/*
 * Decompiled with CFR 0.152.
 */
package config;

import cli.Converter;
import cli.ConverterKt;
import cli.SanityValues;
import config.ConfigRegister;
import config.ConfigTypeKt;
import fuzzer.AssumeHandlingStrategy;
import fuzzer.NonlinearReductionCode;
import fuzzer.PathChoosingStrategyCodes;
import fuzzer.ValueOracleCode;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import log.VersionedFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smt.ConstraintChooserEnum;
import smt.ModelPostProcessingEnum;
import smt.MultipleCounterExamplesEnum;
import smt.axiomgenerators.fullinstantiation.HashingScheme;
import solver.SolverInfoClOptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0015\u001e\u001f !\"#$%&'()*+,-./012B#\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\bJ\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0013\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014R\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\r\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001e\u0010\u0011\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\u0014\u0082\u0001\u00043456\u00a8\u00067"}, d2={"Lconfig/ConfigType;", "T", "Ljava/io/Serializable;", "", "default", "name", "", "postponeRegister", "", "(Ljava/io/Serializable;Ljava/lang/String;Z)V", "getDefault", "()Ljava/io/Serializable;", "Ljava/io/Serializable;", "illegalArgMessage", "getIllegalArgMessage", "()Ljava/lang/String;", "getName", "value", "getValue", "setValue", "(Ljava/io/Serializable;)V", "check", "newValue", "(Ljava/io/Serializable;)Z", "exists", "get", "getOrNull", "register", "", "set", "BigIntCmdLine", "BooleanCmdLine", "CmdLine", "ConstraintChooserCmdLine", "ExecName", "FuzzerAssumeHandlingStrategyCmdLine", "FuzzerNonlinearReductionCmdLine", "FuzzerPathChoosingStrategyCmdLine", "FuzzerValueOracleCmdLine", "HashingSchemeCmdLine", "IntCmdLine", "MainFileName", "ModelPostProcessingCmdLine", "MultipleCounterexamplesCmdLine", "SanityMode", "SolverProgramCmdLine", "StringCmdLine", "StringListCmdLine", "StringSetCmdLine", "VersionedFileCmdLine", "WithArtifacts", "Lconfig/ConfigType$MainFileName;", "Lconfig/ConfigType$WithArtifacts;", "Lconfig/ConfigType$ExecName;", "Lconfig/ConfigType$CmdLine;", "Shared"})
public abstract class ConfigType<T extends Serializable> {
    @Nullable
    private final T default;
    @NotNull
    private final String name;
    @Nullable
    private T value;

    private ConfigType(T t2, String name, boolean postponeRegister) {
        this.default = t2;
        this.name = name;
        this.value = this.default;
        if (!postponeRegister) {
            this.register();
        }
    }

    public /* synthetic */ ConfigType(Serializable serializable, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(serializable, string2, bl, null);
    }

    @Nullable
    public final T getDefault() {
        return this.default;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final T getValue() {
        return this.value;
    }

    public final void setValue(@Nullable T t2) {
        this.value = t2;
    }

    public abstract boolean check(@NotNull T var1);

    @NotNull
    public abstract String getIllegalArgMessage();

    public final void register() {
        ConfigRegister.INSTANCE.register(this);
    }

    public final void set(@NotNull T newValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        if (!this.check(newValue)) {
            throw new IllegalArgumentException(this.getIllegalArgMessage() + ": " + newValue);
        }
        this.value = newValue;
    }

    public final boolean exists() {
        return this.value != null || this.default != null;
    }

    @NotNull
    public T get() {
        if (!this.exists()) {
            throw new AssertionError((Object)("This configuration must be non-null: " + this.name));
        }
        T t2 = this.getOrNull();
        Intrinsics.checkNotNull(t2);
        return t2;
    }

    @Nullable
    public T getOrNull() {
        T t2 = this.value;
        if (t2 == null) {
            t2 = this.default;
        }
        return t2;
    }

    public /* synthetic */ ConfigType(Serializable serializable, String name, boolean postponeRegister, DefaultConstructorMarker $constructor_marker) {
        this(serializable, name, postponeRegister);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$MainFileName;", "Lconfig/ConfigType;", "", "()V", "illegalArgMessage", "getIllegalArgMessage", "()Ljava/lang/String;", "check", "", "newValue", "Shared"})
    public static final class MainFileName
    extends ConfigType<String> {
        @NotNull
        public static final MainFileName INSTANCE = new MainFileName();
        @NotNull
        private static final String illegalArgMessage = "";

        private MainFileName() {
            super(null, "MainFileName", false, 4, null);
        }

        @Override
        public boolean check(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return true;
        }

        @Override
        @NotNull
        public String getIllegalArgMessage() {
            return illegalArgMessage;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$WithArtifacts;", "Lconfig/ConfigType;", "", "()V", "illegalArgMessage", "", "getIllegalArgMessage", "()Ljava/lang/String;", "check", "newValue", "Shared"})
    public static final class WithArtifacts
    extends ConfigType<Boolean> {
        @NotNull
        public static final WithArtifacts INSTANCE = new WithArtifacts();
        @NotNull
        private static final String illegalArgMessage = "";

        private WithArtifacts() {
            super(Boolean.valueOf(false), "WithArtifacts", false, 4, null);
        }

        @Override
        public boolean check(boolean newValue) {
            return true;
        }

        @Override
        @NotNull
        public String getIllegalArgMessage() {
            return illegalArgMessage;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$ExecName;", "Lconfig/ConfigType;", "", "()V", "illegalArgMessage", "getIllegalArgMessage", "()Ljava/lang/String;", "check", "", "newValue", "Shared"})
    public static final class ExecName
    extends ConfigType<String> {
        @NotNull
        public static final ExecName INSTANCE = new ExecName();
        @NotNull
        private static final String illegalArgMessage = "Illegal execution name";

        private ExecName() {
            super(null, "ExecName", true, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean check(@NotNull String newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            if (StringsKt.isBlank(newValue)) return false;
            boolean bl = true;
            if (!bl) return false;
            CharSequence charSequence = newValue;
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue(string2, "separator");
            if (StringsKt.contains$default(charSequence, string2, false, 2, null)) return false;
            return true;
        }

        @Override
        @NotNull
        public String getIllegalArgMessage() {
            return illegalArgMessage;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B5\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lconfig/ConfigType$CmdLine;", "T", "Ljava/io/Serializable;", "Lconfig/ConfigType;", "default", "converter", "Lcli/Converter;", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/io/Serializable;Lcli/Converter;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "getAliases", "()Ljava/util/List;", "allOptions", "getAllOptions", "illegalArgMessage", "", "getIllegalArgMessage", "()Ljava/lang/String;", "getOption", "()Lorg/apache/commons/cli/Option;", "check", "", "newValue", "(Ljava/io/Serializable;)Z", "getMatchedOption", "cmdLine", "Lorg/apache/commons/cli/CommandLine;", "isConfigured", "setFromCLI", "", "Shared"})
    public static class CmdLine<T extends Serializable>
    extends ConfigType<T> {
        @NotNull
        private final Converter<T> converter;
        @NotNull
        private final Option option;
        @NotNull
        private final List<Option> aliases;
        @NotNull
        private final List<Option> allOptions;

        /*
         * WARNING - void declaration
         */
        public CmdLine(@Nullable T t2, @NotNull Converter<T> converter, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(converter, "converter");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)t2, ConfigTypeKt.realOpt(option), true, null);
            this.converter = converter;
            this.option = option;
            this.aliases = aliases;
            Iterable iterable = this.aliases;
            CmdLine cmdLine = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void alias;
                Option option2 = (Option)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Option(ConfigTypeKt.realOpt((Option)alias), alias.hasArg(), alias.getDescription()));
            }
            cmdLine.allOptions = CollectionsKt.plus((Collection)((List)destination$iv$iv), this.option);
            this.register();
        }

        public /* synthetic */ CmdLine(Serializable serializable, Converter converter, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(serializable, converter, option, list2);
        }

        @NotNull
        public final Option getOption() {
            return this.option;
        }

        @NotNull
        public final List<Option> getAliases() {
            return this.aliases;
        }

        @NotNull
        public final List<Option> getAllOptions() {
            return this.allOptions;
        }

        @Override
        public boolean check(@NotNull T newValue) {
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            return true;
        }

        @Override
        @NotNull
        public String getIllegalArgMessage() {
            return "";
        }

        @Nullable
        public final Option getMatchedOption(@NotNull CommandLine cmdLine) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(cmdLine, "cmdLine");
                for (Object t2 : (Iterable)this.allOptions) {
                    Option o = (Option)t2;
                    boolean bl = false;
                    if (!cmdLine.hasOption(ConfigTypeKt.realOpt(o))) continue;
                    v0 = t2;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean isConfigured(@NotNull CommandLine cmdLine) {
            Intrinsics.checkNotNullParameter(cmdLine, "cmdLine");
            return this.getMatchedOption(cmdLine) != null;
        }

        public final void setFromCLI(@NotNull CommandLine cmdLine) {
            Intrinsics.checkNotNullParameter(cmdLine, "cmdLine");
            Option matchedOption = this.getMatchedOption(cmdLine);
            if (matchedOption != null) {
                if (!matchedOption.hasArg()) {
                    if (!(this.getDefault() instanceof Boolean)) {
                        boolean $i$a$-check-ConfigType$CmdLine$setFromCLI$22 = false;
                        String $i$a$-check-ConfigType$CmdLine$setFromCLI$22 = "Option " + ConfigTypeKt.realOpt(matchedOption) + " without an argument can only be a boolean flag";
                        throw new IllegalStateException($i$a$-check-ConfigType$CmdLine$setFromCLI$22.toString());
                    }
                    Boolean $this$uncheckedAs$iv = true;
                    boolean $i$f$uncheckedAs = false;
                    this.set((Serializable)$this$uncheckedAs$iv);
                } else {
                    String rawValue = cmdLine.getOptionValue(ConfigTypeKt.realOpt(matchedOption));
                    Function1<String, T> function1 = this.converter.getConvert();
                    Intrinsics.checkNotNullExpressionValue(rawValue, "rawValue");
                    Serializable convertedValue = (Serializable)function1.invoke(rawValue);
                    this.set(convertedValue);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$BooleanCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/Boolean;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class BooleanCmdLine
    extends CmdLine<Boolean> {
        public BooleanCmdLine(@Nullable Boolean bl, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)bl, ConverterKt.getBooleanConverter(), option, aliases);
        }

        public /* synthetic */ BooleanCmdLine(Boolean bl, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(bl, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$IntCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/Integer;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class IntCmdLine
    extends CmdLine<Integer> {
        public IntCmdLine(@Nullable Integer n, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)n, ConverterKt.getIntConverter(), option, aliases);
        }

        public /* synthetic */ IntCmdLine(Integer n, Option option, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(n, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$BigIntCmdLine;", "Lconfig/ConfigType$CmdLine;", "Ljava/math/BigInteger;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/math/BigInteger;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class BigIntCmdLine
    extends CmdLine<BigInteger> {
        public BigIntCmdLine(@Nullable BigInteger bigInteger, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)bigInteger, ConverterKt.getBigIntConverter(), option, aliases);
        }

        public /* synthetic */ BigIntCmdLine(BigInteger bigInteger, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(bigInteger, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$StringCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/String;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class StringCmdLine
    extends CmdLine<String> {
        public StringCmdLine(@Nullable String string2, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)string2), ConverterKt.getStringConverter(), option, aliases);
        }

        public /* synthetic */ StringCmdLine(String string2, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(string2, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$StringListCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "([Ljava/lang/String;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class StringListCmdLine
    extends CmdLine<String[]> {
        public StringListCmdLine(@NotNull String[] stringArray, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(stringArray, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)stringArray, ConverterKt.getStringListConverter(), option, aliases);
        }

        public /* synthetic */ StringListCmdLine(String[] stringArray, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(stringArray, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u00040\u0001B9\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002j\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lconfig/ConfigType$StringSetCmdLine;", "Lconfig/ConfigType$CmdLine;", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/util/HashSet;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class StringSetCmdLine
    extends CmdLine<HashSet<String>> {
        public StringSetCmdLine(@Nullable HashSet<String> hashSet, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)hashSet, ConverterKt.getStringSetConverter(), option, aliases);
        }

        public /* synthetic */ StringSetCmdLine(HashSet hashSet, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(hashSet, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B+\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$SolverProgramCmdLine;", "Lconfig/ConfigType$CmdLine;", "", "Lsolver/SolverInfoClOptions;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "([Lsolver/SolverInfoClOptions;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class SolverProgramCmdLine
    extends CmdLine<SolverInfoClOptions[]> {
        public SolverProgramCmdLine(@NotNull SolverInfoClOptions[] solverInfoClOptionsArray, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(solverInfoClOptionsArray, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)solverInfoClOptionsArray, ConverterKt.getSolverProgramListConverter(), option, aliases);
        }

        public /* synthetic */ SolverProgramCmdLine(SolverInfoClOptions[] solverInfoClOptionsArray, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(solverInfoClOptionsArray, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$HashingSchemeCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/axiomgenerators/fullinstantiation/HashingScheme;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/axiomgenerators/fullinstantiation/HashingScheme;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class HashingSchemeCmdLine
    extends CmdLine<HashingScheme> {
        public HashingSchemeCmdLine(@Nullable HashingScheme hashingScheme, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)hashingScheme, ConverterKt.getHashingSchemeConverter(), option, aliases);
        }

        public /* synthetic */ HashingSchemeCmdLine(HashingScheme hashingScheme, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(hashingScheme, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$ConstraintChooserCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/ConstraintChooserEnum;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/ConstraintChooserEnum;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class ConstraintChooserCmdLine
    extends CmdLine<ConstraintChooserEnum> {
        public ConstraintChooserCmdLine(@NotNull ConstraintChooserEnum constraintChooserEnum, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)constraintChooserEnum, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)constraintChooserEnum), ConverterKt.getConstraintChooserConverter(), option, aliases);
        }

        public /* synthetic */ ConstraintChooserCmdLine(ConstraintChooserEnum constraintChooserEnum, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(constraintChooserEnum, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$ModelPostProcessingCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/ModelPostProcessingEnum;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/ModelPostProcessingEnum;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class ModelPostProcessingCmdLine
    extends CmdLine<ModelPostProcessingEnum> {
        public ModelPostProcessingCmdLine(@NotNull ModelPostProcessingEnum modelPostProcessingEnum, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)modelPostProcessingEnum, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)modelPostProcessingEnum), ConverterKt.getModelPostProcessingConverter(), option, aliases);
        }

        public /* synthetic */ ModelPostProcessingCmdLine(ModelPostProcessingEnum modelPostProcessingEnum, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(modelPostProcessingEnum, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$MultipleCounterexamplesCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lsmt/MultipleCounterExamplesEnum;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lsmt/MultipleCounterExamplesEnum;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class MultipleCounterexamplesCmdLine
    extends CmdLine<MultipleCounterExamplesEnum> {
        public MultipleCounterexamplesCmdLine(@NotNull MultipleCounterExamplesEnum multipleCounterExamplesEnum, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)multipleCounterExamplesEnum, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)multipleCounterExamplesEnum), ConverterKt.getMultipleCounterexamplesConverter(), option, aliases);
        }

        public /* synthetic */ MultipleCounterexamplesCmdLine(MultipleCounterExamplesEnum multipleCounterExamplesEnum, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(multipleCounterExamplesEnum, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$SanityMode;", "Lconfig/ConfigType$CmdLine;", "Lcli/SanityValues;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lcli/SanityValues;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class SanityMode
    extends CmdLine<SanityValues> {
        public SanityMode(@NotNull SanityValues sanityValues, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)sanityValues, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)sanityValues), ConverterKt.getSanityModeConverter(), option, aliases);
        }

        public /* synthetic */ SanityMode(SanityValues sanityValues, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(sanityValues, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lconfig/ConfigType$VersionedFileCmdLine;", "Lconfig/ConfigType$CmdLine;", "Llog/VersionedFile;", "default", "", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Ljava/lang/String;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class VersionedFileCmdLine
    extends CmdLine<VersionedFile> {
        public VersionedFileCmdLine(@NotNull String string2, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(string2, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)new VersionedFile(string2), new Converter(1.INSTANCE), option, aliases);
        }

        public /* synthetic */ VersionedFileCmdLine(String string2, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(string2, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$FuzzerValueOracleCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lfuzzer/ValueOracleCode;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lfuzzer/ValueOracleCode;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class FuzzerValueOracleCmdLine
    extends CmdLine<ValueOracleCode> {
        public FuzzerValueOracleCmdLine(@Nullable ValueOracleCode valueOracleCode, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)valueOracleCode), ConverterKt.getValueOracleCodeConverter(), option, aliases);
        }

        public /* synthetic */ FuzzerValueOracleCmdLine(ValueOracleCode valueOracleCode, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(valueOracleCode, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$FuzzerNonlinearReductionCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lfuzzer/NonlinearReductionCode;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lfuzzer/NonlinearReductionCode;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class FuzzerNonlinearReductionCmdLine
    extends CmdLine<NonlinearReductionCode> {
        public FuzzerNonlinearReductionCmdLine(@Nullable NonlinearReductionCode nonlinearReductionCode, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)nonlinearReductionCode), ConverterKt.getNonLinearReductionCodeConverter(), option, aliases);
        }

        public /* synthetic */ FuzzerNonlinearReductionCmdLine(NonlinearReductionCode nonlinearReductionCode, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(nonlinearReductionCode, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$FuzzerAssumeHandlingStrategyCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lfuzzer/AssumeHandlingStrategy;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lfuzzer/AssumeHandlingStrategy;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class FuzzerAssumeHandlingStrategyCmdLine
    extends CmdLine<AssumeHandlingStrategy> {
        public FuzzerAssumeHandlingStrategyCmdLine(@Nullable AssumeHandlingStrategy assumeHandlingStrategy, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)assumeHandlingStrategy), ConverterKt.getAssumeHandlingStrategyConverter(), option, aliases);
        }

        public /* synthetic */ FuzzerAssumeHandlingStrategyCmdLine(AssumeHandlingStrategy assumeHandlingStrategy, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(assumeHandlingStrategy, option, list2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lconfig/ConfigType$FuzzerPathChoosingStrategyCmdLine;", "Lconfig/ConfigType$CmdLine;", "Lfuzzer/PathChoosingStrategyCodes;", "default", "option", "Lorg/apache/commons/cli/Option;", "aliases", "", "(Lfuzzer/PathChoosingStrategyCodes;Lorg/apache/commons/cli/Option;Ljava/util/List;)V", "Shared"})
    public static class FuzzerPathChoosingStrategyCmdLine
    extends CmdLine<PathChoosingStrategyCodes> {
        public FuzzerPathChoosingStrategyCmdLine(@NotNull PathChoosingStrategyCodes pathChoosingStrategyCodes, @NotNull Option option, @NotNull List<? extends Option> aliases) {
            Intrinsics.checkNotNullParameter((Object)pathChoosingStrategyCodes, "default");
            Intrinsics.checkNotNullParameter(option, "option");
            Intrinsics.checkNotNullParameter(aliases, "aliases");
            super((Serializable)((Object)pathChoosingStrategyCodes), ConverterKt.getPathChoosingStrategyConverter(), option, aliases);
        }

        public /* synthetic */ FuzzerPathChoosingStrategyCmdLine(PathChoosingStrategyCodes pathChoosingStrategyCodes, Option option, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(pathChoosingStrategyCodes, option, list2);
        }
    }
}

