/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.ERelop;
import com.certora.evmverifier.cvl.Exp;
import java.util.Arrays;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLExpTag;

public class RelopExp
extends Exp {
    public ERelop relop;
    public Exp l;
    public Exp r;

    public RelopExp(String _relop, Exp _l, Exp _r) {
        ERelop erelop = ERelop.fromString(_relop);
        if (!Arrays.asList(ERelop.values()).contains((Object)erelop)) {
            throw new RuntimeException("Illegal relop " + _relop);
        }
        this.relop = erelop;
        this.l = _l;
        this.r = _r;
    }

    public RelopExp(ERelop _relop, Exp _l, Exp _r) {
        this.relop = _relop;
        this.l = _l;
        this.r = _r;
    }

    public String toString() {
        return String.format(this.relop.toString(), this.l.toString(), this.r.toString());
    }

    @Override
    public CVLExp kotlinize() {
        switch (this.relop) {
            case LT: {
                return new CVLExp.RelopExp.ArithRelopExp.LtExp((CVLExp)this.l.kotlinize(), (CVLExp)this.r.kotlinize(), CVLExpTag.Companion.getEmptyTag());
            }
            case LE: {
                return new CVLExp.RelopExp.ArithRelopExp.LeExp((CVLExp)this.l.kotlinize(), (CVLExp)this.r.kotlinize(), CVLExpTag.Companion.getEmptyTag());
            }
            case GT: {
                return new CVLExp.RelopExp.ArithRelopExp.GtExp((CVLExp)this.l.kotlinize(), (CVLExp)this.r.kotlinize(), CVLExpTag.Companion.getEmptyTag());
            }
            case GE: {
                return new CVLExp.RelopExp.ArithRelopExp.GeExp((CVLExp)this.l.kotlinize(), (CVLExp)this.r.kotlinize(), CVLExpTag.Companion.getEmptyTag());
            }
            case EQ: {
                return new CVLExp.RelopExp.EqExp((CVLExp)this.l.kotlinize(), (CVLExp)this.r.kotlinize(), CVLExpTag.Companion.getEmptyTag());
            }
            case NE: {
                return new CVLExp.RelopExp.NeExp((CVLExp)this.l.kotlinize(), (CVLExp)this.r.kotlinize(), CVLExpTag.Companion.getEmptyTag());
            }
        }
        throw new AssertionError((Object)"unrecognized relop -- implement missing case?");
    }
}

