/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.NamedParam;
import com.certora.evmverifier.cvl.Param;
import com.certora.evmverifier.cvl.SlotPattern;
import java_cup.runtime.ComplexSymbolFactory;
import kotlinizable.Kotlinizable;
import spec.cvlast.CVLHookPattern;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLSlotPattern;

public class HookPattern
implements Kotlinizable<CVLHookPattern> {
    private final HookType hookType;
    private final NamedParam value;
    private final NamedParam oldValue;
    private final SlotPattern slot;
    private final Base base;

    HookPattern(String _specFile, ComplexSymbolFactory.Location _loc, HookType _hookType, Param _value, SlotPattern _slot, Base _base) {
        this.hookType = _hookType;
        this.value = NamedParam.paramToNamedParam(_specFile, _loc, _value);
        this.oldValue = null;
        this.slot = _slot;
        this.base = _base;
    }

    HookPattern(String _specFile, ComplexSymbolFactory.Location _loc, HookType _hookType, Param _value, Param _oldValue, SlotPattern _slot, Base _base) {
        this.hookType = _hookType;
        this.value = NamedParam.paramToNamedParam(_specFile, _loc, _value);
        this.oldValue = NamedParam.paramToNamedParam(_specFile, _loc, _oldValue);
        this.slot = _slot;
        this.base = _base;
    }

    HookPattern(String _specFile, ComplexSymbolFactory.Location _loc, HookType _hookType, Param _value) {
        this.hookType = _hookType;
        this.value = NamedParam.paramToNamedParam(_specFile, _loc, _value);
        this.oldValue = null;
        this.slot = null;
        this.base = Base.NONE;
    }

    @Override
    public CVLHookPattern kotlinize() {
        if (this.hookType == HookType.SLOAD) {
            return new CVLHookPattern.StoragePattern.Load(this.value.kotlinize(), (CVLSlotPattern)this.slot.kotlinize(), this.base());
        }
        if (this.hookType == HookType.SSTORE) {
            CVLParam.Named kotlinizedOldValue = this.oldValue == null ? null : this.oldValue.kotlinize();
            return new CVLHookPattern.StoragePattern.Store(this.value.kotlinize(), (CVLSlotPattern)this.slot.kotlinize(), this.base(), kotlinizedOldValue);
        }
        if (this.hookType == HookType.CREATE) {
            return new CVLHookPattern.Create(this.value.kotlinize());
        }
        throw new RuntimeException("Unrecognized hook pattern");
    }

    private CVLHookPattern.StoragePattern.Base base() {
        return CVLHookPattern.StoragePattern.Base.STORAGE;
    }

    static enum Base {
        NONE,
        STORAGE;

    }

    static enum HookType {
        SLOAD,
        SSTORE,
        CREATE;

    }
}

