/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import bridge.ReproJson;
import bridge.ReproJsonParser;
import java.io.Closeable;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import log.Logger;
import log.LoggerTypes;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u001d\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lbridge/ReproJsonParser;", "", "()V", "logger", "Llog/Logger;", "getJsonElementFromReproJson", "Lkotlinx/serialization/json/JsonElement;", "jsonStr", "", "elemStr", "parseFromFile", "Lbridge/ReproJson;", "reproFileName", "parseReproSettings", "", "certoraMetaDataElem", "(Lkotlinx/serialization/json/JsonElement;)[Ljava/lang/String;", "ReproParserException", "Shared"})
public final class ReproJsonParser {
    @NotNull
    public static final ReproJsonParser INSTANCE = new ReproJsonParser();
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.RUN_REPRO);

    private ReproJsonParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ReproJson parseFromFile(@NotNull String reproFileName) {
        Intrinsics.checkNotNullParameter(reproFileName, "reproFileName");
        if (!FileUtils.fileExists(reproFileName)) {
            throw new ReproParserException("run-repro file " + reproFileName + " was specified in cmd line but does not exist");
        }
        Closeable closeable = new FileReader(reproFileName);
        Throwable throwable = null;
        try {
            Object it = (FileReader)closeable;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Object reproJsonStr = it;
        JsonElement certoraMetaDataElem = this.getJsonElementFromReproJson((String)reproJsonStr, "certoraMetaData");
        JsonElement certoraBuildElem = this.getJsonElementFromReproJson((String)reproJsonStr, "certoraBuild");
        JsonElement certoraVerifyElem = this.getJsonElementFromReproJson((String)reproJsonStr, "certoraVerify");
        JsonElement certoraConfigElem = this.getJsonElementFromReproJson((String)reproJsonStr, "certoraConfig");
        if (certoraBuildElem == null || certoraVerifyElem == null || certoraConfigElem == null) {
            throw new ReproParserException("run-repro file " + reproFileName + " contained unparsable element");
        }
        return new ReproJson(certoraMetaDataElem, certoraBuildElem, certoraVerifyElem, certoraConfigElem);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String[] parseReproSettings(@Nullable JsonElement certoraMetaDataElem) {
        try {
            void $this$flatMapTo$iv$iv;
            JsonArray jsonArray;
            JsonElement jsonElement = certoraMetaDataElem;
            if (jsonElement == null) {
                jsonArray = null;
            } else {
                JsonObject jsonObject = JsonElementKt.getJsonObject(jsonElement);
                if (jsonObject == null) {
                    jsonArray = null;
                } else {
                    JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)"args");
                    if (jsonElement2 == null) {
                        jsonArray = null;
                    } else {
                        JsonObject jsonObject2 = JsonElementKt.getJsonObject(jsonElement2);
                        if (jsonObject2 == null) {
                            jsonArray = null;
                        } else {
                            JsonElement jsonElement3 = (JsonElement)jsonObject2.get((Object)"settings");
                            jsonArray = jsonElement3 == null ? null : JsonElementKt.getJsonArray(jsonElement3);
                        }
                    }
                }
            }
            if (jsonArray == null) {
                return null;
            }
            JsonArray settings = jsonArray;
            Iterable $this$flatMap$iv = (Iterable)JsonKt.Json$default(null, parseReproSettings.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.ListSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE)), settings.toString());
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return stringArray;
        }
        catch (Exception e) {
            logger.warn(e, parseReproSettings.3.INSTANCE);
            return null;
        }
    }

    private final JsonElement getJsonElementFromReproJson(String jsonStr, String elemStr) {
        try {
            JsonElement jsonElement;
            JsonElement reproduction;
            JsonObject jsonObj = JsonElementKt.getJsonObject(Json.Default.parseToJsonElement(jsonStr));
            JsonElement jsonElement2 = reproduction = (JsonElement)jsonObj.get((Object)"reproduction");
            if (jsonElement2 == null) {
                jsonElement = null;
            } else {
                JsonObject jsonObject = JsonElementKt.getJsonObject(jsonElement2);
                jsonElement = jsonObject == null ? null : (JsonElement)jsonObject.get((Object)elemStr);
            }
            return jsonElement;
        }
        catch (Exception e) {
            String errMsg = "ReproJsonParser could not parse json element " + elemStr;
            logger.error((Throwable)e, (Function0<? extends Object>)new Function0<Object>(errMsg){
                final /* synthetic */ String $errMsg;
                {
                    this.$errMsg = $errMsg;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$errMsg;
                }
            });
            throw new ReproParserException(errMsg);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lbridge/ReproJsonParser$ReproParserException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errMsg", "", "(Ljava/lang/String;)V", "Shared"})
    public static final class ReproParserException
    extends Exception {
        public ReproParserException(@NotNull String errMsg) {
            Intrinsics.checkNotNullParameter(errMsg, "errMsg");
            super(errMsg);
        }
    }
}

