"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImageScanNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const target = require("aws-cdk-lib/aws-events-targets");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
class EcrImageScanNotify extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new lambda.Function(this, 'Function', {
            handler: 'lambda_function.lambda_handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: lambda.Runtime.PYTHON_3_9,
            timeout: cdk.Duration.minutes(3),
            environment: {
                WEBHOOK_URL: props.webhookUrl,
            },
        });
        const ecrScanTarget = new target.LambdaFunction(handler);
        new events.Rule(this, 'EventBusEcrImageScan', {
            ruleName: 'EventBusEcrImageScanRule',
            description: 'Send ECR Image Scan findings severity counts to slack',
            targets: [ecrScanTarget],
            eventPattern: {
                source: [
                    'aws.ecr',
                    'aws.inspector2',
                ],
                detailType: [
                    'ECR Image Scan',
                    'Inspector2 Scan',
                ],
            },
        });
    }
}
exports.EcrImageScanNotify = EcrImageScanNotify;
_a = JSII_RTTI_SYMBOL_1;
EcrImageScanNotify[_a] = { fqn: "cdk-ecr-image-scan-notify.EcrImageScanNotify", version: "1.0.75" };
//# sourceMappingURL=data:application/json;base64,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