# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['semantha_sdk',
 'semantha_sdk.api',
 'semantha_sdk.model',
 'semantha_sdk.model.schema',
 'semantha_sdk.request',
 'semantha_sdk.response',
 'semantha_sdk.rest']

package_data = \
{'': ['*']}

install_requires = \
['marshmallow==3.19.0', 'requests==2.28.2']

setup_kwargs = {
    'name': 'semantha-sdk',
    'version': '4.5.2',
    'description': 'This is a python client sdk for accessing semantha (the semantic platform)',
    'long_description': '![](https://www.semantha.de/wp-content/uploads/semantha-inverted.svg)\n\n# semantha® SDK\n\nThe semantha SDK is a high-level REST client to access the [semantha](http://semantha.ai) API.\nThe SDK is still under development.\nAn overview of the current progress (i.e. implemented and tested resources and endpoints) may be found at the end of\nthis document (State of Development).\nThe semantha SDK is compatible with python >= 3.8.\n\n### Disclaimer\n\n**IMPORTANT:** The SDK is under development and interfaces may change at any time without notice.\nUse with caution and on own risk.\n\n### Update Note\n\nVersion 4.5.0 comes with a major restructuring of the SDK.\nAll sub-resources are directly accessible (instead of invoking getters).\nThat also means that (except for a few) all functions are plain get/post/delete/put/patch.\nFor example, in Versions < 4.5.0 a domain resource was fetched using `semantha_sdk.domains.get_one("domain_name")`.\nStarting with 4.5.0 it is `semantha_sdk.domains("domain_name")`.\nThat also means that get/post/put/patch functions return semantha model objects (and never resources), which makes usage more consistent.\n\n### Access\n\nTo access semantha\'s API you will need an API and a server url.\nBoth can be requested via [this contact form](https://www.semantha.de/request/).\n\n### Basic Usage\n\n#### Import\n\n```\nimport semantha_sdk\n```\n\n#### Authentication\n\n```\nsemantha = semantha_sdk.login(url="<semantha platform server URL>", key="<your key>")\n# or\nsemantha = semantha_sdk.login(url="<semantha platform server URL>", key_file="<path to your key file (json format)>")\n```\n\n#### End-point (Resource) Access\n\n```\n# end-points (resp. resources) can be used like objects\ncurrent_user = semantha.current_user\nmy_domain = semantha.domains("my_domain")\n\n# they may have sub-resources, which can be retrieved as objects as well\nreference_documents = my_domain.reference_documents\n```\n\n#### CRUD on End-points\n\n```\n# CRUD operations are functions\ndomain_settings = my_domain.settings.get()\nmy_domain.reference_documents.delete() (deletes ALL reference document/library entries)\n```\n\n#### Function Return Types & semantha Data Model\n\n```\n# some functions only return None, e.g.\nmy_domain.reference_documents.delete() # returns NoneType\n\n# others return built in types, e.g\nroles_list = current_user.roles.get() # returns list[str]\n\n# but most return objects of the semantha Data Model\n# (all returned objects are instances of frozen dataclasses)\nsettings = my_domain.settings.get() # returns instance of DomainSettings\n# attributes can be accessed as properties, e.g.\nsettings.enable_tagging # returns true or false\n# Data Model objects may be complex\ndocument = my_domain.references.post(file=a, reference_document=b) # returns instance of Document\n# the following returns the similarity value of the first references of the first sentence of the\n# the first paragraph on the first page of the document (if a reference was found for this sentence)\nsimilarity = pages[0].contents[0].paragraphs[0].references[0].similarity # returns float\n```\n\n### State of Development\n\nThe following resources and end-points are fully functional and (partially) tested:\n\n- [X] login -> API\n    - [X] .current_user -> CurrentUser\n        - [X] get -> UserData(SemanthaModelEntity)\n        - [X] roles -> CurrentUserRoles\n          - [x] get -> list[str]\n    - [X] .diff -> Diff\n        - [X] post -> list[Diff(SemanthaModelEntity)]\n    - [X] .domains -> Domains\n        - [X] get -> list[Domain(SemanthaModelEntity)]\n    - [X] .domains("domain_name") -> Domain\n        - [X] .document_annotations -> DocumentAnnotations\n            - [ ] post -> not yet implemented\n        - [X] .document_classes -> DocumentClasses\n            - [X] get -> list[DocumentClass(SemanthaModelEntity)]\n            - [X] post -> DocumentClass(SemanthaModelEntity)\n            - [X] delete -> None\n        - [X] .document_classes("id") -> DocumentClass\n            - [X] get -> DocumentClass(SemanthaModelEntity)\n            - [X] delete -> None\n            - [X] put -> DocumentClass(SemanthaModelEntity)\n            - [x] document_classes -> InnerDocumentClasses\n                - [x] get -> list[DocumentClass(SemanthaModelEntity)]\n                - [x] post -> DocumentClass(SemanthaModelEntity)\n            - [x] reference_documents -> InnerReferenceDocuments\n                - [x] get -> list[Document(SemanthaModelEntity)]\n                - [x] patch -> None\n                - [x] delete -> None\n        - [X] .document_comparisons -> DocumentComparisons\n            - [ ] post -> not yet implemented\n          - [X] .documents -> Documents\n              - [X] post -> list[Document(SemanthaModelEntity)]\n          - [X] .reference_documents -> ReferenceDocuments\n              - [X] get -> ReferenceDocuments(SemanthaModelEntity)\n              - [X] delete -> None\n              - [X] post -> list[DocumentInformation(SemanthaModelEntity)]\n              - [x] .clusters -> DocumentCluster\n                - [x] get -> DocumentCluster(SemanthaModelEntity)\n              - [x] .statistic -> Statistics\n                - [x] get -> Statistic(SemanthaModelEntity)\n              - [x] .named_entities -> NamedEntities\n                - [x] get -> Optional[NamedEntities(SemanthaModelEntity)]\n        - [x] .reference_documents("id") -> ReferenceDocument\n            - [X] get -> Document(SemanthaModelEntity)\n            - [X] delete -> None\n            - [X] patch -> DocumentInformation(SemanthaModelEntity)\n            - [X] .paragraphs("id") -> ReferenceDocumentParagraph\n                - [X] get -> Paragraph(SemanthaModelEntity)\n                - [X] patch -> Paragraph(SemanthaModelEntity)\n                - [X] delete -> None\n            - [X] .sentences("id") -> ReferenceDocumentSentence\n                - [x] get -> Sentence(SemanthaModelEntity)\n        - [X] .references -> References\n            - [X] post -> Document(SemanthaModelEntity)\n        - [x] .settings -> DomainSettings\n            - [X] get -> DomainSettings(SemanthaModelEntity)\n            - [X] patch -> DomainSettings(SemanthaModelEntity)\n        - [ ] .tags -> DomainTags\n            - [X] get -> list[str]\n    - [ ] .model\n      - [x] .domains("domain_name")\n        - [x] .boostwords -> Boostwords\n            - [x] get -> list[Boostword(SemanthaModelEntity)]\n            - [X] delete -> None\n            - [X] post_word -> Boostword(SemanthaModelEntity)\n            - [X] post_regex -> Boostword(SemanthaModelEntity)\n        - [x] .boostwords("id") -> Boostword\n            - [X] get -> Boostword(SemanthaModelEntity)\n            - [X] delete -> None\n            - [X] put_word -> Boostword(SemanthaModelEntity)\n            - [X] put_regex -> Boostword(SemanthaModelEntity)\n        - [x] .synonyms -> Synonyms\n            - [X] get -> list[Synonym(SemanthaModelEntity)]\n            - [X] delete -> None\n            - [X] post_word -> Synonym(SemanthaModelEntity)\n            - [X] post_regex -> Synonym(SemanthaModelEntity)\n        - [x] .synonyms("id") -> Synonym\n            - [X] get -> Synonym(SemanthaModelEntity)\n            - [X] delete -> None\n            - [X] put_word -> Synonym(SemanthaModelEntity)\n            - [X] put_regex -> Synonym(SemanthaModelEntity)\n',
    'author': 'Sebastian Weigelt',
    'author_email': 'sebastian.weigelt@semantha.de',
    'maintainer': 'semantha support',
    'maintainer_email': 'support@semantha.de',
    'url': 'https://semantha.de',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
