/*
 * # Fomantic UI - 2.8.8
 * https://github.com/fomantic/Fomantic-UI
 * http://fomantic-ui.com/
 *
 * Copyright 2022 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(I,E,S,O){"use strict";I.isFunction=I.isFunction||function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},E=void 0!==E&&E.Math==Math?E:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),I.fn.checkbox=function(s){var u,e=I(this),b=e.selector||"",y=(new Date).getTime(),C=[],x=s,w="string"==typeof x,D=[].slice.call(arguments,1);return e.each(function(){var e,h,g=I.extend(!0,{},I.fn.checkbox.settings,s),n=g.className,t=g.namespace,p=g.selector,r=g.error,i="."+t,o="module-"+t,f=I(this),a=I(this).children(p.label),k=I(this).children(p.input),m=k[0],c=!1,v=!1,l=f.data(o),d=this;h={initialize:function(){h.verbose("Initializing checkbox",g),h.create.label(),h.bind.events(),h.set.tabbable(),h.hide.input(),h.observeChanges(),h.instantiate(),h.setup()},instantiate:function(){h.verbose("Storing instance of module",h),l=h,f.data(o,h)},destroy:function(){h.verbose("Destroying module"),h.unbind.events(),h.show.input(),f.removeData(o)},fix:{reference:function(){f.is(p.input)&&(h.debug("Behavior called on <input> adjusting invoked element"),f=f.closest(p.checkbox),h.refresh())}},setup:function(){h.set.initialLoad(),h.is.indeterminate()?(h.debug("Initial value is indeterminate"),h.indeterminate()):h.is.checked()?(h.debug("Initial value is checked"),h.check()):(h.debug("Initial value is unchecked"),h.uncheck()),h.remove.initialLoad()},refresh:function(){a=f.children(p.label),k=f.children(p.input),m=k[0]},hide:{input:function(){h.verbose("Modifying <input> z-index to be unselectable"),k.addClass(n.hidden)}},show:{input:function(){h.verbose("Modifying <input> z-index to be selectable"),k.removeClass(n.hidden)}},observeChanges:function(){"MutationObserver"in E&&((e=new MutationObserver(function(e){h.debug("DOM tree modified, updating selector cache"),h.refresh()})).observe(d,{childList:!0,subtree:!0}),h.debug("Setting up mutation observer",e))},attachEvents:function(e,n){var t=I(e);n=I.isFunction(h[n])?h[n]:h.toggle,0<t.length?(h.debug("Attaching checkbox events to element",e,n),t.on("click"+i,n)):h.error(r.notFound)},preventDefaultOnInputTarget:function(){"undefined"!=typeof event&&null!==event&&I(event.target).is(p.input)&&(h.verbose("Preventing default check action after manual check action"),event.preventDefault())},event:{change:function(e){h.should.ignoreCallbacks()||g.onChange.call(m)},click:function(e){var n=I(e.target);n.is(p.input)?h.verbose("Using default check action on initialized checkbox"):n.is(p.link)?h.debug("Clicking link inside checkbox, skipping toggle"):(h.toggle(),k.focus(),e.preventDefault())},keydown:function(e){var n=e.which,t=13,i=32,o=27,a=37,c=38,r=39,l=40,d=h.get.radios(),s=d.index(f),u=d.length,b=!1;if(n==a||n==c?b=(0===s?u:s)-1:n!=r&&n!=l||(b=s===u-1?0:s+1),!h.should.ignoreCallbacks()&&!1!==b){if(!1===g.beforeUnchecked.apply(m))return h.verbose("Option not allowed to be unchecked, cancelling key navigation"),!1;if(!1===g.beforeChecked.apply(I(d[b]).children(p.input)[0]))return h.verbose("Next option should not allow check, cancelling key navigation"),!1}v=n==o?(h.verbose("Escape key pressed blurring field"),k.blur(),!0):!(e.ctrlKey||!(n==i||n==t&&g.enableEnterKey))&&(h.verbose("Enter/space key pressed, toggling checkbox"),h.toggle(),!0)},keyup:function(e){v&&e.preventDefault()}},check:function(){h.should.allowCheck()&&(h.debug("Checking checkbox",k),h.set.checked(),h.should.ignoreCallbacks()||(g.onChecked.call(m),h.trigger.change()),h.preventDefaultOnInputTarget())},uncheck:function(){h.should.allowUncheck()&&(h.debug("Unchecking checkbox"),h.set.unchecked(),h.should.ignoreCallbacks()||(g.onUnchecked.call(m),h.trigger.change()),h.preventDefaultOnInputTarget())},indeterminate:function(){h.should.allowIndeterminate()?h.debug("Checkbox is already indeterminate"):(h.debug("Making checkbox indeterminate"),h.set.indeterminate(),h.should.ignoreCallbacks()||(g.onIndeterminate.call(m),h.trigger.change()))},determinate:function(){h.should.allowDeterminate()?h.debug("Checkbox is already determinate"):(h.debug("Making checkbox determinate"),h.set.determinate(),h.should.ignoreCallbacks()||(g.onDeterminate.call(m),h.trigger.change()))},enable:function(){h.is.enabled()?h.debug("Checkbox is already enabled"):(h.debug("Enabling checkbox"),h.set.enabled(),h.should.ignoreCallbacks()||(g.onEnable.call(m),g.onEnabled.call(m),h.trigger.change()))},disable:function(){h.is.disabled()?h.debug("Checkbox is already disabled"):(h.debug("Disabling checkbox"),h.set.disabled(),h.should.ignoreCallbacks()||(g.onDisable.call(m),g.onDisabled.call(m),h.trigger.change()))},get:{radios:function(){var e=h.get.name();return I('input[name="'+e+'"]').closest(p.checkbox)},otherRadios:function(){return h.get.radios().not(f)},name:function(){return k.attr("name")}},is:{initialLoad:function(){return c},radio:function(){return k.hasClass(n.radio)||"radio"==k.attr("type")},indeterminate:function(){return k.prop("indeterminate")!==O&&k.prop("indeterminate")},checked:function(){return k.prop("checked")!==O&&k.prop("checked")},disabled:function(){return k.prop("disabled")!==O&&k.prop("disabled")},enabled:function(){return!h.is.disabled()},determinate:function(){return!h.is.indeterminate()},unchecked:function(){return!h.is.checked()}},should:{allowCheck:function(){return h.is.determinate()&&h.is.checked()&&!h.is.initialLoad()?(h.debug("Should not allow check, checkbox is already checked"),!1):!(!h.should.ignoreCallbacks()&&!1===g.beforeChecked.apply(m))||(h.debug("Should not allow check, beforeChecked cancelled"),!1)},allowUncheck:function(){return h.is.determinate()&&h.is.unchecked()&&!h.is.initialLoad()?(h.debug("Should not allow uncheck, checkbox is already unchecked"),!1):!(!h.should.ignoreCallbacks()&&!1===g.beforeUnchecked.apply(m))||(h.debug("Should not allow uncheck, beforeUnchecked cancelled"),!1)},allowIndeterminate:function(){return h.is.indeterminate()&&!h.is.initialLoad()?(h.debug("Should not allow indeterminate, checkbox is already indeterminate"),!1):!(!h.should.ignoreCallbacks()&&!1===g.beforeIndeterminate.apply(m))||(h.debug("Should not allow indeterminate, beforeIndeterminate cancelled"),!1)},allowDeterminate:function(){return h.is.determinate()&&!h.is.initialLoad()?(h.debug("Should not allow determinate, checkbox is already determinate"),!1):!(!h.should.ignoreCallbacks()&&!1===g.beforeDeterminate.apply(m))||(h.debug("Should not allow determinate, beforeDeterminate cancelled"),!1)},ignoreCallbacks:function(){return c&&!g.fireOnInit}},can:{change:function(){return!(f.hasClass(n.disabled)||f.hasClass(n.readOnly)||k.prop("disabled")||k.prop("readonly"))},uncheck:function(){return"boolean"==typeof g.uncheckable?g.uncheckable:!h.is.radio()}},set:{initialLoad:function(){c=!0},checked:function(){h.verbose("Setting class to checked"),f.removeClass(n.indeterminate).addClass(n.checked),h.is.radio()&&h.uncheckOthers(),h.is.indeterminate()||!h.is.checked()?(h.verbose("Setting state to checked",m),k.prop("indeterminate",!1).prop("checked",!0)):h.debug("Input is already checked, skipping input property change")},unchecked:function(){h.verbose("Removing checked class"),f.removeClass(n.indeterminate).removeClass(n.checked),h.is.indeterminate()||!h.is.unchecked()?(h.debug("Setting state to unchecked"),k.prop("indeterminate",!1).prop("checked",!1)):h.debug("Input is already unchecked")},indeterminate:function(){h.verbose("Setting class to indeterminate"),f.addClass(n.indeterminate),h.is.indeterminate()?h.debug("Input is already indeterminate, skipping input property change"):(h.debug("Setting state to indeterminate"),k.prop("indeterminate",!0))},determinate:function(){h.verbose("Removing indeterminate class"),f.removeClass(n.indeterminate),h.is.determinate()?h.debug("Input is already determinate, skipping input property change"):(h.debug("Setting state to determinate"),k.prop("indeterminate",!1))},disabled:function(){h.verbose("Setting class to disabled"),f.addClass(n.disabled),h.is.disabled()?h.debug("Input is already disabled, skipping input property change"):(h.debug("Setting state to disabled"),k.prop("disabled","disabled"))},enabled:function(){h.verbose("Removing disabled class"),f.removeClass(n.disabled),h.is.enabled()?h.debug("Input is already enabled, skipping input property change"):(h.debug("Setting state to enabled"),k.prop("disabled",!1))},tabbable:function(){h.verbose("Adding tabindex to checkbox"),k.attr("tabindex")===O&&k.attr("tabindex",0)}},remove:{initialLoad:function(){c=!1}},trigger:{change:function(){var e=k[0];if(e){var n=S.createEvent("HTMLEvents");h.verbose("Triggering native change event"),n.initEvent("change",!0,!1),e.dispatchEvent(n)}}},create:{label:function(){0<k.prevAll(p.label).length?(k.prev(p.label).detach().insertAfter(k),h.debug("Moving existing label",a)):h.has.label()||(a=I("<label>").insertAfter(k),h.debug("Creating label",a))}},has:{label:function(){return 0<a.length}},bind:{events:function(){h.verbose("Attaching checkbox events"),f.on("click"+i,h.event.click).on("change"+i,h.event.change).on("keydown"+i,p.input,h.event.keydown).on("keyup"+i,p.input,h.event.keyup)}},unbind:{events:function(){h.debug("Removing events"),f.off(i)}},uncheckOthers:function(){var e=h.get.otherRadios();h.debug("Unchecking other radios",e),e.removeClass(n.checked)},toggle:function(){h.can.change()?h.is.indeterminate()||h.is.unchecked()?(h.debug("Currently unchecked"),h.check()):h.is.checked()&&h.can.uncheck()&&(h.debug("Currently checked"),h.uncheck()):h.is.radio()||h.debug("Checkbox is read-only or disabled, ignoring toggle")},setting:function(e,n){if(h.debug("Changing setting",e,n),I.isPlainObject(e))I.extend(!0,g,e);else{if(n===O)return g[e];I.isPlainObject(g[e])?I.extend(!0,g[e],n):g[e]=n}},internal:function(e,n){if(I.isPlainObject(e))I.extend(!0,h,e);else{if(n===O)return h[e];h[e]=n}},debug:function(){!g.silent&&g.debug&&(g.performance?h.performance.log(arguments):(h.debug=Function.prototype.bind.call(console.info,console,g.name+":"),h.debug.apply(console,arguments)))},verbose:function(){!g.silent&&g.verbose&&g.debug&&(g.performance?h.performance.log(arguments):(h.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),h.verbose.apply(console,arguments)))},error:function(){g.silent||(h.error=Function.prototype.bind.call(console.error,console,g.name+":"),h.error.apply(console,arguments))},performance:{log:function(e){var n,t;g.performance&&(t=(n=(new Date).getTime())-(y||n),y=n,C.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:d,"Execution Time":t})),clearTimeout(h.performance.timer),h.performance.timer=setTimeout(h.performance.display,500)},display:function(){var e=g.name+":",t=0;y=!1,clearTimeout(h.performance.timer),I.each(C,function(e,n){t+=n["Execution Time"]}),e+=" "+t+"ms",b&&(e+=" '"+b+"'"),(console.group!==O||console.table!==O)&&0<C.length&&(console.groupCollapsed(e),console.table?console.table(C):I.each(C,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),C=[]}},invoke:function(i,e,n){var o,a,t,c=l;return e=e||D,n=d||n,"string"==typeof i&&c!==O&&(i=i.split(/[\. ]/),o=i.length-1,I.each(i,function(e,n){var t=e!=o?n+i[e+1].charAt(0).toUpperCase()+i[e+1].slice(1):i;if(I.isPlainObject(c[t])&&e!=o)c=c[t];else{if(c[t]!==O)return a=c[t],!1;if(!I.isPlainObject(c[n])||e==o)return c[n]!==O?a=c[n]:h.error(r.method,i),!1;c=c[n]}})),I.isFunction(a)?t=a.apply(n,e):a!==O&&(t=a),Array.isArray(u)?u.push(t):u!==O?u=[u,t]:t!==O&&(u=t),a}},w?(l===O&&h.initialize(),h.invoke(x)):(l!==O&&l.invoke("destroy"),h.initialize())}),u!==O?u:this},I.fn.checkbox.settings={name:"Checkbox",namespace:"checkbox",silent:!1,debug:!1,verbose:!0,performance:!0,uncheckable:"auto",fireOnInit:!1,enableEnterKey:!0,onChange:function(){},beforeChecked:function(){},beforeUnchecked:function(){},beforeDeterminate:function(){},beforeIndeterminate:function(){},onChecked:function(){},onUnchecked:function(){},onDeterminate:function(){},onIndeterminate:function(){},onEnable:function(){},onDisable:function(){},onEnabled:function(){},onDisabled:function(){},className:{checked:"checked",indeterminate:"indeterminate",disabled:"disabled",hidden:"hidden",radio:"radio",readOnly:"read-only"},error:{method:"The method you called is not defined"},selector:{checkbox:".ui.checkbox",label:"label, .box",input:'input[type="checkbox"], input[type="radio"]',link:"a[href]"}}}(jQuery,window,document);