# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['src2prod']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'multimd>=0.1.0-beta.0,<0.2.0',
 'spkpb>=0.0.10-beta.0,<0.0.11']

entry_points = \
{'console_scripts': ['src2prod = src2prod.cmdline:update']}

setup_kwargs = {
    'name': 'src2prod',
    'version': '0.1.1b0',
    'description': 'This module allows to develop a project within a source folder and to publish the final product in another folder, this last directory being a "thin" version of the source one.',
    'long_description': 'The `Python` module `src2prod`\n==============================\n\n> **I beg your pardon for my english...**\n>\n> English is not my native language, so be nice if you notice misunderstandings, misspellings, or grammatical errors in my documents and codes.\n\n\nAbout `src2prod`\n----------------\n\nThis module allows to develop a project within a source folder and to publish the final product in another folder, this last directory being a "thin" version of the source one. If you use `git`, this module can talk with it to do a better job.\n\n> We give detailed examples using `Python`, and then this document ends with an explanation of how to use `python -m src2prod` in a terminal.\n\n\nThe example used for this short tutorial\n----------------------------------------\n\nWe will consider a fictitious development project `MockProject` with the following tree structure.\n\n~~~\n+ MockProject\n    + changes\n        + 2022\n            * 12.txt\n        * LICENSE.txt\n        * x-todo-x.txt\n\n    + src\n        * __init__.py\n        * LICENSE.txt\n        * mockthis.py\n        + tool_config\n            * escape.yaml\n        * tool_debug.py\n        * tool_escape.py\n\n    + tests\n        + mockthis\n            * escape.yaml\n            * test_escape.py\n\n    * pyproject.toml\n    * README.md\n~~~\n\n\nBuilding a thin copy of the source folder\n-----------------------------------------\n\n### What we want...\n\nIn the project `mockproject`, there are some files that are only useful for code development.\n\n  1. Names using the pattern `x-...-x` indicate files, or folders that `git` must ignore (there are no such files, or folders in the `src` directory, but we could imagine using some).\n\n  1. Names using the pattern `tool_...` are for files, and folders not to be included in the final product, but which `git` must retain.\n\n  1. The `README.md` file used for `git` servers must also be included in the final product.\n\n\nBy copying files, we wish to add one new folder `mockproject` to obtain the following structure.\n\n~~~\n+ MockProject\n    + changes [...]\n\n    + mockproject\n        * __init__.py\n        * mockthis.py\n        * LICENSE.txt\n        * README.md\n\n    + src [...]\n\n    + tests [...]\n\n    * pyproject.toml\n    * README.md\n~~~\n\n\n### How to do that?\n\nHere is how to make a selective copy from the sub-directory `src` to the sub-folder `mockproject`. We will assume that the `cd` command has been used beforehand, so that running the `Python` scripts is done from the development folder `MockProject` (note the use of instances of `pathlib.Path`).\n\n~~~python\nfrom src2prod import *\n\nproject = Project(\n    project = Path(\'MockProject\'),\n    source  = Path(\'src\'),\n    target  = Path(\'mockproject\'),\n    ignore  = \'\'\'\n        tool_*/\n        tool_*.*\n    \'\'\',\n    usegit = True,\n    readme = Path(\'README.md\')\n)\n\nproject.update()\n~~~\n\nHere are the important points about the above code.\n\n  1. `project`, `source`, `target` and `readme` follow the rules below.\n\n      * The values of these arguments can also be strings (which will be converted to instances `Path`).\n\n      * The argument `readme` is optional unlike `project`, `source` and `target`.\n\n      * `project` is a full path to the source development directory when the `Python` script is launched, but `source`, `target` and `readme` are relative to `project`.\n\n  1. The argument `ignore` can be used even if the project does not use `git`. It can be either a string containing rules, or an absolute `Path` to a file containing rules (an absolute path allows the use of the same rules for multiple projects). Now let\'s see how to define rules.\n\n      * Empty lines are ignored (this allows a basic formatting of rules).\n\n      * Each none empty line is internally stripped. This will indicate one rule for either a file, or a folder.\n\n      * A rule finishing by `/` is for a folder: internally the last `/` is removed such as to store the rule only for folders.\n\n      * Each rule will be used with the method `match` of `pathlib.Path` (it\'s very basic, but quite powerful).\n\n  1. `usegit = True` asks to ignore files, and folders as `git` does, if this feature is activated for the development directory (this action completes the rules defined with the argument `ignore`).\n\n  1. Errors and warnings are printed in the terminal, and also written verbatim to the file `mockproject.src2prod.log` where `mockproject` is the name taken from the path specified via `project`.\n\n\nOnly the source files to copy\n-----------------------------\n\nSometimes, the final product is not just a "selective clone" of the folder `src`: for example, a final file may be the merging of several source files (the author of `src2prod` uses this technique to develop his `LaTeX` projects). In such a case, you can use the following method and attribute.\n\n  1. The method `build` just looks for files to keep for the product folder without creating anything.\n\n  1. After the use of `build`, the attribute `lof` is the list of all files to be kept for the folder `src` (`lof` is for `list of files`).\n\nHere is an example of code that prints the list of source files to be kept for the final product.\n\n~~~python\nfrom src2prod import *\n\nproject = Project(\n    name   = \'MockProject\',\n    source = Path(\'src\'),\n    target = Path(\'mockproject\'),\n    ignore = \'\'\'\n        tool_*/\n        tool_*.*\n    \'\'\',\n    usegit = True,\n    readme = Path(\'README.md\')\n)\n\nproject.build()\n\nfor f in project.lof:\n    print(f)\n~~~\n\nThis script run in a terminal gives the following output. Note that the list does not contain the path to the `README` file, this must be handled manually (see the `check_readme` and `copy_readme` methods of the class `Project`).\n\n~~~\n/full/path/to/MockProject/src/__init__.py\n/full/path/to/MockProject/src/escape.py\n/full/path/to/MockProject/src/LICENSE.txt\n~~~\n\n\n`README.md` piece-by-piece\n--------------------------\n\nYou can write your `README.md` by typing small sections. Let\'s assume we have done this for our fictitious development project `MockProject` which now has the following tree structure.\n\n~~~\n+ MockProject\n    + changes [...]\n\n    + readme\n        * about.md\n        * about.yaml\n        * cli.md\n        * escape.md\n        * prologue.md\n\n    + src [...]\n\n    + tests [...]\n\n    * pyproject.toml\n~~~\n\n\nThe special file `about.yaml` is used to specify the order in which the different `MD` files are merged. Its contents were as follows.\n\n~~~yaml\ntoc:\n  - prologue\n  - about\n  - escape\n  - cli\n~~~\n\nThe construction of the new final product `mockproject` is very simple: we just specify the folder `readme` instead of a file for the `readme` argument. And that\'s it! See the code below where the class `Project` guesses that `Path(\'readme\')` is a folder.\n\n~~~python\nfrom src2prod import *\n\nproject = Project(\n    project = Path(\'mockproject\'),\n    source  = Path(\'src\'),\n    target  = Path(\'mockproject\'),\n    ignore  = \'\'\'\n        tool_*/\n        tool_*.*\n    \'\'\',\n    usegit = True,\n    readme = Path(\'readme\')\n)\n\nproject.update()\n~~~\n\n\nWorking in a terminal\n---------------------\n\nThe project provides a `CLI`, aka a `Command Line Interface`, for updating a project. The following `Unix` terminal session shows how to use this feature.\n\n\n#### What we have before\n\n~~~\n> ls\nspkpb         src2prod\nignore.txt\n\n> cat ignore.txt\ntool_*/\ntool_*.*\n\n> ls spkpb\nREADME.md     src\nchanges       tools\n~~~\n\n\n#### How to use `src2prod`\n\n~~~\n> python -m src2prod --usegit --notsafe --readme=\'README.md\' --ignore=\'ignore.txt\' spkpb\n---------------\n"spkpb": UPDATE\n---------------\n\n1) The log file used will be :\n   "spkpb/spkpb.src2prod.log".\n2) External "README" file to use:\n   "spkpb/README.md".\n3) Ignore rules in the file:\n   "ignore.txt"\n4) Checking "git".\n5) Working in the branch "master".\n6) Starting the analysis of the source folder:\n   "spkpb/src".\n7) 21 files found using the rules from "ignore".\n8) Removing unwanted files using "git".\n9) 10 files found using "git". 11 new files ignored thanks to "git".\n10) Target folder has been created:\n    "spkpb/spkpb".\n11) Copying 10 files from source to target.\n12) "README.md" added to the target.\n13) Target folder updated.\n~~~\n\n\n#### What we obtain after\n\n~~~\n> ls spkpb\nREADME.md     spkpb.src2prod.log\nsrc           changes\nspkpb         tools\n\n> ls spkpb/spkpb/*\nspkpb/spkpb/LICENSE.txt        spkpb/spkpb/__init__.py\nspkpb/spkpb/problems.py        spkpb/spkpb/README.md\nspkpb/spkpb/base.py            spkpb/spkpb/timer.py\n\nspkpb/spkpb/speaker:\n__init__.py         log.py\nterm.py             allinone.py\nspk_interface.py\n~~~\n\n\n#### Help\n\nYou can have an help as usual in the `Unix` command line world.\n\n~~~\n> python -m src2prod --help\nUsage: __main__.py [OPTIONS] PROJECT\n\n  Update your "source-to-product" like projects using the Python module\n  src2prod.\n\n  PROJECT: the path of the project to update.\n\nOptions:\n  --src TEXT     Relative path of the source folder of the project. The\n                 default value is "src".\n\n  --target TEXT  Relative path of the targer folder of the project. The\n                 default value "", an empty string, indicates to use the name,\n                 in lower case, of the project.\n\n  --ignore TEXT  Path to a file with the rules for ignoring files in addition\n                 to what git does. The default value "", an empty string,\n                 indicates to not use any rule.\n\n  --usegit       This flag is to use git.\n  --readme TEXT  Relative path of an external "README" file or "readme"\n                 folder. The default value "", an empty string, indicates to\n                 not use any external "README" file.\n\n  --notsafe      TO USE WITH A LOT OF CAUTION! This flag allows to remove a\n                 none empty target folder.\n\n  --help         Show this message and exit.\n  ~~~',
    'author': 'Christophe BAL',
    'author_email': 'None',
    'maintainer': 'Christophe BAL',
    'maintainer_email': 'None',
    'url': 'https://github.com/bc-tools/for-dev/tree/main/src2prod',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
