"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticDBInstance = exports.ElasticDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "ElasticDBInstanceProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosElasticDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::GPDB::ElasticDBInstance`
 */
class ElasticDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::GPDB::ElasticDBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosElasticDBInstance = new gpdb_generated_1.RosElasticDBInstance(this, id, {
            masterNodeNum: props.masterNodeNum,
            encryptionType: props.encryptionType,
            instanceSpec: props.instanceSpec,
            engineVersion: props.engineVersion,
            privateIpAddress: props.privateIpAddress,
            zoneId: props.zoneId,
            vpcId: props.vpcId,
            vSwitchId: props.vSwitchId,
            segNodeNum: props.segNodeNum,
            period: props.period,
            segStorageType: props.segStorageType,
            storageSize: props.storageSize,
            encryptionKey: props.encryptionKey,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceCategory: props.dbInstanceCategory,
            securityIpList: props.securityIpList,
            dbInstanceMode: props.dbInstanceMode,
            dbInstanceDescription: props.dbInstanceDescription,
            tags: props.tags,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosElasticDBInstance;
        this.attrConnectionString = rosElasticDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosElasticDBInstance.attrDbInstanceId;
        this.attrOrderId = rosElasticDBInstance.attrOrderId;
        this.attrPort = rosElasticDBInstance.attrPort;
    }
}
exports.ElasticDBInstance = ElasticDBInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWxhc3RpY2RiaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbGFzdGljZGJpbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMscURBQXdEO0FBRXZCLDBHQUZ4QixxQ0FBb0IsT0FFNkI7QUF3SDFEOztHQUVHO0FBQ0gsTUFBYSxpQkFBa0IsU0FBUSxHQUFHLENBQUMsUUFBUTtJQTJCL0M7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE2QixFQUFFLG1DQUEyQyxJQUFJO1FBQ3hILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxvQkFBb0IsR0FBRyxJQUFJLHFDQUFvQixDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDN0QsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLE9BQU8sS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE9BQU87WUFDM0Ysa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxxQkFBcUI7WUFDbEQsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVTtTQUN2RyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLG9CQUFvQixDQUFDO1FBQ3JDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxvQkFBb0IsQ0FBQyxvQkFBb0IsQ0FBQztRQUN0RSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsb0JBQW9CLENBQUMsZ0JBQWdCLENBQUM7UUFDOUQsSUFBSSxDQUFDLFdBQVcsR0FBRyxvQkFBb0IsQ0FBQyxXQUFXLENBQUM7UUFDcEQsSUFBSSxDQUFDLFFBQVEsR0FBRyxvQkFBb0IsQ0FBQyxRQUFRLENBQUM7SUFDbEQsQ0FBQztDQUNKO0FBakVELDhDQWlFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0VsYXN0aWNEQkluc3RhbmNlIH0gZnJvbSAnLi9ncGRiLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0VsYXN0aWNEQkluc3RhbmNlIGFzIEVsYXN0aWNEQkluc3RhbmNlUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkdQREI6OkVsYXN0aWNEQkluc3RhbmNlYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEVsYXN0aWNEQkluc3RhbmNlUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZW5naW5lVmVyc2lvbjogVGhlIHZlcnNpb24gb2YgdGhlIGRhdGFiYXNlIGVuZ2luZS4gRm9yIGV4YW1wbGU6IDYuMOOAgTcuMFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuZ2luZVZlcnNpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGluc3RhbmNlU3BlYzogVGhlIHNwZWNpZmljYXRpb24gb2Ygc2VnbWVudCBub2Rlcy4gRm9yIGV4YW1wbGU6IDJDMTZHLCA0QzMyRywgMTZDMTI4Ry5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZVNwZWM6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNlZ05vZGVOdW06IFRoZSBudW1iZXIgb2Ygc2VnbWVudCBub2Rlcy5cbiAgICAgKiBGb3IgdGhlIGhpZ2ggYXZhaWxhYmlsaXR5IHZlcnNpb24sIHRoZSB2YWx1ZSByYW5nZXMgZnJvbSA0IHRvIDUxMi5cbiAgICAgKiBUaGUgYmFzaWMgdmVyc2lvbiByYW5nZXMgZnJvbSAyIHRvIDUxMi5cbiAgICAgKi9cbiAgICByZWFkb25seSBzZWdOb2RlTnVtOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzZWdTdG9yYWdlVHlwZTogVGhlIGRpc2sgdHlwZSBvZiBzZWdtZW50IG5vZGVzLiBGb3IgZXhhbXBsZTogY2xvdWRfZXNzZCwgY2xvdWRfZWZmaWNpZW5jeS5cbiAgICAgKi9cbiAgICByZWFkb25seSBzZWdTdG9yYWdlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc3RvcmFnZVNpemU6IFRoZSBzdG9yYWdlIGNhcGFjaXR5IG9mIHBlciBzZWdtZW50IG5vZGUuIFVuaXQ6IEdCLiBNaW5pbXVtIGlzIDUwLCBtYXggaXMgNDAwMCwgc3RlcCBpcyA1MC5cbiAgICAgKi9cbiAgICByZWFkb25seSBzdG9yYWdlU2l6ZTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdlN3aXRjaElkOiBUaGUgdlN3aXRjaCBJRCBvZiB0aGUgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdlN3aXRjaElkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB6b25lSWQ6IFRoZSB6b25lIElEIG9mIHRoZSBpbnN0YW5jZSwgc3VjaCBhcyBjbi1oYW5nemhvdS1kLiBZb3UgY2FuIGNhbGwgdGhlIERlc2NyaWJlUmVnaW9uc1xuICAgICAqIG9wZXJhdGlvbiB0byBxdWVyeSB0aGUgbW9zdCByZWNlbnQgem9uZSBsaXN0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHpvbmVJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGJJbnN0YW5jZUNhdGVnb3J5OiBEQiBpbnN0YW5jZSBjYXRlZ29yeSwgdmFsaWQgdmFsdWVzOiBCYXNpYywgSGlnaEF2YWlsYWJpbGl0eS5cbiAgICAgKiBUaGlzIHBhcmFtZXRlciBtdXN0IGJlIHBhc3NlZCBpbiB0byBjcmVhdGUgYSBzdG9yYWdlIHJlc2VydmF0aW9uIG1vZGUgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJJbnN0YW5jZUNhdGVnb3J5Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGJJbnN0YW5jZURlc2NyaXB0aW9uOiBUaGUgZGVzY3JpcHRpb24gb2YgdGhlIGluc3RhbmNlLiBUaGUgZGVzY3JpcHRpb24gY2Fubm90IGV4Y2VlZCAyNTYgY2hhcmFjdGVycyBpbiBsZW5ndGguXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJJbnN0YW5jZURlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGJJbnN0YW5jZU1vZGU6IFRoZSBkYiBpbnN0YW5jZSBtb2RlLiBWYWxpZCB2YWx1ZXM6IFN0b3JhZ2VFbGFzdGljLCBTZXJ2ZXJsZXNzLCBDbGFzc2ljLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRiSW5zdGFuY2VNb2RlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZW5jcnlwdGlvbktleTogSWYgdGhlIEVuY3J5cHRpb25UeXBlIHBhcmFtZXRlciBpcyBzZXQgdG8gQ2xvdWREaXNrLCB5b3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIHRvIHRoZSBlbmNyeXB0aW9uIGtleSB0aGF0IGlzIGluIHRoZSBzYW1lIHJlZ2lvbiB3aXRoIHRoZSBkaXNrcyB0aGF0IGlzIHNwZWNpZmllZCBieSB0aGUgRW5jcnlwdGlvblR5cGUgcGFyYW1ldGVyLiBPdGhlcndpc2UsIGxlYXZlIHRoaXMgcGFyYW1ldGVyIGVtcHR5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuY3J5cHRpb25LZXk/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlbmNyeXB0aW9uVHlwZTogVGhlIHR5cGUgb2YgdGhlIGVuY3J5cHRpb24uIERlZmF1bHQgdmFsdWU6IE5VTEwuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBOVUxMOiBFbmNyeXB0aW9uIGlzIGRpc2FibGVkLlxuICAgICAqIENsb3VkRGlzazogRW5jcnlwdGlvbiBpcyBlbmFibGVkIG9uIGRpc2tzIGFuZCB0aGUgZW5jcnlwdGlvbiBrZXkgaXMgc3BlY2lmaWVkIGJ5IHVzaW5nIHRoZSBFbmNyeXB0aW9uS2V5IHBhcmFtZXRlci5cbiAgICAgKiBOb3RlOiBEaXNrIGVuY3J5cHRpb24gY2Fubm90IGJlIGRpc2FibGVkIGFmdGVyIGl0IGlzIGVuYWJsZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5jcnlwdGlvblR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBtYXN0ZXJOb2RlTnVtOiBUaGUgbnVtYmVyIG9mIG1hc3RlciBub2Rlcy4gTWluaW11bSBpcyAxLCBtYXggaXMgMi5cbiAgICAgKi9cbiAgICByZWFkb25seSBtYXN0ZXJOb2RlTnVtPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGF5VHlwZTogVGhlIGJpbGxpbmcgbWV0aG9kIG9mIHRoZSBpbnN0YW5jZS4gRGVmYXVsdCB2YWx1ZTogUG9zdHBhaWQuIFZhbGlkIHZhbHVlczpcbiAgICAgKiBQb3N0cGFpZDogcGF5LWFzLXlvdS1nb1xuICAgICAqIFByZXBhaWQ6IHN1YnNjcmlwdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBheVR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwZXJpb2Q6IFRoZSBzdWJzY3JpcHRpb24gcGVyaW9kLiBXaGlsZSBjaG9vc2UgYnkgcGF5IGJ5IG1vbnRoLCBpdCBjb3VsZCBiZSBmcm9tIDEgdG8gMTEuIFdoaWxlIGNob29zZSBwYXkgYnkgeWVhciwgaXQgY291bGQgYmUgZnJvbSAxIHRvIDMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGVyaW9kPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcGVyaW9kVW5pdDogVW5pdCBvZiBzdWJzY3JpcHRpb24gcGVyaW9kLCBpdCBjb3VsZCBiZSBNb250aC9ZZWFyLiBEZWZhdWx0IHZhbHVlIGlzIE1vbnRoLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBlcmlvZFVuaXQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwcml2YXRlSXBBZGRyZXNzOiBQcml2YXRlIElQIGFkZHJlc3MuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpdmF0ZUlwQWRkcmVzcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNlY3VyaXR5SXBMaXN0OiBUaGUgd2hpdGVsaXN0IG9mIElQIGFkZHJlc3NlcyB0aGF0IGFyZSBhbGxvd2VkIHRvIGFjY2VzcyB0aGUgaW5zdGFuY2UuIERlZmF1bHQgdmFsdWU6XG4gICAgICogMTI3LjAuMC4xLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5SXBMaXN0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGFnczogVGFncyB0byBhdHRhY2ggdG8gaW5zdGFuY2UuIE1heCBzdXBwb3J0IDIwIHRhZ3MgdG8gYWRkIGR1cmluZyBjcmVhdGUgaW5zdGFuY2UuIEVhY2ggdGFnIHdpdGggdHdvIHByb3BlcnRpZXMgS2V5IGFuZCBWYWx1ZSwgYW5kIEtleSBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogUm9zRWxhc3RpY0RCSW5zdGFuY2UuVGFnc1Byb3BlcnR5W107XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2cGNJZDogVGhlIFZQQyBJRCBvZiB0aGUgaW5zdGFuY2UuIElmIHlvdSBzZXQgdGhlIEluc3RhbmNlTmV0d29ya1R5cGUgcGFyYW1ldGVyIHRvIFZQQywgeW91XG4gICAgICogbXVzdCBhbHNvIHNwZWNpZnkgdGhlIFZQQ0lkIHBhcmFtZXRlci4gVGhlIHNwZWNpZmllZCByZWdpb24gb2YgdGhlIFZQQyBtdXN0IGJlIHRoZVxuICAgICAqIHNhbWUgYXMgdGhlIFJlZ2lvbklkIHZhbHVlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZwY0lkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpHUERCOjpFbGFzdGljREJJbnN0YW5jZWBcbiAqL1xuZXhwb3J0IGNsYXNzIEVsYXN0aWNEQkluc3RhbmNlIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cbiAgICAgKi9cblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBDb25uZWN0aW9uU3RyaW5nOiBUaGUgZW5kcG9pbnQgb2YgdGhlIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQ29ubmVjdGlvblN0cmluZzogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERCSW5zdGFuY2VJZDogVGhlIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRiSW5zdGFuY2VJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIE9yZGVySWQ6IFRoZSBvcmRlciBJRCBvZiB0aGUgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJPcmRlcklkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgUG9ydDogVGhlIHBvcnQgdXNlZCB0byBjb25uZWN0IHRvIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clBvcnQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpHUERCOjpFbGFzdGljREJJbnN0YW5jZWAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRWxhc3RpY0RCSW5zdGFuY2VQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NFbGFzdGljREJJbnN0YW5jZSA9IG5ldyBSb3NFbGFzdGljREJJbnN0YW5jZSh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIG1hc3Rlck5vZGVOdW06IHByb3BzLm1hc3Rlck5vZGVOdW0sXG4gICAgICAgICAgICBlbmNyeXB0aW9uVHlwZTogcHJvcHMuZW5jcnlwdGlvblR5cGUsXG4gICAgICAgICAgICBpbnN0YW5jZVNwZWM6IHByb3BzLmluc3RhbmNlU3BlYyxcbiAgICAgICAgICAgIGVuZ2luZVZlcnNpb246IHByb3BzLmVuZ2luZVZlcnNpb24sXG4gICAgICAgICAgICBwcml2YXRlSXBBZGRyZXNzOiBwcm9wcy5wcml2YXRlSXBBZGRyZXNzLFxuICAgICAgICAgICAgem9uZUlkOiBwcm9wcy56b25lSWQsXG4gICAgICAgICAgICB2cGNJZDogcHJvcHMudnBjSWQsXG4gICAgICAgICAgICB2U3dpdGNoSWQ6IHByb3BzLnZTd2l0Y2hJZCxcbiAgICAgICAgICAgIHNlZ05vZGVOdW06IHByb3BzLnNlZ05vZGVOdW0sXG4gICAgICAgICAgICBwZXJpb2Q6IHByb3BzLnBlcmlvZCxcbiAgICAgICAgICAgIHNlZ1N0b3JhZ2VUeXBlOiBwcm9wcy5zZWdTdG9yYWdlVHlwZSxcbiAgICAgICAgICAgIHN0b3JhZ2VTaXplOiBwcm9wcy5zdG9yYWdlU2l6ZSxcbiAgICAgICAgICAgIGVuY3J5cHRpb25LZXk6IHByb3BzLmVuY3J5cHRpb25LZXksXG4gICAgICAgICAgICBwYXlUeXBlOiBwcm9wcy5wYXlUeXBlID09PSB1bmRlZmluZWQgfHwgcHJvcHMucGF5VHlwZSA9PT0gbnVsbCA/ICdQb3N0cGFpZCcgOiBwcm9wcy5wYXlUeXBlLFxuICAgICAgICAgICAgZGJJbnN0YW5jZUNhdGVnb3J5OiBwcm9wcy5kYkluc3RhbmNlQ2F0ZWdvcnksXG4gICAgICAgICAgICBzZWN1cml0eUlwTGlzdDogcHJvcHMuc2VjdXJpdHlJcExpc3QsXG4gICAgICAgICAgICBkYkluc3RhbmNlTW9kZTogcHJvcHMuZGJJbnN0YW5jZU1vZGUsXG4gICAgICAgICAgICBkYkluc3RhbmNlRGVzY3JpcHRpb246IHByb3BzLmRiSW5zdGFuY2VEZXNjcmlwdGlvbixcbiAgICAgICAgICAgIHRhZ3M6IHByb3BzLnRhZ3MsXG4gICAgICAgICAgICBwZXJpb2RVbml0OiBwcm9wcy5wZXJpb2RVbml0ID09PSB1bmRlZmluZWQgfHwgcHJvcHMucGVyaW9kVW5pdCA9PT0gbnVsbCA/ICdNb250aCcgOiBwcm9wcy5wZXJpb2RVbml0LFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0VsYXN0aWNEQkluc3RhbmNlO1xuICAgICAgICB0aGlzLmF0dHJDb25uZWN0aW9uU3RyaW5nID0gcm9zRWxhc3RpY0RCSW5zdGFuY2UuYXR0ckNvbm5lY3Rpb25TdHJpbmc7XG4gICAgICAgIHRoaXMuYXR0ckRiSW5zdGFuY2VJZCA9IHJvc0VsYXN0aWNEQkluc3RhbmNlLmF0dHJEYkluc3RhbmNlSWQ7XG4gICAgICAgIHRoaXMuYXR0ck9yZGVySWQgPSByb3NFbGFzdGljREJJbnN0YW5jZS5hdHRyT3JkZXJJZDtcbiAgICAgICAgdGhpcy5hdHRyUG9ydCA9IHJvc0VsYXN0aWNEQkluc3RhbmNlLmF0dHJQb3J0O1xuICAgIH1cbn1cbiJdfQ==