"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::GPDB::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::GPDB::DBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new gpdb_generated_1.RosDBInstance(this, id, {
            masterNodeNum: props.masterNodeNum,
            instanceSpec: props.instanceSpec,
            privateIpAddress: props.privateIpAddress,
            idleTime: props.idleTime,
            segNodeNum: props.segNodeNum,
            segStorageType: props.segStorageType,
            encryptionKey: props.encryptionKey,
            dbInstanceGroupCount: props.dbInstanceGroupCount,
            dbInstanceCategory: props.dbInstanceCategory,
            vectorConfigurationStatus: props.vectorConfigurationStatus,
            securityIpList: props.securityIpList,
            serverlessResource: props.serverlessResource,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            encryptionType: props.encryptionType,
            serverlessMode: props.serverlessMode,
            engineVersion: props.engineVersion,
            createSampleData: props.createSampleData,
            zoneId: props.zoneId,
            vpcId: props.vpcId,
            dbInstanceClass: props.dbInstanceClass,
            vSwitchId: props.vSwitchId,
            period: props.period,
            storageSize: props.storageSize,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceMode: props.dbInstanceMode,
            segDiskPerformanceLevel: props.segDiskPerformanceLevel,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrConnectionString = rosDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrOrderId = rosDBInstance.attrOrderId;
        this.attrPort = rosDBInstance.attrPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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