# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest

import flat_api
from flat_api.api.class_api import ClassApi  # noqa: E501
from flat_api.rest import ApiException


class TestClassApi(unittest.TestCase):
    """ClassApi unit test stubs"""

    def setUp(self):
        self.api = flat_api.api.class_api.ClassApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_activate_class(self):
        """Test case for activate_class

        Activate the class  # noqa: E501
        """
        pass

    def test_add_class_user(self):
        """Test case for add_class_user

        Add a user to the class  # noqa: E501
        """
        pass

    def test_archive_assignment(self):
        """Test case for archive_assignment

        Archive the assignment  # noqa: E501
        """
        pass

    def test_archive_class(self):
        """Test case for archive_class

        Archive the class  # noqa: E501
        """
        pass

    def test_copy_assignment(self):
        """Test case for copy_assignment

        Copy an assignment  # noqa: E501
        """
        pass

    def test_create_assignment(self):
        """Test case for create_assignment

        Assignment creation  # noqa: E501
        """
        pass

    def test_create_class(self):
        """Test case for create_class

        Create a new class  # noqa: E501
        """
        pass

    def test_create_submission(self):
        """Test case for create_submission

        Create or edit a submission  # noqa: E501
        """
        pass

    def test_delete_class_user(self):
        """Test case for delete_class_user

        Remove a user from the class  # noqa: E501
        """
        pass

    def test_delete_submission(self):
        """Test case for delete_submission

        Delete a submission  # noqa: E501
        """
        pass

    def test_delete_submission_comment(self):
        """Test case for delete_submission_comment

        Delete a feedback comment to a submission  # noqa: E501
        """
        pass

    def test_edit_submission(self):
        """Test case for edit_submission

        Edit a submission  # noqa: E501
        """
        pass

    def test_enroll_class(self):
        """Test case for enroll_class

        Join a class  # noqa: E501
        """
        pass

    def test_export_submissions_reviews_as_csv(self):
        """Test case for export_submissions_reviews_as_csv

        CSV Grades exports  # noqa: E501
        """
        pass

    def test_export_submissions_reviews_as_excel(self):
        """Test case for export_submissions_reviews_as_excel

        Excel Grades exports  # noqa: E501
        """
        pass

    def test_fork_score(self):
        """Test case for fork_score

        Fork a score  # noqa: E501
        """
        pass

    def test_get_class(self):
        """Test case for get_class

        Get the details of a single class  # noqa: E501
        """
        pass

    def test_get_score_submissions(self):
        """Test case for get_score_submissions

        List submissions related to the score  # noqa: E501
        """
        pass

    def test_get_submission(self):
        """Test case for get_submission

        Get a student submission  # noqa: E501
        """
        pass

    def test_get_submission_comments(self):
        """Test case for get_submission_comments

        List the feedback comments of a submission  # noqa: E501
        """
        pass

    def test_get_submission_history(self):
        """Test case for get_submission_history

        Get the history of the submission  # noqa: E501
        """
        pass

    def test_get_submissions(self):
        """Test case for get_submissions

        List the students' submissions  # noqa: E501
        """
        pass

    def test_list_assignments(self):
        """Test case for list_assignments

        Assignments listing  # noqa: E501
        """
        pass

    def test_list_class_student_submissions(self):
        """Test case for list_class_student_submissions

        List the submissions for a student  # noqa: E501
        """
        pass

    def test_list_classes(self):
        """Test case for list_classes

        List the classes available for the current user  # noqa: E501
        """
        pass

    def test_post_submission_comment(self):
        """Test case for post_submission_comment

        Add a feedback comment to a submission  # noqa: E501
        """
        pass

    def test_unarchive_assignment(self):
        """Test case for unarchive_assignment

        Unarchive the assignment.  # noqa: E501
        """
        pass

    def test_unarchive_class(self):
        """Test case for unarchive_class

        Unarchive the class  # noqa: E501
        """
        pass

    def test_update_class(self):
        """Test case for update_class

        Update the class  # noqa: E501
        """
        pass

    def test_update_submission_comment(self):
        """Test case for update_submission_comment

        Update a feedback comment to a submission  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
