# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class UserPublic(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'username': 'str',
        'picture': 'str',
        'followers_count': 'int',
        'firstname': 'str',
        'is_power_user': 'bool',
        'lastname': 'str',
        'html_url': 'str',
        'following_count': 'int',
        'liked_scores_count': 'int',
        'printable_name': 'str',
        'bio': 'str',
        'id': 'str',
        'name': 'str',
        'is_flat_team': 'bool',
        'organization_role': 'OrganizationRoles',
        'profile_theme': 'str',
        'cover_picture': 'str',
        'owned_public_scores_count': 'int',
        'instruments': 'list[str]',
        'class_role': 'ClassRoles',
        'organization': 'str',
        'type': 'str',
        'registration_date': 'datetime'
    }

    attribute_map = {
        'username': 'username',
        'picture': 'picture',
        'followers_count': 'followersCount',
        'firstname': 'firstname',
        'is_power_user': 'isPowerUser',
        'lastname': 'lastname',
        'html_url': 'htmlUrl',
        'following_count': 'followingCount',
        'liked_scores_count': 'likedScoresCount',
        'printable_name': 'printableName',
        'bio': 'bio',
        'id': 'id',
        'name': 'name',
        'is_flat_team': 'isFlatTeam',
        'organization_role': 'organizationRole',
        'profile_theme': 'profileTheme',
        'cover_picture': 'coverPicture',
        'owned_public_scores_count': 'ownedPublicScoresCount',
        'instruments': 'instruments',
        'class_role': 'classRole',
        'organization': 'organization',
        'type': 'type',
        'registration_date': 'registrationDate'
    }

    def __init__(self, username=None, picture=None, followers_count=None, firstname=None, is_power_user=None, lastname=None, html_url=None, following_count=None, liked_scores_count=None, printable_name=None, bio=None, id=None, name=None, is_flat_team=None, organization_role=None, profile_theme=None, cover_picture=None, owned_public_scores_count=None, instruments=None, class_role=None, organization=None, type=None, registration_date=None):  # noqa: E501
        """UserPublic - a model defined in OpenAPI"""  # noqa: E501

        self._username = None
        self._picture = None
        self._followers_count = None
        self._firstname = None
        self._is_power_user = None
        self._lastname = None
        self._html_url = None
        self._following_count = None
        self._liked_scores_count = None
        self._printable_name = None
        self._bio = None
        self._id = None
        self._name = None
        self._is_flat_team = None
        self._organization_role = None
        self._profile_theme = None
        self._cover_picture = None
        self._owned_public_scores_count = None
        self._instruments = None
        self._class_role = None
        self._organization = None
        self._type = None
        self._registration_date = None
        self.discriminator = None

        if username is not None:
            self.username = username
        self.picture = picture
        if followers_count is not None:
            self.followers_count = followers_count
        if firstname is not None:
            self.firstname = firstname
        if is_power_user is not None:
            self.is_power_user = is_power_user
        if lastname is not None:
            self.lastname = lastname
        if html_url is not None:
            self.html_url = html_url
        if following_count is not None:
            self.following_count = following_count
        if liked_scores_count is not None:
            self.liked_scores_count = liked_scores_count
        if printable_name is not None:
            self.printable_name = printable_name
        if bio is not None:
            self.bio = bio
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if is_flat_team is not None:
            self.is_flat_team = is_flat_team
        if organization_role is not None:
            self.organization_role = organization_role
        if profile_theme is not None:
            self.profile_theme = profile_theme
        if cover_picture is not None:
            self.cover_picture = cover_picture
        if owned_public_scores_count is not None:
            self.owned_public_scores_count = owned_public_scores_count
        if instruments is not None:
            self.instruments = instruments
        if class_role is not None:
            self.class_role = class_role
        if organization is not None:
            self.organization = organization
        if type is not None:
            self.type = type
        if registration_date is not None:
            self.registration_date = registration_date

    @property
    def username(self):
        """Gets the username of this UserPublic.  # noqa: E501

        The user name (unique for the organization)  # noqa: E501

        :return: The username of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this UserPublic.

        The user name (unique for the organization)  # noqa: E501

        :param username: The username of this UserPublic.  # noqa: E501
        :type: str
        """

        self._username = username

    @property
    def picture(self):
        """Gets the picture of this UserPublic.  # noqa: E501

        The URL of the picture to display  # noqa: E501

        :return: The picture of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._picture

    @picture.setter
    def picture(self, picture):
        """Sets the picture of this UserPublic.

        The URL of the picture to display  # noqa: E501

        :param picture: The picture of this UserPublic.  # noqa: E501
        :type: str
        """

        self._picture = picture

    @property
    def followers_count(self):
        """Gets the followers_count of this UserPublic.  # noqa: E501

        Number of followers the user have  # noqa: E501

        :return: The followers_count of this UserPublic.  # noqa: E501
        :rtype: int
        """
        return self._followers_count

    @followers_count.setter
    def followers_count(self, followers_count):
        """Sets the followers_count of this UserPublic.

        Number of followers the user have  # noqa: E501

        :param followers_count: The followers_count of this UserPublic.  # noqa: E501
        :type: int
        """

        self._followers_count = followers_count

    @property
    def firstname(self):
        """Gets the firstname of this UserPublic.  # noqa: E501

        Firstname of the user (for education users)  # noqa: E501

        :return: The firstname of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._firstname

    @firstname.setter
    def firstname(self, firstname):
        """Sets the firstname of this UserPublic.

        Firstname of the user (for education users)  # noqa: E501

        :param firstname: The firstname of this UserPublic.  # noqa: E501
        :type: str
        """

        self._firstname = firstname

    @property
    def is_power_user(self):
        """Gets the is_power_user of this UserPublic.  # noqa: E501

        User license status. 'true' if user is an individual Power user  # noqa: E501

        :return: The is_power_user of this UserPublic.  # noqa: E501
        :rtype: bool
        """
        return self._is_power_user

    @is_power_user.setter
    def is_power_user(self, is_power_user):
        """Sets the is_power_user of this UserPublic.

        User license status. 'true' if user is an individual Power user  # noqa: E501

        :param is_power_user: The is_power_user of this UserPublic.  # noqa: E501
        :type: bool
        """

        self._is_power_user = is_power_user

    @property
    def lastname(self):
        """Gets the lastname of this UserPublic.  # noqa: E501

        Lastname of the user (for education users)  # noqa: E501

        :return: The lastname of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._lastname

    @lastname.setter
    def lastname(self, lastname):
        """Sets the lastname of this UserPublic.

        Lastname of the user (for education users)  # noqa: E501

        :param lastname: The lastname of this UserPublic.  # noqa: E501
        :type: str
        """

        self._lastname = lastname

    @property
    def html_url(self):
        """Gets the html_url of this UserPublic.  # noqa: E501

        Link to user profile (for Indiv. users only)  # noqa: E501

        :return: The html_url of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """Sets the html_url of this UserPublic.

        Link to user profile (for Indiv. users only)  # noqa: E501

        :param html_url: The html_url of this UserPublic.  # noqa: E501
        :type: str
        """

        self._html_url = html_url

    @property
    def following_count(self):
        """Gets the following_count of this UserPublic.  # noqa: E501

        Number of people the user follow  # noqa: E501

        :return: The following_count of this UserPublic.  # noqa: E501
        :rtype: int
        """
        return self._following_count

    @following_count.setter
    def following_count(self, following_count):
        """Sets the following_count of this UserPublic.

        Number of people the user follow  # noqa: E501

        :param following_count: The following_count of this UserPublic.  # noqa: E501
        :type: int
        """

        self._following_count = following_count

    @property
    def liked_scores_count(self):
        """Gets the liked_scores_count of this UserPublic.  # noqa: E501

        Number of the scores liked by the user  # noqa: E501

        :return: The liked_scores_count of this UserPublic.  # noqa: E501
        :rtype: int
        """
        return self._liked_scores_count

    @liked_scores_count.setter
    def liked_scores_count(self, liked_scores_count):
        """Sets the liked_scores_count of this UserPublic.

        Number of the scores liked by the user  # noqa: E501

        :param liked_scores_count: The liked_scores_count of this UserPublic.  # noqa: E501
        :type: int
        """

        self._liked_scores_count = liked_scores_count

    @property
    def printable_name(self):
        """Gets the printable_name of this UserPublic.  # noqa: E501

        The name that can be directly printed (name, firstname & lastname, or username)  # noqa: E501

        :return: The printable_name of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._printable_name

    @printable_name.setter
    def printable_name(self, printable_name):
        """Sets the printable_name of this UserPublic.

        The name that can be directly printed (name, firstname & lastname, or username)  # noqa: E501

        :param printable_name: The printable_name of this UserPublic.  # noqa: E501
        :type: str
        """

        self._printable_name = printable_name

    @property
    def bio(self):
        """Gets the bio of this UserPublic.  # noqa: E501

        User's biography  # noqa: E501

        :return: The bio of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._bio

    @bio.setter
    def bio(self, bio):
        """Sets the bio of this UserPublic.

        User's biography  # noqa: E501

        :param bio: The bio of this UserPublic.  # noqa: E501
        :type: str
        """

        self._bio = bio

    @property
    def id(self):
        """Gets the id of this UserPublic.  # noqa: E501

        The user unique identifier  # noqa: E501

        :return: The id of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UserPublic.

        The user unique identifier  # noqa: E501

        :param id: The id of this UserPublic.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this UserPublic.  # noqa: E501

        A displayable name for the user (for consumer users)  # noqa: E501

        :return: The name of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this UserPublic.

        A displayable name for the user (for consumer users)  # noqa: E501

        :param name: The name of this UserPublic.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def is_flat_team(self):
        """Gets the is_flat_team of this UserPublic.  # noqa: E501

        Will be 'true' if user is part of the Flat Team  # noqa: E501

        :return: The is_flat_team of this UserPublic.  # noqa: E501
        :rtype: bool
        """
        return self._is_flat_team

    @is_flat_team.setter
    def is_flat_team(self, is_flat_team):
        """Sets the is_flat_team of this UserPublic.

        Will be 'true' if user is part of the Flat Team  # noqa: E501

        :param is_flat_team: The is_flat_team of this UserPublic.  # noqa: E501
        :type: bool
        """

        self._is_flat_team = is_flat_team

    @property
    def organization_role(self):
        """Gets the organization_role of this UserPublic.  # noqa: E501


        :return: The organization_role of this UserPublic.  # noqa: E501
        :rtype: OrganizationRoles
        """
        return self._organization_role

    @organization_role.setter
    def organization_role(self, organization_role):
        """Sets the organization_role of this UserPublic.


        :param organization_role: The organization_role of this UserPublic.  # noqa: E501
        :type: OrganizationRoles
        """

        self._organization_role = organization_role

    @property
    def profile_theme(self):
        """Gets the profile_theme of this UserPublic.  # noqa: E501

        Theme (background) for the profile  # noqa: E501

        :return: The profile_theme of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._profile_theme

    @profile_theme.setter
    def profile_theme(self, profile_theme):
        """Sets the profile_theme of this UserPublic.

        Theme (background) for the profile  # noqa: E501

        :param profile_theme: The profile_theme of this UserPublic.  # noqa: E501
        :type: str
        """

        self._profile_theme = profile_theme

    @property
    def cover_picture(self):
        """Gets the cover_picture of this UserPublic.  # noqa: E501

        Cover picture (backgroud) for the profile  # noqa: E501

        :return: The cover_picture of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._cover_picture

    @cover_picture.setter
    def cover_picture(self, cover_picture):
        """Sets the cover_picture of this UserPublic.

        Cover picture (backgroud) for the profile  # noqa: E501

        :param cover_picture: The cover_picture of this UserPublic.  # noqa: E501
        :type: str
        """

        self._cover_picture = cover_picture

    @property
    def owned_public_scores_count(self):
        """Gets the owned_public_scores_count of this UserPublic.  # noqa: E501

        Number of public scores the user have  # noqa: E501

        :return: The owned_public_scores_count of this UserPublic.  # noqa: E501
        :rtype: int
        """
        return self._owned_public_scores_count

    @owned_public_scores_count.setter
    def owned_public_scores_count(self, owned_public_scores_count):
        """Sets the owned_public_scores_count of this UserPublic.

        Number of public scores the user have  # noqa: E501

        :param owned_public_scores_count: The owned_public_scores_count of this UserPublic.  # noqa: E501
        :type: int
        """

        self._owned_public_scores_count = owned_public_scores_count

    @property
    def instruments(self):
        """Gets the instruments of this UserPublic.  # noqa: E501

        An array of the instrument identifiers. The format of the strings is `{instrument-group}.{instrument-id}`.   # noqa: E501

        :return: The instruments of this UserPublic.  # noqa: E501
        :rtype: list[str]
        """
        return self._instruments

    @instruments.setter
    def instruments(self, instruments):
        """Sets the instruments of this UserPublic.

        An array of the instrument identifiers. The format of the strings is `{instrument-group}.{instrument-id}`.   # noqa: E501

        :param instruments: The instruments of this UserPublic.  # noqa: E501
        :type: list[str]
        """

        self._instruments = instruments

    @property
    def class_role(self):
        """Gets the class_role of this UserPublic.  # noqa: E501


        :return: The class_role of this UserPublic.  # noqa: E501
        :rtype: ClassRoles
        """
        return self._class_role

    @class_role.setter
    def class_role(self, class_role):
        """Sets the class_role of this UserPublic.


        :param class_role: The class_role of this UserPublic.  # noqa: E501
        :type: ClassRoles
        """

        self._class_role = class_role

    @property
    def organization(self):
        """Gets the organization of this UserPublic.  # noqa: E501

        Organization ID (for Edu users only)  # noqa: E501

        :return: The organization of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this UserPublic.

        Organization ID (for Edu users only)  # noqa: E501

        :param organization: The organization of this UserPublic.  # noqa: E501
        :type: str
        """

        self._organization = organization

    @property
    def type(self):
        """Gets the type of this UserPublic.  # noqa: E501

        The type of user account  # noqa: E501

        :return: The type of this UserPublic.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this UserPublic.

        The type of user account  # noqa: E501

        :param type: The type of this UserPublic.  # noqa: E501
        :type: str
        """
        allowed_values = ["user", "guest"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def registration_date(self):
        """Gets the registration_date of this UserPublic.  # noqa: E501

        Date the user signed up  # noqa: E501

        :return: The registration_date of this UserPublic.  # noqa: E501
        :rtype: datetime
        """
        return self._registration_date

    @registration_date.setter
    def registration_date(self, registration_date):
        """Sets the registration_date of this UserPublic.

        Date the user signed up  # noqa: E501

        :param registration_date: The registration_date of this UserPublic.  # noqa: E501
        :type: datetime
        """

        self._registration_date = registration_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserPublic):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
