# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Task(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'state': 'str',
        'progress': 'TaskProgress',
        'creation_date': 'datetime',
        'modification_date': 'datetime',
        'done_date': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'state': 'state',
        'progress': 'progress',
        'creation_date': 'creationDate',
        'modification_date': 'modificationDate',
        'done_date': 'doneDate'
    }

    def __init__(self, id=None, type=None, state=None, progress=None, creation_date=None, modification_date=None, done_date=None):  # noqa: E501
        """Task - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._type = None
        self._state = None
        self._progress = None
        self._creation_date = None
        self._modification_date = None
        self._done_date = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if type is not None:
            self.type = type
        if state is not None:
            self.state = state
        if progress is not None:
            self.progress = progress
        if creation_date is not None:
            self.creation_date = creation_date
        if modification_date is not None:
            self.modification_date = modification_date
        if done_date is not None:
            self.done_date = done_date

    @property
    def id(self):
        """Gets the id of this Task.  # noqa: E501

        Unique identifier of the task  # noqa: E501

        :return: The id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Task.

        Unique identifier of the task  # noqa: E501

        :param id: The id of this Task.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this Task.  # noqa: E501

        Type of the task  # noqa: E501

        :return: The type of this Task.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Task.

        Type of the task  # noqa: E501

        :param type: The type of this Task.  # noqa: E501
        :type: str
        """
        allowed_values = ["audio-export", "audio-low-prio"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def state(self):
        """Gets the state of this Task.  # noqa: E501

        State of the Task  # noqa: E501

        :return: The state of this Task.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Task.

        State of the Task  # noqa: E501

        :param state: The state of this Task.  # noqa: E501
        :type: str
        """
        allowed_values = ["created", "doing", "done", "canceled", "error"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def progress(self):
        """Gets the progress of this Task.  # noqa: E501


        :return: The progress of this Task.  # noqa: E501
        :rtype: TaskProgress
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """Sets the progress of this Task.


        :param progress: The progress of this Task.  # noqa: E501
        :type: TaskProgress
        """

        self._progress = progress

    @property
    def creation_date(self):
        """Gets the creation_date of this Task.  # noqa: E501

        The creation date of the task  # noqa: E501

        :return: The creation_date of this Task.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this Task.

        The creation date of the task  # noqa: E501

        :param creation_date: The creation_date of this Task.  # noqa: E501
        :type: datetime
        """

        self._creation_date = creation_date

    @property
    def modification_date(self):
        """Gets the modification_date of this Task.  # noqa: E501

        The last modification date of the task  # noqa: E501

        :return: The modification_date of this Task.  # noqa: E501
        :rtype: datetime
        """
        return self._modification_date

    @modification_date.setter
    def modification_date(self, modification_date):
        """Sets the modification_date of this Task.

        The last modification date of the task  # noqa: E501

        :param modification_date: The modification_date of this Task.  # noqa: E501
        :type: datetime
        """

        self._modification_date = modification_date

    @property
    def done_date(self):
        """Gets the done_date of this Task.  # noqa: E501

        The date when the task has been completed  # noqa: E501

        :return: The done_date of this Task.  # noqa: E501
        :rtype: datetime
        """
        return self._done_date

    @done_date.setter
    def done_date(self, done_date):
        """Sets the done_date of this Task.

        The date when the task has been completed  # noqa: E501

        :param done_date: The done_date of this Task.  # noqa: E501
        :type: datetime
        """

        self._done_date = done_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Task):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
