# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ScoreCreationBuilderDataScoreData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'use_tab_staff': 'bool',
        'use_chord_grid': 'bool',
        'fifths': 'float',
        'nb_beats': 'float',
        'beat_type': 'float',
        'instruments': 'list[ScoreCreationBuilderDataScoreDataInstruments]'
    }

    attribute_map = {
        'use_tab_staff': 'useTabStaff',
        'use_chord_grid': 'useChordGrid',
        'fifths': 'fifths',
        'nb_beats': 'nbBeats',
        'beat_type': 'beatType',
        'instruments': 'instruments'
    }

    def __init__(self, use_tab_staff=None, use_chord_grid=None, fifths=None, nb_beats=None, beat_type=None, instruments=None):  # noqa: E501
        """ScoreCreationBuilderDataScoreData - a model defined in OpenAPI"""  # noqa: E501

        self._use_tab_staff = None
        self._use_chord_grid = None
        self._fifths = None
        self._nb_beats = None
        self._beat_type = None
        self._instruments = None
        self.discriminator = None

        if use_tab_staff is not None:
            self.use_tab_staff = use_tab_staff
        if use_chord_grid is not None:
            self.use_chord_grid = use_chord_grid
        if fifths is not None:
            self.fifths = fifths
        if nb_beats is not None:
            self.nb_beats = nb_beats
        if beat_type is not None:
            self.beat_type = beat_type
        if instruments is not None:
            self.instruments = instruments

    @property
    def use_tab_staff(self):
        """Gets the use_tab_staff of this ScoreCreationBuilderDataScoreData.  # noqa: E501

        true if the TAB staff is displayed with fretted instruments  # noqa: E501

        :return: The use_tab_staff of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :rtype: bool
        """
        return self._use_tab_staff

    @use_tab_staff.setter
    def use_tab_staff(self, use_tab_staff):
        """Sets the use_tab_staff of this ScoreCreationBuilderDataScoreData.

        true if the TAB staff is displayed with fretted instruments  # noqa: E501

        :param use_tab_staff: The use_tab_staff of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :type: bool
        """

        self._use_tab_staff = use_tab_staff

    @property
    def use_chord_grid(self):
        """Gets the use_chord_grid of this ScoreCreationBuilderDataScoreData.  # noqa: E501

        true if the chord grid must be displayed with fretted instruments  # noqa: E501

        :return: The use_chord_grid of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :rtype: bool
        """
        return self._use_chord_grid

    @use_chord_grid.setter
    def use_chord_grid(self, use_chord_grid):
        """Sets the use_chord_grid of this ScoreCreationBuilderDataScoreData.

        true if the chord grid must be displayed with fretted instruments  # noqa: E501

        :param use_chord_grid: The use_chord_grid of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :type: bool
        """

        self._use_chord_grid = use_chord_grid

    @property
    def fifths(self):
        """Gets the fifths of this ScoreCreationBuilderDataScoreData.  # noqa: E501

        The key signature of the score (expressed between -7 and 7). Major C is used when the value is not provided.  # noqa: E501

        :return: The fifths of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :rtype: float
        """
        return self._fifths

    @fifths.setter
    def fifths(self, fifths):
        """Sets the fifths of this ScoreCreationBuilderDataScoreData.

        The key signature of the score (expressed between -7 and 7). Major C is used when the value is not provided.  # noqa: E501

        :param fifths: The fifths of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :type: float
        """

        self._fifths = fifths

    @property
    def nb_beats(self):
        """Gets the nb_beats of this ScoreCreationBuilderDataScoreData.  # noqa: E501

        The number of beats in the measure  # noqa: E501

        :return: The nb_beats of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :rtype: float
        """
        return self._nb_beats

    @nb_beats.setter
    def nb_beats(self, nb_beats):
        """Sets the nb_beats of this ScoreCreationBuilderDataScoreData.

        The number of beats in the measure  # noqa: E501

        :param nb_beats: The nb_beats of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :type: float
        """

        self._nb_beats = nb_beats

    @property
    def beat_type(self):
        """Gets the beat_type of this ScoreCreationBuilderDataScoreData.  # noqa: E501

        The duration of a beat in the measure  # noqa: E501

        :return: The beat_type of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :rtype: float
        """
        return self._beat_type

    @beat_type.setter
    def beat_type(self, beat_type):
        """Sets the beat_type of this ScoreCreationBuilderDataScoreData.

        The duration of a beat in the measure  # noqa: E501

        :param beat_type: The beat_type of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :type: float
        """

        self._beat_type = beat_type

    @property
    def instruments(self):
        """Gets the instruments of this ScoreCreationBuilderDataScoreData.  # noqa: E501

        The list of instruments to add to the score. See https://prod.flat-cdn.com/fixtures/instruments_en.json for the possible values for `group` and `instrument`.   # noqa: E501

        :return: The instruments of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :rtype: list[ScoreCreationBuilderDataScoreDataInstruments]
        """
        return self._instruments

    @instruments.setter
    def instruments(self, instruments):
        """Sets the instruments of this ScoreCreationBuilderDataScoreData.

        The list of instruments to add to the score. See https://prod.flat-cdn.com/fixtures/instruments_en.json for the possible values for `group` and `instrument`.   # noqa: E501

        :param instruments: The instruments of this ScoreCreationBuilderDataScoreData.  # noqa: E501
        :type: list[ScoreCreationBuilderDataScoreDataInstruments]
        """

        self._instruments = instruments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScoreCreationBuilderDataScoreData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
