# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ScoreCreationBuilderDataLayoutData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'notes_spacing_coeff': 'float',
        'length_unit': 'str',
        'page_height': 'float',
        'page_width': 'float',
        'page_margin_top': 'float',
        'page_margin_bottom': 'float',
        'page_margin_left': 'float',
        'page_margin_right': 'float'
    }

    attribute_map = {
        'notes_spacing_coeff': 'notesSpacingCoeff',
        'length_unit': 'lengthUnit',
        'page_height': 'pageHeight',
        'page_width': 'pageWidth',
        'page_margin_top': 'pageMarginTop',
        'page_margin_bottom': 'pageMarginBottom',
        'page_margin_left': 'pageMarginLeft',
        'page_margin_right': 'pageMarginRight'
    }

    def __init__(self, notes_spacing_coeff=None, length_unit='cm', page_height=None, page_width=None, page_margin_top=None, page_margin_bottom=None, page_margin_left=None, page_margin_right=None):  # noqa: E501
        """ScoreCreationBuilderDataLayoutData - a model defined in OpenAPI"""  # noqa: E501

        self._notes_spacing_coeff = None
        self._length_unit = None
        self._page_height = None
        self._page_width = None
        self._page_margin_top = None
        self._page_margin_bottom = None
        self._page_margin_left = None
        self._page_margin_right = None
        self.discriminator = None

        if notes_spacing_coeff is not None:
            self.notes_spacing_coeff = notes_spacing_coeff
        if length_unit is not None:
            self.length_unit = length_unit
        if page_height is not None:
            self.page_height = page_height
        if page_width is not None:
            self.page_width = page_width
        if page_margin_top is not None:
            self.page_margin_top = page_margin_top
        if page_margin_bottom is not None:
            self.page_margin_bottom = page_margin_bottom
        if page_margin_left is not None:
            self.page_margin_left = page_margin_left
        if page_margin_right is not None:
            self.page_margin_right = page_margin_right

    @property
    def notes_spacing_coeff(self):
        """Gets the notes_spacing_coeff of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        A float value >= 1 that controls the spacing between notes.  # noqa: E501

        :return: The notes_spacing_coeff of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._notes_spacing_coeff

    @notes_spacing_coeff.setter
    def notes_spacing_coeff(self, notes_spacing_coeff):
        """Sets the notes_spacing_coeff of this ScoreCreationBuilderDataLayoutData.

        A float value >= 1 that controls the spacing between notes.  # noqa: E501

        :param notes_spacing_coeff: The notes_spacing_coeff of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._notes_spacing_coeff = notes_spacing_coeff

    @property
    def length_unit(self):
        """Gets the length_unit of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The unit to use for layout customizations  # noqa: E501

        :return: The length_unit of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: str
        """
        return self._length_unit

    @length_unit.setter
    def length_unit(self, length_unit):
        """Sets the length_unit of this ScoreCreationBuilderDataLayoutData.

        The unit to use for layout customizations  # noqa: E501

        :param length_unit: The length_unit of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: str
        """
        allowed_values = ["cm", "inch"]  # noqa: E501
        if length_unit not in allowed_values:
            raise ValueError(
                "Invalid value for `length_unit` ({0}), must be one of {1}"  # noqa: E501
                .format(length_unit, allowed_values)
            )

        self._length_unit = length_unit

    @property
    def page_height(self):
        """Gets the page_height of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The height of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :return: The page_height of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._page_height

    @page_height.setter
    def page_height(self, page_height):
        """Sets the page_height of this ScoreCreationBuilderDataLayoutData.

        The height of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :param page_height: The page_height of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._page_height = page_height

    @property
    def page_width(self):
        """Gets the page_width of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The width of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :return: The page_width of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._page_width

    @page_width.setter
    def page_width(self, page_width):
        """Sets the page_width of this ScoreCreationBuilderDataLayoutData.

        The width of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :param page_width: The page_width of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._page_width = page_width

    @property
    def page_margin_top(self):
        """Gets the page_margin_top of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The top margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :return: The page_margin_top of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._page_margin_top

    @page_margin_top.setter
    def page_margin_top(self, page_margin_top):
        """Sets the page_margin_top of this ScoreCreationBuilderDataLayoutData.

        The top margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :param page_margin_top: The page_margin_top of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._page_margin_top = page_margin_top

    @property
    def page_margin_bottom(self):
        """Gets the page_margin_bottom of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The bottom margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :return: The page_margin_bottom of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._page_margin_bottom

    @page_margin_bottom.setter
    def page_margin_bottom(self, page_margin_bottom):
        """Sets the page_margin_bottom of this ScoreCreationBuilderDataLayoutData.

        The bottom margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :param page_margin_bottom: The page_margin_bottom of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._page_margin_bottom = page_margin_bottom

    @property
    def page_margin_left(self):
        """Gets the page_margin_left of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The left margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :return: The page_margin_left of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._page_margin_left

    @page_margin_left.setter
    def page_margin_left(self, page_margin_left):
        """Sets the page_margin_left of this ScoreCreationBuilderDataLayoutData.

        The left margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :param page_margin_left: The page_margin_left of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._page_margin_left = page_margin_left

    @property
    def page_margin_right(self):
        """Gets the page_margin_right of this ScoreCreationBuilderDataLayoutData.  # noqa: E501

        The right margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :return: The page_margin_right of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :rtype: float
        """
        return self._page_margin_right

    @page_margin_right.setter
    def page_margin_right(self, page_margin_right):
        """Sets the page_margin_right of this ScoreCreationBuilderDataLayoutData.

        The right margin of the page in chosen unit (`lengthUnit`).  # noqa: E501

        :param page_margin_right: The page_margin_right of this ScoreCreationBuilderDataLayoutData.  # noqa: E501
        :type: float
        """

        self._page_margin_right = page_margin_right

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScoreCreationBuilderDataLayoutData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
