# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ScoreCreation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'data_encoding': 'str',
        'title': 'str',
        'privacy': 'ScorePrivacy',
        'builder_data': 'ScoreCreationBuilderData',
        'filename': 'str',
        'source': 'ScoreSource',
        'collection': 'str',
        'data': 'str',
        'google_drive_folder': 'str'
    }

    attribute_map = {
        'data_encoding': 'dataEncoding',
        'title': 'title',
        'privacy': 'privacy',
        'builder_data': 'builderData',
        'filename': 'filename',
        'source': 'source',
        'collection': 'collection',
        'data': 'data',
        'google_drive_folder': 'googleDriveFolder'
    }

    def __init__(self, data_encoding=None, title=None, privacy=None, builder_data=None, filename=None, source=None, collection=None, data=None, google_drive_folder=None):  # noqa: E501
        """ScoreCreation - a model defined in OpenAPI"""  # noqa: E501

        self._data_encoding = None
        self._title = None
        self._privacy = None
        self._builder_data = None
        self._filename = None
        self._source = None
        self._collection = None
        self._data = None
        self._google_drive_folder = None
        self.discriminator = None

        if data_encoding is not None:
            self.data_encoding = data_encoding
        if title is not None:
            self.title = title
        if privacy is not None:
            self.privacy = privacy
        if builder_data is not None:
            self.builder_data = builder_data
        if filename is not None:
            self.filename = filename
        if source is not None:
            self.source = source
        if collection is not None:
            self.collection = collection
        if data is not None:
            self.data = data
        if google_drive_folder is not None:
            self.google_drive_folder = google_drive_folder

    @property
    def data_encoding(self):
        """Gets the data_encoding of this ScoreCreation.  # noqa: E501

        The optional encoding of the score data. This property must match the encoding used for the `data` property.  # noqa: E501

        :return: The data_encoding of this ScoreCreation.  # noqa: E501
        :rtype: str
        """
        return self._data_encoding

    @data_encoding.setter
    def data_encoding(self, data_encoding):
        """Sets the data_encoding of this ScoreCreation.

        The optional encoding of the score data. This property must match the encoding used for the `data` property.  # noqa: E501

        :param data_encoding: The data_encoding of this ScoreCreation.  # noqa: E501
        :type: str
        """
        allowed_values = ["base64"]  # noqa: E501
        if data_encoding not in allowed_values:
            raise ValueError(
                "Invalid value for `data_encoding` ({0}), must be one of {1}"  # noqa: E501
                .format(data_encoding, allowed_values)
            )

        self._data_encoding = data_encoding

    @property
    def title(self):
        """Gets the title of this ScoreCreation.  # noqa: E501

        The title of the new score. If the title is too long, the API may trim this one.  If this title is not specified, the API will try to (in this order):   - Use the title contained in the file (e.g. [`movement-title`](https://usermanuals.musicxml.com/MusicXML/Content/EL-MusicXML-movement-title.htm) or [`credit-words`](https://usermanuals.musicxml.com/MusicXML/Content/EL-MusicXML-credit-words.htm) for [MusicXML](http://www.musicxml.com/) files).   - Use the name of the file for files from a specified `source` (e.g. Google Drive) or the one in the `filename` property   - Set a default title (e.g. \"New Music Score\")   # noqa: E501

        :return: The title of this ScoreCreation.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ScoreCreation.

        The title of the new score. If the title is too long, the API may trim this one.  If this title is not specified, the API will try to (in this order):   - Use the title contained in the file (e.g. [`movement-title`](https://usermanuals.musicxml.com/MusicXML/Content/EL-MusicXML-movement-title.htm) or [`credit-words`](https://usermanuals.musicxml.com/MusicXML/Content/EL-MusicXML-credit-words.htm) for [MusicXML](http://www.musicxml.com/) files).   - Use the name of the file for files from a specified `source` (e.g. Google Drive) or the one in the `filename` property   - Set a default title (e.g. \"New Music Score\")   # noqa: E501

        :param title: The title of this ScoreCreation.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def privacy(self):
        """Gets the privacy of this ScoreCreation.  # noqa: E501


        :return: The privacy of this ScoreCreation.  # noqa: E501
        :rtype: ScorePrivacy
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this ScoreCreation.


        :param privacy: The privacy of this ScoreCreation.  # noqa: E501
        :type: ScorePrivacy
        """

        self._privacy = privacy

    @property
    def builder_data(self):
        """Gets the builder_data of this ScoreCreation.  # noqa: E501


        :return: The builder_data of this ScoreCreation.  # noqa: E501
        :rtype: ScoreCreationBuilderData
        """
        return self._builder_data

    @builder_data.setter
    def builder_data(self, builder_data):
        """Sets the builder_data of this ScoreCreation.


        :param builder_data: The builder_data of this ScoreCreation.  # noqa: E501
        :type: ScoreCreationBuilderData
        """

        self._builder_data = builder_data

    @property
    def filename(self):
        """Gets the filename of this ScoreCreation.  # noqa: E501

        If this is an imported file, its filename  # noqa: E501

        :return: The filename of this ScoreCreation.  # noqa: E501
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this ScoreCreation.

        If this is an imported file, its filename  # noqa: E501

        :param filename: The filename of this ScoreCreation.  # noqa: E501
        :type: str
        """

        self._filename = filename

    @property
    def source(self):
        """Gets the source of this ScoreCreation.  # noqa: E501


        :return: The source of this ScoreCreation.  # noqa: E501
        :rtype: ScoreSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this ScoreCreation.


        :param source: The source of this ScoreCreation.  # noqa: E501
        :type: ScoreSource
        """

        self._source = source

    @property
    def collection(self):
        """Gets the collection of this ScoreCreation.  # noqa: E501

        Unique identifier of a collection where the score will be created. If no collection identifier is provided, the score will be stored in the `root` directory.   # noqa: E501

        :return: The collection of this ScoreCreation.  # noqa: E501
        :rtype: str
        """
        return self._collection

    @collection.setter
    def collection(self, collection):
        """Sets the collection of this ScoreCreation.

        Unique identifier of a collection where the score will be created. If no collection identifier is provided, the score will be stored in the `root` directory.   # noqa: E501

        :param collection: The collection of this ScoreCreation.  # noqa: E501
        :type: str
        """

        self._collection = collection

    @property
    def data(self):
        """Gets the data of this ScoreCreation.  # noqa: E501

        The data of the score file. It must be a MusicXML 3 file (`vnd.recordare.musicxml` or `vnd.recordare.musicxml+xml`), a MIDI file (`audio/midi`) or a Flat.json (aka Adagio.json) file. Binary payloads (`vnd.recordare.musicxml` and `audio/midi`) can be encoded in Base64, in this case the `dataEncoding` property must match the encoding used for the API request.   # noqa: E501

        :return: The data of this ScoreCreation.  # noqa: E501
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this ScoreCreation.

        The data of the score file. It must be a MusicXML 3 file (`vnd.recordare.musicxml` or `vnd.recordare.musicxml+xml`), a MIDI file (`audio/midi`) or a Flat.json (aka Adagio.json) file. Binary payloads (`vnd.recordare.musicxml` and `audio/midi`) can be encoded in Base64, in this case the `dataEncoding` property must match the encoding used for the API request.   # noqa: E501

        :param data: The data of this ScoreCreation.  # noqa: E501
        :type: str
        """

        self._data = data

    @property
    def google_drive_folder(self):
        """Gets the google_drive_folder of this ScoreCreation.  # noqa: E501

        If the user uses Google Drive and this properties is specified, the file will be created in this directory. The currently user creating the file must be granted to write in this directory.   # noqa: E501

        :return: The google_drive_folder of this ScoreCreation.  # noqa: E501
        :rtype: str
        """
        return self._google_drive_folder

    @google_drive_folder.setter
    def google_drive_folder(self, google_drive_folder):
        """Sets the google_drive_folder of this ScoreCreation.

        If the user uses Google Drive and this properties is specified, the file will be created in this directory. The currently user creating the file must be granted to write in this directory.   # noqa: E501

        :param google_drive_folder: The google_drive_folder of this ScoreCreation.  # noqa: E501
        :type: str
        """

        self._google_drive_folder = google_drive_folder

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScoreCreation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
