# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ScoreCommentContext(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'part_uuid': 'str',
        'staff_idx': 'float',
        'staff_uuid': 'str',
        'measure_uuids': 'list[str]',
        'start_time_pos': 'float',
        'stop_time_pos': 'float',
        'start_dpq': 'float',
        'stop_dpq': 'float'
    }

    attribute_map = {
        'part_uuid': 'partUuid',
        'staff_idx': 'staffIdx',
        'staff_uuid': 'staffUuid',
        'measure_uuids': 'measureUuids',
        'start_time_pos': 'startTimePos',
        'stop_time_pos': 'stopTimePos',
        'start_dpq': 'startDpq',
        'stop_dpq': 'stopDpq'
    }

    def __init__(self, part_uuid=None, staff_idx=None, staff_uuid=None, measure_uuids=None, start_time_pos=None, stop_time_pos=None, start_dpq=None, stop_dpq=None):  # noqa: E501
        """ScoreCommentContext - a model defined in OpenAPI"""  # noqa: E501

        self._part_uuid = None
        self._staff_idx = None
        self._staff_uuid = None
        self._measure_uuids = None
        self._start_time_pos = None
        self._stop_time_pos = None
        self._start_dpq = None
        self._stop_dpq = None
        self.discriminator = None

        self.part_uuid = part_uuid
        if staff_idx is not None:
            self.staff_idx = staff_idx
        if staff_uuid is not None:
            self.staff_uuid = staff_uuid
        self.measure_uuids = measure_uuids
        self.start_time_pos = start_time_pos
        self.stop_time_pos = stop_time_pos
        self.start_dpq = start_dpq
        self.stop_dpq = stop_dpq

    @property
    def part_uuid(self):
        """Gets the part_uuid of this ScoreCommentContext.  # noqa: E501

        The unique identifier (UUID) of the score part  # noqa: E501

        :return: The part_uuid of this ScoreCommentContext.  # noqa: E501
        :rtype: str
        """
        return self._part_uuid

    @part_uuid.setter
    def part_uuid(self, part_uuid):
        """Sets the part_uuid of this ScoreCommentContext.

        The unique identifier (UUID) of the score part  # noqa: E501

        :param part_uuid: The part_uuid of this ScoreCommentContext.  # noqa: E501
        :type: str
        """
        if part_uuid is None:
            raise ValueError("Invalid value for `part_uuid`, must not be `None`")  # noqa: E501

        self._part_uuid = part_uuid

    @property
    def staff_idx(self):
        """Gets the staff_idx of this ScoreCommentContext.  # noqa: E501

        (Deprecated, use `staffUuid`) The identififer of the staff  # noqa: E501

        :return: The staff_idx of this ScoreCommentContext.  # noqa: E501
        :rtype: float
        """
        return self._staff_idx

    @staff_idx.setter
    def staff_idx(self, staff_idx):
        """Sets the staff_idx of this ScoreCommentContext.

        (Deprecated, use `staffUuid`) The identififer of the staff  # noqa: E501

        :param staff_idx: The staff_idx of this ScoreCommentContext.  # noqa: E501
        :type: float
        """

        self._staff_idx = staff_idx

    @property
    def staff_uuid(self):
        """Gets the staff_uuid of this ScoreCommentContext.  # noqa: E501

        The unique identififer (UUID) of the staff  # noqa: E501

        :return: The staff_uuid of this ScoreCommentContext.  # noqa: E501
        :rtype: str
        """
        return self._staff_uuid

    @staff_uuid.setter
    def staff_uuid(self, staff_uuid):
        """Sets the staff_uuid of this ScoreCommentContext.

        The unique identififer (UUID) of the staff  # noqa: E501

        :param staff_uuid: The staff_uuid of this ScoreCommentContext.  # noqa: E501
        :type: str
        """

        self._staff_uuid = staff_uuid

    @property
    def measure_uuids(self):
        """Gets the measure_uuids of this ScoreCommentContext.  # noqa: E501

        The list of measure UUIds  # noqa: E501

        :return: The measure_uuids of this ScoreCommentContext.  # noqa: E501
        :rtype: list[str]
        """
        return self._measure_uuids

    @measure_uuids.setter
    def measure_uuids(self, measure_uuids):
        """Sets the measure_uuids of this ScoreCommentContext.

        The list of measure UUIds  # noqa: E501

        :param measure_uuids: The measure_uuids of this ScoreCommentContext.  # noqa: E501
        :type: list[str]
        """
        if measure_uuids is None:
            raise ValueError("Invalid value for `measure_uuids`, must not be `None`")  # noqa: E501

        self._measure_uuids = measure_uuids

    @property
    def start_time_pos(self):
        """Gets the start_time_pos of this ScoreCommentContext.  # noqa: E501


        :return: The start_time_pos of this ScoreCommentContext.  # noqa: E501
        :rtype: float
        """
        return self._start_time_pos

    @start_time_pos.setter
    def start_time_pos(self, start_time_pos):
        """Sets the start_time_pos of this ScoreCommentContext.


        :param start_time_pos: The start_time_pos of this ScoreCommentContext.  # noqa: E501
        :type: float
        """
        if start_time_pos is None:
            raise ValueError("Invalid value for `start_time_pos`, must not be `None`")  # noqa: E501

        self._start_time_pos = start_time_pos

    @property
    def stop_time_pos(self):
        """Gets the stop_time_pos of this ScoreCommentContext.  # noqa: E501


        :return: The stop_time_pos of this ScoreCommentContext.  # noqa: E501
        :rtype: float
        """
        return self._stop_time_pos

    @stop_time_pos.setter
    def stop_time_pos(self, stop_time_pos):
        """Sets the stop_time_pos of this ScoreCommentContext.


        :param stop_time_pos: The stop_time_pos of this ScoreCommentContext.  # noqa: E501
        :type: float
        """
        if stop_time_pos is None:
            raise ValueError("Invalid value for `stop_time_pos`, must not be `None`")  # noqa: E501

        self._stop_time_pos = stop_time_pos

    @property
    def start_dpq(self):
        """Gets the start_dpq of this ScoreCommentContext.  # noqa: E501


        :return: The start_dpq of this ScoreCommentContext.  # noqa: E501
        :rtype: float
        """
        return self._start_dpq

    @start_dpq.setter
    def start_dpq(self, start_dpq):
        """Sets the start_dpq of this ScoreCommentContext.


        :param start_dpq: The start_dpq of this ScoreCommentContext.  # noqa: E501
        :type: float
        """
        if start_dpq is None:
            raise ValueError("Invalid value for `start_dpq`, must not be `None`")  # noqa: E501

        self._start_dpq = start_dpq

    @property
    def stop_dpq(self):
        """Gets the stop_dpq of this ScoreCommentContext.  # noqa: E501


        :return: The stop_dpq of this ScoreCommentContext.  # noqa: E501
        :rtype: float
        """
        return self._stop_dpq

    @stop_dpq.setter
    def stop_dpq(self, stop_dpq):
        """Sets the stop_dpq of this ScoreCommentContext.


        :param stop_dpq: The stop_dpq of this ScoreCommentContext.  # noqa: E501
        :type: float
        """
        if stop_dpq is None:
            raise ValueError("Invalid value for `stop_dpq`, must not be `None`")  # noqa: E501

        self._stop_dpq = stop_dpq

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScoreCommentContext):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
