# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ScoreComment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'user': 'str',
        'score': 'str',
        'revision': 'str',
        'reply_to': 'str',
        'date': 'datetime',
        'modification_date': 'datetime',
        'comment': 'str',
        'raw_comment': 'str',
        'context': 'ScoreCommentContext',
        'mentions': 'list[str]',
        'resolved': 'bool',
        'resolved_by': 'str',
        'moderation': 'ScoreCommentModeration',
        'spam': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'user': 'user',
        'score': 'score',
        'revision': 'revision',
        'reply_to': 'replyTo',
        'date': 'date',
        'modification_date': 'modificationDate',
        'comment': 'comment',
        'raw_comment': 'rawComment',
        'context': 'context',
        'mentions': 'mentions',
        'resolved': 'resolved',
        'resolved_by': 'resolvedBy',
        'moderation': 'moderation',
        'spam': 'spam'
    }

    def __init__(self, id=None, type=None, user=None, score=None, revision=None, reply_to=None, date=None, modification_date=None, comment=None, raw_comment=None, context=None, mentions=None, resolved=None, resolved_by=None, moderation=None, spam=None):  # noqa: E501
        """ScoreComment - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._type = None
        self._user = None
        self._score = None
        self._revision = None
        self._reply_to = None
        self._date = None
        self._modification_date = None
        self._comment = None
        self._raw_comment = None
        self._context = None
        self._mentions = None
        self._resolved = None
        self._resolved_by = None
        self._moderation = None
        self._spam = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if type is not None:
            self.type = type
        if user is not None:
            self.user = user
        if score is not None:
            self.score = score
        if revision is not None:
            self.revision = revision
        if reply_to is not None:
            self.reply_to = reply_to
        if date is not None:
            self.date = date
        if modification_date is not None:
            self.modification_date = modification_date
        if comment is not None:
            self.comment = comment
        if raw_comment is not None:
            self.raw_comment = raw_comment
        if context is not None:
            self.context = context
        if mentions is not None:
            self.mentions = mentions
        if resolved is not None:
            self.resolved = resolved
        if resolved_by is not None:
            self.resolved_by = resolved_by
        if moderation is not None:
            self.moderation = moderation
        if spam is not None:
            self.spam = spam

    @property
    def id(self):
        """Gets the id of this ScoreComment.  # noqa: E501

        The comment unique identifier  # noqa: E501

        :return: The id of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ScoreComment.

        The comment unique identifier  # noqa: E501

        :param id: The id of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this ScoreComment.  # noqa: E501

        The type of the comment  # noqa: E501

        :return: The type of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ScoreComment.

        The type of the comment  # noqa: E501

        :param type: The type of this ScoreComment.  # noqa: E501
        :type: str
        """
        allowed_values = ["document", "inline"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def user(self):
        """Gets the user of this ScoreComment.  # noqa: E501

        The author unique identifier  # noqa: E501

        :return: The user of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ScoreComment.

        The author unique identifier  # noqa: E501

        :param user: The user of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def score(self):
        """Gets the score of this ScoreComment.  # noqa: E501

        The unique identifier of the score where the comment was posted  # noqa: E501

        :return: The score of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this ScoreComment.

        The unique identifier of the score where the comment was posted  # noqa: E501

        :param score: The score of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._score = score

    @property
    def revision(self):
        """Gets the revision of this ScoreComment.  # noqa: E501

        The unique identifier of revision the comment was posted  # noqa: E501

        :return: The revision of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this ScoreComment.

        The unique identifier of revision the comment was posted  # noqa: E501

        :param revision: The revision of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._revision = revision

    @property
    def reply_to(self):
        """Gets the reply_to of this ScoreComment.  # noqa: E501

        When the comment is a reply to another comment, the unique identifier of the parent comment   # noqa: E501

        :return: The reply_to of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._reply_to

    @reply_to.setter
    def reply_to(self, reply_to):
        """Sets the reply_to of this ScoreComment.

        When the comment is a reply to another comment, the unique identifier of the parent comment   # noqa: E501

        :param reply_to: The reply_to of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._reply_to = reply_to

    @property
    def date(self):
        """Gets the date of this ScoreComment.  # noqa: E501

        The date when the comment was posted  # noqa: E501

        :return: The date of this ScoreComment.  # noqa: E501
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this ScoreComment.

        The date when the comment was posted  # noqa: E501

        :param date: The date of this ScoreComment.  # noqa: E501
        :type: datetime
        """

        self._date = date

    @property
    def modification_date(self):
        """Gets the modification_date of this ScoreComment.  # noqa: E501

        The date of the last comment modification  # noqa: E501

        :return: The modification_date of this ScoreComment.  # noqa: E501
        :rtype: datetime
        """
        return self._modification_date

    @modification_date.setter
    def modification_date(self, modification_date):
        """Sets the modification_date of this ScoreComment.

        The date of the last comment modification  # noqa: E501

        :param modification_date: The modification_date of this ScoreComment.  # noqa: E501
        :type: datetime
        """

        self._modification_date = modification_date

    @property
    def comment(self):
        """Gets the comment of this ScoreComment.  # noqa: E501

        The comment text that can includes mentions using the following format: `@[id:username]`.   # noqa: E501

        :return: The comment of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this ScoreComment.

        The comment text that can includes mentions using the following format: `@[id:username]`.   # noqa: E501

        :param comment: The comment of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def raw_comment(self):
        """Gets the raw_comment of this ScoreComment.  # noqa: E501

        A raw version of the comment, that can be displayed without parsing the mentions.   # noqa: E501

        :return: The raw_comment of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._raw_comment

    @raw_comment.setter
    def raw_comment(self, raw_comment):
        """Sets the raw_comment of this ScoreComment.

        A raw version of the comment, that can be displayed without parsing the mentions.   # noqa: E501

        :param raw_comment: The raw_comment of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._raw_comment = raw_comment

    @property
    def context(self):
        """Gets the context of this ScoreComment.  # noqa: E501


        :return: The context of this ScoreComment.  # noqa: E501
        :rtype: ScoreCommentContext
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this ScoreComment.


        :param context: The context of this ScoreComment.  # noqa: E501
        :type: ScoreCommentContext
        """

        self._context = context

    @property
    def mentions(self):
        """Gets the mentions of this ScoreComment.  # noqa: E501

        The list of user identifier mentioned on the score  # noqa: E501

        :return: The mentions of this ScoreComment.  # noqa: E501
        :rtype: list[str]
        """
        return self._mentions

    @mentions.setter
    def mentions(self, mentions):
        """Sets the mentions of this ScoreComment.

        The list of user identifier mentioned on the score  # noqa: E501

        :param mentions: The mentions of this ScoreComment.  # noqa: E501
        :type: list[str]
        """

        self._mentions = mentions

    @property
    def resolved(self):
        """Gets the resolved of this ScoreComment.  # noqa: E501

        For inline comments, the comment can be marked as resolved and will be hidden in the future responses   # noqa: E501

        :return: The resolved of this ScoreComment.  # noqa: E501
        :rtype: bool
        """
        return self._resolved

    @resolved.setter
    def resolved(self, resolved):
        """Sets the resolved of this ScoreComment.

        For inline comments, the comment can be marked as resolved and will be hidden in the future responses   # noqa: E501

        :param resolved: The resolved of this ScoreComment.  # noqa: E501
        :type: bool
        """

        self._resolved = resolved

    @property
    def resolved_by(self):
        """Gets the resolved_by of this ScoreComment.  # noqa: E501

        If the user is marked as resolved, this will contain the unique identifier of the User who marked this comment as resolved   # noqa: E501

        :return: The resolved_by of this ScoreComment.  # noqa: E501
        :rtype: str
        """
        return self._resolved_by

    @resolved_by.setter
    def resolved_by(self, resolved_by):
        """Sets the resolved_by of this ScoreComment.

        If the user is marked as resolved, this will contain the unique identifier of the User who marked this comment as resolved   # noqa: E501

        :param resolved_by: The resolved_by of this ScoreComment.  # noqa: E501
        :type: str
        """

        self._resolved_by = resolved_by

    @property
    def moderation(self):
        """Gets the moderation of this ScoreComment.  # noqa: E501


        :return: The moderation of this ScoreComment.  # noqa: E501
        :rtype: ScoreCommentModeration
        """
        return self._moderation

    @moderation.setter
    def moderation(self, moderation):
        """Sets the moderation of this ScoreComment.


        :param moderation: The moderation of this ScoreComment.  # noqa: E501
        :type: ScoreCommentModeration
        """

        self._moderation = moderation

    @property
    def spam(self):
        """Gets the spam of this ScoreComment.  # noqa: E501

        `true  if the message has been detected as spam and hidden from other users   # noqa: E501

        :return: The spam of this ScoreComment.  # noqa: E501
        :rtype: bool
        """
        return self._spam

    @spam.setter
    def spam(self, spam):
        """Sets the spam of this ScoreComment.

        `true  if the message has been detected as spam and hidden from other users   # noqa: E501

        :param spam: The spam of this ScoreComment.  # noqa: E501
        :type: bool
        """

        self._spam = spam

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScoreComment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
