# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class OrganizationInvitation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'organization': 'str',
        'organization_role': 'OrganizationRoles',
        'custom_code': 'str',
        'email': 'str',
        'invited_by': 'str',
        'used_by': 'str'
    }

    attribute_map = {
        'id': 'id',
        'organization': 'organization',
        'organization_role': 'organizationRole',
        'custom_code': 'customCode',
        'email': 'email',
        'invited_by': 'invitedBy',
        'used_by': 'usedBy'
    }

    def __init__(self, id=None, organization=None, organization_role=None, custom_code=None, email=None, invited_by=None, used_by=None):  # noqa: E501
        """OrganizationInvitation - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._organization = None
        self._organization_role = None
        self._custom_code = None
        self._email = None
        self._invited_by = None
        self._used_by = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if organization is not None:
            self.organization = organization
        if organization_role is not None:
            self.organization_role = organization_role
        if custom_code is not None:
            self.custom_code = custom_code
        if email is not None:
            self.email = email
        if invited_by is not None:
            self.invited_by = invited_by
        if used_by is not None:
            self.used_by = used_by

    @property
    def id(self):
        """Gets the id of this OrganizationInvitation.  # noqa: E501

        The invitation unique identifier  # noqa: E501

        :return: The id of this OrganizationInvitation.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this OrganizationInvitation.

        The invitation unique identifier  # noqa: E501

        :param id: The id of this OrganizationInvitation.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def organization(self):
        """Gets the organization of this OrganizationInvitation.  # noqa: E501

        The unique identifier of the Organization owning this class  # noqa: E501

        :return: The organization of this OrganizationInvitation.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this OrganizationInvitation.

        The unique identifier of the Organization owning this class  # noqa: E501

        :param organization: The organization of this OrganizationInvitation.  # noqa: E501
        :type: str
        """

        self._organization = organization

    @property
    def organization_role(self):
        """Gets the organization_role of this OrganizationInvitation.  # noqa: E501


        :return: The organization_role of this OrganizationInvitation.  # noqa: E501
        :rtype: OrganizationRoles
        """
        return self._organization_role

    @organization_role.setter
    def organization_role(self, organization_role):
        """Sets the organization_role of this OrganizationInvitation.


        :param organization_role: The organization_role of this OrganizationInvitation.  # noqa: E501
        :type: OrganizationRoles
        """

        self._organization_role = organization_role

    @property
    def custom_code(self):
        """Gets the custom_code of this OrganizationInvitation.  # noqa: E501

        Enrollment code to use when joining this organization  # noqa: E501

        :return: The custom_code of this OrganizationInvitation.  # noqa: E501
        :rtype: str
        """
        return self._custom_code

    @custom_code.setter
    def custom_code(self, custom_code):
        """Sets the custom_code of this OrganizationInvitation.

        Enrollment code to use when joining this organization  # noqa: E501

        :param custom_code: The custom_code of this OrganizationInvitation.  # noqa: E501
        :type: str
        """

        self._custom_code = custom_code

    @property
    def email(self):
        """Gets the email of this OrganizationInvitation.  # noqa: E501

        The email address this invitation was sent to  # noqa: E501

        :return: The email of this OrganizationInvitation.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this OrganizationInvitation.

        The email address this invitation was sent to  # noqa: E501

        :param email: The email of this OrganizationInvitation.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def invited_by(self):
        """Gets the invited_by of this OrganizationInvitation.  # noqa: E501

        The unique identifier of the User who created this invitation  # noqa: E501

        :return: The invited_by of this OrganizationInvitation.  # noqa: E501
        :rtype: str
        """
        return self._invited_by

    @invited_by.setter
    def invited_by(self, invited_by):
        """Sets the invited_by of this OrganizationInvitation.

        The unique identifier of the User who created this invitation  # noqa: E501

        :param invited_by: The invited_by of this OrganizationInvitation.  # noqa: E501
        :type: str
        """

        self._invited_by = invited_by

    @property
    def used_by(self):
        """Gets the used_by of this OrganizationInvitation.  # noqa: E501

        The unique identifier of the User who used this invitation  # noqa: E501

        :return: The used_by of this OrganizationInvitation.  # noqa: E501
        :rtype: str
        """
        return self._used_by

    @used_by.setter
    def used_by(self, used_by):
        """Sets the used_by of this OrganizationInvitation.

        The unique identifier of the User who used this invitation  # noqa: E501

        :param used_by: The used_by of this OrganizationInvitation.  # noqa: E501
        :type: str
        """

        self._used_by = used_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationInvitation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
