# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class MediaAttachment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'score': 'str',
        'revision': 'str',
        'worksheet': 'str',
        'track': 'str',
        'sharing_mode': 'MediaScoreSharingMode',
        'lock_score_template': 'bool',
        'title': 'str',
        'description': 'str',
        'html': 'str',
        'html_width': 'str',
        'html_height': 'str',
        'url': 'str',
        'thumbnail_url': 'str',
        'thumbnail_width': 'int',
        'thumbnail_height': 'int',
        'author_name': 'str',
        'author_url': 'str',
        'icon_url': 'str',
        'mime_type': 'str',
        'google_drive_file_id': 'str'
    }

    attribute_map = {
        'type': 'type',
        'score': 'score',
        'revision': 'revision',
        'worksheet': 'worksheet',
        'track': 'track',
        'sharing_mode': 'sharingMode',
        'lock_score_template': 'lockScoreTemplate',
        'title': 'title',
        'description': 'description',
        'html': 'html',
        'html_width': 'htmlWidth',
        'html_height': 'htmlHeight',
        'url': 'url',
        'thumbnail_url': 'thumbnailUrl',
        'thumbnail_width': 'thumbnailWidth',
        'thumbnail_height': 'thumbnailHeight',
        'author_name': 'authorName',
        'author_url': 'authorUrl',
        'icon_url': 'iconUrl',
        'mime_type': 'mimeType',
        'google_drive_file_id': 'googleDriveFileId'
    }

    def __init__(self, type=None, score=None, revision=None, worksheet=None, track=None, sharing_mode=None, lock_score_template=None, title=None, description=None, html=None, html_width=None, html_height=None, url=None, thumbnail_url=None, thumbnail_width=None, thumbnail_height=None, author_name=None, author_url=None, icon_url=None, mime_type=None, google_drive_file_id=None):  # noqa: E501
        """MediaAttachment - a model defined in OpenAPI"""  # noqa: E501

        self._type = None
        self._score = None
        self._revision = None
        self._worksheet = None
        self._track = None
        self._sharing_mode = None
        self._lock_score_template = None
        self._title = None
        self._description = None
        self._html = None
        self._html_width = None
        self._html_height = None
        self._url = None
        self._thumbnail_url = None
        self._thumbnail_width = None
        self._thumbnail_height = None
        self._author_name = None
        self._author_url = None
        self._icon_url = None
        self._mime_type = None
        self._google_drive_file_id = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if score is not None:
            self.score = score
        if revision is not None:
            self.revision = revision
        if worksheet is not None:
            self.worksheet = worksheet
        if track is not None:
            self.track = track
        if sharing_mode is not None:
            self.sharing_mode = sharing_mode
        if lock_score_template is not None:
            self.lock_score_template = lock_score_template
        if title is not None:
            self.title = title
        if description is not None:
            self.description = description
        if html is not None:
            self.html = html
        if html_width is not None:
            self.html_width = html_width
        if html_height is not None:
            self.html_height = html_height
        if url is not None:
            self.url = url
        if thumbnail_url is not None:
            self.thumbnail_url = thumbnail_url
        if thumbnail_width is not None:
            self.thumbnail_width = thumbnail_width
        if thumbnail_height is not None:
            self.thumbnail_height = thumbnail_height
        if author_name is not None:
            self.author_name = author_name
        if author_url is not None:
            self.author_url = author_url
        if icon_url is not None:
            self.icon_url = icon_url
        if mime_type is not None:
            self.mime_type = mime_type
        if google_drive_file_id is not None:
            self.google_drive_file_id = google_drive_file_id

    @property
    def type(self):
        """Gets the type of this MediaAttachment.  # noqa: E501

        The type of the assignment resolved: * `rich`, `photo`, `video` are attachment types that are automatically resolved from a `link` attachment. * A `flat` attachment is a score document where the unique identifier will be specified in the `score` property. Its sharing mode will be provided in the `sharingMode` property.   # noqa: E501

        :return: The type of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this MediaAttachment.

        The type of the assignment resolved: * `rich`, `photo`, `video` are attachment types that are automatically resolved from a `link` attachment. * A `flat` attachment is a score document where the unique identifier will be specified in the `score` property. Its sharing mode will be provided in the `sharingMode` property.   # noqa: E501

        :param type: The type of this MediaAttachment.  # noqa: E501
        :type: str
        """
        allowed_values = ["rich", "photo", "video", "link", "flat", "googleDrive", "worksheet", "performance"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def score(self):
        """Gets the score of this MediaAttachment.  # noqa: E501

        An unique Flat score identifier  # noqa: E501

        :return: The score of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this MediaAttachment.

        An unique Flat score identifier  # noqa: E501

        :param score: The score of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._score = score

    @property
    def revision(self):
        """Gets the revision of this MediaAttachment.  # noqa: E501

        An unique revision identifier of a score  # noqa: E501

        :return: The revision of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this MediaAttachment.

        An unique revision identifier of a score  # noqa: E501

        :param revision: The revision of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._revision = revision

    @property
    def worksheet(self):
        """Gets the worksheet of this MediaAttachment.  # noqa: E501

        An unique worksheet identifier  # noqa: E501

        :return: The worksheet of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._worksheet

    @worksheet.setter
    def worksheet(self, worksheet):
        """Sets the worksheet of this MediaAttachment.

        An unique worksheet identifier  # noqa: E501

        :param worksheet: The worksheet of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._worksheet = worksheet

    @property
    def track(self):
        """Gets the track of this MediaAttachment.  # noqa: E501

        A unique track identifier  # noqa: E501

        :return: The track of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._track

    @track.setter
    def track(self, track):
        """Sets the track of this MediaAttachment.

        A unique track identifier  # noqa: E501

        :param track: The track of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._track = track

    @property
    def sharing_mode(self):
        """Gets the sharing_mode of this MediaAttachment.  # noqa: E501


        :return: The sharing_mode of this MediaAttachment.  # noqa: E501
        :rtype: MediaScoreSharingMode
        """
        return self._sharing_mode

    @sharing_mode.setter
    def sharing_mode(self, sharing_mode):
        """Sets the sharing_mode of this MediaAttachment.


        :param sharing_mode: The sharing_mode of this MediaAttachment.  # noqa: E501
        :type: MediaScoreSharingMode
        """

        self._sharing_mode = sharing_mode

    @property
    def lock_score_template(self):
        """Gets the lock_score_template of this MediaAttachment.  # noqa: E501

        To be used with a score attached in `sharingMode` `copy` (score used as template). If true, students won't be able to change the original notes of the template.  # noqa: E501

        :return: The lock_score_template of this MediaAttachment.  # noqa: E501
        :rtype: bool
        """
        return self._lock_score_template

    @lock_score_template.setter
    def lock_score_template(self, lock_score_template):
        """Sets the lock_score_template of this MediaAttachment.

        To be used with a score attached in `sharingMode` `copy` (score used as template). If true, students won't be able to change the original notes of the template.  # noqa: E501

        :param lock_score_template: The lock_score_template of this MediaAttachment.  # noqa: E501
        :type: bool
        """

        self._lock_score_template = lock_score_template

    @property
    def title(self):
        """Gets the title of this MediaAttachment.  # noqa: E501

        The resolved title of the attachment  # noqa: E501

        :return: The title of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this MediaAttachment.

        The resolved title of the attachment  # noqa: E501

        :param title: The title of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def description(self):
        """Gets the description of this MediaAttachment.  # noqa: E501

        The resolved description of the attachment  # noqa: E501

        :return: The description of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this MediaAttachment.

        The resolved description of the attachment  # noqa: E501

        :param description: The description of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def html(self):
        """Gets the html of this MediaAttachment.  # noqa: E501

        If the attachment type is `rich` or `video`, the HTML code of the media to display   # noqa: E501

        :return: The html of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._html

    @html.setter
    def html(self, html):
        """Sets the html of this MediaAttachment.

        If the attachment type is `rich` or `video`, the HTML code of the media to display   # noqa: E501

        :param html: The html of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._html = html

    @property
    def html_width(self):
        """Gets the html_width of this MediaAttachment.  # noqa: E501

        If the `html` is available, the width of the widget  # noqa: E501

        :return: The html_width of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._html_width

    @html_width.setter
    def html_width(self, html_width):
        """Sets the html_width of this MediaAttachment.

        If the `html` is available, the width of the widget  # noqa: E501

        :param html_width: The html_width of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._html_width = html_width

    @property
    def html_height(self):
        """Gets the html_height of this MediaAttachment.  # noqa: E501

        If the `html` is available, the height of the widget  # noqa: E501

        :return: The html_height of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._html_height

    @html_height.setter
    def html_height(self, html_height):
        """Sets the html_height of this MediaAttachment.

        If the `html` is available, the height of the widget  # noqa: E501

        :param html_height: The html_height of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._html_height = html_height

    @property
    def url(self):
        """Gets the url of this MediaAttachment.  # noqa: E501

        The url of the attachment  # noqa: E501

        :return: The url of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this MediaAttachment.

        The url of the attachment  # noqa: E501

        :param url: The url of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def thumbnail_url(self):
        """Gets the thumbnail_url of this MediaAttachment.  # noqa: E501

        If the attachment type is `rich`, `video`, `photo` or `link`, a displayable thumbnail for this attachment   # noqa: E501

        :return: The thumbnail_url of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._thumbnail_url

    @thumbnail_url.setter
    def thumbnail_url(self, thumbnail_url):
        """Sets the thumbnail_url of this MediaAttachment.

        If the attachment type is `rich`, `video`, `photo` or `link`, a displayable thumbnail for this attachment   # noqa: E501

        :param thumbnail_url: The thumbnail_url of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._thumbnail_url = thumbnail_url

    @property
    def thumbnail_width(self):
        """Gets the thumbnail_width of this MediaAttachment.  # noqa: E501

        If the `thumbnailUrl` is available, the width of the thumbnail   # noqa: E501

        :return: The thumbnail_width of this MediaAttachment.  # noqa: E501
        :rtype: int
        """
        return self._thumbnail_width

    @thumbnail_width.setter
    def thumbnail_width(self, thumbnail_width):
        """Sets the thumbnail_width of this MediaAttachment.

        If the `thumbnailUrl` is available, the width of the thumbnail   # noqa: E501

        :param thumbnail_width: The thumbnail_width of this MediaAttachment.  # noqa: E501
        :type: int
        """

        self._thumbnail_width = thumbnail_width

    @property
    def thumbnail_height(self):
        """Gets the thumbnail_height of this MediaAttachment.  # noqa: E501

        If the `thumbnailUrl` is available, the width of the thumbnail   # noqa: E501

        :return: The thumbnail_height of this MediaAttachment.  # noqa: E501
        :rtype: int
        """
        return self._thumbnail_height

    @thumbnail_height.setter
    def thumbnail_height(self, thumbnail_height):
        """Sets the thumbnail_height of this MediaAttachment.

        If the `thumbnailUrl` is available, the width of the thumbnail   # noqa: E501

        :param thumbnail_height: The thumbnail_height of this MediaAttachment.  # noqa: E501
        :type: int
        """

        self._thumbnail_height = thumbnail_height

    @property
    def author_name(self):
        """Gets the author_name of this MediaAttachment.  # noqa: E501

        The resolved author name of the attachment  # noqa: E501

        :return: The author_name of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._author_name

    @author_name.setter
    def author_name(self, author_name):
        """Sets the author_name of this MediaAttachment.

        The resolved author name of the attachment  # noqa: E501

        :param author_name: The author_name of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._author_name = author_name

    @property
    def author_url(self):
        """Gets the author_url of this MediaAttachment.  # noqa: E501

        The resolved author url of the attachment  # noqa: E501

        :return: The author_url of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._author_url

    @author_url.setter
    def author_url(self, author_url):
        """Sets the author_url of this MediaAttachment.

        The resolved author url of the attachment  # noqa: E501

        :param author_url: The author_url of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._author_url = author_url

    @property
    def icon_url(self):
        """Gets the icon_url of this MediaAttachment.  # noqa: E501

        The URL of the icon  # noqa: E501

        :return: The icon_url of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._icon_url

    @icon_url.setter
    def icon_url(self, icon_url):
        """Sets the icon_url of this MediaAttachment.

        The URL of the icon  # noqa: E501

        :param icon_url: The icon_url of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._icon_url = icon_url

    @property
    def mime_type(self):
        """Gets the mime_type of this MediaAttachment.  # noqa: E501

        The mine type of the file  # noqa: E501

        :return: The mime_type of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """Sets the mime_type of this MediaAttachment.

        The mine type of the file  # noqa: E501

        :param mime_type: The mime_type of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._mime_type = mime_type

    @property
    def google_drive_file_id(self):
        """Gets the google_drive_file_id of this MediaAttachment.  # noqa: E501

        The ID of the Google Drive File  # noqa: E501

        :return: The google_drive_file_id of this MediaAttachment.  # noqa: E501
        :rtype: str
        """
        return self._google_drive_file_id

    @google_drive_file_id.setter
    def google_drive_file_id(self, google_drive_file_id):
        """Sets the google_drive_file_id of this MediaAttachment.

        The ID of the Google Drive File  # noqa: E501

        :param google_drive_file_id: The google_drive_file_id of this MediaAttachment.  # noqa: E501
        :type: str
        """

        self._google_drive_file_id = google_drive_file_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaAttachment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
