# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class CollectionCapabilities(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'can_edit': 'bool',
        'can_share': 'bool',
        'can_delete': 'bool',
        'can_add_scores': 'bool',
        'can_delete_scores': 'bool'
    }

    attribute_map = {
        'can_edit': 'canEdit',
        'can_share': 'canShare',
        'can_delete': 'canDelete',
        'can_add_scores': 'canAddScores',
        'can_delete_scores': 'canDeleteScores'
    }

    def __init__(self, can_edit=None, can_share=None, can_delete=None, can_add_scores=None, can_delete_scores=None):  # noqa: E501
        """CollectionCapabilities - a model defined in OpenAPI"""  # noqa: E501

        self._can_edit = None
        self._can_share = None
        self._can_delete = None
        self._can_add_scores = None
        self._can_delete_scores = None
        self.discriminator = None

        if can_edit is not None:
            self.can_edit = can_edit
        if can_share is not None:
            self.can_share = can_share
        if can_delete is not None:
            self.can_delete = can_delete
        if can_add_scores is not None:
            self.can_add_scores = can_add_scores
        if can_delete_scores is not None:
            self.can_delete_scores = can_delete_scores

    @property
    def can_edit(self):
        """Gets the can_edit of this CollectionCapabilities.  # noqa: E501

        Whether the current user can modify the metadata for the collection   # noqa: E501

        :return: The can_edit of this CollectionCapabilities.  # noqa: E501
        :rtype: bool
        """
        return self._can_edit

    @can_edit.setter
    def can_edit(self, can_edit):
        """Sets the can_edit of this CollectionCapabilities.

        Whether the current user can modify the metadata for the collection   # noqa: E501

        :param can_edit: The can_edit of this CollectionCapabilities.  # noqa: E501
        :type: bool
        """

        self._can_edit = can_edit

    @property
    def can_share(self):
        """Gets the can_share of this CollectionCapabilities.  # noqa: E501

        Whether the current user can modify the sharing settings for the collection   # noqa: E501

        :return: The can_share of this CollectionCapabilities.  # noqa: E501
        :rtype: bool
        """
        return self._can_share

    @can_share.setter
    def can_share(self, can_share):
        """Sets the can_share of this CollectionCapabilities.

        Whether the current user can modify the sharing settings for the collection   # noqa: E501

        :param can_share: The can_share of this CollectionCapabilities.  # noqa: E501
        :type: bool
        """

        self._can_share = can_share

    @property
    def can_delete(self):
        """Gets the can_delete of this CollectionCapabilities.  # noqa: E501

        Whether the current user can delete the collection   # noqa: E501

        :return: The can_delete of this CollectionCapabilities.  # noqa: E501
        :rtype: bool
        """
        return self._can_delete

    @can_delete.setter
    def can_delete(self, can_delete):
        """Sets the can_delete of this CollectionCapabilities.

        Whether the current user can delete the collection   # noqa: E501

        :param can_delete: The can_delete of this CollectionCapabilities.  # noqa: E501
        :type: bool
        """

        self._can_delete = can_delete

    @property
    def can_add_scores(self):
        """Gets the can_add_scores of this CollectionCapabilities.  # noqa: E501

        Whether the current user can add scores to the collection  If this collection has the `type` `trash`, this property will be set to `false`. Use `DELETE /v2/scores/{score}` to trash a score.   # noqa: E501

        :return: The can_add_scores of this CollectionCapabilities.  # noqa: E501
        :rtype: bool
        """
        return self._can_add_scores

    @can_add_scores.setter
    def can_add_scores(self, can_add_scores):
        """Sets the can_add_scores of this CollectionCapabilities.

        Whether the current user can add scores to the collection  If this collection has the `type` `trash`, this property will be set to `false`. Use `DELETE /v2/scores/{score}` to trash a score.   # noqa: E501

        :param can_add_scores: The can_add_scores of this CollectionCapabilities.  # noqa: E501
        :type: bool
        """

        self._can_add_scores = can_add_scores

    @property
    def can_delete_scores(self):
        """Gets the can_delete_scores of this CollectionCapabilities.  # noqa: E501

        Whether the current user can delete scores from the collection  If this collection has the `type` `trash`, this property will be set to `false`. Use `POST /v2/scores/{score}/untrash` to restore a score.   # noqa: E501

        :return: The can_delete_scores of this CollectionCapabilities.  # noqa: E501
        :rtype: bool
        """
        return self._can_delete_scores

    @can_delete_scores.setter
    def can_delete_scores(self, can_delete_scores):
        """Sets the can_delete_scores of this CollectionCapabilities.

        Whether the current user can delete scores from the collection  If this collection has the `type` `trash`, this property will be set to `false`. Use `POST /v2/scores/{score}/untrash` to restore a score.   # noqa: E501

        :param can_delete_scores: The can_delete_scores of this CollectionCapabilities.  # noqa: E501
        :type: bool
        """

        self._can_delete_scores = can_delete_scores

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectionCapabilities):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
