# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Collection(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'title': 'str',
        'html_url': 'str',
        'type': 'CollectionType',
        'privacy': 'CollectionPrivacy',
        'sharing_key': 'str',
        'app': 'CollectionApp',
        'creation_date': 'datetime',
        'user': 'UserPublicSummary',
        'rights': 'ResourceRights',
        'collaborators': 'list[ResourceCollaborator]',
        'capabilities': 'CollectionCapabilities',
        'collections': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'title': 'title',
        'html_url': 'htmlUrl',
        'type': 'type',
        'privacy': 'privacy',
        'sharing_key': 'sharingKey',
        'app': 'app',
        'creation_date': 'creationDate',
        'user': 'user',
        'rights': 'rights',
        'collaborators': 'collaborators',
        'capabilities': 'capabilities',
        'collections': 'collections'
    }

    def __init__(self, id=None, title=None, html_url=None, type=None, privacy=None, sharing_key=None, app=None, creation_date=None, user=None, rights=None, collaborators=None, capabilities=None, collections=None):  # noqa: E501
        """Collection - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._title = None
        self._html_url = None
        self._type = None
        self._privacy = None
        self._sharing_key = None
        self._app = None
        self._creation_date = None
        self._user = None
        self._rights = None
        self._collaborators = None
        self._capabilities = None
        self._collections = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if title is not None:
            self.title = title
        if html_url is not None:
            self.html_url = html_url
        if type is not None:
            self.type = type
        if privacy is not None:
            self.privacy = privacy
        if sharing_key is not None:
            self.sharing_key = sharing_key
        if app is not None:
            self.app = app
        if creation_date is not None:
            self.creation_date = creation_date
        if user is not None:
            self.user = user
        if rights is not None:
            self.rights = rights
        if collaborators is not None:
            self.collaborators = collaborators
        if capabilities is not None:
            self.capabilities = capabilities
        if collections is not None:
            self.collections = collections

    @property
    def id(self):
        """Gets the id of this Collection.  # noqa: E501

        Unique identifier of the collection  # noqa: E501

        :return: The id of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Collection.

        Unique identifier of the collection  # noqa: E501

        :param id: The id of this Collection.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def title(self):
        """Gets the title of this Collection.  # noqa: E501

        The title of the collection  # noqa: E501

        :return: The title of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Collection.

        The title of the collection  # noqa: E501

        :param title: The title of this Collection.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def html_url(self):
        """Gets the html_url of this Collection.  # noqa: E501

        The url where the collection can be viewed in a web browser  # noqa: E501

        :return: The html_url of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """Sets the html_url of this Collection.

        The url where the collection can be viewed in a web browser  # noqa: E501

        :param html_url: The html_url of this Collection.  # noqa: E501
        :type: str
        """

        self._html_url = html_url

    @property
    def type(self):
        """Gets the type of this Collection.  # noqa: E501


        :return: The type of this Collection.  # noqa: E501
        :rtype: CollectionType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Collection.


        :param type: The type of this Collection.  # noqa: E501
        :type: CollectionType
        """

        self._type = type

    @property
    def privacy(self):
        """Gets the privacy of this Collection.  # noqa: E501


        :return: The privacy of this Collection.  # noqa: E501
        :rtype: CollectionPrivacy
        """
        return self._privacy

    @privacy.setter
    def privacy(self, privacy):
        """Sets the privacy of this Collection.


        :param privacy: The privacy of this Collection.  # noqa: E501
        :type: CollectionPrivacy
        """

        self._privacy = privacy

    @property
    def sharing_key(self):
        """Gets the sharing_key of this Collection.  # noqa: E501

        The private sharing key of the collection (available when the `privacy` mode is set to `privateLink`)  # noqa: E501

        :return: The sharing_key of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._sharing_key

    @sharing_key.setter
    def sharing_key(self, sharing_key):
        """Sets the sharing_key of this Collection.

        The private sharing key of the collection (available when the `privacy` mode is set to `privateLink`)  # noqa: E501

        :param sharing_key: The sharing_key of this Collection.  # noqa: E501
        :type: str
        """

        self._sharing_key = sharing_key

    @property
    def app(self):
        """Gets the app of this Collection.  # noqa: E501


        :return: The app of this Collection.  # noqa: E501
        :rtype: CollectionApp
        """
        return self._app

    @app.setter
    def app(self, app):
        """Sets the app of this Collection.


        :param app: The app of this Collection.  # noqa: E501
        :type: CollectionApp
        """

        self._app = app

    @property
    def creation_date(self):
        """Gets the creation_date of this Collection.  # noqa: E501

        The date when the collection was created  # noqa: E501

        :return: The creation_date of this Collection.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this Collection.

        The date when the collection was created  # noqa: E501

        :param creation_date: The creation_date of this Collection.  # noqa: E501
        :type: datetime
        """

        self._creation_date = creation_date

    @property
    def user(self):
        """Gets the user of this Collection.  # noqa: E501


        :return: The user of this Collection.  # noqa: E501
        :rtype: UserPublicSummary
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this Collection.


        :param user: The user of this Collection.  # noqa: E501
        :type: UserPublicSummary
        """

        self._user = user

    @property
    def rights(self):
        """Gets the rights of this Collection.  # noqa: E501


        :return: The rights of this Collection.  # noqa: E501
        :rtype: ResourceRights
        """
        return self._rights

    @rights.setter
    def rights(self, rights):
        """Sets the rights of this Collection.


        :param rights: The rights of this Collection.  # noqa: E501
        :type: ResourceRights
        """

        self._rights = rights

    @property
    def collaborators(self):
        """Gets the collaborators of this Collection.  # noqa: E501

        The list of the collaborators of the collection  # noqa: E501

        :return: The collaborators of this Collection.  # noqa: E501
        :rtype: list[ResourceCollaborator]
        """
        return self._collaborators

    @collaborators.setter
    def collaborators(self, collaborators):
        """Sets the collaborators of this Collection.

        The list of the collaborators of the collection  # noqa: E501

        :param collaborators: The collaborators of this Collection.  # noqa: E501
        :type: list[ResourceCollaborator]
        """

        self._collaborators = collaborators

    @property
    def capabilities(self):
        """Gets the capabilities of this Collection.  # noqa: E501


        :return: The capabilities of this Collection.  # noqa: E501
        :rtype: CollectionCapabilities
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """Sets the capabilities of this Collection.


        :param capabilities: The capabilities of this Collection.  # noqa: E501
        :type: CollectionCapabilities
        """

        self._capabilities = capabilities

    @property
    def collections(self):
        """Gets the collections of this Collection.  # noqa: E501

        The List of parent collections, which includes all the collections this score is included. Please note that you might not have access to all of them.  # noqa: E501

        :return: The collections of this Collection.  # noqa: E501
        :rtype: list[str]
        """
        return self._collections

    @collections.setter
    def collections(self, collections):
        """Sets the collections of this Collection.

        The List of parent collections, which includes all the collections this score is included. Please note that you might not have access to all of them.  # noqa: E501

        :param collections: The collections of this Collection.  # noqa: E501
        :type: list[str]
        """

        self._collections = collections

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Collection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
