# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ClassAttachmentCreation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'score': 'str',
        'worksheet': 'str',
        'sharing_mode': 'MediaScoreSharingMode',
        'lock_score_template': 'bool',
        'url': 'str',
        'google_drive_file_id': 'str'
    }

    attribute_map = {
        'type': 'type',
        'score': 'score',
        'worksheet': 'worksheet',
        'sharing_mode': 'sharingMode',
        'lock_score_template': 'lockScoreTemplate',
        'url': 'url',
        'google_drive_file_id': 'googleDriveFileId'
    }

    def __init__(self, type=None, score=None, worksheet=None, sharing_mode=None, lock_score_template=None, url=None, google_drive_file_id=None):  # noqa: E501
        """ClassAttachmentCreation - a model defined in OpenAPI"""  # noqa: E501

        self._type = None
        self._score = None
        self._worksheet = None
        self._sharing_mode = None
        self._lock_score_template = None
        self._url = None
        self._google_drive_file_id = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if score is not None:
            self.score = score
        if worksheet is not None:
            self.worksheet = worksheet
        if sharing_mode is not None:
            self.sharing_mode = sharing_mode
        if lock_score_template is not None:
            self.lock_score_template = lock_score_template
        if url is not None:
            self.url = url
        if google_drive_file_id is not None:
            self.google_drive_file_id = google_drive_file_id

    @property
    def type(self):
        """Gets the type of this ClassAttachmentCreation.  # noqa: E501

        The type of the attachment posted  # noqa: E501

        :return: The type of this ClassAttachmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ClassAttachmentCreation.

        The type of the attachment posted  # noqa: E501

        :param type: The type of this ClassAttachmentCreation.  # noqa: E501
        :type: str
        """
        allowed_values = ["flat", "link", "googleDrive", "worksheet"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def score(self):
        """Gets the score of this ClassAttachmentCreation.  # noqa: E501

        A unique Flat score identifier. The user creating the assignment must at least have read access to the document. If the user has admin rights, new group permissions will be automatically added for the teachers and students of the class.   # noqa: E501

        :return: The score of this ClassAttachmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this ClassAttachmentCreation.

        A unique Flat score identifier. The user creating the assignment must at least have read access to the document. If the user has admin rights, new group permissions will be automatically added for the teachers and students of the class.   # noqa: E501

        :param score: The score of this ClassAttachmentCreation.  # noqa: E501
        :type: str
        """

        self._score = score

    @property
    def worksheet(self):
        """Gets the worksheet of this ClassAttachmentCreation.  # noqa: E501

        An unique worksheet identifier  # noqa: E501

        :return: The worksheet of this ClassAttachmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._worksheet

    @worksheet.setter
    def worksheet(self, worksheet):
        """Sets the worksheet of this ClassAttachmentCreation.

        An unique worksheet identifier  # noqa: E501

        :param worksheet: The worksheet of this ClassAttachmentCreation.  # noqa: E501
        :type: str
        """

        self._worksheet = worksheet

    @property
    def sharing_mode(self):
        """Gets the sharing_mode of this ClassAttachmentCreation.  # noqa: E501


        :return: The sharing_mode of this ClassAttachmentCreation.  # noqa: E501
        :rtype: MediaScoreSharingMode
        """
        return self._sharing_mode

    @sharing_mode.setter
    def sharing_mode(self, sharing_mode):
        """Sets the sharing_mode of this ClassAttachmentCreation.


        :param sharing_mode: The sharing_mode of this ClassAttachmentCreation.  # noqa: E501
        :type: MediaScoreSharingMode
        """

        self._sharing_mode = sharing_mode

    @property
    def lock_score_template(self):
        """Gets the lock_score_template of this ClassAttachmentCreation.  # noqa: E501

        To be used with a score attached in `sharingMode` `copy` (score used as template). If true, students won't be able to change the original notes of the template.  # noqa: E501

        :return: The lock_score_template of this ClassAttachmentCreation.  # noqa: E501
        :rtype: bool
        """
        return self._lock_score_template

    @lock_score_template.setter
    def lock_score_template(self, lock_score_template):
        """Sets the lock_score_template of this ClassAttachmentCreation.

        To be used with a score attached in `sharingMode` `copy` (score used as template). If true, students won't be able to change the original notes of the template.  # noqa: E501

        :param lock_score_template: The lock_score_template of this ClassAttachmentCreation.  # noqa: E501
        :type: bool
        """

        self._lock_score_template = lock_score_template

    @property
    def url(self):
        """Gets the url of this ClassAttachmentCreation.  # noqa: E501

        The URL of the attachment.  # noqa: E501

        :return: The url of this ClassAttachmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ClassAttachmentCreation.

        The URL of the attachment.  # noqa: E501

        :param url: The url of this ClassAttachmentCreation.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def google_drive_file_id(self):
        """Gets the google_drive_file_id of this ClassAttachmentCreation.  # noqa: E501

        The ID of the Google Drive File  # noqa: E501

        :return: The google_drive_file_id of this ClassAttachmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._google_drive_file_id

    @google_drive_file_id.setter
    def google_drive_file_id(self, google_drive_file_id):
        """Sets the google_drive_file_id of this ClassAttachmentCreation.

        The ID of the Google Drive File  # noqa: E501

        :param google_drive_file_id: The google_drive_file_id of this ClassAttachmentCreation.  # noqa: E501
        :type: str
        """

        self._google_drive_file_id = google_drive_file_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClassAttachmentCreation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
