# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AssignmentSubmissionUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attachments': 'list[ClassAttachmentCreation]',
        'submit': 'bool',
        'draft_grade': 'float',
        'grade': 'float',
        'exercises_ids': 'list[str]',
        '_return': 'bool',
        'comments': 'AssignmentSubmissionUpdateComments'
    }

    attribute_map = {
        'attachments': 'attachments',
        'submit': 'submit',
        'draft_grade': 'draftGrade',
        'grade': 'grade',
        'exercises_ids': 'exercisesIds',
        '_return': 'return',
        'comments': 'comments'
    }

    def __init__(self, attachments=None, submit=None, draft_grade=None, grade=None, exercises_ids=None, _return=None, comments=None):  # noqa: E501
        """AssignmentSubmissionUpdate - a model defined in OpenAPI"""  # noqa: E501

        self._attachments = None
        self._submit = None
        self._draft_grade = None
        self._grade = None
        self._exercises_ids = None
        self.__return = None
        self._comments = None
        self.discriminator = None

        if attachments is not None:
            self.attachments = attachments
        if submit is not None:
            self.submit = submit
        self.draft_grade = draft_grade
        self.grade = grade
        self.exercises_ids = exercises_ids
        if _return is not None:
            self._return = _return
        if comments is not None:
            self.comments = comments

    @property
    def attachments(self):
        """Gets the attachments of this AssignmentSubmissionUpdate.  # noqa: E501


        :return: The attachments of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: list[ClassAttachmentCreation]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this AssignmentSubmissionUpdate.


        :param attachments: The attachments of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: list[ClassAttachmentCreation]
        """

        self._attachments = attachments

    @property
    def submit(self):
        """Gets the submit of this AssignmentSubmissionUpdate.  # noqa: E501

        If `true`, the submission will be marked as done  # noqa: E501

        :return: The submit of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._submit

    @submit.setter
    def submit(self, submit):
        """Sets the submit of this AssignmentSubmissionUpdate.

        If `true`, the submission will be marked as done  # noqa: E501

        :param submit: The submit of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: bool
        """

        self._submit = submit

    @property
    def draft_grade(self):
        """Gets the draft_grade of this AssignmentSubmissionUpdate.  # noqa: E501

        Optional grade. If unset, no grade was set. This value is only visible by the teacher, and we will be set to `grade` once the teacher returns the submission  # noqa: E501

        :return: The draft_grade of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: float
        """
        return self._draft_grade

    @draft_grade.setter
    def draft_grade(self, draft_grade):
        """Sets the draft_grade of this AssignmentSubmissionUpdate.

        Optional grade. If unset, no grade was set. This value is only visible by the teacher, and we will be set to `grade` once the teacher returns the submission  # noqa: E501

        :param draft_grade: The draft_grade of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: float
        """
        if draft_grade is not None and draft_grade > 100:  # noqa: E501
            raise ValueError("Invalid value for `draft_grade`, must be a value less than or equal to `100`")  # noqa: E501
        if draft_grade is not None and draft_grade < 0:  # noqa: E501
            raise ValueError("Invalid value for `draft_grade`, must be a value greater than or equal to `0`")  # noqa: E501

        self._draft_grade = draft_grade

    @property
    def grade(self):
        """Gets the grade of this AssignmentSubmissionUpdate.  # noqa: E501

        Optional grade. If unset, no grade was set.  # noqa: E501

        :return: The grade of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: float
        """
        return self._grade

    @grade.setter
    def grade(self, grade):
        """Sets the grade of this AssignmentSubmissionUpdate.

        Optional grade. If unset, no grade was set.  # noqa: E501

        :param grade: The grade of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: float
        """
        if grade is not None and grade > 100:  # noqa: E501
            raise ValueError("Invalid value for `grade`, must be a value less than or equal to `100`")  # noqa: E501
        if grade is not None and grade < 0:  # noqa: E501
            raise ValueError("Invalid value for `grade`, must be a value greater than or equal to `0`")  # noqa: E501

        self._grade = grade

    @property
    def exercises_ids(self):
        """Gets the exercises_ids of this AssignmentSubmissionUpdate.  # noqa: E501

        The ids of exercises when they need to be in a specific order  # noqa: E501

        :return: The exercises_ids of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: list[str]
        """
        return self._exercises_ids

    @exercises_ids.setter
    def exercises_ids(self, exercises_ids):
        """Sets the exercises_ids of this AssignmentSubmissionUpdate.

        The ids of exercises when they need to be in a specific order  # noqa: E501

        :param exercises_ids: The exercises_ids of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: list[str]
        """

        self._exercises_ids = exercises_ids

    @property
    def _return(self):
        """Gets the _return of this AssignmentSubmissionUpdate.  # noqa: E501

        If `true`, the submission will be marked as done  # noqa: E501

        :return: The _return of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: bool
        """
        return self.__return

    @_return.setter
    def _return(self, _return):
        """Sets the _return of this AssignmentSubmissionUpdate.

        If `true`, the submission will be marked as done  # noqa: E501

        :param _return: The _return of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: bool
        """

        self.__return = _return

    @property
    def comments(self):
        """Gets the comments of this AssignmentSubmissionUpdate.  # noqa: E501


        :return: The comments of this AssignmentSubmissionUpdate.  # noqa: E501
        :rtype: AssignmentSubmissionUpdateComments
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """Sets the comments of this AssignmentSubmissionUpdate.


        :param comments: The comments of this AssignmentSubmissionUpdate.  # noqa: E501
        :type: AssignmentSubmissionUpdateComments
        """

        self._comments = comments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignmentSubmissionUpdate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
