# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AssignmentSubmissionHistory(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'date': 'datetime',
        'users': 'list[str]',
        'state': 'AssignmentSubmissionState',
        'draft_grade': 'float',
        'grade': 'float',
        'max_points': 'float',
        'attachment': 'AssignmentSubmissionHistoryAttachment'
    }

    attribute_map = {
        'date': 'date',
        'users': 'users',
        'state': 'state',
        'draft_grade': 'draftGrade',
        'grade': 'grade',
        'max_points': 'maxPoints',
        'attachment': 'attachment'
    }

    def __init__(self, date=None, users=None, state=None, draft_grade=None, grade=None, max_points=None, attachment=None):  # noqa: E501
        """AssignmentSubmissionHistory - a model defined in OpenAPI"""  # noqa: E501

        self._date = None
        self._users = None
        self._state = None
        self._draft_grade = None
        self._grade = None
        self._max_points = None
        self._attachment = None
        self.discriminator = None

        if date is not None:
            self.date = date
        if users is not None:
            self.users = users
        if state is not None:
            self.state = state
        if draft_grade is not None:
            self.draft_grade = draft_grade
        if grade is not None:
            self.grade = grade
        if max_points is not None:
            self.max_points = max_points
        if attachment is not None:
            self.attachment = attachment

    @property
    def date(self):
        """Gets the date of this AssignmentSubmissionHistory.  # noqa: E501

        The date when the submission was changed  # noqa: E501

        :return: The date of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this AssignmentSubmissionHistory.

        The date when the submission was changed  # noqa: E501

        :param date: The date of this AssignmentSubmissionHistory.  # noqa: E501
        :type: datetime
        """

        self._date = date

    @property
    def users(self):
        """Gets the users of this AssignmentSubmissionHistory.  # noqa: E501

        The user(s) unique identifier(s) who made the change  # noqa: E501

        :return: The users of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: list[str]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this AssignmentSubmissionHistory.

        The user(s) unique identifier(s) who made the change  # noqa: E501

        :param users: The users of this AssignmentSubmissionHistory.  # noqa: E501
        :type: list[str]
        """

        self._users = users

    @property
    def state(self):
        """Gets the state of this AssignmentSubmissionHistory.  # noqa: E501


        :return: The state of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: AssignmentSubmissionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this AssignmentSubmissionHistory.


        :param state: The state of this AssignmentSubmissionHistory.  # noqa: E501
        :type: AssignmentSubmissionState
        """

        self._state = state

    @property
    def draft_grade(self):
        """Gets the draft_grade of this AssignmentSubmissionHistory.  # noqa: E501

        The numerator of the grade at this time in the submission grade history  # noqa: E501

        :return: The draft_grade of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: float
        """
        return self._draft_grade

    @draft_grade.setter
    def draft_grade(self, draft_grade):
        """Sets the draft_grade of this AssignmentSubmissionHistory.

        The numerator of the grade at this time in the submission grade history  # noqa: E501

        :param draft_grade: The draft_grade of this AssignmentSubmissionHistory.  # noqa: E501
        :type: float
        """

        self._draft_grade = draft_grade

    @property
    def grade(self):
        """Gets the grade of this AssignmentSubmissionHistory.  # noqa: E501

        The numerator of the grade at this time in the submission grade history  # noqa: E501

        :return: The grade of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: float
        """
        return self._grade

    @grade.setter
    def grade(self, grade):
        """Sets the grade of this AssignmentSubmissionHistory.

        The numerator of the grade at this time in the submission grade history  # noqa: E501

        :param grade: The grade of this AssignmentSubmissionHistory.  # noqa: E501
        :type: float
        """

        self._grade = grade

    @property
    def max_points(self):
        """Gets the max_points of this AssignmentSubmissionHistory.  # noqa: E501

        The denominator of the grade at this time in the submission grade history  # noqa: E501

        :return: The max_points of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: float
        """
        return self._max_points

    @max_points.setter
    def max_points(self, max_points):
        """Sets the max_points of this AssignmentSubmissionHistory.

        The denominator of the grade at this time in the submission grade history  # noqa: E501

        :param max_points: The max_points of this AssignmentSubmissionHistory.  # noqa: E501
        :type: float
        """

        self._max_points = max_points

    @property
    def attachment(self):
        """Gets the attachment of this AssignmentSubmissionHistory.  # noqa: E501


        :return: The attachment of this AssignmentSubmissionHistory.  # noqa: E501
        :rtype: AssignmentSubmissionHistoryAttachment
        """
        return self._attachment

    @attachment.setter
    def attachment(self, attachment):
        """Sets the attachment of this AssignmentSubmissionHistory.


        :param attachment: The attachment of this AssignmentSubmissionHistory.  # noqa: E501
        :type: AssignmentSubmissionHistoryAttachment
        """

        self._attachment = attachment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignmentSubmissionHistory):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
