# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AssignmentSubmission(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'state': 'AssignmentSubmissionState',
        'classroom': 'str',
        'assignment': 'str',
        'creator': 'str',
        'creation_date': 'str',
        'attachments': 'list[MediaAttachment]',
        'submission_date': 'str',
        'return_date': 'str',
        'return_creator': 'str',
        'grade': 'float',
        'draft_grade': 'float',
        'max_points': 'float',
        'exercises_ids': 'list[str]',
        'google_classroom': 'GoogleClassroomSubmission',
        'microsoft_graph': 'MicrosoftGraphSubmission'
    }

    attribute_map = {
        'id': 'id',
        'state': 'state',
        'classroom': 'classroom',
        'assignment': 'assignment',
        'creator': 'creator',
        'creation_date': 'creationDate',
        'attachments': 'attachments',
        'submission_date': 'submissionDate',
        'return_date': 'returnDate',
        'return_creator': 'returnCreator',
        'grade': 'grade',
        'draft_grade': 'draftGrade',
        'max_points': 'maxPoints',
        'exercises_ids': 'exercisesIds',
        'google_classroom': 'googleClassroom',
        'microsoft_graph': 'microsoftGraph'
    }

    def __init__(self, id=None, state=None, classroom=None, assignment=None, creator=None, creation_date=None, attachments=None, submission_date=None, return_date=None, return_creator=None, grade=None, draft_grade=None, max_points=None, exercises_ids=None, google_classroom=None, microsoft_graph=None):  # noqa: E501
        """AssignmentSubmission - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._state = None
        self._classroom = None
        self._assignment = None
        self._creator = None
        self._creation_date = None
        self._attachments = None
        self._submission_date = None
        self._return_date = None
        self._return_creator = None
        self._grade = None
        self._draft_grade = None
        self._max_points = None
        self._exercises_ids = None
        self._google_classroom = None
        self._microsoft_graph = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if state is not None:
            self.state = state
        if classroom is not None:
            self.classroom = classroom
        if assignment is not None:
            self.assignment = assignment
        if creator is not None:
            self.creator = creator
        if creation_date is not None:
            self.creation_date = creation_date
        if attachments is not None:
            self.attachments = attachments
        if submission_date is not None:
            self.submission_date = submission_date
        if return_date is not None:
            self.return_date = return_date
        if return_creator is not None:
            self.return_creator = return_creator
        self.grade = grade
        self.draft_grade = draft_grade
        if max_points is not None:
            self.max_points = max_points
        self.exercises_ids = exercises_ids
        if google_classroom is not None:
            self.google_classroom = google_classroom
        if microsoft_graph is not None:
            self.microsoft_graph = microsoft_graph

    @property
    def id(self):
        """Gets the id of this AssignmentSubmission.  # noqa: E501

        Unique identifier of the submission  # noqa: E501

        :return: The id of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AssignmentSubmission.

        Unique identifier of the submission  # noqa: E501

        :param id: The id of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def state(self):
        """Gets the state of this AssignmentSubmission.  # noqa: E501


        :return: The state of this AssignmentSubmission.  # noqa: E501
        :rtype: AssignmentSubmissionState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this AssignmentSubmission.


        :param state: The state of this AssignmentSubmission.  # noqa: E501
        :type: AssignmentSubmissionState
        """

        self._state = state

    @property
    def classroom(self):
        """Gets the classroom of this AssignmentSubmission.  # noqa: E501

        Unique identifier of the classroom where the assignment was posted   # noqa: E501

        :return: The classroom of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._classroom

    @classroom.setter
    def classroom(self, classroom):
        """Sets the classroom of this AssignmentSubmission.

        Unique identifier of the classroom where the assignment was posted   # noqa: E501

        :param classroom: The classroom of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._classroom = classroom

    @property
    def assignment(self):
        """Gets the assignment of this AssignmentSubmission.  # noqa: E501

        Unique identifier of the assignment  # noqa: E501

        :return: The assignment of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment):
        """Sets the assignment of this AssignmentSubmission.

        Unique identifier of the assignment  # noqa: E501

        :param assignment: The assignment of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._assignment = assignment

    @property
    def creator(self):
        """Gets the creator of this AssignmentSubmission.  # noqa: E501

        The User identifier of the student who created the submission  # noqa: E501

        :return: The creator of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this AssignmentSubmission.

        The User identifier of the student who created the submission  # noqa: E501

        :param creator: The creator of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._creator = creator

    @property
    def creation_date(self):
        """Gets the creation_date of this AssignmentSubmission.  # noqa: E501

        The date when the submission was created  # noqa: E501

        :return: The creation_date of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this AssignmentSubmission.

        The date when the submission was created  # noqa: E501

        :param creation_date: The creation_date of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._creation_date = creation_date

    @property
    def attachments(self):
        """Gets the attachments of this AssignmentSubmission.  # noqa: E501


        :return: The attachments of this AssignmentSubmission.  # noqa: E501
        :rtype: list[MediaAttachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this AssignmentSubmission.


        :param attachments: The attachments of this AssignmentSubmission.  # noqa: E501
        :type: list[MediaAttachment]
        """

        self._attachments = attachments

    @property
    def submission_date(self):
        """Gets the submission_date of this AssignmentSubmission.  # noqa: E501

        The date when the student submitted his work  # noqa: E501

        :return: The submission_date of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._submission_date

    @submission_date.setter
    def submission_date(self, submission_date):
        """Sets the submission_date of this AssignmentSubmission.

        The date when the student submitted his work  # noqa: E501

        :param submission_date: The submission_date of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._submission_date = submission_date

    @property
    def return_date(self):
        """Gets the return_date of this AssignmentSubmission.  # noqa: E501

        The date when the teacher returned the work  # noqa: E501

        :return: The return_date of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._return_date

    @return_date.setter
    def return_date(self, return_date):
        """Sets the return_date of this AssignmentSubmission.

        The date when the teacher returned the work  # noqa: E501

        :param return_date: The return_date of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._return_date = return_date

    @property
    def return_creator(self):
        """Gets the return_creator of this AssignmentSubmission.  # noqa: E501

        The User unique identifier of the teacher who returned the submission   # noqa: E501

        :return: The return_creator of this AssignmentSubmission.  # noqa: E501
        :rtype: str
        """
        return self._return_creator

    @return_creator.setter
    def return_creator(self, return_creator):
        """Sets the return_creator of this AssignmentSubmission.

        The User unique identifier of the teacher who returned the submission   # noqa: E501

        :param return_creator: The return_creator of this AssignmentSubmission.  # noqa: E501
        :type: str
        """

        self._return_creator = return_creator

    @property
    def grade(self):
        """Gets the grade of this AssignmentSubmission.  # noqa: E501

        Optional grade. If unset, no grade was set.  # noqa: E501

        :return: The grade of this AssignmentSubmission.  # noqa: E501
        :rtype: float
        """
        return self._grade

    @grade.setter
    def grade(self, grade):
        """Sets the grade of this AssignmentSubmission.

        Optional grade. If unset, no grade was set.  # noqa: E501

        :param grade: The grade of this AssignmentSubmission.  # noqa: E501
        :type: float
        """

        self._grade = grade

    @property
    def draft_grade(self):
        """Gets the draft_grade of this AssignmentSubmission.  # noqa: E501

        Optional grade. If unset, no grade was set. This value is only visible by the teacher, and we will be set to `grade` once the teacher returns the submission  # noqa: E501

        :return: The draft_grade of this AssignmentSubmission.  # noqa: E501
        :rtype: float
        """
        return self._draft_grade

    @draft_grade.setter
    def draft_grade(self, draft_grade):
        """Sets the draft_grade of this AssignmentSubmission.

        Optional grade. If unset, no grade was set. This value is only visible by the teacher, and we will be set to `grade` once the teacher returns the submission  # noqa: E501

        :param draft_grade: The draft_grade of this AssignmentSubmission.  # noqa: E501
        :type: float
        """

        self._draft_grade = draft_grade

    @property
    def max_points(self):
        """Gets the max_points of this AssignmentSubmission.  # noqa: E501

        Optional max points for the grade. If set, a corresponding `draftGrade` or `grade` will be set.  # noqa: E501

        :return: The max_points of this AssignmentSubmission.  # noqa: E501
        :rtype: float
        """
        return self._max_points

    @max_points.setter
    def max_points(self, max_points):
        """Sets the max_points of this AssignmentSubmission.

        Optional max points for the grade. If set, a corresponding `draftGrade` or `grade` will be set.  # noqa: E501

        :param max_points: The max_points of this AssignmentSubmission.  # noqa: E501
        :type: float
        """

        self._max_points = max_points

    @property
    def exercises_ids(self):
        """Gets the exercises_ids of this AssignmentSubmission.  # noqa: E501

        The ids of exercises when they need to be in a specific order  # noqa: E501

        :return: The exercises_ids of this AssignmentSubmission.  # noqa: E501
        :rtype: list[str]
        """
        return self._exercises_ids

    @exercises_ids.setter
    def exercises_ids(self, exercises_ids):
        """Sets the exercises_ids of this AssignmentSubmission.

        The ids of exercises when they need to be in a specific order  # noqa: E501

        :param exercises_ids: The exercises_ids of this AssignmentSubmission.  # noqa: E501
        :type: list[str]
        """

        self._exercises_ids = exercises_ids

    @property
    def google_classroom(self):
        """Gets the google_classroom of this AssignmentSubmission.  # noqa: E501


        :return: The google_classroom of this AssignmentSubmission.  # noqa: E501
        :rtype: GoogleClassroomSubmission
        """
        return self._google_classroom

    @google_classroom.setter
    def google_classroom(self, google_classroom):
        """Sets the google_classroom of this AssignmentSubmission.


        :param google_classroom: The google_classroom of this AssignmentSubmission.  # noqa: E501
        :type: GoogleClassroomSubmission
        """

        self._google_classroom = google_classroom

    @property
    def microsoft_graph(self):
        """Gets the microsoft_graph of this AssignmentSubmission.  # noqa: E501


        :return: The microsoft_graph of this AssignmentSubmission.  # noqa: E501
        :rtype: MicrosoftGraphSubmission
        """
        return self._microsoft_graph

    @microsoft_graph.setter
    def microsoft_graph(self, microsoft_graph):
        """Sets the microsoft_graph of this AssignmentSubmission.


        :param microsoft_graph: The microsoft_graph of this AssignmentSubmission.  # noqa: E501
        :type: MicrosoftGraphSubmission
        """

        self._microsoft_graph = microsoft_graph

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignmentSubmission):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
