# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AssignmentCreation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'AssignmentType',
        'state': 'str',
        'title': 'str',
        'description': 'str',
        'attachments': 'list[ClassAttachmentCreation]',
        'due_date': 'datetime',
        'scheduled_date': 'datetime',
        'nb_playback_authorized': 'float',
        'toolset': 'str',
        'cover_file': 'str',
        'cover': 'str',
        'max_points': 'float',
        'google_classroom': 'AssignmentCreationGoogleClassroom',
        'microsoft_graph': 'AssignmentCreationMicrosoftGraph',
        'assignee_mode': 'str',
        'assigned_students': 'list[str]',
        'shuffle_exercises': 'bool'
    }

    attribute_map = {
        'type': 'type',
        'state': 'state',
        'title': 'title',
        'description': 'description',
        'attachments': 'attachments',
        'due_date': 'dueDate',
        'scheduled_date': 'scheduledDate',
        'nb_playback_authorized': 'nbPlaybackAuthorized',
        'toolset': 'toolset',
        'cover_file': 'coverFile',
        'cover': 'cover',
        'max_points': 'maxPoints',
        'google_classroom': 'googleClassroom',
        'microsoft_graph': 'microsoftGraph',
        'assignee_mode': 'assigneeMode',
        'assigned_students': 'assignedStudents',
        'shuffle_exercises': 'shuffleExercises'
    }

    def __init__(self, type=None, state=None, title=None, description=None, attachments=None, due_date=None, scheduled_date=None, nb_playback_authorized=None, toolset=None, cover_file=None, cover=None, max_points=None, google_classroom=None, microsoft_graph=None, assignee_mode=None, assigned_students=None, shuffle_exercises=None):  # noqa: E501
        """AssignmentCreation - a model defined in OpenAPI"""  # noqa: E501

        self._type = None
        self._state = None
        self._title = None
        self._description = None
        self._attachments = None
        self._due_date = None
        self._scheduled_date = None
        self._nb_playback_authorized = None
        self._toolset = None
        self._cover_file = None
        self._cover = None
        self._max_points = None
        self._google_classroom = None
        self._microsoft_graph = None
        self._assignee_mode = None
        self._assigned_students = None
        self._shuffle_exercises = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if state is not None:
            self.state = state
        if title is not None:
            self.title = title
        if description is not None:
            self.description = description
        if attachments is not None:
            self.attachments = attachments
        self.due_date = due_date
        self.scheduled_date = scheduled_date
        self.nb_playback_authorized = nb_playback_authorized
        self.toolset = toolset
        self.cover_file = cover_file
        self.cover = cover
        self.max_points = max_points
        if google_classroom is not None:
            self.google_classroom = google_classroom
        if microsoft_graph is not None:
            self.microsoft_graph = microsoft_graph
        if assignee_mode is not None:
            self.assignee_mode = assignee_mode
        if assigned_students is not None:
            self.assigned_students = assigned_students
        if shuffle_exercises is not None:
            self.shuffle_exercises = shuffle_exercises

    @property
    def type(self):
        """Gets the type of this AssignmentCreation.  # noqa: E501


        :return: The type of this AssignmentCreation.  # noqa: E501
        :rtype: AssignmentType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this AssignmentCreation.


        :param type: The type of this AssignmentCreation.  # noqa: E501
        :type: AssignmentType
        """

        self._type = type

    @property
    def state(self):
        """Gets the state of this AssignmentCreation.  # noqa: E501

        State of the assignment  # noqa: E501

        :return: The state of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this AssignmentCreation.

        State of the assignment  # noqa: E501

        :param state: The state of this AssignmentCreation.  # noqa: E501
        :type: str
        """
        allowed_values = ["draft", "active"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def title(self):
        """Gets the title of this AssignmentCreation.  # noqa: E501

        Title of the assignment  # noqa: E501

        :return: The title of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this AssignmentCreation.

        Title of the assignment  # noqa: E501

        :param title: The title of this AssignmentCreation.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def description(self):
        """Gets the description of this AssignmentCreation.  # noqa: E501

        Description and content of the assignment  # noqa: E501

        :return: The description of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AssignmentCreation.

        Description and content of the assignment  # noqa: E501

        :param description: The description of this AssignmentCreation.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def attachments(self):
        """Gets the attachments of this AssignmentCreation.  # noqa: E501


        :return: The attachments of this AssignmentCreation.  # noqa: E501
        :rtype: list[ClassAttachmentCreation]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this AssignmentCreation.


        :param attachments: The attachments of this AssignmentCreation.  # noqa: E501
        :type: list[ClassAttachmentCreation]
        """

        self._attachments = attachments

    @property
    def due_date(self):
        """Gets the due_date of this AssignmentCreation.  # noqa: E501

        The due date of this assignment, late submissions will be marked as paste due. If not set, the assignment won't have a due date.   # noqa: E501

        :return: The due_date of this AssignmentCreation.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this AssignmentCreation.

        The due date of this assignment, late submissions will be marked as paste due. If not set, the assignment won't have a due date.   # noqa: E501

        :param due_date: The due_date of this AssignmentCreation.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    @property
    def scheduled_date(self):
        """Gets the scheduled_date of this AssignmentCreation.  # noqa: E501

        The publication (scheduled) date of the assignment. If this one is specified, the assignment will only be listed to the teachers of the class.   # noqa: E501

        :return: The scheduled_date of this AssignmentCreation.  # noqa: E501
        :rtype: datetime
        """
        return self._scheduled_date

    @scheduled_date.setter
    def scheduled_date(self, scheduled_date):
        """Sets the scheduled_date of this AssignmentCreation.

        The publication (scheduled) date of the assignment. If this one is specified, the assignment will only be listed to the teachers of the class.   # noqa: E501

        :param scheduled_date: The scheduled_date of this AssignmentCreation.  # noqa: E501
        :type: datetime
        """

        self._scheduled_date = scheduled_date

    @property
    def nb_playback_authorized(self):
        """Gets the nb_playback_authorized of this AssignmentCreation.  # noqa: E501

        The number of playback authorized on the scores of the assignment.  # noqa: E501

        :return: The nb_playback_authorized of this AssignmentCreation.  # noqa: E501
        :rtype: float
        """
        return self._nb_playback_authorized

    @nb_playback_authorized.setter
    def nb_playback_authorized(self, nb_playback_authorized):
        """Sets the nb_playback_authorized of this AssignmentCreation.

        The number of playback authorized on the scores of the assignment.  # noqa: E501

        :param nb_playback_authorized: The nb_playback_authorized of this AssignmentCreation.  # noqa: E501
        :type: float
        """

        self._nb_playback_authorized = nb_playback_authorized

    @property
    def toolset(self):
        """Gets the toolset of this AssignmentCreation.  # noqa: E501

        The id of the associated toolset  # noqa: E501

        :return: The toolset of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._toolset

    @toolset.setter
    def toolset(self, toolset):
        """Sets the toolset of this AssignmentCreation.

        The id of the associated toolset  # noqa: E501

        :param toolset: The toolset of this AssignmentCreation.  # noqa: E501
        :type: str
        """

        self._toolset = toolset

    @property
    def cover_file(self):
        """Gets the cover_file of this AssignmentCreation.  # noqa: E501

        The id of the cover to display  # noqa: E501

        :return: The cover_file of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._cover_file

    @cover_file.setter
    def cover_file(self, cover_file):
        """Sets the cover_file of this AssignmentCreation.

        The id of the cover to display  # noqa: E501

        :param cover_file: The cover_file of this AssignmentCreation.  # noqa: E501
        :type: str
        """

        self._cover_file = cover_file

    @property
    def cover(self):
        """Gets the cover of this AssignmentCreation.  # noqa: E501

        The URL of the cover to display  # noqa: E501

        :return: The cover of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._cover

    @cover.setter
    def cover(self, cover):
        """Sets the cover of this AssignmentCreation.

        The URL of the cover to display  # noqa: E501

        :param cover: The cover of this AssignmentCreation.  # noqa: E501
        :type: str
        """

        self._cover = cover

    @property
    def max_points(self):
        """Gets the max_points of this AssignmentCreation.  # noqa: E501

        If set, the grading will be enabled for the assignement with this value as the maximum of points   # noqa: E501

        :return: The max_points of this AssignmentCreation.  # noqa: E501
        :rtype: float
        """
        return self._max_points

    @max_points.setter
    def max_points(self, max_points):
        """Sets the max_points of this AssignmentCreation.

        If set, the grading will be enabled for the assignement with this value as the maximum of points   # noqa: E501

        :param max_points: The max_points of this AssignmentCreation.  # noqa: E501
        :type: float
        """
        if max_points is not None and max_points > 100:  # noqa: E501
            raise ValueError("Invalid value for `max_points`, must be a value less than or equal to `100`")  # noqa: E501
        if max_points is not None and max_points < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_points`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_points = max_points

    @property
    def google_classroom(self):
        """Gets the google_classroom of this AssignmentCreation.  # noqa: E501


        :return: The google_classroom of this AssignmentCreation.  # noqa: E501
        :rtype: AssignmentCreationGoogleClassroom
        """
        return self._google_classroom

    @google_classroom.setter
    def google_classroom(self, google_classroom):
        """Sets the google_classroom of this AssignmentCreation.


        :param google_classroom: The google_classroom of this AssignmentCreation.  # noqa: E501
        :type: AssignmentCreationGoogleClassroom
        """

        self._google_classroom = google_classroom

    @property
    def microsoft_graph(self):
        """Gets the microsoft_graph of this AssignmentCreation.  # noqa: E501


        :return: The microsoft_graph of this AssignmentCreation.  # noqa: E501
        :rtype: AssignmentCreationMicrosoftGraph
        """
        return self._microsoft_graph

    @microsoft_graph.setter
    def microsoft_graph(self, microsoft_graph):
        """Sets the microsoft_graph of this AssignmentCreation.


        :param microsoft_graph: The microsoft_graph of this AssignmentCreation.  # noqa: E501
        :type: AssignmentCreationMicrosoftGraph
        """

        self._microsoft_graph = microsoft_graph

    @property
    def assignee_mode(self):
        """Gets the assignee_mode of this AssignmentCreation.  # noqa: E501

        Possible modes of assigning assignments  # noqa: E501

        :return: The assignee_mode of this AssignmentCreation.  # noqa: E501
        :rtype: str
        """
        return self._assignee_mode

    @assignee_mode.setter
    def assignee_mode(self, assignee_mode):
        """Sets the assignee_mode of this AssignmentCreation.

        Possible modes of assigning assignments  # noqa: E501

        :param assignee_mode: The assignee_mode of this AssignmentCreation.  # noqa: E501
        :type: str
        """
        allowed_values = ["everyone", "selected"]  # noqa: E501
        if assignee_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `assignee_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(assignee_mode, allowed_values)
            )

        self._assignee_mode = assignee_mode

    @property
    def assigned_students(self):
        """Gets the assigned_students of this AssignmentCreation.  # noqa: E501

        Identifiers for the students that have access to the assignment  # noqa: E501

        :return: The assigned_students of this AssignmentCreation.  # noqa: E501
        :rtype: list[str]
        """
        return self._assigned_students

    @assigned_students.setter
    def assigned_students(self, assigned_students):
        """Sets the assigned_students of this AssignmentCreation.

        Identifiers for the students that have access to the assignment  # noqa: E501

        :param assigned_students: The assigned_students of this AssignmentCreation.  # noqa: E501
        :type: list[str]
        """

        self._assigned_students = assigned_students

    @property
    def shuffle_exercises(self):
        """Gets the shuffle_exercises of this AssignmentCreation.  # noqa: E501

        Mixing exercises for each students  # noqa: E501

        :return: The shuffle_exercises of this AssignmentCreation.  # noqa: E501
        :rtype: bool
        """
        return self._shuffle_exercises

    @shuffle_exercises.setter
    def shuffle_exercises(self, shuffle_exercises):
        """Sets the shuffle_exercises of this AssignmentCreation.

        Mixing exercises for each students  # noqa: E501

        :param shuffle_exercises: The shuffle_exercises of this AssignmentCreation.  # noqa: E501
        :type: bool
        """

        self._shuffle_exercises = shuffle_exercises

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignmentCreation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
