# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AssignmentCopy(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'classroom': 'str',
        'assignment': 'str',
        'scheduled_date': 'datetime'
    }

    attribute_map = {
        'classroom': 'classroom',
        'assignment': 'assignment',
        'scheduled_date': 'scheduledDate'
    }

    def __init__(self, classroom=None, assignment=None, scheduled_date=None):  # noqa: E501
        """AssignmentCopy - a model defined in OpenAPI"""  # noqa: E501

        self._classroom = None
        self._assignment = None
        self._scheduled_date = None
        self.discriminator = None

        if classroom is not None:
            self.classroom = classroom
        if assignment is not None:
            self.assignment = assignment
        if scheduled_date is not None:
            self.scheduled_date = scheduled_date

    @property
    def classroom(self):
        """Gets the classroom of this AssignmentCopy.  # noqa: E501

        The destination classroom where the assignment will be copied  # noqa: E501

        :return: The classroom of this AssignmentCopy.  # noqa: E501
        :rtype: str
        """
        return self._classroom

    @classroom.setter
    def classroom(self, classroom):
        """Sets the classroom of this AssignmentCopy.

        The destination classroom where the assignment will be copied  # noqa: E501

        :param classroom: The classroom of this AssignmentCopy.  # noqa: E501
        :type: str
        """

        self._classroom = classroom

    @property
    def assignment(self):
        """Gets the assignment of this AssignmentCopy.  # noqa: E501

        An optional destination assignment where the original assignement will be copied. Must be a draft.  # noqa: E501

        :return: The assignment of this AssignmentCopy.  # noqa: E501
        :rtype: str
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment):
        """Sets the assignment of this AssignmentCopy.

        An optional destination assignment where the original assignement will be copied. Must be a draft.  # noqa: E501

        :param assignment: The assignment of this AssignmentCopy.  # noqa: E501
        :type: str
        """

        self._assignment = assignment

    @property
    def scheduled_date(self):
        """Gets the scheduled_date of this AssignmentCopy.  # noqa: E501

        The publication (scheduled) date of the assignment. If this one is specified, the assignment will only be listed to the teachers of the class. Alternatively the existing `scheduledDate` from the copied assignment will be used.   # noqa: E501

        :return: The scheduled_date of this AssignmentCopy.  # noqa: E501
        :rtype: datetime
        """
        return self._scheduled_date

    @scheduled_date.setter
    def scheduled_date(self, scheduled_date):
        """Sets the scheduled_date of this AssignmentCopy.

        The publication (scheduled) date of the assignment. If this one is specified, the assignment will only be listed to the teachers of the class. Alternatively the existing `scheduledDate` from the copied assignment will be used.   # noqa: E501

        :param scheduled_date: The scheduled_date of this AssignmentCopy.  # noqa: E501
        :type: datetime
        """

        self._scheduled_date = scheduled_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignmentCopy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
