# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Assignment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'state': 'str',
        'type': 'AssignmentType',
        'title': 'str',
        'classroom': 'str',
        'description': 'str',
        'cover': 'str',
        'cover_file': 'str',
        'attachments': 'list[MediaAttachment]',
        'submissions': 'list[AssignmentSubmission]',
        'creator': 'str',
        'creation_date': 'datetime',
        'scheduled_date': 'datetime',
        'due_date': 'datetime',
        'max_points': 'float',
        'google_classroom': 'GoogleClassroomCoursework',
        'microsoft_graph': 'MicrosoftGraphAssignment',
        'mfc': 'AssignmentMfc',
        'canvas': 'AssignmentCanvas',
        'lti': 'AssignmentLti'
    }

    attribute_map = {
        'state': 'state',
        'type': 'type',
        'title': 'title',
        'classroom': 'classroom',
        'description': 'description',
        'cover': 'cover',
        'cover_file': 'coverFile',
        'attachments': 'attachments',
        'submissions': 'submissions',
        'creator': 'creator',
        'creation_date': 'creationDate',
        'scheduled_date': 'scheduledDate',
        'due_date': 'dueDate',
        'max_points': 'maxPoints',
        'google_classroom': 'googleClassroom',
        'microsoft_graph': 'microsoftGraph',
        'mfc': 'mfc',
        'canvas': 'canvas',
        'lti': 'lti'
    }

    def __init__(self, state=None, type=None, title=None, classroom=None, description=None, cover=None, cover_file=None, attachments=None, submissions=None, creator=None, creation_date=None, scheduled_date=None, due_date=None, max_points=None, google_classroom=None, microsoft_graph=None, mfc=None, canvas=None, lti=None):  # noqa: E501
        """Assignment - a model defined in OpenAPI"""  # noqa: E501

        self._state = None
        self._type = None
        self._title = None
        self._classroom = None
        self._description = None
        self._cover = None
        self._cover_file = None
        self._attachments = None
        self._submissions = None
        self._creator = None
        self._creation_date = None
        self._scheduled_date = None
        self._due_date = None
        self._max_points = None
        self._google_classroom = None
        self._microsoft_graph = None
        self._mfc = None
        self._canvas = None
        self._lti = None
        self.discriminator = None

        if state is not None:
            self.state = state
        if type is not None:
            self.type = type
        if title is not None:
            self.title = title
        if classroom is not None:
            self.classroom = classroom
        if description is not None:
            self.description = description
        if cover is not None:
            self.cover = cover
        if cover_file is not None:
            self.cover_file = cover_file
        if attachments is not None:
            self.attachments = attachments
        if submissions is not None:
            self.submissions = submissions
        if creator is not None:
            self.creator = creator
        if creation_date is not None:
            self.creation_date = creation_date
        if scheduled_date is not None:
            self.scheduled_date = scheduled_date
        if due_date is not None:
            self.due_date = due_date
        if max_points is not None:
            self.max_points = max_points
        if google_classroom is not None:
            self.google_classroom = google_classroom
        if microsoft_graph is not None:
            self.microsoft_graph = microsoft_graph
        if mfc is not None:
            self.mfc = mfc
        if canvas is not None:
            self.canvas = canvas
        if lti is not None:
            self.lti = lti

    @property
    def state(self):
        """Gets the state of this Assignment.  # noqa: E501

        State of the assignment  # noqa: E501

        :return: The state of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Assignment.

        State of the assignment  # noqa: E501

        :param state: The state of this Assignment.  # noqa: E501
        :type: str
        """
        allowed_values = ["draft", "active", "archived"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def type(self):
        """Gets the type of this Assignment.  # noqa: E501


        :return: The type of this Assignment.  # noqa: E501
        :rtype: AssignmentType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Assignment.


        :param type: The type of this Assignment.  # noqa: E501
        :type: AssignmentType
        """

        self._type = type

    @property
    def title(self):
        """Gets the title of this Assignment.  # noqa: E501

        Title of the assignment  # noqa: E501

        :return: The title of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Assignment.

        Title of the assignment  # noqa: E501

        :param title: The title of this Assignment.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def classroom(self):
        """Gets the classroom of this Assignment.  # noqa: E501

        The unique identifier of the class where this assignment was posted  # noqa: E501

        :return: The classroom of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._classroom

    @classroom.setter
    def classroom(self, classroom):
        """Sets the classroom of this Assignment.

        The unique identifier of the class where this assignment was posted  # noqa: E501

        :param classroom: The classroom of this Assignment.  # noqa: E501
        :type: str
        """

        self._classroom = classroom

    @property
    def description(self):
        """Gets the description of this Assignment.  # noqa: E501

        Description and content of the assignment  # noqa: E501

        :return: The description of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Assignment.

        Description and content of the assignment  # noqa: E501

        :param description: The description of this Assignment.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def cover(self):
        """Gets the cover of this Assignment.  # noqa: E501

        The URL of the cover to display  # noqa: E501

        :return: The cover of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._cover

    @cover.setter
    def cover(self, cover):
        """Sets the cover of this Assignment.

        The URL of the cover to display  # noqa: E501

        :param cover: The cover of this Assignment.  # noqa: E501
        :type: str
        """

        self._cover = cover

    @property
    def cover_file(self):
        """Gets the cover_file of this Assignment.  # noqa: E501

        The id of the cover to display  # noqa: E501

        :return: The cover_file of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._cover_file

    @cover_file.setter
    def cover_file(self, cover_file):
        """Sets the cover_file of this Assignment.

        The id of the cover to display  # noqa: E501

        :param cover_file: The cover_file of this Assignment.  # noqa: E501
        :type: str
        """

        self._cover_file = cover_file

    @property
    def attachments(self):
        """Gets the attachments of this Assignment.  # noqa: E501


        :return: The attachments of this Assignment.  # noqa: E501
        :rtype: list[MediaAttachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this Assignment.


        :param attachments: The attachments of this Assignment.  # noqa: E501
        :type: list[MediaAttachment]
        """

        self._attachments = attachments

    @property
    def submissions(self):
        """Gets the submissions of this Assignment.  # noqa: E501


        :return: The submissions of this Assignment.  # noqa: E501
        :rtype: list[AssignmentSubmission]
        """
        return self._submissions

    @submissions.setter
    def submissions(self, submissions):
        """Sets the submissions of this Assignment.


        :param submissions: The submissions of this Assignment.  # noqa: E501
        :type: list[AssignmentSubmission]
        """

        self._submissions = submissions

    @property
    def creator(self):
        """Gets the creator of this Assignment.  # noqa: E501

        The User unique identifier of the creator of this assignment   # noqa: E501

        :return: The creator of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this Assignment.

        The User unique identifier of the creator of this assignment   # noqa: E501

        :param creator: The creator of this Assignment.  # noqa: E501
        :type: str
        """

        self._creator = creator

    @property
    def creation_date(self):
        """Gets the creation_date of this Assignment.  # noqa: E501

        The creation date of this assignment  # noqa: E501

        :return: The creation_date of this Assignment.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this Assignment.

        The creation date of this assignment  # noqa: E501

        :param creation_date: The creation_date of this Assignment.  # noqa: E501
        :type: datetime
        """

        self._creation_date = creation_date

    @property
    def scheduled_date(self):
        """Gets the scheduled_date of this Assignment.  # noqa: E501

        The publication (scheduled) date of the assignment. If this one is specified, the assignment will only be listed to the teachers of the class.   # noqa: E501

        :return: The scheduled_date of this Assignment.  # noqa: E501
        :rtype: datetime
        """
        return self._scheduled_date

    @scheduled_date.setter
    def scheduled_date(self, scheduled_date):
        """Sets the scheduled_date of this Assignment.

        The publication (scheduled) date of the assignment. If this one is specified, the assignment will only be listed to the teachers of the class.   # noqa: E501

        :param scheduled_date: The scheduled_date of this Assignment.  # noqa: E501
        :type: datetime
        """

        self._scheduled_date = scheduled_date

    @property
    def due_date(self):
        """Gets the due_date of this Assignment.  # noqa: E501

        The due date of this assignment, late submissions will be marked as paste due.   # noqa: E501

        :return: The due_date of this Assignment.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this Assignment.

        The due date of this assignment, late submissions will be marked as paste due.   # noqa: E501

        :param due_date: The due_date of this Assignment.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    @property
    def max_points(self):
        """Gets the max_points of this Assignment.  # noqa: E501

        If set, the grading will be enabled for the assignement   # noqa: E501

        :return: The max_points of this Assignment.  # noqa: E501
        :rtype: float
        """
        return self._max_points

    @max_points.setter
    def max_points(self, max_points):
        """Sets the max_points of this Assignment.

        If set, the grading will be enabled for the assignement   # noqa: E501

        :param max_points: The max_points of this Assignment.  # noqa: E501
        :type: float
        """

        self._max_points = max_points

    @property
    def google_classroom(self):
        """Gets the google_classroom of this Assignment.  # noqa: E501


        :return: The google_classroom of this Assignment.  # noqa: E501
        :rtype: GoogleClassroomCoursework
        """
        return self._google_classroom

    @google_classroom.setter
    def google_classroom(self, google_classroom):
        """Sets the google_classroom of this Assignment.


        :param google_classroom: The google_classroom of this Assignment.  # noqa: E501
        :type: GoogleClassroomCoursework
        """

        self._google_classroom = google_classroom

    @property
    def microsoft_graph(self):
        """Gets the microsoft_graph of this Assignment.  # noqa: E501


        :return: The microsoft_graph of this Assignment.  # noqa: E501
        :rtype: MicrosoftGraphAssignment
        """
        return self._microsoft_graph

    @microsoft_graph.setter
    def microsoft_graph(self, microsoft_graph):
        """Sets the microsoft_graph of this Assignment.


        :param microsoft_graph: The microsoft_graph of this Assignment.  # noqa: E501
        :type: MicrosoftGraphAssignment
        """

        self._microsoft_graph = microsoft_graph

    @property
    def mfc(self):
        """Gets the mfc of this Assignment.  # noqa: E501


        :return: The mfc of this Assignment.  # noqa: E501
        :rtype: AssignmentMfc
        """
        return self._mfc

    @mfc.setter
    def mfc(self, mfc):
        """Sets the mfc of this Assignment.


        :param mfc: The mfc of this Assignment.  # noqa: E501
        :type: AssignmentMfc
        """

        self._mfc = mfc

    @property
    def canvas(self):
        """Gets the canvas of this Assignment.  # noqa: E501


        :return: The canvas of this Assignment.  # noqa: E501
        :rtype: AssignmentCanvas
        """
        return self._canvas

    @canvas.setter
    def canvas(self, canvas):
        """Sets the canvas of this Assignment.


        :param canvas: The canvas of this Assignment.  # noqa: E501
        :type: AssignmentCanvas
        """

        self._canvas = canvas

    @property
    def lti(self):
        """Gets the lti of this Assignment.  # noqa: E501


        :return: The lti of this Assignment.  # noqa: E501
        :rtype: AssignmentLti
        """
        return self._lti

    @lti.setter
    def lti(self, lti):
        """Sets the lti of this Assignment.


        :param lti: The lti of this Assignment.  # noqa: E501
        :type: AssignmentLti
        """

        self._lti = lti

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Assignment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
