# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ApiAccessToken(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'token': 'str',
        'issued_date': 'datetime',
        'expiration_date': 'datetime',
        'scopes': 'list[AppScopes]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'token': 'token',
        'issued_date': 'issuedDate',
        'expiration_date': 'expirationDate',
        'scopes': 'scopes'
    }

    def __init__(self, id=None, name=None, token=None, issued_date=None, expiration_date=None, scopes=None):  # noqa: E501
        """ApiAccessToken - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._name = None
        self._token = None
        self._issued_date = None
        self._expiration_date = None
        self._scopes = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if token is not None:
            self.token = token
        if issued_date is not None:
            self.issued_date = issued_date
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if scopes is not None:
            self.scopes = scopes

    @property
    def id(self):
        """Gets the id of this ApiAccessToken.  # noqa: E501

        Unique identifier of this private token  # noqa: E501

        :return: The id of this ApiAccessToken.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ApiAccessToken.

        Unique identifier of this private token  # noqa: E501

        :param id: The id of this ApiAccessToken.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ApiAccessToken.  # noqa: E501

        Name of the personal access token  # noqa: E501

        :return: The name of this ApiAccessToken.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApiAccessToken.

        Name of the personal access token  # noqa: E501

        :param name: The name of this ApiAccessToken.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def token(self):
        """Gets the token of this ApiAccessToken.  # noqa: E501

        The token. This token will only be returned once, then only the first 4 characters will be returned.   # noqa: E501

        :return: The token of this ApiAccessToken.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this ApiAccessToken.

        The token. This token will only be returned once, then only the first 4 characters will be returned.   # noqa: E501

        :param token: The token of this ApiAccessToken.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def issued_date(self):
        """Gets the issued_date of this ApiAccessToken.  # noqa: E501

        The date then this token was issued   # noqa: E501

        :return: The issued_date of this ApiAccessToken.  # noqa: E501
        :rtype: datetime
        """
        return self._issued_date

    @issued_date.setter
    def issued_date(self, issued_date):
        """Sets the issued_date of this ApiAccessToken.

        The date then this token was issued   # noqa: E501

        :param issued_date: The issued_date of this ApiAccessToken.  # noqa: E501
        :type: datetime
        """

        self._issued_date = issued_date

    @property
    def expiration_date(self):
        """Gets the expiration_date of this ApiAccessToken.  # noqa: E501

        The date then this token will expire   # noqa: E501

        :return: The expiration_date of this ApiAccessToken.  # noqa: E501
        :rtype: datetime
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this ApiAccessToken.

        The date then this token will expire   # noqa: E501

        :param expiration_date: The expiration_date of this ApiAccessToken.  # noqa: E501
        :type: datetime
        """

        self._expiration_date = expiration_date

    @property
    def scopes(self):
        """Gets the scopes of this ApiAccessToken.  # noqa: E501

        The list of scopes associated to the token   # noqa: E501

        :return: The scopes of this ApiAccessToken.  # noqa: E501
        :rtype: list[AppScopes]
        """
        return self._scopes

    @scopes.setter
    def scopes(self, scopes):
        """Sets the scopes of this ApiAccessToken.

        The list of scopes associated to the token   # noqa: E501

        :param scopes: The scopes of this ApiAccessToken.  # noqa: E501
        :type: list[AppScopes]
        """

        self._scopes = scopes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiAccessToken):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
