# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from flat_api.api_client import ApiClient


class ScoreApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_score_collaborator(self, score, body, **kwargs):  # noqa: E501
        """Add a new collaborator  # noqa: E501

        Share a score with a single user or a group. This API call allows to add, invite and update the collaborators of a resource. - To add an existing Flat user to the resource, specify its unique identifier in the `user` property. - To invite an external user to the resource, specify its email in the `userEmail` property. - To add a Flat group to the resource, specify its unique identifier in the `group` property. - To update an existing collaborator, process the same request with different rights.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_score_collaborator(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ResourceCollaboratorCreation body: (required)
        :return: ResourceCollaborator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_score_collaborator_with_http_info(score, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_score_collaborator_with_http_info(score, body, **kwargs)  # noqa: E501
            return data

    def add_score_collaborator_with_http_info(self, score, body, **kwargs):  # noqa: E501
        """Add a new collaborator  # noqa: E501

        Share a score with a single user or a group. This API call allows to add, invite and update the collaborators of a resource. - To add an existing Flat user to the resource, specify its unique identifier in the `user` property. - To invite an external user to the resource, specify its email in the `userEmail` property. - To add a Flat group to the resource, specify its unique identifier in the `group` property. - To update an existing collaborator, process the same request with different rights.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_score_collaborator_with_http_info(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ResourceCollaboratorCreation body: (required)
        :return: ResourceCollaborator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_score_collaborator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `add_score_collaborator`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_score_collaborator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/collaborators', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceCollaborator',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_score_track(self, score, body, **kwargs):  # noqa: E501
        """Add a new video or audio track to the score  # noqa: E501

        Use this method to add new track to the score. This track can then be played on flat.io or in an embedded score. This API method support medias hosted on SoundCloud, YouTube and Vimeo.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_score_track(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreTrackCreation body: (required)
        :return: ScoreTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_score_track_with_http_info(score, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_score_track_with_http_info(score, body, **kwargs)  # noqa: E501
            return data

    def add_score_track_with_http_info(self, score, body, **kwargs):  # noqa: E501
        """Add a new video or audio track to the score  # noqa: E501

        Use this method to add new track to the score. This track can then be played on flat.io or in an embedded score. This API method support medias hosted on SoundCloud, YouTube and Vimeo.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_score_track_with_http_info(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreTrackCreation body: (required)
        :return: ScoreTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_score_track" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `add_score_track`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_score_track`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/tracks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_export_task(self, score, revision, format, **kwargs):  # noqa: E501
        """Create a new score export task  # noqa: E501

        Some of the exports of a score takes are longer to process than a simple API requests. Use this endpoint to launch a new export of one score hosted on Flat.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_export_task(score, revision, format, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str revision: Unique identifier of a score revision. You can use `last` to fetch the information related to the last version created.  (required)
        :param str format: The format of the file that will be generated or the target service name where the file will be exported (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param TaskExportOptions body:
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_export_task_with_http_info(score, revision, format, **kwargs)  # noqa: E501
        else:
            (data) = self.create_export_task_with_http_info(score, revision, format, **kwargs)  # noqa: E501
            return data

    def create_export_task_with_http_info(self, score, revision, format, **kwargs):  # noqa: E501
        """Create a new score export task  # noqa: E501

        Some of the exports of a score takes are longer to process than a simple API requests. Use this endpoint to launch a new export of one score hosted on Flat.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_export_task_with_http_info(score, revision, format, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str revision: Unique identifier of a score revision. You can use `last` to fetch the information related to the last version created.  (required)
        :param str format: The format of the file that will be generated or the target service name where the file will be exported (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param TaskExportOptions body:
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'revision', 'format', 'sharing_key', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_export_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `create_export_task`")  # noqa: E501
        # verify the required parameter 'revision' is set
        if ('revision' not in local_var_params or
                local_var_params['revision'] is None):
            raise ValueError("Missing the required parameter `revision` when calling `create_export_task`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ValueError("Missing the required parameter `format` when calling `create_export_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'revision' in local_var_params:
            path_params['revision'] = local_var_params['revision']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/revisions/{revision}/{format}/task', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_score(self, body, **kwargs):  # noqa: E501
        """Create a new score  # noqa: E501

        Use this API method to **create a new music score in the current User account**. This API endpoints provides 3 ways to create scores:  * `ScoreCreationBuilderData` : Create a blank score by providing the list of instruments to use. You can optionally customize the initial key signature, time signature, enable TABs, Chord grids, as well as the page layout. * `ScoreCreationFileImport`: Import an existing MusicXML 3 file (`vnd.recordare.musicxml` or `vnd.recordare.musicxml+xml`), a MIDI file (`audio/midi`), Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar, or MuseScore file to create the new Flat document. * `ScoreCreationGoogleDriveImport`: Import an existing Google Drive file from the connected Google Drive account.  This API call will automatically create the first revision of the document, the score can be modified by the using our web application or by uploading a new revision of this file (`POST /v2/scores/{score}/revisions/{revision}`).  The currently authenticated user will be granted owner of the file and will be able to add other collaborators (users and groups).  If no `collection` is specified, the API will create the score in the most appropriate collection. When using an OAuth2 access token or a personal token, the score will be automatically added to your dedicated app collection in the account (`/v2/collections/app`).  If a `collection` is specified and this one has more public privacy settings than the score (e.g. `public` vs `private` for the score), the privacy settings of the created score will be adjusted to the collection ones.  You can check the adjusted privacy settings in the returned score `privacy`, and optionally adjust these settings if needed using `PUT /scores/{score}`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_score(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScoreCreation body: (required)
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_score_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_score_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_score_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new score  # noqa: E501

        Use this API method to **create a new music score in the current User account**. This API endpoints provides 3 ways to create scores:  * `ScoreCreationBuilderData` : Create a blank score by providing the list of instruments to use. You can optionally customize the initial key signature, time signature, enable TABs, Chord grids, as well as the page layout. * `ScoreCreationFileImport`: Import an existing MusicXML 3 file (`vnd.recordare.musicxml` or `vnd.recordare.musicxml+xml`), a MIDI file (`audio/midi`), Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar, or MuseScore file to create the new Flat document. * `ScoreCreationGoogleDriveImport`: Import an existing Google Drive file from the connected Google Drive account.  This API call will automatically create the first revision of the document, the score can be modified by the using our web application or by uploading a new revision of this file (`POST /v2/scores/{score}/revisions/{revision}`).  The currently authenticated user will be granted owner of the file and will be able to add other collaborators (users and groups).  If no `collection` is specified, the API will create the score in the most appropriate collection. When using an OAuth2 access token or a personal token, the score will be automatically added to your dedicated app collection in the account (`/v2/collections/app`).  If a `collection` is specified and this one has more public privacy settings than the score (e.g. `public` vs `private` for the score), the privacy settings of the created score will be adjusted to the collection ones.  You can check the adjusted privacy settings in the returned score `privacy`, and optionally adjust these settings if needed using `PUT /scores/{score}`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_score_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScoreCreation body: (required)
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_score_revision(self, score, body, **kwargs):  # noqa: E501
        """Create a new revision  # noqa: E501

        Update a score by uploading a new revision for this one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_score_revision(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreRevisionCreation body: (required)
        :return: ScoreRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_score_revision_with_http_info(score, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_score_revision_with_http_info(score, body, **kwargs)  # noqa: E501
            return data

    def create_score_revision_with_http_info(self, score, body, **kwargs):  # noqa: E501
        """Create a new revision  # noqa: E501

        Update a score by uploading a new revision for this one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_score_revision_with_http_info(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreRevisionCreation body: (required)
        :return: ScoreRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_score_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `create_score_revision`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_score_revision`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/revisions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreRevision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_score(self, score, **kwargs):  # noqa: E501
        """Delete a score  # noqa: E501

        This method can be used by the owner/admin (`aclAdmin` rights) of a score as well as regular collaborators.  When called by an owner/admin, it will schedule the deletion of the score, its revisions, and complete history. The score won't be accessible anymore after calling this method and the user's quota will directly be updated.  When called by a regular collaborator (`aclRead` / `aclWrite`), the score will be unshared (i.e. removed from the account & own collections).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_score(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param bool now: If `true`, the score deletion will be scheduled to be done ASAP
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_score_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_score_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def delete_score_with_http_info(self, score, **kwargs):  # noqa: E501
        """Delete a score  # noqa: E501

        This method can be used by the owner/admin (`aclAdmin` rights) of a score as well as regular collaborators.  When called by an owner/admin, it will schedule the deletion of the score, its revisions, and complete history. The score won't be accessible anymore after calling this method and the user's quota will directly be updated.  When called by a regular collaborator (`aclRead` / `aclWrite`), the score will be unshared (i.e. removed from the account & own collections).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_score_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param bool now: If `true`, the score deletion will be scheduled to be done ASAP
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'now']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `delete_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'now' in local_var_params:
            query_params.append(('now', local_var_params['now']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_score_comment(self, score, comment, **kwargs):  # noqa: E501
        """Delete a comment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_score_comment(score, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_score_comment_with_http_info(score, comment, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_score_comment_with_http_info(score, comment, **kwargs)  # noqa: E501
            return data

    def delete_score_comment_with_http_info(self, score, comment, **kwargs):  # noqa: E501
        """Delete a comment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_score_comment_with_http_info(score, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'comment', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_score_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `delete_score_comment`")  # noqa: E501
        # verify the required parameter 'comment' is set
        if ('comment' not in local_var_params or
                local_var_params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `delete_score_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'comment' in local_var_params:
            path_params['comment'] = local_var_params['comment']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/comments/{comment}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_score_track(self, score, track, **kwargs):  # noqa: E501
        """Remove an audio or video track linked to the score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_score_track(score, track, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str track: Unique identifier of a score audio track  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_score_track_with_http_info(score, track, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_score_track_with_http_info(score, track, **kwargs)  # noqa: E501
            return data

    def delete_score_track_with_http_info(self, score, track, **kwargs):  # noqa: E501
        """Remove an audio or video track linked to the score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_score_track_with_http_info(score, track, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str track: Unique identifier of a score audio track  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'track']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_score_track" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `delete_score_track`")  # noqa: E501
        # verify the required parameter 'track' is set
        if ('track' not in local_var_params or
                local_var_params['track'] is None):
            raise ValueError("Missing the required parameter `track` when calling `delete_score_track`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'track' in local_var_params:
            path_params['track'] = local_var_params['track']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/tracks/{track}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_score(self, score, **kwargs):  # noqa: E501
        """Edit a score&#39;s metadata  # noqa: E501

        This API method allows you to change the metadata of a score document (e.g. its `title` or `privacy`), all the properties are optional.  To edit the file itself, create a new revision using the appropriate method (`POST /v2/scores/{score}/revisions/{revision}`).  When editing the `title`, `subtitle`, `composer`, `lyricist`, `arranger` or `licenseText`, the metadatas will be instantly be updated, and a real-time action will be pushed to update the document lazily. This pending document modification will be automatically be saved as a new version by either a connected client or our internal versioning service.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_score(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreModification body:
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_score_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_score_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def edit_score_with_http_info(self, score, **kwargs):  # noqa: E501
        """Edit a score&#39;s metadata  # noqa: E501

        This API method allows you to change the metadata of a score document (e.g. its `title` or `privacy`), all the properties are optional.  To edit the file itself, create a new revision using the appropriate method (`POST /v2/scores/{score}/revisions/{revision}`).  When editing the `title`, `subtitle`, `composer`, `lyricist`, `arranger` or `licenseText`, the metadatas will be instantly be updated, and a real-time action will be pushed to update the document lazily. This pending document modification will be automatically be saved as a new version by either a connected client or our internal versioning service.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_score_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreModification body:
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `edit_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fork_score(self, score, body, **kwargs):  # noqa: E501
        """Fork a score  # noqa: E501

        This API call will make a copy of the last revision of the specified score and create a new score. The copy of the score will have a privacy set to `private`.  When using a [Flat for Education](https://flat.io/edu) account, the inline and contextualized comments will be accessible in the child document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fork_score(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreFork body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fork_score_with_http_info(score, body, **kwargs)  # noqa: E501
        else:
            (data) = self.fork_score_with_http_info(score, body, **kwargs)  # noqa: E501
            return data

    def fork_score_with_http_info(self, score, body, **kwargs):  # noqa: E501
        """Fork a score  # noqa: E501

        This API call will make a copy of the last revision of the specified score and create a new score. The copy of the score will have a privacy set to `private`.  When using a [Flat for Education](https://flat.io/edu) account, the inline and contextualized comments will be accessible in the child document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fork_score_with_http_info(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreFork body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fork_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `fork_score`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `fork_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/fork', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ger_user_likes(self, user, **kwargs):  # noqa: E501
        """List liked scores  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ger_user_likes(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of a Flat user. If you authenticated, you can use `me` to refer to the current user.  (required)
        :param bool ids: Return only the identifiers of the scores
        :return: list[ScoreDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ger_user_likes_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.ger_user_likes_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def ger_user_likes_with_http_info(self, user, **kwargs):  # noqa: E501
        """List liked scores  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ger_user_likes_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of a Flat user. If you authenticated, you can use `me` to refer to the current user.  (required)
        :param bool ids: Return only the identifiers of the scores
        :return: list[ScoreDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user', 'ids']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ger_user_likes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `ger_user_likes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []
        if 'ids' in local_var_params:
            query_params.append(('ids', local_var_params['ids']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user}/likes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScoreDetails]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_group_scores(self, group, **kwargs):  # noqa: E501
        """List group&#39;s scores  # noqa: E501

        Get the list of scores shared with a group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_scores(group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: Unique identifier of a Flat group  (required)
        :param str parent: Filter the score forked from the score id `parent`
        :return: list[ScoreDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_group_scores_with_http_info(group, **kwargs)  # noqa: E501
        else:
            (data) = self.get_group_scores_with_http_info(group, **kwargs)  # noqa: E501
            return data

    def get_group_scores_with_http_info(self, group, **kwargs):  # noqa: E501
        """List group&#39;s scores  # noqa: E501

        Get the list of scores shared with a group.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_group_scores_with_http_info(group, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group: Unique identifier of a Flat group  (required)
        :param str parent: Filter the score forked from the score id `parent`
        :return: list[ScoreDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['group', 'parent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_scores" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group' is set
        if ('group' not in local_var_params or
                local_var_params['group'] is None):
            raise ValueError("Missing the required parameter `group` when calling `get_group_scores`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group' in local_var_params:
            path_params['group'] = local_var_params['group']  # noqa: E501

        query_params = []
        if 'parent' in local_var_params:
            query_params.append(('parent', local_var_params['parent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/groups/{group}/scores', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScoreDetails]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score(self, score, **kwargs):  # noqa: E501
        """Get a score&#39;s metadata  # noqa: E501

        Get the details of a score identified by the `score` parameter in the URL. The currently authenticated user must have at least a read access to the document to use this API call.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def get_score_with_http_info(self, score, **kwargs):  # noqa: E501
        """Get a score&#39;s metadata  # noqa: E501

        Get the details of a score identified by the `score` parameter in the URL. The currently authenticated user must have at least a read access to the document to use this API call.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_collaborator(self, score, collaborator, **kwargs):  # noqa: E501
        """Get a collaborator  # noqa: E501

        Get the information about a collaborator (User or Group).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_collaborator(score, collaborator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str collaborator: Unique identifier of a **collaborator permission**, or unique identifier of a **User**, or unique identifier of a **Group**  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ResourceCollaborator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_collaborator_with_http_info(score, collaborator, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_collaborator_with_http_info(score, collaborator, **kwargs)  # noqa: E501
            return data

    def get_score_collaborator_with_http_info(self, score, collaborator, **kwargs):  # noqa: E501
        """Get a collaborator  # noqa: E501

        Get the information about a collaborator (User or Group).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_collaborator_with_http_info(score, collaborator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str collaborator: Unique identifier of a **collaborator permission**, or unique identifier of a **User**, or unique identifier of a **Group**  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ResourceCollaborator
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'collaborator', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_collaborator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_collaborator`")  # noqa: E501
        # verify the required parameter 'collaborator' is set
        if ('collaborator' not in local_var_params or
                local_var_params['collaborator'] is None):
            raise ValueError("Missing the required parameter `collaborator` when calling `get_score_collaborator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'collaborator' in local_var_params:
            path_params['collaborator'] = local_var_params['collaborator']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/collaborators/{collaborator}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceCollaborator',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_collaborators(self, score, **kwargs):  # noqa: E501
        """List the collaborators  # noqa: E501

        This API call will list the different collaborators of a score and their rights on the document. The returned list will at least contain the owner of the document.  Collaborators can be a single user (the object `user` will be populated) or a group (the object `group` will be populated).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_collaborators(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: list[ResourceCollaborator]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_collaborators_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_collaborators_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def get_score_collaborators_with_http_info(self, score, **kwargs):  # noqa: E501
        """List the collaborators  # noqa: E501

        This API call will list the different collaborators of a score and their rights on the document. The returned list will at least contain the owner of the document.  Collaborators can be a single user (the object `user` will be populated) or a group (the object `group` will be populated).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_collaborators_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: list[ResourceCollaborator]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_collaborators" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_collaborators`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/collaborators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ResourceCollaborator]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_comments(self, score, **kwargs):  # noqa: E501
        """List comments  # noqa: E501

        This method lists the different comments added on a music score (documents and inline) sorted by their post dates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_comments(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param str type: Filter the comments by type
        :param str sort: Sort
        :param str direction: Sort direction
        :return: list[ScoreComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_comments_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_comments_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def get_score_comments_with_http_info(self, score, **kwargs):  # noqa: E501
        """List comments  # noqa: E501

        This method lists the different comments added on a music score (documents and inline) sorted by their post dates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_comments_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param str type: Filter the comments by type
        :param str sort: Sort
        :param str direction: Sort direction
        :return: list[ScoreComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'sharing_key', 'type', 'sort', 'direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_comments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501
        if 'type' in local_var_params:
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'sort' in local_var_params:
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScoreComment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_revision(self, score, revision, **kwargs):  # noqa: E501
        """Get a score revision  # noqa: E501

        When creating a score or saving a new version of a score, a revision is created in our storage. This method allows you to get a specific revision metadata.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_revision(score, revision, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str revision: Unique identifier of a score revision. You can use `last` to fetch the information related to the last version created.  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_revision_with_http_info(score, revision, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_revision_with_http_info(score, revision, **kwargs)  # noqa: E501
            return data

    def get_score_revision_with_http_info(self, score, revision, **kwargs):  # noqa: E501
        """Get a score revision  # noqa: E501

        When creating a score or saving a new version of a score, a revision is created in our storage. This method allows you to get a specific revision metadata.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_revision_with_http_info(score, revision, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str revision: Unique identifier of a score revision. You can use `last` to fetch the information related to the last version created.  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreRevision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'revision', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_revision" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_revision`")  # noqa: E501
        # verify the required parameter 'revision' is set
        if ('revision' not in local_var_params or
                local_var_params['revision'] is None):
            raise ValueError("Missing the required parameter `revision` when calling `get_score_revision`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'revision' in local_var_params:
            path_params['revision'] = local_var_params['revision']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/revisions/{revision}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreRevision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_revision_data(self, score, revision, format, **kwargs):  # noqa: E501
        """Get a score revision data  # noqa: E501

        Retrieve the file corresponding to a score revision (the following formats are available): Flat JSON/Adagio JSON `json`, MusicXML `mxl`/`xml`, MP3 `mp3`, WAV `wav`, MIDI `midi`, a tumbnail of the first page `thumbnail.png` or auto sync points `synchronizationPoints`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_revision_data(score, revision, format, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str revision: Unique identifier of a score revision. You can use `last` to fetch the information related to the last version created.  (required)
        :param str format: The format of the file you will retrieve (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param str parts: An optional a set of parts uuid to be exported. This parameter must be composed of parts uuids separated by commas. For example \"59df645f-bb1c-f1b4-b573-d2afc4491f94,34ef645f-1aef-f3bc-1564-34cca4492b87\". 
        :param bool default_track: When `format` is `mp3`, this property is set to true and the score has a default `ScoreTrack` (mp3), this one will be returned instead of the playback file. 
        :param bool url: Returns a json with the `url` in it instead of redirecting 
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_revision_data_with_http_info(score, revision, format, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_revision_data_with_http_info(score, revision, format, **kwargs)  # noqa: E501
            return data

    def get_score_revision_data_with_http_info(self, score, revision, format, **kwargs):  # noqa: E501
        """Get a score revision data  # noqa: E501

        Retrieve the file corresponding to a score revision (the following formats are available): Flat JSON/Adagio JSON `json`, MusicXML `mxl`/`xml`, MP3 `mp3`, WAV `wav`, MIDI `midi`, a tumbnail of the first page `thumbnail.png` or auto sync points `synchronizationPoints`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_revision_data_with_http_info(score, revision, format, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str revision: Unique identifier of a score revision. You can use `last` to fetch the information related to the last version created.  (required)
        :param str format: The format of the file you will retrieve (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param str parts: An optional a set of parts uuid to be exported. This parameter must be composed of parts uuids separated by commas. For example \"59df645f-bb1c-f1b4-b573-d2afc4491f94,34ef645f-1aef-f3bc-1564-34cca4492b87\". 
        :param bool default_track: When `format` is `mp3`, this property is set to true and the score has a default `ScoreTrack` (mp3), this one will be returned instead of the playback file. 
        :param bool url: Returns a json with the `url` in it instead of redirecting 
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'revision', 'format', 'sharing_key', 'parts', 'default_track', 'url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_revision_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_revision_data`")  # noqa: E501
        # verify the required parameter 'revision' is set
        if ('revision' not in local_var_params or
                local_var_params['revision'] is None):
            raise ValueError("Missing the required parameter `revision` when calling `get_score_revision_data`")  # noqa: E501
        # verify the required parameter 'format' is set
        if ('format' not in local_var_params or
                local_var_params['format'] is None):
            raise ValueError("Missing the required parameter `format` when calling `get_score_revision_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'revision' in local_var_params:
            path_params['revision'] = local_var_params['revision']  # noqa: E501
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501
        if 'parts' in local_var_params:
            query_params.append(('parts', local_var_params['parts']))  # noqa: E501
        if 'default_track' in local_var_params:
            query_params.append(('defaultTrack', local_var_params['default_track']))  # noqa: E501
        if 'url' in local_var_params:
            query_params.append(('url', local_var_params['url']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/vnd.recordare.musicxml+xml', 'application/vnd.recordare.musicxml', 'audio/mp3', 'audio/wav', 'audio/midi', 'image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/revisions/{revision}/{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_revisions(self, score, **kwargs):  # noqa: E501
        """List the revisions  # noqa: E501

        When creating a score or saving a new version of a score, a revision is created in our storage. This method allows you to list all of them, sorted by last modification.  Depending the plan of the account, this list can be trunked to the few last revisions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_revisions(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: list[ScoreRevision]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_revisions_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_revisions_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def get_score_revisions_with_http_info(self, score, **kwargs):  # noqa: E501
        """List the revisions  # noqa: E501

        When creating a score or saving a new version of a score, a revision is created in our storage. This method allows you to list all of them, sorted by last modification.  Depending the plan of the account, this list can be trunked to the few last revisions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_revisions_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: list[ScoreRevision]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_revisions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_revisions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/revisions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScoreRevision]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_submissions(self, score, **kwargs):  # noqa: E501
        """List submissions related to the score  # noqa: E501

        This API call will list the different assignments submissions where the score is attached. This method can be used by anyone that are part of the organization and have at least read access to the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_submissions(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_submissions_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_submissions_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def get_score_submissions_with_http_info(self, score, **kwargs):  # noqa: E501
        """List submissions related to the score  # noqa: E501

        This API call will list the different assignments submissions where the score is attached. This method can be used by anyone that are part of the organization and have at least read access to the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_submissions_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_submissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_submissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/submissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssignmentSubmission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_track(self, score, track, **kwargs):  # noqa: E501
        """Retrieve the details of an audio or video track linked to a score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_track(score, track, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str track: Unique identifier of a score audio track  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_track_with_http_info(score, track, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_track_with_http_info(score, track, **kwargs)  # noqa: E501
            return data

    def get_score_track_with_http_info(self, score, track, **kwargs):  # noqa: E501
        """Retrieve the details of an audio or video track linked to a score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_track_with_http_info(score, track, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str track: Unique identifier of a score audio track  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'track', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_track" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_track`")  # noqa: E501
        # verify the required parameter 'track' is set
        if ('track' not in local_var_params or
                local_var_params['track'] is None):
            raise ValueError("Missing the required parameter `track` when calling `get_score_track`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'track' in local_var_params:
            path_params['track'] = local_var_params['track']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/tracks/{track}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_scores(self, user, **kwargs):  # noqa: E501
        """List user&#39;s scores  # noqa: E501

        Get the list of public scores owned by a User.  **DEPRECATED**: Please note that the current behavior will be deprecrated on **2019-01-01**. This method will no longer list private and shared scores, but only public scores of a Flat account. If you want to access to private scores, please use the [Collections API](#tag/Collection) instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_scores(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of a Flat user. If you authenticated, you can use `me` to refer to the current user.  (required)
        :param str parent: Filter the score forked from the score id `parent`
        :return: list[ScoreDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_scores_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_scores_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def get_user_scores_with_http_info(self, user, **kwargs):  # noqa: E501
        """List user&#39;s scores  # noqa: E501

        Get the list of public scores owned by a User.  **DEPRECATED**: Please note that the current behavior will be deprecrated on **2019-01-01**. This method will no longer list private and shared scores, but only public scores of a Flat account. If you want to access to private scores, please use the [Collections API](#tag/Collection) instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_scores_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of a Flat user. If you authenticated, you can use `me` to refer to the current user.  (required)
        :param str parent: Filter the score forked from the score id `parent`
        :return: list[ScoreDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user', 'parent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_scores" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `get_user_scores`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []
        if 'parent' in local_var_params:
            query_params.append(('parent', local_var_params['parent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/users/{user}/scores', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScoreDetails]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_score_tracks(self, score, **kwargs):  # noqa: E501
        """List the audio or video tracks linked to a score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_score_tracks(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param str assignment: An assignment id with which all the tracks returned will be related to 
        :param bool list_auto_track: If true, and if available, return last automatically synchronized Flat's mp3 export as an additional track 
        :return: list[ScoreTrack]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_score_tracks_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.list_score_tracks_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def list_score_tracks_with_http_info(self, score, **kwargs):  # noqa: E501
        """List the audio or video tracks linked to a score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_score_tracks_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :param str assignment: An assignment id with which all the tracks returned will be related to 
        :param bool list_auto_track: If true, and if available, return last automatically synchronized Flat's mp3 export as an additional track 
        :return: list[ScoreTrack]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'sharing_key', 'assignment', 'list_auto_track']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_score_tracks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `list_score_tracks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501
        if 'assignment' in local_var_params:
            query_params.append(('assignment', local_var_params['assignment']))  # noqa: E501
        if 'list_auto_track' in local_var_params:
            query_params.append(('listAutoTrack', local_var_params['list_auto_track']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/tracks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ScoreTrack]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mark_score_comment_resolved(self, score, comment, **kwargs):  # noqa: E501
        """Mark the comment as resolved  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_score_comment_resolved(score, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mark_score_comment_resolved_with_http_info(score, comment, **kwargs)  # noqa: E501
        else:
            (data) = self.mark_score_comment_resolved_with_http_info(score, comment, **kwargs)  # noqa: E501
            return data

    def mark_score_comment_resolved_with_http_info(self, score, comment, **kwargs):  # noqa: E501
        """Mark the comment as resolved  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_score_comment_resolved_with_http_info(score, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'comment', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_score_comment_resolved" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `mark_score_comment_resolved`")  # noqa: E501
        # verify the required parameter 'comment' is set
        if ('comment' not in local_var_params or
                local_var_params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `mark_score_comment_resolved`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'comment' in local_var_params:
            path_params['comment'] = local_var_params['comment']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/comments/{comment}/resolved', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def mark_score_comment_unresolved(self, score, comment, **kwargs):  # noqa: E501
        """Mark the comment as unresolved  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_score_comment_unresolved(score, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.mark_score_comment_unresolved_with_http_info(score, comment, **kwargs)  # noqa: E501
        else:
            (data) = self.mark_score_comment_unresolved_with_http_info(score, comment, **kwargs)  # noqa: E501
            return data

    def mark_score_comment_unresolved_with_http_info(self, score, comment, **kwargs):  # noqa: E501
        """Mark the comment as unresolved  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.mark_score_comment_unresolved_with_http_info(score, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'comment', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method mark_score_comment_unresolved" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `mark_score_comment_unresolved`")  # noqa: E501
        # verify the required parameter 'comment' is set
        if ('comment' not in local_var_params or
                local_var_params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `mark_score_comment_unresolved`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'comment' in local_var_params:
            path_params['comment'] = local_var_params['comment']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/comments/{comment}/resolved', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_score_comment(self, score, body, **kwargs):  # noqa: E501
        """Post a new comment  # noqa: E501

        Post a document or a contextualized comment on a document.  Please note that this method includes an anti-spam system for public scores. We don't guarantee that your comments will be accepted and displayed to end-user. Comments are be blocked by returning a `403` HTTP error and hidden from other users when the `spam` property is `true`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_score_comment(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreCommentCreation body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_score_comment_with_http_info(score, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_score_comment_with_http_info(score, body, **kwargs)  # noqa: E501
            return data

    def post_score_comment_with_http_info(self, score, body, **kwargs):  # noqa: E501
        """Post a new comment  # noqa: E501

        Post a document or a contextualized comment on a document.  Please note that this method includes an anti-spam system for public scores. We don't guarantee that your comments will be accepted and displayed to end-user. Comments are be blocked by returning a `403` HTTP error and hidden from other users when the `spam` property is `true`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_score_comment_with_http_info(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreCommentCreation body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_score_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `post_score_comment`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_score_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_score_collaborator(self, score, collaborator, **kwargs):  # noqa: E501
        """Delete a collaborator  # noqa: E501

        Remove the specified collaborator from the score   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_score_collaborator(score, collaborator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str collaborator: Unique identifier of a **collaborator permission**, or unique identifier of a **User**, or unique identifier of a **Group**  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_score_collaborator_with_http_info(score, collaborator, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_score_collaborator_with_http_info(score, collaborator, **kwargs)  # noqa: E501
            return data

    def remove_score_collaborator_with_http_info(self, score, collaborator, **kwargs):  # noqa: E501
        """Delete a collaborator  # noqa: E501

        Remove the specified collaborator from the score   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_score_collaborator_with_http_info(score, collaborator, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str collaborator: Unique identifier of a **collaborator permission**, or unique identifier of a **User**, or unique identifier of a **Group**  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'collaborator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_score_collaborator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `remove_score_collaborator`")  # noqa: E501
        # verify the required parameter 'collaborator' is set
        if ('collaborator' not in local_var_params or
                local_var_params['collaborator'] is None):
            raise ValueError("Missing the required parameter `collaborator` when calling `remove_score_collaborator`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'collaborator' in local_var_params:
            path_params['collaborator'] = local_var_params['collaborator']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/collaborators/{collaborator}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def untrash_score(self, score, **kwargs):  # noqa: E501
        """Untrash a score  # noqa: E501

        This method will remove the score from the `trash` collection and from the deletion queue, and add it back to the original collections.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.untrash_score(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.untrash_score_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.untrash_score_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def untrash_score_with_http_info(self, score, **kwargs):  # noqa: E501
        """Untrash a score  # noqa: E501

        This method will remove the score from the `trash` collection and from the deletion queue, and add it back to the original collections.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.untrash_score_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method untrash_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `untrash_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/untrash', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_score_comment(self, score, comment, body, **kwargs):  # noqa: E501
        """Update an existing comment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_score_comment(score, comment, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param ScoreCommentUpdate body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_score_comment_with_http_info(score, comment, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_score_comment_with_http_info(score, comment, body, **kwargs)  # noqa: E501
            return data

    def update_score_comment_with_http_info(self, score, comment, body, **kwargs):  # noqa: E501
        """Update an existing comment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_score_comment_with_http_info(score, comment, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str comment: Unique identifier of a sheet music comment  (required)
        :param ScoreCommentUpdate body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'comment', 'body', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_score_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `update_score_comment`")  # noqa: E501
        # verify the required parameter 'comment' is set
        if ('comment' not in local_var_params or
                local_var_params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `update_score_comment`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_score_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'comment' in local_var_params:
            path_params['comment'] = local_var_params['comment']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/comments/{comment}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_score_track(self, score, track, body, **kwargs):  # noqa: E501
        """Update an audio or video track linked to a score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_score_track(score, track, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str track: Unique identifier of a score audio track  (required)
        :param ScoreTrackUpdate body: (required)
        :return: ScoreTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_score_track_with_http_info(score, track, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_score_track_with_http_info(score, track, body, **kwargs)  # noqa: E501
            return data

    def update_score_track_with_http_info(self, score, track, body, **kwargs):  # noqa: E501
        """Update an audio or video track linked to a score  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_score_track_with_http_info(score, track, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param str track: Unique identifier of a score audio track  (required)
        :param ScoreTrackUpdate body: (required)
        :return: ScoreTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'track', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_score_track" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `update_score_track`")  # noqa: E501
        # verify the required parameter 'track' is set
        if ('track' not in local_var_params or
                local_var_params['track'] is None):
            raise ValueError("Missing the required parameter `track` when calling `update_score_track`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_score_track`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501
        if 'track' in local_var_params:
            path_params['track'] = local_var_params['track']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/tracks/{track}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
