# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from flat_api.api_client import ApiClient


class OrganizationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def count_orga_users(self, **kwargs):  # noqa: E501
        """Count the organization users using the provided filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_orga_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] role: Filter users by role
        :param str q: The query to search
        :param list[str] group: Filter users by group
        :param bool no_active_license: Filter users who don't have an active license
        :return: int[UserDetailsAdmin]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.count_orga_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.count_orga_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def count_orga_users_with_http_info(self, **kwargs):  # noqa: E501
        """Count the organization users using the provided filters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.count_orga_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] role: Filter users by role
        :param str q: The query to search
        :param list[str] group: Filter users by group
        :param bool no_active_license: Filter users who don't have an active license
        :return: int[UserDetailsAdmin]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['role', 'q', 'group', 'no_active_license']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_orga_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role' in local_var_params:
            query_params.append(('role', local_var_params['role']))  # noqa: E501
            collection_formats['role'] = 'multi'  # noqa: E501
        if 'q' in local_var_params:
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'multi'  # noqa: E501
        if 'no_active_license' in local_var_params:
            query_params.append(('noActiveLicense', local_var_params['no_active_license']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int[UserDetailsAdmin]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_lti_credentials(self, body, **kwargs):  # noqa: E501
        """Create a new couple of LTI 1.x credentials  # noqa: E501

        Flat for Education is a Certified LTI Provider. You can use these API methods to automate the creation of LTI credentials. You can read more about our LTI implementation, supported components and LTI Endpoints in our [Developer Documentation](https://flat.io/developers/docs/lti/).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_lti_credentials(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LtiCredentialsCreation body: (required)
        :return: LtiCredentials
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_lti_credentials_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_lti_credentials_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_lti_credentials_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new couple of LTI 1.x credentials  # noqa: E501

        Flat for Education is a Certified LTI Provider. You can use these API methods to automate the creation of LTI credentials. You can read more about our LTI implementation, supported components and LTI Endpoints in our [Developer Documentation](https://flat.io/developers/docs/lti/).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_lti_credentials_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LtiCredentialsCreation body: (required)
        :return: LtiCredentials
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_lti_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_lti_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/lti/credentials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LtiCredentials',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_organization_invitation(self, **kwargs):  # noqa: E501
        """Create a new invitation to join the organization  # noqa: E501

        This method creates and sends invitation for teachers and admins.  Invitations can only be used by new Flat users or users who are not part of the organization yet.  If the email of the user is already associated to a user of your organization, the API will simply update the role of the existing user and won't send an invitation. In this case, the property `usedBy` will be directly filled with the uniquer identifier of the corresponding user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_invitation(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrganizationInvitationCreation body:
        :return: OrganizationInvitation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_organization_invitation_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_organization_invitation_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_organization_invitation_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new invitation to join the organization  # noqa: E501

        This method creates and sends invitation for teachers and admins.  Invitations can only be used by new Flat users or users who are not part of the organization yet.  If the email of the user is already associated to a user of your organization, the API will simply update the role of the existing user and won't send an invitation. In this case, the property `usedBy` will be directly filled with the uniquer identifier of the corresponding user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_invitation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrganizationInvitationCreation body:
        :return: OrganizationInvitation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization_invitation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/invitations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationInvitation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_organization_user(self, **kwargs):  # noqa: E501
        """Create a new user account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserCreation body:
        :return: UserDetailsAdmin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_organization_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_organization_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_organization_user_with_http_info(self, **kwargs):  # noqa: E501
        """Create a new user account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserCreation body:
        :return: UserDetailsAdmin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserDetailsAdmin',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_organization_user_access_token(self, user, **kwargs):  # noqa: E501
        """Create a delegated API access token for an organization user  # noqa: E501

        This operation will create an API access token for a chosen organization user. This token will be valid for a limited time and can be used to access the API as the organization user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_user_access_token(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param OrganizationUserAccessTokenCreation organization_user_access_token_creation:
        :return: ApiAccessToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_organization_user_access_token_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.create_organization_user_access_token_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def create_organization_user_access_token_with_http_info(self, user, **kwargs):  # noqa: E501
        """Create a delegated API access token for an organization user  # noqa: E501

        This operation will create an API access token for a chosen organization user. This token will be valid for a limited time and can be used to access the API as the organization user.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_user_access_token_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param OrganizationUserAccessTokenCreation organization_user_access_token_creation:
        :return: ApiAccessToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user', 'organization_user_access_token_creation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization_user_access_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `create_organization_user_access_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'organization_user_access_token_creation' in local_var_params:
            body_params = local_var_params['organization_user_access_token_creation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users/{user}/accessToken', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiAccessToken',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_organization_user_signin_link(self, user, **kwargs):  # noqa: E501
        """Create a sign in link for an organization user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_user_signin_link(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param OrganizationUserSigninLinkCreation organization_user_signin_link_creation:
        :return: OrganizationUserSigninLink
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_organization_user_signin_link_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.create_organization_user_signin_link_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def create_organization_user_signin_link_with_http_info(self, user, **kwargs):  # noqa: E501
        """Create a sign in link for an organization user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_user_signin_link_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param OrganizationUserSigninLinkCreation organization_user_signin_link_creation:
        :return: OrganizationUserSigninLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user', 'organization_user_signin_link_creation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization_user_signin_link" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `create_organization_user_signin_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'organization_user_signin_link_creation' in local_var_params:
            body_params = local_var_params['organization_user_signin_link_creation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users/{user}/signinLink', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUserSigninLink',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_lti_credentials(self, **kwargs):  # noqa: E501
        """List LTI 1.x credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_lti_credentials(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[LtiCredentials]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_lti_credentials_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_lti_credentials_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_lti_credentials_with_http_info(self, **kwargs):  # noqa: E501
        """List LTI 1.x credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_lti_credentials_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[LtiCredentials]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_lti_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/lti/credentials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LtiCredentials]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_organization_invitations(self, **kwargs):  # noqa: E501
        """List the organization invitations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_organization_invitations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: Filter users by role
        :param int limit: This is the maximum number of objects that may be returned
        :param str next: An opaque string cursor to fetch the next page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :param str previous: An opaque string cursor to fetch the previous page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :return: list[OrganizationInvitation]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_organization_invitations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_organization_invitations_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_organization_invitations_with_http_info(self, **kwargs):  # noqa: E501
        """List the organization invitations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_organization_invitations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: Filter users by role
        :param int limit: This is the maximum number of objects that may be returned
        :param str next: An opaque string cursor to fetch the next page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :param str previous: An opaque string cursor to fetch the previous page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :return: list[OrganizationInvitation]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['role', 'limit', 'next', 'previous']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_invitations" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'limit' in local_var_params and local_var_params['limit'] > 1000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_organization_invitations`, must be a value less than or equal to `1000`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_organization_invitations`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role' in local_var_params:
            query_params.append(('role', local_var_params['role']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'next' in local_var_params:
            query_params.append(('next', local_var_params['next']))  # noqa: E501
        if 'previous' in local_var_params:
            query_params.append(('previous', local_var_params['previous']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/invitations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationInvitation]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_organization_users(self, **kwargs):  # noqa: E501
        """List the organization users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_organization_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] sort: The order to sort the user list
        :param str direction: Sort direction
        :param str next: An opaque string cursor to fetch the next page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :param str previous: An opaque string cursor to fetch the previous page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :param list[str] role: Filter users by role
        :param str q: The query to search
        :param list[str] group: Filter users by group
        :param bool no_active_license: Filter users who don't have an active license
        :param list[str] license_expiration_date: Filter users by license expiration date or `active` / `notActive`
        :param bool only_ids: Return only user ids
        :param int limit: This is the maximum number of objects that may be returned
        :return: list[UserDetailsAdmin]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_organization_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_organization_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_organization_users_with_http_info(self, **kwargs):  # noqa: E501
        """List the organization users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_organization_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] sort: The order to sort the user list
        :param str direction: Sort direction
        :param str next: An opaque string cursor to fetch the next page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :param str previous: An opaque string cursor to fetch the previous page of data. The paginated API URLs are returned in the `Link` header when requesting the API. These URLs will contain a `next` and `previous` cursor based on the available data. 
        :param list[str] role: Filter users by role
        :param str q: The query to search
        :param list[str] group: Filter users by group
        :param bool no_active_license: Filter users who don't have an active license
        :param list[str] license_expiration_date: Filter users by license expiration date or `active` / `notActive`
        :param bool only_ids: Return only user ids
        :param int limit: This is the maximum number of objects that may be returned
        :return: list[UserDetailsAdmin]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['sort', 'direction', 'next', 'previous', 'role', 'q', 'group', 'no_active_license', 'license_expiration_date', 'only_ids', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_organization_users" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if 'limit' in local_var_params and local_var_params['limit'] > 1000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_organization_users`, must be a value less than or equal to `1000`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_organization_users`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort' in local_var_params:
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'direction' in local_var_params:
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501
        if 'next' in local_var_params:
            query_params.append(('next', local_var_params['next']))  # noqa: E501
        if 'previous' in local_var_params:
            query_params.append(('previous', local_var_params['previous']))  # noqa: E501
        if 'role' in local_var_params:
            query_params.append(('role', local_var_params['role']))  # noqa: E501
            collection_formats['role'] = 'multi'  # noqa: E501
        if 'q' in local_var_params:
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'group' in local_var_params:
            query_params.append(('group', local_var_params['group']))  # noqa: E501
            collection_formats['group'] = 'multi'  # noqa: E501
        if 'no_active_license' in local_var_params:
            query_params.append(('noActiveLicense', local_var_params['no_active_license']))  # noqa: E501
        if 'license_expiration_date' in local_var_params:
            query_params.append(('licenseExpirationDate', local_var_params['license_expiration_date']))  # noqa: E501
            collection_formats['licenseExpirationDate'] = 'multi'  # noqa: E501
        if 'only_ids' in local_var_params:
            query_params.append(('onlyIds', local_var_params['only_ids']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UserDetailsAdmin]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_organization_invitation(self, invitation, **kwargs):  # noqa: E501
        """Remove an organization invitation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_organization_invitation(invitation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invitation: Unique identifier of the invitation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_organization_invitation_with_http_info(invitation, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_organization_invitation_with_http_info(invitation, **kwargs)  # noqa: E501
            return data

    def remove_organization_invitation_with_http_info(self, invitation, **kwargs):  # noqa: E501
        """Remove an organization invitation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_organization_invitation_with_http_info(invitation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invitation: Unique identifier of the invitation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['invitation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_organization_invitation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invitation' is set
        if ('invitation' not in local_var_params or
                local_var_params['invitation'] is None):
            raise ValueError("Missing the required parameter `invitation` when calling `remove_organization_invitation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invitation' in local_var_params:
            path_params['invitation'] = local_var_params['invitation']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/invitations/{invitation}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_organization_user(self, user, **kwargs):  # noqa: E501
        """Remove an account from Flat  # noqa: E501

        This operation removes an account from Flat and its data, including: * The music scores created by this user (documents, history, comments, collaboration information) * Education related data (assignments and classroom information)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_organization_user(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param bool convert_to_individual: If `true`, the account will be only removed from the organization and converted into an individual account on our public website, https://flat.io. This operation will remove the education-related data from the account. Before realizing this operation, you need to be sure that the user is at least 13 years old and that this one has read and agreed to the Individual Terms of Services of Flat available on https://flat.io/legal. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_organization_user_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_organization_user_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def remove_organization_user_with_http_info(self, user, **kwargs):  # noqa: E501
        """Remove an account from Flat  # noqa: E501

        This operation removes an account from Flat and its data, including: * The music scores created by this user (documents, history, comments, collaboration information) * Education related data (assignments and classroom information)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_organization_user_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param bool convert_to_individual: If `true`, the account will be only removed from the organization and converted into an individual account on our public website, https://flat.io. This operation will remove the education-related data from the account. Before realizing this operation, you need to be sure that the user is at least 13 years old and that this one has read and agreed to the Individual Terms of Services of Flat available on https://flat.io/legal. 
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user', 'convert_to_individual']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_organization_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `remove_organization_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []
        if 'convert_to_individual' in local_var_params:
            query_params.append(('convertToIndividual', local_var_params['convert_to_individual']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users/{user}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def revoke_lti_credentials(self, credentials, **kwargs):  # noqa: E501
        """Revoke LTI 1.x credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_lti_credentials(credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str credentials: Credentials unique identifier  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revoke_lti_credentials_with_http_info(credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.revoke_lti_credentials_with_http_info(credentials, **kwargs)  # noqa: E501
            return data

    def revoke_lti_credentials_with_http_info(self, credentials, **kwargs):  # noqa: E501
        """Revoke LTI 1.x credentials  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.revoke_lti_credentials_with_http_info(credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str credentials: Credentials unique identifier  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['credentials']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revoke_lti_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'credentials' is set
        if ('credentials' not in local_var_params or
                local_var_params['credentials'] is None):
            raise ValueError("Missing the required parameter `credentials` when calling `revoke_lti_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'credentials' in local_var_params:
            path_params['credentials'] = local_var_params['credentials']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/lti/credentials/{credentials}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_organization_user(self, user, body, **kwargs):  # noqa: E501
        """Update account information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_organization_user(user, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param UserAdminUpdate body: (required)
        :return: UserDetailsAdmin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_organization_user_with_http_info(user, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_organization_user_with_http_info(user, body, **kwargs)  # noqa: E501
            return data

    def update_organization_user_with_http_info(self, user, body, **kwargs):  # noqa: E501
        """Update account information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_organization_user_with_http_info(user, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: Unique identifier of the Flat account  (required)
        :param UserAdminUpdate body: (required)
        :return: UserDetailsAdmin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `update_organization_user`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_organization_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/users/{user}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserDetailsAdmin',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
