# coding: utf-8

"""
    Flat API

    The Flat API allows you to easily extend the abilities of the [Flat Platform](https://flat.io), with a wide range of use cases including the following:  * Creating and importing new music scores using MusicXML, MIDI, Guitar Pro (GP3, GP4, GP5, GPX, GP), PowerTab, TuxGuitar and MuseScore files * Browsing, updating, copying, exporting the user's scores (for example in MP3, WAV or MIDI) * Managing educational resources with Flat for Education: creating & updating the organization accounts, the classes, rosters and assignments.  The Flat API is built on HTTP. Our API is RESTful It has predictable resource URLs. It returns HTTP response codes to indicate errors. It also accepts and returns JSON in the HTTP body. The [schema](/swagger.yaml) of this API follows the [OpenAPI Initiative (OAI) specification](https://www.openapis.org/), you can use and work with [compatible Swagger tools](http://swagger.io/open-source-integrations/). This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/).  You can use your favorite HTTP/REST library for your programming language to use Flat's API. This specification and reference is [available on Github](https://github.com/FlatIO/api-reference).  Getting Started and learn more:  * [API Overview and introduction](https://flat.io/developers/docs/api/) * [Authentication (Personal Access Tokens or OAuth2)](https://flat.io/developers/docs/api/authentication.html) * [SDKs](https://flat.io/developers/docs/api/sdks.html) * [Rate Limits](https://flat.io/developers/docs/api/rate-limits.html) * [Changelog](https://flat.io/developers/docs/api/changelog.html)   # noqa: E501

    OpenAPI spec version: 2.17.0
    Contact: developers@flat.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from flat_api.api_client import ApiClient


class ClassApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def activate_class(self, _class, **kwargs):  # noqa: E501
        """Activate the class  # noqa: E501

        Mark the class as `active`. This is mainly used for classes synchronized from Clever that are initially with an `inactive` state and hidden in the UI.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_class(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.activate_class_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.activate_class_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def activate_class_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Activate the class  # noqa: E501

        Mark the class as `active`. This is mainly used for classes synchronized from Clever that are initially with an `inactive` state and hidden in the UI.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.activate_class_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `activate_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/activate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_class_user(self, _class, user, **kwargs):  # noqa: E501
        """Add a user to the class  # noqa: E501

        This method can be used by a teacher of the class to enroll another Flat user into the class.  Only users that are part of your Organization can be enrolled in a class of this same Organization.  When enrolling a user in the class, Flat will automatically add this user to the corresponding Class group, based on this role in the Organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_class_user(_class, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str user: Unique identifier of the user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_class_user_with_http_info(_class, user, **kwargs)  # noqa: E501
        else:
            (data) = self.add_class_user_with_http_info(_class, user, **kwargs)  # noqa: E501
            return data

    def add_class_user_with_http_info(self, _class, user, **kwargs):  # noqa: E501
        """Add a user to the class  # noqa: E501

        This method can be used by a teacher of the class to enroll another Flat user into the class.  Only users that are part of your Organization can be enrolled in a class of this same Organization.  When enrolling a user in the class, Flat will automatically add this user to the corresponding Class group, based on this role in the Organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_class_user_with_http_info(_class, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str user: Unique identifier of the user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_class_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `add_class_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `add_class_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/users/{user}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def archive_assignment(self, _class, assignment, **kwargs):  # noqa: E501
        """Archive the assignment  # noqa: E501

        Archive the assignment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_assignment(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive_assignment_with_http_info(_class, assignment, **kwargs)  # noqa: E501
        else:
            (data) = self.archive_assignment_with_http_info(_class, assignment, **kwargs)  # noqa: E501
            return data

    def archive_assignment_with_http_info(self, _class, assignment, **kwargs):  # noqa: E501
        """Archive the assignment  # noqa: E501

        Archive the assignment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_assignment_with_http_info(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_assignment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `archive_assignment`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `archive_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/archive', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Assignment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def archive_class(self, _class, **kwargs):  # noqa: E501
        """Archive the class  # noqa: E501

        Mark the class as `archived`. When this course is synchronized with another app, like Google Classroom, this state will be automatically be updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_class(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive_class_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.archive_class_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def archive_class_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Archive the class  # noqa: E501

        Mark the class as `archived`. When this course is synchronized with another app, like Google Classroom, this state will be automatically be updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_class_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `archive_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/archive', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_assignment(self, _class, assignment, body, **kwargs):  # noqa: E501
        """Copy an assignment  # noqa: E501

        Copy an assignment to a specified class.  If the original assignment has a due date in the past, this new assingment will be created without a due date.  If the new class is synchronized with an external app (e.g. Google Classroom), the copied assignment will also be posted on the external app.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_assignment(_class, assignment, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param AssignmentCopy body: (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_assignment_with_http_info(_class, assignment, body, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_assignment_with_http_info(_class, assignment, body, **kwargs)  # noqa: E501
            return data

    def copy_assignment_with_http_info(self, _class, assignment, body, **kwargs):  # noqa: E501
        """Copy an assignment  # noqa: E501

        Copy an assignment to a specified class.  If the original assignment has a due date in the past, this new assingment will be created without a due date.  If the new class is synchronized with an external app (e.g. Google Classroom), the copied assignment will also be posted on the external app.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_assignment_with_http_info(_class, assignment, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param AssignmentCopy body: (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_assignment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `copy_assignment`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `copy_assignment`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `copy_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/copy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Assignment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_assignment(self, _class, **kwargs):  # noqa: E501
        """Assignment creation  # noqa: E501

        Use this method as a teacher to create and post a new assignment to a class.  If the class is synchronized with Google Classroom, the assignment will be automatically posted to your Classroom course.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_assignment(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param AssignmentCreation body:
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_assignment_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.create_assignment_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def create_assignment_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Assignment creation  # noqa: E501

        Use this method as a teacher to create and post a new assignment to a class.  If the class is synchronized with Google Classroom, the assignment will be automatically posted to your Classroom course.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_assignment_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param AssignmentCreation body:
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_assignment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `create_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Assignment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_class(self, body, **kwargs):  # noqa: E501
        """Create a new class  # noqa: E501

        Classrooms on Flat allow you to create activities with assignments and post content to a specific group.  When creating a class, Flat automatically creates two groups: one for the teachers of the course, one for the students. The creator of this class is automatically added to the teachers group.  If the classsroom is synchronized with another application like Google Classroom, some of the meta information will automatically be updated.  You can add users to this class using `PUT /classes/{class}/users/{user}`, they will automatically added to the group based on their role on Flat. Users can also enroll themselves to this class using `POST /classes/enroll/{enrollmentCode}` and the `enrollmentCode` returned in the `ClassDetails` response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_class(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClassCreation body: (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_class_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_class_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_class_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new class  # noqa: E501

        Classrooms on Flat allow you to create activities with assignments and post content to a specific group.  When creating a class, Flat automatically creates two groups: one for the teachers of the course, one for the students. The creator of this class is automatically added to the teachers group.  If the classsroom is synchronized with another application like Google Classroom, some of the meta information will automatically be updated.  You can add users to this class using `PUT /classes/{class}/users/{user}`, they will automatically added to the group based on their role on Flat. Users can also enroll themselves to this class using `POST /classes/enroll/{enrollmentCode}` and the `enrollmentCode` returned in the `ClassDetails` response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_class_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClassCreation body: (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_submission(self, _class, assignment, body, **kwargs):  # noqa: E501
        """Create or edit a submission  # noqa: E501

        Use this method as a student to create, update and submit a submission related to an assignment. Students can only set `attachments` and `submit`. Teachers can use `PUT /classes/{class}/assignments/{assignment}/submissions/{submission}` to update a submission by id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_submission(_class, assignment, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param AssignmentSubmissionUpdate body: (required)
        :return: AssignmentSubmission
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_submission_with_http_info(_class, assignment, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_submission_with_http_info(_class, assignment, body, **kwargs)  # noqa: E501
            return data

    def create_submission_with_http_info(self, _class, assignment, body, **kwargs):  # noqa: E501
        """Create or edit a submission  # noqa: E501

        Use this method as a student to create, update and submit a submission related to an assignment. Students can only set `attachments` and `submit`. Teachers can use `PUT /classes/{class}/assignments/{assignment}/submissions/{submission}` to update a submission by id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_submission_with_http_info(_class, assignment, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param AssignmentSubmissionUpdate body: (required)
        :return: AssignmentSubmission
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_submission" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `create_submission`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `create_submission`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_submission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssignmentSubmission',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_class_user(self, _class, user, **kwargs):  # noqa: E501
        """Remove a user from the class  # noqa: E501

        This method can be used by a teacher to remove a user from the class, or by a student to leave the classroom.  Warning: Removing a user from the class will remove the associated resources, including the submissions and feedback related to these submissions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_class_user(_class, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str user: Unique identifier of the user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_class_user_with_http_info(_class, user, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_class_user_with_http_info(_class, user, **kwargs)  # noqa: E501
            return data

    def delete_class_user_with_http_info(self, _class, user, **kwargs):  # noqa: E501
        """Remove a user from the class  # noqa: E501

        This method can be used by a teacher to remove a user from the class, or by a student to leave the classroom.  Warning: Removing a user from the class will remove the associated resources, including the submissions and feedback related to these submissions.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_class_user_with_http_info(_class, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str user: Unique identifier of the user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_class_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `delete_class_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `delete_class_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/users/{user}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submission(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """Delete a submission  # noqa: E501

        Use this method as a teacher to delete a submission and allow student to start over the assignment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submission(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submission_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submission_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
            return data

    def delete_submission_with_http_info(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """Delete a submission  # noqa: E501

        Use this method as a teacher to delete a submission and allow student to start over the assignment   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submission_with_http_info(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submission" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `delete_submission`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `delete_submission`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `delete_submission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_submission_comment(self, _class, assignment, submission, comment, **kwargs):  # noqa: E501
        """Delete a feedback comment to a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submission_comment(_class, assignment, submission, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param str comment: Unique identifier of the comment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_submission_comment_with_http_info(_class, assignment, submission, comment, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_submission_comment_with_http_info(_class, assignment, submission, comment, **kwargs)  # noqa: E501
            return data

    def delete_submission_comment_with_http_info(self, _class, assignment, submission, comment, **kwargs):  # noqa: E501
        """Delete a feedback comment to a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_submission_comment_with_http_info(_class, assignment, submission, comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param str comment: Unique identifier of the comment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission', 'comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_submission_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `delete_submission_comment`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `delete_submission_comment`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `delete_submission_comment`")  # noqa: E501
        # verify the required parameter 'comment' is set
        if ('comment' not in local_var_params or
                local_var_params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `delete_submission_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501
        if 'comment' in local_var_params:
            path_params['comment'] = local_var_params['comment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}/comments/{comment}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_submission(self, _class, assignment, submission, body, **kwargs):  # noqa: E501
        """Edit a submission  # noqa: E501

        Use this method as a teacher to update the different submission and give feedback. Teachers can only set `return`, `draftGrade` and `grade`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_submission(_class, assignment, submission, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param AssignmentSubmissionUpdate body: (required)
        :return: AssignmentSubmission
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_submission_with_http_info(_class, assignment, submission, body, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_submission_with_http_info(_class, assignment, submission, body, **kwargs)  # noqa: E501
            return data

    def edit_submission_with_http_info(self, _class, assignment, submission, body, **kwargs):  # noqa: E501
        """Edit a submission  # noqa: E501

        Use this method as a teacher to update the different submission and give feedback. Teachers can only set `return`, `draftGrade` and `grade`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_submission_with_http_info(_class, assignment, submission, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param AssignmentSubmissionUpdate body: (required)
        :return: AssignmentSubmission
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_submission" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `edit_submission`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `edit_submission`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `edit_submission`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `edit_submission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssignmentSubmission',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def enroll_class(self, enrollment_code, **kwargs):  # noqa: E501
        """Join a class  # noqa: E501

        Use this method to join a class using an enrollment code given one of the teacher of this class. This code is also available in the `ClassDetails` returned to the teachers when creating the class or listing / fetching a specific class.  Flat will automatically add the user to the corresponding class group based on this role in the organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enroll_class(enrollment_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enrollment_code: The enrollment code, available to the teacher in `ClassDetails`  (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.enroll_class_with_http_info(enrollment_code, **kwargs)  # noqa: E501
        else:
            (data) = self.enroll_class_with_http_info(enrollment_code, **kwargs)  # noqa: E501
            return data

    def enroll_class_with_http_info(self, enrollment_code, **kwargs):  # noqa: E501
        """Join a class  # noqa: E501

        Use this method to join a class using an enrollment code given one of the teacher of this class. This code is also available in the `ClassDetails` returned to the teachers when creating the class or listing / fetching a specific class.  Flat will automatically add the user to the corresponding class group based on this role in the organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enroll_class_with_http_info(enrollment_code, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str enrollment_code: The enrollment code, available to the teacher in `ClassDetails`  (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['enrollment_code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enroll_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'enrollment_code' is set
        if ('enrollment_code' not in local_var_params or
                local_var_params['enrollment_code'] is None):
            raise ValueError("Missing the required parameter `enrollment_code` when calling `enroll_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'enrollment_code' in local_var_params:
            path_params['enrollmentCode'] = local_var_params['enrollment_code']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/enroll/{enrollmentCode}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_submissions_reviews_as_csv(self, _class, assignment, **kwargs):  # noqa: E501
        """CSV Grades exports  # noqa: E501

        Export list of submissions grades to a CSV file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_submissions_reviews_as_csv(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_submissions_reviews_as_csv_with_http_info(_class, assignment, **kwargs)  # noqa: E501
        else:
            (data) = self.export_submissions_reviews_as_csv_with_http_info(_class, assignment, **kwargs)  # noqa: E501
            return data

    def export_submissions_reviews_as_csv_with_http_info(self, _class, assignment, **kwargs):  # noqa: E501
        """CSV Grades exports  # noqa: E501

        Export list of submissions grades to a CSV file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_submissions_reviews_as_csv_with_http_info(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_submissions_reviews_as_csv" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `export_submissions_reviews_as_csv`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `export_submissions_reviews_as_csv`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/csv'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/csv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_submissions_reviews_as_excel(self, _class, assignment, **kwargs):  # noqa: E501
        """Excel Grades exports  # noqa: E501

        Export list of submissions grades to an Excel file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_submissions_reviews_as_excel(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_submissions_reviews_as_excel_with_http_info(_class, assignment, **kwargs)  # noqa: E501
        else:
            (data) = self.export_submissions_reviews_as_excel_with_http_info(_class, assignment, **kwargs)  # noqa: E501
            return data

    def export_submissions_reviews_as_excel_with_http_info(self, _class, assignment, **kwargs):  # noqa: E501
        """Excel Grades exports  # noqa: E501

        Export list of submissions grades to an Excel file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_submissions_reviews_as_excel_with_http_info(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_submissions_reviews_as_excel" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `export_submissions_reviews_as_excel`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `export_submissions_reviews_as_excel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/excel', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fork_score(self, score, body, **kwargs):  # noqa: E501
        """Fork a score  # noqa: E501

        This API call will make a copy of the last revision of the specified score and create a new score. The copy of the score will have a privacy set to `private`.  When using a [Flat for Education](https://flat.io/edu) account, the inline and contextualized comments will be accessible in the child document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fork_score(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreFork body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fork_score_with_http_info(score, body, **kwargs)  # noqa: E501
        else:
            (data) = self.fork_score_with_http_info(score, body, **kwargs)  # noqa: E501
            return data

    def fork_score_with_http_info(self, score, body, **kwargs):  # noqa: E501
        """Fork a score  # noqa: E501

        This API call will make a copy of the last revision of the specified score and create a new score. The copy of the score will have a privacy set to `private`.  When using a [Flat for Education](https://flat.io/edu) account, the inline and contextualized comments will be accessible in the child document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fork_score_with_http_info(score, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :param ScoreFork body: (required)
        :param str sharing_key: This sharing key must be specified to access to a score or collection with a `privacy` mode set to `privateLink` and the current user is not a collaborator of the document. 
        :return: ScoreDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score', 'body', 'sharing_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fork_score" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `fork_score`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `fork_score`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []
        if 'sharing_key' in local_var_params:
            query_params.append(('sharingKey', local_var_params['sharing_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/fork', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScoreDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_class(self, _class, **kwargs):  # noqa: E501
        """Get the details of a single class  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_class(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_class_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.get_class_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def get_class_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Get the details of a single class  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_class_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `get_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_score_submissions(self, score, **kwargs):  # noqa: E501
        """List submissions related to the score  # noqa: E501

        This API call will list the different assignments submissions where the score is attached. This method can be used by anyone that are part of the organization and have at least read access to the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_submissions(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_score_submissions_with_http_info(score, **kwargs)  # noqa: E501
        else:
            (data) = self.get_score_submissions_with_http_info(score, **kwargs)  # noqa: E501
            return data

    def get_score_submissions_with_http_info(self, score, **kwargs):  # noqa: E501
        """List submissions related to the score  # noqa: E501

        This API call will list the different assignments submissions where the score is attached. This method can be used by anyone that are part of the organization and have at least read access to the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_score_submissions_with_http_info(score, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str score: Unique identifier of the score document. This can be a Flat Score unique identifier (i.e. `ScoreDetails.id`) or, if the score is also a Google Drive file, the Drive file unique identifier prefixed with `drive-` (e.g. `drive-0B000000000`).  (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['score']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_score_submissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'score' is set
        if ('score' not in local_var_params or
                local_var_params['score'] is None):
            raise ValueError("Missing the required parameter `score` when calling `get_score_submissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'score' in local_var_params:
            path_params['score'] = local_var_params['score']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/scores/{score}/submissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssignmentSubmission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submission(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """Get a student submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: AssignmentSubmission
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submission_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submission_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
            return data

    def get_submission_with_http_info(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """Get a student submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_with_http_info(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: AssignmentSubmission
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submission" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `get_submission`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `get_submission`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `get_submission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssignmentSubmission',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submission_comments(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """List the feedback comments of a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_comments(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: list[AssignmentSubmissionComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submission_comments_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submission_comments_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
            return data

    def get_submission_comments_with_http_info(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """List the feedback comments of a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_comments_with_http_info(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: list[AssignmentSubmissionComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submission_comments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `get_submission_comments`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `get_submission_comments`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `get_submission_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssignmentSubmissionComment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submission_history(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """Get the history of the submission  # noqa: E501

        For teachers only. Returns a detailed history of the submission. This currently includes state and grade histories.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_history(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: list[AssignmentSubmissionHistory]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submission_history_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submission_history_with_http_info(_class, assignment, submission, **kwargs)  # noqa: E501
            return data

    def get_submission_history_with_http_info(self, _class, assignment, submission, **kwargs):  # noqa: E501
        """Get the history of the submission  # noqa: E501

        For teachers only. Returns a detailed history of the submission. This currently includes state and grade histories.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submission_history_with_http_info(_class, assignment, submission, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :return: list[AssignmentSubmissionHistory]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submission_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `get_submission_history`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `get_submission_history`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `get_submission_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssignmentSubmissionHistory]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_submissions(self, _class, assignment, **kwargs):  # noqa: E501
        """List the students&#39; submissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submissions(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_submissions_with_http_info(_class, assignment, **kwargs)  # noqa: E501
        else:
            (data) = self.get_submissions_with_http_info(_class, assignment, **kwargs)  # noqa: E501
            return data

    def get_submissions_with_http_info(self, _class, assignment, **kwargs):  # noqa: E501
        """List the students&#39; submissions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_submissions_with_http_info(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_submissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `get_submissions`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `get_submissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssignmentSubmission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_assignments(self, _class, **kwargs):  # noqa: E501
        """Assignments listing  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_assignments(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: list[Assignment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_assignments_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.list_assignments_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def list_assignments_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Assignments listing  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_assignments_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: list[Assignment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assignments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `list_assignments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Assignment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_class_student_submissions(self, _class, user, **kwargs):  # noqa: E501
        """List the submissions for a student  # noqa: E501

        Use this method as a teacher to list all the assignment submissions sent by a student of the class   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_class_student_submissions(_class, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str user: Unique identifier of the user (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_class_student_submissions_with_http_info(_class, user, **kwargs)  # noqa: E501
        else:
            (data) = self.list_class_student_submissions_with_http_info(_class, user, **kwargs)  # noqa: E501
            return data

    def list_class_student_submissions_with_http_info(self, _class, user, **kwargs):  # noqa: E501
        """List the submissions for a student  # noqa: E501

        Use this method as a teacher to list all the assignment submissions sent by a student of the class   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_class_student_submissions_with_http_info(_class, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str user: Unique identifier of the user (required)
        :return: list[AssignmentSubmission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_class_student_submissions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `list_class_student_submissions`")  # noqa: E501
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `list_class_student_submissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'user' in local_var_params:
            path_params['user'] = local_var_params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/students/{user}/submissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssignmentSubmission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_classes(self, **kwargs):  # noqa: E501
        """List the classes available for the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_classes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str state: Filter the classes by state
        :return: list[ClassDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_classes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_classes_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_classes_with_http_info(self, **kwargs):  # noqa: E501
        """List the classes available for the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_classes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str state: Filter the classes by state
        :return: list[ClassDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_classes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'state' in local_var_params:
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ClassDetails]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_submission_comment(self, _class, assignment, submission, assignment_submission_comment_creation, **kwargs):  # noqa: E501
        """Add a feedback comment to a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submission_comment(_class, assignment, submission, assignment_submission_comment_creation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param AssignmentSubmissionCommentCreation assignment_submission_comment_creation: (required)
        :return: AssignmentSubmissionComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_submission_comment_with_http_info(_class, assignment, submission, assignment_submission_comment_creation, **kwargs)  # noqa: E501
        else:
            (data) = self.post_submission_comment_with_http_info(_class, assignment, submission, assignment_submission_comment_creation, **kwargs)  # noqa: E501
            return data

    def post_submission_comment_with_http_info(self, _class, assignment, submission, assignment_submission_comment_creation, **kwargs):  # noqa: E501
        """Add a feedback comment to a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_submission_comment_with_http_info(_class, assignment, submission, assignment_submission_comment_creation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param AssignmentSubmissionCommentCreation assignment_submission_comment_creation: (required)
        :return: AssignmentSubmissionComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission', 'assignment_submission_comment_creation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_submission_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `post_submission_comment`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `post_submission_comment`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `post_submission_comment`")  # noqa: E501
        # verify the required parameter 'assignment_submission_comment_creation' is set
        if ('assignment_submission_comment_creation' not in local_var_params or
                local_var_params['assignment_submission_comment_creation'] is None):
            raise ValueError("Missing the required parameter `assignment_submission_comment_creation` when calling `post_submission_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'assignment_submission_comment_creation' in local_var_params:
            body_params = local_var_params['assignment_submission_comment_creation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssignmentSubmissionComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unarchive_assignment(self, _class, assignment, **kwargs):  # noqa: E501
        """Unarchive the assignment.  # noqa: E501

        Mark the assignment as `active`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unarchive_assignment(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unarchive_assignment_with_http_info(_class, assignment, **kwargs)  # noqa: E501
        else:
            (data) = self.unarchive_assignment_with_http_info(_class, assignment, **kwargs)  # noqa: E501
            return data

    def unarchive_assignment_with_http_info(self, _class, assignment, **kwargs):  # noqa: E501
        """Unarchive the assignment.  # noqa: E501

        Mark the assignment as `active`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unarchive_assignment_with_http_info(_class, assignment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unarchive_assignment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `unarchive_assignment`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `unarchive_assignment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/archive', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Assignment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unarchive_class(self, _class, **kwargs):  # noqa: E501
        """Unarchive the class  # noqa: E501

        Mark the class as `active`. When this course is synchronized with another app, like Google Classroom, this state will be automatically be updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unarchive_class(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unarchive_class_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.unarchive_class_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def unarchive_class_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Unarchive the class  # noqa: E501

        Mark the class as `active`. When this course is synchronized with another app, like Google Classroom, this state will be automatically be updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unarchive_class_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unarchive_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `unarchive_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/archive', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_class(self, _class, **kwargs):  # noqa: E501
        """Update the class  # noqa: E501

        Update the meta information of the class   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_class(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param ClassUpdate body: Details of the Class
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_class_with_http_info(_class, **kwargs)  # noqa: E501
        else:
            (data) = self.update_class_with_http_info(_class, **kwargs)  # noqa: E501
            return data

    def update_class_with_http_info(self, _class, **kwargs):  # noqa: E501
        """Update the class  # noqa: E501

        Update the meta information of the class   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_class_with_http_info(_class, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param ClassUpdate body: Details of the Class
        :return: ClassDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_class" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `update_class`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_submission_comment(self, _class, assignment, submission, comment, assignment_submission_comment_creation, **kwargs):  # noqa: E501
        """Update a feedback comment to a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_submission_comment(_class, assignment, submission, comment, assignment_submission_comment_creation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param str comment: Unique identifier of the comment (required)
        :param AssignmentSubmissionCommentCreation assignment_submission_comment_creation: (required)
        :return: AssignmentSubmissionComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_submission_comment_with_http_info(_class, assignment, submission, comment, assignment_submission_comment_creation, **kwargs)  # noqa: E501
        else:
            (data) = self.update_submission_comment_with_http_info(_class, assignment, submission, comment, assignment_submission_comment_creation, **kwargs)  # noqa: E501
            return data

    def update_submission_comment_with_http_info(self, _class, assignment, submission, comment, assignment_submission_comment_creation, **kwargs):  # noqa: E501
        """Update a feedback comment to a submission  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_submission_comment_with_http_info(_class, assignment, submission, comment, assignment_submission_comment_creation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str _class: Unique identifier of the class (required)
        :param str assignment: Unique identifier of the assignment (required)
        :param str submission: Unique identifier of the submission (required)
        :param str comment: Unique identifier of the comment (required)
        :param AssignmentSubmissionCommentCreation assignment_submission_comment_creation: (required)
        :return: AssignmentSubmissionComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_class', 'assignment', 'submission', 'comment', 'assignment_submission_comment_creation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_submission_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_class' is set
        if ('_class' not in local_var_params or
                local_var_params['_class'] is None):
            raise ValueError("Missing the required parameter `_class` when calling `update_submission_comment`")  # noqa: E501
        # verify the required parameter 'assignment' is set
        if ('assignment' not in local_var_params or
                local_var_params['assignment'] is None):
            raise ValueError("Missing the required parameter `assignment` when calling `update_submission_comment`")  # noqa: E501
        # verify the required parameter 'submission' is set
        if ('submission' not in local_var_params or
                local_var_params['submission'] is None):
            raise ValueError("Missing the required parameter `submission` when calling `update_submission_comment`")  # noqa: E501
        # verify the required parameter 'comment' is set
        if ('comment' not in local_var_params or
                local_var_params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `update_submission_comment`")  # noqa: E501
        # verify the required parameter 'assignment_submission_comment_creation' is set
        if ('assignment_submission_comment_creation' not in local_var_params or
                local_var_params['assignment_submission_comment_creation'] is None):
            raise ValueError("Missing the required parameter `assignment_submission_comment_creation` when calling `update_submission_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if '_class' in local_var_params:
            path_params['class'] = local_var_params['_class']  # noqa: E501
        if 'assignment' in local_var_params:
            path_params['assignment'] = local_var_params['assignment']  # noqa: E501
        if 'submission' in local_var_params:
            path_params['submission'] = local_var_params['submission']  # noqa: E501
        if 'comment' in local_var_params:
            path_params['comment'] = local_var_params['comment']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'assignment_submission_comment_creation' in local_var_params:
            body_params = local_var_params['assignment_submission_comment_creation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/classes/{class}/assignments/{assignment}/submissions/{submission}/comments/{comment}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssignmentSubmissionComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
