"""Mercurial Repo object for libvcs.

.. todo::

   The following is from pypa/pip (MIT license):

   - [`MercurialRepo.convert_pip_url`](libvcs.hg.convert_pip_url)
   - [`MercurialRepo.get_url`](libvcs.hg.MercurialRepo.get_url)
   - [`MercurialRepo.get_revision`](libvcs.hg.MercurialRepo.get_revision)
"""  # NOQA E5
import logging
import pathlib

from .base import BaseRepo

logger = logging.getLogger(__name__)


class MercurialRepo(BaseRepo):
    bin_name = "hg"
    schemes = ("hg", "hg+http", "hg+https", "hg+file")

    def __init__(self, url, dir, *args, **kwargs):
        BaseRepo.__init__(self, url, dir, *args, **kwargs)

    def obtain(self, *args, **kwargs):
        self.ensure_dir()

        # Double hyphens between [OPTION]... -- SOURCE [DEST] prevent command injections
        # via aliases
        self.run(["clone", "--noupdate", "-q", "--", self.url, self.dir])
        self.run(["update", "-q"])

    def get_revision(self):
        return self.run(["parents", "--template={rev}"])

    def update_repo(self, *args, **kwargs):
        self.ensure_dir()
        if not pathlib.Path(self.dir / ".hg").exists():
            self.obtain()
            self.update_repo()
        else:
            self.run(["update"])
            self.run(["pull", "-u"])
