# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 purpose: pulumi.Input[str],
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_start: Optional[pulumi.Input[str]] = None,
                 dhcp_stop: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 igmp_snooping: Optional[pulumi.Input[bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[bool]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_group: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[int]] = None,
                 wan_gateway: Optional[pulumi.Input[str]] = None,
                 wan_ip: Optional[pulumi.Input[str]] = None,
                 wan_netmask: Optional[pulumi.Input[str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[str]] = None,
                 wan_type: Optional[pulumi.Input[str]] = None,
                 wan_username: Optional[pulumi.Input[str]] = None,
                 x_wan_password: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[int] dhcp_lease: Specifies the lease time for DHCP addresses. Defaults to `86400`.
        :param pulumi.Input[bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[str] domain_name: The domain name of this network.
        :param pulumi.Input[bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Defaults to `none`.
        :param pulumi.Input[str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD.
        :param pulumi.Input[str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[str] ipv6_static_subnet: Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        :param pulumi.Input[str] name: The name of the network.
        :param pulumi.Input[str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[str] site: The name of the site to associate the network with.
        :param pulumi.Input[str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[str] x_wan_password: Specifies the IPV4 WAN password.
        """
        pulumi.set(__self__, "purpose", purpose)
        if dhcp_dns is not None:
            pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        if dhcp_enabled is not None:
            pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)
        if dhcp_lease is not None:
            pulumi.set(__self__, "dhcp_lease", dhcp_lease)
        if dhcp_relay_enabled is not None:
            pulumi.set(__self__, "dhcp_relay_enabled", dhcp_relay_enabled)
        if dhcp_start is not None:
            pulumi.set(__self__, "dhcp_start", dhcp_start)
        if dhcp_stop is not None:
            pulumi.set(__self__, "dhcp_stop", dhcp_stop)
        if dhcpd_boot_enabled is not None:
            pulumi.set(__self__, "dhcpd_boot_enabled", dhcpd_boot_enabled)
        if dhcpd_boot_filename is not None:
            pulumi.set(__self__, "dhcpd_boot_filename", dhcpd_boot_filename)
        if dhcpd_boot_server is not None:
            pulumi.set(__self__, "dhcpd_boot_server", dhcpd_boot_server)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if igmp_snooping is not None:
            pulumi.set(__self__, "igmp_snooping", igmp_snooping)
        if ipv6_interface_type is not None:
            pulumi.set(__self__, "ipv6_interface_type", ipv6_interface_type)
        if ipv6_pd_interface is not None:
            pulumi.set(__self__, "ipv6_pd_interface", ipv6_pd_interface)
        if ipv6_pd_prefixid is not None:
            pulumi.set(__self__, "ipv6_pd_prefixid", ipv6_pd_prefixid)
        if ipv6_ra_enable is not None:
            pulumi.set(__self__, "ipv6_ra_enable", ipv6_ra_enable)
        if ipv6_static_subnet is not None:
            pulumi.set(__self__, "ipv6_static_subnet", ipv6_static_subnet)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group is not None:
            pulumi.set(__self__, "network_group", network_group)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wan_dns is not None:
            pulumi.set(__self__, "wan_dns", wan_dns)
        if wan_egress_qos is not None:
            pulumi.set(__self__, "wan_egress_qos", wan_egress_qos)
        if wan_gateway is not None:
            pulumi.set(__self__, "wan_gateway", wan_gateway)
        if wan_ip is not None:
            pulumi.set(__self__, "wan_ip", wan_ip)
        if wan_netmask is not None:
            pulumi.set(__self__, "wan_netmask", wan_netmask)
        if wan_networkgroup is not None:
            pulumi.set(__self__, "wan_networkgroup", wan_networkgroup)
        if wan_type is not None:
            pulumi.set(__self__, "wan_type", wan_type)
        if wan_username is not None:
            pulumi.set(__self__, "wan_username", wan_username)
        if x_wan_password is not None:
            pulumi.set(__self__, "x_wan_password", x_wan_password)

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Input[str]:
        """
        The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: pulumi.Input[str]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        """
        return pulumi.get(self, "dhcp_dns")

    @dhcp_dns.setter
    def dhcp_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dhcp_dns", value)

    @property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @dhcp_enabled.setter
    def dhcp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_enabled", value)

    @property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the lease time for DHCP addresses. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_lease")

    @dhcp_lease.setter
    def dhcp_lease(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dhcp_lease", value)

    @property
    @pulumi.getter(name="dhcpRelayEnabled")
    def dhcp_relay_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether DHCP relay is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_relay_enabled")

    @dhcp_relay_enabled.setter
    def dhcp_relay_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_relay_enabled", value)

    @property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @dhcp_start.setter
    def dhcp_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_start", value)

    @property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @dhcp_stop.setter
    def dhcp_stop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_stop", value)

    @property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @dhcpd_boot_enabled.setter
    def dhcpd_boot_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcpd_boot_enabled", value)

    @property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @dhcpd_boot_filename.setter
    def dhcpd_boot_filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcpd_boot_filename", value)

    @property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @dhcpd_boot_server.setter
    def dhcpd_boot_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcpd_boot_server", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @igmp_snooping.setter
    def igmp_snooping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "igmp_snooping", value)

    @property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which type of IPv6 connection to use. Defaults to `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @ipv6_interface_type.setter
    def ipv6_interface_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_interface_type", value)

    @property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which WAN interface to use for IPv6 PD.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @ipv6_pd_interface.setter
    def ipv6_pd_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_pd_interface", value)

    @property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @ipv6_pd_prefixid.setter
    def ipv6_pd_prefixid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_pd_prefixid", value)

    @property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @ipv6_ra_enable.setter
    def ipv6_ra_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_ra_enable", value)

    @property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @ipv6_static_subnet.setter
    def ipv6_static_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_static_subnet", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> Optional[pulumi.Input[str]]:
        """
        The group of the network. Defaults to `LAN`.
        """
        return pulumi.get(self, "network_group")

    @network_group.setter
    def network_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_group", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of the network. Must be a valid CIDR address.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @wan_dns.setter
    def wan_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wan_dns", value)

    @property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the WAN egress quality of service. Defaults to `0`.
        """
        return pulumi.get(self, "wan_egress_qos")

    @wan_egress_qos.setter
    def wan_egress_qos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wan_egress_qos", value)

    @property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @wan_gateway.setter
    def wan_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_gateway", value)

    @property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @wan_ip.setter
    def wan_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_ip", value)

    @property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @wan_netmask.setter
    def wan_netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_netmask", value)

    @property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @wan_networkgroup.setter
    def wan_networkgroup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_networkgroup", value)

    @property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @wan_type.setter
    def wan_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_type", value)

    @property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @wan_username.setter
    def wan_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_username", value)

    @property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")

    @x_wan_password.setter
    def x_wan_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x_wan_password", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_start: Optional[pulumi.Input[str]] = None,
                 dhcp_stop: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 igmp_snooping: Optional[pulumi.Input[bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[bool]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_group: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[int]] = None,
                 wan_gateway: Optional[pulumi.Input[str]] = None,
                 wan_ip: Optional[pulumi.Input[str]] = None,
                 wan_netmask: Optional[pulumi.Input[str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[str]] = None,
                 wan_type: Optional[pulumi.Input[str]] = None,
                 wan_username: Optional[pulumi.Input[str]] = None,
                 x_wan_password: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[int] dhcp_lease: Specifies the lease time for DHCP addresses. Defaults to `86400`.
        :param pulumi.Input[bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[str] domain_name: The domain name of this network.
        :param pulumi.Input[bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Defaults to `none`.
        :param pulumi.Input[str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD.
        :param pulumi.Input[str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[str] ipv6_static_subnet: Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        :param pulumi.Input[str] name: The name of the network.
        :param pulumi.Input[str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[str] site: The name of the site to associate the network with.
        :param pulumi.Input[str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[str] x_wan_password: Specifies the IPV4 WAN password.
        """
        if dhcp_dns is not None:
            pulumi.set(__self__, "dhcp_dns", dhcp_dns)
        if dhcp_enabled is not None:
            pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)
        if dhcp_lease is not None:
            pulumi.set(__self__, "dhcp_lease", dhcp_lease)
        if dhcp_relay_enabled is not None:
            pulumi.set(__self__, "dhcp_relay_enabled", dhcp_relay_enabled)
        if dhcp_start is not None:
            pulumi.set(__self__, "dhcp_start", dhcp_start)
        if dhcp_stop is not None:
            pulumi.set(__self__, "dhcp_stop", dhcp_stop)
        if dhcpd_boot_enabled is not None:
            pulumi.set(__self__, "dhcpd_boot_enabled", dhcpd_boot_enabled)
        if dhcpd_boot_filename is not None:
            pulumi.set(__self__, "dhcpd_boot_filename", dhcpd_boot_filename)
        if dhcpd_boot_server is not None:
            pulumi.set(__self__, "dhcpd_boot_server", dhcpd_boot_server)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if igmp_snooping is not None:
            pulumi.set(__self__, "igmp_snooping", igmp_snooping)
        if ipv6_interface_type is not None:
            pulumi.set(__self__, "ipv6_interface_type", ipv6_interface_type)
        if ipv6_pd_interface is not None:
            pulumi.set(__self__, "ipv6_pd_interface", ipv6_pd_interface)
        if ipv6_pd_prefixid is not None:
            pulumi.set(__self__, "ipv6_pd_prefixid", ipv6_pd_prefixid)
        if ipv6_ra_enable is not None:
            pulumi.set(__self__, "ipv6_ra_enable", ipv6_ra_enable)
        if ipv6_static_subnet is not None:
            pulumi.set(__self__, "ipv6_static_subnet", ipv6_static_subnet)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group is not None:
            pulumi.set(__self__, "network_group", network_group)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if wan_dns is not None:
            pulumi.set(__self__, "wan_dns", wan_dns)
        if wan_egress_qos is not None:
            pulumi.set(__self__, "wan_egress_qos", wan_egress_qos)
        if wan_gateway is not None:
            pulumi.set(__self__, "wan_gateway", wan_gateway)
        if wan_ip is not None:
            pulumi.set(__self__, "wan_ip", wan_ip)
        if wan_netmask is not None:
            pulumi.set(__self__, "wan_netmask", wan_netmask)
        if wan_networkgroup is not None:
            pulumi.set(__self__, "wan_networkgroup", wan_networkgroup)
        if wan_type is not None:
            pulumi.set(__self__, "wan_type", wan_type)
        if wan_username is not None:
            pulumi.set(__self__, "wan_username", wan_username)
        if x_wan_password is not None:
            pulumi.set(__self__, "x_wan_password", x_wan_password)

    @property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        """
        return pulumi.get(self, "dhcp_dns")

    @dhcp_dns.setter
    def dhcp_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dhcp_dns", value)

    @property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @dhcp_enabled.setter
    def dhcp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_enabled", value)

    @property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the lease time for DHCP addresses. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_lease")

    @dhcp_lease.setter
    def dhcp_lease(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dhcp_lease", value)

    @property
    @pulumi.getter(name="dhcpRelayEnabled")
    def dhcp_relay_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether DHCP relay is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_relay_enabled")

    @dhcp_relay_enabled.setter
    def dhcp_relay_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_relay_enabled", value)

    @property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @dhcp_start.setter
    def dhcp_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_start", value)

    @property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @dhcp_stop.setter
    def dhcp_stop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcp_stop", value)

    @property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @dhcpd_boot_enabled.setter
    def dhcpd_boot_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcpd_boot_enabled", value)

    @property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @dhcpd_boot_filename.setter
    def dhcpd_boot_filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcpd_boot_filename", value)

    @property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @dhcpd_boot_server.setter
    def dhcpd_boot_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dhcpd_boot_server", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @igmp_snooping.setter
    def igmp_snooping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "igmp_snooping", value)

    @property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which type of IPv6 connection to use. Defaults to `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @ipv6_interface_type.setter
    def ipv6_interface_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_interface_type", value)

    @property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which WAN interface to use for IPv6 PD.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @ipv6_pd_interface.setter
    def ipv6_pd_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_pd_interface", value)

    @property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @ipv6_pd_prefixid.setter
    def ipv6_pd_prefixid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_pd_prefixid", value)

    @property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @ipv6_ra_enable.setter
    def ipv6_ra_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6_ra_enable", value)

    @property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @ipv6_static_subnet.setter
    def ipv6_static_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_static_subnet", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> Optional[pulumi.Input[str]]:
        """
        The group of the network. Defaults to `LAN`.
        """
        return pulumi.get(self, "network_group")

    @network_group.setter
    def network_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_group", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of the network. Must be a valid CIDR address.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @wan_dns.setter
    def wan_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wan_dns", value)

    @property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the WAN egress quality of service. Defaults to `0`.
        """
        return pulumi.get(self, "wan_egress_qos")

    @wan_egress_qos.setter
    def wan_egress_qos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wan_egress_qos", value)

    @property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @wan_gateway.setter
    def wan_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_gateway", value)

    @property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @wan_ip.setter
    def wan_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_ip", value)

    @property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @wan_netmask.setter
    def wan_netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_netmask", value)

    @property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @wan_networkgroup.setter
    def wan_networkgroup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_networkgroup", value)

    @property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @wan_type.setter
    def wan_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_type", value)

    @property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @wan_username.setter
    def wan_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wan_username", value)

    @property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")

    @x_wan_password.setter
    def x_wan_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x_wan_password", value)


class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_start: Optional[pulumi.Input[str]] = None,
                 dhcp_stop: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 igmp_snooping: Optional[pulumi.Input[bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[bool]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_group: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[int]] = None,
                 wan_gateway: Optional[pulumi.Input[str]] = None,
                 wan_ip: Optional[pulumi.Input[str]] = None,
                 wan_netmask: Optional[pulumi.Input[str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[str]] = None,
                 wan_type: Optional[pulumi.Input[str]] = None,
                 wan_username: Optional[pulumi.Input[str]] = None,
                 x_wan_password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `Network` manages WAN/LAN/VLAN networks.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        vlan = unifi.Network("vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        wan = unifi.Network("wan",
            purpose="wan",
            wan_networkgroup="WAN",
            wan_type="pppoe",
            wan_ip="192.168.1.1",
            wan_egress_qos=1,
            wan_username="username",
            x_wan_password="password")
        ```

        ## Import

        # import from provider configured site

        ```sh
         $ pulumi import unifi:index/network:Network mynetwork 5dc28e5e9106d105bdc87217
        ```

        # import from another site

        ```sh
         $ pulumi import unifi:index/network:Network mynetwork bfa2l6i7:5dc28e5e9106d105bdc87217
        ```

        # import network by name

        ```sh
         $ pulumi import unifi:index/network:Network mynetwork name=LAN
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[int] dhcp_lease: Specifies the lease time for DHCP addresses. Defaults to `86400`.
        :param pulumi.Input[bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[str] domain_name: The domain name of this network.
        :param pulumi.Input[bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Defaults to `none`.
        :param pulumi.Input[str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD.
        :param pulumi.Input[str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[str] ipv6_static_subnet: Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        :param pulumi.Input[str] name: The name of the network.
        :param pulumi.Input[str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[str] site: The name of the site to associate the network with.
        :param pulumi.Input[str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[str] x_wan_password: Specifies the IPV4 WAN password.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `Network` manages WAN/LAN/VLAN networks.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        config = pulumi.Config()
        vlan_id = config.get_float("vlanId")
        if vlan_id is None:
            vlan_id = 10
        vlan = unifi.Network("vlan",
            purpose="corporate",
            subnet="10.0.0.1/24",
            vlan_id=vlan_id,
            dhcp_start="10.0.0.6",
            dhcp_stop="10.0.0.254",
            dhcp_enabled=True)
        wan = unifi.Network("wan",
            purpose="wan",
            wan_networkgroup="WAN",
            wan_type="pppoe",
            wan_ip="192.168.1.1",
            wan_egress_qos=1,
            wan_username="username",
            x_wan_password="password")
        ```

        ## Import

        # import from provider configured site

        ```sh
         $ pulumi import unifi:index/network:Network mynetwork 5dc28e5e9106d105bdc87217
        ```

        # import from another site

        ```sh
         $ pulumi import unifi:index/network:Network mynetwork bfa2l6i7:5dc28e5e9106d105bdc87217
        ```

        # import network by name

        ```sh
         $ pulumi import unifi:index/network:Network mynetwork name=LAN
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dhcp_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_lease: Optional[pulumi.Input[int]] = None,
                 dhcp_relay_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcp_start: Optional[pulumi.Input[str]] = None,
                 dhcp_stop: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_enabled: Optional[pulumi.Input[bool]] = None,
                 dhcpd_boot_filename: Optional[pulumi.Input[str]] = None,
                 dhcpd_boot_server: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 igmp_snooping: Optional[pulumi.Input[bool]] = None,
                 ipv6_interface_type: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_interface: Optional[pulumi.Input[str]] = None,
                 ipv6_pd_prefixid: Optional[pulumi.Input[str]] = None,
                 ipv6_ra_enable: Optional[pulumi.Input[bool]] = None,
                 ipv6_static_subnet: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_group: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wan_egress_qos: Optional[pulumi.Input[int]] = None,
                 wan_gateway: Optional[pulumi.Input[str]] = None,
                 wan_ip: Optional[pulumi.Input[str]] = None,
                 wan_netmask: Optional[pulumi.Input[str]] = None,
                 wan_networkgroup: Optional[pulumi.Input[str]] = None,
                 wan_type: Optional[pulumi.Input[str]] = None,
                 wan_username: Optional[pulumi.Input[str]] = None,
                 x_wan_password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["dhcp_dns"] = dhcp_dns
            __props__.__dict__["dhcp_enabled"] = dhcp_enabled
            __props__.__dict__["dhcp_lease"] = dhcp_lease
            __props__.__dict__["dhcp_relay_enabled"] = dhcp_relay_enabled
            __props__.__dict__["dhcp_start"] = dhcp_start
            __props__.__dict__["dhcp_stop"] = dhcp_stop
            __props__.__dict__["dhcpd_boot_enabled"] = dhcpd_boot_enabled
            __props__.__dict__["dhcpd_boot_filename"] = dhcpd_boot_filename
            __props__.__dict__["dhcpd_boot_server"] = dhcpd_boot_server
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["igmp_snooping"] = igmp_snooping
            __props__.__dict__["ipv6_interface_type"] = ipv6_interface_type
            __props__.__dict__["ipv6_pd_interface"] = ipv6_pd_interface
            __props__.__dict__["ipv6_pd_prefixid"] = ipv6_pd_prefixid
            __props__.__dict__["ipv6_ra_enable"] = ipv6_ra_enable
            __props__.__dict__["ipv6_static_subnet"] = ipv6_static_subnet
            __props__.__dict__["name"] = name
            __props__.__dict__["network_group"] = network_group
            if purpose is None and not opts.urn:
                raise TypeError("Missing required property 'purpose'")
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["site"] = site
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["wan_dns"] = wan_dns
            __props__.__dict__["wan_egress_qos"] = wan_egress_qos
            __props__.__dict__["wan_gateway"] = wan_gateway
            __props__.__dict__["wan_ip"] = wan_ip
            __props__.__dict__["wan_netmask"] = wan_netmask
            __props__.__dict__["wan_networkgroup"] = wan_networkgroup
            __props__.__dict__["wan_type"] = wan_type
            __props__.__dict__["wan_username"] = wan_username
            __props__.__dict__["x_wan_password"] = x_wan_password
        super(Network, __self__).__init__(
            'unifi:index/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dhcp_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dhcp_enabled: Optional[pulumi.Input[bool]] = None,
            dhcp_lease: Optional[pulumi.Input[int]] = None,
            dhcp_relay_enabled: Optional[pulumi.Input[bool]] = None,
            dhcp_start: Optional[pulumi.Input[str]] = None,
            dhcp_stop: Optional[pulumi.Input[str]] = None,
            dhcpd_boot_enabled: Optional[pulumi.Input[bool]] = None,
            dhcpd_boot_filename: Optional[pulumi.Input[str]] = None,
            dhcpd_boot_server: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            igmp_snooping: Optional[pulumi.Input[bool]] = None,
            ipv6_interface_type: Optional[pulumi.Input[str]] = None,
            ipv6_pd_interface: Optional[pulumi.Input[str]] = None,
            ipv6_pd_prefixid: Optional[pulumi.Input[str]] = None,
            ipv6_ra_enable: Optional[pulumi.Input[bool]] = None,
            ipv6_static_subnet: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_group: Optional[pulumi.Input[str]] = None,
            purpose: Optional[pulumi.Input[str]] = None,
            site: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None,
            wan_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            wan_egress_qos: Optional[pulumi.Input[int]] = None,
            wan_gateway: Optional[pulumi.Input[str]] = None,
            wan_ip: Optional[pulumi.Input[str]] = None,
            wan_netmask: Optional[pulumi.Input[str]] = None,
            wan_networkgroup: Optional[pulumi.Input[str]] = None,
            wan_type: Optional[pulumi.Input[str]] = None,
            wan_username: Optional[pulumi.Input[str]] = None,
            x_wan_password: Optional[pulumi.Input[str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dhcp_dns: Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        :param pulumi.Input[bool] dhcp_enabled: Specifies whether DHCP is enabled or not on this network.
        :param pulumi.Input[int] dhcp_lease: Specifies the lease time for DHCP addresses. Defaults to `86400`.
        :param pulumi.Input[bool] dhcp_relay_enabled: Specifies whether DHCP relay is enabled or not on this network.
        :param pulumi.Input[str] dhcp_start: The IPv4 address where the DHCP range of addresses starts.
        :param pulumi.Input[str] dhcp_stop: The IPv4 address where the DHCP range of addresses stops.
        :param pulumi.Input[bool] dhcpd_boot_enabled: Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        :param pulumi.Input[str] dhcpd_boot_filename: Specifies the file to PXE boot from on the dhcpd*boot*server.
        :param pulumi.Input[str] dhcpd_boot_server: Specifies the IPv4 address of a TFTP server to network boot from.
        :param pulumi.Input[str] domain_name: The domain name of this network.
        :param pulumi.Input[bool] igmp_snooping: Specifies whether IGMP snooping is enabled or not.
        :param pulumi.Input[str] ipv6_interface_type: Specifies which type of IPv6 connection to use. Defaults to `none`.
        :param pulumi.Input[str] ipv6_pd_interface: Specifies which WAN interface to use for IPv6 PD.
        :param pulumi.Input[str] ipv6_pd_prefixid: Specifies the IPv6 Prefix ID.
        :param pulumi.Input[bool] ipv6_ra_enable: Specifies whether to enable router advertisements or not.
        :param pulumi.Input[str] ipv6_static_subnet: Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        :param pulumi.Input[str] name: The name of the network.
        :param pulumi.Input[str] network_group: The group of the network. Defaults to `LAN`.
        :param pulumi.Input[str] purpose: The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        :param pulumi.Input[str] site: The name of the site to associate the network with.
        :param pulumi.Input[str] subnet: The subnet of the network. Must be a valid CIDR address.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wan_dns: DNS servers IPs of the WAN.
        :param pulumi.Input[int] wan_egress_qos: Specifies the WAN egress quality of service. Defaults to `0`.
        :param pulumi.Input[str] wan_gateway: The IPv4 gateway of the WAN.
        :param pulumi.Input[str] wan_ip: The IPv4 address of the WAN.
        :param pulumi.Input[str] wan_netmask: The IPv4 netmask of the WAN.
        :param pulumi.Input[str] wan_networkgroup: Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        :param pulumi.Input[str] wan_type: Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        :param pulumi.Input[str] wan_username: Specifies the IPV4 WAN username.
        :param pulumi.Input[str] x_wan_password: Specifies the IPV4 WAN password.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["dhcp_dns"] = dhcp_dns
        __props__.__dict__["dhcp_enabled"] = dhcp_enabled
        __props__.__dict__["dhcp_lease"] = dhcp_lease
        __props__.__dict__["dhcp_relay_enabled"] = dhcp_relay_enabled
        __props__.__dict__["dhcp_start"] = dhcp_start
        __props__.__dict__["dhcp_stop"] = dhcp_stop
        __props__.__dict__["dhcpd_boot_enabled"] = dhcpd_boot_enabled
        __props__.__dict__["dhcpd_boot_filename"] = dhcpd_boot_filename
        __props__.__dict__["dhcpd_boot_server"] = dhcpd_boot_server
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["igmp_snooping"] = igmp_snooping
        __props__.__dict__["ipv6_interface_type"] = ipv6_interface_type
        __props__.__dict__["ipv6_pd_interface"] = ipv6_pd_interface
        __props__.__dict__["ipv6_pd_prefixid"] = ipv6_pd_prefixid
        __props__.__dict__["ipv6_ra_enable"] = ipv6_ra_enable
        __props__.__dict__["ipv6_static_subnet"] = ipv6_static_subnet
        __props__.__dict__["name"] = name
        __props__.__dict__["network_group"] = network_group
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["site"] = site
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["wan_dns"] = wan_dns
        __props__.__dict__["wan_egress_qos"] = wan_egress_qos
        __props__.__dict__["wan_gateway"] = wan_gateway
        __props__.__dict__["wan_ip"] = wan_ip
        __props__.__dict__["wan_netmask"] = wan_netmask
        __props__.__dict__["wan_networkgroup"] = wan_networkgroup
        __props__.__dict__["wan_type"] = wan_type
        __props__.__dict__["wan_username"] = wan_username
        __props__.__dict__["x_wan_password"] = x_wan_password
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dhcpDns")
    def dhcp_dns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the IPv4 addresses for the DNS server to be returned from the DHCP server. Leave blank to disable this feature.
        """
        return pulumi.get(self, "dhcp_dns")

    @property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether DHCP is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_enabled")

    @property
    @pulumi.getter(name="dhcpLease")
    def dhcp_lease(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the lease time for DHCP addresses. Defaults to `86400`.
        """
        return pulumi.get(self, "dhcp_lease")

    @property
    @pulumi.getter(name="dhcpRelayEnabled")
    def dhcp_relay_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether DHCP relay is enabled or not on this network.
        """
        return pulumi.get(self, "dhcp_relay_enabled")

    @property
    @pulumi.getter(name="dhcpStart")
    def dhcp_start(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 address where the DHCP range of addresses starts.
        """
        return pulumi.get(self, "dhcp_start")

    @property
    @pulumi.getter(name="dhcpStop")
    def dhcp_stop(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 address where the DHCP range of addresses stops.
        """
        return pulumi.get(self, "dhcp_stop")

    @property
    @pulumi.getter(name="dhcpdBootEnabled")
    def dhcpd_boot_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Toggles on the DHCP boot options. Should be set to true when you want to have dhcpd*boot*filename, and dhcpd*boot*server to take effect.
        """
        return pulumi.get(self, "dhcpd_boot_enabled")

    @property
    @pulumi.getter(name="dhcpdBootFilename")
    def dhcpd_boot_filename(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the file to PXE boot from on the dhcpd*boot*server.
        """
        return pulumi.get(self, "dhcpd_boot_filename")

    @property
    @pulumi.getter(name="dhcpdBootServer")
    def dhcpd_boot_server(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IPv4 address of a TFTP server to network boot from.
        """
        return pulumi.get(self, "dhcpd_boot_server")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The domain name of this network.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="igmpSnooping")
    def igmp_snooping(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether IGMP snooping is enabled or not.
        """
        return pulumi.get(self, "igmp_snooping")

    @property
    @pulumi.getter(name="ipv6InterfaceType")
    def ipv6_interface_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies which type of IPv6 connection to use. Defaults to `none`.
        """
        return pulumi.get(self, "ipv6_interface_type")

    @property
    @pulumi.getter(name="ipv6PdInterface")
    def ipv6_pd_interface(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies which WAN interface to use for IPv6 PD.
        """
        return pulumi.get(self, "ipv6_pd_interface")

    @property
    @pulumi.getter(name="ipv6PdPrefixid")
    def ipv6_pd_prefixid(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IPv6 Prefix ID.
        """
        return pulumi.get(self, "ipv6_pd_prefixid")

    @property
    @pulumi.getter(name="ipv6RaEnable")
    def ipv6_ra_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable router advertisements or not.
        """
        return pulumi.get(self, "ipv6_ra_enable")

    @property
    @pulumi.getter(name="ipv6StaticSubnet")
    def ipv6_static_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the static IPv6 subnet when ipv6*interface*type is 'static'.
        """
        return pulumi.get(self, "ipv6_static_subnet")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the network.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkGroup")
    def network_group(self) -> pulumi.Output[Optional[str]]:
        """
        The group of the network. Defaults to `LAN`.
        """
        return pulumi.get(self, "network_group")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[str]:
        """
        The purpose of the network. Must be one of `corporate`, `guest`, `wan`, or `vlan-only`.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        The name of the site to associate the network with.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[Optional[str]]:
        """
        The subnet of the network. Must be a valid CIDR address.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[Optional[int]]:
        """
        The VLAN ID of the network.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="wanDns")
    def wan_dns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        DNS servers IPs of the WAN.
        """
        return pulumi.get(self, "wan_dns")

    @property
    @pulumi.getter(name="wanEgressQos")
    def wan_egress_qos(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the WAN egress quality of service. Defaults to `0`.
        """
        return pulumi.get(self, "wan_egress_qos")

    @property
    @pulumi.getter(name="wanGateway")
    def wan_gateway(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 gateway of the WAN.
        """
        return pulumi.get(self, "wan_gateway")

    @property
    @pulumi.getter(name="wanIp")
    def wan_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 address of the WAN.
        """
        return pulumi.get(self, "wan_ip")

    @property
    @pulumi.getter(name="wanNetmask")
    def wan_netmask(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 netmask of the WAN.
        """
        return pulumi.get(self, "wan_netmask")

    @property
    @pulumi.getter(name="wanNetworkgroup")
    def wan_networkgroup(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the WAN network group. Must be one of either `WAN`, `WAN2` or `WAN_LTE_FAILOVER`.
        """
        return pulumi.get(self, "wan_networkgroup")

    @property
    @pulumi.getter(name="wanType")
    def wan_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IPV4 WAN connection type. Must be one of either `disabled`, `static`, `dhcp`, or `pppoe`.
        """
        return pulumi.get(self, "wan_type")

    @property
    @pulumi.getter(name="wanUsername")
    def wan_username(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IPV4 WAN username.
        """
        return pulumi.get(self, "wan_username")

    @property
    @pulumi.getter(name="xWanPassword")
    def x_wan_password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IPV4 WAN password.
        """
        return pulumi.get(self, "x_wan_password")

