# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['modules', 'pbash', 'pbash.modules']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.4,<9.0.0', 'rich>=11.2.0,<12.0.0']

entry_points = \
{'console_scripts': ['pbash = pbash:run']}

setup_kwargs = {
    'name': 'pbash',
    'version': '0.1.0',
    'description': 'Bash Script Manager',
    'long_description': '# Welcome to pbash\n\n[![](https://badgen.net/github/release/sguerri/pbash)](https://github.com/sguerri/pbash/releases/)\n[![](https://img.shields.io/github/workflow/status/sguerri/pbash/Build/v0.1.0)](https://github.com/sguerri/pbash/actions/workflows/build.yml)\n[![](https://badgen.net/github/license/sguerri/pbash)](https://www.gnu.org/licenses/)\n[![](https://badgen.net/pypi/v/pbash)](https://pypi.org/project/pbash/)\n[![](https://badgen.net/pypi/python/pbash)](#)\n[![](https://badgen.net/badge/Open%20Source%20%3F/Yes%21/blue?icon=github)](#)\n\n> Bash Script Manager\n\n**pbash** helps managing a set of bash scripts. It keeps the logic of one file per script, but creates aliases and handle parameter prompt and pipe.\n\n**Main features**\n* bash script run\n* parameter prompt\n* parameter pass through pipe\n* automatic cli command and option from the script\n* git support\n* possibility to handle several distinct stores\n* commands and params autocompletion\n\n**Roadmap**\n* enhanced filter\n* test on other platforms\n* code cleaning\n\n---\n\n- [Welcome to pbash](#welcome-to-pbash)\n  * [Installation](#installation)\n    + [Requirements](#requirements)\n    + [Install from pypi](#install-from-pypi)\n    + [Install from deb package](#install-from-deb-package)\n  * [Usage](#usage)\n    + [Initialise](#initialise)\n    + [Create a new script](#create-a-new-script)\n    + [Script template](#script-template)\n    + [Run a script](#run-a-script)\n    + [Run a script (example)](#run-a-script--example-)\n    + [List scripts](#list-scripts)\n    + [Edit a script](#edit-a-script)\n    + [Filter](#filter)\n    + [Add a new store](#add-a-new-store)\n    + [Use a store](#use-a-store)\n    + [Initialise new git repository](#initialise-new-git-repository)\n    + [Initialise from existing git repository](#initialise-from-existing-git-repository)\n    + [Publish to git](#publish-to-git)\n    + [Shortcuts and Aliases](#shortcuts-and-aliases)\n  * [Build](#build)\n  * [Dependencies](#dependencies)\n  * [Author](#author)\n  * [Issues](#issues)\n  * [License](#license)\n\n## Installation\n\n### Requirements\n\nThe application is developped and used on ubuntu 21.10, with python 3.9.7. Any feedback on other platforms is welcomed.\n\n- python3 >=3.6.2,<4.0\n- git: `sudo apt install git`\n- nano: `sudo apt install nano`\n\n### Install from pypi\n\n```bash\npip install pbash\n```\n\nFor an isolated environment with [pipx](https://pypa.github.io/pipx/):\n\n```bash\npipx install pbash\n```\n\n### Install from deb package\n\nA deb package is available, built using `dh-virtualenv`. Installing this package will create a new Python virtual environment in `opt/venvs`. It will then create the symlink `usr/bin/pbash` pointing to `opt/venvs/pbash/bin/pbash`.\n\nNote that `dh-virtualenv` built packages are dependent of python version. Use this only if you have default python version installed:\n* ubuntu bionic 18.04: Python 3.6\n* ubuntu focal 20.04: Python 3.8\n* ubuntu hirsute 21.04: Python 3.9\n* ubuntu impish 21.10: Python 3.9\n\nDownload latest `.deb` file from the [release page](https://github.com/sguerri/pbash/releases).\n\n```bash\nsudo dpkg -i pbash_0.1.0_{{os}}_amd64.deb\n```\n\n## Usage\n\n### Initialise\n\nInitialisation is required before using the application, to create the working diretory.\n\n```bash\npbash init\n```\n\nA configuration file `.pbashrc` is created in the user home directory.\n\nBy default, scripts will be stored in `${HOME}/.pbash/` folder.\n\nThe `--edit` option will open configuration file in edit mode.\n\n### Create a new script\n\nYou can create a new script file.\n\n```bash\npbash new --name "${NAME}" --desc "${DESCRIPTION}" --param "${PARAM1}" --param "${PARAM2}"\n```\n\nIf options are not given, they will be prompted at run.\n\nFor param details, see below.\n\n### Script template\n\nTo add a description to the script, add a comment line beginning with `#DESC `.\n\n```bash\n#DESC ...\n```\n\nTo add a param to the script, add a comment line beginning with `#PARAM `.\n\n```bash\n#PARAM <name>, <question>, <default>, <always_prompt>\n```\n\nOnly `<name>` is required. This value must be strict alphanumeric. The application will automatically create an option `--<name>` for the cli `run` command.\n\n`<question>` is used for cli prompt and option help message. Default is empty string.\n\n`<default>` is the default value. Default is empty string.\n\n`<always_prompt>` is used to display prompt even when a default value is given. Set to `true` if desired. Default is `false`.\n\n### Run a script\n\nThe generic `run` command calls the corresponding script.\n\n```bash\npbash run <name>\n```\n\nOptions are automatically created based on script informations.\n\n### Run a script (example)\n\nLet\'s take the below script `example.sh`\n\n```bash\n#!/bin/bash\n#PARAM user, User\n#PARAM message, Which message\nread -p "User: " user\nread -p "Which message: " message\necho "$user says $message"\n```\n\nThe script can be run directly through terminal.\n\nIt can also be run through **pbash** : the params will be prompted\n\n```bash\npbash run example\n```\n\nIt can be run with options :\n\n```bash\npbash run example --user "Sebastien" --message "Hello World!"\n```\n\nOr with piped arguments\n\n```bash\n(echo "Sebastien"; echo "Hello World!") | pbash run example\n# or\ncat <(echo "Sebastien") <(echo "Hello World!") | pbash run example\n```\n\n*Note : for piped arguments, all params must be given so that it works*\n\n### List scripts\n\n```bash\npbash list <filter>\n```\n\n### Edit a script\n\nScript edition will open the file in default cli editor.\n\n```bash\npbash edit <filter>\n```\n\n### Filter\n\nCurrently command filter is only done on the script file name.\n\nA future enhancement will provide a better filter functionnality.\n\n`pbash <command> <anything>` will filter displayed scripts based on `anything` value (name containing this value).\n\n### Add a new store\n\nYou can create several stores (config sections). Default store path is `${HOME}/.pbash-${NAME}/`\n\n```bash\npbash -c "${STORE}" init --new-section\n```\n\nYou can also select path via the option `--path`. The folder will be created if it does not exist.\n\n```bash\npbash -c "${STORE}" init --new-section --path "${PATH}"\n```\n\n### Use a store\n\nAll functions can be used for a specific store by using the `-c` option from **pbash** application.\n\n```bash\npbash -c "${STORE}" new ...\npbash -c "${STORE}" list ...\npbash -c "${STORE}" run ...\n# etc.\n```\n\n### Initialise new git repository\n\nYou can initialise a new git repository in store path. It will set automatic git push for every script creation or modification. The git repository needs to be created on your platform before.\n\nA default branch `main` is created.\n\n```bash\npbash -c "${STORE}" init-git\n```\n\nYou can also pass parameter through cli command:\n\n```bash\npbash -c "${STORE}" init-git --repo "${REPO}" --user "${USER}" --mail "${EMAIL}" --branch "${BRANCH}"\n```\n\n### Initialise from existing git repository\n\nIf the git repository already exists, you can restore it in the current store folder by adding the `--pull` option to `init-git` command.\n\nIt will download the latest commit from `main` branch. If the branch name is different, you can update it in the config file through `pbash init --edit` or through `--branch` option.\n\n### Publish to git\n\nWhen a git repository is enabled, all changes to scripts will be pushed to remote. However, there will never be automatic pull to retrieve potential scripts changes from remote (from other application, computer, user, aso.).\n\nIt can be done manually through\n\n```bash\npbash -c "${STORE} git pull"\n  # or\npbash -c "${STORE} git sync" # pull then push\n```\n\nIn case a remote change is done but not pulled, the automatic push on script modification will fail. A manual `git sync` will be required to merge local and remote.\n\n### Shortcuts and Aliases\n\nApplication must give a fast access to scripts to be useful.\n\nI personnaly defined shortcuts in my home `.bashrc` file:\n\n```bash\nalias pb=\'pbash -c PRO\'\nalias pbr=\'pbash -c PRO run\'\nalias pbp=\'pbash -c PERSO\'\nalias pbpr=\'pbash -c PERSO run\'\n```\n\n## Build\n\n**Requirements**\n\n- debhelper: `sudo apt install debhelper`\n- [dh-virtualenv](https://github.com/spotify/dh-virtualenv)\n- [build](https://github.com/pypa/build)\n- [virtualenv](https://virtualenv.pypa.io/en/latest/)\n\n**Commands**\n\n```bash\npoetry install\n\n# build deb\ndpkg-buildpackage -us -uc\ndpkg-buildpackage -Tclean\n\n# build python package\npython3 -m build\n```\n\n## Dependencies\n\n**Python Libraries**\n- [click](https://palletsprojects.com/p/click/)\n- [rich](https://github.com/Textualize/rich)\n\n**Python Development Libraries**\n- [poetry](https://python-poetry.org/)\n\n## Author\n\nSébastien Guerri - [github page](https://github.com/sguerri)\n\n## Issues\n\nContributions, issues and feature requests are welcome!\n\nFeel free to check [issues page](https://github.com/sguerri/pbash/issues). You can also contact me.\n\n## License\n\nCopyright (C) 2022 Sebastien Guerri\n\npbash is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or any later version.\n\npbash is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with pbash. If not, see <https://www.gnu.org/licenses/>.',
    'author': 'Sebastien GUERRI',
    'author_email': 'nierrgu@bmel.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sguerri/pbash',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0',
}


setup(**setup_kwargs)
