/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_jupyterlab_fileeditor-extension_lib_index_js"],{

/***/ "../node_modules/@jupyterlab/fileeditor-extension/lib/commands.js":
/*!************************************************************************!*\
  !*** ../node_modules/@jupyterlab/fileeditor-extension/lib/commands.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"CommandIDs\": () => (/* binding */ CommandIDs),\n/* harmony export */   \"FACTORY\": () => (/* binding */ FACTORY),\n/* harmony export */   \"Commands\": () => (/* binding */ Commands)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/codeeditor */ \"webpack/sharing/consume/default/@jupyterlab/codeeditor/@jupyterlab/codeeditor\");\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_4__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n/**\n * The command IDs used by the fileeditor plugin.\n */\nvar CommandIDs;\n(function (CommandIDs) {\n    CommandIDs.createNew = 'fileeditor:create-new';\n    CommandIDs.createNewMarkdown = 'fileeditor:create-new-markdown-file';\n    CommandIDs.changeFontSize = 'fileeditor:change-font-size';\n    CommandIDs.lineNumbers = 'fileeditor:toggle-line-numbers';\n    CommandIDs.lineWrap = 'fileeditor:toggle-line-wrap';\n    CommandIDs.changeTabs = 'fileeditor:change-tabs';\n    CommandIDs.matchBrackets = 'fileeditor:toggle-match-brackets';\n    CommandIDs.autoClosingBrackets = 'fileeditor:toggle-autoclosing-brackets';\n    CommandIDs.createConsole = 'fileeditor:create-console';\n    CommandIDs.replaceSelection = 'fileeditor:replace-selection';\n    CommandIDs.runCode = 'fileeditor:run-code';\n    CommandIDs.runAllCode = 'fileeditor:run-all';\n    CommandIDs.markdownPreview = 'fileeditor:markdown-preview';\n    CommandIDs.undo = 'fileeditor:undo';\n    CommandIDs.redo = 'fileeditor:redo';\n    CommandIDs.cut = 'fileeditor:cut';\n    CommandIDs.copy = 'fileeditor:copy';\n    CommandIDs.paste = 'fileeditor:paste';\n    CommandIDs.selectAll = 'fileeditor:select-all';\n})(CommandIDs || (CommandIDs = {}));\n/**\n * The name of the factory that creates editor widgets.\n */\nconst FACTORY = 'Editor';\nlet config = Object.assign({}, _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1__.CodeEditor.defaultConfig);\n/**\n * A utility class for adding commands and menu items,\n * for use by the File Editor extension or other Editor extensions.\n */\nvar Commands;\n(function (Commands) {\n    /**\n     * Accessor function that returns the createConsole function for use by Create Console commands\n     */\n    function getCreateConsoleFunction(commands) {\n        return async function createConsole(widget, args) {\n            var _a;\n            const options = args || {};\n            const console = await commands.execute('console:create', {\n                activate: options['activate'],\n                name: (_a = widget.context.contentsModel) === null || _a === void 0 ? void 0 : _a.name,\n                path: widget.context.path,\n                preferredLanguage: widget.context.model.defaultKernelLanguage,\n                ref: widget.id,\n                insertMode: 'split-bottom'\n            });\n            widget.context.pathChanged.connect((sender, value) => {\n                var _a;\n                console.session.setPath(value);\n                console.session.setName((_a = widget.context.contentsModel) === null || _a === void 0 ? void 0 : _a.name);\n            });\n        };\n    }\n    /**\n     * Update the setting values.\n     */\n    function updateSettings(settings, commands) {\n        config = Object.assign(Object.assign({}, _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1__.CodeEditor.defaultConfig), settings.get('editorConfig').composite);\n        // Trigger a refresh of the rendered commands\n        commands.notifyCommandChanged();\n    }\n    Commands.updateSettings = updateSettings;\n    /**\n     * Update the settings of the current tracker instances.\n     */\n    function updateTracker(tracker) {\n        tracker.forEach(widget => {\n            updateWidget(widget.content);\n        });\n    }\n    Commands.updateTracker = updateTracker;\n    /**\n     * Update the settings of a widget.\n     * Skip global settings for transient editor specific configs.\n     */\n    function updateWidget(widget) {\n        const transientConfigs = ['lineNumbers', 'lineWrap', 'matchBrackets'];\n        const editor = widget.editor;\n        let editorOptions = {};\n        Object.keys(config).forEach((key) => {\n            if (!transientConfigs.includes(key)) {\n                editorOptions[key] = config[key];\n            }\n        });\n        editor.setOptions(editorOptions);\n    }\n    Commands.updateWidget = updateWidget;\n    /**\n     * Wrapper function for adding the default File Editor commands\n     */\n    function addCommands(commands, settingRegistry, trans, id, isEnabled, tracker, browserFactory) {\n        // Add a command to change font size.\n        addChangeFontSizeCommand(commands, settingRegistry, trans, id);\n        addLineNumbersCommand(commands, settingRegistry, trans, id, isEnabled);\n        addWordWrapCommand(commands, settingRegistry, trans, id, isEnabled);\n        addChangeTabsCommand(commands, settingRegistry, trans, id);\n        addMatchBracketsCommand(commands, settingRegistry, trans, id, isEnabled);\n        addAutoClosingBracketsCommand(commands, settingRegistry, trans, id);\n        addReplaceSelectionCommand(commands, tracker, trans, isEnabled);\n        addCreateConsoleCommand(commands, tracker, trans, isEnabled);\n        addRunCodeCommand(commands, tracker, trans, isEnabled);\n        addRunAllCodeCommand(commands, tracker, trans, isEnabled);\n        addMarkdownPreviewCommand(commands, tracker, trans);\n        // Add a command for creating a new text file.\n        addCreateNewCommand(commands, browserFactory, trans);\n        // Add a command for creating a new Markdown file.\n        addCreateNewMarkdownCommand(commands, browserFactory, trans);\n        addUndoCommand(commands, tracker, trans, isEnabled);\n        addRedoCommand(commands, tracker, trans, isEnabled);\n        addCutCommand(commands, tracker, trans, isEnabled);\n        addCopyCommand(commands, tracker, trans, isEnabled);\n        addPasteCommand(commands, tracker, trans, isEnabled);\n        addSelectAllCommand(commands, tracker, trans, isEnabled);\n    }\n    Commands.addCommands = addCommands;\n    /**\n     * Add a command to change font size for File Editor\n     */\n    function addChangeFontSizeCommand(commands, settingRegistry, trans, id) {\n        commands.addCommand(CommandIDs.changeFontSize, {\n            execute: args => {\n                const delta = Number(args['delta']);\n                if (Number.isNaN(delta)) {\n                    console.error(`${CommandIDs.changeFontSize}: delta arg must be a number`);\n                    return;\n                }\n                const style = window.getComputedStyle(document.documentElement);\n                const cssSize = parseInt(style.getPropertyValue('--jp-code-font-size'), 10);\n                const currentSize = config.fontSize || cssSize;\n                config.fontSize = currentSize + delta;\n                return settingRegistry\n                    .set(id, 'editorConfig', config)\n                    .catch((reason) => {\n                    console.error(`Failed to set ${id}: ${reason.message}`);\n                });\n            },\n            label: args => args['name']\n        });\n    }\n    Commands.addChangeFontSizeCommand = addChangeFontSizeCommand;\n    /**\n     * Add the Line Numbers command\n     */\n    function addLineNumbersCommand(commands, settingRegistry, trans, id, isEnabled) {\n        commands.addCommand(CommandIDs.lineNumbers, {\n            execute: () => {\n                config.lineNumbers = !config.lineNumbers;\n                return settingRegistry\n                    .set(id, 'editorConfig', config)\n                    .catch((reason) => {\n                    console.error(`Failed to set ${id}: ${reason.message}`);\n                });\n            },\n            isEnabled,\n            isToggled: () => config.lineNumbers,\n            label: trans.__('Line Numbers')\n        });\n    }\n    Commands.addLineNumbersCommand = addLineNumbersCommand;\n    /**\n     * Add the Word Wrap command\n     */\n    function addWordWrapCommand(commands, settingRegistry, trans, id, isEnabled) {\n        commands.addCommand(CommandIDs.lineWrap, {\n            execute: args => {\n                config.lineWrap = args['mode'] || 'off';\n                return settingRegistry\n                    .set(id, 'editorConfig', config)\n                    .catch((reason) => {\n                    console.error(`Failed to set ${id}: ${reason.message}`);\n                });\n            },\n            isEnabled,\n            isToggled: args => {\n                const lineWrap = args['mode'] || 'off';\n                return config.lineWrap === lineWrap;\n            },\n            label: trans.__('Word Wrap')\n        });\n    }\n    Commands.addWordWrapCommand = addWordWrapCommand;\n    /**\n     * Add command for changing tabs size or type in File Editor\n     */\n    function addChangeTabsCommand(commands, settingRegistry, trans, id) {\n        commands.addCommand(CommandIDs.changeTabs, {\n            label: args => args['name'],\n            execute: args => {\n                config.tabSize = args['size'] || 4;\n                config.insertSpaces = !!args['insertSpaces'];\n                return settingRegistry\n                    .set(id, 'editorConfig', config)\n                    .catch((reason) => {\n                    console.error(`Failed to set ${id}: ${reason.message}`);\n                });\n            },\n            isToggled: args => {\n                const insertSpaces = !!args['insertSpaces'];\n                const size = args['size'] || 4;\n                return config.insertSpaces === insertSpaces && config.tabSize === size;\n            }\n        });\n    }\n    Commands.addChangeTabsCommand = addChangeTabsCommand;\n    /**\n     * Add the Match Brackets command\n     */\n    function addMatchBracketsCommand(commands, settingRegistry, trans, id, isEnabled) {\n        commands.addCommand(CommandIDs.matchBrackets, {\n            execute: () => {\n                config.matchBrackets = !config.matchBrackets;\n                return settingRegistry\n                    .set(id, 'editorConfig', config)\n                    .catch((reason) => {\n                    console.error(`Failed to set ${id}: ${reason.message}`);\n                });\n            },\n            label: trans.__('Match Brackets'),\n            isEnabled,\n            isToggled: () => config.matchBrackets\n        });\n    }\n    Commands.addMatchBracketsCommand = addMatchBracketsCommand;\n    /**\n     * Add the Auto Close Brackets for Text Editor command\n     */\n    function addAutoClosingBracketsCommand(commands, settingRegistry, trans, id) {\n        commands.addCommand(CommandIDs.autoClosingBrackets, {\n            execute: () => {\n                config.autoClosingBrackets = !config.autoClosingBrackets;\n                return settingRegistry\n                    .set(id, 'editorConfig', config)\n                    .catch((reason) => {\n                    console.error(`Failed to set ${id}: ${reason.message}`);\n                });\n            },\n            label: trans.__('Auto Close Brackets for Text Editor'),\n            isToggled: () => config.autoClosingBrackets\n        });\n    }\n    Commands.addAutoClosingBracketsCommand = addAutoClosingBracketsCommand;\n    /**\n     * Add the replace selection for text editor command\n     */\n    function addReplaceSelectionCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.replaceSelection, {\n            execute: args => {\n                var _a, _b;\n                const text = args['text'] || '';\n                const widget = tracker.currentWidget;\n                if (!widget) {\n                    return;\n                }\n                (_b = (_a = widget.content.editor).replaceSelection) === null || _b === void 0 ? void 0 : _b.call(_a, text);\n            },\n            isEnabled,\n            label: trans.__('Replace Selection in Editor')\n        });\n    }\n    Commands.addReplaceSelectionCommand = addReplaceSelectionCommand;\n    /**\n     * Add the Create Console for Editor command\n     */\n    function addCreateConsoleCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.createConsole, {\n            execute: args => {\n                const widget = tracker.currentWidget;\n                if (!widget) {\n                    return;\n                }\n                return getCreateConsoleFunction(commands)(widget, args);\n            },\n            isEnabled,\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.consoleIcon,\n            label: trans.__('Create Console for Editor')\n        });\n    }\n    Commands.addCreateConsoleCommand = addCreateConsoleCommand;\n    /**\n     * Add the Run Code command\n     */\n    function addRunCodeCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.runCode, {\n            execute: () => {\n                var _a;\n                // Run the appropriate code, taking into account a ```fenced``` code block.\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                let code = '';\n                const editor = widget.editor;\n                const path = widget.context.path;\n                const extension = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.PathExt.extname(path);\n                const selection = editor.getSelection();\n                const { start, end } = selection;\n                let selected = start.column !== end.column || start.line !== end.line;\n                if (selected) {\n                    // Get the selected code from the editor.\n                    const start = editor.getOffsetAt(selection.start);\n                    const end = editor.getOffsetAt(selection.end);\n                    code = editor.model.value.text.substring(start, end);\n                }\n                else if (_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.MarkdownCodeBlocks.isMarkdown(extension)) {\n                    const { text } = editor.model.value;\n                    const blocks = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.MarkdownCodeBlocks.findMarkdownCodeBlocks(text);\n                    for (const block of blocks) {\n                        if (block.startLine <= start.line && start.line <= block.endLine) {\n                            code = block.code;\n                            selected = true;\n                            break;\n                        }\n                    }\n                }\n                if (!selected) {\n                    // no selection, submit whole line and advance\n                    code = editor.getLine(selection.start.line);\n                    const cursor = editor.getCursorPosition();\n                    if (cursor.line + 1 === editor.lineCount) {\n                        const text = editor.model.value.text;\n                        editor.model.value.text = text + '\\n';\n                    }\n                    editor.setCursorPosition({\n                        line: cursor.line + 1,\n                        column: cursor.column\n                    });\n                }\n                const activate = false;\n                if (code) {\n                    return commands.execute('console:inject', { activate, code, path });\n                }\n                else {\n                    return Promise.resolve(void 0);\n                }\n            },\n            isEnabled,\n            label: trans.__('Run Code')\n        });\n    }\n    Commands.addRunCodeCommand = addRunCodeCommand;\n    /**\n     * Add the Run All Code command\n     */\n    function addRunAllCodeCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.runAllCode, {\n            execute: () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                let code = '';\n                const editor = widget.editor;\n                const text = editor.model.value.text;\n                const path = widget.context.path;\n                const extension = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.PathExt.extname(path);\n                if (_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.MarkdownCodeBlocks.isMarkdown(extension)) {\n                    // For Markdown files, run only code blocks.\n                    const blocks = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.MarkdownCodeBlocks.findMarkdownCodeBlocks(text);\n                    for (const block of blocks) {\n                        code += block.code;\n                    }\n                }\n                else {\n                    code = text;\n                }\n                const activate = false;\n                if (code) {\n                    return commands.execute('console:inject', { activate, code, path });\n                }\n                else {\n                    return Promise.resolve(void 0);\n                }\n            },\n            isEnabled,\n            label: trans.__('Run All Code')\n        });\n    }\n    Commands.addRunAllCodeCommand = addRunAllCodeCommand;\n    /**\n     * Add markdown preview command\n     */\n    function addMarkdownPreviewCommand(commands, tracker, trans) {\n        commands.addCommand(CommandIDs.markdownPreview, {\n            execute: () => {\n                const widget = tracker.currentWidget;\n                if (!widget) {\n                    return;\n                }\n                const path = widget.context.path;\n                return commands.execute('markdownviewer:open', {\n                    path,\n                    options: {\n                        mode: 'split-right'\n                    }\n                });\n            },\n            isVisible: () => {\n                const widget = tracker.currentWidget;\n                return ((widget && _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.PathExt.extname(widget.context.path) === '.md') || false);\n            },\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.markdownIcon,\n            label: trans.__('Show Markdown Preview')\n        });\n    }\n    Commands.addMarkdownPreviewCommand = addMarkdownPreviewCommand;\n    /**\n     * Add undo command\n     */\n    function addUndoCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.undo, {\n            execute: () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                widget.editor.undo();\n            },\n            isEnabled: () => {\n                var _a;\n                if (!isEnabled()) {\n                    return false;\n                }\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return false;\n                }\n                // Ideally enable it when there are undo events stored\n                // Reference issue #8590: Code mirror editor could expose the history of undo/redo events\n                return true;\n            },\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.undoIcon.bindprops({ stylesheet: 'menuItem' }),\n            label: trans.__('Undo')\n        });\n    }\n    Commands.addUndoCommand = addUndoCommand;\n    /**\n     * Add redo command\n     */\n    function addRedoCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.redo, {\n            execute: () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                widget.editor.redo();\n            },\n            isEnabled: () => {\n                var _a;\n                if (!isEnabled()) {\n                    return false;\n                }\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return false;\n                }\n                // Ideally enable it when there are redo events stored\n                // Reference issue #8590: Code mirror editor could expose the history of undo/redo events\n                return true;\n            },\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.redoIcon.bindprops({ stylesheet: 'menuItem' }),\n            label: trans.__('Redo')\n        });\n    }\n    Commands.addRedoCommand = addRedoCommand;\n    /**\n     * Add cut command\n     */\n    function addCutCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.cut, {\n            execute: () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                const editor = widget.editor;\n                const text = getTextSelection(editor);\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Clipboard.copyToSystem(text);\n                editor.replaceSelection && editor.replaceSelection('');\n            },\n            isEnabled: () => {\n                var _a;\n                if (!isEnabled()) {\n                    return false;\n                }\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return false;\n                }\n                // Enable command if there is a text selection in the editor\n                return isSelected(widget.editor);\n            },\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.cutIcon.bindprops({ stylesheet: 'menuItem' }),\n            label: trans.__('Cut')\n        });\n    }\n    Commands.addCutCommand = addCutCommand;\n    /**\n     * Add copy command\n     */\n    function addCopyCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.copy, {\n            execute: () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                const editor = widget.editor;\n                const text = getTextSelection(editor);\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Clipboard.copyToSystem(text);\n            },\n            isEnabled: () => {\n                var _a;\n                if (!isEnabled()) {\n                    return false;\n                }\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return false;\n                }\n                // Enable command if there is a text selection in the editor\n                return isSelected(widget.editor);\n            },\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.copyIcon.bindprops({ stylesheet: 'menuItem' }),\n            label: trans.__('Copy')\n        });\n    }\n    Commands.addCopyCommand = addCopyCommand;\n    /**\n     * Add paste command\n     */\n    function addPasteCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.paste, {\n            execute: async () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                const editor = widget.editor;\n                // Get data from clipboard\n                const clipboard = window.navigator.clipboard;\n                const clipboardData = await clipboard.readText();\n                if (clipboardData) {\n                    // Paste data to the editor\n                    editor.replaceSelection && editor.replaceSelection(clipboardData);\n                }\n            },\n            isEnabled: () => { var _a; return Boolean(isEnabled() && ((_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content)); },\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.pasteIcon.bindprops({ stylesheet: 'menuItem' }),\n            label: trans.__('Paste')\n        });\n    }\n    Commands.addPasteCommand = addPasteCommand;\n    /**\n     * Add select all command\n     */\n    function addSelectAllCommand(commands, tracker, trans, isEnabled) {\n        commands.addCommand(CommandIDs.selectAll, {\n            execute: () => {\n                var _a;\n                const widget = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;\n                if (!widget) {\n                    return;\n                }\n                const editor = widget.editor;\n                editor.execCommand('selectAll');\n            },\n            isEnabled: () => { var _a; return Boolean(isEnabled() && ((_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content)); },\n            label: trans.__('Select All')\n        });\n    }\n    Commands.addSelectAllCommand = addSelectAllCommand;\n    /**\n     * Helper function to check if there is a text selection in the editor\n     */\n    function isSelected(editor) {\n        const selectionObj = editor.getSelection();\n        const { start, end } = selectionObj;\n        const selected = start.column !== end.column || start.line !== end.line;\n        return selected;\n    }\n    /**\n     * Helper function to get text selection from the editor\n     */\n    function getTextSelection(editor) {\n        const selectionObj = editor.getSelection();\n        const start = editor.getOffsetAt(selectionObj.start);\n        const end = editor.getOffsetAt(selectionObj.end);\n        const text = editor.model.value.text.substring(start, end);\n        return text;\n    }\n    /**\n     * Function to create a new untitled text file, given the current working directory.\n     */\n    function createNew(commands, cwd, ext = 'txt') {\n        return commands\n            .execute('docmanager:new-untitled', {\n            path: cwd,\n            type: 'file',\n            ext\n        })\n            .then(model => {\n            return commands.execute('docmanager:open', {\n                path: model.path,\n                factory: FACTORY\n            });\n        });\n    }\n    /**\n     * Add the New File command\n     *\n     * Defaults to Text/.txt if file type data is not specified\n     */\n    function addCreateNewCommand(commands, browserFactory, trans) {\n        commands.addCommand(CommandIDs.createNew, {\n            label: args => {\n                var _a, _b;\n                if (args.isPalette) {\n                    return (_a = args.paletteLabel) !== null && _a !== void 0 ? _a : trans.__('New Text File');\n                }\n                return (_b = args.launcherLabel) !== null && _b !== void 0 ? _b : trans.__('Text File');\n            },\n            caption: args => { var _a; return (_a = args.caption) !== null && _a !== void 0 ? _a : trans.__('Create a new text file'); },\n            icon: args => {\n                var _a;\n                return args.isPalette\n                    ? undefined\n                    : _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.LabIcon.resolve({\n                        icon: (_a = args.iconName) !== null && _a !== void 0 ? _a : _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.textEditorIcon\n                    });\n            },\n            execute: args => {\n                var _a;\n                const cwd = args.cwd || browserFactory.defaultBrowser.model.path;\n                return createNew(commands, cwd, (_a = args.fileExt) !== null && _a !== void 0 ? _a : 'txt');\n            }\n        });\n    }\n    Commands.addCreateNewCommand = addCreateNewCommand;\n    /**\n     * Add the New Markdown File command\n     */\n    function addCreateNewMarkdownCommand(commands, browserFactory, trans) {\n        commands.addCommand(CommandIDs.createNewMarkdown, {\n            label: args => args['isPalette']\n                ? trans.__('New Markdown File')\n                : trans.__('Markdown File'),\n            caption: trans.__('Create a new markdown file'),\n            icon: args => (args['isPalette'] ? undefined : _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.markdownIcon),\n            execute: args => {\n                const cwd = args['cwd'] || browserFactory.defaultBrowser.model.path;\n                return createNew(commands, cwd, 'md');\n            }\n        });\n    }\n    Commands.addCreateNewMarkdownCommand = addCreateNewMarkdownCommand;\n    /**\n     * Wrapper function for adding the default launcher items for File Editor\n     */\n    function addLauncherItems(launcher, trans) {\n        addCreateNewToLauncher(launcher, trans);\n        addCreateNewMarkdownToLauncher(launcher, trans);\n    }\n    Commands.addLauncherItems = addLauncherItems;\n    /**\n     * Add Create New Text File to the Launcher\n     */\n    function addCreateNewToLauncher(launcher, trans) {\n        launcher.add({\n            command: CommandIDs.createNew,\n            category: trans.__('Other'),\n            rank: 1\n        });\n    }\n    Commands.addCreateNewToLauncher = addCreateNewToLauncher;\n    /**\n     * Add Create New Markdown to the Launcher\n     */\n    function addCreateNewMarkdownToLauncher(launcher, trans) {\n        launcher.add({\n            command: CommandIDs.createNewMarkdown,\n            category: trans.__('Other'),\n            rank: 2\n        });\n    }\n    Commands.addCreateNewMarkdownToLauncher = addCreateNewMarkdownToLauncher;\n    /**\n     * Add ___ File items to the Launcher for common file types associated with available kernels\n     */\n    function addKernelLanguageLauncherItems(launcher, trans, availableKernelFileTypes) {\n        for (let ext of availableKernelFileTypes) {\n            launcher.add({\n                command: CommandIDs.createNew,\n                category: trans.__('Other'),\n                rank: 3,\n                args: ext\n            });\n        }\n    }\n    Commands.addKernelLanguageLauncherItems = addKernelLanguageLauncherItems;\n    /**\n     * Wrapper function for adding the default items to the File Editor palette\n     */\n    function addPaletteItems(palette, trans) {\n        addChangeTabsCommandsToPalette(palette, trans);\n        addCreateNewCommandToPalette(palette, trans);\n        addCreateNewMarkdownCommandToPalette(palette, trans);\n        addChangeFontSizeCommandsToPalette(palette, trans);\n    }\n    Commands.addPaletteItems = addPaletteItems;\n    /**\n     * Add commands to change the tab indentation to the File Editor palette\n     */\n    function addChangeTabsCommandsToPalette(palette, trans) {\n        const paletteCategory = trans.__('Text Editor');\n        const args = {\n            insertSpaces: false,\n            size: 4,\n            name: trans.__('Indent with Tab')\n        };\n        const command = 'fileeditor:change-tabs';\n        palette.addItem({ command, args, category: paletteCategory });\n        for (const size of [1, 2, 4, 8]) {\n            const args = {\n                insertSpaces: true,\n                size,\n                name: trans._n('Spaces: %1', 'Spaces: %1', size)\n            };\n            palette.addItem({ command, args, category: paletteCategory });\n        }\n    }\n    Commands.addChangeTabsCommandsToPalette = addChangeTabsCommandsToPalette;\n    /**\n     * Add a Create New File command to the File Editor palette\n     */\n    function addCreateNewCommandToPalette(palette, trans) {\n        const paletteCategory = trans.__('Text Editor');\n        palette.addItem({\n            command: CommandIDs.createNew,\n            args: { isPalette: true },\n            category: paletteCategory\n        });\n    }\n    Commands.addCreateNewCommandToPalette = addCreateNewCommandToPalette;\n    /**\n     * Add a Create New Markdown command to the File Editor palette\n     */\n    function addCreateNewMarkdownCommandToPalette(palette, trans) {\n        const paletteCategory = trans.__('Text Editor');\n        palette.addItem({\n            command: CommandIDs.createNewMarkdown,\n            args: { isPalette: true },\n            category: paletteCategory\n        });\n    }\n    Commands.addCreateNewMarkdownCommandToPalette = addCreateNewMarkdownCommandToPalette;\n    /**\n     * Add commands to change the font size to the File Editor palette\n     */\n    function addChangeFontSizeCommandsToPalette(palette, trans) {\n        const paletteCategory = trans.__('Text Editor');\n        const command = CommandIDs.changeFontSize;\n        let args = { name: trans.__('Increase Font Size'), delta: 1 };\n        palette.addItem({ command, args, category: paletteCategory });\n        args = { name: trans.__('Decrease Font Size'), delta: -1 };\n        palette.addItem({ command, args, category: paletteCategory });\n    }\n    Commands.addChangeFontSizeCommandsToPalette = addChangeFontSizeCommandsToPalette;\n    /**\n     * Add New ___ File commands to the File Editor palette for common file types associated with available kernels\n     */\n    function addKernelLanguagePaletteItems(palette, trans, availableKernelFileTypes) {\n        const paletteCategory = trans.__('Text Editor');\n        for (let ext of availableKernelFileTypes) {\n            palette.addItem({\n                command: CommandIDs.createNew,\n                args: Object.assign(Object.assign({}, ext), { isPalette: true }),\n                category: paletteCategory\n            });\n        }\n    }\n    Commands.addKernelLanguagePaletteItems = addKernelLanguagePaletteItems;\n    /**\n     * Wrapper function for adding the default menu items for File Editor\n     */\n    function addMenuItems(menu, commands, tracker, trans, consoleTracker, sessionDialogs) {\n        // Add the editing commands to the settings menu.\n        addEditingCommandsToSettingsMenu(menu, commands, trans);\n        // Add new text file creation to the file menu.\n        addCreateNewFileToFileMenu(menu);\n        // Add new markdown file creation to the file menu.\n        addCreateNewMarkdownFileToFileMenu(menu);\n        // Add undo/redo hooks to the edit menu.\n        addUndoRedoToEditMenu(menu, tracker);\n        // Add editor view options.\n        addEditorViewerToViewMenu(menu, tracker, trans);\n        // Add a console creator the the file menu.\n        addConsoleCreatorToFileMenu(menu, commands, tracker, trans);\n        // Add a code runner to the run menu.\n        if (consoleTracker) {\n            addCodeRunnersToRunMenu(menu, commands, tracker, consoleTracker, trans, sessionDialogs);\n        }\n    }\n    Commands.addMenuItems = addMenuItems;\n    /**\n     * Add File Editor editing commands to the Settings menu, including:\n     * Indent with Tab, Tab Spaces, Change Font Size, and auto closing brackets\n     */\n    function addEditingCommandsToSettingsMenu(menu, commands, trans) {\n        const tabMenu = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Menu({ commands });\n        tabMenu.title.label = trans.__('Text Editor Indentation');\n        const args = {\n            insertSpaces: false,\n            size: 4,\n            name: trans.__('Indent with Tab')\n        };\n        const command = 'fileeditor:change-tabs';\n        tabMenu.addItem({ command, args });\n        for (const size of [1, 2, 4, 8]) {\n            const args = {\n                insertSpaces: true,\n                size,\n                name: trans._n('Spaces: %1', 'Spaces: %1', size)\n            };\n            tabMenu.addItem({ command, args });\n        }\n        menu.settingsMenu.addGroup([\n            {\n                command: CommandIDs.changeFontSize,\n                args: { name: trans.__('Increase Text Editor Font Size'), delta: +1 }\n            },\n            {\n                command: CommandIDs.changeFontSize,\n                args: { name: trans.__('Decrease Text Editor Font Size'), delta: -1 }\n            },\n            { type: 'submenu', submenu: tabMenu },\n            { command: CommandIDs.autoClosingBrackets }\n        ], 30);\n    }\n    Commands.addEditingCommandsToSettingsMenu = addEditingCommandsToSettingsMenu;\n    /**\n     * Add a Create New File command to the File menu\n     */\n    function addCreateNewFileToFileMenu(menu) {\n        menu.fileMenu.newMenu.addGroup([{ command: CommandIDs.createNew }], 30);\n    }\n    Commands.addCreateNewFileToFileMenu = addCreateNewFileToFileMenu;\n    /**\n     * Add a Create New Markdown File command to the File menu\n     */\n    function addCreateNewMarkdownFileToFileMenu(menu) {\n        menu.fileMenu.newMenu.addGroup([{ command: CommandIDs.createNewMarkdown }], 30);\n    }\n    Commands.addCreateNewMarkdownFileToFileMenu = addCreateNewMarkdownFileToFileMenu;\n    /**\n     * Add Create New ___ File commands to the File menu for common file types associated with available kernels\n     */\n    function addKernelLanguageMenuItems(menu, availableKernelFileTypes) {\n        for (let ext of availableKernelFileTypes) {\n            menu.fileMenu.newMenu.addGroup([{ command: CommandIDs.createNew, args: ext }], 30);\n        }\n    }\n    Commands.addKernelLanguageMenuItems = addKernelLanguageMenuItems;\n    /**\n     * Add File Editor undo and redo widgets to the Edit menu\n     */\n    function addUndoRedoToEditMenu(menu, tracker) {\n        menu.editMenu.undoers.add({\n            tracker,\n            undo: widget => {\n                widget.content.editor.undo();\n            },\n            redo: widget => {\n                widget.content.editor.redo();\n            }\n        });\n    }\n    Commands.addUndoRedoToEditMenu = addUndoRedoToEditMenu;\n    /**\n     * Add a File Editor editor viewer to the View Menu\n     */\n    function addEditorViewerToViewMenu(menu, tracker, trans) {\n        menu.viewMenu.editorViewers.add({\n            tracker,\n            toggleLineNumbers: widget => {\n                const lineNumbers = !widget.content.editor.getOption('lineNumbers');\n                widget.content.editor.setOption('lineNumbers', lineNumbers);\n            },\n            toggleWordWrap: widget => {\n                const oldValue = widget.content.editor.getOption('lineWrap');\n                const newValue = oldValue === 'off' ? 'on' : 'off';\n                widget.content.editor.setOption('lineWrap', newValue);\n            },\n            toggleMatchBrackets: widget => {\n                const matchBrackets = !widget.content.editor.getOption('matchBrackets');\n                widget.content.editor.setOption('matchBrackets', matchBrackets);\n            },\n            lineNumbersToggled: widget => widget.content.editor.getOption('lineNumbers'),\n            wordWrapToggled: widget => widget.content.editor.getOption('lineWrap') !== 'off',\n            matchBracketsToggled: widget => widget.content.editor.getOption('matchBrackets')\n        });\n    }\n    Commands.addEditorViewerToViewMenu = addEditorViewerToViewMenu;\n    /**\n     * Add a File Editor console creator to the File menu\n     */\n    function addConsoleCreatorToFileMenu(menu, commands, tracker, trans) {\n        const createConsole = getCreateConsoleFunction(commands);\n        menu.fileMenu.consoleCreators.add({\n            tracker,\n            createConsoleLabel: (n) => trans.__('Create Console for Editor'),\n            createConsole\n        });\n    }\n    Commands.addConsoleCreatorToFileMenu = addConsoleCreatorToFileMenu;\n    /**\n     * Add a File Editor code runner to the Run menu\n     */\n    function addCodeRunnersToRunMenu(menu, commands, tracker, consoleTracker, trans, sessionDialogs) {\n        menu.runMenu.codeRunners.add({\n            tracker,\n            runLabel: (n) => trans.__('Run Code'),\n            runAllLabel: (n) => trans.__('Run All Code'),\n            restartAndRunAllLabel: (n) => trans.__('Restart Kernel and Run All Code'),\n            isEnabled: current => !!consoleTracker.find(widget => { var _a; return ((_a = widget.sessionContext.session) === null || _a === void 0 ? void 0 : _a.path) === current.context.path; }),\n            run: () => commands.execute(CommandIDs.runCode),\n            runAll: () => commands.execute(CommandIDs.runAllCode),\n            restartAndRunAll: current => {\n                const widget = consoleTracker.find(widget => { var _a; return ((_a = widget.sessionContext.session) === null || _a === void 0 ? void 0 : _a.path) === current.context.path; });\n                if (widget) {\n                    return (sessionDialogs || _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.sessionContextDialogs)\n                        .restart(widget.sessionContext)\n                        .then(restarted => {\n                        if (restarted) {\n                            void commands.execute(CommandIDs.runAllCode);\n                        }\n                        return restarted;\n                    });\n                }\n            }\n        });\n    }\n    Commands.addCodeRunnersToRunMenu = addCodeRunnersToRunMenu;\n    /**\n     * Wrapper function for adding the default items to the File Editor context menu\n     */\n    function addContextMenuItems(app) {\n        addCreateConsoleToContextMenu(app);\n        addMarkdownPreviewToContextMenu(app);\n        addUndoCommandToContextMenu(app);\n        addRedoCommandToContextMenu(app);\n        addCutCommandToContextMenu(app);\n        addCopyCommandToContextMenu(app);\n        addPasteCommandToContextMenu(app);\n        addSelectAllCommandToContextMenu(app);\n    }\n    Commands.addContextMenuItems = addContextMenuItems;\n    /**\n     * Add a Create Console item to the File Editor context menu\n     */\n    function addCreateConsoleToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.createConsole,\n            selector: '.jp-FileEditor'\n        });\n    }\n    Commands.addCreateConsoleToContextMenu = addCreateConsoleToContextMenu;\n    /**\n     * Add a Markdown Preview item to the File Editor context menu\n     */\n    function addMarkdownPreviewToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.markdownPreview,\n            selector: '.jp-FileEditor'\n        });\n    }\n    Commands.addMarkdownPreviewToContextMenu = addMarkdownPreviewToContextMenu;\n    /**\n     * Add a Undo item to the File Editor context menu\n     */\n    function addUndoCommandToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.undo,\n            selector: '.jp-FileEditor',\n            rank: 1\n        });\n    }\n    Commands.addUndoCommandToContextMenu = addUndoCommandToContextMenu;\n    /**\n     * Add a Redo item to the File Editor context menu\n     */\n    function addRedoCommandToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.redo,\n            selector: '.jp-FileEditor',\n            rank: 2\n        });\n    }\n    Commands.addRedoCommandToContextMenu = addRedoCommandToContextMenu;\n    /**\n     * Add a Cut item to the File Editor context menu\n     */\n    function addCutCommandToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.cut,\n            selector: '.jp-FileEditor',\n            rank: 3\n        });\n    }\n    Commands.addCutCommandToContextMenu = addCutCommandToContextMenu;\n    /**\n     * Add a Copy item to the File Editor context menu\n     */\n    function addCopyCommandToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.copy,\n            selector: '.jp-FileEditor',\n            rank: 4\n        });\n    }\n    Commands.addCopyCommandToContextMenu = addCopyCommandToContextMenu;\n    /**\n     * Add a Paste item to the File Editor context menu\n     */\n    function addPasteCommandToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.paste,\n            selector: '.jp-FileEditor',\n            rank: 5\n        });\n    }\n    Commands.addPasteCommandToContextMenu = addPasteCommandToContextMenu;\n    /**\n     * Add a Select All item to the File Editor context menu\n     */\n    function addSelectAllCommandToContextMenu(app) {\n        app.contextMenu.addItem({\n            command: CommandIDs.selectAll,\n            selector: '.jp-FileEditor',\n            rank: 6\n        });\n    }\n    Commands.addSelectAllCommandToContextMenu = addSelectAllCommandToContextMenu;\n})(Commands || (Commands = {}));\n//# sourceMappingURL=commands.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/fileeditor-extension/lib/commands.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/fileeditor-extension/lib/index.js":
/*!*********************************************************************!*\
  !*** ../node_modules/@jupyterlab/fileeditor-extension/lib/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Commands\": () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_12__.Commands),\n/* harmony export */   \"tabSpaceStatus\": () => (/* binding */ tabSpaceStatus),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/application */ \"webpack/sharing/consume/default/@jupyterlab/application/@jupyterlab/application\");\n/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/codeeditor */ \"webpack/sharing/consume/default/@jupyterlab/codeeditor/@jupyterlab/codeeditor\");\n/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_console__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/console */ \"webpack/sharing/consume/default/@jupyterlab/console/@jupyterlab/console\");\n/* harmony import */ var _jupyterlab_console__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_console__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/filebrowser */ \"webpack/sharing/consume/default/@jupyterlab/filebrowser/@jupyterlab/filebrowser\");\n/* harmony import */ var _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/fileeditor */ \"webpack/sharing/consume/default/@jupyterlab/fileeditor/@jupyterlab/fileeditor\");\n/* harmony import */ var _jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/launcher */ \"webpack/sharing/consume/default/@jupyterlab/launcher/@jupyterlab/launcher\");\n/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/mainmenu */ \"webpack/sharing/consume/default/@jupyterlab/mainmenu/@jupyterlab/mainmenu\");\n/* harmony import */ var _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_7__);\n/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @jupyterlab/settingregistry */ \"webpack/sharing/consume/default/@jupyterlab/settingregistry/@jupyterlab/settingregistry\");\n/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_8__);\n/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @jupyterlab/statusbar */ \"webpack/sharing/consume/default/@jupyterlab/statusbar/@jupyterlab/statusbar\");\n/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_9__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_10__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_11__);\n/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./commands */ \"../node_modules/@jupyterlab/fileeditor-extension/lib/commands.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/**\n * @packageDocumentation\n * @module fileeditor-extension\n */\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * The editor tracker extension.\n */\nconst plugin = {\n    activate,\n    id: '@jupyterlab/fileeditor-extension:plugin',\n    requires: [\n        _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2__.IEditorServices,\n        _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_4__.IFileBrowserFactory,\n        _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_8__.ISettingRegistry,\n        _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_10__.ITranslator\n    ],\n    optional: [\n        _jupyterlab_console__WEBPACK_IMPORTED_MODULE_3__.IConsoleTracker,\n        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ICommandPalette,\n        _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_6__.ILauncher,\n        _jupyterlab_mainmenu__WEBPACK_IMPORTED_MODULE_7__.IMainMenu,\n        _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILayoutRestorer,\n        _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.ISessionContextDialogs\n    ],\n    provides: _jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5__.IEditorTracker,\n    autoStart: true\n};\n/**\n * A plugin that provides a status item allowing the user to\n * switch tabs vs spaces and tab widths for text editors.\n */\nconst tabSpaceStatus = {\n    id: '@jupyterlab/fileeditor-extension:tab-space-status',\n    autoStart: true,\n    requires: [_jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5__.IEditorTracker, _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_8__.ISettingRegistry, _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_10__.ITranslator],\n    optional: [_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_9__.IStatusBar],\n    activate: (app, editorTracker, settingRegistry, translator, statusBar) => {\n        const trans = translator.load('jupyterlab');\n        if (!statusBar) {\n            // Automatically disable if statusbar missing\n            return;\n        }\n        // Create a menu for switching tabs vs spaces.\n        const menu = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_11__.Menu({ commands: app.commands });\n        const command = 'fileeditor:change-tabs';\n        const { shell } = app;\n        const args = {\n            insertSpaces: false,\n            size: 4,\n            name: trans.__('Indent with Tab')\n        };\n        menu.addItem({ command, args });\n        for (const size of [1, 2, 4, 8]) {\n            const args = {\n                insertSpaces: true,\n                size,\n                name: trans._n('Spaces: %1', 'Spaces: %1', size)\n            };\n            menu.addItem({ command, args });\n        }\n        // Create the status item.\n        const item = new _jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5__.TabSpaceStatus({ menu, translator });\n        // Keep a reference to the code editor config from the settings system.\n        const updateSettings = (settings) => {\n            item.model.config = Object.assign(Object.assign({}, _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2__.CodeEditor.defaultConfig), settings.get('editorConfig').composite);\n        };\n        void Promise.all([\n            settingRegistry.load('@jupyterlab/fileeditor-extension:plugin'),\n            app.restored\n        ]).then(([settings]) => {\n            updateSettings(settings);\n            settings.changed.connect(updateSettings);\n        });\n        // Add the status item.\n        statusBar.registerStatusItem('@jupyterlab/fileeditor-extension:tab-space-status', {\n            item,\n            align: 'right',\n            rank: 1,\n            isActive: () => {\n                return (!!shell.currentWidget && editorTracker.has(shell.currentWidget));\n            }\n        });\n    }\n};\n/**\n * Export the plugins as default.\n */\nconst plugins = [plugin, tabSpaceStatus];\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugins);\n/**\n * Activate the editor tracker plugin.\n */\nfunction activate(app, editorServices, browserFactory, settingRegistry, translator, consoleTracker, palette, launcher, menu, restorer, sessionDialogs) {\n    const id = plugin.id;\n    const trans = translator.load('jupyterlab');\n    const namespace = 'editor';\n    const factory = new _jupyterlab_fileeditor__WEBPACK_IMPORTED_MODULE_5__.FileEditorFactory({\n        editorServices,\n        factoryOptions: {\n            name: _commands__WEBPACK_IMPORTED_MODULE_12__.FACTORY,\n            fileTypes: ['markdown', '*'],\n            defaultFor: ['markdown', '*'] // it outranks the defaultRendered viewer.\n        }\n    });\n    const { commands, restored, shell } = app;\n    const tracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.WidgetTracker({\n        namespace\n    });\n    const isEnabled = () => tracker.currentWidget !== null &&\n        tracker.currentWidget === shell.currentWidget;\n    const commonLanguageFileTypeData = new Map([\n        [\n            'python',\n            [\n                {\n                    fileExt: 'py',\n                    iconName: 'ui-components:python',\n                    launcherLabel: trans.__('Python File'),\n                    paletteLabel: trans.__('New Python File'),\n                    caption: trans.__('Create a new Python file')\n                }\n            ]\n        ],\n        [\n            'julia',\n            [\n                {\n                    fileExt: 'jl',\n                    iconName: 'ui-components:text-editor',\n                    launcherLabel: trans.__('Julia File'),\n                    paletteLabel: trans.__('New Julia File'),\n                    caption: trans.__('Create a new Julia file')\n                }\n            ]\n        ],\n        [\n            'R',\n            [\n                {\n                    fileExt: 'r',\n                    iconName: 'ui-components:r-kernel',\n                    launcherLabel: trans.__('R File'),\n                    paletteLabel: trans.__('New R File'),\n                    caption: trans.__('Create a new R file')\n                }\n            ]\n        ]\n    ]);\n    // Use available kernels to determine which common file types should have 'Create New' options in the Launcher, File Editor palette, and File menu\n    const getAvailableKernelFileTypes = async () => {\n        var _a, _b;\n        const specsManager = app.serviceManager.kernelspecs;\n        await specsManager.ready;\n        let fileTypes = new Set();\n        const specs = (_b = (_a = specsManager.specs) === null || _a === void 0 ? void 0 : _a.kernelspecs) !== null && _b !== void 0 ? _b : {};\n        Object.keys(specs).forEach(spec => {\n            const specModel = specs[spec];\n            if (specModel) {\n                const exts = commonLanguageFileTypeData.get(specModel.language);\n                exts === null || exts === void 0 ? void 0 : exts.forEach(ext => fileTypes.add(ext));\n            }\n        });\n        return fileTypes;\n    };\n    // Handle state restoration.\n    if (restorer) {\n        void restorer.restore(tracker, {\n            command: 'docmanager:open',\n            args: widget => ({ path: widget.context.path, factory: _commands__WEBPACK_IMPORTED_MODULE_12__.FACTORY }),\n            name: widget => widget.context.path\n        });\n    }\n    // Add a console creator to the File menu\n    // Fetch the initial state of the settings.\n    Promise.all([settingRegistry.load(id), restored])\n        .then(([settings]) => {\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateSettings(settings, commands);\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateTracker(tracker);\n        settings.changed.connect(() => {\n            _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateSettings(settings, commands);\n            _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateTracker(tracker);\n        });\n    })\n        .catch((reason) => {\n        console.error(reason.message);\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateTracker(tracker);\n    });\n    factory.widgetCreated.connect((sender, widget) => {\n        // Notify the widget tracker if restore data needs to update.\n        widget.context.pathChanged.connect(() => {\n            void tracker.save(widget);\n        });\n        void tracker.add(widget);\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateWidget(widget.content);\n    });\n    app.docRegistry.addWidgetFactory(factory);\n    // Handle the settings of new widgets.\n    tracker.widgetAdded.connect((sender, widget) => {\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.updateWidget(widget.content);\n    });\n    _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addCommands(commands, settingRegistry, trans, id, isEnabled, tracker, browserFactory);\n    // Add a launcher item if the launcher is available.\n    if (launcher) {\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addLauncherItems(launcher, trans);\n    }\n    if (palette) {\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addPaletteItems(palette, trans);\n    }\n    if (menu) {\n        _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addMenuItems(menu, commands, tracker, trans, consoleTracker, sessionDialogs);\n    }\n    getAvailableKernelFileTypes()\n        .then(availableKernelFileTypes => {\n        if (launcher) {\n            _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addKernelLanguageLauncherItems(launcher, trans, availableKernelFileTypes);\n        }\n        if (palette) {\n            _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addKernelLanguagePaletteItems(palette, trans, availableKernelFileTypes);\n        }\n        if (menu) {\n            _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addKernelLanguageMenuItems(menu, availableKernelFileTypes);\n        }\n    })\n        .catch((reason) => {\n        console.error(reason.message);\n    });\n    _commands__WEBPACK_IMPORTED_MODULE_12__.Commands.addContextMenuItems(app);\n    return tracker;\n}\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/fileeditor-extension/lib/index.js?");

/***/ })

}]);