# MIT License
#
# Copyright (c) 2021 Looker Data Sciences, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#

# 446 API methods


# NOTE: Do not edit this file generated by Looker SDK Codegen for API 4.0
import datetime
from typing import Any, MutableMapping, Optional, Sequence, Union, cast
import warnings

from . import models as mdls
from looker_sdk.rtl import api_methods
from looker_sdk.rtl import transport


class Looker40SDK(api_methods.APIMethods):

    # region Alert: Alert

    # Follow an alert.
    #
    # POST /alerts/{alert_id}/follow -> None
    def follow_alert(
        self,
        # ID of an alert
        alert_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Follow an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            None,
            self.post(
                path=f"/alerts/{alert_id}/follow",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # Unfollow an alert.
    #
    # DELETE /alerts/{alert_id}/follow -> None
    def unfollow_alert(
        self,
        # ID of an alert
        alert_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Unfollow an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            None,
            self.delete(
                path=f"/alerts/{alert_id}/follow",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search Alerts
    #
    # GET /alerts/search -> Sequence[mdls.Alert]
    def search_alerts(
        self,
        # (Optional) Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # (Optional) Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # (Optional) Dimension by which to order the results(`dashboard` | `owner`)
        group_by: Optional[str] = None,
        # (Optional) Requested fields.
        fields: Optional[str] = None,
        # (Optional) Filter on returning only enabled or disabled alerts.
        disabled: Optional[bool] = None,
        # (Optional) Filter on alert frequency, such as: monthly, weekly, daily, hourly, minutes
        frequency: Optional[str] = None,
        # (Optional) Filter on whether the alert has met its condition when it last executed
        condition_met: Optional[bool] = None,
        # (Optional) Filter on the start range of the last time the alerts were run. Example: 2021-01-01T01:01:01-08:00.
        last_run_start: Optional[str] = None,
        # (Optional) Filter on the start range of the last time the alerts were run. Example: 2021-01-01T01:01:01-08:00.
        last_run_end: Optional[str] = None,
        # (Admin only) (Optional) Filter for all owners.
        all_owners: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Alert]:
        """Search Alerts"""
        response = cast(
            Sequence[mdls.Alert],
            self.get(
                path="/alerts/search",
                structure=Sequence[mdls.Alert],
                query_params={
                    "limit": limit,
                    "offset": offset,
                    "group_by": group_by,
                    "fields": fields,
                    "disabled": disabled,
                    "frequency": frequency,
                    "condition_met": condition_met,
                    "last_run_start": last_run_start,
                    "last_run_end": last_run_end,
                    "all_owners": all_owners,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get an alert by a given alert ID
    #
    # GET /alerts/{alert_id} -> mdls.Alert
    def get_alert(
        self,
        # ID of an alert
        alert_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Alert:
        """Get an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            mdls.Alert,
            self.get(
                path=f"/alerts/{alert_id}",
                structure=mdls.Alert,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update an alert
    # # Required fields: `owner_id`, `field`, `destinations`, `comparison_type`, `threshold`, `cron`
    # #
    #
    # PUT /alerts/{alert_id} -> mdls.Alert
    def update_alert(
        self,
        # ID of an alert
        alert_id: str,
        body: mdls.WriteAlert,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Alert:
        """Update an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            mdls.Alert,
            self.put(
                path=f"/alerts/{alert_id}",
                structure=mdls.Alert,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update select alert fields
    # # Available fields: `owner_id`, `is_disabled`, `disabled_reason`, `is_public`, `threshold`
    # #
    #
    # PATCH /alerts/{alert_id} -> mdls.Alert
    def update_alert_field(
        self,
        # ID of an alert
        alert_id: str,
        body: mdls.AlertPatch,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Alert:
        """Update select fields on an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            mdls.Alert,
            self.patch(
                path=f"/alerts/{alert_id}",
                structure=mdls.Alert,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete an alert by a given alert ID
    #
    # DELETE /alerts/{alert_id} -> None
    def delete_alert(
        self,
        # ID of an alert
        alert_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Delete an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            None,
            self.delete(
                path=f"/alerts/{alert_id}",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new alert and return details of the newly created object
    #
    # Required fields: `field`, `destinations`, `comparison_type`, `threshold`, `cron`
    #
    # Example Request:
    # Run alert on dashboard element '103' at 5am every day. Send an email to 'test@test.com' if inventory for Los Angeles (using dashboard filter `Warehouse Name`) is lower than 1,000
    # ```
    # {
    #   "cron": "0 5 * * *",
    #   "custom_title": "Alert when LA inventory is low",
    #   "dashboard_element_id": 103,
    #   "applied_dashboard_filters": [
    #     {
    #       "filter_title": "Warehouse Name",
    #       "field_name": "distribution_centers.name",
    #       "filter_value": "Los Angeles CA",
    #       "filter_description": "is Los Angeles CA"
    #     }
    #   ],
    #   "comparison_type": "LESS_THAN",
    #   "destinations": [
    #     {
    #       "destination_type": "EMAIL",
    #       "email_address": "test@test.com"
    #     }
    #   ],
    #   "field": {
    #     "title": "Number on Hand",
    #     "name": "inventory_items.number_on_hand"
    #   },
    #   "is_disabled": false,
    #   "is_public": true,
    #   "threshold": 1000
    # }
    # ```
    #
    # POST /alerts -> mdls.Alert
    def create_alert(
        self,
        body: mdls.WriteAlert,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Alert:
        """Create an alert"""
        response = cast(
            mdls.Alert,
            self.post(
                path="/alerts",
                structure=mdls.Alert,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Enqueue an Alert by ID
    #
    # POST /alerts/{alert_id}/enqueue -> None
    def enqueue_alert(
        self,
        # ID of an alert
        alert_id: str,
        # Whether to enqueue an alert again if its already running.
        force: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Enqueue an alert"""
        alert_id = self.encode_path_param(alert_id)
        response = cast(
            None,
            self.post(
                path=f"/alerts/{alert_id}/enqueue",
                structure=None,
                query_params={"force": force},
                transport_options=transport_options,
            ),
        )
        return response

    # # Alert Notifications.
    #   The endpoint returns all the alert notifications received by the user on email in the past 7 days. It also returns whether the notifications have been read by the user.
    #
    # GET /alert_notifications -> Sequence[mdls.AlertNotifications]
    def alert_notifications(
        self,
        # (Optional) Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # (Optional) Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.AlertNotifications]:
        """Alert Notifications"""
        response = cast(
            Sequence[mdls.AlertNotifications],
            self.get(
                path="/alert_notifications",
                structure=Sequence[mdls.AlertNotifications],
                query_params={"limit": limit, "offset": offset},
                transport_options=transport_options,
            ),
        )
        return response

    # # Reads a Notification
    #   The endpoint marks a given alert notification as read by the user, in case it wasn't already read. The AlertNotification model is updated for this purpose. It returns the notification as a response.
    #
    # PATCH /alert_notifications/{alert_notification_id} -> mdls.AlertNotifications
    def read_alert_notification(
        self,
        # ID of a notification
        alert_notification_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.AlertNotifications:
        """Read a Notification"""
        alert_notification_id = self.encode_path_param(alert_notification_id)
        response = cast(
            mdls.AlertNotifications,
            self.patch(
                path=f"/alert_notifications/{alert_notification_id}",
                structure=mdls.AlertNotifications,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region ApiAuth: API Authentication

    # ### Present client credentials to obtain an authorization token
    #
    # Looker API implements the OAuth2 [Resource Owner Password Credentials Grant](https://docs.looker.com/r/api/outh2_resource_owner_pc) pattern.
    # The client credentials required for this login must be obtained by creating an API3 key on a user account
    # in the Looker Admin console. The API3 key consists of a public `client_id` and a private `client_secret`.
    #
    # The access token returned by `login` must be used in the HTTP Authorization header of subsequent
    # API requests, like this:
    # ```
    # Authorization: token 4QDkCyCtZzYgj4C2p2cj3csJH7zqS5RzKs2kTnG4
    # ```
    # Replace "4QDkCy..." with the `access_token` value returned by `login`.
    # The word `token` is a string literal and must be included exactly as shown.
    #
    # This function can accept `client_id` and `client_secret` parameters as URL query params or as www-form-urlencoded params in the body of the HTTP request. Since there is a small risk that URL parameters may be visible to intermediate nodes on the network route (proxies, routers, etc), passing credentials in the body of the request is considered more secure than URL params.
    #
    # Example of passing credentials in the HTTP request body:
    # ````
    # POST HTTP /login
    # Content-Type: application/x-www-form-urlencoded
    #
    # client_id=CGc9B7v7J48dQSJvxxx&client_secret=nNVS9cSS3xNpSC9JdsBvvvvv
    # ````
    #
    # ### Best Practice:
    # Always pass credentials in body params. Pass credentials in URL query params **only** when you cannot pass body params due to application, tool, or other limitations.
    #
    # For more information and detailed examples of Looker API authorization, see [How to Authenticate to Looker API3](https://github.com/looker/looker-sdk-ruby/blob/master/authentication.md).
    #
    # POST /login -> mdls.AccessToken
    def login(
        self,
        # client_id part of API3 Key.
        client_id: Optional[str] = None,
        # client_secret part of API3 Key.
        client_secret: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.AccessToken:
        """Login"""
        response = cast(
            mdls.AccessToken,
            self.post(
                path="/login",
                structure=mdls.AccessToken,
                query_params={"client_id": client_id, "client_secret": client_secret},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create an access token that runs as a given user.
    #
    # This can only be called by an authenticated admin user. It allows that admin to generate a new
    # authentication token for the user with the given user id. That token can then be used for subsequent
    # API calls - which are then performed *as* that target user.
    #
    # The target user does *not* need to have a pre-existing API client_id/client_secret pair. And, no such
    # credentials are created by this call.
    #
    # This allows for building systems where api user authentication for an arbitrary number of users is done
    # outside of Looker and funneled through a single 'service account' with admin permissions. Note that a
    # new access token is generated on each call. If target users are going to be making numerous API
    # calls in a short period then it is wise to cache this authentication token rather than call this before
    # each of those API calls.
    #
    # See 'login' for more detail on the access token and how to use it.
    #
    # POST /login/{user_id} -> mdls.AccessToken
    def login_user(
        self,
        # Id of user.
        user_id: str,
        # When true (default), API calls using the returned access_token are attributed to the admin user who created the access_token. When false, API activity is attributed to the user the access_token runs as. False requires a looker license.
        associative: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.AccessToken:
        """Login user"""
        user_id = self.encode_path_param(user_id)
        warnings.warn(
            "login_user behavior changed significantly in 21.4.0. See https://git.io/JOtH1"
        )
        response = cast(
            mdls.AccessToken,
            self.post(
                path=f"/login/{user_id}",
                structure=mdls.AccessToken,
                query_params={"associative": associative},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Logout of the API and invalidate the current access token.
    #
    # DELETE /logout -> str
    def logout(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Logout"""
        response = cast(
            str,
            self.delete(
                path="/logout", structure=str, transport_options=transport_options
            ),
        )
        return response

    # endregion

    # region Auth: Manage User Authentication Configuration

    # ### Create an embed secret using the specified information.
    #
    # The value of the `secret` field will be set by Looker and returned.
    #
    # POST /embed_config/secrets -> mdls.EmbedSecret
    def create_embed_secret(
        self,
        body: Optional[mdls.WriteEmbedSecret] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.EmbedSecret:
        """Create Embed Secret"""
        response = cast(
            mdls.EmbedSecret,
            self.post(
                path="/embed_config/secrets",
                structure=mdls.EmbedSecret,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete an embed secret.
    #
    # DELETE /embed_config/secrets/{embed_secret_id} -> str
    def delete_embed_secret(
        self,
        # Id of Embed Secret
        embed_secret_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Embed Secret"""
        embed_secret_id = self.encode_path_param(embed_secret_id)
        response = cast(
            str,
            self.delete(
                path=f"/embed_config/secrets/{embed_secret_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create SSO Embed URL
    #
    # Creates an SSO embed URL and cryptographically signs it with an embed secret.
    # This signed URL can then be used to instantiate a Looker embed session in a PBL web application.
    # Do not make any modifications to this URL - any change may invalidate the signature and
    # cause the URL to fail to load a Looker embed session.
    #
    # A signed SSO embed URL can only be used once. After it has been used to request a page from the
    # Looker server, the URL is invalid. Future requests using the same URL will fail. This is to prevent
    # 'replay attacks'.
    #
    # The `target_url` property must be a complete URL of a Looker UI page - scheme, hostname, path and query params.
    # To load a dashboard with id 56 and with a filter of `Date=1 years`, the looker URL would look like `https:/myname.looker.com/dashboards/56?Date=1%20years`.
    # The best way to obtain this target_url is to navigate to the desired Looker page in your web browser,
    # copy the URL shown in the browser address bar and paste it into the `target_url` property as a quoted string value in this API request.
    #
    # Permissions for the embed user are defined by the groups in which the embed user is a member (group_ids property)
    # and the lists of models and permissions assigned to the embed user.
    # At a minimum, you must provide values for either the group_ids property, or both the models and permissions properties.
    # These properties are additive; an embed user can be a member of certain groups AND be granted access to models and permissions.
    #
    # The embed user's access is the union of permissions granted by the group_ids, models, and permissions properties.
    #
    # This function does not strictly require all group_ids, user attribute names, or model names to exist at the moment the
    # SSO embed url is created. Unknown group_id, user attribute names or model names will be passed through to the output URL.
    # To diagnose potential problems with an SSO embed URL, you can copy the signed URL into the Embed URI Validator text box in `<your looker instance>/admin/embed`.
    #
    # The `secret_id` parameter is optional. If specified, its value must be the id of an active secret defined in the Looker instance.
    # if not specified, the URL will be signed using the newest active secret defined in the Looker instance.
    #
    # #### Security Note
    # Protect this signed URL as you would an access token or password credentials - do not write
    # it to disk, do not pass it to a third party, and only pass it through a secure HTTPS
    # encrypted transport.
    #
    # POST /embed/sso_url -> mdls.EmbedUrlResponse
    def create_sso_embed_url(
        self,
        body: mdls.EmbedSsoParams,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.EmbedUrlResponse:
        """Create SSO Embed Url"""
        response = cast(
            mdls.EmbedUrlResponse,
            self.post(
                path="/embed/sso_url",
                structure=mdls.EmbedUrlResponse,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create an Embed URL
    #
    # Creates an embed URL that runs as the Looker user making this API call. ("Embed as me")
    # This embed URL can then be used to instantiate a Looker embed session in a
    # "Powered by Looker" (PBL) web application.
    #
    # This is similar to Private Embedding (https://docs.looker.com/r/admin/embed/private-embed). Instead of
    # of logging into the Web UI to authenticate, the user has already authenticated against the API to be able to
    # make this call. However, unlike Private Embed where the user has access to any other part of the Looker UI,
    # the embed web session created by requesting the EmbedUrlResponse.url in a browser only has access to
    # content visible under the `/embed` context.
    #
    # An embed URL can only be used once, and must be used within 5 minutes of being created. After it
    # has been used to request a page from the Looker server, the URL is invalid. Future requests using
    # the same URL will fail. This is to prevent 'replay attacks'.
    #
    # The `target_url` property must be a complete URL of a Looker Embedded UI page - scheme, hostname, path starting with "/embed" and query params.
    # To load a dashboard with id 56 and with a filter of `Date=1 years`, the looker Embed URL would look like `https://myname.looker.com/embed/dashboards/56?Date=1%20years`.
    # The best way to obtain this target_url is to navigate to the desired Looker page in your web browser,
    # copy the URL shown in the browser address bar, insert "/embed" after the host/port, and paste it into the `target_url` property as a quoted string value in this API request.
    #
    # #### Security Note
    # Protect this embed URL as you would an access token or password credentials - do not write
    # it to disk, do not pass it to a third party, and only pass it through a secure HTTPS
    # encrypted transport.
    #
    # POST /embed/token_url/me -> mdls.EmbedUrlResponse
    def create_embed_url_as_me(
        self,
        body: mdls.EmbedParams,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.EmbedUrlResponse:
        """Create Embed URL"""
        response = cast(
            mdls.EmbedUrlResponse,
            self.post(
                path="/embed/token_url/me",
                structure=mdls.EmbedUrlResponse,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the LDAP configuration.
    #
    # Looker can be optionally configured to authenticate users against an Active Directory or other LDAP directory server.
    # LDAP setup requires coordination with an administrator of that directory server.
    #
    # Only Looker administrators can read and update the LDAP configuration.
    #
    # Configuring LDAP impacts authentication for all users. This configuration should be done carefully.
    #
    # Looker maintains a single LDAP configuration. It can be read and updated.       Updates only succeed if the new state will be valid (in the sense that all required fields are populated);       it is up to you to ensure that the configuration is appropriate and correct).
    #
    # LDAP is enabled or disabled for Looker using the **enabled** field.
    #
    # Looker will never return an **auth_password** field. That value can be set, but never retrieved.
    #
    # See the [Looker LDAP docs](https://docs.looker.com/r/api/ldap_setup) for additional information.
    #
    # GET /ldap_config -> mdls.LDAPConfig
    def ldap_config(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LDAPConfig:
        """Get LDAP Configuration"""
        response = cast(
            mdls.LDAPConfig,
            self.get(
                path="/ldap_config",
                structure=mdls.LDAPConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the LDAP configuration.
    #
    # Configuring LDAP impacts authentication for all users. This configuration should be done carefully.
    #
    # Only Looker administrators can read and update the LDAP configuration.
    #
    # LDAP is enabled or disabled for Looker using the **enabled** field.
    #
    # It is **highly** recommended that any LDAP setting changes be tested using the APIs below before being set globally.
    #
    # See the [Looker LDAP docs](https://docs.looker.com/r/api/ldap_setup) for additional information.
    #
    # PATCH /ldap_config -> mdls.LDAPConfig
    def update_ldap_config(
        self,
        body: mdls.WriteLDAPConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LDAPConfig:
        """Update LDAP Configuration"""
        response = cast(
            mdls.LDAPConfig,
            self.patch(
                path="/ldap_config",
                structure=mdls.LDAPConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test the connection settings for an LDAP configuration.
    #
    # This tests that the connection is possible given a connection_host and connection_port.
    #
    # **connection_host** and **connection_port** are required. **connection_tls** is optional.
    #
    # Example:
    # ```json
    # {
    #   "connection_host": "ldap.example.com",
    #   "connection_port": "636",
    #   "connection_tls": true
    # }
    # ```
    #
    # No authentication to the LDAP server is attempted.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_connection -> mdls.LDAPConfigTestResult
    def test_ldap_config_connection(
        self,
        body: mdls.WriteLDAPConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LDAPConfigTestResult:
        """Test LDAP Connection"""
        response = cast(
            mdls.LDAPConfigTestResult,
            self.put(
                path="/ldap_config/test_connection",
                structure=mdls.LDAPConfigTestResult,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test the connection authentication settings for an LDAP configuration.
    #
    # This tests that the connection is possible and that a 'server' account to be used by Looker can       authenticate to the LDAP server given connection and authentication information.
    #
    # **connection_host**, **connection_port**, and **auth_username**, are required.       **connection_tls** and **auth_password** are optional.
    #
    # Example:
    # ```json
    # {
    #   "connection_host": "ldap.example.com",
    #   "connection_port": "636",
    #   "connection_tls": true,
    #   "auth_username": "cn=looker,dc=example,dc=com",
    #   "auth_password": "secret"
    # }
    # ```
    #
    # Looker will never return an **auth_password**. If this request omits the **auth_password** field, then       the **auth_password** value from the active config (if present) will be used for the test.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_auth -> mdls.LDAPConfigTestResult
    def test_ldap_config_auth(
        self,
        body: mdls.WriteLDAPConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LDAPConfigTestResult:
        """Test LDAP Auth"""
        response = cast(
            mdls.LDAPConfigTestResult,
            self.put(
                path="/ldap_config/test_auth",
                structure=mdls.LDAPConfigTestResult,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test the user authentication settings for an LDAP configuration without authenticating the user.
    #
    # This test will let you easily test the mapping for user properties and roles for any user without      needing to authenticate as that user.
    #
    # This test accepts a full LDAP configuration along with a username and attempts to find the full info      for the user from the LDAP server without actually authenticating the user. So, user password is not      required.The configuration is validated before attempting to contact the server.
    #
    # **test_ldap_user** is required.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_user_info -> mdls.LDAPConfigTestResult
    def test_ldap_config_user_info(
        self,
        body: mdls.WriteLDAPConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LDAPConfigTestResult:
        """Test LDAP User Info"""
        response = cast(
            mdls.LDAPConfigTestResult,
            self.put(
                path="/ldap_config/test_user_info",
                structure=mdls.LDAPConfigTestResult,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test the user authentication settings for an LDAP configuration.
    #
    # This test accepts a full LDAP configuration along with a username/password pair and attempts to       authenticate the user with the LDAP server. The configuration is validated before attempting the       authentication.
    #
    # Looker will never return an **auth_password**. If this request omits the **auth_password** field, then       the **auth_password** value from the active config (if present) will be used for the test.
    #
    # **test_ldap_user** and **test_ldap_password** are required.
    #
    # The active LDAP settings are not modified.
    #
    # PUT /ldap_config/test_user_auth -> mdls.LDAPConfigTestResult
    def test_ldap_config_user_auth(
        self,
        body: mdls.WriteLDAPConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LDAPConfigTestResult:
        """Test LDAP User Auth"""
        response = cast(
            mdls.LDAPConfigTestResult,
            self.put(
                path="/ldap_config/test_user_auth",
                structure=mdls.LDAPConfigTestResult,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Registers a mobile device.
    # # Required fields: [:device_token, :device_type]
    #
    # POST /mobile/device -> mdls.MobileToken
    def register_mobile_device(
        self,
        body: mdls.WriteMobileToken,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MobileToken:
        """Register Mobile Device"""
        response = cast(
            mdls.MobileToken,
            self.post(
                path="/mobile/device",
                structure=mdls.MobileToken,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Updates the mobile device registration
    #
    # PATCH /mobile/device/{device_id} -> mdls.MobileToken
    def update_mobile_device_registration(
        self,
        # Unique id of the device.
        device_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MobileToken:
        """Update Mobile Device Registration"""
        device_id = self.encode_path_param(device_id)
        response = cast(
            mdls.MobileToken,
            self.patch(
                path=f"/mobile/device/{device_id}",
                structure=mdls.MobileToken,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Deregister a mobile device.
    #
    # DELETE /mobile/device/{device_id} -> None
    def deregister_mobile_device(
        self,
        # Unique id of the device.
        device_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Deregister Mobile Device"""
        device_id = self.encode_path_param(device_id)
        response = cast(
            None,
            self.delete(
                path=f"/mobile/device/{device_id}",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # ### List All OAuth Client Apps
    #
    # Lists all applications registered to use OAuth2 login with this Looker instance, including
    # enabled and disabled apps.
    #
    # Results are filtered to include only the apps that the caller (current user)
    # has permission to see.
    #
    # GET /oauth_client_apps -> Sequence[mdls.OauthClientApp]
    def all_oauth_client_apps(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.OauthClientApp]:
        """Get All OAuth Client Apps"""
        response = cast(
            Sequence[mdls.OauthClientApp],
            self.get(
                path="/oauth_client_apps",
                structure=Sequence[mdls.OauthClientApp],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Oauth Client App
    #
    # Returns the registered app client with matching client_guid.
    #
    # GET /oauth_client_apps/{client_guid} -> mdls.OauthClientApp
    def oauth_client_app(
        self,
        # The unique id of this application
        client_guid: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OauthClientApp:
        """Get OAuth Client App"""
        client_guid = self.encode_path_param(client_guid)
        response = cast(
            mdls.OauthClientApp,
            self.get(
                path=f"/oauth_client_apps/{client_guid}",
                structure=mdls.OauthClientApp,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Register an OAuth2 Client App
    #
    # Registers details identifying an external web app or native app as an OAuth2 login client of the Looker instance.
    # The app registration must provide a unique client_guid and redirect_uri that the app will present
    # in OAuth login requests. If the client_guid and redirect_uri parameters in the login request do not match
    # the app details registered with the Looker instance, the request is assumed to be a forgery and is rejected.
    #
    # POST /oauth_client_apps/{client_guid} -> mdls.OauthClientApp
    def register_oauth_client_app(
        self,
        # The unique id of this application
        client_guid: str,
        body: mdls.WriteOauthClientApp,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OauthClientApp:
        """Register OAuth App"""
        client_guid = self.encode_path_param(client_guid)
        response = cast(
            mdls.OauthClientApp,
            self.post(
                path=f"/oauth_client_apps/{client_guid}",
                structure=mdls.OauthClientApp,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update OAuth2 Client App Details
    #
    # Modifies the details a previously registered OAuth2 login client app.
    #
    # PATCH /oauth_client_apps/{client_guid} -> mdls.OauthClientApp
    def update_oauth_client_app(
        self,
        # The unique id of this application
        client_guid: str,
        body: mdls.WriteOauthClientApp,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OauthClientApp:
        """Update OAuth App"""
        client_guid = self.encode_path_param(client_guid)
        response = cast(
            mdls.OauthClientApp,
            self.patch(
                path=f"/oauth_client_apps/{client_guid}",
                structure=mdls.OauthClientApp,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete OAuth Client App
    #
    # Deletes the registration info of the app with the matching client_guid.
    # All active sessions and tokens issued for this app will immediately become invalid.
    #
    # As with most REST DELETE operations, this endpoint does not return an error if the
    # indicated resource does not exist.
    #
    # ### Note: this deletion cannot be undone.
    #
    # DELETE /oauth_client_apps/{client_guid} -> str
    def delete_oauth_client_app(
        self,
        # The unique id of this application
        client_guid: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete OAuth Client App"""
        client_guid = self.encode_path_param(client_guid)
        response = cast(
            str,
            self.delete(
                path=f"/oauth_client_apps/{client_guid}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Invalidate All Issued Tokens
    #
    # Immediately invalidates all auth codes, sessions, access tokens and refresh tokens issued for
    # this app for ALL USERS of this app.
    #
    # DELETE /oauth_client_apps/{client_guid}/tokens -> str
    def invalidate_tokens(
        self,
        # The unique id of the application
        client_guid: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Invalidate Tokens"""
        client_guid = self.encode_path_param(client_guid)
        response = cast(
            str,
            self.delete(
                path=f"/oauth_client_apps/{client_guid}/tokens",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Activate an app for a user
    #
    # Activates a user for a given oauth client app. This indicates the user has been informed that
    # the app will have access to the user's looker data, and that the user has accepted and allowed
    # the app to use their Looker account.
    #
    # Activating a user for an app that the user is already activated with returns a success response.
    #
    # POST /oauth_client_apps/{client_guid}/users/{user_id} -> str
    def activate_app_user(
        self,
        # The unique id of this application
        client_guid: str,
        # The id of the user to enable use of this app
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Activate OAuth App User"""
        client_guid = self.encode_path_param(client_guid)
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.post(
                path=f"/oauth_client_apps/{client_guid}/users/{user_id}",
                structure=str,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Deactivate an app for a user
    #
    # Deactivate a user for a given oauth client app. All tokens issued to the app for
    # this user will be invalid immediately. Before the user can use the app with their
    # Looker account, the user will have to read and accept an account use disclosure statement for the app.
    #
    # Admin users can deactivate other users, but non-admin users can only deactivate themselves.
    #
    # As with most REST DELETE operations, this endpoint does not return an error if the indicated
    # resource (app or user) does not exist or has already been deactivated.
    #
    # DELETE /oauth_client_apps/{client_guid}/users/{user_id} -> str
    def deactivate_app_user(
        self,
        # The unique id of this application
        client_guid: str,
        # The id of the user to enable use of this app
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Deactivate OAuth App User"""
        client_guid = self.encode_path_param(client_guid)
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/oauth_client_apps/{client_guid}/users/{user_id}",
                structure=str,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the OIDC configuration.
    #
    # Looker can be optionally configured to authenticate users against an OpenID Connect (OIDC)
    # authentication server. OIDC setup requires coordination with an administrator of that server.
    #
    # Only Looker administrators can read and update the OIDC configuration.
    #
    # Configuring OIDC impacts authentication for all users. This configuration should be done carefully.
    #
    # Looker maintains a single OIDC configuation. It can be read and updated.       Updates only succeed if the new state will be valid (in the sense that all required fields are populated);       it is up to you to ensure that the configuration is appropriate and correct).
    #
    # OIDC is enabled or disabled for Looker using the **enabled** field.
    #
    # GET /oidc_config -> mdls.OIDCConfig
    def oidc_config(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OIDCConfig:
        """Get OIDC Configuration"""
        response = cast(
            mdls.OIDCConfig,
            self.get(
                path="/oidc_config",
                structure=mdls.OIDCConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the OIDC configuration.
    #
    # Configuring OIDC impacts authentication for all users. This configuration should be done carefully.
    #
    # Only Looker administrators can read and update the OIDC configuration.
    #
    # OIDC is enabled or disabled for Looker using the **enabled** field.
    #
    # It is **highly** recommended that any OIDC setting changes be tested using the APIs below before being set globally.
    #
    # PATCH /oidc_config -> mdls.OIDCConfig
    def update_oidc_config(
        self,
        body: mdls.WriteOIDCConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OIDCConfig:
        """Update OIDC Configuration"""
        response = cast(
            mdls.OIDCConfig,
            self.patch(
                path="/oidc_config",
                structure=mdls.OIDCConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a OIDC test configuration by test_slug.
    #
    # GET /oidc_test_configs/{test_slug} -> mdls.OIDCConfig
    def oidc_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OIDCConfig:
        """Get OIDC Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = cast(
            mdls.OIDCConfig,
            self.get(
                path=f"/oidc_test_configs/{test_slug}",
                structure=mdls.OIDCConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a OIDC test configuration.
    #
    # DELETE /oidc_test_configs/{test_slug} -> str
    def delete_oidc_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete OIDC Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = cast(
            str,
            self.delete(
                path=f"/oidc_test_configs/{test_slug}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a OIDC test configuration.
    #
    # POST /oidc_test_configs -> mdls.OIDCConfig
    def create_oidc_test_config(
        self,
        body: mdls.WriteOIDCConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.OIDCConfig:
        """Create OIDC Test Configuration"""
        response = cast(
            mdls.OIDCConfig,
            self.post(
                path="/oidc_test_configs",
                structure=mdls.OIDCConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get password config.
    #
    # GET /password_config -> mdls.PasswordConfig
    def password_config(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.PasswordConfig:
        """Get Password Config"""
        response = cast(
            mdls.PasswordConfig,
            self.get(
                path="/password_config",
                structure=mdls.PasswordConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update password config.
    #
    # PATCH /password_config -> mdls.PasswordConfig
    def update_password_config(
        self,
        body: mdls.WritePasswordConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.PasswordConfig:
        """Update Password Config"""
        response = cast(
            mdls.PasswordConfig,
            self.patch(
                path="/password_config",
                structure=mdls.PasswordConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Force all credentials_email users to reset their login passwords upon their next login.
    #
    # PUT /password_config/force_password_reset_at_next_login_for_all_users -> str
    def force_password_reset_at_next_login_for_all_users(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Force password reset"""
        response = cast(
            str,
            self.put(
                path="/password_config/force_password_reset_at_next_login_for_all_users",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the SAML configuration.
    #
    # Looker can be optionally configured to authenticate users against a SAML authentication server.
    # SAML setup requires coordination with an administrator of that server.
    #
    # Only Looker administrators can read and update the SAML configuration.
    #
    # Configuring SAML impacts authentication for all users. This configuration should be done carefully.
    #
    # Looker maintains a single SAML configuation. It can be read and updated.       Updates only succeed if the new state will be valid (in the sense that all required fields are populated);       it is up to you to ensure that the configuration is appropriate and correct).
    #
    # SAML is enabled or disabled for Looker using the **enabled** field.
    #
    # GET /saml_config -> mdls.SamlConfig
    def saml_config(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SamlConfig:
        """Get SAML Configuration"""
        response = cast(
            mdls.SamlConfig,
            self.get(
                path="/saml_config",
                structure=mdls.SamlConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the SAML configuration.
    #
    # Configuring SAML impacts authentication for all users. This configuration should be done carefully.
    #
    # Only Looker administrators can read and update the SAML configuration.
    #
    # SAML is enabled or disabled for Looker using the **enabled** field.
    #
    # It is **highly** recommended that any SAML setting changes be tested using the APIs below before being set globally.
    #
    # PATCH /saml_config -> mdls.SamlConfig
    def update_saml_config(
        self,
        body: mdls.WriteSamlConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SamlConfig:
        """Update SAML Configuration"""
        response = cast(
            mdls.SamlConfig,
            self.patch(
                path="/saml_config",
                structure=mdls.SamlConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a SAML test configuration by test_slug.
    #
    # GET /saml_test_configs/{test_slug} -> mdls.SamlConfig
    def saml_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SamlConfig:
        """Get SAML Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = cast(
            mdls.SamlConfig,
            self.get(
                path=f"/saml_test_configs/{test_slug}",
                structure=mdls.SamlConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a SAML test configuration.
    #
    # DELETE /saml_test_configs/{test_slug} -> str
    def delete_saml_test_config(
        self,
        # Slug of test config
        test_slug: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete SAML Test Configuration"""
        test_slug = self.encode_path_param(test_slug)
        response = cast(
            str,
            self.delete(
                path=f"/saml_test_configs/{test_slug}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a SAML test configuration.
    #
    # POST /saml_test_configs -> mdls.SamlConfig
    def create_saml_test_config(
        self,
        body: mdls.WriteSamlConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SamlConfig:
        """Create SAML Test Configuration"""
        response = cast(
            mdls.SamlConfig,
            self.post(
                path="/saml_test_configs",
                structure=mdls.SamlConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Parse the given xml as a SAML IdP metadata document and return the result.
    #
    # POST /parse_saml_idp_metadata -> mdls.SamlMetadataParseResult
    def parse_saml_idp_metadata(
        self,
        body: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SamlMetadataParseResult:
        """Parse SAML IdP XML"""
        response = cast(
            mdls.SamlMetadataParseResult,
            self.post(
                path="/parse_saml_idp_metadata",
                structure=mdls.SamlMetadataParseResult,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Fetch the given url and parse it as a SAML IdP metadata document and return the result.
    # Note that this requires that the url be public or at least at a location where the Looker instance
    # can fetch it without requiring any special authentication.
    #
    # POST /fetch_and_parse_saml_idp_metadata -> mdls.SamlMetadataParseResult
    def fetch_and_parse_saml_idp_metadata(
        self,
        body: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SamlMetadataParseResult:
        """Parse SAML IdP Url"""
        response = cast(
            mdls.SamlMetadataParseResult,
            self.post(
                path="/fetch_and_parse_saml_idp_metadata",
                structure=mdls.SamlMetadataParseResult,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get session config.
    #
    # GET /session_config -> mdls.SessionConfig
    def session_config(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SessionConfig:
        """Get Session Config"""
        response = cast(
            mdls.SessionConfig,
            self.get(
                path="/session_config",
                structure=mdls.SessionConfig,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update session config.
    #
    # PATCH /session_config -> mdls.SessionConfig
    def update_session_config(
        self,
        body: mdls.WriteSessionConfig,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SessionConfig:
        """Update Session Config"""
        response = cast(
            mdls.SessionConfig,
            self.patch(
                path="/session_config",
                structure=mdls.SessionConfig,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Support Access Allowlist Users
    #
    # Returns the users that have been added to the Support Access Allowlist
    #
    # GET /support_access/allowlist -> Sequence[mdls.SupportAccessAllowlistEntry]
    def get_support_access_allowlist_entries(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.SupportAccessAllowlistEntry]:
        """Get Support Access Allowlist Users"""
        response = cast(
            Sequence[mdls.SupportAccessAllowlistEntry],
            self.get(
                path="/support_access/allowlist",
                structure=Sequence[mdls.SupportAccessAllowlistEntry],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Add Support Access Allowlist Users
    #
    # Adds a list of emails to the Allowlist, using the provided reason
    #
    # POST /support_access/allowlist -> Sequence[mdls.SupportAccessAllowlistEntry]
    def add_support_access_allowlist_entries(
        self,
        body: mdls.SupportAccessAddEntries,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.SupportAccessAllowlistEntry]:
        """Add Support Access Allowlist Users"""
        response = cast(
            Sequence[mdls.SupportAccessAllowlistEntry],
            self.post(
                path="/support_access/allowlist",
                structure=Sequence[mdls.SupportAccessAllowlistEntry],
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete Support Access Allowlist User
    #
    # Deletes the specified Allowlist Entry Id
    #
    # DELETE /support_access/allowlist/{entry_id} -> str
    def delete_support_access_allowlist_entry(
        self,
        # Id of Allowlist Entry
        entry_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Support Access Allowlist Entry"""
        entry_id = self.encode_path_param(entry_id)
        response = cast(
            str,
            self.delete(
                path=f"/support_access/allowlist/{entry_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Enable Support Access
    #
    # Enables Support Access for the provided duration
    #
    # PUT /support_access/enable -> mdls.SupportAccessStatus
    def enable_support_access(
        self,
        body: mdls.SupportAccessEnable,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SupportAccessStatus:
        """Enable Support Access"""
        response = cast(
            mdls.SupportAccessStatus,
            self.put(
                path="/support_access/enable",
                structure=mdls.SupportAccessStatus,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Disable Support Access
    #
    # Disables Support Access immediately
    #
    # PUT /support_access/disable -> mdls.SupportAccessStatus
    def disable_support_access(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SupportAccessStatus:
        """Disable Support Access"""
        response = cast(
            mdls.SupportAccessStatus,
            self.put(
                path="/support_access/disable",
                structure=mdls.SupportAccessStatus,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Support Access Status
    #
    # Returns the current Support Access Status
    #
    # GET /support_access/status -> mdls.SupportAccessStatus
    def support_access_status(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SupportAccessStatus:
        """Support Access Status"""
        response = cast(
            mdls.SupportAccessStatus,
            self.get(
                path="/support_access/status",
                structure=mdls.SupportAccessStatus,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get currently locked-out users.
    #
    # GET /user_login_lockouts -> Sequence[mdls.UserLoginLockout]
    def all_user_login_lockouts(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.UserLoginLockout]:
        """Get All User Login Lockouts"""
        response = cast(
            Sequence[mdls.UserLoginLockout],
            self.get(
                path="/user_login_lockouts",
                structure=Sequence[mdls.UserLoginLockout],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search currently locked-out users.
    #
    # GET /user_login_lockouts/search -> Sequence[mdls.UserLoginLockout]
    def search_user_login_lockouts(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Auth type user is locked out for (email, ldap, totp, api)
        auth_type: Optional[str] = None,
        # Match name
        full_name: Optional[str] = None,
        # Match email
        email: Optional[str] = None,
        # Match remote LDAP ID
        remote_id: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.UserLoginLockout]:
        """Search User Login Lockouts"""
        response = cast(
            Sequence[mdls.UserLoginLockout],
            self.get(
                path="/user_login_lockouts/search",
                structure=Sequence[mdls.UserLoginLockout],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "auth_type": auth_type,
                    "full_name": full_name,
                    "email": email,
                    "remote_id": remote_id,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Removes login lockout for the associated user.
    #
    # DELETE /user_login_lockout/{key} -> str
    def delete_user_login_lockout(
        self,
        # The key associated with the locked user
        key: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete User Login Lockout"""
        key = self.encode_path_param(key)
        response = cast(
            str,
            self.delete(
                path=f"/user_login_lockout/{key}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Board: Manage Boards

    # ### Get information about all boards.
    #
    # GET /boards -> Sequence[mdls.Board]
    def all_boards(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Board]:
        """Get All Boards"""
        response = cast(
            Sequence[mdls.Board],
            self.get(
                path="/boards",
                structure=Sequence[mdls.Board],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new board.
    #
    # POST /boards -> mdls.Board
    def create_board(
        self,
        body: mdls.WriteBoard,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Board:
        """Create Board"""
        response = cast(
            mdls.Board,
            self.post(
                path="/boards",
                structure=mdls.Board,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search Boards
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /boards/search -> Sequence[mdls.Board]
    def search_boards(
        self,
        # Matches board title.
        title: Optional[str] = None,
        # Matches the timestamp for when the board was created.
        created_at: Optional[str] = None,
        # The first name of the user who created this board.
        first_name: Optional[str] = None,
        # The last name of the user who created this board.
        last_name: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Return favorited boards when true.
        favorited: Optional[bool] = None,
        # Filter on boards created by a particular user.
        creator_id: Optional[str] = None,
        # The fields to sort the results by
        sorts: Optional[str] = None,
        # The page to return. DEPRECATED. Use offset instead.
        page: Optional[int] = None,
        # The number of items in the returned page. DEPRECATED. Use limit instead.
        per_page: Optional[int] = None,
        # The number of items to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # The maximum number of items to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Filter results based on permission, either show (default) or update
        permission: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Board]:
        """Search Boards"""
        response = cast(
            Sequence[mdls.Board],
            self.get(
                path="/boards/search",
                structure=Sequence[mdls.Board],
                query_params={
                    "title": title,
                    "created_at": created_at,
                    "first_name": first_name,
                    "last_name": last_name,
                    "fields": fields,
                    "favorited": favorited,
                    "creator_id": creator_id,
                    "sorts": sorts,
                    "page": page,
                    "per_page": per_page,
                    "offset": offset,
                    "limit": limit,
                    "filter_or": filter_or,
                    "permission": permission,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a board.
    #
    # GET /boards/{board_id} -> mdls.Board
    def board(
        self,
        # Id of board
        board_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Board:
        """Get Board"""
        board_id = self.encode_path_param(board_id)
        response = cast(
            mdls.Board,
            self.get(
                path=f"/boards/{board_id}",
                structure=mdls.Board,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a board definition.
    #
    # PATCH /boards/{board_id} -> mdls.Board
    def update_board(
        self,
        # Id of board
        board_id: str,
        body: mdls.WriteBoard,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Board:
        """Update Board"""
        board_id = self.encode_path_param(board_id)
        response = cast(
            mdls.Board,
            self.patch(
                path=f"/boards/{board_id}",
                structure=mdls.Board,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a board.
    #
    # DELETE /boards/{board_id} -> str
    def delete_board(
        self,
        # Id of board
        board_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Board"""
        board_id = self.encode_path_param(board_id)
        response = cast(
            str,
            self.delete(
                path=f"/boards/{board_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all board items.
    #
    # GET /board_items -> Sequence[mdls.BoardItem]
    def all_board_items(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Filter to a specific board section
        board_section_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.BoardItem]:
        """Get All Board Items"""
        response = cast(
            Sequence[mdls.BoardItem],
            self.get(
                path="/board_items",
                structure=Sequence[mdls.BoardItem],
                query_params={
                    "fields": fields,
                    "sorts": sorts,
                    "board_section_id": board_section_id,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new board item.
    #
    # POST /board_items -> mdls.BoardItem
    def create_board_item(
        self,
        body: mdls.WriteBoardItem,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BoardItem:
        """Create Board Item"""
        response = cast(
            mdls.BoardItem,
            self.post(
                path="/board_items",
                structure=mdls.BoardItem,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a board item.
    #
    # GET /board_items/{board_item_id} -> mdls.BoardItem
    def board_item(
        self,
        # Id of board item
        board_item_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BoardItem:
        """Get Board Item"""
        board_item_id = self.encode_path_param(board_item_id)
        response = cast(
            mdls.BoardItem,
            self.get(
                path=f"/board_items/{board_item_id}",
                structure=mdls.BoardItem,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a board item definition.
    #
    # PATCH /board_items/{board_item_id} -> mdls.BoardItem
    def update_board_item(
        self,
        # Id of board item
        board_item_id: str,
        body: mdls.WriteBoardItem,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BoardItem:
        """Update Board Item"""
        board_item_id = self.encode_path_param(board_item_id)
        response = cast(
            mdls.BoardItem,
            self.patch(
                path=f"/board_items/{board_item_id}",
                structure=mdls.BoardItem,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a board item.
    #
    # DELETE /board_items/{board_item_id} -> str
    def delete_board_item(
        self,
        # Id of board item
        board_item_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Board Item"""
        board_item_id = self.encode_path_param(board_item_id)
        response = cast(
            str,
            self.delete(
                path=f"/board_items/{board_item_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all board sections.
    #
    # GET /board_sections -> Sequence[mdls.BoardSection]
    def all_board_sections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.BoardSection]:
        """Get All Board sections"""
        response = cast(
            Sequence[mdls.BoardSection],
            self.get(
                path="/board_sections",
                structure=Sequence[mdls.BoardSection],
                query_params={"fields": fields, "sorts": sorts},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new board section.
    #
    # POST /board_sections -> mdls.BoardSection
    def create_board_section(
        self,
        body: mdls.WriteBoardSection,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BoardSection:
        """Create Board section"""
        response = cast(
            mdls.BoardSection,
            self.post(
                path="/board_sections",
                structure=mdls.BoardSection,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a board section.
    #
    # GET /board_sections/{board_section_id} -> mdls.BoardSection
    def board_section(
        self,
        # Id of board section
        board_section_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BoardSection:
        """Get Board section"""
        board_section_id = self.encode_path_param(board_section_id)
        response = cast(
            mdls.BoardSection,
            self.get(
                path=f"/board_sections/{board_section_id}",
                structure=mdls.BoardSection,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a board section definition.
    #
    # PATCH /board_sections/{board_section_id} -> mdls.BoardSection
    def update_board_section(
        self,
        # Id of board section
        board_section_id: str,
        body: mdls.WriteBoardSection,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BoardSection:
        """Update Board section"""
        board_section_id = self.encode_path_param(board_section_id)
        response = cast(
            mdls.BoardSection,
            self.patch(
                path=f"/board_sections/{board_section_id}",
                structure=mdls.BoardSection,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a board section.
    #
    # DELETE /board_sections/{board_section_id} -> str
    def delete_board_section(
        self,
        # Id of board section
        board_section_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Board section"""
        board_section_id = self.encode_path_param(board_section_id)
        response = cast(
            str,
            self.delete(
                path=f"/board_sections/{board_section_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region ColorCollection: Manage Color Collections

    # ### Get an array of all existing Color Collections
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **standard** color collections with [ColorCollection](#!/ColorCollection/color_collections_standard)
    #
    # Get all **custom** color collections with [ColorCollection](#!/ColorCollection/color_collections_custom)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections -> Sequence[mdls.ColorCollection]
    def all_color_collections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ColorCollection]:
        """Get all Color Collections"""
        response = cast(
            Sequence[mdls.ColorCollection],
            self.get(
                path="/color_collections",
                structure=Sequence[mdls.ColorCollection],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a custom color collection with the specified information
    #
    # Creates a new custom color collection object, returning the details, including the created id.
    #
    # **Update** an existing color collection with [Update Color Collection](#!/ColorCollection/update_color_collection)
    #
    # **Permanently delete** an existing custom color collection with [Delete Color Collection](#!/ColorCollection/delete_color_collection)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # POST /color_collections -> mdls.ColorCollection
    def create_color_collection(
        self,
        body: mdls.WriteColorCollection,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ColorCollection:
        """Create ColorCollection"""
        response = cast(
            mdls.ColorCollection,
            self.post(
                path="/color_collections",
                structure=mdls.ColorCollection,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get an array of all existing **Custom** Color Collections
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **standard** color collections with [ColorCollection](#!/ColorCollection/color_collections_standard)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections/custom -> Sequence[mdls.ColorCollection]
    def color_collections_custom(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ColorCollection]:
        """Get all Custom Color Collections"""
        response = cast(
            Sequence[mdls.ColorCollection],
            self.get(
                path="/color_collections/custom",
                structure=Sequence[mdls.ColorCollection],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get an array of all existing **Standard** Color Collections
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **custom** color collections with [ColorCollection](#!/ColorCollection/color_collections_custom)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections/standard -> Sequence[mdls.ColorCollection]
    def color_collections_standard(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ColorCollection]:
        """Get all Standard Color Collections"""
        response = cast(
            Sequence[mdls.ColorCollection],
            self.get(
                path="/color_collections/standard",
                structure=Sequence[mdls.ColorCollection],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the default color collection
    #
    # Use this to retrieve the default Color Collection.
    #
    # Set the default color collection with [ColorCollection](#!/ColorCollection/set_default_color_collection)
    #
    # GET /color_collections/default -> mdls.ColorCollection
    def default_color_collection(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ColorCollection:
        """Get Default Color Collection"""
        response = cast(
            mdls.ColorCollection,
            self.get(
                path="/color_collections/default",
                structure=mdls.ColorCollection,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set the global default Color Collection by ID
    #
    # Returns the new specified default Color Collection object.
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # PUT /color_collections/default -> mdls.ColorCollection
    def set_default_color_collection(
        self,
        # ID of color collection to set as default
        collection_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ColorCollection:
        """Set Default Color Collection"""
        response = cast(
            mdls.ColorCollection,
            self.put(
                path="/color_collections/default",
                structure=mdls.ColorCollection,
                query_params={"collection_id": collection_id},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a Color Collection by ID
    #
    # Use this to retrieve a specific Color Collection.
    # Get a **single** color collection by id with [ColorCollection](#!/ColorCollection/color_collection)
    #
    # Get all **standard** color collections with [ColorCollection](#!/ColorCollection/color_collections_standard)
    #
    # Get all **custom** color collections with [ColorCollection](#!/ColorCollection/color_collections_custom)
    #
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # GET /color_collections/{collection_id} -> mdls.ColorCollection
    def color_collection(
        self,
        # Id of Color Collection
        collection_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ColorCollection:
        """Get Color Collection by ID"""
        collection_id = self.encode_path_param(collection_id)
        response = cast(
            mdls.ColorCollection,
            self.get(
                path=f"/color_collections/{collection_id}",
                structure=mdls.ColorCollection,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a custom color collection by id.
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # PATCH /color_collections/{collection_id} -> mdls.ColorCollection
    def update_color_collection(
        self,
        # Id of Custom Color Collection
        collection_id: str,
        body: mdls.WriteColorCollection,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ColorCollection:
        """Update Custom Color collection"""
        collection_id = self.encode_path_param(collection_id)
        response = cast(
            mdls.ColorCollection,
            self.patch(
                path=f"/color_collections/{collection_id}",
                structure=mdls.ColorCollection,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a custom color collection by id
    #
    # This operation permanently deletes the identified **Custom** color collection.
    #
    # **Standard** color collections cannot be deleted
    #
    # Because multiple color collections can have the same label, they must be deleted by ID, not name.
    # **Note**: Only an API user with the Admin role can call this endpoint. Unauthorized requests will return `Not Found` (404) errors.
    #
    # DELETE /color_collections/{collection_id} -> str
    def delete_color_collection(
        self,
        # Id of Color Collection
        collection_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete ColorCollection"""
        collection_id = self.encode_path_param(collection_id)
        response = cast(
            str,
            self.delete(
                path=f"/color_collections/{collection_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Config: Manage General Configuration

    # Get the current Cloud Storage Configuration.
    #
    # GET /cloud_storage -> mdls.BackupConfiguration
    def cloud_storage_configuration(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BackupConfiguration:
        """Get Cloud Storage"""
        response = cast(
            mdls.BackupConfiguration,
            self.get(
                path="/cloud_storage",
                structure=mdls.BackupConfiguration,
                transport_options=transport_options,
            ),
        )
        return response

    # Update the current Cloud Storage Configuration.
    #
    # PATCH /cloud_storage -> mdls.BackupConfiguration
    def update_cloud_storage_configuration(
        self,
        body: mdls.WriteBackupConfiguration,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.BackupConfiguration:
        """Update Cloud Storage"""
        response = cast(
            mdls.BackupConfiguration,
            self.patch(
                path="/cloud_storage",
                structure=mdls.BackupConfiguration,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the current status and content of custom welcome emails
    #
    # GET /custom_welcome_email -> mdls.CustomWelcomeEmail
    def custom_welcome_email(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CustomWelcomeEmail:
        """Get Custom Welcome Email"""
        response = cast(
            mdls.CustomWelcomeEmail,
            self.get(
                path="/custom_welcome_email",
                structure=mdls.CustomWelcomeEmail,
                transport_options=transport_options,
            ),
        )
        return response

    # Update custom welcome email setting and values. Optionally send a test email with the new content to the currently logged in user.
    #
    # PATCH /custom_welcome_email -> mdls.CustomWelcomeEmail
    def update_custom_welcome_email(
        self,
        body: mdls.CustomWelcomeEmail,
        # If true a test email with the content from the request will be sent to the current user after saving
        send_test_welcome_email: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CustomWelcomeEmail:
        """Update Custom Welcome Email Content"""
        response = cast(
            mdls.CustomWelcomeEmail,
            self.patch(
                path="/custom_welcome_email",
                structure=mdls.CustomWelcomeEmail,
                query_params={"send_test_welcome_email": send_test_welcome_email},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # Requests to this endpoint will send a welcome email with the custom content provided in the body to the currently logged in user.
    #
    # PUT /custom_welcome_email_test -> mdls.WelcomeEmailTest
    def update_custom_welcome_email_test(
        self,
        body: mdls.WelcomeEmailTest,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.WelcomeEmailTest:
        """Send a test welcome email to the currently logged in user with the supplied content"""
        response = cast(
            mdls.WelcomeEmailTest,
            self.put(
                path="/custom_welcome_email_test",
                structure=mdls.WelcomeEmailTest,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Retrieve the value for whether or not digest emails is enabled
    #
    # GET /digest_emails_enabled -> mdls.DigestEmails
    def digest_emails_enabled(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DigestEmails:
        """Get Digest_emails"""
        response = cast(
            mdls.DigestEmails,
            self.get(
                path="/digest_emails_enabled",
                structure=mdls.DigestEmails,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the setting for enabling/disabling digest emails
    #
    # PATCH /digest_emails_enabled -> mdls.DigestEmails
    def update_digest_emails_enabled(
        self,
        body: mdls.DigestEmails,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DigestEmails:
        """Update Digest_emails"""
        response = cast(
            mdls.DigestEmails,
            self.patch(
                path="/digest_emails_enabled",
                structure=mdls.DigestEmails,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Trigger the generation of digest email records and send them to Looker's internal system. This does not send
    # any actual emails, it generates records containing content which may be of interest for users who have become inactive.
    # Emails will be sent at a later time from Looker's internal system if the Digest Emails feature is enabled in settings.
    #
    # POST /digest_email_send -> mdls.DigestEmailSend
    def create_digest_email_send(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DigestEmailSend:
        """Deliver digest email contents"""
        response = cast(
            mdls.DigestEmailSend,
            self.post(
                path="/digest_email_send",
                structure=mdls.DigestEmailSend,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Egress IP Addresses
    #
    # Returns the list of public egress IP Addresses for a hosted customer's instance
    #
    # GET /public_egress_ip_addresses -> mdls.EgressIpAddresses
    def public_egress_ip_addresses(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.EgressIpAddresses:
        """Public Egress IP Addresses"""
        response = cast(
            mdls.EgressIpAddresses,
            self.get(
                path="/public_egress_ip_addresses",
                structure=mdls.EgressIpAddresses,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set the menu item name and content for internal help resources
    #
    # GET /internal_help_resources_content -> mdls.InternalHelpResourcesContent
    def internal_help_resources_content(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.InternalHelpResourcesContent:
        """Get Internal Help Resources Content"""
        response = cast(
            mdls.InternalHelpResourcesContent,
            self.get(
                path="/internal_help_resources_content",
                structure=mdls.InternalHelpResourcesContent,
                transport_options=transport_options,
            ),
        )
        return response

    # Update internal help resources content
    #
    # PATCH /internal_help_resources_content -> mdls.InternalHelpResourcesContent
    def update_internal_help_resources_content(
        self,
        body: mdls.WriteInternalHelpResourcesContent,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.InternalHelpResourcesContent:
        """Update internal help resources content"""
        response = cast(
            mdls.InternalHelpResourcesContent,
            self.patch(
                path="/internal_help_resources_content",
                structure=mdls.InternalHelpResourcesContent,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get and set the options for internal help resources
    #
    # GET /internal_help_resources_enabled -> mdls.InternalHelpResources
    def internal_help_resources(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.InternalHelpResources:
        """Get Internal Help Resources"""
        response = cast(
            mdls.InternalHelpResources,
            self.get(
                path="/internal_help_resources_enabled",
                structure=mdls.InternalHelpResources,
                transport_options=transport_options,
            ),
        )
        return response

    # Update internal help resources settings
    #
    # PATCH /internal_help_resources -> mdls.InternalHelpResources
    def update_internal_help_resources(
        self,
        body: mdls.WriteInternalHelpResources,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.InternalHelpResources:
        """Update internal help resources configuration"""
        response = cast(
            mdls.InternalHelpResources,
            self.patch(
                path="/internal_help_resources",
                structure=mdls.InternalHelpResources,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get all legacy features.
    #
    # GET /legacy_features -> Sequence[mdls.LegacyFeature]
    def all_legacy_features(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.LegacyFeature]:
        """Get All Legacy Features"""
        response = cast(
            Sequence[mdls.LegacyFeature],
            self.get(
                path="/legacy_features",
                structure=Sequence[mdls.LegacyFeature],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the legacy feature with a specific id.
    #
    # GET /legacy_features/{legacy_feature_id} -> mdls.LegacyFeature
    def legacy_feature(
        self,
        # id of legacy feature
        legacy_feature_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LegacyFeature:
        """Get Legacy Feature"""
        legacy_feature_id = self.encode_path_param(legacy_feature_id)
        response = cast(
            mdls.LegacyFeature,
            self.get(
                path=f"/legacy_features/{legacy_feature_id}",
                structure=mdls.LegacyFeature,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update information about the legacy feature with a specific id.
    #
    # PATCH /legacy_features/{legacy_feature_id} -> mdls.LegacyFeature
    def update_legacy_feature(
        self,
        # id of legacy feature
        legacy_feature_id: str,
        body: mdls.WriteLegacyFeature,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LegacyFeature:
        """Update Legacy Feature"""
        legacy_feature_id = self.encode_path_param(legacy_feature_id)
        response = cast(
            mdls.LegacyFeature,
            self.patch(
                path=f"/legacy_features/{legacy_feature_id}",
                structure=mdls.LegacyFeature,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a list of locales that Looker supports.
    #
    # GET /locales -> Sequence[mdls.Locale]
    def all_locales(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Locale]:
        """Get All Locales"""
        response = cast(
            Sequence[mdls.Locale],
            self.get(
                path="/locales",
                structure=Sequence[mdls.Locale],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get all mobile settings.
    #
    # GET /mobile/settings -> mdls.MobileSettings
    def mobile_settings(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MobileSettings:
        """Get Mobile_Settings"""
        response = cast(
            mdls.MobileSettings,
            self.get(
                path="/mobile/settings",
                structure=mdls.MobileSettings,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Looker Settings
    #
    # Available settings are:
    #  - extension_framework_enabled
    #  - extension_load_url_enabled
    #  - marketplace_auto_install_enabled
    #  - marketplace_enabled
    #  - privatelabel_configuration
    #  - custom_welcome_email
    #  - onboarding_enabled
    #
    # GET /setting -> mdls.Setting
    def get_setting(
        self,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Setting:
        """Get Setting"""
        response = cast(
            mdls.Setting,
            self.get(
                path="/setting",
                structure=mdls.Setting,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Configure Looker Settings
    #
    # Available settings are:
    #  - extension_framework_enabled
    #  - extension_load_url_enabled
    #  - marketplace_auto_install_enabled
    #  - marketplace_enabled
    #  - privatelabel_configuration
    #  - custom_welcome_email
    #  - onboarding_enabled
    #
    # See the `Setting` type for more information on the specific values that can be configured.
    #
    # PATCH /setting -> mdls.Setting
    def set_setting(
        self,
        body: mdls.WriteSetting,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Setting:
        """Set Setting"""
        response = cast(
            mdls.Setting,
            self.patch(
                path="/setting",
                structure=mdls.Setting,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Configure SMTP Settings
    #   This API allows users to configure the SMTP settings on the Looker instance.
    #   This API is only supported in the OEM jar. Additionally, only admin users are authorised to call this API.
    #
    # POST /smtp_settings -> None
    def set_smtp_settings(
        self,
        body: mdls.SmtpSettings,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Set SMTP Setting"""
        response = cast(
            None,
            self.post(
                path="/smtp_settings",
                structure=None,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get current SMTP status.
    #
    # GET /smtp_status -> mdls.SmtpStatus
    def smtp_status(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SmtpStatus:
        """Get SMTP Status"""
        response = cast(
            mdls.SmtpStatus,
            self.get(
                path="/smtp_status",
                structure=mdls.SmtpStatus,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a list of timezones that Looker supports (e.g. useful for scheduling tasks).
    #
    # GET /timezones -> Sequence[mdls.Timezone]
    def all_timezones(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Timezone]:
        """Get All Timezones"""
        response = cast(
            Sequence[mdls.Timezone],
            self.get(
                path="/timezones",
                structure=Sequence[mdls.Timezone],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all API versions supported by this Looker instance.
    #
    # GET /versions -> mdls.ApiVersion
    def versions(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ApiVersion:
        """Get ApiVersion"""
        response = cast(
            mdls.ApiVersion,
            self.get(
                path="/versions",
                structure=mdls.ApiVersion,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get an API specification for this Looker instance.
    #
    # The specification is returned as a JSON document in Swagger 2.x format
    #
    # GET /api_spec/{api_version}/{specification} -> Any
    def api_spec(
        self,
        # API version
        api_version: str,
        # Specification name. Typically, this is "swagger.json"
        specification: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Any:
        """Get an API specification"""
        api_version = self.encode_path_param(api_version)
        specification = self.encode_path_param(specification)
        response = cast(
            Any,
            self.get(
                path=f"/api_spec/{api_version}/{specification}",
                structure=Any,
                transport_options=transport_options,
            ),
        )
        return response

    # ### This feature is enabled only by special license.
    # ### Gets the whitelabel configuration, which includes hiding documentation links, custom favicon uploading, etc.
    #
    # GET /whitelabel_configuration -> mdls.WhitelabelConfiguration
    def whitelabel_configuration(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.WhitelabelConfiguration:
        """Get Whitelabel configuration"""
        response = cast(
            mdls.WhitelabelConfiguration,
            self.get(
                path="/whitelabel_configuration",
                structure=mdls.WhitelabelConfiguration,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the whitelabel configuration
    #
    # PUT /whitelabel_configuration -> mdls.WhitelabelConfiguration
    def update_whitelabel_configuration(
        self,
        body: mdls.WriteWhitelabelConfiguration,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.WhitelabelConfiguration:
        """Update Whitelabel configuration"""
        response = cast(
            mdls.WhitelabelConfiguration,
            self.put(
                path="/whitelabel_configuration",
                structure=mdls.WhitelabelConfiguration,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Connection: Manage Database Connections

    # ### Get information about all connections.
    #
    # GET /connections -> Sequence[mdls.DBConnection]
    def all_connections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DBConnection]:
        """Get All Connections"""
        response = cast(
            Sequence[mdls.DBConnection],
            self.get(
                path="/connections",
                structure=Sequence[mdls.DBConnection],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a connection using the specified configuration.
    #
    # POST /connections -> mdls.DBConnection
    def create_connection(
        self,
        body: mdls.WriteDBConnection,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DBConnection:
        """Create Connection"""
        response = cast(
            mdls.DBConnection,
            self.post(
                path="/connections",
                structure=mdls.DBConnection,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a connection.
    #
    # GET /connections/{connection_name} -> mdls.DBConnection
    def connection(
        self,
        # Name of connection
        connection_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DBConnection:
        """Get Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            mdls.DBConnection,
            self.get(
                path=f"/connections/{connection_name}",
                structure=mdls.DBConnection,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a connection using the specified configuration.
    #
    # PATCH /connections/{connection_name} -> mdls.DBConnection
    def update_connection(
        self,
        # Name of connection
        connection_name: str,
        body: mdls.WriteDBConnection,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DBConnection:
        """Update Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            mdls.DBConnection,
            self.patch(
                path=f"/connections/{connection_name}",
                structure=mdls.DBConnection,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a connection.
    #
    # DELETE /connections/{connection_name} -> str
    def delete_connection(
        self,
        # Name of connection
        connection_name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            str,
            self.delete(
                path=f"/connections/{connection_name}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a connection override.
    #
    # DELETE /connections/{connection_name}/connection_override/{override_context} -> str
    def delete_connection_override(
        self,
        # Name of connection
        connection_name: str,
        # Context of connection override
        override_context: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Connection Override"""
        connection_name = self.encode_path_param(connection_name)
        override_context = self.encode_path_param(override_context)
        response = cast(
            str,
            self.delete(
                path=f"/connections/{connection_name}/connection_override/{override_context}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test an existing connection.
    #
    # Note that a connection's 'dialect' property has a 'connection_tests' property that lists the
    # specific types of tests that the connection supports.
    #
    # This API is rate limited.
    #
    # Unsupported tests in the request will be ignored.
    #
    # PUT /connections/{connection_name}/test -> Sequence[mdls.DBConnectionTestResult]
    def test_connection(
        self,
        # Name of connection
        connection_name: str,
        # Array of names of tests to run
        tests: Optional[mdls.DelimSequence[str]] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DBConnectionTestResult]:
        """Test Connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            Sequence[mdls.DBConnectionTestResult],
            self.put(
                path=f"/connections/{connection_name}/test",
                structure=Sequence[mdls.DBConnectionTestResult],
                query_params={"tests": tests},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test a connection configuration.
    #
    # Note that a connection's 'dialect' property has a 'connection_tests' property that lists the
    # specific types of tests that the connection supports.
    #
    # This API is rate limited.
    #
    # Unsupported tests in the request will be ignored.
    #
    # PUT /connections/test -> Sequence[mdls.DBConnectionTestResult]
    def test_connection_config(
        self,
        body: mdls.WriteDBConnection,
        # Array of names of tests to run
        tests: Optional[mdls.DelimSequence[str]] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DBConnectionTestResult]:
        """Test Connection Configuration"""
        response = cast(
            Sequence[mdls.DBConnectionTestResult],
            self.put(
                path="/connections/test",
                structure=Sequence[mdls.DBConnectionTestResult],
                query_params={"tests": tests},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all dialects.
    #
    # GET /dialect_info -> Sequence[mdls.DialectInfo]
    def all_dialect_infos(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DialectInfo]:
        """Get All Dialect Infos"""
        response = cast(
            Sequence[mdls.DialectInfo],
            self.get(
                path="/dialect_info",
                structure=Sequence[mdls.DialectInfo],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get all External OAuth Applications.
    #
    # This is an OAuth Application which Looker uses to access external systems.
    #
    # GET /external_oauth_applications -> Sequence[mdls.ExternalOauthApplication]
    def all_external_oauth_applications(
        self,
        # Application name
        name: Optional[str] = None,
        # Application Client ID
        client_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ExternalOauthApplication]:
        """Get All External OAuth Applications"""
        response = cast(
            Sequence[mdls.ExternalOauthApplication],
            self.get(
                path="/external_oauth_applications",
                structure=Sequence[mdls.ExternalOauthApplication],
                query_params={"name": name, "client_id": client_id},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create an OAuth Application using the specified configuration.
    #
    # This is an OAuth Application which Looker uses to access external systems.
    #
    # POST /external_oauth_applications -> mdls.ExternalOauthApplication
    def create_external_oauth_application(
        self,
        body: mdls.WriteExternalOauthApplication,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ExternalOauthApplication:
        """Create External OAuth Application"""
        response = cast(
            mdls.ExternalOauthApplication,
            self.post(
                path="/external_oauth_applications",
                structure=mdls.ExternalOauthApplication,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create OAuth User state.
    #
    # POST /external_oauth_applications/user_state -> mdls.CreateOAuthApplicationUserStateResponse
    def create_oauth_application_user_state(
        self,
        body: mdls.CreateOAuthApplicationUserStateRequest,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CreateOAuthApplicationUserStateResponse:
        """Create Create OAuth user state."""
        response = cast(
            mdls.CreateOAuthApplicationUserStateResponse,
            self.post(
                path="/external_oauth_applications/user_state",
                structure=mdls.CreateOAuthApplicationUserStateResponse,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all SSH Servers.
    #
    # GET /ssh_servers -> Sequence[mdls.SshServer]
    def all_ssh_servers(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.SshServer]:
        """Get All SSH Servers"""
        response = cast(
            Sequence[mdls.SshServer],
            self.get(
                path="/ssh_servers",
                structure=Sequence[mdls.SshServer],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create an SSH Server.
    #
    # POST /ssh_servers -> mdls.SshServer
    def create_ssh_server(
        self,
        body: mdls.WriteSshServer,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshServer:
        """Create SSH Server"""
        response = cast(
            mdls.SshServer,
            self.post(
                path="/ssh_servers",
                structure=mdls.SshServer,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about an SSH Server.
    #
    # GET /ssh_server/{ssh_server_id} -> mdls.SshServer
    def ssh_server(
        self,
        # Id of SSH Server
        ssh_server_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshServer:
        """Get SSH Server"""
        ssh_server_id = self.encode_path_param(ssh_server_id)
        response = cast(
            mdls.SshServer,
            self.get(
                path=f"/ssh_server/{ssh_server_id}",
                structure=mdls.SshServer,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update an SSH Server.
    #
    # PATCH /ssh_server/{ssh_server_id} -> mdls.SshServer
    def update_ssh_server(
        self,
        # Id of SSH Server
        ssh_server_id: str,
        body: mdls.WriteSshServer,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshServer:
        """Update SSH Server"""
        ssh_server_id = self.encode_path_param(ssh_server_id)
        response = cast(
            mdls.SshServer,
            self.patch(
                path=f"/ssh_server/{ssh_server_id}",
                structure=mdls.SshServer,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete an SSH Server.
    #
    # DELETE /ssh_server/{ssh_server_id} -> str
    def delete_ssh_server(
        self,
        # Id of SSH Server
        ssh_server_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete SSH Server"""
        ssh_server_id = self.encode_path_param(ssh_server_id)
        response = cast(
            str,
            self.delete(
                path=f"/ssh_server/{ssh_server_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test the SSH Server
    #
    # GET /ssh_server/{ssh_server_id}/test -> mdls.SshServer
    def test_ssh_server(
        self,
        # Id of SSH Server
        ssh_server_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshServer:
        """Test SSH Server"""
        ssh_server_id = self.encode_path_param(ssh_server_id)
        response = cast(
            mdls.SshServer,
            self.get(
                path=f"/ssh_server/{ssh_server_id}/test",
                structure=mdls.SshServer,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all SSH Tunnels.
    #
    # GET /ssh_tunnels -> Sequence[mdls.SshTunnel]
    def all_ssh_tunnels(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.SshTunnel]:
        """Get All SSH Tunnels"""
        response = cast(
            Sequence[mdls.SshTunnel],
            self.get(
                path="/ssh_tunnels",
                structure=Sequence[mdls.SshTunnel],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create an SSH Tunnel
    #
    # POST /ssh_tunnels -> mdls.SshTunnel
    def create_ssh_tunnel(
        self,
        body: mdls.WriteSshTunnel,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshTunnel:
        """Create SSH Tunnel"""
        response = cast(
            mdls.SshTunnel,
            self.post(
                path="/ssh_tunnels",
                structure=mdls.SshTunnel,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about an SSH Tunnel.
    #
    # GET /ssh_tunnel/{ssh_tunnel_id} -> mdls.SshTunnel
    def ssh_tunnel(
        self,
        # Id of SSH Tunnel
        ssh_tunnel_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshTunnel:
        """Get SSH Tunnel"""
        ssh_tunnel_id = self.encode_path_param(ssh_tunnel_id)
        response = cast(
            mdls.SshTunnel,
            self.get(
                path=f"/ssh_tunnel/{ssh_tunnel_id}",
                structure=mdls.SshTunnel,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update an SSH Tunnel
    #
    # PATCH /ssh_tunnel/{ssh_tunnel_id} -> mdls.SshTunnel
    def update_ssh_tunnel(
        self,
        # Id of SSH Tunnel
        ssh_tunnel_id: str,
        body: mdls.WriteSshTunnel,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshTunnel:
        """Update SSH Tunnel"""
        ssh_tunnel_id = self.encode_path_param(ssh_tunnel_id)
        response = cast(
            mdls.SshTunnel,
            self.patch(
                path=f"/ssh_tunnel/{ssh_tunnel_id}",
                structure=mdls.SshTunnel,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete an SSH Tunnel
    #
    # DELETE /ssh_tunnel/{ssh_tunnel_id} -> str
    def delete_ssh_tunnel(
        self,
        # Id of SSH Tunnel
        ssh_tunnel_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete SSH Tunnel"""
        ssh_tunnel_id = self.encode_path_param(ssh_tunnel_id)
        response = cast(
            str,
            self.delete(
                path=f"/ssh_tunnel/{ssh_tunnel_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Test the SSH Tunnel
    #
    # GET /ssh_tunnel/{ssh_tunnel_id}/test -> mdls.SshTunnel
    def test_ssh_tunnel(
        self,
        # Id of SSH Tunnel
        ssh_tunnel_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshTunnel:
        """Test SSH Tunnel"""
        ssh_tunnel_id = self.encode_path_param(ssh_tunnel_id)
        response = cast(
            mdls.SshTunnel,
            self.get(
                path=f"/ssh_tunnel/{ssh_tunnel_id}/test",
                structure=mdls.SshTunnel,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the SSH public key
    #
    # Get the public key created for this instance to identify itself to a remote SSH server.
    #
    # GET /ssh_public_key -> mdls.SshPublicKey
    def ssh_public_key(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SshPublicKey:
        """Get SSH Public Key"""
        response = cast(
            mdls.SshPublicKey,
            self.get(
                path="/ssh_public_key",
                structure=mdls.SshPublicKey,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Content: Manage Content

    # ### Search Favorite Content
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /content_favorite/search -> Sequence[mdls.ContentFavorite]
    def search_content_favorites(
        self,
        # Match content favorite id(s)
        id: Optional[str] = None,
        # Match user id(s).To create a list of multiple ids, use commas as separators
        user_id: Optional[str] = None,
        # Match content metadata id(s).To create a list of multiple ids, use commas as separators
        content_metadata_id: Optional[str] = None,
        # Match dashboard id(s).To create a list of multiple ids, use commas as separators
        dashboard_id: Optional[str] = None,
        # Match look id(s).To create a list of multiple ids, use commas as separators
        look_id: Optional[str] = None,
        # Match board id(s).To create a list of multiple ids, use commas as separators
        board_id: Optional[str] = None,
        # Number of results to return. (used with offset)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ContentFavorite]:
        """Search Favorite Contents"""
        response = cast(
            Sequence[mdls.ContentFavorite],
            self.get(
                path="/content_favorite/search",
                structure=Sequence[mdls.ContentFavorite],
                query_params={
                    "id": id,
                    "user_id": user_id,
                    "content_metadata_id": content_metadata_id,
                    "dashboard_id": dashboard_id,
                    "look_id": look_id,
                    "board_id": board_id,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "fields": fields,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get favorite content by its id
    #
    # GET /content_favorite/{content_favorite_id} -> mdls.ContentFavorite
    def content_favorite(
        self,
        # Id of favorite content
        content_favorite_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentFavorite:
        """Get Favorite Content"""
        content_favorite_id = self.encode_path_param(content_favorite_id)
        response = cast(
            mdls.ContentFavorite,
            self.get(
                path=f"/content_favorite/{content_favorite_id}",
                structure=mdls.ContentFavorite,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete favorite content
    #
    # DELETE /content_favorite/{content_favorite_id} -> str
    def delete_content_favorite(
        self,
        # Id of favorite content
        content_favorite_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Favorite Content"""
        content_favorite_id = self.encode_path_param(content_favorite_id)
        response = cast(
            str,
            self.delete(
                path=f"/content_favorite/{content_favorite_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create favorite content
    #
    # POST /content_favorite -> mdls.ContentFavorite
    def create_content_favorite(
        self,
        body: mdls.WriteContentFavorite,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentFavorite:
        """Create Favorite Content"""
        response = cast(
            mdls.ContentFavorite,
            self.post(
                path="/content_favorite",
                structure=mdls.ContentFavorite,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all content metadata in a space.
    #
    # GET /content_metadata -> Sequence[mdls.ContentMeta]
    def all_content_metadatas(
        self,
        # Parent space of content.
        parent_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ContentMeta]:
        """Get All Content Metadatas"""
        response = cast(
            Sequence[mdls.ContentMeta],
            self.get(
                path="/content_metadata",
                structure=Sequence[mdls.ContentMeta],
                query_params={"parent_id": parent_id, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about an individual content metadata record.
    #
    # GET /content_metadata/{content_metadata_id} -> mdls.ContentMeta
    def content_metadata(
        self,
        # Id of content metadata
        content_metadata_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentMeta:
        """Get Content Metadata"""
        content_metadata_id = self.encode_path_param(content_metadata_id)
        response = cast(
            mdls.ContentMeta,
            self.get(
                path=f"/content_metadata/{content_metadata_id}",
                structure=mdls.ContentMeta,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Move a piece of content.
    #
    # PATCH /content_metadata/{content_metadata_id} -> mdls.ContentMeta
    def update_content_metadata(
        self,
        # Id of content metadata
        content_metadata_id: str,
        body: mdls.WriteContentMeta,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentMeta:
        """Update Content Metadata"""
        content_metadata_id = self.encode_path_param(content_metadata_id)
        response = cast(
            mdls.ContentMeta,
            self.patch(
                path=f"/content_metadata/{content_metadata_id}",
                structure=mdls.ContentMeta,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### All content metadata access records for a content metadata item.
    #
    # GET /content_metadata_access -> Sequence[mdls.ContentMetaGroupUser]
    def all_content_metadata_accesses(
        self,
        # Id of content metadata
        content_metadata_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ContentMetaGroupUser]:
        """Get All Content Metadata Accesses"""
        response = cast(
            Sequence[mdls.ContentMetaGroupUser],
            self.get(
                path="/content_metadata_access",
                structure=Sequence[mdls.ContentMetaGroupUser],
                query_params={
                    "content_metadata_id": content_metadata_id,
                    "fields": fields,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create content metadata access.
    #
    # POST /content_metadata_access -> mdls.ContentMetaGroupUser
    def create_content_metadata_access(
        self,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: mdls.ContentMetaGroupUser,
        # Optionally sends notification email when granting access to a board.
        send_boards_notification_email: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentMetaGroupUser:
        """Create Content Metadata Access"""
        response = cast(
            mdls.ContentMetaGroupUser,
            self.post(
                path="/content_metadata_access",
                structure=mdls.ContentMetaGroupUser,
                query_params={
                    "send_boards_notification_email": send_boards_notification_email
                },
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update type of access for content metadata.
    #
    # PUT /content_metadata_access/{content_metadata_access_id} -> mdls.ContentMetaGroupUser
    def update_content_metadata_access(
        self,
        # Id of content metadata access
        content_metadata_access_id: str,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: mdls.ContentMetaGroupUser,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentMetaGroupUser:
        """Update Content Metadata Access"""
        content_metadata_access_id = self.encode_path_param(content_metadata_access_id)
        response = cast(
            mdls.ContentMetaGroupUser,
            self.put(
                path=f"/content_metadata_access/{content_metadata_access_id}",
                structure=mdls.ContentMetaGroupUser,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Remove content metadata access.
    #
    # DELETE /content_metadata_access/{content_metadata_access_id} -> str
    def delete_content_metadata_access(
        self,
        # Id of content metadata access
        content_metadata_access_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Content Metadata Access"""
        content_metadata_access_id = self.encode_path_param(content_metadata_access_id)
        response = cast(
            str,
            self.delete(
                path=f"/content_metadata_access/{content_metadata_access_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get an image representing the contents of a dashboard or look.
    #
    # The returned thumbnail is an abstract representation of the contents of a dashbord or look and does not
    # reflect the actual data displayed in the respective visualizations.
    #
    # GET /content_thumbnail/{type}/{resource_id} -> Union[str, bytes]
    def content_thumbnail(
        self,
        # Either dashboard or look
        type: str,
        # ID of the dashboard or look to render
        resource_id: str,
        # Whether or not to refresh the rendered image with the latest content
        reload: Optional[str] = None,
        # A value of png produces a thumbnail in PNG format instead of SVG (default)
        format: Optional[str] = None,
        # The width of the image if format is supplied
        width: Optional[int] = None,
        # The height of the image if format is supplied
        height: Optional[int] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Union[str, bytes]:
        """Get Content Thumbnail"""
        type = self.encode_path_param(type)
        resource_id = self.encode_path_param(resource_id)
        response = cast(
            Union[str, bytes],
            self.get(
                path=f"/content_thumbnail/{type}/{resource_id}",
                structure=Union[str, bytes],  # type: ignore
                query_params={
                    "reload": reload,
                    "format": format,
                    "width": width,
                    "height": height,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Validate All Content
    #
    # Performs validation of all looks and dashboards
    # Returns a list of errors found as well as metadata about the content validation run.
    #
    # GET /content_validation -> mdls.ContentValidation
    def content_validation(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ContentValidation:
        """Validate Content"""
        response = cast(
            mdls.ContentValidation,
            self.get(
                path="/content_validation",
                structure=mdls.ContentValidation,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search Content Views
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /content_view/search -> Sequence[mdls.ContentView]
    def search_content_views(
        self,
        # Match view count
        view_count: Optional[str] = None,
        # Match Group Id
        group_id: Optional[str] = None,
        # Match look_id
        look_id: Optional[str] = None,
        # Match dashboard_id
        dashboard_id: Optional[str] = None,
        # Match content metadata id
        content_metadata_id: Optional[str] = None,
        # Match start of week date (format is "YYYY-MM-DD")
        start_of_week_date: Optional[str] = None,
        # True if only all time view records should be returned
        all_time: Optional[bool] = None,
        # Match user id
        user_id: Optional[str] = None,
        # Requested fields
        fields: Optional[str] = None,
        # Number of results to return. Use with `offset` to manage pagination of results
        limit: Optional[int] = None,
        # Number of results to skip before returning data
        offset: Optional[int] = None,
        # Fields to sort by
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ContentView]:
        """Search Content Views"""
        response = cast(
            Sequence[mdls.ContentView],
            self.get(
                path="/content_view/search",
                structure=Sequence[mdls.ContentView],
                query_params={
                    "view_count": view_count,
                    "group_id": group_id,
                    "look_id": look_id,
                    "dashboard_id": dashboard_id,
                    "content_metadata_id": content_metadata_id,
                    "start_of_week_date": start_of_week_date,
                    "all_time": all_time,
                    "user_id": user_id,
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a vector image representing the contents of a dashboard or look.
    #
    # # DEPRECATED:  Use [content_thumbnail()](#!/Content/content_thumbnail)
    #
    # The returned thumbnail is an abstract representation of the contents of a dashbord or look and does not
    # reflect the actual data displayed in the respective visualizations.
    #
    # GET /vector_thumbnail/{type}/{resource_id} -> str
    def vector_thumbnail(
        self,
        # Either dashboard or look
        type: str,
        # ID of the dashboard or look to render
        resource_id: str,
        # Whether or not to refresh the rendered image with the latest content
        reload: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Get Vector Thumbnail"""
        type = self.encode_path_param(type)
        resource_id = self.encode_path_param(resource_id)
        response = cast(
            str,
            self.get(
                path=f"/vector_thumbnail/{type}/{resource_id}",
                structure=str,
                query_params={"reload": reload},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Dashboard: Manage Dashboards

    # ### Get information about all active dashboards.
    #
    # Returns an array of **abbreviated dashboard objects**. Dashboards marked as deleted are excluded from this list.
    #
    # Get the **full details** of a specific dashboard by id with [dashboard()](#!/Dashboard/dashboard)
    #
    # Find **deleted dashboards** with [search_dashboards()](#!/Dashboard/search_dashboards)
    #
    # GET /dashboards -> Sequence[mdls.DashboardBase]
    def all_dashboards(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DashboardBase]:
        """Get All Dashboards"""
        response = cast(
            Sequence[mdls.DashboardBase],
            self.get(
                path="/dashboards",
                structure=Sequence[mdls.DashboardBase],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new dashboard
    #
    # Creates a new dashboard object and returns the details of the newly created dashboard.
    #
    # `Title` and `space_id` are required fields.
    # `Space_id` must contain the id of an existing space.
    # A dashboard's `title` must be unique within the space in which it resides.
    #
    # If you receive a 422 error response when creating a dashboard, be sure to look at the
    # response body for information about exactly which fields are missing or contain invalid data.
    #
    # You can **update** an existing dashboard with [update_dashboard()](#!/Dashboard/update_dashboard)
    #
    # You can **permanently delete** an existing dashboard with [delete_dashboard()](#!/Dashboard/delete_dashboard)
    #
    # POST /dashboards -> mdls.Dashboard
    def create_dashboard(
        self,
        body: mdls.WriteDashboard,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Dashboard:
        """Create Dashboard"""
        response = cast(
            mdls.Dashboard,
            self.post(
                path="/dashboards",
                structure=mdls.Dashboard,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search Dashboards
    #
    # Returns an **array of dashboard objects** that match the specified search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # The parameters `limit`, and `offset` are recommended for fetching results in page-size chunks.
    #
    # Get a **single dashboard** by id with [dashboard()](#!/Dashboard/dashboard)
    #
    # GET /dashboards/search -> Sequence[mdls.Dashboard]
    def search_dashboards(
        self,
        # Match dashboard id.
        id: Optional[str] = None,
        # Match dashboard slug.
        slug: Optional[str] = None,
        # Match Dashboard title.
        title: Optional[str] = None,
        # Match Dashboard description.
        description: Optional[str] = None,
        # Filter on a content favorite id.
        content_favorite_id: Optional[str] = None,
        # Filter on a particular space.
        folder_id: Optional[str] = None,
        # Filter on dashboards deleted status.
        deleted: Optional[str] = None,
        # Filter on dashboards created by a particular user.
        user_id: Optional[str] = None,
        # Filter on a particular value of view_count
        view_count: Optional[str] = None,
        # Filter on a content favorite id.
        content_metadata_id: Optional[str] = None,
        # Exclude items that exist only in personal spaces other than the users
        curate: Optional[bool] = None,
        # Select dashboards based on when they were last viewed
        last_viewed_at: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # One or more fields to sort by. Sortable fields: [:title, :user_id, :id, :created_at, :space_id, :folder_id, :description, :view_count, :favorite_count, :slug, :content_favorite_id, :content_metadata_id, :deleted, :deleted_at, :last_viewed_at, :last_accessed_at]
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Dashboard]:
        """Search Dashboards"""
        response = cast(
            Sequence[mdls.Dashboard],
            self.get(
                path="/dashboards/search",
                structure=Sequence[mdls.Dashboard],
                query_params={
                    "id": id,
                    "slug": slug,
                    "title": title,
                    "description": description,
                    "content_favorite_id": content_favorite_id,
                    "folder_id": folder_id,
                    "deleted": deleted,
                    "user_id": user_id,
                    "view_count": view_count,
                    "content_metadata_id": content_metadata_id,
                    "curate": curate,
                    "last_viewed_at": last_viewed_at,
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Import a LookML dashboard to a space as a UDD
    # Creates a UDD (a dashboard which exists in the Looker database rather than as a LookML file) from the LookML dashboard
    # and places it in the space specified. The created UDD will have a lookml_link_id which links to the original LookML dashboard.
    #
    # To give the imported dashboard specify a (e.g. title: "my title") in the body of your request, otherwise the imported
    # dashboard will have the same title as the original LookML dashboard.
    #
    # For this operation to succeed the user must have permission to see the LookML dashboard in question, and have permission to
    # create content in the space the dashboard is being imported to.
    #
    # **Sync** a linked UDD with [sync_lookml_dashboard()](#!/Dashboard/sync_lookml_dashboard)
    # **Unlink** a linked UDD by setting lookml_link_id to null with [update_dashboard()](#!/Dashboard/update_dashboard)
    #
    # POST /dashboards/{lookml_dashboard_id}/import/{space_id} -> mdls.Dashboard
    def import_lookml_dashboard(
        self,
        # Id of LookML dashboard
        lookml_dashboard_id: str,
        # Id of space to import the dashboard to
        space_id: str,
        body: Optional[mdls.WriteDashboard] = None,
        # If true, and this dashboard is localized, export it with the raw keys, not localized.
        raw_locale: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Dashboard:
        """Import LookML Dashboard"""
        lookml_dashboard_id = self.encode_path_param(lookml_dashboard_id)
        space_id = self.encode_path_param(space_id)
        response = cast(
            mdls.Dashboard,
            self.post(
                path=f"/dashboards/{lookml_dashboard_id}/import/{space_id}",
                structure=mdls.Dashboard,
                query_params={"raw_locale": raw_locale},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update all linked dashboards to match the specified LookML dashboard.
    #
    # Any UDD (a dashboard which exists in the Looker database rather than as a LookML file) which has a `lookml_link_id`
    # property value referring to a LookML dashboard's id (model::dashboardname) will be updated so that it matches the current state of the LookML dashboard.
    #
    # For this operation to succeed the user must have permission to view the LookML dashboard, and only linked dashboards
    # that the user has permission to update will be synced.
    #
    # To **link** or **unlink** a UDD set the `lookml_link_id` property with [update_dashboard()](#!/Dashboard/update_dashboard)
    #
    # PATCH /dashboards/{lookml_dashboard_id}/sync -> Sequence[int]
    def sync_lookml_dashboard(
        self,
        # Id of LookML dashboard, in the form 'model::dashboardname'
        lookml_dashboard_id: str,
        body: mdls.WriteDashboard,
        # If true, and this dashboard is localized, export it with the raw keys, not localized.
        raw_locale: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[int]:
        """Sync LookML Dashboard"""
        lookml_dashboard_id = self.encode_path_param(lookml_dashboard_id)
        response = cast(
            Sequence[int],
            self.patch(
                path=f"/dashboards/{lookml_dashboard_id}/sync",
                structure=Sequence[int],
                query_params={"raw_locale": raw_locale},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a dashboard
    #
    # Returns the full details of the identified dashboard object
    #
    # Get a **summary list** of all active dashboards with [all_dashboards()](#!/Dashboard/all_dashboards)
    #
    # You can **Search** for dashboards with [search_dashboards()](#!/Dashboard/search_dashboards)
    #
    # GET /dashboards/{dashboard_id} -> mdls.Dashboard
    def dashboard(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Dashboard:
        """Get Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            mdls.Dashboard,
            self.get(
                path=f"/dashboards/{dashboard_id}",
                structure=mdls.Dashboard,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a dashboard
    #
    # You can use this function to change the string and integer properties of
    # a dashboard. Nested objects such as filters, dashboard elements, or dashboard layout components
    # cannot be modified by this function - use the update functions for the respective
    # nested object types (like [update_dashboard_filter()](#!/3.1/Dashboard/update_dashboard_filter) to change a filter)
    # to modify nested objects referenced by a dashboard.
    #
    # If you receive a 422 error response when updating a dashboard, be sure to look at the
    # response body for information about exactly which fields are missing or contain invalid data.
    #
    # PATCH /dashboards/{dashboard_id} -> mdls.Dashboard
    def update_dashboard(
        self,
        # Id of dashboard
        dashboard_id: str,
        body: mdls.WriteDashboard,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Dashboard:
        """Update Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            mdls.Dashboard,
            self.patch(
                path=f"/dashboards/{dashboard_id}",
                structure=mdls.Dashboard,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the dashboard with the specified id
    #
    # Permanently **deletes** a dashboard. (The dashboard cannot be recovered after this operation.)
    #
    # "Soft" delete or hide a dashboard by setting its `deleted` status to `True` with [update_dashboard()](#!/Dashboard/update_dashboard).
    #
    # Note: When a dashboard is deleted in the UI, it is soft deleted. Use this API call to permanently remove it, if desired.
    #
    # DELETE /dashboards/{dashboard_id} -> str
    def delete_dashboard(
        self,
        # Id of dashboard
        dashboard_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            str,
            self.delete(
                path=f"/dashboards/{dashboard_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Aggregate Table LookML for Each Query on a Dahboard
    #
    # Returns a JSON object that contains the dashboard id and Aggregate Table lookml
    #
    # GET /dashboards/aggregate_table_lookml/{dashboard_id} -> mdls.DashboardAggregateTableLookml
    def dashboard_aggregate_table_lookml(
        self,
        # Id of dashboard
        dashboard_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardAggregateTableLookml:
        """Get Aggregate Table LookML for a dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            mdls.DashboardAggregateTableLookml,
            self.get(
                path=f"/dashboards/aggregate_table_lookml/{dashboard_id}",
                structure=mdls.DashboardAggregateTableLookml,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get lookml of a UDD
    #
    # Returns a JSON object that contains the dashboard id and the full lookml
    #
    # GET /dashboards/lookml/{dashboard_id} -> mdls.DashboardLookml
    def dashboard_lookml(
        self,
        # Id of dashboard
        dashboard_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLookml:
        """Get lookml of a UDD"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            mdls.DashboardLookml,
            self.get(
                path=f"/dashboards/lookml/{dashboard_id}",
                structure=mdls.DashboardLookml,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Move an existing dashboard
    #
    # Moves a dashboard to a specified folder, and returns the moved dashboard.
    #
    # `dashboard_id` and `folder_id` are required.
    # `dashboard_id` and `folder_id` must already exist, and `folder_id` must be different from the current `folder_id` of the dashboard.
    #
    # PATCH /dashboards/{dashboard_id}/move -> mdls.Dashboard
    def move_dashboard(
        self,
        # Dashboard id to move.
        dashboard_id: str,
        # Folder id to move to.
        folder_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Dashboard:
        """Move Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            mdls.Dashboard,
            self.patch(
                path=f"/dashboards/{dashboard_id}/move",
                structure=mdls.Dashboard,
                query_params={"folder_id": folder_id},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Creates a dashboard object based on LookML Dashboard YAML, and returns the details of the newly created dashboard.
    #
    # If a dashboard exists with the YAML-defined "preferred_slug", the new dashboard will overwrite it. Otherwise, a new
    # dashboard will be created. Note that when a dashboard is overwritten, alerts will not be maintained.
    #
    # If a folder_id is specified: new dashboards will be placed in that folder, and overwritten dashboards will be moved to it
    # If the folder_id isn't specified: new dashboards will be placed in the caller's personal folder, and overwritten dashboards
    # will remain where they were
    #
    # LookML must contain valid LookML YAML code. It's recommended to use the LookML format returned
    # from [dashboard_lookml()](#!/Dashboard/dashboard_lookml) as the input LookML (newlines replaced with
    # ).
    #
    # Note that the created dashboard is not linked to any LookML Dashboard,
    # i.e. [sync_lookml_dashboard()](#!/Dashboard/sync_lookml_dashboard) will not update dashboards created by this method.
    #
    # POST /dashboards/lookml -> mdls.DashboardLookml
    def import_dashboard_from_lookml(
        self,
        body: mdls.WriteDashboardLookml,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLookml:
        """Import Dashboard from LookML"""
        response = cast(
            mdls.DashboardLookml,
            self.post(
                path="/dashboards/lookml",
                structure=mdls.DashboardLookml,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # # DEPRECATED:  Use [import_dashboard_from_lookml()](#!/Dashboard/import_dashboard_from_lookml)
    #
    # POST /dashboards/from_lookml -> mdls.DashboardLookml
    def create_dashboard_from_lookml(
        self,
        body: mdls.WriteDashboardLookml,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLookml:
        """Create Dashboard from LookML"""
        response = cast(
            mdls.DashboardLookml,
            self.post(
                path="/dashboards/from_lookml",
                structure=mdls.DashboardLookml,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Copy an existing dashboard
    #
    # Creates a copy of an existing dashboard, in a specified folder, and returns the copied dashboard.
    #
    # `dashboard_id` is required, `dashboard_id` and `folder_id` must already exist if specified.
    # `folder_id` will default to the existing folder.
    #
    # If a dashboard with the same title already exists in the target folder, the copy will have '(copy)'
    #   or '(copy <# of copies>)' appended.
    #
    # POST /dashboards/{dashboard_id}/copy -> mdls.Dashboard
    def copy_dashboard(
        self,
        # Dashboard id to copy.
        dashboard_id: str,
        # Folder id to copy to.
        folder_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Dashboard:
        """Copy Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            mdls.Dashboard,
            self.post(
                path=f"/dashboards/{dashboard_id}/copy",
                structure=mdls.Dashboard,
                query_params={"folder_id": folder_id},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search Dashboard Elements
    #
    # Returns an **array of DashboardElement objects** that match the specified search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /dashboard_elements/search -> Sequence[mdls.DashboardElement]
    def search_dashboard_elements(
        self,
        # Select elements that refer to a given dashboard id
        dashboard_id: Optional[str] = None,
        # Select elements that refer to a given look id
        look_id: Optional[str] = None,
        # Match the title of element
        title: Optional[str] = None,
        # Select soft-deleted dashboard elements
        deleted: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Fields to sort by. Sortable fields: [:look_id, :dashboard_id, :deleted, :title]
        sorts: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DashboardElement]:
        """Search Dashboard Elements"""
        response = cast(
            Sequence[mdls.DashboardElement],
            self.get(
                path="/dashboard_elements/search",
                structure=Sequence[mdls.DashboardElement],
                query_params={
                    "dashboard_id": dashboard_id,
                    "look_id": look_id,
                    "title": title,
                    "deleted": deleted,
                    "fields": fields,
                    "filter_or": filter_or,
                    "sorts": sorts,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the dashboard element with a specific id.
    #
    # GET /dashboard_elements/{dashboard_element_id} -> mdls.DashboardElement
    def dashboard_element(
        self,
        # Id of dashboard element
        dashboard_element_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardElement:
        """Get DashboardElement"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        response = cast(
            mdls.DashboardElement,
            self.get(
                path=f"/dashboard_elements/{dashboard_element_id}",
                structure=mdls.DashboardElement,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the dashboard element with a specific id.
    #
    # PATCH /dashboard_elements/{dashboard_element_id} -> mdls.DashboardElement
    def update_dashboard_element(
        self,
        # Id of dashboard element
        dashboard_element_id: str,
        body: mdls.WriteDashboardElement,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardElement:
        """Update DashboardElement"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        response = cast(
            mdls.DashboardElement,
            self.patch(
                path=f"/dashboard_elements/{dashboard_element_id}",
                structure=mdls.DashboardElement,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a dashboard element with a specific id.
    #
    # DELETE /dashboard_elements/{dashboard_element_id} -> str
    def delete_dashboard_element(
        self,
        # Id of dashboard element
        dashboard_element_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete DashboardElement"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        response = cast(
            str,
            self.delete(
                path=f"/dashboard_elements/{dashboard_element_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the dashboard elements on a dashboard with a specific id.
    #
    # GET /dashboards/{dashboard_id}/dashboard_elements -> Sequence[mdls.DashboardElement]
    def dashboard_dashboard_elements(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DashboardElement]:
        """Get All DashboardElements"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            Sequence[mdls.DashboardElement],
            self.get(
                path=f"/dashboards/{dashboard_id}/dashboard_elements",
                structure=Sequence[mdls.DashboardElement],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a dashboard element on the dashboard with a specific id.
    #
    # POST /dashboard_elements -> mdls.DashboardElement
    def create_dashboard_element(
        self,
        body: mdls.WriteDashboardElement,
        # Requested fields.
        fields: Optional[str] = None,
        # Apply relevant filters on dashboard to this tile
        apply_filters: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardElement:
        """Create DashboardElement"""
        response = cast(
            mdls.DashboardElement,
            self.post(
                path="/dashboard_elements",
                structure=mdls.DashboardElement,
                query_params={"fields": fields, "apply_filters": apply_filters},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the dashboard filters with a specific id.
    #
    # GET /dashboard_filters/{dashboard_filter_id} -> mdls.DashboardFilter
    def dashboard_filter(
        self,
        # Id of dashboard filters
        dashboard_filter_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardFilter:
        """Get Dashboard Filter"""
        dashboard_filter_id = self.encode_path_param(dashboard_filter_id)
        response = cast(
            mdls.DashboardFilter,
            self.get(
                path=f"/dashboard_filters/{dashboard_filter_id}",
                structure=mdls.DashboardFilter,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the dashboard filter with a specific id.
    #
    # PATCH /dashboard_filters/{dashboard_filter_id} -> mdls.DashboardFilter
    def update_dashboard_filter(
        self,
        # Id of dashboard filter
        dashboard_filter_id: str,
        body: mdls.WriteDashboardFilter,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardFilter:
        """Update Dashboard Filter"""
        dashboard_filter_id = self.encode_path_param(dashboard_filter_id)
        response = cast(
            mdls.DashboardFilter,
            self.patch(
                path=f"/dashboard_filters/{dashboard_filter_id}",
                structure=mdls.DashboardFilter,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a dashboard filter with a specific id.
    #
    # DELETE /dashboard_filters/{dashboard_filter_id} -> str
    def delete_dashboard_filter(
        self,
        # Id of dashboard filter
        dashboard_filter_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Dashboard Filter"""
        dashboard_filter_id = self.encode_path_param(dashboard_filter_id)
        response = cast(
            str,
            self.delete(
                path=f"/dashboard_filters/{dashboard_filter_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the dashboard filters on a dashboard with a specific id.
    #
    # GET /dashboards/{dashboard_id}/dashboard_filters -> Sequence[mdls.DashboardFilter]
    def dashboard_dashboard_filters(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DashboardFilter]:
        """Get All Dashboard Filters"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            Sequence[mdls.DashboardFilter],
            self.get(
                path=f"/dashboards/{dashboard_id}/dashboard_filters",
                structure=Sequence[mdls.DashboardFilter],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a dashboard filter on the dashboard with a specific id.
    #
    # POST /dashboard_filters -> mdls.DashboardFilter
    def create_dashboard_filter(
        self,
        body: mdls.WriteCreateDashboardFilter,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardFilter:
        """Create Dashboard Filter"""
        response = cast(
            mdls.DashboardFilter,
            self.post(
                path="/dashboard_filters",
                structure=mdls.DashboardFilter,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the dashboard elements with a specific id.
    #
    # GET /dashboard_layout_components/{dashboard_layout_component_id} -> mdls.DashboardLayoutComponent
    def dashboard_layout_component(
        self,
        # Id of dashboard layout component
        dashboard_layout_component_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLayoutComponent:
        """Get DashboardLayoutComponent"""
        dashboard_layout_component_id = self.encode_path_param(
            dashboard_layout_component_id
        )
        response = cast(
            mdls.DashboardLayoutComponent,
            self.get(
                path=f"/dashboard_layout_components/{dashboard_layout_component_id}",
                structure=mdls.DashboardLayoutComponent,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the dashboard element with a specific id.
    #
    # PATCH /dashboard_layout_components/{dashboard_layout_component_id} -> mdls.DashboardLayoutComponent
    def update_dashboard_layout_component(
        self,
        # Id of dashboard layout component
        dashboard_layout_component_id: str,
        body: mdls.WriteDashboardLayoutComponent,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLayoutComponent:
        """Update DashboardLayoutComponent"""
        dashboard_layout_component_id = self.encode_path_param(
            dashboard_layout_component_id
        )
        response = cast(
            mdls.DashboardLayoutComponent,
            self.patch(
                path=f"/dashboard_layout_components/{dashboard_layout_component_id}",
                structure=mdls.DashboardLayoutComponent,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the dashboard layout components for a dashboard layout with a specific id.
    #
    # GET /dashboard_layouts/{dashboard_layout_id}/dashboard_layout_components -> Sequence[mdls.DashboardLayoutComponent]
    def dashboard_layout_dashboard_layout_components(
        self,
        # Id of dashboard layout component
        dashboard_layout_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DashboardLayoutComponent]:
        """Get All DashboardLayoutComponents"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = cast(
            Sequence[mdls.DashboardLayoutComponent],
            self.get(
                path=f"/dashboard_layouts/{dashboard_layout_id}/dashboard_layout_components",
                structure=Sequence[mdls.DashboardLayoutComponent],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the dashboard layouts with a specific id.
    #
    # GET /dashboard_layouts/{dashboard_layout_id} -> mdls.DashboardLayout
    def dashboard_layout(
        self,
        # Id of dashboard layouts
        dashboard_layout_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLayout:
        """Get DashboardLayout"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = cast(
            mdls.DashboardLayout,
            self.get(
                path=f"/dashboard_layouts/{dashboard_layout_id}",
                structure=mdls.DashboardLayout,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the dashboard layout with a specific id.
    #
    # PATCH /dashboard_layouts/{dashboard_layout_id} -> mdls.DashboardLayout
    def update_dashboard_layout(
        self,
        # Id of dashboard layout
        dashboard_layout_id: str,
        body: mdls.WriteDashboardLayout,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLayout:
        """Update DashboardLayout"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = cast(
            mdls.DashboardLayout,
            self.patch(
                path=f"/dashboard_layouts/{dashboard_layout_id}",
                structure=mdls.DashboardLayout,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a dashboard layout with a specific id.
    #
    # DELETE /dashboard_layouts/{dashboard_layout_id} -> str
    def delete_dashboard_layout(
        self,
        # Id of dashboard layout
        dashboard_layout_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete DashboardLayout"""
        dashboard_layout_id = self.encode_path_param(dashboard_layout_id)
        response = cast(
            str,
            self.delete(
                path=f"/dashboard_layouts/{dashboard_layout_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the dashboard elements on a dashboard with a specific id.
    #
    # GET /dashboards/{dashboard_id}/dashboard_layouts -> Sequence[mdls.DashboardLayout]
    def dashboard_dashboard_layouts(
        self,
        # Id of dashboard
        dashboard_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.DashboardLayout]:
        """Get All DashboardLayouts"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            Sequence[mdls.DashboardLayout],
            self.get(
                path=f"/dashboards/{dashboard_id}/dashboard_layouts",
                structure=Sequence[mdls.DashboardLayout],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a dashboard layout on the dashboard with a specific id.
    #
    # POST /dashboard_layouts -> mdls.DashboardLayout
    def create_dashboard_layout(
        self,
        body: mdls.WriteDashboardLayout,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DashboardLayout:
        """Create DashboardLayout"""
        response = cast(
            mdls.DashboardLayout,
            self.post(
                path="/dashboard_layouts",
                structure=mdls.DashboardLayout,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region DataAction: Run Data Actions

    # Perform a data action. The data action object can be obtained from query results, and used to perform an arbitrary action.
    #
    # POST /data_actions -> mdls.DataActionResponse
    def perform_data_action(
        self,
        body: mdls.DataActionRequest,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DataActionResponse:
        """Send a Data Action"""
        response = cast(
            mdls.DataActionResponse,
            self.post(
                path="/data_actions",
                structure=mdls.DataActionResponse,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # For some data actions, the remote server may supply a form requesting further user input. This endpoint takes a data action, asks the remote server to generate a form for it, and returns that form to you for presentation to the user.
    #
    # POST /data_actions/form -> mdls.DataActionForm
    def fetch_remote_data_action_form(
        self,
        body: MutableMapping[str, Any],
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DataActionForm:
        """Fetch Remote Data Action Form"""
        response = cast(
            mdls.DataActionForm,
            self.post(
                path="/data_actions/form",
                structure=mdls.DataActionForm,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Datagroup: Manage Datagroups

    # ### Get information about all datagroups.
    #
    # GET /datagroups -> Sequence[mdls.Datagroup]
    def all_datagroups(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Datagroup]:
        """Get All Datagroups"""
        response = cast(
            Sequence[mdls.Datagroup],
            self.get(
                path="/datagroups",
                structure=Sequence[mdls.Datagroup],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a datagroup.
    #
    # GET /datagroups/{datagroup_id} -> mdls.Datagroup
    def datagroup(
        self,
        # ID of datagroup.
        datagroup_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Datagroup:
        """Get Datagroup"""
        datagroup_id = self.encode_path_param(datagroup_id)
        response = cast(
            mdls.Datagroup,
            self.get(
                path=f"/datagroups/{datagroup_id}",
                structure=mdls.Datagroup,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a datagroup using the specified params.
    #
    # PATCH /datagroups/{datagroup_id} -> mdls.Datagroup
    def update_datagroup(
        self,
        # ID of datagroup.
        datagroup_id: str,
        body: mdls.WriteDatagroup,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Datagroup:
        """Update Datagroup"""
        datagroup_id = self.encode_path_param(datagroup_id)
        response = cast(
            mdls.Datagroup,
            self.patch(
                path=f"/datagroups/{datagroup_id}",
                structure=mdls.Datagroup,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region DerivedTable: View Derived Table graphs

    # ### Discover information about derived tables
    #
    # GET /derived_table/graph/model/{model} -> mdls.DependencyGraph
    def graph_derived_tables_for_model(
        self,
        # The name of the Lookml model.
        model: str,
        # The format of the graph. Valid values are [dot]. Default is `dot`
        format: Optional[str] = None,
        # Color denoting the build status of the graph. Grey = not built, green = built, yellow = building, red = error.
        color: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DependencyGraph:
        """Get Derived Table graph for model"""
        model = self.encode_path_param(model)
        response = cast(
            mdls.DependencyGraph,
            self.get(
                path=f"/derived_table/graph/model/{model}",
                structure=mdls.DependencyGraph,
                query_params={"format": format, "color": color},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the subgraph representing this derived table and its dependencies.
    #
    # GET /derived_table/graph/view/{view} -> mdls.DependencyGraph
    def graph_derived_tables_for_view(
        self,
        # The derived table's view name.
        view: str,
        # The models where this derived table is defined.
        models: Optional[str] = None,
        # The model directory to look in, either `dev` or `production`.
        workspace: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DependencyGraph:
        """Get subgraph of derived table and dependencies"""
        view = self.encode_path_param(view)
        response = cast(
            mdls.DependencyGraph,
            self.get(
                path=f"/derived_table/graph/view/{view}",
                structure=mdls.DependencyGraph,
                query_params={"models": models, "workspace": workspace},
                transport_options=transport_options,
            ),
        )
        return response

    # Enqueue materialization for a PDT with the given model name and view name
    #
    # GET /derived_table/{model_name}/{view_name}/start -> mdls.MaterializePDT
    def start_pdt_build(
        self,
        # The model of the PDT to start building.
        model_name: str,
        # The view name of the PDT to start building.
        view_name: str,
        # Force rebuild of required dependent PDTs, even if they are already materialized.
        force_rebuild: Optional[str] = None,
        # Force involved incremental PDTs to fully re-materialize.
        force_full_incremental: Optional[str] = None,
        # Workspace in which to materialize selected PDT ('dev' or default 'production').
        workspace: Optional[str] = None,
        # The source of this request.
        source: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MaterializePDT:
        """Start a PDT materialization"""
        model_name = self.encode_path_param(model_name)
        view_name = self.encode_path_param(view_name)
        response = cast(
            mdls.MaterializePDT,
            self.get(
                path=f"/derived_table/{model_name}/{view_name}/start",
                structure=mdls.MaterializePDT,
                query_params={
                    "force_rebuild": force_rebuild,
                    "force_full_incremental": force_full_incremental,
                    "workspace": workspace,
                    "source": source,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # Check status of PDT materialization
    #
    # GET /derived_table/{materialization_id}/status -> mdls.MaterializePDT
    def check_pdt_build(
        self,
        # The materialization id to check status for.
        materialization_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MaterializePDT:
        """Check status of a PDT materialization"""
        materialization_id = self.encode_path_param(materialization_id)
        response = cast(
            mdls.MaterializePDT,
            self.get(
                path=f"/derived_table/{materialization_id}/status",
                structure=mdls.MaterializePDT,
                transport_options=transport_options,
            ),
        )
        return response

    # Stop a PDT materialization
    #
    # GET /derived_table/{materialization_id}/stop -> mdls.MaterializePDT
    def stop_pdt_build(
        self,
        # The materialization id to stop.
        materialization_id: str,
        # The source of this request.
        source: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MaterializePDT:
        """Stop a PDT materialization"""
        materialization_id = self.encode_path_param(materialization_id)
        response = cast(
            mdls.MaterializePDT,
            self.get(
                path=f"/derived_table/{materialization_id}/stop",
                structure=mdls.MaterializePDT,
                query_params={"source": source},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Folder: Manage Folders

    # Search for folders by creator id, parent id, name, etc
    #
    # GET /folders/search -> Sequence[mdls.Folder]
    def search_folders(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match Space title.
        name: Optional[str] = None,
        # Match Space id
        id: Optional[str] = None,
        # Filter on a children of a particular folder.
        parent_id: Optional[str] = None,
        # Filter on folder created by a particular user.
        creator_id: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Match is shared root
        is_shared_root: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Folder]:
        """Search Folders"""
        response = cast(
            Sequence[mdls.Folder],
            self.get(
                path="/folders/search",
                structure=Sequence[mdls.Folder],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "name": name,
                    "id": id,
                    "parent_id": parent_id,
                    "creator_id": creator_id,
                    "filter_or": filter_or,
                    "is_shared_root": is_shared_root,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the folder with a specific id.
    #
    # GET /folders/{folder_id} -> mdls.Folder
    def folder(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Folder:
        """Get Folder"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            mdls.Folder,
            self.get(
                path=f"/folders/{folder_id}",
                structure=mdls.Folder,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the folder with a specific id.
    #
    # PATCH /folders/{folder_id} -> mdls.Folder
    def update_folder(
        self,
        # Id of folder
        folder_id: str,
        body: mdls.UpdateFolder,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Folder:
        """Update Folder"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            mdls.Folder,
            self.patch(
                path=f"/folders/{folder_id}",
                structure=mdls.Folder,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the folder with a specific id including any children folders.
    # **DANGER** this will delete all looks and dashboards in the folder.
    #
    # DELETE /folders/{folder_id} -> str
    def delete_folder(
        self,
        # Id of folder
        folder_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Folder"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            str,
            self.delete(
                path=f"/folders/{folder_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all folders.
    #
    # In API 3.x, this will not return empty personal folders, unless they belong to the calling user,
    # or if they contain soft-deleted content.
    #
    # In API 4.0+, all personal folders will be returned.
    #
    # GET /folders -> Sequence[mdls.Folder]
    def all_folders(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Folder]:
        """Get All Folders"""
        response = cast(
            Sequence[mdls.Folder],
            self.get(
                path="/folders",
                structure=Sequence[mdls.Folder],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a folder with specified information.
    #
    # Caller must have permission to edit the parent folder and to create folders, otherwise the request
    # returns 404 Not Found.
    #
    # POST /folders -> mdls.Folder
    def create_folder(
        self,
        body: mdls.CreateFolder,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Folder:
        """Create Folder"""
        response = cast(
            mdls.Folder,
            self.post(
                path="/folders",
                structure=mdls.Folder,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the children of a folder.
    #
    # GET /folders/{folder_id}/children -> Sequence[mdls.Folder]
    def folder_children(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Folder]:
        """Get Folder Children"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            Sequence[mdls.Folder],
            self.get(
                path=f"/folders/{folder_id}/children",
                structure=Sequence[mdls.Folder],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search the children of a folder
    #
    # GET /folders/{folder_id}/children/search -> Sequence[mdls.Folder]
    def folder_children_search(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match folder name.
        name: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Folder]:
        """Search Folder Children"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            Sequence[mdls.Folder],
            self.get(
                path=f"/folders/{folder_id}/children/search",
                structure=Sequence[mdls.Folder],
                query_params={"fields": fields, "sorts": sorts, "name": name},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the parent of a folder
    #
    # GET /folders/{folder_id}/parent -> mdls.Folder
    def folder_parent(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Folder:
        """Get Folder Parent"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            mdls.Folder,
            self.get(
                path=f"/folders/{folder_id}/parent",
                structure=mdls.Folder,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the ancestors of a folder
    #
    # GET /folders/{folder_id}/ancestors -> Sequence[mdls.Folder]
    def folder_ancestors(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Folder]:
        """Get Folder Ancestors"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            Sequence[mdls.Folder],
            self.get(
                path=f"/folders/{folder_id}/ancestors",
                structure=Sequence[mdls.Folder],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get all looks in a folder.
    # In API 3.x, this will return all looks in a folder, including looks in the trash.
    # In API 4.0+, all looks in a folder will be returned, excluding looks in the trash.
    #
    # GET /folders/{folder_id}/looks -> Sequence[mdls.LookWithQuery]
    def folder_looks(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.LookWithQuery]:
        """Get Folder Looks"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            Sequence[mdls.LookWithQuery],
            self.get(
                path=f"/folders/{folder_id}/looks",
                structure=Sequence[mdls.LookWithQuery],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the dashboards in a folder
    #
    # GET /folders/{folder_id}/dashboards -> Sequence[mdls.Dashboard]
    def folder_dashboards(
        self,
        # Id of folder
        folder_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Dashboard]:
        """Get Folder Dashboards"""
        folder_id = self.encode_path_param(folder_id)
        response = cast(
            Sequence[mdls.Dashboard],
            self.get(
                path=f"/folders/{folder_id}/dashboards",
                structure=Sequence[mdls.Dashboard],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Group: Manage Groups

    # ### Get information about all groups.
    #
    # GET /groups -> Sequence[mdls.Group]
    def all_groups(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Optional of ids to get specific groups.
        ids: Optional[mdls.DelimSequence[str]] = None,
        # Id of content metadata to which groups must have access.
        content_metadata_id: Optional[str] = None,
        # Select only groups that either can/cannot be given access to content.
        can_add_to_content_metadata: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Group]:
        """Get All Groups"""
        response = cast(
            Sequence[mdls.Group],
            self.get(
                path="/groups",
                structure=Sequence[mdls.Group],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "ids": ids,
                    "content_metadata_id": content_metadata_id,
                    "can_add_to_content_metadata": can_add_to_content_metadata,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Creates a new group (admin only).
    #
    # POST /groups -> mdls.Group
    def create_group(
        self,
        body: mdls.WriteGroup,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Group:
        """Create Group"""
        response = cast(
            mdls.Group,
            self.post(
                path="/groups",
                structure=mdls.Group,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search groups
    #
    # Returns all group records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /groups/search -> Sequence[mdls.Group]
    def search_groups(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Match group id.
        id: Optional[str] = None,
        # Match group name.
        name: Optional[str] = None,
        # Match group external_group_id.
        external_group_id: Optional[str] = None,
        # Match group externally_managed.
        externally_managed: Optional[bool] = None,
        # Match group externally_orphaned.
        externally_orphaned: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Group]:
        """Search Groups"""
        response = cast(
            Sequence[mdls.Group],
            self.get(
                path="/groups/search",
                structure=Sequence[mdls.Group],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "filter_or": filter_or,
                    "id": id,
                    "name": name,
                    "external_group_id": external_group_id,
                    "externally_managed": externally_managed,
                    "externally_orphaned": externally_orphaned,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search groups include roles
    #
    # Returns all group records that match the given search criteria, and attaches any associated roles.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /groups/search/with_roles -> Sequence[mdls.GroupSearch]
    def search_groups_with_roles(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Match group id.
        id: Optional[str] = None,
        # Match group name.
        name: Optional[str] = None,
        # Match group external_group_id.
        external_group_id: Optional[str] = None,
        # Match group externally_managed.
        externally_managed: Optional[bool] = None,
        # Match group externally_orphaned.
        externally_orphaned: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.GroupSearch]:
        """Search Groups with Roles"""
        response = cast(
            Sequence[mdls.GroupSearch],
            self.get(
                path="/groups/search/with_roles",
                structure=Sequence[mdls.GroupSearch],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "filter_or": filter_or,
                    "id": id,
                    "name": name,
                    "external_group_id": external_group_id,
                    "externally_managed": externally_managed,
                    "externally_orphaned": externally_orphaned,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search groups include hierarchy
    #
    # Returns all group records that match the given search criteria, and attaches
    # associated role_ids and parent group_ids.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /groups/search/with_hierarchy -> Sequence[mdls.GroupHierarchy]
    def search_groups_with_hierarchy(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Match group id.
        id: Optional[str] = None,
        # Match group name.
        name: Optional[str] = None,
        # Match group external_group_id.
        external_group_id: Optional[str] = None,
        # Match group externally_managed.
        externally_managed: Optional[bool] = None,
        # Match group externally_orphaned.
        externally_orphaned: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.GroupHierarchy]:
        """Search Groups with Hierarchy"""
        response = cast(
            Sequence[mdls.GroupHierarchy],
            self.get(
                path="/groups/search/with_hierarchy",
                structure=Sequence[mdls.GroupHierarchy],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "filter_or": filter_or,
                    "id": id,
                    "name": name,
                    "external_group_id": external_group_id,
                    "externally_managed": externally_managed,
                    "externally_orphaned": externally_orphaned,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a group.
    #
    # GET /groups/{group_id} -> mdls.Group
    def group(
        self,
        # Id of group
        group_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Group:
        """Get Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            mdls.Group,
            self.get(
                path=f"/groups/{group_id}",
                structure=mdls.Group,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Updates the a group (admin only).
    #
    # PATCH /groups/{group_id} -> mdls.Group
    def update_group(
        self,
        # Id of group
        group_id: str,
        body: mdls.WriteGroup,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Group:
        """Update Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            mdls.Group,
            self.patch(
                path=f"/groups/{group_id}",
                structure=mdls.Group,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Deletes a group (admin only).
    #
    # DELETE /groups/{group_id} -> str
    def delete_group(
        self,
        # Id of group
        group_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            str,
            self.delete(
                path=f"/groups/{group_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the groups in a group
    #
    # GET /groups/{group_id}/groups -> Sequence[mdls.Group]
    def all_group_groups(
        self,
        # Id of group
        group_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Group]:
        """Get All Groups in Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            Sequence[mdls.Group],
            self.get(
                path=f"/groups/{group_id}/groups",
                structure=Sequence[mdls.Group],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Adds a new group to a group.
    #
    # POST /groups/{group_id}/groups -> mdls.Group
    def add_group_group(
        self,
        # Id of group
        group_id: str,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: mdls.GroupIdForGroupInclusion,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Group:
        """Add a Group to Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            mdls.Group,
            self.post(
                path=f"/groups/{group_id}/groups",
                structure=mdls.Group,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the users directly included in a group.
    #
    # GET /groups/{group_id}/users -> Sequence[mdls.User]
    def all_group_users(
        self,
        # Id of group
        group_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.User]:
        """Get All Users in Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            Sequence[mdls.User],
            self.get(
                path=f"/groups/{group_id}/users",
                structure=Sequence[mdls.User],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Adds a new user to a group.
    #
    # POST /groups/{group_id}/users -> mdls.User
    def add_group_user(
        self,
        # Id of group
        group_id: str,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: mdls.GroupIdForGroupUserInclusion,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Add a User to Group"""
        group_id = self.encode_path_param(group_id)
        response = cast(
            mdls.User,
            self.post(
                path=f"/groups/{group_id}/users",
                structure=mdls.User,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Removes a user from a group.
    #
    # DELETE /groups/{group_id}/users/{user_id} -> None
    def delete_group_user(
        self,
        # Id of group
        group_id: str,
        # Id of user to remove from group
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Remove a User from Group"""
        group_id = self.encode_path_param(group_id)
        user_id = self.encode_path_param(user_id)
        response = cast(
            None,
            self.delete(
                path=f"/groups/{group_id}/users/{user_id}",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Removes a group from a group.
    #
    # DELETE /groups/{group_id}/groups/{deleting_group_id} -> None
    def delete_group_from_group(
        self,
        # Id of group
        group_id: str,
        # Id of group to delete
        deleting_group_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Deletes a Group from Group"""
        group_id = self.encode_path_param(group_id)
        deleting_group_id = self.encode_path_param(deleting_group_id)
        response = cast(
            None,
            self.delete(
                path=f"/groups/{group_id}/groups/{deleting_group_id}",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set the value of a user attribute for a group.
    #
    # For information about how user attribute values are calculated, see [Set User Attribute Group Values](#!/UserAttribute/set_user_attribute_group_values).
    #
    # PATCH /groups/{group_id}/attribute_values/{user_attribute_id} -> mdls.UserAttributeGroupValue
    def update_user_attribute_group_value(
        self,
        # Id of group
        group_id: str,
        # Id of user attribute
        user_attribute_id: str,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: mdls.UserAttributeGroupValue,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.UserAttributeGroupValue:
        """Set User Attribute Group Value"""
        group_id = self.encode_path_param(group_id)
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            mdls.UserAttributeGroupValue,
            self.patch(
                path=f"/groups/{group_id}/attribute_values/{user_attribute_id}",
                structure=mdls.UserAttributeGroupValue,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Remove a user attribute value from a group.
    #
    # DELETE /groups/{group_id}/attribute_values/{user_attribute_id} -> None
    def delete_user_attribute_group_value(
        self,
        # Id of group
        group_id: str,
        # Id of user attribute
        user_attribute_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Delete User Attribute Group Value"""
        group_id = self.encode_path_param(group_id)
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            None,
            self.delete(
                path=f"/groups/{group_id}/attribute_values/{user_attribute_id}",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Homepage: Manage Homepage

    # ### Get information about the primary homepage's sections.
    #
    # GET /primary_homepage_sections -> Sequence[mdls.HomepageSection]
    def all_primary_homepage_sections(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.HomepageSection]:
        """Get All Primary homepage sections"""
        response = cast(
            Sequence[mdls.HomepageSection],
            self.get(
                path="/primary_homepage_sections",
                structure=Sequence[mdls.HomepageSection],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Integration: Manage Integrations

    # ### Get information about all Integration Hubs.
    #
    # GET /integration_hubs -> Sequence[mdls.IntegrationHub]
    def all_integration_hubs(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.IntegrationHub]:
        """Get All Integration Hubs"""
        response = cast(
            Sequence[mdls.IntegrationHub],
            self.get(
                path="/integration_hubs",
                structure=Sequence[mdls.IntegrationHub],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new Integration Hub.
    #
    # This API is rate limited to prevent it from being used for SSRF attacks
    #
    # POST /integration_hubs -> mdls.IntegrationHub
    def create_integration_hub(
        self,
        body: mdls.WriteIntegrationHub,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.IntegrationHub:
        """Create Integration Hub"""
        response = cast(
            mdls.IntegrationHub,
            self.post(
                path="/integration_hubs",
                structure=mdls.IntegrationHub,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a Integration Hub.
    #
    # GET /integration_hubs/{integration_hub_id} -> mdls.IntegrationHub
    def integration_hub(
        self,
        # Id of integration_hub
        integration_hub_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.IntegrationHub:
        """Get Integration Hub"""
        integration_hub_id = self.encode_path_param(integration_hub_id)
        response = cast(
            mdls.IntegrationHub,
            self.get(
                path=f"/integration_hubs/{integration_hub_id}",
                structure=mdls.IntegrationHub,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a Integration Hub definition.
    #
    # This API is rate limited to prevent it from being used for SSRF attacks
    #
    # PATCH /integration_hubs/{integration_hub_id} -> mdls.IntegrationHub
    def update_integration_hub(
        self,
        # Id of integration_hub
        integration_hub_id: str,
        body: mdls.WriteIntegrationHub,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.IntegrationHub:
        """Update Integration Hub"""
        integration_hub_id = self.encode_path_param(integration_hub_id)
        response = cast(
            mdls.IntegrationHub,
            self.patch(
                path=f"/integration_hubs/{integration_hub_id}",
                structure=mdls.IntegrationHub,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a Integration Hub.
    #
    # DELETE /integration_hubs/{integration_hub_id} -> str
    def delete_integration_hub(
        self,
        # Id of integration_hub
        integration_hub_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Integration Hub"""
        integration_hub_id = self.encode_path_param(integration_hub_id)
        response = cast(
            str,
            self.delete(
                path=f"/integration_hubs/{integration_hub_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # Accepts the legal agreement for a given integration hub. This only works for integration hubs that have legal_agreement_required set to true and legal_agreement_signed set to false.
    #
    # POST /integration_hubs/{integration_hub_id}/accept_legal_agreement -> mdls.IntegrationHub
    def accept_integration_hub_legal_agreement(
        self,
        # Id of integration_hub
        integration_hub_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.IntegrationHub:
        """Accept Integration Hub Legal Agreement"""
        integration_hub_id = self.encode_path_param(integration_hub_id)
        response = cast(
            mdls.IntegrationHub,
            self.post(
                path=f"/integration_hubs/{integration_hub_id}/accept_legal_agreement",
                structure=mdls.IntegrationHub,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all Integrations.
    #
    # GET /integrations -> Sequence[mdls.Integration]
    def all_integrations(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Filter to a specific provider
        integration_hub_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Integration]:
        """Get All Integrations"""
        response = cast(
            Sequence[mdls.Integration],
            self.get(
                path="/integrations",
                structure=Sequence[mdls.Integration],
                query_params={
                    "fields": fields,
                    "integration_hub_id": integration_hub_id,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a Integration.
    #
    # GET /integrations/{integration_id} -> mdls.Integration
    def integration(
        self,
        # Id of integration
        integration_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Integration:
        """Get Integration"""
        integration_id = self.encode_path_param(integration_id)
        response = cast(
            mdls.Integration,
            self.get(
                path=f"/integrations/{integration_id}",
                structure=mdls.Integration,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update parameters on a Integration.
    #
    # PATCH /integrations/{integration_id} -> mdls.Integration
    def update_integration(
        self,
        # Id of integration
        integration_id: str,
        body: mdls.WriteIntegration,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Integration:
        """Update Integration"""
        integration_id = self.encode_path_param(integration_id)
        response = cast(
            mdls.Integration,
            self.patch(
                path=f"/integrations/{integration_id}",
                structure=mdls.Integration,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # Returns the Integration form for presentation to the user.
    #
    # POST /integrations/{integration_id}/form -> mdls.DataActionForm
    def fetch_integration_form(
        self,
        # Id of integration
        integration_id: str,
        body: Optional[MutableMapping[str, Any]] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.DataActionForm:
        """Fetch Remote Integration Form"""
        integration_id = self.encode_path_param(integration_id)
        response = cast(
            mdls.DataActionForm,
            self.post(
                path=f"/integrations/{integration_id}/form",
                structure=mdls.DataActionForm,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # Tests the integration to make sure all the settings are working.
    #
    # POST /integrations/{integration_id}/test -> mdls.IntegrationTestResult
    def test_integration(
        self,
        # Id of integration
        integration_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.IntegrationTestResult:
        """Test integration"""
        integration_id = self.encode_path_param(integration_id)
        response = cast(
            mdls.IntegrationTestResult,
            self.post(
                path=f"/integrations/{integration_id}/test",
                structure=mdls.IntegrationTestResult,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Look: Run and Manage Looks

    # ### Get information about all active Looks
    #
    # Returns an array of **abbreviated Look objects** describing all the looks that the caller has access to. Soft-deleted Looks are **not** included.
    #
    # Get the **full details** of a specific look by id with [look(id)](#!/Look/look)
    #
    # Find **soft-deleted looks** with [search_looks()](#!/Look/search_looks)
    #
    # GET /looks -> Sequence[mdls.Look]
    def all_looks(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Look]:
        """Get All Looks"""
        response = cast(
            Sequence[mdls.Look],
            self.get(
                path="/looks",
                structure=Sequence[mdls.Look],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a Look
    #
    # To create a look to display query data, first create the query with [create_query()](#!/Query/create_query)
    # then assign the query's id to the `query_id` property in the call to `create_look()`.
    #
    # To place the look into a particular space, assign the space's id to the `space_id` property
    # in the call to `create_look()`.
    #
    # POST /looks -> mdls.LookWithQuery
    def create_look(
        self,
        body: mdls.WriteLookWithQuery,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookWithQuery:
        """Create Look"""
        response = cast(
            mdls.LookWithQuery,
            self.post(
                path="/looks",
                structure=mdls.LookWithQuery,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search Looks
    #
    # Returns an **array of Look objects** that match the specified search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # Get a **single look** by id with [look(id)](#!/Look/look)
    #
    # GET /looks/search -> Sequence[mdls.Look]
    def search_looks(
        self,
        # Match look id.
        id: Optional[str] = None,
        # Match Look title.
        title: Optional[str] = None,
        # Match Look description.
        description: Optional[str] = None,
        # Select looks with a particular content favorite id
        content_favorite_id: Optional[str] = None,
        # Select looks in a particular folder.
        folder_id: Optional[str] = None,
        # Select looks created by a particular user.
        user_id: Optional[str] = None,
        # Select looks with particular view_count value
        view_count: Optional[str] = None,
        # Select soft-deleted looks
        deleted: Optional[bool] = None,
        # Select looks that reference a particular query by query_id
        query_id: Optional[str] = None,
        # Exclude items that exist only in personal spaces other than the users
        curate: Optional[bool] = None,
        # Select looks based on when they were last viewed
        last_viewed_at: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # One or more fields to sort results by. Sortable fields: [:title, :user_id, :id, :created_at, :space_id, :folder_id, :description, :updated_at, :last_updater_id, :view_count, :favorite_count, :content_favorite_id, :deleted, :deleted_at, :last_viewed_at, :last_accessed_at, :query_id]
        sorts: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Look]:
        """Search Looks"""
        response = cast(
            Sequence[mdls.Look],
            self.get(
                path="/looks/search",
                structure=Sequence[mdls.Look],
                query_params={
                    "id": id,
                    "title": title,
                    "description": description,
                    "content_favorite_id": content_favorite_id,
                    "folder_id": folder_id,
                    "user_id": user_id,
                    "view_count": view_count,
                    "deleted": deleted,
                    "query_id": query_id,
                    "curate": curate,
                    "last_viewed_at": last_viewed_at,
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a Look.
    #
    # Returns detailed information about a Look and its associated Query.
    #
    # GET /looks/{look_id} -> mdls.LookWithQuery
    def look(
        self,
        # Id of look
        look_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookWithQuery:
        """Get Look"""
        look_id = self.encode_path_param(look_id)
        response = cast(
            mdls.LookWithQuery,
            self.get(
                path=f"/looks/{look_id}",
                structure=mdls.LookWithQuery,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Modify a Look
    #
    # Use this function to modify parts of a look. Property values given in a call to `update_look` are
    # applied to the existing look, so there's no need to include properties whose values are not changing.
    # It's best to specify only the properties you want to change and leave everything else out
    # of your `update_look` call. **Look properties marked 'read-only' will be ignored.**
    #
    # When a user deletes a look in the Looker UI, the look data remains in the database but is
    # marked with a deleted flag ("soft-deleted"). Soft-deleted looks can be undeleted (by an admin)
    # if the delete was in error.
    #
    # To soft-delete a look via the API, use [update_look()](#!/Look/update_look) to change the look's `deleted` property to `true`.
    # You can undelete a look by calling `update_look` to change the look's `deleted` property to `false`.
    #
    # Soft-deleted looks are excluded from the results of [all_looks()](#!/Look/all_looks) and [search_looks()](#!/Look/search_looks), so they
    # essentially disappear from view even though they still reside in the db.
    # In API 3.1 and later, you can pass `deleted: true` as a parameter to [search_looks()](#!/3.1/Look/search_looks) to list soft-deleted looks.
    #
    # NOTE: [delete_look()](#!/Look/delete_look) performs a "hard delete" - the look data is removed from the Looker
    # database and destroyed. There is no "undo" for `delete_look()`.
    #
    # PATCH /looks/{look_id} -> mdls.LookWithQuery
    def update_look(
        self,
        # Id of look
        look_id: str,
        body: mdls.WriteLookWithQuery,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookWithQuery:
        """Update Look"""
        look_id = self.encode_path_param(look_id)
        response = cast(
            mdls.LookWithQuery,
            self.patch(
                path=f"/looks/{look_id}",
                structure=mdls.LookWithQuery,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Permanently Delete a Look
    #
    # This operation **permanently** removes a look from the Looker database.
    #
    # NOTE: There is no "undo" for this kind of delete.
    #
    # For information about soft-delete (which can be undone) see [update_look()](#!/Look/update_look).
    #
    # DELETE /looks/{look_id} -> str
    def delete_look(
        self,
        # Id of look
        look_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Look"""
        look_id = self.encode_path_param(look_id)
        response = cast(
            str,
            self.delete(
                path=f"/looks/{look_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run a Look
    #
    # Runs a given look's query and returns the results in the requested format.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # GET /looks/{look_id}/run/{result_format} -> Union[str, bytes]
    def run_look(
        self,
        # Id of look
        look_id: str,
        # Format of result
        result_format: str,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode. Note that this flag being false does not guarantee development models will be used.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Union[str, bytes]:
        """Run Look"""
        look_id = self.encode_path_param(look_id)
        result_format = self.encode_path_param(result_format)
        response = cast(
            Union[str, bytes],
            self.get(
                path=f"/looks/{look_id}/run/{result_format}",
                structure=Union[str, bytes],  # type: ignore
                query_params={
                    "limit": limit,
                    "apply_formatting": apply_formatting,
                    "apply_vis": apply_vis,
                    "cache": cache,
                    "image_width": image_width,
                    "image_height": image_height,
                    "generate_drill_links": generate_drill_links,
                    "force_production": force_production,
                    "cache_only": cache_only,
                    "path_prefix": path_prefix,
                    "rebuild_pdts": rebuild_pdts,
                    "server_table_calcs": server_table_calcs,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Copy an existing look
    #
    # Creates a copy of an existing look, in a specified folder, and returns the copied look.
    #
    # `look_id` and `folder_id` are required.
    #
    # `look_id` and `folder_id` must already exist, and `folder_id` must be different from the current `folder_id` of the dashboard.
    #
    # POST /looks/{look_id}/copy -> mdls.LookWithQuery
    def copy_look(
        self,
        # Look id to copy.
        look_id: str,
        # Folder id to copy to.
        folder_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookWithQuery:
        """Copy Look"""
        look_id = self.encode_path_param(look_id)
        response = cast(
            mdls.LookWithQuery,
            self.post(
                path=f"/looks/{look_id}/copy",
                structure=mdls.LookWithQuery,
                query_params={"folder_id": folder_id},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Move an existing look
    #
    # Moves a look to a specified folder, and returns the moved look.
    #
    # `look_id` and `folder_id` are required.
    # `look_id` and `folder_id` must already exist, and `folder_id` must be different from the current `folder_id` of the dashboard.
    #
    # PATCH /looks/{look_id}/move -> mdls.LookWithQuery
    def move_look(
        self,
        # Look id to move.
        look_id: str,
        # Folder id to move to.
        folder_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookWithQuery:
        """Move Look"""
        look_id = self.encode_path_param(look_id)
        response = cast(
            mdls.LookWithQuery,
            self.patch(
                path=f"/looks/{look_id}/move",
                structure=mdls.LookWithQuery,
                query_params={"folder_id": folder_id},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region LookmlModel: Manage LookML Models

    # ### Get information about all lookml models.
    #
    # GET /lookml_models -> Sequence[mdls.LookmlModel]
    def all_lookml_models(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return. (can be used with offset)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (Defaults to 0 if not set when limit is used)
        offset: Optional[int] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.LookmlModel]:
        """Get All LookML Models"""
        response = cast(
            Sequence[mdls.LookmlModel],
            self.get(
                path="/lookml_models",
                structure=Sequence[mdls.LookmlModel],
                query_params={"fields": fields, "limit": limit, "offset": offset},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a lookml model using the specified configuration.
    #
    # POST /lookml_models -> mdls.LookmlModel
    def create_lookml_model(
        self,
        body: mdls.WriteLookmlModel,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookmlModel:
        """Create LookML Model"""
        response = cast(
            mdls.LookmlModel,
            self.post(
                path="/lookml_models",
                structure=mdls.LookmlModel,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a lookml model.
    #
    # GET /lookml_models/{lookml_model_name} -> mdls.LookmlModel
    def lookml_model(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookmlModel:
        """Get LookML Model"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        response = cast(
            mdls.LookmlModel,
            self.get(
                path=f"/lookml_models/{lookml_model_name}",
                structure=mdls.LookmlModel,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a lookml model using the specified configuration.
    #
    # PATCH /lookml_models/{lookml_model_name} -> mdls.LookmlModel
    def update_lookml_model(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        body: mdls.WriteLookmlModel,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookmlModel:
        """Update LookML Model"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        response = cast(
            mdls.LookmlModel,
            self.patch(
                path=f"/lookml_models/{lookml_model_name}",
                structure=mdls.LookmlModel,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a lookml model.
    #
    # DELETE /lookml_models/{lookml_model_name} -> str
    def delete_lookml_model(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete LookML Model"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        response = cast(
            str,
            self.delete(
                path=f"/lookml_models/{lookml_model_name}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a lookml model explore.
    #
    # GET /lookml_models/{lookml_model_name}/explores/{explore_name} -> mdls.LookmlModelExplore
    def lookml_model_explore(
        self,
        # Name of lookml model.
        lookml_model_name: str,
        # Name of explore.
        explore_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.LookmlModelExplore:
        """Get LookML Model Explore"""
        lookml_model_name = self.encode_path_param(lookml_model_name)
        explore_name = self.encode_path_param(explore_name)
        response = cast(
            mdls.LookmlModelExplore,
            self.get(
                path=f"/lookml_models/{lookml_model_name}/explores/{explore_name}",
                structure=mdls.LookmlModelExplore,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Metadata: Connection Metadata Features

    # ### Field name suggestions for a model and view
    #
    # `filters` is a string hash of values, with the key as the field name and the string value as the filter expression:
    #
    # ```ruby
    # {'users.age': '>=60'}
    # ```
    #
    # or
    #
    # ```ruby
    # {'users.age': '<30'}
    # ```
    #
    # or
    #
    # ```ruby
    # {'users.age': '=50'}
    # ```
    #
    # GET /models/{model_name}/views/{view_name}/fields/{field_name}/suggestions -> mdls.ModelFieldSuggestions
    def model_fieldname_suggestions(
        self,
        # Name of model
        model_name: str,
        # Name of view
        view_name: str,
        # Name of field to use for suggestions
        field_name: str,
        # Search term pattern (evaluated as as `%term%`)
        term: Optional[str] = None,
        # Suggestion filters with field name keys and comparison expressions
        filters: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ModelFieldSuggestions:
        """Model field name suggestions"""
        model_name = self.encode_path_param(model_name)
        view_name = self.encode_path_param(view_name)
        field_name = self.encode_path_param(field_name)
        response = cast(
            mdls.ModelFieldSuggestions,
            self.get(
                path=f"/models/{model_name}/views/{view_name}/fields/{field_name}/suggestions",
                structure=mdls.ModelFieldSuggestions,
                query_params={"term": term, "filters": filters},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a single model
    #
    # GET /models/{model_name} -> mdls.Model
    def get_model(
        self,
        # Name of model
        model_name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Model:
        """Get a single model"""
        model_name = self.encode_path_param(model_name)
        response = cast(
            mdls.Model,
            self.get(
                path=f"/models/{model_name}",
                structure=mdls.Model,
                transport_options=transport_options,
            ),
        )
        return response

    # ### List databases available to this connection
    #
    # Certain dialects can support multiple databases per single connection.
    # If this connection supports multiple databases, the database names will be returned in an array.
    #
    # Connections using dialects that do not support multiple databases will return an empty array.
    #
    # **Note**: [Connection Features](#!/Metadata/connection_features) can be used to determine if a connection supports
    # multiple databases.
    #
    # GET /connections/{connection_name}/databases -> Sequence[str]
    def connection_databases(
        self,
        # Name of connection
        connection_name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[str]:
        """List accessible databases to this connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            Sequence[str],
            self.get(
                path=f"/connections/{connection_name}/databases",
                structure=Sequence[str],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Retrieve metadata features for this connection
    #
    # Returns a list of feature names with `true` (available) or `false` (not available)
    #
    # GET /connections/{connection_name}/features -> mdls.ConnectionFeatures
    def connection_features(
        self,
        # Name of connection
        connection_name: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ConnectionFeatures:
        """Metadata features supported by this connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            mdls.ConnectionFeatures,
            self.get(
                path=f"/connections/{connection_name}/features",
                structure=mdls.ConnectionFeatures,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the list of schemas and tables for a connection
    #
    # GET /connections/{connection_name}/schemas -> Sequence[mdls.Schema]
    def connection_schemas(
        self,
        # Name of connection
        connection_name: str,
        # For dialects that support multiple databases, optionally identify which to use
        database: Optional[str] = None,
        # True to use fetch from cache, false to load fresh
        cache: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Schema]:
        """Get schemas for a connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            Sequence[mdls.Schema],
            self.get(
                path=f"/connections/{connection_name}/schemas",
                structure=Sequence[mdls.Schema],
                query_params={"database": database, "cache": cache, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the list of tables for a schema
    #
    # For dialects that support multiple databases, optionally identify which to use. If not provided, the default
    # database for the connection will be used.
    #
    # For dialects that do **not** support multiple databases, **do not use** the database parameter
    #
    # GET /connections/{connection_name}/tables -> Sequence[mdls.SchemaTables]
    def connection_tables(
        self,
        # Name of connection
        connection_name: str,
        # Optional. Name of database to use for the query, only if applicable
        database: Optional[str] = None,
        # Optional. Return only tables for this schema
        schema_name: Optional[str] = None,
        # True to fetch from cache, false to load fresh
        cache: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Optional. Return tables with names that contain this value
        table_filter: Optional[str] = None,
        # Optional. Return tables up to the table_limit
        table_limit: Optional[int] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.SchemaTables]:
        """Get tables for a connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            Sequence[mdls.SchemaTables],
            self.get(
                path=f"/connections/{connection_name}/tables",
                structure=Sequence[mdls.SchemaTables],
                query_params={
                    "database": database,
                    "schema_name": schema_name,
                    "cache": cache,
                    "fields": fields,
                    "table_filter": table_filter,
                    "table_limit": table_limit,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the columns (and therefore also the tables) in a specific schema
    #
    # GET /connections/{connection_name}/columns -> Sequence[mdls.SchemaColumns]
    def connection_columns(
        self,
        # Name of connection
        connection_name: str,
        # For dialects that support multiple databases, optionally identify which to use
        database: Optional[str] = None,
        # Name of schema to use.
        schema_name: Optional[str] = None,
        # True to fetch from cache, false to load fresh
        cache: Optional[bool] = None,
        # limits the tables per schema returned
        table_limit: Optional[int] = None,
        # only fetch columns for a given (comma-separated) list of tables
        table_names: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.SchemaColumns]:
        """Get columns for a connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            Sequence[mdls.SchemaColumns],
            self.get(
                path=f"/connections/{connection_name}/columns",
                structure=Sequence[mdls.SchemaColumns],
                query_params={
                    "database": database,
                    "schema_name": schema_name,
                    "cache": cache,
                    "table_limit": table_limit,
                    "table_names": table_names,
                    "fields": fields,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search a connection for columns matching the specified name
    #
    # **Note**: `column_name` must be a valid column name. It is not a search pattern.
    #
    # GET /connections/{connection_name}/search_columns -> Sequence[mdls.ColumnSearch]
    def connection_search_columns(
        self,
        # Name of connection
        connection_name: str,
        # Column name to find
        column_name: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ColumnSearch]:
        """Search a connection for columns"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            Sequence[mdls.ColumnSearch],
            self.get(
                path=f"/connections/{connection_name}/search_columns",
                structure=Sequence[mdls.ColumnSearch],
                query_params={"column_name": column_name, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Connection cost estimating
    #
    # Assign a `sql` statement to the body of the request. e.g., for Ruby, `{sql: 'select * from users'}`
    #
    # **Note**: If the connection's dialect has no support for cost estimates, an error will be returned
    #
    # POST /connections/{connection_name}/cost_estimate -> mdls.CostEstimate
    def connection_cost_estimate(
        self,
        # Name of connection
        connection_name: str,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: mdls.CreateCostEstimate,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CostEstimate:
        """Estimate costs for a connection"""
        connection_name = self.encode_path_param(connection_name)
        response = cast(
            mdls.CostEstimate,
            self.post(
                path=f"/connections/{connection_name}/cost_estimate",
                structure=mdls.CostEstimate,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Project: Manage Projects

    # ### Generate Lockfile for All LookML Dependencies
    #
    #       Git must have been configured, must be in dev mode and deploy permission required
    #
    #       Install_all is a two step process
    #       1. For each remote_dependency in a project the dependency manager will resolve any ambiguous ref.
    #       2. The project will then write out a lockfile including each remote_dependency with its resolved ref.
    #
    # POST /projects/{project_id}/manifest/lock_all -> str
    def lock_all(
        self,
        # Id of project
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Lock All"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.post(
                path=f"/projects/{project_id}/manifest/lock_all",
                structure=str,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get All Git Branches
    #
    # Returns a list of git branches in the project repository
    #
    # GET /projects/{project_id}/git_branches -> Sequence[mdls.GitBranch]
    def all_git_branches(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.GitBranch]:
        """Get All Git Branches"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            Sequence[mdls.GitBranch],
            self.get(
                path=f"/projects/{project_id}/git_branches",
                structure=Sequence[mdls.GitBranch],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the Current Git Branch
    #
    # Returns the git branch currently checked out in the given project repository
    #
    # GET /projects/{project_id}/git_branch -> mdls.GitBranch
    def git_branch(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.GitBranch:
        """Get Active Git Branch"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.GitBranch,
            self.get(
                path=f"/projects/{project_id}/git_branch",
                structure=mdls.GitBranch,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Checkout and/or reset --hard an existing Git Branch
    #
    # Only allowed in development mode
    #   - Call `update_session` to select the 'dev' workspace.
    #
    # Checkout an existing branch if name field is different from the name of the currently checked out branch.
    #
    # Optionally specify a branch name, tag name or commit SHA to which the branch should be reset.
    #   **DANGER** hard reset will be force pushed to the remote. Unsaved changes and commits may be permanently lost.
    #
    # PUT /projects/{project_id}/git_branch -> mdls.GitBranch
    def update_git_branch(
        self,
        # Project Id
        project_id: str,
        body: mdls.WriteGitBranch,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.GitBranch:
        """Update Project Git Branch"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.GitBranch,
            self.put(
                path=f"/projects/{project_id}/git_branch",
                structure=mdls.GitBranch,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create and Checkout a Git Branch
    #
    # Creates and checks out a new branch in the given project repository
    # Only allowed in development mode
    #   - Call `update_session` to select the 'dev' workspace.
    #
    # Optionally specify a branch name, tag name or commit SHA as the start point in the ref field.
    #   If no ref is specified, HEAD of the current branch will be used as the start point for the new branch.
    #
    # POST /projects/{project_id}/git_branch -> mdls.GitBranch
    def create_git_branch(
        self,
        # Project Id
        project_id: str,
        body: mdls.WriteGitBranch,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.GitBranch:
        """Checkout New Git Branch"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.GitBranch,
            self.post(
                path=f"/projects/{project_id}/git_branch",
                structure=mdls.GitBranch,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the specified Git Branch
    #
    # Returns the git branch specified in branch_name path param if it exists in the given project repository
    #
    # GET /projects/{project_id}/git_branch/{branch_name} -> mdls.GitBranch
    def find_git_branch(
        self,
        # Project Id
        project_id: str,
        # Branch Name
        branch_name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.GitBranch:
        """Find a Git Branch"""
        project_id = self.encode_path_param(project_id)
        branch_name = self.encode_path_param(branch_name)
        response = cast(
            mdls.GitBranch,
            self.get(
                path=f"/projects/{project_id}/git_branch/{branch_name}",
                structure=mdls.GitBranch,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the specified Git Branch
    #
    # Delete git branch specified in branch_name path param from local and remote of specified project repository
    #
    # DELETE /projects/{project_id}/git_branch/{branch_name} -> str
    def delete_git_branch(
        self,
        # Project Id
        project_id: str,
        # Branch Name
        branch_name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete a Git Branch"""
        project_id = self.encode_path_param(project_id)
        branch_name = self.encode_path_param(branch_name)
        response = cast(
            str,
            self.delete(
                path=f"/projects/{project_id}/git_branch/{branch_name}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Deploy a Remote Branch or Ref to Production
    #
    # Git must have been configured and deploy permission required.
    #
    # Deploy is a one/two step process
    # 1. If this is the first deploy of this project, create the production project with git repository.
    # 2. Pull the branch or ref into the production project.
    #
    # Can only specify either a branch or a ref.
    #
    # POST /projects/{project_id}/deploy_ref_to_production -> str
    def deploy_ref_to_production(
        self,
        # Id of project
        project_id: str,
        # Branch to deploy to production
        branch: Optional[str] = None,
        # Ref to deploy to production
        ref: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Deploy Remote Branch or Ref to Production"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.post(
                path=f"/projects/{project_id}/deploy_ref_to_production",
                structure=str,
                query_params={"branch": branch, "ref": ref},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Deploy LookML from this Development Mode Project to Production
    #
    # Git must have been configured, must be in dev mode and deploy permission required
    #
    # Deploy is a two / three step process:
    #
    # 1. Push commits in current branch of dev mode project to the production branch (origin/master).
    #    Note a. This step is skipped in read-only projects.
    #    Note b. If this step is unsuccessful for any reason (e.g. rejected non-fastforward because production branch has
    #              commits not in current branch), subsequent steps will be skipped.
    # 2. If this is the first deploy of this project, create the production project with git repository.
    # 3. Pull the production branch into the production project.
    #
    # POST /projects/{project_id}/deploy_to_production -> str
    def deploy_to_production(
        self,
        # Id of project
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Deploy To Production"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.post(
                path=f"/projects/{project_id}/deploy_to_production",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Reset a project to the revision of the project that is in production.
    #
    # **DANGER** this will delete any changes that have not been pushed to a remote repository.
    #
    # POST /projects/{project_id}/reset_to_production -> str
    def reset_project_to_production(
        self,
        # Id of project
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Reset To Production"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.post(
                path=f"/projects/{project_id}/reset_to_production",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Reset a project development branch to the revision of the project that is on the remote.
    #
    # **DANGER** this will delete any changes that have not been pushed to a remote repository.
    #
    # POST /projects/{project_id}/reset_to_remote -> str
    def reset_project_to_remote(
        self,
        # Id of project
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Reset To Remote"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.post(
                path=f"/projects/{project_id}/reset_to_remote",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get All Projects
    #
    # Returns all projects visible to the current user
    #
    # GET /projects -> Sequence[mdls.Project]
    def all_projects(
        self,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Project]:
        """Get All Projects"""
        response = cast(
            Sequence[mdls.Project],
            self.get(
                path="/projects",
                structure=Sequence[mdls.Project],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create A Project
    #
    # dev mode required.
    # - Call `update_session` to select the 'dev' workspace.
    #
    # `name` is required.
    # `git_remote_url` is not allowed. To configure Git for the newly created project, follow the instructions in `update_project`.
    #
    # POST /projects -> mdls.Project
    def create_project(
        self,
        body: mdls.WriteProject,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Project:
        """Create Project"""
        response = cast(
            mdls.Project,
            self.post(
                path="/projects",
                structure=mdls.Project,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get A Project
    #
    # Returns the project with the given project id
    #
    # GET /projects/{project_id} -> mdls.Project
    def project(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Project:
        """Get Project"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.Project,
            self.get(
                path=f"/projects/{project_id}",
                structure=mdls.Project,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update Project Configuration
    #
    # Apply changes to a project's configuration.
    #
    #
    # #### Configuring Git for a Project
    #
    # To set up a Looker project with a remote git repository, follow these steps:
    #
    # 1. Call `update_session` to select the 'dev' workspace.
    # 1. Call `create_git_deploy_key` to create a new deploy key for the project
    # 1. Copy the deploy key text into the remote git repository's ssh key configuration
    # 1. Call `update_project` to set project's `git_remote_url` ()and `git_service_name`, if necessary).
    #
    # When you modify a project's `git_remote_url`, Looker connects to the remote repository to fetch
    # metadata. The remote git repository MUST be configured with the Looker-generated deploy
    # key for this project prior to setting the project's `git_remote_url`.
    #
    # To set up a Looker project with a git repository residing on the Looker server (a 'bare' git repo):
    #
    # 1. Call `update_session` to select the 'dev' workspace.
    # 1. Call `update_project` setting `git_remote_url` to null and `git_service_name` to "bare".
    #
    # PATCH /projects/{project_id} -> mdls.Project
    def update_project(
        self,
        # Project Id
        project_id: str,
        body: mdls.WriteProject,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Project:
        """Update Project"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.Project,
            self.patch(
                path=f"/projects/{project_id}",
                structure=mdls.Project,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get A Projects Manifest object
    #
    # Returns the project with the given project id
    #
    # GET /projects/{project_id}/manifest -> mdls.Manifest
    def manifest(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Manifest:
        """Get Manifest"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.Manifest,
            self.get(
                path=f"/projects/{project_id}/manifest",
                structure=mdls.Manifest,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Git Deploy Key
    #
    # Returns the ssh public key previously created for a project's git repository.
    #
    # GET /projects/{project_id}/git/deploy_key -> str
    def git_deploy_key(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Git Deploy Key"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.get(
                path=f"/projects/{project_id}/git/deploy_key",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create Git Deploy Key
    #
    # Create a public/private key pair for authenticating ssh git requests from Looker to a remote git repository
    # for a particular Looker project.
    #
    # Returns the public key of the generated ssh key pair.
    #
    # Copy this public key to your remote git repository's ssh keys configuration so that the remote git service can
    # validate and accept git requests from the Looker server.
    #
    # POST /projects/{project_id}/git/deploy_key -> str
    def create_git_deploy_key(
        self,
        # Project Id
        project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Create Deploy Key"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            str,
            self.post(
                path=f"/projects/{project_id}/git/deploy_key",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Cached Project Validation Results
    #
    # Returns the cached results of a previous project validation calculation, if any.
    # Returns http status 204 No Content if no validation results exist.
    #
    # Validating the content of all the files in a project can be computationally intensive
    # for large projects. Use this API to simply fetch the results of the most recent
    # project validation rather than revalidating the entire project from scratch.
    #
    # A value of `"stale": true` in the response indicates that the project has changed since
    # the cached validation results were computed. The cached validation results may no longer
    # reflect the current state of the project.
    #
    # GET /projects/{project_id}/validate -> mdls.ProjectValidationCache
    def project_validation_results(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ProjectValidationCache:
        """Cached Project Validation Results"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.ProjectValidationCache,
            self.get(
                path=f"/projects/{project_id}/validate",
                structure=mdls.ProjectValidationCache,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Validate Project
    #
    # Performs lint validation of all lookml files in the project.
    # Returns a list of errors found, if any.
    #
    # Validating the content of all the files in a project can be computationally intensive
    # for large projects. For best performance, call `validate_project(project_id)` only
    # when you really want to recompute project validation. To quickly display the results of
    # the most recent project validation (without recomputing), use `project_validation_results(project_id)`
    #
    # POST /projects/{project_id}/validate -> mdls.ProjectValidation
    def validate_project(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ProjectValidation:
        """Validate Project"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.ProjectValidation,
            self.post(
                path=f"/projects/{project_id}/validate",
                structure=mdls.ProjectValidation,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Project Workspace
    #
    # Returns information about the state of the project files in the currently selected workspace
    #
    # GET /projects/{project_id}/current_workspace -> mdls.ProjectWorkspace
    def project_workspace(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ProjectWorkspace:
        """Get Project Workspace"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.ProjectWorkspace,
            self.get(
                path=f"/projects/{project_id}/current_workspace",
                structure=mdls.ProjectWorkspace,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get All Project Files
    #
    # Returns a list of the files in the project
    #
    # GET /projects/{project_id}/files -> Sequence[mdls.ProjectFile]
    def all_project_files(
        self,
        # Project Id
        project_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ProjectFile]:
        """Get All Project Files"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            Sequence[mdls.ProjectFile],
            self.get(
                path=f"/projects/{project_id}/files",
                structure=Sequence[mdls.ProjectFile],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Project File Info
    #
    # Returns information about a file in the project
    #
    # GET /projects/{project_id}/files/file -> mdls.ProjectFile
    def project_file(
        self,
        # Project Id
        project_id: str,
        # File Id
        file_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ProjectFile:
        """Get Project File"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.ProjectFile,
            self.get(
                path=f"/projects/{project_id}/files/file",
                structure=mdls.ProjectFile,
                query_params={"file_id": file_id, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get All Git Connection Tests
    #
    # dev mode required.
    #   - Call `update_session` to select the 'dev' workspace.
    #
    # Returns a list of tests which can be run against a project's (or the dependency project for the provided remote_url) git connection. Call [Run Git Connection Test](#!/Project/run_git_connection_test) to execute each test in sequence.
    #
    # Tests are ordered by increasing specificity. Tests should be run in the order returned because later tests require functionality tested by tests earlier in the test list.
    #
    # For example, a late-stage test for write access is meaningless if connecting to the git server (an early test) is failing.
    #
    # GET /projects/{project_id}/git_connection_tests -> Sequence[mdls.GitConnectionTest]
    def all_git_connection_tests(
        self,
        # Project Id
        project_id: str,
        # (Optional: leave blank for root project) The remote url for remote dependency to test.
        remote_url: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.GitConnectionTest]:
        """Get All Git Connection Tests"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            Sequence[mdls.GitConnectionTest],
            self.get(
                path=f"/projects/{project_id}/git_connection_tests",
                structure=Sequence[mdls.GitConnectionTest],
                query_params={"remote_url": remote_url},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run a git connection test
    #
    # Run the named test on the git service used by this project (or the dependency project for the provided remote_url) and return the result. This
    # is intended to help debug git connections when things do not work properly, to give
    # more helpful information about why a git url is not working with Looker.
    #
    # Tests should be run in the order they are returned by [Get All Git Connection Tests](#!/Project/all_git_connection_tests).
    #
    # GET /projects/{project_id}/git_connection_tests/{test_id} -> mdls.GitConnectionTestResult
    def run_git_connection_test(
        self,
        # Project Id
        project_id: str,
        # Test Id
        test_id: str,
        # (Optional: leave blank for root project) The remote url for remote dependency to test.
        remote_url: Optional[str] = None,
        # (Optional: leave blank for dev credentials) Whether to use git production credentials.
        use_production: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.GitConnectionTestResult:
        """Run Git Connection Test"""
        project_id = self.encode_path_param(project_id)
        test_id = self.encode_path_param(test_id)
        response = cast(
            mdls.GitConnectionTestResult,
            self.get(
                path=f"/projects/{project_id}/git_connection_tests/{test_id}",
                structure=mdls.GitConnectionTestResult,
                query_params={
                    "remote_url": remote_url,
                    "use_production": use_production,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get All LookML Tests
    #
    # Returns a list of tests which can be run to validate a project's LookML code and/or the underlying data,
    # optionally filtered by the file id.
    # Call [Run LookML Test](#!/Project/run_lookml_test) to execute tests.
    #
    # GET /projects/{project_id}/lookml_tests -> Sequence[mdls.LookmlTest]
    def all_lookml_tests(
        self,
        # Project Id
        project_id: str,
        # File Id
        file_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.LookmlTest]:
        """Get All LookML Tests"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            Sequence[mdls.LookmlTest],
            self.get(
                path=f"/projects/{project_id}/lookml_tests",
                structure=Sequence[mdls.LookmlTest],
                query_params={"file_id": file_id},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run LookML Tests
    #
    # Runs all tests in the project, optionally filtered by file, test, and/or model.
    #
    # GET /projects/{project_id}/lookml_tests/run -> Sequence[mdls.LookmlTestResult]
    def run_lookml_test(
        self,
        # Project Id
        project_id: str,
        # File Name
        file_id: Optional[str] = None,
        # Test Name
        test: Optional[str] = None,
        # Model Name
        model: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.LookmlTestResult]:
        """Run LookML Test"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            Sequence[mdls.LookmlTestResult],
            self.get(
                path=f"/projects/{project_id}/lookml_tests/run",
                structure=Sequence[mdls.LookmlTestResult],
                query_params={"file_id": file_id, "test": test, "model": model},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Creates a tag for the most recent commit, or a specific ref is a SHA is provided
    #
    # This is an internal-only, undocumented route.
    #
    # POST /projects/{project_id}/tag -> mdls.Project
    def tag_ref(
        self,
        # Project Id
        project_id: str,
        body: mdls.WriteProject,
        # (Optional): Commit Sha to Tag
        commit_sha: Optional[str] = None,
        # Tag Name
        tag_name: Optional[str] = None,
        # (Optional): Tag Message
        tag_message: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Project:
        """Tag Ref"""
        project_id = self.encode_path_param(project_id)
        response = cast(
            mdls.Project,
            self.post(
                path=f"/projects/{project_id}/tag",
                structure=mdls.Project,
                query_params={
                    "commit_sha": commit_sha,
                    "tag_name": tag_name,
                    "tag_message": tag_message,
                },
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Configure Repository Credential for a remote dependency
    #
    # Admin required.
    #
    # `root_project_id` is required.
    # `credential_id` is required.
    #
    # PUT /projects/{root_project_id}/credential/{credential_id} -> mdls.RepositoryCredential
    def update_repository_credential(
        self,
        # Root Project Id
        root_project_id: str,
        # Credential Id
        credential_id: str,
        body: mdls.WriteRepositoryCredential,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.RepositoryCredential:
        """Create Repository Credential"""
        root_project_id = self.encode_path_param(root_project_id)
        credential_id = self.encode_path_param(credential_id)
        response = cast(
            mdls.RepositoryCredential,
            self.put(
                path=f"/projects/{root_project_id}/credential/{credential_id}",
                structure=mdls.RepositoryCredential,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Repository Credential for a remote dependency
    #
    # Admin required.
    #
    # `root_project_id` is required.
    # `credential_id` is required.
    #
    # DELETE /projects/{root_project_id}/credential/{credential_id} -> str
    def delete_repository_credential(
        self,
        # Root Project Id
        root_project_id: str,
        # Credential Id
        credential_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Repository Credential"""
        root_project_id = self.encode_path_param(root_project_id)
        credential_id = self.encode_path_param(credential_id)
        response = cast(
            str,
            self.delete(
                path=f"/projects/{root_project_id}/credential/{credential_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get all Repository Credentials for a project
    #
    # `root_project_id` is required.
    #
    # GET /projects/{root_project_id}/credentials -> Sequence[mdls.RepositoryCredential]
    def get_all_repository_credentials(
        self,
        # Root Project Id
        root_project_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.RepositoryCredential]:
        """Get All Repository Credentials"""
        root_project_id = self.encode_path_param(root_project_id)
        response = cast(
            Sequence[mdls.RepositoryCredential],
            self.get(
                path=f"/projects/{root_project_id}/credentials",
                structure=Sequence[mdls.RepositoryCredential],
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Query: Run and Manage Queries

    # ### Create an async query task
    #
    # Creates a query task (job) to run a previously created query asynchronously. Returns a Query Task ID.
    #
    # Use [query_task(query_task_id)](#!/Query/query_task) to check the execution status of the query task.
    # After the query task status reaches "Complete", use [query_task_results(query_task_id)](#!/Query/query_task_results) to fetch the results of the query.
    #
    # POST /query_tasks -> mdls.QueryTask
    def create_query_task(
        self,
        body: mdls.WriteCreateQueryTask,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode. Note that this flag being false does not guarantee development models will be used.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        # DEPRECATED. Render width for image formats. Note that this parameter is always ignored by this method.
        image_width: Optional[int] = None,
        # DEPRECATED. Render height for image formats. Note that this parameter is always ignored by this method.
        image_height: Optional[int] = None,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.QueryTask:
        """Run Query Async"""
        response = cast(
            mdls.QueryTask,
            self.post(
                path="/query_tasks",
                structure=mdls.QueryTask,
                query_params={
                    "limit": limit,
                    "apply_formatting": apply_formatting,
                    "apply_vis": apply_vis,
                    "cache": cache,
                    "generate_drill_links": generate_drill_links,
                    "force_production": force_production,
                    "cache_only": cache_only,
                    "path_prefix": path_prefix,
                    "rebuild_pdts": rebuild_pdts,
                    "server_table_calcs": server_table_calcs,
                    "image_width": image_width,
                    "image_height": image_height,
                    "fields": fields,
                },
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Fetch results of multiple async queries
    #
    # Returns the results of multiple async queries in one request.
    #
    # For Query Tasks that are not completed, the response will include the execution status of the Query Task but will not include query results.
    # Query Tasks whose results have expired will have a status of 'expired'.
    # If the user making the API request does not have sufficient privileges to view a Query Task result, the result will have a status of 'missing'
    #
    # GET /query_tasks/multi_results -> MutableMapping[str, Any]
    def query_task_multi_results(
        self,
        # List of Query Task IDs
        query_task_ids: mdls.DelimSequence[str],
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> MutableMapping[str, Any]:
        """Get Multiple Async Query Results"""
        response = cast(
            MutableMapping[str, Any],
            self.get(
                path="/query_tasks/multi_results",
                structure=MutableMapping[str, Any],
                query_params={"query_task_ids": query_task_ids},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Query Task details
    #
    # Use this function to check the status of an async query task. After the status
    # reaches "Complete", you can call [query_task_results(query_task_id)](#!/Query/query_task_results) to
    # retrieve the results of the query.
    #
    # Use [create_query_task()](#!/Query/create_query_task) to create an async query task.
    #
    # GET /query_tasks/{query_task_id} -> mdls.QueryTask
    def query_task(
        self,
        # ID of the Query Task
        query_task_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.QueryTask:
        """Get Async Query Info"""
        query_task_id = self.encode_path_param(query_task_id)
        response = cast(
            mdls.QueryTask,
            self.get(
                path=f"/query_tasks/{query_task_id}",
                structure=mdls.QueryTask,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Async Query Results
    #
    # Returns the results of an async query task if the query has completed.
    #
    # If the query task is still running or waiting to run, this function returns 204 No Content.
    #
    # If the query task ID is invalid or the cached results of the query task have expired, this function returns 404 Not Found.
    #
    # Use [query_task(query_task_id)](#!/Query/query_task) to check the execution status of the query task
    # Call query_task_results only after the query task status reaches "Complete".
    #
    # You can also use [query_task_multi_results()](#!/Query/query_task_multi_results) retrieve the
    # results of multiple async query tasks at the same time.
    #
    # #### SQL Error Handling:
    # If the query fails due to a SQL db error, how this is communicated depends on the result_format you requested in `create_query_task()`.
    #
    # For `json_detail` result_format: `query_task_results()` will respond with HTTP status '200 OK' and db SQL error info
    # will be in the `errors` property of the response object. The 'data' property will be empty.
    #
    # For all other result formats: `query_task_results()` will respond with HTTP status `400 Bad Request` and some db SQL error info
    # will be in the message of the 400 error response, but not as detailed as expressed in `json_detail.errors`.
    # These data formats can only carry row data, and error info is not row data.
    #
    # GET /query_tasks/{query_task_id}/results -> str
    def query_task_results(
        self,
        # ID of the Query Task
        query_task_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Get Async Query Results"""
        query_task_id = self.encode_path_param(query_task_id)
        response = cast(
            str,
            self.get(
                path=f"/query_tasks/{query_task_id}/results",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a previously created query by id.
    #
    # A Looker query object includes the various parameters that define a database query that has been run or
    # could be run in the future. These parameters include: model, view, fields, filters, pivots, etc.
    # Query *results* are not part of the query object.
    #
    # Query objects are unique and immutable. Query objects are created automatically in Looker as users explore data.
    # Looker does not delete them; they become part of the query history. When asked to create a query for
    # any given set of parameters, Looker will first try to find an existing query object with matching
    # parameters and will only create a new object when an appropriate object can not be found.
    #
    # This 'get' method is used to get the details about a query for a given id. See the other methods here
    # to 'create' and 'run' queries.
    #
    # Note that some fields like 'filter_config' and 'vis_config' etc are specific to how the Looker UI
    # builds queries and visualizations and are not generally useful for API use. They are not required when
    # creating new queries and can usually just be ignored.
    #
    # GET /queries/{query_id} -> mdls.Query
    def query(
        self,
        # Id of query
        query_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Query:
        """Get Query"""
        query_id = self.encode_path_param(query_id)
        response = cast(
            mdls.Query,
            self.get(
                path=f"/queries/{query_id}",
                structure=mdls.Query,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the query for a given query slug.
    #
    # This returns the query for the 'slug' in a query share URL.
    #
    # The 'slug' is a randomly chosen short string that is used as an alternative to the query's id value
    # for use in URLs etc. This method exists as a convenience to help you use the API to 'find' queries that
    # have been created using the Looker UI.
    #
    # You can use the Looker explore page to build a query and then choose the 'Share' option to
    # show the share url for the query. Share urls generally look something like 'https://looker.yourcompany/x/vwGSbfc'.
    # The trailing 'vwGSbfc' is the share slug. You can pass that string to this api method to get details about the query.
    # Those details include the 'id' that you can use to run the query. Or, you can copy the query body
    # (perhaps with your own modification) and use that as the basis to make/run new queries.
    #
    # This will also work with slugs from Looker explore urls like
    # 'https://looker.yourcompany/explore/ecommerce/orders?qid=aogBgL6o3cKK1jN3RoZl5s'. In this case
    # 'aogBgL6o3cKK1jN3RoZl5s' is the slug.
    #
    # GET /queries/slug/{slug} -> mdls.Query
    def query_for_slug(
        self,
        # Slug of query
        slug: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Query:
        """Get Query for Slug"""
        slug = self.encode_path_param(slug)
        response = cast(
            mdls.Query,
            self.get(
                path=f"/queries/slug/{slug}",
                structure=mdls.Query,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a query.
    #
    # This allows you to create a new query that you can later run. Looker queries are immutable once created
    # and are not deleted. If you create a query that is exactly like an existing query then the existing query
    # will be returned and no new query will be created. Whether a new query is created or not, you can use
    # the 'id' in the returned query with the 'run' method.
    #
    # The query parameters are passed as json in the body of the request.
    #
    # POST /queries -> mdls.Query
    def create_query(
        self,
        body: mdls.WriteQuery,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Query:
        """Create Query"""
        response = cast(
            mdls.Query,
            self.post(
                path="/queries",
                structure=mdls.Query,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run a saved query.
    #
    # This runs a previously saved query. You can use this on a query that was generated in the Looker UI
    # or one that you have explicitly created using the API. You can also use a query 'id' from a saved 'Look'.
    #
    # The 'result_format' parameter specifies the desired structure and format of the response.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # GET /queries/{query_id}/run/{result_format} -> Union[str, bytes]
    def run_query(
        self,
        # Id of query
        query_id: str,
        # Format of result
        result_format: str,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode. Note that this flag being false does not guarantee development models will be used.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        # Specifies the source of this call.
        source: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Union[str, bytes]:
        """Run Query"""
        query_id = self.encode_path_param(query_id)
        result_format = self.encode_path_param(result_format)
        response = cast(
            Union[str, bytes],
            self.get(
                path=f"/queries/{query_id}/run/{result_format}",
                structure=Union[str, bytes],  # type: ignore
                query_params={
                    "limit": limit,
                    "apply_formatting": apply_formatting,
                    "apply_vis": apply_vis,
                    "cache": cache,
                    "image_width": image_width,
                    "image_height": image_height,
                    "generate_drill_links": generate_drill_links,
                    "force_production": force_production,
                    "cache_only": cache_only,
                    "path_prefix": path_prefix,
                    "rebuild_pdts": rebuild_pdts,
                    "server_table_calcs": server_table_calcs,
                    "source": source,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run the query that is specified inline in the posted body.
    #
    # This allows running a query as defined in json in the posted body. This combines
    # the two actions of posting & running a query into one step.
    #
    # Here is an example body in json:
    # ```
    # {
    #   "model":"thelook",
    #   "view":"inventory_items",
    #   "fields":["category.name","inventory_items.days_in_inventory_tier","products.count"],
    #   "filters":{"category.name":"socks"},
    #   "sorts":["products.count desc 0"],
    #   "limit":"500",
    #   "query_timezone":"America/Los_Angeles"
    # }
    # ```
    #
    # When using the Ruby SDK this would be passed as a Ruby hash like:
    # ```
    # {
    #  :model=>"thelook",
    #  :view=>"inventory_items",
    #  :fields=>
    #   ["category.name",
    #    "inventory_items.days_in_inventory_tier",
    #    "products.count"],
    #  :filters=>{:"category.name"=>"socks"},
    #  :sorts=>["products.count desc 0"],
    #  :limit=>"500",
    #  :query_timezone=>"America/Los_Angeles",
    # }
    # ```
    #
    # This will return the result of running the query in the format specified by the 'result_format' parameter.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # POST /queries/run/{result_format} -> Union[str, bytes]
    def run_inline_query(
        self,
        # Format of result
        result_format: str,
        body: mdls.WriteQuery,
        # Row limit (may override the limit in the saved query).
        limit: Optional[int] = None,
        # Apply model-specified formatting to each result.
        apply_formatting: Optional[bool] = None,
        # Apply visualization options to results.
        apply_vis: Optional[bool] = None,
        # Get results from cache if available.
        cache: Optional[bool] = None,
        # Render width for image formats.
        image_width: Optional[int] = None,
        # Render height for image formats.
        image_height: Optional[int] = None,
        # Generate drill links (only applicable to 'json_detail' format.
        generate_drill_links: Optional[bool] = None,
        # Force use of production models even if the user is in development mode. Note that this flag being false does not guarantee development models will be used.
        force_production: Optional[bool] = None,
        # Retrieve any results from cache even if the results have expired.
        cache_only: Optional[bool] = None,
        # Prefix to use for drill links (url encoded).
        path_prefix: Optional[str] = None,
        # Rebuild PDTS used in query.
        rebuild_pdts: Optional[bool] = None,
        # Perform table calculations on query results
        server_table_calcs: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Union[str, bytes]:
        """Run Inline Query"""
        result_format = self.encode_path_param(result_format)
        response = cast(
            Union[str, bytes],
            self.post(
                path=f"/queries/run/{result_format}",
                structure=Union[str, bytes],  # type: ignore
                query_params={
                    "limit": limit,
                    "apply_formatting": apply_formatting,
                    "apply_vis": apply_vis,
                    "cache": cache,
                    "image_width": image_width,
                    "image_height": image_height,
                    "generate_drill_links": generate_drill_links,
                    "force_production": force_production,
                    "cache_only": cache_only,
                    "path_prefix": path_prefix,
                    "rebuild_pdts": rebuild_pdts,
                    "server_table_calcs": server_table_calcs,
                },
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run an URL encoded query.
    #
    # This requires the caller to encode the specifiers for the query into the URL query part using
    # Looker-specific syntax as explained below.
    #
    # Generally, you would want to use one of the methods that takes the parameters as json in the POST body
    # for creating and/or running queries. This method exists for cases where one really needs to encode the
    # parameters into the URL of a single 'GET' request. This matches the way that the Looker UI formats
    # 'explore' URLs etc.
    #
    # The parameters here are very similar to the json body formatting except that the filter syntax is
    # tricky. Unfortunately, this format makes this method not currently callable via the 'Try it out!' button
    # in this documentation page. But, this is callable when creating URLs manually or when using the Looker SDK.
    #
    # Here is an example inline query URL:
    #
    # ```
    # https://looker.mycompany.com:19999/api/3.0/queries/models/thelook/views/inventory_items/run/json?fields=category.name,inventory_items.days_in_inventory_tier,products.count&f[category.name]=socks&sorts=products.count+desc+0&limit=500&query_timezone=America/Los_Angeles
    # ```
    #
    # When invoking this endpoint with the Ruby SDK, pass the query parameter parts as a hash. The hash to match the above would look like:
    #
    # ```ruby
    # query_params =
    # {
    #   fields: "category.name,inventory_items.days_in_inventory_tier,products.count",
    #   :"f[category.name]" => "socks",
    #   sorts: "products.count desc 0",
    #   limit: "500",
    #   query_timezone: "America/Los_Angeles"
    # }
    # response = ruby_sdk.run_url_encoded_query('thelook','inventory_items','json', query_params)
    #
    # ```
    #
    # Again, it is generally easier to use the variant of this method that passes the full query in the POST body.
    # This method is available for cases where other alternatives won't fit the need.
    #
    # Supported formats:
    #
    # | result_format | Description
    # | :-----------: | :--- |
    # | json | Plain json
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | md | Simple markdown
    # | xlsx | MS Excel spreadsheet
    # | sql | Returns the generated SQL rather than running the query
    # | png | A PNG image of the visualization of the query
    # | jpg | A JPG image of the visualization of the query
    #
    # GET /queries/models/{model_name}/views/{view_name}/run/{result_format} -> Union[str, bytes]
    def run_url_encoded_query(
        self,
        # Model name
        model_name: str,
        # View name
        view_name: str,
        # Format of result
        result_format: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Union[str, bytes]:
        """Run Url Encoded Query"""
        model_name = self.encode_path_param(model_name)
        view_name = self.encode_path_param(view_name)
        result_format = self.encode_path_param(result_format)
        response = cast(
            Union[str, bytes],
            self.get(
                path=f"/queries/models/{model_name}/views/{view_name}/run/{result_format}",
                structure=Union[str, bytes],  # type: ignore
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Merge Query
    #
    # Returns a merge query object given its id.
    #
    # GET /merge_queries/{merge_query_id} -> mdls.MergeQuery
    def merge_query(
        self,
        # Merge Query Id
        merge_query_id: str,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MergeQuery:
        """Get Merge Query"""
        merge_query_id = self.encode_path_param(merge_query_id)
        response = cast(
            mdls.MergeQuery,
            self.get(
                path=f"/merge_queries/{merge_query_id}",
                structure=mdls.MergeQuery,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create Merge Query
    #
    # Creates a new merge query object.
    #
    # A merge query takes the results of one or more queries and combines (merges) the results
    # according to field mapping definitions. The result is similar to a SQL left outer join.
    #
    # A merge query can merge results of queries from different SQL databases.
    #
    # The order that queries are defined in the source_queries array property is significant. The
    # first query in the array defines the primary key into which the results of subsequent
    # queries will be merged.
    #
    # Like model/view query objects, merge queries are immutable and have structural identity - if
    # you make a request to create a new merge query that is identical to an existing merge query,
    # the existing merge query will be returned instead of creating a duplicate. Conversely, any
    # change to the contents of a merge query will produce a new object with a new id.
    #
    # POST /merge_queries -> mdls.MergeQuery
    def create_merge_query(
        self,
        body: Optional[mdls.WriteMergeQuery] = None,
        # Requested fields
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.MergeQuery:
        """Create Merge Query"""
        response = cast(
            mdls.MergeQuery,
            self.post(
                path="/merge_queries",
                structure=mdls.MergeQuery,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # Get information about all running queries.
    #
    # GET /running_queries -> Sequence[mdls.RunningQueries]
    def all_running_queries(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.RunningQueries]:
        """Get All Running Queries"""
        response = cast(
            Sequence[mdls.RunningQueries],
            self.get(
                path="/running_queries",
                structure=Sequence[mdls.RunningQueries],
                transport_options=transport_options,
            ),
        )
        return response

    # Kill a query with a specific query_task_id.
    #
    # DELETE /running_queries/{query_task_id} -> str
    def kill_query(
        self,
        # Query task id.
        query_task_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Kill Running Query"""
        query_task_id = self.encode_path_param(query_task_id)
        response = cast(
            str,
            self.delete(
                path=f"/running_queries/{query_task_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # Get a SQL Runner query.
    #
    # GET /sql_queries/{slug} -> mdls.SqlQuery
    def sql_query(
        self,
        # slug of query
        slug: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SqlQuery:
        """Get SQL Runner Query"""
        slug = self.encode_path_param(slug)
        response = cast(
            mdls.SqlQuery,
            self.get(
                path=f"/sql_queries/{slug}",
                structure=mdls.SqlQuery,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a SQL Runner Query
    #
    # Either the `connection_name` or `model_name` parameter MUST be provided.
    #
    # POST /sql_queries -> mdls.SqlQuery
    def create_sql_query(
        self,
        body: mdls.SqlQueryCreate,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.SqlQuery:
        """Create SQL Runner Query"""
        response = cast(
            mdls.SqlQuery,
            self.post(
                path="/sql_queries",
                structure=mdls.SqlQuery,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # Execute a SQL Runner query in a given result_format.
    #
    # POST /sql_queries/{slug}/run/{result_format} -> Union[str, bytes]
    def run_sql_query(
        self,
        # slug of query
        slug: str,
        # Format of result, options are: ["inline_json", "json", "json_detail", "json_fe", "csv", "html", "md", "txt", "xlsx", "gsxml", "json_label"]
        result_format: str,
        # Defaults to false. If set to true, the HTTP response will have content-disposition and other headers set to make the HTTP response behave as a downloadable attachment instead of as inline content.
        download: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Union[str, bytes]:
        """Run SQL Runner Query"""
        slug = self.encode_path_param(slug)
        result_format = self.encode_path_param(result_format)
        response = cast(
            Union[str, bytes],
            self.post(
                path=f"/sql_queries/{slug}/run/{result_format}",
                structure=Union[str, bytes],  # type: ignore
                query_params={"download": download},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region RenderTask: Manage Render Tasks

    # ### Create a new task to render a look to an image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/looks/{look_id}/{result_format} -> mdls.RenderTask
    def create_look_render_task(
        self,
        # Id of look to render
        look_id: str,
        # Output type: png, or jpg
        result_format: str,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.RenderTask:
        """Create Look Render Task"""
        look_id = self.encode_path_param(look_id)
        result_format = self.encode_path_param(result_format)
        response = cast(
            mdls.RenderTask,
            self.post(
                path=f"/render_tasks/looks/{look_id}/{result_format}",
                structure=mdls.RenderTask,
                query_params={"width": width, "height": height, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new task to render an existing query to an image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/queries/{query_id}/{result_format} -> mdls.RenderTask
    def create_query_render_task(
        self,
        # Id of the query to render
        query_id: str,
        # Output type: png or jpg
        result_format: str,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.RenderTask:
        """Create Query Render Task"""
        query_id = self.encode_path_param(query_id)
        result_format = self.encode_path_param(result_format)
        response = cast(
            mdls.RenderTask,
            self.post(
                path=f"/render_tasks/queries/{query_id}/{result_format}",
                structure=mdls.RenderTask,
                query_params={"width": width, "height": height, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new task to render a dashboard to a document or image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/dashboards/{dashboard_id}/{result_format} -> mdls.RenderTask
    def create_dashboard_render_task(
        self,
        # Id of dashboard to render. The ID can be a LookML dashboard also.
        dashboard_id: str,
        # Output type: pdf, png, or jpg
        result_format: str,
        body: mdls.CreateDashboardRenderTask,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        # Paper size for pdf. Value can be one of: ["letter","legal","tabloid","a0","a1","a2","a3","a4","a5"]
        pdf_paper_size: Optional[str] = None,
        # Whether to render pdf in landscape paper orientation
        pdf_landscape: Optional[bool] = None,
        # Whether or not to expand table vis to full length
        long_tables: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.RenderTask:
        """Create Dashboard Render Task"""
        dashboard_id = self.encode_path_param(dashboard_id)
        result_format = self.encode_path_param(result_format)
        response = cast(
            mdls.RenderTask,
            self.post(
                path=f"/render_tasks/dashboards/{dashboard_id}/{result_format}",
                structure=mdls.RenderTask,
                query_params={
                    "width": width,
                    "height": height,
                    "fields": fields,
                    "pdf_paper_size": pdf_paper_size,
                    "pdf_landscape": pdf_landscape,
                    "long_tables": long_tables,
                },
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a render task.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # GET /render_tasks/{render_task_id} -> mdls.RenderTask
    def render_task(
        self,
        # Id of render task
        render_task_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.RenderTask:
        """Get Render Task"""
        render_task_id = self.encode_path_param(render_task_id)
        response = cast(
            mdls.RenderTask,
            self.get(
                path=f"/render_tasks/{render_task_id}",
                structure=mdls.RenderTask,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the document or image produced by a completed render task.
    #
    # Note that the PDF or image result will be a binary blob in the HTTP response, as indicated by the
    # Content-Type in the response headers. This may require specialized (or at least different) handling than text
    # responses such as JSON. You may need to tell your HTTP client that the response is binary so that it does not
    # attempt to parse the binary data as text.
    #
    # If the render task exists but has not finished rendering the results, the response HTTP status will be
    # **202 Accepted**, the response body will be empty, and the response will have a Retry-After header indicating
    # that the caller should repeat the request at a later time.
    #
    # Returns 404 if the render task cannot be found, if the cached result has expired, or if the caller
    # does not have permission to view the results.
    #
    # For detailed information about the status of the render task, use [Render Task](#!/RenderTask/render_task).
    # Polling loops waiting for completion of a render task would be better served by polling **render_task(id)** until
    # the task status reaches completion (or error) instead of polling **render_task_results(id)** alone.
    #
    # GET /render_tasks/{render_task_id}/results -> bytes
    def render_task_results(
        self,
        # Id of render task
        render_task_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> bytes:
        """Render Task Results"""
        render_task_id = self.encode_path_param(render_task_id)
        response = cast(
            bytes,
            self.get(
                path=f"/render_tasks/{render_task_id}/results",
                structure=bytes,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new task to render a dashboard element to an image.
    #
    # Returns a render task object.
    # To check the status of a render task, pass the render_task.id to [Get Render Task](#!/RenderTask/get_render_task).
    # Once the render task is complete, you can download the resulting document or image using [Get Render Task Results](#!/RenderTask/get_render_task_results).
    #
    # POST /render_tasks/dashboard_elements/{dashboard_element_id}/{result_format} -> mdls.RenderTask
    def create_dashboard_element_render_task(
        self,
        # Id of dashboard element to render: UDD dashboard element would be numeric and LookML dashboard element would be model_name::dashboard_title::lookml_link_id
        dashboard_element_id: str,
        # Output type: png or jpg
        result_format: str,
        # Output width in pixels
        width: int,
        # Output height in pixels
        height: int,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.RenderTask:
        """Create Dashboard Element Render Task"""
        dashboard_element_id = self.encode_path_param(dashboard_element_id)
        result_format = self.encode_path_param(result_format)
        response = cast(
            mdls.RenderTask,
            self.post(
                path=f"/render_tasks/dashboard_elements/{dashboard_element_id}/{result_format}",
                structure=mdls.RenderTask,
                query_params={"width": width, "height": height, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Role: Manage Roles

    # ### Search model sets
    # Returns all model set records that match the given search criteria.
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /model_sets/search -> Sequence[mdls.ModelSet]
    def search_model_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match model set id.
        id: Optional[str] = None,
        # Match model set name.
        name: Optional[str] = None,
        # Match model sets by all_access status.
        all_access: Optional[bool] = None,
        # Match model sets by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ModelSet]:
        """Search Model Sets"""
        response = cast(
            Sequence[mdls.ModelSet],
            self.get(
                path="/model_sets/search",
                structure=Sequence[mdls.ModelSet],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "name": name,
                    "all_access": all_access,
                    "built_in": built_in,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the model set with a specific id.
    #
    # GET /model_sets/{model_set_id} -> mdls.ModelSet
    def model_set(
        self,
        # Id of model set
        model_set_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ModelSet:
        """Get Model Set"""
        model_set_id = self.encode_path_param(model_set_id)
        response = cast(
            mdls.ModelSet,
            self.get(
                path=f"/model_sets/{model_set_id}",
                structure=mdls.ModelSet,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update information about the model set with a specific id.
    #
    # PATCH /model_sets/{model_set_id} -> mdls.ModelSet
    def update_model_set(
        self,
        # id of model set
        model_set_id: str,
        body: mdls.WriteModelSet,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ModelSet:
        """Update Model Set"""
        model_set_id = self.encode_path_param(model_set_id)
        response = cast(
            mdls.ModelSet,
            self.patch(
                path=f"/model_sets/{model_set_id}",
                structure=mdls.ModelSet,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the model set with a specific id.
    #
    # DELETE /model_sets/{model_set_id} -> str
    def delete_model_set(
        self,
        # id of model set
        model_set_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Model Set"""
        model_set_id = self.encode_path_param(model_set_id)
        response = cast(
            str,
            self.delete(
                path=f"/model_sets/{model_set_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all model sets.
    #
    # GET /model_sets -> Sequence[mdls.ModelSet]
    def all_model_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ModelSet]:
        """Get All Model Sets"""
        response = cast(
            Sequence[mdls.ModelSet],
            self.get(
                path="/model_sets",
                structure=Sequence[mdls.ModelSet],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a model set with the specified information. Model sets are used by Roles.
    #
    # POST /model_sets -> mdls.ModelSet
    def create_model_set(
        self,
        body: mdls.WriteModelSet,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ModelSet:
        """Create Model Set"""
        response = cast(
            mdls.ModelSet,
            self.post(
                path="/model_sets",
                structure=mdls.ModelSet,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get all supported permissions.
    #
    # GET /permissions -> Sequence[mdls.Permission]
    def all_permissions(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Permission]:
        """Get All Permissions"""
        response = cast(
            Sequence[mdls.Permission],
            self.get(
                path="/permissions",
                structure=Sequence[mdls.Permission],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search permission sets
    # Returns all permission set records that match the given search criteria.
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /permission_sets/search -> Sequence[mdls.PermissionSet]
    def search_permission_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match permission set id.
        id: Optional[str] = None,
        # Match permission set name.
        name: Optional[str] = None,
        # Match permission sets by all_access status.
        all_access: Optional[bool] = None,
        # Match permission sets by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.PermissionSet]:
        """Search Permission Sets"""
        response = cast(
            Sequence[mdls.PermissionSet],
            self.get(
                path="/permission_sets/search",
                structure=Sequence[mdls.PermissionSet],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "name": name,
                    "all_access": all_access,
                    "built_in": built_in,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the permission set with a specific id.
    #
    # GET /permission_sets/{permission_set_id} -> mdls.PermissionSet
    def permission_set(
        self,
        # Id of permission set
        permission_set_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.PermissionSet:
        """Get Permission Set"""
        permission_set_id = self.encode_path_param(permission_set_id)
        response = cast(
            mdls.PermissionSet,
            self.get(
                path=f"/permission_sets/{permission_set_id}",
                structure=mdls.PermissionSet,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update information about the permission set with a specific id.
    #
    # PATCH /permission_sets/{permission_set_id} -> mdls.PermissionSet
    def update_permission_set(
        self,
        # Id of permission set
        permission_set_id: str,
        body: mdls.WritePermissionSet,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.PermissionSet:
        """Update Permission Set"""
        permission_set_id = self.encode_path_param(permission_set_id)
        response = cast(
            mdls.PermissionSet,
            self.patch(
                path=f"/permission_sets/{permission_set_id}",
                structure=mdls.PermissionSet,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the permission set with a specific id.
    #
    # DELETE /permission_sets/{permission_set_id} -> str
    def delete_permission_set(
        self,
        # Id of permission set
        permission_set_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Permission Set"""
        permission_set_id = self.encode_path_param(permission_set_id)
        response = cast(
            str,
            self.delete(
                path=f"/permission_sets/{permission_set_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all permission sets.
    #
    # GET /permission_sets -> Sequence[mdls.PermissionSet]
    def all_permission_sets(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.PermissionSet]:
        """Get All Permission Sets"""
        response = cast(
            Sequence[mdls.PermissionSet],
            self.get(
                path="/permission_sets",
                structure=Sequence[mdls.PermissionSet],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a permission set with the specified information. Permission sets are used by Roles.
    #
    # POST /permission_sets -> mdls.PermissionSet
    def create_permission_set(
        self,
        body: mdls.WritePermissionSet,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.PermissionSet:
        """Create Permission Set"""
        response = cast(
            mdls.PermissionSet,
            self.post(
                path="/permission_sets",
                structure=mdls.PermissionSet,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all roles.
    #
    # GET /roles -> Sequence[mdls.Role]
    def all_roles(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Optional list of ids to get specific roles.
        ids: Optional[mdls.DelimSequence[str]] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Role]:
        """Get All Roles"""
        response = cast(
            Sequence[mdls.Role],
            self.get(
                path="/roles",
                structure=Sequence[mdls.Role],
                query_params={"fields": fields, "ids": ids},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a role with the specified information.
    #
    # POST /roles -> mdls.Role
    def create_role(
        self,
        body: mdls.WriteRole,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Role:
        """Create Role"""
        response = cast(
            mdls.Role,
            self.post(
                path="/roles",
                structure=mdls.Role,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search roles
    #
    # Returns all role records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /roles/search -> Sequence[mdls.Role]
    def search_roles(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match role id.
        id: Optional[str] = None,
        # Match role name.
        name: Optional[str] = None,
        # Match roles by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Role]:
        """Search Roles"""
        response = cast(
            Sequence[mdls.Role],
            self.get(
                path="/roles/search",
                structure=Sequence[mdls.Role],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "name": name,
                    "built_in": built_in,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search roles include user count
    #
    # Returns all role records that match the given search criteria, and attaches
    # associated user counts.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /roles/search/with_user_count -> Sequence[mdls.RoleSearch]
    def search_roles_with_user_count(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match role id.
        id: Optional[str] = None,
        # Match role name.
        name: Optional[str] = None,
        # Match roles by built_in status.
        built_in: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.RoleSearch]:
        """Search Roles with User Count"""
        response = cast(
            Sequence[mdls.RoleSearch],
            self.get(
                path="/roles/search/with_user_count",
                structure=Sequence[mdls.RoleSearch],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "name": name,
                    "built_in": built_in,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the role with a specific id.
    #
    # GET /roles/{role_id} -> mdls.Role
    def role(
        self,
        # id of role
        role_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Role:
        """Get Role"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            mdls.Role,
            self.get(
                path=f"/roles/{role_id}",
                structure=mdls.Role,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update information about the role with a specific id.
    #
    # PATCH /roles/{role_id} -> mdls.Role
    def update_role(
        self,
        # id of role
        role_id: str,
        body: mdls.WriteRole,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Role:
        """Update Role"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            mdls.Role,
            self.patch(
                path=f"/roles/{role_id}",
                structure=mdls.Role,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the role with a specific id.
    #
    # DELETE /roles/{role_id} -> str
    def delete_role(
        self,
        # id of role
        role_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Role"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            str,
            self.delete(
                path=f"/roles/{role_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the groups with the role that has a specific id.
    #
    # GET /roles/{role_id}/groups -> Sequence[mdls.Group]
    def role_groups(
        self,
        # id of role
        role_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Group]:
        """Get Role Groups"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            Sequence[mdls.Group],
            self.get(
                path=f"/roles/{role_id}/groups",
                structure=Sequence[mdls.Group],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set all groups for a role, removing all existing group associations from that role.
    #
    # PUT /roles/{role_id}/groups -> Sequence[mdls.Group]
    def set_role_groups(
        self,
        # id of role
        role_id: str,
        body: Sequence[str],
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Group]:
        """Update Role Groups"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            Sequence[mdls.Group],
            self.put(
                path=f"/roles/{role_id}/groups",
                structure=Sequence[mdls.Group],
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all the users with the role that has a specific id.
    #
    # GET /roles/{role_id}/users -> Sequence[mdls.User]
    def role_users(
        self,
        # id of role
        role_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Get only users associated directly with the role: exclude those only associated through groups.
        direct_association_only: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.User]:
        """Get Role Users"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            Sequence[mdls.User],
            self.get(
                path=f"/roles/{role_id}/users",
                structure=Sequence[mdls.User],
                query_params={
                    "fields": fields,
                    "direct_association_only": direct_association_only,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set all the users of the role with a specific id.
    #
    # PUT /roles/{role_id}/users -> Sequence[mdls.User]
    def set_role_users(
        self,
        # id of role
        role_id: str,
        body: Sequence[str],
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.User]:
        """Update Role Users"""
        role_id = self.encode_path_param(role_id)
        response = cast(
            Sequence[mdls.User],
            self.put(
                path=f"/roles/{role_id}/users",
                structure=Sequence[mdls.User],
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region ScheduledPlan: Manage Scheduled Plans

    # ### Get Scheduled Plans for a Space
    #
    # Returns scheduled plans owned by the caller for a given space id.
    #
    # GET /scheduled_plans/space/{space_id} -> Sequence[mdls.ScheduledPlan]
    def scheduled_plans_for_space(
        self,
        # Space Id
        space_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ScheduledPlan]:
        """Scheduled Plans for Space"""
        space_id = self.encode_path_param(space_id)
        response = cast(
            Sequence[mdls.ScheduledPlan],
            self.get(
                path=f"/scheduled_plans/space/{space_id}",
                structure=Sequence[mdls.ScheduledPlan],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Information About a Scheduled Plan
    #
    # Admins can fetch information about other users' Scheduled Plans.
    #
    # GET /scheduled_plans/{scheduled_plan_id} -> mdls.ScheduledPlan
    def scheduled_plan(
        self,
        # Scheduled Plan Id
        scheduled_plan_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ScheduledPlan:
        """Get Scheduled Plan"""
        scheduled_plan_id = self.encode_path_param(scheduled_plan_id)
        response = cast(
            mdls.ScheduledPlan,
            self.get(
                path=f"/scheduled_plans/{scheduled_plan_id}",
                structure=mdls.ScheduledPlan,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a Scheduled Plan
    #
    # Admins can update other users' Scheduled Plans.
    #
    # Note: Any scheduled plan destinations specified in an update will **replace** all scheduled plan destinations
    # currently defined for the scheduled plan.
    #
    # For Example: If a scheduled plan has destinations A, B, and C, and you call update on this scheduled plan
    # specifying only B in the destinations, then destinations A and C will be deleted by the update.
    #
    # Updating a scheduled plan to assign null or an empty array to the scheduled_plan_destinations property is an error, as a scheduled plan must always have at least one destination.
    #
    # If you omit the scheduled_plan_destinations property from the object passed to update, then the destinations
    # defined on the original scheduled plan will remain unchanged.
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    # PATCH /scheduled_plans/{scheduled_plan_id} -> mdls.ScheduledPlan
    def update_scheduled_plan(
        self,
        # Scheduled Plan Id
        scheduled_plan_id: str,
        body: mdls.WriteScheduledPlan,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ScheduledPlan:
        """Update Scheduled Plan"""
        scheduled_plan_id = self.encode_path_param(scheduled_plan_id)
        response = cast(
            mdls.ScheduledPlan,
            self.patch(
                path=f"/scheduled_plans/{scheduled_plan_id}",
                structure=mdls.ScheduledPlan,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a Scheduled Plan
    #
    # Normal users can only delete their own scheduled plans.
    # Admins can delete other users' scheduled plans.
    # This delete cannot be undone.
    #
    # DELETE /scheduled_plans/{scheduled_plan_id} -> str
    def delete_scheduled_plan(
        self,
        # Scheduled Plan Id
        scheduled_plan_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Scheduled Plan"""
        scheduled_plan_id = self.encode_path_param(scheduled_plan_id)
        response = cast(
            str,
            self.delete(
                path=f"/scheduled_plans/{scheduled_plan_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### List All Scheduled Plans
    #
    # Returns all scheduled plans which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans -> Sequence[mdls.ScheduledPlan]
    def all_scheduled_plans(
        self,
        # Return scheduled plans belonging to this user_id. If not provided, returns scheduled plans owned by the caller.
        user_id: Optional[str] = None,
        # Comma delimited list of field names. If provided, only the fields specified will be included in the response
        fields: Optional[str] = None,
        # Return scheduled plans belonging to all users (caller needs see_schedules permission)
        all_users: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ScheduledPlan]:
        """Get All Scheduled Plans"""
        response = cast(
            Sequence[mdls.ScheduledPlan],
            self.get(
                path="/scheduled_plans",
                structure=Sequence[mdls.ScheduledPlan],
                query_params={
                    "user_id": user_id,
                    "fields": fields,
                    "all_users": all_users,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a Scheduled Plan
    #
    # Create a scheduled plan to render a Look or Dashboard on a recurring schedule.
    #
    # To create a scheduled plan, you MUST provide values for the following fields:
    # `name`
    # and
    # `look_id`, `dashboard_id`, `lookml_dashboard_id`, or `query_id`
    # and
    # `cron_tab` or `datagroup`
    # and
    # at least one scheduled_plan_destination
    #
    # A scheduled plan MUST have at least one scheduled_plan_destination defined.
    #
    # When `look_id` is set, `require_no_results`, `require_results`, and `require_change` are all required.
    #
    # If `create_scheduled_plan` fails with a 422 error, be sure to look at the error messages in the response which will explain exactly what fields are missing or values that are incompatible.
    #
    # The queries that provide the data for the look or dashboard are run in the context of user account that owns the scheduled plan.
    #
    # When `run_as_recipient` is `false` or not specified, the queries that provide the data for the
    # look or dashboard are run in the context of user account that owns the scheduled plan.
    #
    # When `run_as_recipient` is `true` and all the email recipients are Looker user accounts, the
    # queries are run in the context of each recipient, so different recipients may see different
    # data from the same scheduled render of a look or dashboard. For more details, see [Run As Recipient](https://docs.looker.com/r/admin/run-as-recipient).
    #
    # Admins can create and modify scheduled plans on behalf of other users by specifying a user id.
    # Non-admin users may not create or modify scheduled plans by or for other users.
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    # POST /scheduled_plans -> mdls.ScheduledPlan
    def create_scheduled_plan(
        self,
        body: mdls.WriteScheduledPlan,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ScheduledPlan:
        """Create Scheduled Plan"""
        response = cast(
            mdls.ScheduledPlan,
            self.post(
                path="/scheduled_plans",
                structure=mdls.ScheduledPlan,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run a Scheduled Plan Immediately
    #
    # Create a scheduled plan that runs only once, and immediately.
    #
    # This can be useful for testing a Scheduled Plan before committing to a production schedule.
    #
    # Admins can create scheduled plans on behalf of other users by specifying a user id.
    #
    # This API is rate limited to prevent it from being used for relay spam or DoS attacks
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    # POST /scheduled_plans/run_once -> mdls.ScheduledPlan
    def scheduled_plan_run_once(
        self,
        body: mdls.WriteScheduledPlan,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ScheduledPlan:
        """Run Scheduled Plan Once"""
        response = cast(
            mdls.ScheduledPlan,
            self.post(
                path="/scheduled_plans/run_once",
                structure=mdls.ScheduledPlan,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Scheduled Plans for a Look
    #
    # Returns all scheduled plans for a look which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans/look/{look_id} -> Sequence[mdls.ScheduledPlan]
    def scheduled_plans_for_look(
        self,
        # Look Id
        look_id: str,
        # User Id (default is requesting user if not specified)
        user_id: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Return scheduled plans belonging to all users for the look
        all_users: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ScheduledPlan]:
        """Scheduled Plans for Look"""
        look_id = self.encode_path_param(look_id)
        response = cast(
            Sequence[mdls.ScheduledPlan],
            self.get(
                path=f"/scheduled_plans/look/{look_id}",
                structure=Sequence[mdls.ScheduledPlan],
                query_params={
                    "user_id": user_id,
                    "fields": fields,
                    "all_users": all_users,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Scheduled Plans for a Dashboard
    #
    # Returns all scheduled plans for a dashboard which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans/dashboard/{dashboard_id} -> Sequence[mdls.ScheduledPlan]
    def scheduled_plans_for_dashboard(
        self,
        # Dashboard Id
        dashboard_id: str,
        # User Id (default is requesting user if not specified)
        user_id: Optional[str] = None,
        # Return scheduled plans belonging to all users for the dashboard
        all_users: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ScheduledPlan]:
        """Scheduled Plans for Dashboard"""
        dashboard_id = self.encode_path_param(dashboard_id)
        response = cast(
            Sequence[mdls.ScheduledPlan],
            self.get(
                path=f"/scheduled_plans/dashboard/{dashboard_id}",
                structure=Sequence[mdls.ScheduledPlan],
                query_params={
                    "user_id": user_id,
                    "all_users": all_users,
                    "fields": fields,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get Scheduled Plans for a LookML Dashboard
    #
    # Returns all scheduled plans for a LookML Dashboard which belong to the caller or given user.
    #
    # If no user_id is provided, this function returns the scheduled plans owned by the caller.
    #
    #
    # To list all schedules for all users, pass `all_users=true`.
    #
    #
    # The caller must have `see_schedules` permission to see other users' scheduled plans.
    #
    # GET /scheduled_plans/lookml_dashboard/{lookml_dashboard_id} -> Sequence[mdls.ScheduledPlan]
    def scheduled_plans_for_lookml_dashboard(
        self,
        # LookML Dashboard Id
        lookml_dashboard_id: str,
        # User Id (default is requesting user if not specified)
        user_id: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Return scheduled plans belonging to all users for the dashboard
        all_users: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.ScheduledPlan]:
        """Scheduled Plans for LookML Dashboard"""
        lookml_dashboard_id = self.encode_path_param(lookml_dashboard_id)
        response = cast(
            Sequence[mdls.ScheduledPlan],
            self.get(
                path=f"/scheduled_plans/lookml_dashboard/{lookml_dashboard_id}",
                structure=Sequence[mdls.ScheduledPlan],
                query_params={
                    "user_id": user_id,
                    "fields": fields,
                    "all_users": all_users,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Run a Scheduled Plan By Id Immediately
    # This function creates a run-once schedule plan based on an existing scheduled plan,
    # applies modifications (if any) to the new scheduled plan, and runs the new schedule plan immediately.
    # This can be useful for testing modifications to an existing scheduled plan before committing to a production schedule.
    #
    # This function internally performs the following operations:
    #
    # 1. Copies the properties of the existing scheduled plan into a new scheduled plan
    # 2. Copies any properties passed in the JSON body of this request into the new scheduled plan (replacing the original values)
    # 3. Creates the new scheduled plan
    # 4. Runs the new scheduled plan
    #
    # The original scheduled plan is not modified by this operation.
    # Admins can create, modify, and run scheduled plans on behalf of other users by specifying a user id.
    # Non-admins can only create, modify, and run their own scheduled plans.
    #
    # #### Email Permissions:
    #
    # For details about permissions required to schedule delivery to email and the safeguards
    # Looker offers to protect against sending to unauthorized email destinations, see [Email Domain Whitelist for Scheduled Looks](https://docs.looker.com/r/api/embed-permissions).
    #
    #
    # #### Scheduled Plan Destination Formats
    #
    # Scheduled plan destinations must specify the data format to produce and send to the destination.
    #
    # Formats:
    #
    # | format | Description
    # | :-----------: | :--- |
    # | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata.
    # | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query
    # | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination.
    # | csv | Comma separated values with a header
    # | txt | Tab separated values with a header
    # | html | Simple html
    # | xlsx | MS Excel spreadsheet
    # | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document
    # | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document
    # | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image
    # ||
    #
    # Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.
    #
    #
    #
    # This API is rate limited to prevent it from being used for relay spam or DoS attacks
    #
    # POST /scheduled_plans/{scheduled_plan_id}/run_once -> mdls.ScheduledPlan
    def scheduled_plan_run_once_by_id(
        self,
        # Id of schedule plan to copy and run
        scheduled_plan_id: str,
        body: Optional[mdls.WriteScheduledPlan] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ScheduledPlan:
        """Run Scheduled Plan Once by Id"""
        scheduled_plan_id = self.encode_path_param(scheduled_plan_id)
        response = cast(
            mdls.ScheduledPlan,
            self.post(
                path=f"/scheduled_plans/{scheduled_plan_id}/run_once",
                structure=mdls.ScheduledPlan,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Session: Session Information

    # ### Get API Session
    #
    # Returns information about the current API session, such as which workspace is selected for the session.
    #
    # GET /session -> mdls.ApiSession
    def session(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ApiSession:
        """Get Session"""
        response = cast(
            mdls.ApiSession,
            self.get(
                path="/session",
                structure=mdls.ApiSession,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update API Session
    #
    # #### API Session Workspace
    #
    # You can use this endpoint to change the active workspace for the current API session.
    #
    # Only one workspace can be active in a session. The active workspace can be changed
    # any number of times in a session.
    #
    # The default workspace for API sessions is the "production" workspace.
    #
    # All Looker APIs that use projects or lookml models (such as running queries) will
    # use the version of project and model files defined by this workspace for the lifetime of the
    # current API session or until the session workspace is changed again.
    #
    # An API session has the same lifetime as the access_token used to authenticate API requests. Each successful
    # API login generates a new access_token and a new API session.
    #
    # If your Looker API client application needs to work in a dev workspace across multiple
    # API sessions, be sure to select the dev workspace after each login.
    #
    # PATCH /session -> mdls.ApiSession
    def update_session(
        self,
        body: mdls.WriteApiSession,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ApiSession:
        """Update Session"""
        response = cast(
            mdls.ApiSession,
            self.patch(
                path="/session",
                structure=mdls.ApiSession,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Theme: Manage Themes

    # ### Get an array of all existing themes
    #
    # Get a **single theme** by id with [Theme](#!/Theme/theme)
    #
    # This method returns an array of all existing themes. The active time for the theme is not considered.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # GET /themes -> Sequence[mdls.Theme]
    def all_themes(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Theme]:
        """Get All Themes"""
        response = cast(
            Sequence[mdls.Theme],
            self.get(
                path="/themes",
                structure=Sequence[mdls.Theme],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a theme
    #
    # Creates a new theme object, returning the theme details, including the created id.
    #
    # If `settings` are not specified, the default theme settings will be copied into the new theme.
    #
    # The theme `name` can only contain alphanumeric characters or underscores. Theme names should not contain any confidential information, such as customer names.
    #
    # **Update** an existing theme with [Update Theme](#!/Theme/update_theme)
    #
    # **Permanently delete** an existing theme with [Delete Theme](#!/Theme/delete_theme)
    #
    # For more information, see [Creating and Applying Themes](https://docs.looker.com/r/admin/themes).
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # POST /themes -> mdls.Theme
    def create_theme(
        self,
        body: mdls.WriteTheme,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Theme:
        """Create Theme"""
        response = cast(
            mdls.Theme,
            self.post(
                path="/themes",
                structure=mdls.Theme,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search all themes for matching criteria.
    #
    # Returns an **array of theme objects** that match the specified search criteria.
    #
    # | Search Parameters | Description
    # | :-------------------: | :------ |
    # | `begin_at` only | Find themes active at or after `begin_at`
    # | `end_at` only | Find themes active at or before `end_at`
    # | both set | Find themes with an active inclusive period between `begin_at` and `end_at`
    #
    # Note: Range matching requires boolean AND logic.
    # When using `begin_at` and `end_at` together, do not use `filter_or`=TRUE
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # Get a **single theme** by id with [Theme](#!/Theme/theme)
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # GET /themes/search -> Sequence[mdls.Theme]
    def search_themes(
        self,
        # Match theme id.
        id: Optional[str] = None,
        # Match theme name.
        name: Optional[str] = None,
        # Timestamp for activation.
        begin_at: Optional[datetime.datetime] = None,
        # Timestamp for expiration.
        end_at: Optional[datetime.datetime] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Requested fields.
        fields: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Theme]:
        """Search Themes"""
        response = cast(
            Sequence[mdls.Theme],
            self.get(
                path="/themes/search",
                structure=Sequence[mdls.Theme],
                query_params={
                    "id": id,
                    "name": name,
                    "begin_at": begin_at,
                    "end_at": end_at,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "fields": fields,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the default theme
    #
    # Returns the active theme object set as the default.
    #
    # The **default** theme name can be set in the UI on the Admin|Theme UI page
    #
    # The optional `ts` parameter can specify a different timestamp than "now." If specified, it returns the default theme at the time indicated.
    #
    # GET /themes/default -> mdls.Theme
    def default_theme(
        self,
        # Timestamp representing the target datetime for the active period. Defaults to 'now'
        ts: Optional[datetime.datetime] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Theme:
        """Get Default Theme"""
        response = cast(
            mdls.Theme,
            self.get(
                path="/themes/default",
                structure=mdls.Theme,
                query_params={"ts": ts},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set the global default theme by theme name
    #
    # Only Admin users can call this function.
    #
    # Only an active theme with no expiration (`end_at` not set) can be assigned as the default theme. As long as a theme has an active record with no expiration, it can be set as the default.
    #
    # [Create Theme](#!/Theme/create) has detailed information on rules for default and active themes
    #
    # Returns the new specified default theme object.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # PUT /themes/default -> mdls.Theme
    def set_default_theme(
        self,
        # Name of theme to set as default
        name: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Theme:
        """Set Default Theme"""
        response = cast(
            mdls.Theme,
            self.put(
                path="/themes/default",
                structure=mdls.Theme,
                query_params={"name": name},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get active themes
    #
    # Returns an array of active themes.
    #
    # If the `name` parameter is specified, it will return an array with one theme if it's active and found.
    #
    # The optional `ts` parameter can specify a different timestamp than "now."
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # GET /themes/active -> Sequence[mdls.Theme]
    def active_themes(
        self,
        # Name of theme
        name: Optional[str] = None,
        # Timestamp representing the target datetime for the active period. Defaults to 'now'
        ts: Optional[datetime.datetime] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Theme]:
        """Get Active Themes"""
        response = cast(
            Sequence[mdls.Theme],
            self.get(
                path="/themes/active",
                structure=Sequence[mdls.Theme],
                query_params={"name": name, "ts": ts, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get the named theme if it's active. Otherwise, return the default theme
    #
    # The optional `ts` parameter can specify a different timestamp than "now."
    # Note: API users with `show` ability can call this function
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # GET /themes/theme_or_default -> mdls.Theme
    def theme_or_default(
        self,
        # Name of theme
        name: str,
        # Timestamp representing the target datetime for the active period. Defaults to 'now'
        ts: Optional[datetime.datetime] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Theme:
        """Get Theme or Default"""
        response = cast(
            mdls.Theme,
            self.get(
                path="/themes/theme_or_default",
                structure=mdls.Theme,
                query_params={"name": name, "ts": ts},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Validate a theme with the specified information
    #
    # Validates all values set for the theme, returning any errors encountered, or 200 OK if valid
    #
    # See [Create Theme](#!/Theme/create_theme) for constraints
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # POST /themes/validate -> mdls.ValidationError
    def validate_theme(
        self,
        body: mdls.WriteTheme,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.ValidationError:
        """Validate Theme"""
        response = cast(
            mdls.ValidationError,
            self.post(
                path="/themes/validate",
                structure=mdls.ValidationError,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get a theme by ID
    #
    # Use this to retrieve a specific theme, whether or not it's currently active.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # GET /themes/{theme_id} -> mdls.Theme
    def theme(
        self,
        # Id of theme
        theme_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Theme:
        """Get Theme"""
        theme_id = self.encode_path_param(theme_id)
        response = cast(
            mdls.Theme,
            self.get(
                path=f"/themes/{theme_id}",
                structure=mdls.Theme,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update the theme by id.
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # PATCH /themes/{theme_id} -> mdls.Theme
    def update_theme(
        self,
        # Id of theme
        theme_id: str,
        body: mdls.WriteTheme,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Theme:
        """Update Theme"""
        theme_id = self.encode_path_param(theme_id)
        response = cast(
            mdls.Theme,
            self.patch(
                path=f"/themes/{theme_id}",
                structure=mdls.Theme,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a specific theme by id
    #
    # This operation permanently deletes the identified theme from the database.
    #
    # Because multiple themes can have the same name (with different activation time spans) themes can only be deleted by ID.
    #
    # All IDs associated with a theme name can be retrieved by searching for the theme name with [Theme Search](#!/Theme/search).
    #
    # **Note**: Custom themes needs to be enabled by Looker. Unless custom themes are enabled, only the automatically generated default theme can be used. Please contact your Account Manager or help.looker.com to update your license for this feature.
    #
    # DELETE /themes/{theme_id} -> str
    def delete_theme(
        self,
        # Id of theme
        theme_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Theme"""
        theme_id = self.encode_path_param(theme_id)
        response = cast(
            str,
            self.delete(
                path=f"/themes/{theme_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region User: Manage Users

    # ### Search email credentials
    #
    # Returns all credentials_email records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    # GET /credentials_email/search -> Sequence[mdls.CredentialsEmailSearch]
    def search_credentials_email(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Number of results to return (used with `offset`).
        limit: Optional[int] = None,
        # Number of results to skip before returning any (used with `limit`).
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match credentials_email id.
        id: Optional[str] = None,
        # Match credentials_email email.
        email: Optional[str] = None,
        # Find credentials_email that match given emails.
        emails: Optional[str] = None,
        # Combine given search criteria in a boolean OR expression.
        filter_or: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.CredentialsEmailSearch]:
        """Search CredentialsEmail"""
        response = cast(
            Sequence[mdls.CredentialsEmailSearch],
            self.get(
                path="/credentials_email/search",
                structure=Sequence[mdls.CredentialsEmailSearch],
                query_params={
                    "fields": fields,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "email": email,
                    "emails": emails,
                    "filter_or": filter_or,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the current user; i.e. the user account currently calling the API.
    #
    # GET /user -> mdls.User
    def me(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Get Current User"""
        response = cast(
            mdls.User,
            self.get(
                path="/user",
                structure=mdls.User,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about all users.
    #
    # GET /users -> Sequence[mdls.User]
    def all_users(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Optional list of ids to get specific users.
        ids: Optional[mdls.DelimSequence[str]] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.User]:
        """Get All Users"""
        response = cast(
            Sequence[mdls.User],
            self.get(
                path="/users",
                structure=Sequence[mdls.User],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "ids": ids,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a user with the specified information.
    #
    # POST /users -> mdls.User
    def create_user(
        self,
        body: Optional[mdls.WriteUser] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Create User"""
        response = cast(
            mdls.User,
            self.post(
                path="/users",
                structure=mdls.User,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search users
    #
    # Returns all<sup>*</sup> user records that match the given search criteria.
    #
    # If multiple search params are given and `filter_or` is FALSE or not specified,
    # search params are combined in a logical AND operation.
    # Only rows that match *all* search param criteria will be returned.
    #
    # If `filter_or` is TRUE, multiple search params are combined in a logical OR operation.
    # Results will include rows that match **any** of the search criteria.
    #
    # String search params use case-insensitive matching.
    # String search params can contain `%` and '_' as SQL LIKE pattern match wildcard expressions.
    # example="dan%" will match "danger" and "Danzig" but not "David"
    # example="D_m%" will match "Damage" and "dump"
    #
    # Integer search params can accept a single value or a comma separated list of values. The multiple
    # values will be combined under a logical OR operation - results will match at least one of
    # the given values.
    #
    # Most search params can accept "IS NULL" and "NOT NULL" as special expressions to match
    # or exclude (respectively) rows where the column is null.
    #
    # Boolean search params accept only "true" and "false" as values.
    #
    #
    # (<sup>*</sup>) Results are always filtered to the level of information the caller is permitted to view.
    # Looker admins can see all user details; normal users in an open system can see
    # names of other users but no details; normal users in a closed system can only see
    # names of other users who are members of the same group as the user.
    #
    # GET /users/search -> Sequence[mdls.User]
    def search_users(
        self,
        # Include only these fields in the response
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by.
        sorts: Optional[str] = None,
        # Match User Id.
        id: Optional[str] = None,
        # Match First name.
        first_name: Optional[str] = None,
        # Match Last name.
        last_name: Optional[str] = None,
        # Search for user accounts associated with Looker employees
        verified_looker_employee: Optional[bool] = None,
        # Search for only embed users
        embed_user: Optional[bool] = None,
        # Search for the user with this email address
        email: Optional[str] = None,
        # Search for disabled user accounts
        is_disabled: Optional[bool] = None,
        # Combine given search criteria in a boolean OR expression
        filter_or: Optional[bool] = None,
        # Search for users who have access to this content_metadata item
        content_metadata_id: Optional[str] = None,
        # Search for users who are direct members of this group
        group_id: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.User]:
        """Search Users"""
        response = cast(
            Sequence[mdls.User],
            self.get(
                path="/users/search",
                structure=Sequence[mdls.User],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "first_name": first_name,
                    "last_name": last_name,
                    "verified_looker_employee": verified_looker_employee,
                    "embed_user": embed_user,
                    "email": email,
                    "is_disabled": is_disabled,
                    "filter_or": filter_or,
                    "content_metadata_id": content_metadata_id,
                    "group_id": group_id,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Search for user accounts by name
    #
    # Returns all user accounts where `first_name` OR `last_name` OR `email` field values match a pattern.
    # The pattern can contain `%` and `_` wildcards as in SQL LIKE expressions.
    #
    # Any additional search params will be combined into a logical AND expression.
    #
    # GET /users/search/names/{pattern} -> Sequence[mdls.User]
    def search_users_names(
        self,
        # Pattern to match
        pattern: str,
        # Include only these fields in the response
        fields: Optional[str] = None,
        # DEPRECATED. Use limit and offset instead. Return only page N of paginated results
        page: Optional[int] = None,
        # DEPRECATED. Use limit and offset instead. Return N rows of data per page
        per_page: Optional[int] = None,
        # Number of results to return. (used with offset and takes priority over page and per_page)
        limit: Optional[int] = None,
        # Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        offset: Optional[int] = None,
        # Fields to sort by
        sorts: Optional[str] = None,
        # Match User Id
        id: Optional[str] = None,
        # Match First name
        first_name: Optional[str] = None,
        # Match Last name
        last_name: Optional[str] = None,
        # Match Verified Looker employee
        verified_looker_employee: Optional[bool] = None,
        # Match Email Address
        email: Optional[str] = None,
        # Include or exclude disabled accounts in the results
        is_disabled: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.User]:
        """Search User Names"""
        pattern = self.encode_path_param(pattern)
        response = cast(
            Sequence[mdls.User],
            self.get(
                path=f"/users/search/names/{pattern}",
                structure=Sequence[mdls.User],
                query_params={
                    "fields": fields,
                    "page": page,
                    "per_page": per_page,
                    "limit": limit,
                    "offset": offset,
                    "sorts": sorts,
                    "id": id,
                    "first_name": first_name,
                    "last_name": last_name,
                    "verified_looker_employee": verified_looker_employee,
                    "email": email,
                    "is_disabled": is_disabled,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the user with a specific id.
    #
    # If the caller is an admin or the caller is the user being specified, then full user information will
    # be returned. Otherwise, a minimal 'public' variant of the user information will be returned. This contains
    # The user name and avatar url, but no sensitive information.
    #
    # GET /users/{user_id} -> mdls.User
    def user(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Get User by Id"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.User,
            self.get(
                path=f"/users/{user_id}",
                structure=mdls.User,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update information about the user with a specific id.
    #
    # PATCH /users/{user_id} -> mdls.User
    def update_user(
        self,
        # Id of user
        user_id: str,
        body: mdls.WriteUser,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Update User"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.User,
            self.patch(
                path=f"/users/{user_id}",
                structure=mdls.User,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete the user with a specific id.
    #
    # **DANGER** this will delete the user and all looks and other information owned by the user.
    #
    # DELETE /users/{user_id} -> str
    def delete_user(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete User"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about the user with a credential of given type with specific id.
    #
    # This is used to do things like find users by their embed external_user_id. Or, find the user with
    # a given api3 client_id, etc. The 'credential_type' matches the 'type' name of the various credential
    # types. It must be one of the values listed in the table below. The 'credential_id' is your unique Id
    # for the user and is specific to each type of credential.
    #
    # An example using the Ruby sdk might look like:
    #
    # `sdk.user_for_credential('embed', 'customer-4959425')`
    #
    # This table shows the supported 'Credential Type' strings. The right column is for reference; it shows
    # which field in the given credential type is actually searched when finding a user with the supplied
    # 'credential_id'.
    #
    # | Credential Types | Id Field Matched |
    # | ---------------- | ---------------- |
    # | email            | email            |
    # | google           | google_user_id   |
    # | saml             | saml_user_id     |
    # | oidc             | oidc_user_id     |
    # | ldap             | ldap_id          |
    # | api              | token            |
    # | api3             | client_id        |
    # | embed            | external_user_id |
    # | looker_openid    | email            |
    #
    # **NOTE**: The 'api' credential type was only used with the legacy Looker query API and is no longer supported. The credential type for API you are currently looking at is 'api3'.
    #
    # GET /users/credential/{credential_type}/{credential_id} -> mdls.User
    def user_for_credential(
        self,
        # Type name of credential
        credential_type: str,
        # Id of credential
        credential_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Get User by Credential Id"""
        credential_type = self.encode_path_param(credential_type)
        credential_id = self.encode_path_param(credential_id)
        response = cast(
            mdls.User,
            self.get(
                path=f"/users/credential/{credential_type}/{credential_id}",
                structure=mdls.User,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Email/password login information for the specified user.
    #
    # GET /users/{user_id}/credentials_email -> mdls.CredentialsEmail
    def user_credentials_email(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsEmail:
        """Get Email/Password Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsEmail,
            self.get(
                path=f"/users/{user_id}/credentials_email",
                structure=mdls.CredentialsEmail,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Email/password login information for the specified user.
    #
    # POST /users/{user_id}/credentials_email -> mdls.CredentialsEmail
    def create_user_credentials_email(
        self,
        # Id of user
        user_id: str,
        body: mdls.WriteCredentialsEmail,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsEmail:
        """Create Email/Password Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsEmail,
            self.post(
                path=f"/users/{user_id}/credentials_email",
                structure=mdls.CredentialsEmail,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Email/password login information for the specified user.
    #
    # PATCH /users/{user_id}/credentials_email -> mdls.CredentialsEmail
    def update_user_credentials_email(
        self,
        # Id of user
        user_id: str,
        body: mdls.WriteCredentialsEmail,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsEmail:
        """Update Email/Password Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsEmail,
            self.patch(
                path=f"/users/{user_id}/credentials_email",
                structure=mdls.CredentialsEmail,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Email/password login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_email -> str
    def delete_user_credentials_email(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Email/Password Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_email",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Two-factor login information for the specified user.
    #
    # GET /users/{user_id}/credentials_totp -> mdls.CredentialsTotp
    def user_credentials_totp(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsTotp:
        """Get Two-Factor Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsTotp,
            self.get(
                path=f"/users/{user_id}/credentials_totp",
                structure=mdls.CredentialsTotp,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Two-factor login information for the specified user.
    #
    # POST /users/{user_id}/credentials_totp -> mdls.CredentialsTotp
    def create_user_credentials_totp(
        self,
        # Id of user
        user_id: str,
        # WARNING: no writeable properties found for POST, PUT, or PATCH
        body: Optional[mdls.CredentialsTotp] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsTotp:
        """Create Two-Factor Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsTotp,
            self.post(
                path=f"/users/{user_id}/credentials_totp",
                structure=mdls.CredentialsTotp,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Two-factor login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_totp -> str
    def delete_user_credentials_totp(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Two-Factor Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_totp",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### LDAP login information for the specified user.
    #
    # GET /users/{user_id}/credentials_ldap -> mdls.CredentialsLDAP
    def user_credentials_ldap(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsLDAP:
        """Get LDAP Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsLDAP,
            self.get(
                path=f"/users/{user_id}/credentials_ldap",
                structure=mdls.CredentialsLDAP,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### LDAP login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_ldap -> str
    def delete_user_credentials_ldap(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete LDAP Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_ldap",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Google authentication login information for the specified user.
    #
    # GET /users/{user_id}/credentials_google -> mdls.CredentialsGoogle
    def user_credentials_google(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsGoogle:
        """Get Google Auth Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsGoogle,
            self.get(
                path=f"/users/{user_id}/credentials_google",
                structure=mdls.CredentialsGoogle,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Google authentication login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_google -> str
    def delete_user_credentials_google(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Google Auth Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_google",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Saml authentication login information for the specified user.
    #
    # GET /users/{user_id}/credentials_saml -> mdls.CredentialsSaml
    def user_credentials_saml(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsSaml:
        """Get Saml Auth Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsSaml,
            self.get(
                path=f"/users/{user_id}/credentials_saml",
                structure=mdls.CredentialsSaml,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Saml authentication login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_saml -> str
    def delete_user_credentials_saml(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Saml Auth Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_saml",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### OpenID Connect (OIDC) authentication login information for the specified user.
    #
    # GET /users/{user_id}/credentials_oidc -> mdls.CredentialsOIDC
    def user_credentials_oidc(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsOIDC:
        """Get OIDC Auth Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsOIDC,
            self.get(
                path=f"/users/{user_id}/credentials_oidc",
                structure=mdls.CredentialsOIDC,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### OpenID Connect (OIDC) authentication login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_oidc -> str
    def delete_user_credentials_oidc(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete OIDC Auth Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_oidc",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # GET /users/{user_id}/credentials_api3/{credentials_api3_id} -> mdls.CredentialsApi3
    def user_credentials_api3(
        self,
        # Id of user
        user_id: str,
        # Id of API 3 Credential
        credentials_api3_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsApi3:
        """Get API 3 Credential"""
        user_id = self.encode_path_param(user_id)
        credentials_api3_id = self.encode_path_param(credentials_api3_id)
        response = cast(
            mdls.CredentialsApi3,
            self.get(
                path=f"/users/{user_id}/credentials_api3/{credentials_api3_id}",
                structure=mdls.CredentialsApi3,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # DELETE /users/{user_id}/credentials_api3/{credentials_api3_id} -> str
    def delete_user_credentials_api3(
        self,
        # Id of user
        user_id: str,
        # Id of API 3 Credential
        credentials_api3_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete API 3 Credential"""
        user_id = self.encode_path_param(user_id)
        credentials_api3_id = self.encode_path_param(credentials_api3_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_api3/{credentials_api3_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # GET /users/{user_id}/credentials_api3 -> Sequence[mdls.CredentialsApi3]
    def all_user_credentials_api3s(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.CredentialsApi3]:
        """Get All API 3 Credentials"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            Sequence[mdls.CredentialsApi3],
            self.get(
                path=f"/users/{user_id}/credentials_api3",
                structure=Sequence[mdls.CredentialsApi3],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### API 3 login information for the specified user. This is for the newer API keys that can be added for any user.
    #
    # POST /users/{user_id}/credentials_api3 -> mdls.CreateCredentialsApi3
    def create_user_credentials_api3(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CreateCredentialsApi3:
        """Create API 3 Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CreateCredentialsApi3,
            self.post(
                path=f"/users/{user_id}/credentials_api3",
                structure=mdls.CreateCredentialsApi3,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Embed login information for the specified user.
    #
    # GET /users/{user_id}/credentials_embed/{credentials_embed_id} -> mdls.CredentialsEmbed
    def user_credentials_embed(
        self,
        # Id of user
        user_id: str,
        # Id of Embedding Credential
        credentials_embed_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsEmbed:
        """Get Embedding Credential"""
        user_id = self.encode_path_param(user_id)
        credentials_embed_id = self.encode_path_param(credentials_embed_id)
        response = cast(
            mdls.CredentialsEmbed,
            self.get(
                path=f"/users/{user_id}/credentials_embed/{credentials_embed_id}",
                structure=mdls.CredentialsEmbed,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Embed login information for the specified user.
    #
    # DELETE /users/{user_id}/credentials_embed/{credentials_embed_id} -> str
    def delete_user_credentials_embed(
        self,
        # Id of user
        user_id: str,
        # Id of Embedding Credential
        credentials_embed_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Embedding Credential"""
        user_id = self.encode_path_param(user_id)
        credentials_embed_id = self.encode_path_param(credentials_embed_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_embed/{credentials_embed_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Embed login information for the specified user.
    #
    # GET /users/{user_id}/credentials_embed -> Sequence[mdls.CredentialsEmbed]
    def all_user_credentials_embeds(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.CredentialsEmbed]:
        """Get All Embedding Credentials"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            Sequence[mdls.CredentialsEmbed],
            self.get(
                path=f"/users/{user_id}/credentials_embed",
                structure=Sequence[mdls.CredentialsEmbed],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Looker Openid login information for the specified user. Used by Looker Analysts.
    #
    # GET /users/{user_id}/credentials_looker_openid -> mdls.CredentialsLookerOpenid
    def user_credentials_looker_openid(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsLookerOpenid:
        """Get Looker OpenId Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsLookerOpenid,
            self.get(
                path=f"/users/{user_id}/credentials_looker_openid",
                structure=mdls.CredentialsLookerOpenid,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Looker Openid login information for the specified user. Used by Looker Analysts.
    #
    # DELETE /users/{user_id}/credentials_looker_openid -> str
    def delete_user_credentials_looker_openid(
        self,
        # Id of user
        user_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Looker OpenId Credential"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/credentials_looker_openid",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Web login session for the specified user.
    #
    # GET /users/{user_id}/sessions/{session_id} -> mdls.Session
    def user_session(
        self,
        # Id of user
        user_id: str,
        # Id of Web Login Session
        session_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Session:
        """Get Web Login Session"""
        user_id = self.encode_path_param(user_id)
        session_id = self.encode_path_param(session_id)
        response = cast(
            mdls.Session,
            self.get(
                path=f"/users/{user_id}/sessions/{session_id}",
                structure=mdls.Session,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Web login session for the specified user.
    #
    # DELETE /users/{user_id}/sessions/{session_id} -> str
    def delete_user_session(
        self,
        # Id of user
        user_id: str,
        # Id of Web Login Session
        session_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete Web Login Session"""
        user_id = self.encode_path_param(user_id)
        session_id = self.encode_path_param(session_id)
        response = cast(
            str,
            self.delete(
                path=f"/users/{user_id}/sessions/{session_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Web login session for the specified user.
    #
    # GET /users/{user_id}/sessions -> Sequence[mdls.Session]
    def all_user_sessions(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Session]:
        """Get All Web Login Sessions"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            Sequence[mdls.Session],
            self.get(
                path=f"/users/{user_id}/sessions",
                structure=Sequence[mdls.Session],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a password reset token.
    # This will create a cryptographically secure random password reset token for the user.
    # If the user already has a password reset token then this invalidates the old token and creates a new one.
    # The token is expressed as the 'password_reset_url' of the user's email/password credential object.
    # This takes an optional 'expires' param to indicate if the new token should be an expiring token.
    # Tokens that expire are typically used for self-service password resets for existing users.
    # Invitation emails for new users typically are not set to expire.
    # The expire period is always 60 minutes when expires is enabled.
    # This method can be called with an empty body.
    #
    # POST /users/{user_id}/credentials_email/password_reset -> mdls.CredentialsEmail
    def create_user_credentials_email_password_reset(
        self,
        # Id of user
        user_id: str,
        # Expiring token.
        expires: Optional[bool] = None,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsEmail:
        """Create Password Reset Token"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsEmail,
            self.post(
                path=f"/users/{user_id}/credentials_email/password_reset",
                structure=mdls.CredentialsEmail,
                query_params={"expires": expires, "fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about roles of a given user
    #
    # GET /users/{user_id}/roles -> Sequence[mdls.Role]
    def user_roles(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Get only roles associated directly with the user: exclude those only associated through groups.
        direct_association_only: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Role]:
        """Get User Roles"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            Sequence[mdls.Role],
            self.get(
                path=f"/users/{user_id}/roles",
                structure=Sequence[mdls.Role],
                query_params={
                    "fields": fields,
                    "direct_association_only": direct_association_only,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Set roles of the user with a specific id.
    #
    # PUT /users/{user_id}/roles -> Sequence[mdls.Role]
    def set_user_roles(
        self,
        # Id of user
        user_id: str,
        body: Sequence[str],
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Role]:
        """Set User Roles"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            Sequence[mdls.Role],
            self.put(
                path=f"/users/{user_id}/roles",
                structure=Sequence[mdls.Role],
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get user attribute values for a given user.
    #
    # Returns the values of specified user attributes (or all user attributes) for a certain user.
    #
    # A value for each user attribute is searched for in the following locations, in this order:
    #
    # 1. in the user's account information
    # 1. in groups that the user is a member of
    # 1. the default value of the user attribute
    #
    # If more than one group has a value defined for a user attribute, the group with the lowest rank wins.
    #
    # The response will only include user attributes for which values were found. Use `include_unset=true` to include
    # empty records for user attributes with no value.
    #
    # The value of all hidden user attributes will be blank.
    #
    # GET /users/{user_id}/attribute_values -> Sequence[mdls.UserAttributeWithValue]
    def user_attribute_user_values(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        # Specific user attributes to request. Omit or leave blank to request all user attributes.
        user_attribute_ids: Optional[mdls.DelimSequence[str]] = None,
        # If true, returns all values in the search path instead of just the first value found. Useful for debugging group precedence.
        all_values: Optional[bool] = None,
        # If true, returns an empty record for each requested attribute that has no user, group, or default value.
        include_unset: Optional[bool] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.UserAttributeWithValue]:
        """Get User Attribute Values"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            Sequence[mdls.UserAttributeWithValue],
            self.get(
                path=f"/users/{user_id}/attribute_values",
                structure=Sequence[mdls.UserAttributeWithValue],
                query_params={
                    "fields": fields,
                    "user_attribute_ids": user_attribute_ids,
                    "all_values": all_values,
                    "include_unset": include_unset,
                },
                transport_options=transport_options,
            ),
        )
        return response

    # ### Store a custom value for a user attribute in a user's account settings.
    #
    # Per-user user attribute values take precedence over group or default values.
    #
    # PATCH /users/{user_id}/attribute_values/{user_attribute_id} -> mdls.UserAttributeWithValue
    def set_user_attribute_user_value(
        self,
        # Id of user
        user_id: str,
        # Id of user attribute
        user_attribute_id: str,
        body: mdls.WriteUserAttributeWithValue,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.UserAttributeWithValue:
        """Set User Attribute User Value"""
        user_id = self.encode_path_param(user_id)
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            mdls.UserAttributeWithValue,
            self.patch(
                path=f"/users/{user_id}/attribute_values/{user_attribute_id}",
                structure=mdls.UserAttributeWithValue,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a user attribute value from a user's account settings.
    #
    # After the user attribute value is deleted from the user's account settings, subsequent requests
    # for the user attribute value for this user will draw from the user's groups or the default
    # value of the user attribute. See [Get User Attribute Values](#!/User/user_attribute_user_values) for more
    # information about how user attribute values are resolved.
    #
    # DELETE /users/{user_id}/attribute_values/{user_attribute_id} -> None
    def delete_user_attribute_user_value(
        self,
        # Id of user
        user_id: str,
        # Id of user attribute
        user_attribute_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> None:
        """Delete User Attribute User Value"""
        user_id = self.encode_path_param(user_id)
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            None,
            self.delete(
                path=f"/users/{user_id}/attribute_values/{user_attribute_id}",
                structure=None,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Send a password reset token.
    # This will send a password reset email to the user. If a password reset token does not already exist
    # for this user, it will create one and then send it.
    # If the user has not yet set up their account, it will send a setup email to the user.
    # The URL sent in the email is expressed as the 'password_reset_url' of the user's email/password credential object.
    # Password reset URLs will expire in 60 minutes.
    # This method can be called with an empty body.
    #
    # POST /users/{user_id}/credentials_email/send_password_reset -> mdls.CredentialsEmail
    def send_user_credentials_email_password_reset(
        self,
        # Id of user
        user_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.CredentialsEmail:
        """Send Password Reset Token"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.CredentialsEmail,
            self.post(
                path=f"/users/{user_id}/credentials_email/send_password_reset",
                structure=mdls.CredentialsEmail,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Change a disabled user's email addresses
    #
    # Allows the admin to change the email addresses for all the user's
    # associated credentials.  Will overwrite all associated email addresses with
    # the value supplied in the 'email' body param.
    # The user's 'is_disabled' status must be true.
    #
    # POST /users/{user_id}/update_emails -> mdls.User
    def wipeout_user_emails(
        self,
        # Id of user
        user_id: str,
        body: mdls.UserEmailOnly,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.User:
        """Wipeout User Emails"""
        user_id = self.encode_path_param(user_id)
        response = cast(
            mdls.User,
            self.post(
                path=f"/users/{user_id}/update_emails",
                structure=mdls.User,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # Create an embed user from an external user ID
    #
    # POST /users/embed_user -> mdls.UserPublic
    def create_embed_user(
        self,
        body: mdls.CreateEmbedUserRequest,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.UserPublic:
        """Create an embed user from an external user ID"""
        response = cast(
            mdls.UserPublic,
            self.post(
                path="/users/embed_user",
                structure=mdls.UserPublic,
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region UserAttribute: Manage User Attributes

    # ### Get information about all user attributes.
    #
    # GET /user_attributes -> Sequence[mdls.UserAttribute]
    def all_user_attributes(
        self,
        # Requested fields.
        fields: Optional[str] = None,
        # Fields to order the results by. Sortable fields include: name, label
        sorts: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.UserAttribute]:
        """Get All User Attributes"""
        response = cast(
            Sequence[mdls.UserAttribute],
            self.get(
                path="/user_attributes",
                structure=Sequence[mdls.UserAttribute],
                query_params={"fields": fields, "sorts": sorts},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Create a new user attribute
    #
    # Permission information for a user attribute is conveyed through the `can` and `user_can_edit` fields.
    # The `user_can_edit` field indicates whether an attribute is user-editable _anywhere_ in the application.
    # The `can` field gives more granular access information, with the `set_value` child field indicating whether
    # an attribute's value can be set by [Setting the User Attribute User Value](#!/User/set_user_attribute_user_value).
    #
    # Note: `name` and `label` fields must be unique across all user attributes in the Looker instance.
    # Attempting to create a new user attribute with a name or label that duplicates an existing
    # user attribute will fail with a 422 error.
    #
    # POST /user_attributes -> mdls.UserAttribute
    def create_user_attribute(
        self,
        body: mdls.WriteUserAttribute,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.UserAttribute:
        """Create User Attribute"""
        response = cast(
            mdls.UserAttribute,
            self.post(
                path="/user_attributes",
                structure=mdls.UserAttribute,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get information about a user attribute.
    #
    # GET /user_attributes/{user_attribute_id} -> mdls.UserAttribute
    def user_attribute(
        self,
        # Id of user attribute
        user_attribute_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.UserAttribute:
        """Get User Attribute"""
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            mdls.UserAttribute,
            self.get(
                path=f"/user_attributes/{user_attribute_id}",
                structure=mdls.UserAttribute,
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Update a user attribute definition.
    #
    # PATCH /user_attributes/{user_attribute_id} -> mdls.UserAttribute
    def update_user_attribute(
        self,
        # Id of user attribute
        user_attribute_id: str,
        body: mdls.WriteUserAttribute,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.UserAttribute:
        """Update User Attribute"""
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            mdls.UserAttribute,
            self.patch(
                path=f"/user_attributes/{user_attribute_id}",
                structure=mdls.UserAttribute,
                query_params={"fields": fields},
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Delete a user attribute (admin only).
    #
    # DELETE /user_attributes/{user_attribute_id} -> str
    def delete_user_attribute(
        self,
        # Id of user attribute
        user_attribute_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> str:
        """Delete User Attribute"""
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            str,
            self.delete(
                path=f"/user_attributes/{user_attribute_id}",
                structure=str,
                transport_options=transport_options,
            ),
        )
        return response

    # ### Returns all values of a user attribute defined by user groups, in precedence order.
    #
    # A user may be a member of multiple groups which define different values for a given user attribute.
    # The order of group-values in the response determines precedence for selecting which group-value applies
    # to a given user.  For more information, see [Set User Attribute Group Values](#!/UserAttribute/set_user_attribute_group_values).
    #
    # Results will only include groups that the caller's user account has permission to see.
    #
    # GET /user_attributes/{user_attribute_id}/group_values -> Sequence[mdls.UserAttributeGroupValue]
    def all_user_attribute_group_values(
        self,
        # Id of user attribute
        user_attribute_id: str,
        # Requested fields.
        fields: Optional[str] = None,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.UserAttributeGroupValue]:
        """Get User Attribute Group Values"""
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            Sequence[mdls.UserAttributeGroupValue],
            self.get(
                path=f"/user_attributes/{user_attribute_id}/group_values",
                structure=Sequence[mdls.UserAttributeGroupValue],
                query_params={"fields": fields},
                transport_options=transport_options,
            ),
        )
        return response

    # ### Define values for a user attribute across a set of groups, in priority order.
    #
    # This function defines all values for a user attribute defined by user groups. This is a global setting, potentially affecting
    # all users in the system. This function replaces any existing group value definitions for the indicated user attribute.
    #
    # The value of a user attribute for a given user is determined by searching the following locations, in this order:
    #
    # 1. the user's account settings
    # 2. the groups that the user is a member of
    # 3. the default value of the user attribute, if any
    #
    # The user may be a member of multiple groups which define different values for that user attribute. The order of items in the group_values parameter
    # determines which group takes priority for that user. Lowest array index wins.
    #
    # An alternate method to indicate the selection precedence of group-values is to assign numbers to the 'rank' property of each
    # group-value object in the array. Lowest 'rank' value wins. If you use this technique, you must assign a
    # rank value to every group-value object in the array.
    #
    #   To set a user attribute value for a single user, see [Set User Attribute User Value](#!/User/set_user_attribute_user_value).
    # To set a user attribute value for all members of a group, see [Set User Attribute Group Value](#!/Group/update_user_attribute_group_value).
    #
    # POST /user_attributes/{user_attribute_id}/group_values -> Sequence[mdls.UserAttributeGroupValue]
    def set_user_attribute_group_values(
        self,
        # Id of user attribute
        user_attribute_id: str,
        body: Sequence[mdls.UserAttributeGroupValue],
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.UserAttributeGroupValue]:
        """Set User Attribute Group Values"""
        user_attribute_id = self.encode_path_param(user_attribute_id)
        response = cast(
            Sequence[mdls.UserAttributeGroupValue],
            self.post(
                path=f"/user_attributes/{user_attribute_id}/group_values",
                structure=Sequence[mdls.UserAttributeGroupValue],
                body=body,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion

    # region Workspace: Manage Workspaces

    # ### Get All Workspaces
    #
    # Returns all workspaces available to the calling user.
    #
    # GET /workspaces -> Sequence[mdls.Workspace]
    def all_workspaces(
        self,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> Sequence[mdls.Workspace]:
        """Get All Workspaces"""
        response = cast(
            Sequence[mdls.Workspace],
            self.get(
                path="/workspaces",
                structure=Sequence[mdls.Workspace],
                transport_options=transport_options,
            ),
        )
        return response

    # ### Get A Workspace
    #
    # Returns information about a workspace such as the git status and selected branches
    # of all projects available to the caller's user account.
    #
    # A workspace defines which versions of project files will be used to evaluate expressions
    # and operations that use model definitions - operations such as running queries or rendering dashboards.
    # Each project has its own git repository, and each project in a workspace may be configured to reference
    # particular branch or revision within their respective repositories.
    #
    # There are two predefined workspaces available: "production" and "dev".
    #
    # The production workspace is shared across all Looker users. Models in the production workspace are read-only.
    # Changing files in production is accomplished by modifying files in a git branch and using Pull Requests
    # to merge the changes from the dev branch into the production branch, and then telling
    # Looker to sync with production.
    #
    # The dev workspace is local to each Looker user. Changes made to project/model files in the dev workspace only affect
    # that user, and only when the dev workspace is selected as the active workspace for the API session.
    # (See set_session_workspace()).
    #
    # The dev workspace is NOT unique to an API session. Two applications accessing the Looker API using
    # the same user account will see the same files in the dev workspace. To avoid collisions between
    # API clients it's best to have each client login with API3 credentials for a different user account.
    #
    # Changes made to files in a dev workspace are persistent across API sessions. It's a good
    # idea to commit any changes you've made to the git repository, but not strictly required. Your modified files
    # reside in a special user-specific directory on the Looker server and will still be there when you login in again
    # later and use update_session(workspace_id: "dev") to select the dev workspace for the new API session.
    #
    # GET /workspaces/{workspace_id} -> mdls.Workspace
    def workspace(
        self,
        # Id of the workspace
        workspace_id: str,
        transport_options: Optional[transport.TransportOptions] = None,
    ) -> mdls.Workspace:
        """Get Workspace"""
        workspace_id = self.encode_path_param(workspace_id)
        response = cast(
            mdls.Workspace,
            self.get(
                path=f"/workspaces/{workspace_id}",
                structure=mdls.Workspace,
                transport_options=transport_options,
            ),
        )
        return response

    # endregion
