# coding: utf-8
# !/usr/bin/env python
import os
import sys

from setuptools import setup, find_packages

version = "0.0.26"

if sys.argv[-1] == "publish":
    try:
        import wheel

        print("Wheel version: ", wheel.__version__)
    except ImportError:
        print('Wheel library missing. Please run "pip install wheel"')
        sys.exit()
    os.system("python setup.py clean")
    os.system("python setup.py sdist bdist_wheel")
    os.system("twine upload dist/*")
    sys.exit()

if sys.argv[1] == "bumpversion":
    print("bumpversion")
    try:
        part = sys.argv[2]
    except IndexError:
        part = "patch"

    os.system("bumpversion --config-file setup.cfg %s" % part)
    sys.exit()

__doc__ = """A generic api for oauth2"""

project_name = "adactivexlsx2html"
app_name = "adactivexlsx2html"

ROOT = os.path.dirname(__file__)


def read(fname):
    return open(os.path.join(ROOT, fname)).read()


setup(
    name=project_name,
    version=version,
    description=__doc__,
    long_description=read("README.md"),
    long_description_content_type="text/markdown",
    url="https://github.com/adactiveasia/%s" % project_name,
    author="dev_adactive",
    author_email="dev@adactive.asia",
    packages=[package for package in find_packages() if package.startswith(app_name)],
    python_requires=">=3.6, <4",
    install_requires=["six", "openpyxl>=2.4.8", "babel>=2.3.4", "packaging>=20.4"],
    zip_safe=False,
    include_package_data=True,
    license="MIT",
    keywords="converter xlsx html",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Topic :: Text Processing",
        "Topic :: Text Processing :: Markup :: HTML",
    ],
)
