# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: user/v1/user.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class BlackHouseInfo(betterproto.Message):
    # 封禁时间 格式 "2020-09-25T18:10:00+08:00"(RFC3339)
    expire_time: str = betterproto.string_field(1)
    # 禁止评论
    disable_comment: bool = betterproto.bool_field(2)
    # 禁止发弹幕
    disable_danmaku: bool = betterproto.bool_field(3)
    # 禁止点评
    disable_review: bool = betterproto.bool_field(4)


@dataclass
class GetBlackHouseInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BlackHouseInfo" = betterproto.message_field(3)


@dataclass
class TakeReaderWelfareReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)


@dataclass
class ReaderWelfareData(betterproto.Message):
    # 2-专属券 3-专属限免卡
    type: int = betterproto.int32_field(1)
    # 数量
    amount: int = betterproto.int32_field(2)


@dataclass
class GetReaderWelfareResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ReaderWelfareData" = betterproto.message_field(3)


@dataclass
class GetReaderWelfareReq(betterproto.Message):
    ep_id: int = betterproto.int32_field(1)


@dataclass
class GetInitInfoReq(betterproto.Message):
    # 在登录后立即调用
    after_login: bool = betterproto.bool_field(1)


@dataclass
class NewerTaskInfo(betterproto.Message):
    # 倒计时 秒数
    countdown_num: int = betterproto.int32_field(1)
    # 阅读礼包状态 0-未领取 1-已领取
    read_status: int = betterproto.int32_field(2)
    # 阅读时长礼包 0-未领取 1-已领取
    read_duration_status: int = betterproto.int32_field(3)
    # 累计追漫数
    fav_num: int = betterproto.int32_field(4)
    # 追漫礼包状态 0-未领取 1-已领取
    fav_gift_status: int = betterproto.int32_field(5)


@dataclass
class GetNewerTaskInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "NewerTaskInfo" = betterproto.message_field(3)


@dataclass
class TakeGiftPackageReq(betterproto.Message):
    # 相关联ID等(气泡ID, 运营弹窗ID, 口令弹窗ID) 当 type=4 时， 累计阅读时长传 1，累计阅读章节数传 2，追漫传 3
    id: int = betterproto.int32_field(1)
    # 礼包相关联类型 1 首页运营弹窗 2 浮动气泡 3 口令弹窗 4 新手任务
    type: int = betterproto.int32_field(2)


@dataclass
class GetRemainMonthlyTicketsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetMonthTickets" = betterproto.message_field(3)


@dataclass
class GetMonthTickets(betterproto.Message):
    # 剩余月票数量
    amount: int = betterproto.int32_field(1)
    # 应援，对于一张月票来说已经应援的漫币的数
    reward_gold: int = betterproto.int32_field(2)
    # 应援解锁多少月票
    reward_tickets: int = betterproto.int32_field(3)
    # 一张月票，漫画解锁多少漫币
    comic_gold: int = betterproto.int32_field(4)
    # 购买漫画解锁多少张月票
    comic_tickets: int = betterproto.int32_field(5)
    # 服务器当前时间(2006-01-02 15:04:05)
    current_time: str = betterproto.string_field(6)
    # 多少漫币解锁一张月票
    gold_line: int = betterproto.int32_field(7)
    # 开通畅读卡赠送数量
    card_send_amount: int = betterproto.int32_field(8)


@dataclass
class GetValidationResp(betterproto.Message):
    # 异常code: 100000: "验证码获取失败",
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetValidationData" = betterproto.message_field(3)


@dataclass
class GetValidationData(betterproto.Message):
    # 验证码类型 img/geetest/tencent
    type: str = betterproto.string_field(1)
    token: str = betterproto.string_field(2)
    geetest: "Geetest" = betterproto.message_field(3)
    tencent: "Tencent" = betterproto.message_field(4)


@dataclass
class Tencent(betterproto.Message):
    appid: str = betterproto.string_field(1)


@dataclass
class Geetest(betterproto.Message):
    challenge: str = betterproto.string_field(1)
    gt: str = betterproto.string_field(2)


@dataclass
class SendSmsResp(betterproto.Message):
    # 异常code: 100001: "验证码校验失败", 100002: "验证码输入错误", 100003: "验证码过期", 100006:
    # "校验失败", 100008: "校验验证码失败", 100010: "短信发送失败", 100014: "短信发送次数本日已达上限",
    # 100015: "短信发送次数过多，请稍后再试", 100016: "短信已经发送",
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "SendSmsData" = betterproto.message_field(3)


@dataclass
class SendSmsData(betterproto.Message):
    token: str = betterproto.string_field(1)


@dataclass
class SendSmsReq(betterproto.Message):
    # 短消息内容类型(场景): 1. 解冻验证码
    sms_type: int = betterproto.int32_field(1)
    # GetValidation接口返回的token
    token: str = betterproto.string_field(2)
    # 图片验证码必传
    captcha: str = betterproto.string_field(3)
    # 极验必传
    challenge: str = betterproto.string_field(4)
    # 极验必传
    validate: str = betterproto.string_field(5)
    # 极验必传
    seccode: str = betterproto.string_field(6)
    # 验证码返回给用户的票据(腾讯云必传)
    ticket: str = betterproto.string_field(7)
    # 验证票据需要的随机字符串(腾讯云必传)
    randstr: str = betterproto.string_field(8)


@dataclass
class UnfreezeRiskUserReq(betterproto.Message):
    # 解冻验证码
    code: str = betterproto.string_field(1)
    # SendSms接口返回的token
    token: str = betterproto.string_field(2)


@dataclass
class ListMonthlyTicketsReq(betterproto.Message):
    # 月份（2006-01）
    date: str = betterproto.string_field(1)
    # 0-获取记录 1-消耗记录
    type: int = betterproto.int32_field(2)
    page_num: int = betterproto.int32_field(3)
    page_size: int = betterproto.int32_field(4)


@dataclass
class ChangeTeenagerModeSignReq(betterproto.Message):
    # 旧密码
    old_sign: str = betterproto.string_field(1)
    # 新密码
    new_sign: str = betterproto.string_field(2)


@dataclass
class TeenagerModeSignReq(betterproto.Message):
    # 青少年模式密码
    teenager_sign: str = betterproto.string_field(1)


@dataclass
class ListMonthlyTicketsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Tickets" = betterproto.message_field(3)


@dataclass
class Tickets(betterproto.Message):
    tickets: List["MonthlyTickets"] = betterproto.message_field(1)


@dataclass
class MonthlyTickets(betterproto.Message):
    # 月票数量
    amount: int = betterproto.int32_field(1)
    # 获取或者消耗的时间（2006-01-02 15:04:05）
    date: str = betterproto.string_field(2)
    # 仅对消耗月票的时候有用,漫画标题
    title: str = betterproto.string_field(3)


@dataclass
class UpdateNickNameReq(betterproto.Message):
    # 新昵称
    name: str = betterproto.string_field(1)


@dataclass
class IOSReviewInfo(betterproto.Message):
    # 是否需要弹窗
    pop: bool = betterproto.bool_field(1)


@dataclass
class IOSReviewResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "IOSReviewInfo" = betterproto.message_field(3)


@dataclass
class LoginResp(betterproto.Message):
    # 登录状态：0、成功；1、失败，请重新登录
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class UpdateAutoBuyComicReq(betterproto.Message):
    # 购买记录 id
    id: int = betterproto.int32_field(1)
    # 自动购买状态，1、漫读券优先; 2、关; 3、漫币优先
    gold_status: int = betterproto.int32_field(2)
    # 优惠券自动购买状态，1、开；2、关 此字段2.0后无效
    coupon_status: int = betterproto.int32_field(3)
    # 自动购买顺序, 从 v3.0 开始使用该字段 形如 1,2,3
    order: List[int] = betterproto.int32_field(4)
    # 是否开启自动购买 1 开启 2 关闭
    auto_pay_status: int = betterproto.int32_field(5)


@dataclass
class UserAutoBuyComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["UserAutoBuyComic"] = betterproto.message_field(3)


@dataclass
class UpdateConfReq(betterproto.Message):
    # 接收推送消息开关，1、开；2、关
    push_status: int = betterproto.int32_field(1)
    # 接收自动购买开关，1、开；2、关
    auto_buy_status: int = betterproto.int32_field(2)
    # 弹幕开关 1、开；2、关
    danmaku_status: int = betterproto.int32_field(3)
    # 1: 专 > 福 > 全 2: 优先到期
    coupon_consume_order: int = betterproto.int32_field(4)
    # 是否开启签到提醒推送, 0、不更改；1、开；2、关
    check_in_remind: int = betterproto.int32_field(5)
    # 卡券过期开关 1、开；2、关
    expire_remind: int = betterproto.int32_field(6)
    # 兴趣偏好推送开关 1、开；2、关
    interest_remind: int = betterproto.int32_field(7)
    # 禁止展示我最爱的漫画 1、禁止；2、不禁止
    hide_best_fav_comic: int = betterproto.int32_field(8)
    # 禁止展示我的漫画点评 1、禁止；2、不禁止
    hide_review: int = betterproto.int32_field(9)
    # 禁止展示我的追漫 1、禁止；2、不禁止
    hide_fav_comics: int = betterproto.int32_field(10)


@dataclass
class UserAutoBuyComic(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 漫画id
    comic_id: int = betterproto.int32_field(2)
    # 漫画标题
    comic_title: str = betterproto.string_field(3)
    # 横版封面
    hcover: str = betterproto.string_field(4)
    # 方版封面
    scover: str = betterproto.string_field(5)
    # 竖版封面
    vcover: str = betterproto.string_field(6)
    # 买了多少话 如果是按卷购买，为买了多少卷
    bought_ep_count: int = betterproto.int32_field(7)
    # 漫币自动购买状态，1、漫读券优先；2、关；3、漫币优先 v3.0 后开始废弃
    gold_status: int = betterproto.int32_field(8)
    # 优惠券自动购买状态，1、开；2、关 该字段已失效
    coupon_status: int = betterproto.int32_field(9)
    # 漫画上线状态: -1:下线 0:正常, 1:删除 2:定时发布
    comic_status: int = betterproto.int32_field(10)
    # 最新话数
    last_ord: float = betterproto.float_field(11)
    # 最初购买时间
    ctime: str = betterproto.string_field(12)
    # 最新短标题
    last_short_title: str = betterproto.string_field(13)
    # 漫画购买方式 9-按卷购买 12-退漫币 13-退卡券
    buy_type: int = betterproto.int32_field(14)
    # 当 buy_type=9 时为按卷购买下买了多少话 虽然上面已经有了 ep_count,但是因为老版本用来显示卷数量了，这里只能再搞一个变量
    ep_for_chapters: int = betterproto.int32_field(15)
    # 自动购买顺序, 从 v3.0 开始使用该字段 形如 1,2,3
    orders: List["AutoPayOrder"] = betterproto.message_field(16)
    enable_auto_pay: bool = betterproto.bool_field(17)


@dataclass
class AutoPayOrder(betterproto.Message):
    id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)


@dataclass
class UserBuyOrdersReq(betterproto.Message):
    # 支付方式 1.用漫币支付, 2.用券支付 3.限免卡 4.畅读券
    pay_type: int = betterproto.int32_field(1)
    # 页码
    page_num: int = betterproto.int32_field(2)
    # 条目数
    page_size: int = betterproto.int32_field(3)
    # 年份 范围 >= 2018; 范围<= 当前年份，不传该参数默认为当前年份
    order_year: int = betterproto.int32_field(4)
    # 月份 范围 1-12，不传该参数2019.6.1前返回该年所有数据, 6.1后返回当前月的数据
    order_month: int = betterproto.int32_field(5)
    # 指定查询打折卡 pay_type 要传 1
    assign_discount: bool = betterproto.bool_field(6)


@dataclass
class AutoBuyComicsReq(betterproto.Message):
    # 支付方式 - 1.用漫币支付, - 2.用券支付, - 100.所有开启中的支付方式,
    # 传此参数会隐去对应的支付方式中自动购买关闭的条目(自动购买开启的漫画), 不传的话则会返回所有条目(已购漫画)
    pay_type: int = betterproto.int32_field(1)
    # 页码
    page_num: int = betterproto.int32_field(2)
    # 条目数
    page_size: int = betterproto.int32_field(3)


@dataclass
class UserBuyOrdersResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["UserBuyOrder"] = betterproto.message_field(3)


@dataclass
class UserBuyOrder(betterproto.Message):
    # ep标题 如果是按卷购买，为卷标题
    ep_title: str = betterproto.string_field(1)
    # 漫画标题
    comic_title: str = betterproto.string_field(2)
    # 购买单话的ep_id 如果是按卷购买，为卷 id
    ep_id: int = betterproto.int32_field(3)
    # 订单创建时间
    ctime: str = betterproto.string_field(5)
    # 订单花多少金币
    pay_amount: int = betterproto.int32_field(6)
    # 订单消耗的券ID
    coupon_id: int = betterproto.int32_field(7)
    # 购买漫画的ID
    comic_id: int = betterproto.int32_field(8)
    # 话 ep 如果是按卷购买，为卷 ord
    ord: float = betterproto.float_field(9)
    # 购买话数
    buy_ep_cnt: int = betterproto.int32_field(10)
    # 短标题 如果是按卷购买，为卷短标题
    short_title: str = betterproto.string_field(11)
    # 购买类型: 5.打赏 9-按卷购买 12-退漫币(标题副标题取title,subtitle) 13-退卡券(同上)
    buy_type: int = betterproto.int32_field(12)
    # 订单id
    order_id: int = betterproto.int64_field(13)
    # 不识别 type 取此标题
    title: str = betterproto.string_field(14)
    # 不识别 type 取此子标题
    subtitle: str = betterproto.string_field(15)
    # 打折卡折扣
    discount: int = betterproto.int32_field(16)
    # 卡券类型文本
    coupon_type_txt: str = betterproto.string_field(17)
    # 打折卡优惠最大漫币额度
    discount_limit: int = betterproto.int32_field(18)
    # 消耗卡券数量
    coupon_amount: int = betterproto.int32_field(19)
    # 卡券角标(不识别的buy_type使用, 为空的时候使用默认角标)
    coupon_icon: str = betterproto.string_field(20)


@dataclass
class OrderDetailReq(betterproto.Message):
    # 订单id
    order_id: int = betterproto.int64_field(1)


@dataclass
class OrderDetailResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "OrderDetailData" = betterproto.message_field(3)


@dataclass
class OrderDetailData(betterproto.Message):
    # 订单id
    order_id: int = betterproto.int64_field(1)
    # 章节信息
    eps: List["EpInfo"] = betterproto.message_field(2)


@dataclass
class EpInfo(betterproto.Message):
    # 章节 id
    id: int = betterproto.int32_field(1)
    # 短标题
    short_title: str = betterproto.string_field(2)


@dataclass
class UserCouponsReq(betterproto.Message):
    # 未过期 true仅返回未过期券, false返回所有的券
    not_expired: bool = betterproto.bool_field(1)
    # 页码
    page_num: int = betterproto.int32_field(2)
    # 条目数
    page_size: int = betterproto.int32_field(3)
    # 1.漫读券, 2.限免卡, 3.打折卡
    tab_type: int = betterproto.int32_field(4)


@dataclass
class UserCouponsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserCoupons" = betterproto.message_field(4)


@dataclass
class UserCoupons(betterproto.Message):
    # 优惠券总次数
    total_remain_amount: int = betterproto.int32_field(1)
    user_coupons: List["UserCoupon"] = betterproto.message_field(2)
    # 从 3.2 开始打算逐渐弃用 获取状态使用 UserState 接口 确认状态使用 AckState 接口
    coupon_info: "UserStateData" = betterproto.message_field(3)


@dataclass
class UserCoupon(betterproto.Message):
    # 优惠券ID
    i_d: int = betterproto.int32_field(1)
    # 剩余多少张
    remain_amount: int = betterproto.int32_field(2)
    # 过期时间
    expire_time: str = betterproto.string_field(3)
    # 来源备注
    reason: str = betterproto.string_field(4)
    # 优惠券类型文本
    type: str = betterproto.string_field(5)
    # 获取时间
    ctime: str = betterproto.string_field(6)
    # 总共发放多少张
    total_amount: int = betterproto.int32_field(7)
    # 限定券限定漫画内容
    limits: List["CouponLimit"] = betterproto.message_field(8)
    # 优惠券类型, 1.全场券, 2.漫画专属券 3.限免卡 4.打折卡 5.全场限免卡
    type_num: int = betterproto.int32_field(9)
    # 是否存在过期漫读券，三天即将过期 0-不存在 1-存在
    will_expire: int = betterproto.int32_field(10)
    # 折扣 30 表示 3 折
    discount: int = betterproto.int32_field(11)
    # 折扣最大折扣漫币
    discount_limit: int = betterproto.int32_field(12)
    # 是否来自于漫读卡
    is_from_card: int = betterproto.int32_field(13)


@dataclass
class CouponLimit(betterproto.Message):
    # 限定维度类型(暂时只有漫画维度) 1.漫画
    type: int = betterproto.int32_field(1)
    # id内容取决于type 当 type 为 1 时，id 为 comic_id
    id: int = betterproto.int32_field(2)
    # title内容取决于type 当 type 为 1 时，title 为 漫画标题
    title: str = betterproto.string_field(3)


@dataclass
class UserWalletResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserWallet" = betterproto.message_field(3)


@dataclass
class UserWallet(betterproto.Message):
    # 剩余优惠券数
    remain_coupon: int = betterproto.int32_field(1)
    # 剩余漫币
    remain_gold: int = betterproto.int32_field(2)
    # 是否有首充奖励
    first_reward: bool = betterproto.bool_field(3)
    # 当前积分
    point: int = betterproto.int64_field(4)
    # 首充赠送比例 50 表示 50% 如果为 0 表示充值送漫读券
    first_bonus_percent: int = betterproto.int32_field(5)
    # 活动赠送比例 50 表示 50% 优先展示首充 没有活动则此字段自为 0
    bonus_percent: int = betterproto.int32_field(6)
    # 非当前平台的漫币 不可用漫币
    unusable_gold: int = betterproto.int32_field(7)
    # 剩余限免卡数量
    remain_item: int = betterproto.int32_field(8)
    # 剩余月票数
    remain_tickets: int = betterproto.int32_field(9)
    # 剩余打折卡数量
    remain_discount: int = betterproto.int32_field(10)
    # 账号等级 0: 低级 1: 中级 2: 高级
    account_level: int = betterproto.int32_field(11)
    # 充值入口文案
    pay_entry_txt: str = betterproto.string_field(12)
    # 充值活动
    pay_act: "PayAct" = betterproto.message_field(13)


@dataclass
class PayAct(betterproto.Message):
    # 充值活动开始时间 2006-01-02 15:04:05
    act_start_time: str = betterproto.string_field(1)
    # 充值活动结束时间 2006-01-02 15:04:05
    act_end_time: str = betterproto.string_field(2)
    # 充值活动入口文案
    act_entry_txt: str = betterproto.string_field(3)


@dataclass
class UserPayOrdersReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 条目数
    page_size: int = betterproto.int32_field(2)
    # 年份 范围 >= 2018; 范围<= 当前年份，不传该参数默认为当前年份
    order_year: int = betterproto.int32_field(3)
    # 月份 范围 1-12，不传该参数返回该年所有数据
    order_month: int = betterproto.int32_field(5)


@dataclass
class UserPayOrdersResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["UserPayOrder"] = betterproto.message_field(3)


@dataclass
class UserPayOrder(betterproto.Message):
    # 充了多少钱，单位：分
    pay_amount: int = betterproto.int32_field(1)
    # 换多少漫币
    product_amount: int = betterproto.int32_field(2)
    # 订单创建时间，格式 2018-01-01 12:14:15
    ctime: str = betterproto.string_field(3)
    # 支付方式，wechat, iap, bp, qpay, alipay
    pay_channel: str = betterproto.string_field(4)
    # 支付方式中文名称，微信, ios内购, B币, QQ钱包, 支付宝
    pay_channel_name: str = betterproto.string_field(5)
    # 奖励漫币总额
    extra_product_amount: int = betterproto.int32_field(6)
    # 订单号
    id: int = betterproto.int64_field(7)
    # 充值活动标识，非空表示含活动奖励
    activity: str = betterproto.string_field(8)


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class InitInfo(betterproto.Message):
    # 新送阅读券数量 请使用 Coupon 里字段
    new_coupon_num: int = betterproto.int32_field(1)
    # 是否开启推送
    push_enabled: bool = betterproto.bool_field(2)
    # 领到的漫读劵
    recieved_coupons: List["RecievedCoupon"] = betterproto.message_field(3)
    # 当前环境(DEV/UAT/PRE/PRO)
    env: str = betterproto.string_field(4)
    # 是否有新消息（包含评论消息和系统消息） 用作我的消息处红点提醒
    has_notice: bool = betterproto.bool_field(5)
    # 是否有系统消息 用作我的消息点进去后系统通知的红点提醒
    has_sys_notice: bool = betterproto.bool_field(6)
    # 新更新的追漫数量
    new_fav_num: int = betterproto.int32_field(7)
    # 请使用 Coupon 里字段 是否存在过期漫读券，三天即将过期 0-不存在 1-存在
    will_expire: int = betterproto.int32_field(8)
    # 是否有新的评论消息 用作我的消息点进去后评论的红点提醒
    has_reply_notice: bool = betterproto.bool_field(9)
    # 是否有新的点赞消息 用作我的消息点进去后点赞的红点提醒
    has_like_notice: bool = betterproto.bool_field(10)
    # 是否开启自动购买
    auto_buy_enabled: bool = betterproto.bool_field(11)
    # 绑定网易账号相关信息
    bind_netease: "BindNetease" = betterproto.message_field(12)
    # 是否关注官方账号
    had_follow_offcial: bool = betterproto.bool_field(13)
    # 是否开启弹幕
    danmaku_enable: bool = betterproto.bool_field(14)
    # 请使用 Coupon 里字段 是否存在过期限免卡，三天即将过期 0-不存在 1-存在
    rent_card_will_expire: int = betterproto.int32_field(15)
    # 请使用 Coupon 里字段 新限免卡数量
    new_rent_num: int = betterproto.int32_field(16)
    # 从 2.12 版本开始漫读券相关信息从这里取 从 3.2 开始打算逐渐弃用 使用 UserState 接口 用户漫读券信息
    coupon: "UserStateData" = betterproto.message_field(17)
    # 1: 专 > 福 > 全 2: 优先到期
    coupon_consume_order: int = betterproto.int32_field(18)
    # 青少年模式是否打开
    teenager_mode_on: bool = betterproto.bool_field(19)
    # 是否封禁
    is_banned: bool = betterproto.bool_field(20)
    # 冻结解冻时间 2006-01-02 15:04:05, 为空代表未冻结
    unfreeze_time: str = betterproto.string_field(21)
    # 是否开启签到提醒推送
    enable_check_in_remind: bool = betterproto.bool_field(22)
    # 卡券过期提醒
    expire_remind: bool = betterproto.bool_field(23)
    # 推送可能感兴趣的内容和福利
    interest_remind: bool = betterproto.bool_field(24)
    # 是否是点评管理员
    review_admin: bool = betterproto.bool_field(25)
    # 自我介绍
    intro: str = betterproto.string_field(26)
    # 封禁原因
    banned_reason: str = betterproto.string_field(27)


@dataclass
class CardInfo(betterproto.Message):
    # 过期时间
    expire_time: str = betterproto.string_field(1)
    # 未发放
    unsend: int = betterproto.int32_field(2)
    # 宣传文案
    copy_writing: str = betterproto.string_field(3)


@dataclass
class BindNetease(betterproto.Message):
    # 启用绑定网易账号入口
    enable_netease_entry: bool = betterproto.bool_field(1)
    # logo
    logo: str = betterproto.string_field(2)
    # 标题
    title: str = betterproto.string_field(3)
    # 跳转 URL
    jump_url: str = betterproto.string_field(4)


@dataclass
class RecievedCoupon(betterproto.Message):
    # 优惠券ID
    id: int = betterproto.int32_field(1)
    # 共有多少张
    amount: int = betterproto.int32_field(2)
    # 过期时间
    expire_time: str = betterproto.string_field(3)
    # 来源备注
    reason: str = betterproto.string_field(4)
    # 优惠券类型
    type: str = betterproto.string_field(5)
    # 获取时间
    ctime: str = betterproto.string_field(6)
    # 0 漫读券 1 畅读卡
    item_type: int = betterproto.int32_field(7)


@dataclass
class GetInitInfoResp(betterproto.Message):
    # 业务错误 * 1、用户初始化失败，请重新登录
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "InitInfo" = betterproto.message_field(3)


@dataclass
class AdviseReq(betterproto.Message):
    # 建议一级选项 1-阅读漫画 2-功能体验 3-漫画购入
    type: int = betterproto.int32_field(1)
    # QQ号
    qq: str = betterproto.string_field(2)
    # 反馈内容
    content: str = betterproto.string_field(3)
    # 反馈建议图片url
    image_url: str = betterproto.string_field(4)
    # 建议二级选项 阅读漫画 1-翻译错误、2-内容重复、3-页码问题、4-画质不清晰、5-加载过慢、6-购买后无法观看、7-其他、8-阅读器错误 功能体验
    # 1-功能建议、2-体验不佳、3-功能问题、4-其他 购入建议 1-日漫、2-国漫、3-美漫、4-韩漫、5-其他
    subtype: int = betterproto.int32_field(5)
    # 市场渠道包名
    android_channel: str = betterproto.string_field(6)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class FollowOffcialResp(betterproto.Message):
    # 1 没有绑定手机号 2 关注失败 3 查询用户信息失败
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CouponInfo" = betterproto.message_field(3)


@dataclass
class CouponInfo(betterproto.Message):
    # 券获取时间 形如: 2006-01-02
    ctime: str = betterproto.string_field(1)
    # 0 表示关注并发券成功 1 关注成功但是已领取奖励 (会附带已领取信息)
    status: int = betterproto.int32_field(2)


@dataclass
class NewbieInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "NewbieInfo" = betterproto.message_field(3)


@dataclass
class NewbieInfo(betterproto.Message):
    # 新人下载福利是否有效 有效：未领
    has_newbie_gift: bool = betterproto.bool_field(1)
    # PC 端新人礼包
    has_pc_newbie_gift: bool = betterproto.bool_field(2)
    # 领到的漫读劵
    coupons: List["ReceivableCoupon"] = betterproto.message_field(3)
    # PC 新人大礼包券数量
    pc_newbie_coupon_amount: int = betterproto.int32_field(4)
    # 是不是新人
    is_new_user: bool = betterproto.bool_field(5)
    # 能不能看见新手任务
    new_user_task: bool = betterproto.bool_field(6)


@dataclass
class ReceivableCoupon(betterproto.Message):
    # 数量
    amount: int = betterproto.int32_field(1)
    # 券名
    name: str = betterproto.string_field(2)


@dataclass
class PCNewbieGiftResp(betterproto.Message):
    # 1 用户未绑定手机号 2 用户已领取该奖励
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "PCNewbieGiftInfo" = betterproto.message_field(3)


@dataclass
class PCNewbieGiftInfo(betterproto.Message):
    # 赠送漫读券数量
    amount: int = betterproto.int32_field(1)


@dataclass
class VipRewardReq(betterproto.Message):
    # 领券 需要发放的漫读券 ID
    reason_id: int = betterproto.int32_field(1)
    # 1 表示领取月卡
    type: int = betterproto.int32_field(2)


@dataclass
class VipRewardResp(betterproto.Message):
    # 1 不是vip用户哦～ 2 invlid conf 3 invlid reason id 4 已领取不能重复领取 5 已达到领取上限啦~ 6
    # 不能重复领取 7 服务器繁忙请稍后再试 8 还不能领取 (非法时间)
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "VipRewardInfo" = betterproto.message_field(3)


@dataclass
class VipRewardInfo(betterproto.Message):
    amount: int = betterproto.int32_field(1)


@dataclass
class VipRewardComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "VipRewardComicsInfo" = betterproto.message_field(3)


@dataclass
class VipRewardComicsInfo(betterproto.Message):
    comics: List["RewardComic"] = betterproto.message_field(1)
    # 是否领取福利券礼包
    is_got_sp: bool = betterproto.bool_field(2)
    # 已领取次数
    has_got_num: int = betterproto.int32_field(3)
    # 特权券 ID
    sp_reason_id: int = betterproto.int32_field(4)
    # 最多领取次数 月度 5 年度 10
    max_num: int = betterproto.int32_field(5)
    # 说明文案
    title: str = betterproto.string_field(6)
    # 角标文案
    subtitle: str = betterproto.string_field(7)
    # 领取免费月卡
    got_free_card: bool = betterproto.bool_field(8)
    # 开启 vip 漫画池
    enable_vip_pool: bool = betterproto.bool_field(9)
    # 开启领取通用券
    enable_free_card: bool = betterproto.bool_field(10)
    # 大会员强制变更时间
    force_switch_time: str = betterproto.string_field(11)
    # 是否切换到新版
    is_switch_new: bool = betterproto.bool_field(12)
    # 领取畅读卡数量
    free_card_cnt: int = betterproto.int32_field(13)
    # 是否已领取大会员奖励 是否领取过老版的券(防薅羊毛)
    is_got_reward: bool = betterproto.bool_field(14)


@dataclass
class RewardComic(betterproto.Message):
    # 漫画 ID
    id: int = betterproto.int32_field(1)
    # 漫画封面
    cover: str = betterproto.string_field(2)
    # 漫画标题
    title: str = betterproto.string_field(3)
    # 是否领取
    is_got: bool = betterproto.bool_field(4)
    # 对应发放漫读券 id
    reason_id: int = betterproto.int32_field(5)


@dataclass
class UserStateResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserStateData" = betterproto.message_field(3)


@dataclass
class UserStateData(betterproto.Message):
    # 新送阅读券数量
    new_coupon_num: int = betterproto.int32_field(1)
    # 是否存在过期漫读券，三天即将过期 0-不存在 1-存在
    coupon_will_expire: int = betterproto.int32_field(2)
    # 是否存在过期限免卡，三天即将过期 0-不存在 1-存在
    rent_will_expire: int = betterproto.int32_field(3)
    # 新限免卡数量
    new_rent_num: int = betterproto.int32_field(4)
    # 是否存在过期打折卡，三天即将过期 0-不存在 1-存在
    discount_will_expire: int = betterproto.int32_field(5)
    # 新打折卡数量
    new_discount_num: int = betterproto.int32_field(6)
    # 是否存在过期月票，三天即将过期 0-不存在 1-存在
    month_ticket_will_expire: int = betterproto.int32_field(7)
    # 新月票数量
    new_month_ticket_num: int = betterproto.int32_field(8)
    # 畅读券即将过期
    silver_will_expire: int = betterproto.int32_field(9)
    # 新获得畅读券
    new_silver_num: int = betterproto.int32_field(10)
    # 剩余限免卡数量
    remain_item: int = betterproto.int32_field(11)
    # 剩余打折卡数量
    remain_discount: int = betterproto.int32_field(12)
    # 剩余优惠券数
    remain_coupon: int = betterproto.int32_field(13)
    # 剩余通用券数
    remain_silver: int = betterproto.int32_field(14)


@dataclass
class AckStateReq(betterproto.Message):
    # 1.漫读券红点 2.限免卡红点 3.打折卡红点 100.通用券红点 200.客户端在购买畅读卡 告知服务端取消了支付 300. 新卡面红点提醒
    # 500. 大会员统一切换到新版（年/月统一3张福利券+5张限定）
    type: int = betterproto.int32_field(1)


@dataclass
class TakeTokenGiftReq(betterproto.Message):
    token: str = betterproto.string_field(1)


@dataclass
class IsRecallUserReq(betterproto.Message):
    # @gt:0
    uid: int = betterproto.int64_field(1)


@dataclass
class IsRecallUserResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "IsRecallUserData" = betterproto.message_field(3)


@dataclass
class IsRecallUserData(betterproto.Message):
    # 是否是召回用户
    is_recall: bool = betterproto.bool_field(1)


@dataclass
class GetRecallInfoReq(betterproto.Message):
    # @gt:0
    uid: int = betterproto.int64_field(1)


@dataclass
class GetRecallInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetRecallInfoData" = betterproto.message_field(3)


@dataclass
class GetRecallInfoData(betterproto.Message):
    # 用户昵称
    name: str = betterproto.string_field(1)
    # 召回奖励信息
    recall_coupon_info: List["RecallCouponInfo"] = betterproto.message_field(2)


@dataclass
class RecallCouponInfo(betterproto.Message):
    # 卡券 ID
    id: int = betterproto.int32_field(1)
    # 卡券数量
    count: int = betterproto.int32_field(2)
    # 卡券类型 全场限免卡 TypeGlobalRentComic int32 = 5 全场优惠卡 TypeGlobalDiscountCard int32
    # = 6 全场福利券 TypeWelfareCoupon = 7
    type: int = betterproto.int32_field(3)


@dataclass
class GetRecallComicResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetRecallComicData" = betterproto.message_field(3)


@dataclass
class GetRecallComicData(betterproto.Message):
    # 召回用户推荐漫画
    recall_comic: List["RecallComic"] = betterproto.message_field(1)


@dataclass
class RecallComic(betterproto.Message):
    # 漫画 ID
    comic_id: int = betterproto.int32_field(1)
    # 漫画封面
    cover: str = betterproto.string_field(2)
    # 漫画标题
    title: str = betterproto.string_field(3)
    # 最新章节标题
    ep_latest_short_title: str = betterproto.string_field(4)
    # 上次阅读话标题 空则为推荐漫画
    ep_read_short_title: str = betterproto.string_field(5)
    # 上次阅读话 id
    ep_read_id: int = betterproto.int32_field(6)
    # 追漫数
    like: int = betterproto.int32_field(7)
    # 风格
    style: List[str] = betterproto.string_field(8)


@dataclass
class UpdateIntroReq(betterproto.Message):
    intro: str = betterproto.string_field(1)


@dataclass
class GetConfResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ConfData" = betterproto.message_field(3)


@dataclass
class ConfData(betterproto.Message):
    # 禁止展示我最爱的漫画 1、禁止；2、不禁止
    hide_best_fav_comic: bool = betterproto.bool_field(1)
    # 禁止展示我的漫画点评 1、禁止；2、不禁止
    hide_review: bool = betterproto.bool_field(2)
    # 禁止展示我的追漫 1、禁止；2、不禁止
    hide_fav_comics: bool = betterproto.bool_field(3)


@dataclass
class UpdateSpaceBackgroundReq(betterproto.Message):
    # 空间背景类型 1 - 畅读卡卡面
    background_type: int = betterproto.int32_field(1)
    # 空间背景ID
    background_id: int = betterproto.int32_field(2)


@dataclass
class GetMyAlbumReq(betterproto.Message):
    # @gt:0
    page_num: int = betterproto.int32_field(1)
    # @gt:0
    page_size: int = betterproto.int32_field(2)


@dataclass
class GetMyAlbumResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetMyAlbum" = betterproto.message_field(3)


@dataclass
class GetMyAlbum(betterproto.Message):
    comic_album: List["ComicAlbum"] = betterproto.message_field(1)


@dataclass
class ComicAlbum(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    comic_title: str = betterproto.string_field(2)
    # 漫画竖版封面
    vertical_cover: str = betterproto.string_field(3)
    album: List["Album"] = betterproto.message_field(4)


@dataclass
class Album(betterproto.Message):
    # 是否未解锁 true: 未解锁  false: 已解锁
    is_lock: bool = betterproto.bool_field(1)
    # 特典信息
    item: "AlbumDetail" = betterproto.message_field(2)


@dataclass
class AlbumDetail(betterproto.Message):
    # 特典 id
    id: int = betterproto.int32_field(1)
    # 特典标题
    title: str = betterproto.string_field(2)
    # 特典封面
    cover: str = betterproto.string_field(3)
    # 特典图片/动图链接
    pic: List[str] = betterproto.string_field(4)
    # 特典详情
    detail: str = betterproto.string_field(5)
    # 限量
    limits: int = betterproto.int32_field(6)
    # 图片类型 0-静态图片 1-gif 2-单话 3-视频
    pic_type: int = betterproto.int32_field(7)
    # 图片数量
    pic_num: int = betterproto.int32_field(8)
    # 生效时间 格式 "2006-01-02 15:04:05"
    online_time: str = betterproto.string_field(9)
    # 截止时间 格式 "2006-01-02 15:04:05"
    offline_time: str = betterproto.string_field(10)
    # 金额数目
    num: int = betterproto.int32_field(11)
    # 解锁方式 0-购买 1-应援 2-混合 3-活动 4-解锁指定章节 5-解锁指定卷
    type: int = betterproto.int32_field(12)
    # 图标
    icon: str = betterproto.string_field(13)
    # 活动 url
    activity_url: str = betterproto.string_field(14)
    # 活动名称
    activity_name: str = betterproto.string_field(15)
    # 需要解锁的章节 ID 列表或者卷 ID 列表
    item_ids: List[int] = betterproto.int32_field(16)


class UserStub(betterproto.ServiceStub):
    """User 服务"""

    @allure.step("""反馈建议 @auth""")
    def advise(self, request: AdviseReq) -> DefaultResponse:
        """反馈建议 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[advise]" + " api" + "=>" + """反馈建议 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/Advise", request, response)
        logging.getLogger(__name__).info("call " + "[advise]" + " api success!")
        return response

    @allure.step("""获取杂项配置信息 @auth""")
    def get_init_info(self, request: GetInitInfoReq) -> GetInitInfoResp:
        """获取杂项配置信息 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_init_info]" + " api" + "=>" + """获取杂项配置信息 @auth"""
        )
        response = GetInitInfoResp()
        self._do_twirp_rpc("/user.v1.User/GetInitInfo", request, response)
        logging.getLogger(__name__).info("call " + "[get_init_info]" + " api success!")
        return response

    @allure.step("""获取验证码初始化信息(验证真人) @auth""")
    def get_validation(self, request: EmptyRequest) -> GetValidationResp:
        """获取验证码初始化信息(验证真人) @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_validation]"
            + " api"
            + "=>"
            + """获取验证码初始化信息(验证真人) @auth"""
        )
        response = GetValidationResp()
        self._do_twirp_rpc("/user.v1.User/GetValidation", request, response)
        logging.getLogger(__name__).info("call " + "[get_validation]" + " api success!")
        return response

    @allure.step("""发送各类用户短消息 @auth""")
    def send_sms(self, request: SendSmsReq) -> SendSmsResp:
        """发送各类用户短消息 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[send_sms]" + " api" + "=>" + """发送各类用户短消息 @auth"""
        )
        response = SendSmsResp()
        self._do_twirp_rpc("/user.v1.User/SendSms", request, response)
        logging.getLogger(__name__).info("call " + "[send_sms]" + " api success!")
        return response

    @allure.step(
        """
        解除风控用户冻结 @auth 异常code 100011: "短信验证码错误", 100013: "短信验证码已过期，请重新发送",
        100017: "短信验证错误次数过多,请重新发送",
        """
    )
    def unfreeze_risk_user(self, request: UnfreezeRiskUserReq) -> DefaultResponse:
        """
        解除风控用户冻结 @auth 异常code 100011: "短信验证码错误", 100013: "短信验证码已过期，请重新发送",
        100017: "短信验证错误次数过多,请重新发送",
        """
        logging.getLogger(__name__).info(
            "start call "
            + "[unfreeze_risk_user]"
            + " api"
            + "=>"
            + """
        解除风控用户冻结 @auth 异常code 100011: "短信验证码错误", 100013: "短信验证码已过期，请重新发送",
        100017: "短信验证错误次数过多,请重新发送",
        """
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/UnfreezeRiskUser", request, response)
        logging.getLogger(__name__).info(
            "call " + "[unfreeze_risk_user]" + " api success!"
        )
        return response

    @allure.step("""用户剩余钱包 @auth""")
    def get_wallet(self, request: EmptyRequest) -> UserWalletResp:
        """用户剩余钱包 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_wallet]" + " api" + "=>" + """用户剩余钱包 @auth"""
        )
        response = UserWalletResp()
        self._do_twirp_rpc("/user.v1.User/GetWallet", request, response)
        logging.getLogger(__name__).info("call " + "[get_wallet]" + " api success!")
        return response

    @allure.step("""打开青少年模式 @auth""")
    def open_teenager_mode(self, request: TeenagerModeSignReq) -> DefaultResponse:
        """打开青少年模式 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[open_teenager_mode]" + " api" + "=>" + """打开青少年模式 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/OpenTeenagerMode", request, response)
        logging.getLogger(__name__).info(
            "call " + "[open_teenager_mode]" + " api success!"
        )
        return response

    @allure.step("""关闭青少年模式 code: 1 签名不对 @auth""")
    def close_teenager_mode(self, request: TeenagerModeSignReq) -> DefaultResponse:
        """关闭青少年模式 code: 1 签名不对 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[close_teenager_mode]"
            + " api"
            + "=>"
            + """关闭青少年模式 code: 1 签名不对 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/CloseTeenagerMode", request, response)
        logging.getLogger(__name__).info(
            "call " + "[close_teenager_mode]" + " api success!"
        )
        return response

    @allure.step("""更新青少年模式签名 code: 1 签名不对 @auth""")
    def change_teenager_mode_sign(
        self, request: ChangeTeenagerModeSignReq
    ) -> DefaultResponse:
        """更新青少年模式签名 code: 1 签名不对 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[change_teenager_mode_sign]"
            + " api"
            + "=>"
            + """更新青少年模式签名 code: 1 签名不对 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/ChangeTeenagerModeSign", request, response)
        logging.getLogger(__name__).info(
            "call " + "[change_teenager_mode_sign]" + " api success!"
        )
        return response

    @allure.step("""验证青少年模式签名 code: 1 签名不对 @auth""")
    def valid_teenager_mode_sign(self, request: TeenagerModeSignReq) -> DefaultResponse:
        """验证青少年模式签名 code: 1 签名不对 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[valid_teenager_mode_sign]"
            + " api"
            + "=>"
            + """验证青少年模式签名 code: 1 签名不对 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/ValidTeenagerModeSign", request, response)
        logging.getLogger(__name__).info(
            "call " + "[valid_teenager_mode_sign]" + " api success!"
        )
        return response

    @allure.step("""用户充值记录 @auth""")
    def get_pay_orders(self, request: UserPayOrdersReq) -> UserPayOrdersResp:
        """用户充值记录 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_pay_orders]" + " api" + "=>" + """用户充值记录 @auth"""
        )
        response = UserPayOrdersResp()
        self._do_twirp_rpc("/user.v1.User/GetPayOrders", request, response)
        logging.getLogger(__name__).info("call " + "[get_pay_orders]" + " api success!")
        return response

    @allure.step("""用户优惠券获取记录 @auth""")
    def get_coupons(self, request: UserCouponsReq) -> UserCouponsResp:
        """用户优惠券获取记录 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_coupons]" + " api" + "=>" + """用户优惠券获取记录 @auth"""
        )
        response = UserCouponsResp()
        self._do_twirp_rpc("/user.v1.User/GetCoupons", request, response)
        logging.getLogger(__name__).info("call " + "[get_coupons]" + " api success!")
        return response

    @allure.step("""用户购买记录 @auth""")
    def get_buy_orders(self, request: UserBuyOrdersReq) -> UserBuyOrdersResp:
        """用户购买记录 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_buy_orders]" + " api" + "=>" + """用户购买记录 @auth"""
        )
        response = UserBuyOrdersResp()
        self._do_twirp_rpc("/user.v1.User/GetBuyOrders", request, response)
        logging.getLogger(__name__).info("call " + "[get_buy_orders]" + " api success!")
        return response

    @allure.step("""查询订单购买所有章节信息 @auth""")
    def get_order_detail(self, request: OrderDetailReq) -> OrderDetailResp:
        """查询订单购买所有章节信息 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_order_detail]"
            + " api"
            + "=>"
            + """查询订单购买所有章节信息 @auth"""
        )
        response = OrderDetailResp()
        self._do_twirp_rpc("/user.v1.User/GetOrderDetail", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_order_detail]" + " api success!"
        )
        return response

    @allure.step("""用户购买过的漫画(原用户自动购买记录) @auth""")
    def get_auto_buy_comics(self, request: AutoBuyComicsReq) -> UserAutoBuyComicsResp:
        """用户购买过的漫画(原用户自动购买记录) @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_auto_buy_comics]"
            + " api"
            + "=>"
            + """用户购买过的漫画(原用户自动购买记录) @auth"""
        )
        response = UserAutoBuyComicsResp()
        self._do_twirp_rpc("/user.v1.User/GetAutoBuyComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_auto_buy_comics]" + " api success!"
        )
        return response

    @allure.step("""用户修改自动购买记录 @auth""")
    def update_auto_buy_comic(self, request: UpdateAutoBuyComicReq) -> DefaultResponse:
        """用户修改自动购买记录 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[update_auto_buy_comic]"
            + " api"
            + "=>"
            + """用户修改自动购买记录 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/UpdateAutoBuyComic", request, response)
        logging.getLogger(__name__).info(
            "call " + "[update_auto_buy_comic]" + " api success!"
        )
        return response

    @allure.step("""拿相关礼包 @auth""")
    def take_gift_package(self, request: TakeGiftPackageReq) -> DefaultResponse:
        """拿相关礼包 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[take_gift_package]" + " api" + "=>" + """拿相关礼包 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/TakeGiftPackage", request, response)
        logging.getLogger(__name__).info(
            "call " + "[take_gift_package]" + " api success!"
        )
        return response

    @allure.step("""领取口令礼包 @auth""")
    def take_token_gift(self, request: TakeTokenGiftReq) -> DefaultResponse:
        """领取口令礼包 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[take_token_gift]" + " api" + "=>" + """领取口令礼包 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/TakeTokenGift", request, response)
        logging.getLogger(__name__).info(
            "call " + "[take_token_gift]" + " api success!"
        )
        return response

    @allure.step("""用户更新个人配置 @auth""")
    def update_conf(self, request: UpdateConfReq) -> DefaultResponse:
        """用户更新个人配置 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[update_conf]" + " api" + "=>" + """用户更新个人配置 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/UpdateConf", request, response)
        logging.getLogger(__name__).info("call " + "[update_conf]" + " api success!")
        return response

    @allure.step("""用户获取个人配置 @auth""")
    def get_conf(self, request: EmptyRequest) -> GetConfResp:
        """用户获取个人配置 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_conf]" + " api" + "=>" + """用户获取个人配置 @auth"""
        )
        response = GetConfResp()
        self._do_twirp_rpc("/user.v1.User/GetConf", request, response)
        logging.getLogger(__name__).info("call " + "[get_conf]" + " api success!")
        return response

    @allure.step("""用户更新空间背景 @auth""")
    def update_space_background(
        self, request: UpdateSpaceBackgroundReq
    ) -> DefaultResponse:
        """用户更新空间背景 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[update_space_background]"
            + " api"
            + "=>"
            + """用户更新空间背景 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/UpdateSpaceBackground", request, response)
        logging.getLogger(__name__).info(
            "call " + "[update_space_background]" + " api success!"
        )
        return response

    @allure.step("""用户更新个人描述 @auth""")
    def update_intro(self, request: UpdateIntroReq) -> DefaultResponse:
        """用户更新个人描述 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[update_intro]" + " api" + "=>" + """用户更新个人描述 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/UpdateIntro", request, response)
        logging.getLogger(__name__).info("call " + "[update_intro]" + " api success!")
        return response

    @allure.step("""用户登录接口 客户端在主站登录成功后立即调用本接口 如果本接口返回失败，则认为登录失败 @auth""")
    def login(self, request: EmptyRequest) -> LoginResp:
        """用户登录接口 客户端在主站登录成功后立即调用本接口 如果本接口返回失败，则认为登录失败 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[login]"
            + " api"
            + "=>"
            + """用户登录接口 客户端在主站登录成功后立即调用本接口 如果本接口返回失败，则认为登录失败 @auth"""
        )
        response = LoginResp()
        self._do_twirp_rpc("/user.v1.User/Login", request, response)
        logging.getLogger(__name__).info("call " + "[login]" + " api success!")
        return response

    @allure.step("""ios 获取评价弹窗信息 @auth""")
    def get_i_o_s_review(self, request: EmptyRequest) -> IOSReviewResp:
        """ios 获取评价弹窗信息 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_i_o_s_review]"
            + " api"
            + "=>"
            + """ios 获取评价弹窗信息 @auth"""
        )
        response = IOSReviewResp()
        self._do_twirp_rpc("/user.v1.User/GetIOSReview", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_i_o_s_review]" + " api success!"
        )
        return response

    @allure.step("""永久关闭评价弹窗 @auth""")
    def disable_i_o_s_review(self, request: EmptyRequest) -> DefaultResponse:
        """永久关闭评价弹窗 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[disable_i_o_s_review]"
            + " api"
            + "=>"
            + """永久关闭评价弹窗 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/DisableIOSReview", request, response)
        logging.getLogger(__name__).info(
            "call " + "[disable_i_o_s_review]" + " api success!"
        )
        return response

    @allure.step("""关注官方账号发放漫读券 @auth""")
    def follow_offcial(self, request: EmptyRequest) -> FollowOffcialResp:
        """关注官方账号发放漫读券 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[follow_offcial]" + " api" + "=>" + """关注官方账号发放漫读券 @auth"""
        )
        response = FollowOffcialResp()
        self._do_twirp_rpc("/user.v1.User/FollowOffcial", request, response)
        logging.getLogger(__name__).info("call " + "[follow_offcial]" + " api success!")
        return response

    @allure.step("""获取用户新人下载福利信息 @auth""")
    def get_newbie_info(self, request: EmptyRequest) -> NewbieInfoResp:
        """获取用户新人下载福利信息 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_newbie_info]"
            + " api"
            + "=>"
            + """获取用户新人下载福利信息 @auth"""
        )
        response = NewbieInfoResp()
        self._do_twirp_rpc("/user.v1.User/GetNewbieInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_newbie_info]" + " api success!"
        )
        return response

    @allure.step("""用户月票余额信息 @auth""")
    def get_remain_monthly_tickets(
        self, request: EmptyRequest
    ) -> GetRemainMonthlyTicketsResp:
        """用户月票余额信息 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_remain_monthly_tickets]"
            + " api"
            + "=>"
            + """用户月票余额信息 @auth"""
        )
        response = GetRemainMonthlyTicketsResp()
        self._do_twirp_rpc("/user.v1.User/GetRemainMonthlyTickets", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_remain_monthly_tickets]" + " api success!"
        )
        return response

    @allure.step("""用户月票获取记录 @auth""")
    def list_monthly_tickets(
        self, request: ListMonthlyTicketsReq
    ) -> ListMonthlyTicketsResp:
        """用户月票获取记录 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[list_monthly_tickets]"
            + " api"
            + "=>"
            + """用户月票获取记录 @auth"""
        )
        response = ListMonthlyTicketsResp()
        self._do_twirp_rpc("/user.v1.User/ListMonthlyTickets", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_monthly_tickets]" + " api success!"
        )
        return response

    @allure.step("""获取 PC 新人大礼包 @auth""")
    def get_p_c_newbie_gift(self, request: EmptyRequest) -> PCNewbieGiftResp:
        """获取 PC 新人大礼包 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_p_c_newbie_gift]"
            + " api"
            + "=>"
            + """获取 PC 新人大礼包 @auth"""
        )
        response = PCNewbieGiftResp()
        self._do_twirp_rpc("/user.v1.User/GetPCNewbieGift", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_p_c_newbie_gift]" + " api success!"
        )
        return response

    @allure.step("""编辑用户昵称 @auth""")
    def update_nick_name(self, request: UpdateNickNameReq) -> DefaultResponse:
        """编辑用户昵称 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[update_nick_name]" + " api" + "=>" + """编辑用户昵称 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/UpdateNickName", request, response)
        logging.getLogger(__name__).info(
            "call " + "[update_nick_name]" + " api success!"
        )
        return response

    @allure.step("""领取 vip 福利等 @auth""")
    def get_vip_reward(self, request: VipRewardReq) -> VipRewardResp:
        """领取 vip 福利等 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_vip_reward]" + " api" + "=>" + """领取 vip 福利等 @auth"""
        )
        response = VipRewardResp()
        self._do_twirp_rpc("/user.v1.User/GetVipReward", request, response)
        logging.getLogger(__name__).info("call " + "[get_vip_reward]" + " api success!")
        return response

    @allure.step("""vip 特权可领取的漫画 @auth""")
    def get_vip_reward_comics(self, request: EmptyRequest) -> VipRewardComicsResp:
        """vip 特权可领取的漫画 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_vip_reward_comics]"
            + " api"
            + "=>"
            + """vip 特权可领取的漫画 @auth"""
        )
        response = VipRewardComicsResp()
        self._do_twirp_rpc("/user.v1.User/GetVipRewardComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_vip_reward_comics]" + " api success!"
        )
        return response

    @allure.step("""获取新手用户信息 @auth""")
    def get_newer_task_info(self, request: EmptyRequest) -> GetNewerTaskInfoResp:
        """获取新手用户信息 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_newer_task_info]"
            + " api"
            + "=>"
            + """获取新手用户信息 @auth"""
        )
        response = GetNewerTaskInfoResp()
        self._do_twirp_rpc("/user.v1.User/GetNewerTaskInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_newer_task_info]" + " api success!"
        )
        return response

    @allure.step("""红点状态 @auth""")
    def get_states(self, request: EmptyRequest) -> UserStateResp:
        """红点状态 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[get_states]" + " api" + "=>" + """红点状态 @auth"""
        )
        response = UserStateResp()
        self._do_twirp_rpc("/user.v1.User/GetStates", request, response)
        logging.getLogger(__name__).info("call " + "[get_states]" + " api success!")
        return response

    @allure.step("""确认红点状态 @auth""")
    def ack_state(self, request: AckStateReq) -> DefaultResponse:
        """确认红点状态 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[ack_state]" + " api" + "=>" + """确认红点状态 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/AckState", request, response)
        logging.getLogger(__name__).info("call " + "[ack_state]" + " api success!")
        return response

    @allure.step("""阅读器内掉落卡券 @auth""")
    def get_reader_welfare(self, request: GetReaderWelfareReq) -> GetReaderWelfareResp:
        """阅读器内掉落卡券 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_reader_welfare]"
            + " api"
            + "=>"
            + """阅读器内掉落卡券 @auth"""
        )
        response = GetReaderWelfareResp()
        self._do_twirp_rpc("/user.v1.User/GetReaderWelfare", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_reader_welfare]" + " api success!"
        )
        return response

    @allure.step("""领取卡券 @auth""")
    def take_reader_welfare(self, request: TakeReaderWelfareReq) -> DefaultResponse:
        """领取卡券 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[take_reader_welfare]" + " api" + "=>" + """领取卡券 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/TakeReaderWelfare", request, response)
        logging.getLogger(__name__).info(
            "call " + "[take_reader_welfare]" + " api success!"
        )
        return response

    @allure.step("""获取用户是否是召回用户""")
    def is_recall_user(self, request: IsRecallUserReq) -> IsRecallUserResp:
        """获取用户是否是召回用户"""
        logging.getLogger(__name__).info(
            "start call " + "[is_recall_user]" + " api" + "=>" + """获取用户是否是召回用户"""
        )
        response = IsRecallUserResp()
        self._do_twirp_rpc("/user.v1.User/IsRecallUser", request, response)
        logging.getLogger(__name__).info("call " + "[is_recall_user]" + " api success!")
        return response

    @allure.step("""获取召回信息 code - 1 没有召回福利""")
    def get_recall_info(self, request: GetRecallInfoReq) -> GetRecallInfoResp:
        """获取召回信息 code - 1 没有召回福利"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_recall_info]"
            + " api"
            + "=>"
            + """获取召回信息 code - 1 没有召回福利"""
        )
        response = GetRecallInfoResp()
        self._do_twirp_rpc("/user.v1.User/GetRecallInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_recall_info]" + " api success!"
        )
        return response

    @allure.step("""领取召回礼包 code - 1 没有召回福利 @auth""")
    def take_recall_reward(self, request: EmptyRequest) -> DefaultResponse:
        """领取召回礼包 code - 1 没有召回福利 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[take_recall_reward]"
            + " api"
            + "=>"
            + """领取召回礼包 code - 1 没有召回福利 @auth"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/user.v1.User/TakeRecallReward", request, response)
        logging.getLogger(__name__).info(
            "call " + "[take_recall_reward]" + " api success!"
        )
        return response

    @allure.step("""获取召回用户推荐漫画 @auth""")
    def get_recall_comic(self, request: EmptyRequest) -> GetRecallComicResp:
        """获取召回用户推荐漫画 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_recall_comic]"
            + " api"
            + "=>"
            + """获取召回用户推荐漫画 @auth"""
        )
        response = GetRecallComicResp()
        self._do_twirp_rpc("/user.v1.User/GetRecallComic", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_recall_comic]" + " api success!"
        )
        return response

    @allure.step("""查询小黑屋信息 @auth""")
    def get_black_house_info(self, request: EmptyRequest) -> GetBlackHouseInfoResp:
        """查询小黑屋信息 @auth"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_black_house_info]"
            + " api"
            + "=>"
            + """查询小黑屋信息 @auth"""
        )
        response = GetBlackHouseInfoResp()
        self._do_twirp_rpc("/user.v1.User/GetBlackHouseInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_black_house_info]" + " api success!"
        )
        return response

    @allure.step("""@auth 获取我的特典""")
    def get_my_album(self, request: GetMyAlbumReq) -> GetMyAlbumResp:
        """@auth 获取我的特典"""
        logging.getLogger(__name__).info(
            "start call " + "[get_my_album]" + " api" + "=>" + """@auth 获取我的特典"""
        )
        response = GetMyAlbumResp()
        self._do_twirp_rpc("/user.v1.User/GetMyAlbum", request, response)
        logging.getLogger(__name__).info("call " + "[get_my_album]" + " api success!")
        return response
