# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: user/v1/space.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class UIDReq(betterproto.Message):
    uid: int = betterproto.int64_field(1)


@dataclass
class UIDWithPagniateReq(betterproto.Message):
    uid: int = betterproto.int64_field(1)
    # 单页数量
    page_size: int = betterproto.int32_field(2)
    # 分页页数
    page_num: int = betterproto.int32_field(3)


@dataclass
class BaseSpaceInfo(betterproto.Message):
    # 昵称
    nickname: str = betterproto.string_field(1)
    # 头像
    avatar: str = betterproto.string_field(2)
    # 自我介绍
    intro: str = betterproto.string_field(3)
    # 性别
    sex: str = betterproto.string_field(4)
    # 活跃天数
    active_day: int = betterproto.int32_field(5)
    # 阅读话数
    read_cnt: int = betterproto.int32_field(6)
    # 点赞数量
    like_cnt: int = betterproto.int32_field(7)
    # 隐藏最爱的漫画
    hide_best_fav_comic: bool = betterproto.bool_field(8)
    # 隐藏点评
    hide_review: bool = betterproto.bool_field(9)
    # 隐藏追漫
    hide_fav_comics: bool = betterproto.bool_field(10)
    # 空间背景类型 1 - 畅读卡卡面
    background_type: int = betterproto.int32_field(11)
    # 空间背景ID
    background_id: int = betterproto.int32_field(12)
    # 空间背景url
    background_uri: str = betterproto.string_field(13)
    # 畅读卡卡面标题
    card_cover_title: str = betterproto.string_field(14)
    # 畅读卡卡面uri资源
    card_cover_uri: str = betterproto.string_field(15)
    # 背景渐变色
    gradient_color: List[str] = betterproto.string_field(16)
    # 畅读卡卡面version
    card_cover_version: int = betterproto.int32_field(17)
    # 挂件字段
    pendant_image: str = betterproto.string_field(18)
    pendant_image_enhance: str = betterproto.string_field(19)
    pendant_name: str = betterproto.string_field(20)
    pendant_expire: int = betterproto.int64_field(21)
    pendant_id: int = betterproto.int32_field(22)


@dataclass
class GetBaseInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BaseSpaceInfo" = betterproto.message_field(3)


@dataclass
class GetFavComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FavComicsData" = betterproto.message_field(3)


@dataclass
class FavComicsData(betterproto.Message):
    # 追漫漫画
    fav_comics: List["FavComic"] = betterproto.message_field(2)


@dataclass
class FavComic(betterproto.Message):
    id: int = betterproto.int64_field(1)
    # 漫画ID
    comic_id: int = betterproto.int32_field(2)
    # 标题
    title: str = betterproto.string_field(3)
    # 竖版封面
    vcover: str = betterproto.string_field(4)
    # 标签
    styles: List[str] = betterproto.string_field(5)
    # 是否共同追漫
    is_fav_togeter: bool = betterproto.bool_field(6)


@dataclass
class GetBestFavComicResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BestFavComicData" = betterproto.message_field(3)


@dataclass
class BestFavComicData(betterproto.Message):
    best_fav_comic: "BestFavComic" = betterproto.message_field(1)


@dataclass
class BestFavComic(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 竖版封面
    vcover: str = betterproto.string_field(3)
    # 阅读单话话数
    read_ep_cnt: int = betterproto.int32_field(4)
    # 粉丝值
    fans: int = betterproto.int32_field(5)
    # 月票值
    tickets: int = betterproto.int32_field(6)
    # 最高排名
    best_rank: int = betterproto.int32_field(7)
    # 最高排名月份
    best_rank_month: int = betterproto.int32_field(8)
    # 最高排名榜单 1 - 投喂总榜 2 - 投喂月榜 3 - 月票总榜 4 - 月票月榜
    best_rank_type: int = betterproto.int32_field(9)
    # 总单话数量
    ep_total: int = betterproto.int32_field(10)


@dataclass
class GetReviewsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ReviewsData" = betterproto.message_field(3)


@dataclass
class ReviewsData(betterproto.Message):
    reviews: List["Review"] = betterproto.message_field(1)


@dataclass
class Review(betterproto.Message):
    # 点评分数
    score: int = betterproto.int32_field(1)
    # 创建时间 2006-01-02 15:04:06
    ctime: str = betterproto.string_field(2)
    # 点评标题
    title: str = betterproto.string_field(3)
    # 点评内容
    content: str = betterproto.string_field(4)
    # 漫画ID
    comic_id: int = betterproto.int32_field(5)
    # 漫画标题
    comic_title: str = betterproto.string_field(6)
    # 漫画封面
    comic_vcover: str = betterproto.string_field(7)
    # 畅读卡标签
    styles: List[str] = betterproto.string_field(8)
    # 畅读卡作者
    authors: List[str] = betterproto.string_field(9)
    # 点评ID
    review_id: int = betterproto.int64_field(10)
    # 点评类型 0-短评 1-长评
    review_type: int = betterproto.int32_field(11)


class SpaceStub(betterproto.ServiceStub):
    """Space 服务 用户相关不需要强登录态的接口"""

    @allure.step("""获取用户空间基本信息""")
    def get_base_space_info(self, request: UIDReq) -> GetBaseInfoResp:
        """获取用户空间基本信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_base_space_info]" + " api" + "=>" + """获取用户空间基本信息"""
        )
        response = GetBaseInfoResp()
        self._do_twirp_rpc("/user.v1.Space/GetBaseSpaceInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_base_space_info]" + " api success!"
        )
        return response

    @allure.step("""获取用户最爱漫画""")
    def get_best_fav_comic(self, request: UIDReq) -> GetBestFavComicResp:
        """获取用户最爱漫画"""
        logging.getLogger(__name__).info(
            "start call " + "[get_best_fav_comic]" + " api" + "=>" + """获取用户最爱漫画"""
        )
        response = GetBestFavComicResp()
        self._do_twirp_rpc("/user.v1.Space/GetBestFavComic", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_best_fav_comic]" + " api success!"
        )
        return response

    @allure.step("""获取用户追漫""")
    def get_fav_comics(self, request: UIDWithPagniateReq) -> GetFavComicsResp:
        """获取用户追漫"""
        logging.getLogger(__name__).info(
            "start call " + "[get_fav_comics]" + " api" + "=>" + """获取用户追漫"""
        )
        response = GetFavComicsResp()
        self._do_twirp_rpc("/user.v1.Space/GetFavComics", request, response)
        logging.getLogger(__name__).info("call " + "[get_fav_comics]" + " api success!")
        return response

    @allure.step("""获取用户点评""")
    def get_reviews(self, request: UIDWithPagniateReq) -> GetReviewsResp:
        """获取用户点评"""
        logging.getLogger(__name__).info(
            "start call " + "[get_reviews]" + " api" + "=>" + """获取用户点评"""
        )
        response = GetReviewsResp()
        self._do_twirp_rpc("/user.v1.Space/GetReviews", request, response)
        logging.getLogger(__name__).info("call " + "[get_reviews]" + " api success!")
        return response
