# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: review/v1/review.proto
# plugin: python-betterproto
import logging
from typing import List, Optional

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class DetailScore(betterproto.Message):
    # 剧情
    plot: int = betterproto.int32_field(1)
    # 画面
    picture: int = betterproto.int32_field(2)
    # 角色
    character: int = betterproto.int32_field(3)


@dataclass
class DefaultResponseWithInt64ID(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DataWithInt64ID" = betterproto.message_field(3)


@dataclass
class DataWithInt64ID(betterproto.Message):
    id: int = betterproto.int64_field(1)


@dataclass
class AddReviewResp(betterproto.Message):
    # 1-漫画门槛不满足 2-用户点评门槛不满足 3-高危敏感词，禁止发表 500-调用主站点评服务添加内容失败
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "AddReview" = betterproto.message_field(3)


@dataclass
class AddReview(betterproto.Message):
    # 发表成功的 点评 id
    id: int = betterproto.int64_field(1)
    # 当 code = 2 时，具体的用户门槛条件
    threshold: "UserThreshold" = betterproto.message_field(2)


@dataclass
class UserThreshold(betterproto.Message):
    # true 完全满足用户门槛 完全满足用户门槛不用判断下面的字段
    entitled: bool = betterproto.bool_field(1)
    # 是否满足绑定手机号 true 满足
    phone: bool = betterproto.bool_field(2)
    # 登陆条件
    login: "UserLogin" = betterproto.message_field(3)
    # 阅读漫画条件
    read: "Read" = betterproto.message_field(4)


@dataclass
class UserLogin(betterproto.Message):
    # 需要登陆多少天可以满足条件
    login: int = betterproto.int32_field(1)
    # 已经登陆多少天
    has_login: int = betterproto.int32_field(2)


@dataclass
class Read(betterproto.Message):
    # 阅读多少本满足条件
    reads: int = betterproto.int32_field(1)
    # 已经阅读多少本
    has_readed: int = betterproto.int32_field(2)


@dataclass
class EditReviewReq(betterproto.Message):
    id: int = betterproto.int64_field(1)
    # 类型 短评改长评可以，长评改短评不行 0-短评 1-长评
    type: int = betterproto.int32_field(2)
    # 点评总分
    score: int = betterproto.int32_field(3)
    # 细分场景打分
    detail: "DetailScore" = betterproto.message_field(4)
    # 点评内容
    content: str = betterproto.string_field(5)
    # 点评标题
    review_title: str = betterproto.string_field(6)
    comic_id: int = betterproto.int32_field(7)
    # 是否修改过内容和标题 true 内容或者标题有一个修改过
    modify: bool = betterproto.bool_field(8)
    # 剧透  0-不包含  1-包含
    spoiler: int = betterproto.int32_field(9)


@dataclass
class EditReviewResp(betterproto.Message):
    # 1-长评不允许修改为点评 2-已有点评内容不能编辑为空 3-高危敏感词，禁止编辑 500-调用主站点评服务编辑内容失败
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class GetReviewByIDReq(betterproto.Message):
    # 点评 id
    id: int = betterproto.int64_field(1)


@dataclass
class GetReviewByIDResp(betterproto.Message):
    # 1-审核不通过/删除等 500-主站点评服务获取详情失败
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetReviewByID" = betterproto.message_field(3)


@dataclass
class GetReviewByID(betterproto.Message):
    review: "ReviewInfo" = betterproto.message_field(1)


@dataclass
class ReviewInfo(betterproto.Message):
    # 点评 id
    id: int = betterproto.int64_field(1)
    # 用户 uid
    uid: int = betterproto.int64_field(2)
    # 账户昵称
    nick_name: str = betterproto.string_field(3)
    # 用户头像
    face: str = betterproto.string_field(4)
    # 漫画 id
    comic_id: int = betterproto.int32_field(5)
    # 漫画标题
    title: str = betterproto.string_field(6)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(7)
    # 0-短评 1-长评
    type: int = betterproto.int32_field(8)
    # 点评标题 长评才有
    review_title: str = betterproto.string_field(9)
    # 点评内容
    content: str = betterproto.string_field(10)
    # 查看自己的点评才区分审核不审核，别人的点评能看就是审核通过的 0-通过 -1 待审 -2 审核不通过 -10086 删除，暂时没有这种状态
    verify: int = betterproto.int32_field(11)
    # 点评分数
    score: int = betterproto.int32_field(12)
    # 细分场景打分
    detail: "DetailScore" = betterproto.message_field(13)
    # 服务器当前时间
    current_time: str = betterproto.string_field(14)
    # 分数上次修改时间
    score_update_time: str = betterproto.string_field(15)
    # day 天内不能修改，根据服务器当前时间和分数上次修改时间，端上先做个拦截判断
    day: int = betterproto.int32_field(16)
    # 创建时间(2006-01-02 15:04:05)
    ctime: str = betterproto.string_field(17)
    # 更新时间(2006-01-02 15:04:05)
    mtime: str = betterproto.string_field(18)
    # 作者
    authors: List[str] = betterproto.string_field(19)
    # 风格
    styles: List[str] = betterproto.string_field(20)
    # 拒绝原因
    reject_reason: str = betterproto.string_field(21)
    # 点赞数
    like_count: int = betterproto.int32_field(22)
    # 点赞动作 0-无动作 1-点赞过 2-点踩过
    like_action: int = betterproto.int32_field(23)
    # 点评评论数量
    comment_count: int = betterproto.int32_field(24)
    # 点评最新点赞人列表 只在详情里面返回，列表接口不返回
    users: List["LikeUsers"] = betterproto.message_field(25)
    # 剧透   0-不包含 1-包含
    spoiler: int = betterproto.int32_field(26)
    # true 是热评
    is_hot: bool = betterproto.bool_field(27)
    # 漫画点评分数
    comic_score: float = betterproto.double_field(28)
    # 漫画用户最终修改时间
    umtime: str = betterproto.string_field(29)


@dataclass
class LikeUsers(betterproto.Message):
    # 点赞人 uid
    uid: int = betterproto.int64_field(1)
    # 点赞人昵称
    nick_name: str = betterproto.string_field(2)
    # 点赞人头像
    face: str = betterproto.string_field(3)


@dataclass
class GetUserReviewByComicIDReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)


@dataclass
class GetUserReviewByComicIDResp(betterproto.Message):
    # 500-主站点评服务获取详情失败
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetReviewByComicID" = betterproto.message_field(3)


@dataclass
class GetReviewByComicID(betterproto.Message):
    review: "ReviewInfo" = betterproto.message_field(1)


@dataclass
class ListReviewsReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    page_size: int = betterproto.int32_field(2)
    page_num: int = betterproto.int32_field(3)
    # 类型 0-短评 1-长评 如果指定类型，则只请求对应类型的数据
    type: int = betterproto.int32_field(4)
    # 排序纬度 0-热度 1-时间
    sort: int = betterproto.int32_field(5)


@dataclass
class ListReviewsResp(betterproto.Message):
    # 500-主站点评服务获取详情失败
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListReviews" = betterproto.message_field(3)


@dataclass
class ListReviews(betterproto.Message):
    # 对应类型的点评总数 用来计算总分页数
    total_reviews: int = betterproto.int32_field(5)
    # 点评列表
    reviews: List["ReviewInfo"] = betterproto.message_field(7)


@dataclass
class GetDetailByComicIDResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetDetailByComicID" = betterproto.message_field(3)


@dataclass
class GetDetailByComicID(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 点评总人数
    num: int = betterproto.int32_field(3)
    # 点评总分
    score: float = betterproto.double_field(4)
    # 短评总数
    total_short_reviews: int = betterproto.int32_field(5)
    # 长评总数
    total_long_reviews: int = betterproto.int32_field(6)
    # 用户是否点评过 true 没有点评过
    not_reviewed: bool = betterproto.bool_field(7)
    # 漫画门槛是否满足 true 满足
    comic_threshold: bool = betterproto.bool_field(8)
    # 如果是登陆用户，会额外返回用户门槛
    user_threshold: "UserThreshold" = betterproto.message_field(9)
    # 是否满足有效分资格 true 不满足
    score_limit: bool = betterproto.bool_field(10)
    # 详情页是否展示点评模块 true 不展示
    forbidden_review: bool = betterproto.bool_field(11)
    # app 排行榜信息
    rank: "Rank" = betterproto.message_field(12)
    # 多少人在看
    watch: int = betterproto.int64_field(13)
    # 主分类
    main_style: str = betterproto.string_field(14)
    # 主分类的百分比排名
    order: float = betterproto.float_field(15)
    # 精选短评
    short_reviews: List["ReviewInfo"] = betterproto.message_field(16)
    # 精选长评
    long_reviews: List["ReviewInfo"] = betterproto.message_field(17)


@dataclass
class Rank(betterproto.Message):
    # 排行榜名称
    name: str = betterproto.string_field(1)
    # 排行榜名次
    order: int = betterproto.int32_field(2)


@dataclass
class ReportReviewReq(betterproto.Message):
    # 类型 0-违反法律法规 1-侵犯个人权益 2-有害社区环境 3-屏蔽点评 4-加入黑名单 5-置底点评
    type: int = betterproto.int32_field(1)
    # 违反法律法规 1-违法违规2-色情 3-赌博诈骗 4-低俗 侵犯个人权益 5-侵犯隐私 6-人身攻击 有害社区环境 7-垃圾广告 8-引战 9-剧透
    # 10-抢楼 11-内容不相关 12-其他
    sub_type: int = betterproto.int32_field(2)
    # 举报的点评 id
    id: int = betterproto.int64_field(3)
    # 被拉黑的 uid
    black_uid: int = betterproto.int64_field(4)


@dataclass
class ActiveScoreReq(betterproto.Message):
    # 单话 id
    ep_id: int = betterproto.int32_field(1)


@dataclass
class DelReviewReq(betterproto.Message):
    # 点评 ID
    id: int = betterproto.int64_field(1)


class ReviewStub(betterproto.ServiceStub):
    """Review 点评服务对外"""

    @allure.step("""发表点评""")
    def add_review(self, request: EditReviewReq) -> AddReviewResp:
        """发表点评"""
        logging.getLogger(__name__).info(
            "start call " + "[add_review]" + " api" + "=>" + """发表点评"""
        )
        response = AddReviewResp()
        self._do_twirp_rpc("/review.v1.Review/AddReview", request, response)
        logging.getLogger(__name__).info("call " + "[add_review]" + " api success!")
        return response

    @allure.step("""编辑点评""")
    def edit_review(self, request: EditReviewReq) -> EditReviewResp:
        """编辑点评"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_review]" + " api" + "=>" + """编辑点评"""
        )
        response = EditReviewResp()
        self._do_twirp_rpc("/review.v1.Review/EditReview", request, response)
        logging.getLogger(__name__).info("call " + "[edit_review]" + " api success!")
        return response

    @allure.step("""查询某个点评""")
    def get_review_by_i_d(self, request: GetReviewByIDReq) -> GetReviewByIDResp:
        """查询某个点评"""
        logging.getLogger(__name__).info(
            "start call " + "[get_review_by_i_d]" + " api" + "=>" + """查询某个点评"""
        )
        response = GetReviewByIDResp()
        self._do_twirp_rpc("/review.v1.Review/GetReviewByID", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_review_by_i_d]" + " api success!"
        )
        return response

    @allure.step("""获取指定用户在漫画下的点评""")
    def get_user_review_by_comic_i_d(
        self, request: GetUserReviewByComicIDReq
    ) -> GetUserReviewByComicIDResp:
        """获取指定用户在漫画下的点评"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_user_review_by_comic_i_d]"
            + " api"
            + "=>"
            + """获取指定用户在漫画下的点评"""
        )
        response = GetUserReviewByComicIDResp()
        self._do_twirp_rpc(
            "/review.v1.Review/GetUserReviewByComicID", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_user_review_by_comic_i_d]" + " api success!"
        )
        return response

    @allure.step("""查询漫画下的点评列表""")
    def list_reviews(self, request: ListReviewsReq) -> ListReviewsResp:
        """查询漫画下的点评列表"""
        logging.getLogger(__name__).info(
            "start call " + "[list_reviews]" + " api" + "=>" + """查询漫画下的点评列表"""
        )
        response = ListReviewsResp()
        self._do_twirp_rpc("/review.v1.Review/ListReviews", request, response)
        logging.getLogger(__name__).info("call " + "[list_reviews]" + " api success!")
        return response

    @allure.step("""查询漫画维度的点评数据""")
    def get_review_detail_by_comic_i_d(
        self, request: GetUserReviewByComicIDReq
    ) -> GetDetailByComicIDResp:
        """查询漫画维度的点评数据"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_review_detail_by_comic_i_d]"
            + " api"
            + "=>"
            + """查询漫画维度的点评数据"""
        )
        response = GetDetailByComicIDResp()
        self._do_twirp_rpc(
            "/review.v1.Review/GetReviewDetailByComicID", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_review_detail_by_comic_i_d]" + " api success!"
        )
        return response

    @allure.step("""举报""")
    def report_review(self, request: ReportReviewReq) -> DefaultResponse:
        """举报"""
        logging.getLogger(__name__).info(
            "start call " + "[report_review]" + " api" + "=>" + """举报"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/review.v1.Review/ReportReview", request, response)
        logging.getLogger(__name__).info("call " + "[report_review]" + " api success!")
        return response

    @allure.step("""最新章节末尾激活有效资格""")
    def active_score(self, request: ActiveScoreReq) -> DefaultResponse:
        """最新章节末尾激活有效资格"""
        logging.getLogger(__name__).info(
            "start call " + "[active_score]" + " api" + "=>" + """最新章节末尾激活有效资格"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/review.v1.Review/ActiveScore", request, response)
        logging.getLogger(__name__).info("call " + "[active_score]" + " api success!")
        return response

    @allure.step("""删除点评""")
    def del_review(self, request: DelReviewReq) -> DefaultResponse:
        """删除点评"""
        logging.getLogger(__name__).info(
            "start call " + "[del_review]" + " api" + "=>" + """删除点评"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/review.v1.Review/DelReview", request, response)
        logging.getLogger(__name__).info("call " + "[del_review]" + " api success!")
        return response
