# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: open/v1/open.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class GetComicIDsListReq(betterproto.Message):
    # 最新话更新时间: 秒级时间戳, 当更新时间不存在时, 最新话更新时间为0 返回该时间戳之后有更新的漫画ID
    last_update_time: int = betterproto.int64_field(1)


@dataclass
class GetComicIDsListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetComicIDsListData" = betterproto.message_field(3)


@dataclass
class GetComicIDsListData(betterproto.Message):
    comic_ids: List[int] = betterproto.int32_field(1)


@dataclass
class GetComicDetailReq(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)


@dataclass
class GetComicDetailResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetComicDetailData" = betterproto.message_field(3)


@dataclass
class GetComicDetailData(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)
    # 作者名
    author_name: List[str] = betterproto.string_field(4)
    # 风格标签
    styles: List[str] = betterproto.string_field(5)
    # 简介
    evaluate: str = betterproto.string_field(6)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(7)
    # 最新话更新时间: 秒级时间戳, 当更新时间不存在时, 最新话更新时间为0
    last_update_time: int = betterproto.int64_field(8)
    # 漫画类型 0:条漫 1:页漫
    comic_type: int = betterproto.int32_field(9)
    # 单话列表
    ep_list: List["Episode"] = betterproto.message_field(10)


@dataclass
class Episode(betterproto.Message):
    # 话ID epid
    id: int = betterproto.int32_field(1)
    # 完整话名
    title: str = betterproto.string_field(2)
    # 话标题(短)
    short_title: str = betterproto.string_field(3)
    # 更新发布时间: 秒级时间戳, 当更新时间不存在时, 最新话更新时间为0
    pub_time: int = betterproto.int64_field(4)
    # 话顺序
    ord: float = betterproto.float_field(5)
    # 付费模式 0.免费, 1.付费
    pay_mode: int = betterproto.int32_field(6)
    # 收费价格(单位: 分)
    pay_gold: int = betterproto.int32_field(7)


@dataclass
class GetEpisodeImgsReq(betterproto.Message):
    # 单话ID
    ep_id: int = betterproto.int32_field(1)


@dataclass
class GetEpisodeImgsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetEpisodeImgsData" = betterproto.message_field(3)


@dataclass
class GetEpisodeImgsData(betterproto.Message):
    # 话ID epid
    id: int = betterproto.int32_field(1)
    # 完整话名
    title: str = betterproto.string_field(2)
    # 话标题(短)
    short_title: str = betterproto.string_field(3)
    # 更新发布时间: 秒级时间戳, 当更新时间不存在时, 最新话更新时间为0
    pub_time: int = betterproto.int64_field(4)
    # 话顺序
    ord: float = betterproto.float_field(5)
    # 付费模式 0.免费, 1.付费
    pay_mode: int = betterproto.int32_field(6)
    # 收费价格(单位: 分)
    pay_gold: int = betterproto.int32_field(7)
    # 漫画ID
    comic_id: int = betterproto.int32_field(8)
    # 图片url（链接有时效性, 15分钟）
    imgs: List[str] = betterproto.string_field(9)


class OpenStub(betterproto.ServiceStub):
    """第三方服务(如分销接口) 分销接口公共字段: app_key"""

    @allure.step("""获取分销漫画列表""")
    def get_comic_i_ds_list(self, request: GetComicIDsListReq) -> GetComicIDsListResp:
        """获取分销漫画列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_i_ds_list]" + " api" + "=>" + """获取分销漫画列表"""
        )
        response = GetComicIDsListResp()
        self._do_twirp_rpc("/open.v1.Open/GetComicIDsList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_i_ds_list]" + " api success!"
        )
        return response

    @allure.step("""获取漫画详情, 包括有单话列表""")
    def get_comic_detail(self, request: GetComicDetailReq) -> GetComicDetailResp:
        """获取漫画详情, 包括有单话列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_detail]" + " api" + "=>" + """获取漫画详情, 包括有单话列表"""
        )
        response = GetComicDetailResp()
        self._do_twirp_rpc("/open.v1.Open/GetComicDetail", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_detail]" + " api success!"
        )
        return response

    @allure.step("""获取漫画详情, 包括有单话列表""")
    def get_episode_imgs(self, request: GetEpisodeImgsReq) -> GetEpisodeImgsResp:
        """获取漫画详情, 包括有单话列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_episode_imgs]" + " api" + "=>" + """获取漫画详情, 包括有单话列表"""
        )
        response = GetEpisodeImgsResp()
        self._do_twirp_rpc("/open.v1.Open/GetEpisodeImgs", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_episode_imgs]" + " api success!"
        )
        return response
