# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: manage/v1/manage.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EditComicTagsReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    main_style_id: int = betterproto.int32_field(2)
    tag_ids: List[int] = betterproto.int32_field(3)


@dataclass
class ComicTagListReq(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)


@dataclass
class ComicTagListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicTagListData" = betterproto.message_field(3)


@dataclass
class ComicTagListData(betterproto.Message):
    main_style_id: int = betterproto.int32_field(1)
    tags: List["Tag"] = betterproto.message_field(2)


@dataclass
class AllTagListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "AllTagListData" = betterproto.message_field(3)


@dataclass
class AllTagListData(betterproto.Message):
    results: List["TagGroup"] = betterproto.message_field(1)


@dataclass
class TagGroup(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)
    operator: str = betterproto.string_field(3)
    select_type: int = betterproto.int32_field(4)
    tags: List["Tag"] = betterproto.message_field(5)


@dataclass
class Tag(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)


@dataclass
class EditComicReq(betterproto.Message):
    # 连载模式 0 单篇 1连载
    is_finish: int = betterproto.int32_field(1)
    # 连载状态,  1:完结 0:连载中 -1:未开刊
    mode: int = betterproto.int32_field(2)
    # 漫画ID
    id: int = betterproto.int32_field(3)
    # 总集数
    length: int = betterproto.int32_field(4)
    # 连载状态 0-正常 1-休刊
    serial_status: int = betterproto.int32_field(5)
    # 临时休刊时间 带时区的时间格式 time.RFC3339
    temporary_finish_time: str = betterproto.string_field(6)


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class AddVerifyReq(betterproto.Message):
    # 要审核的单话ID(必须已经上传好图片Index)
    id: int = betterproto.int32_field(1)


@dataclass
class UploadImageReq(betterproto.Message):
    # 图片类型 1 漫画图片 2 漫画封面
    image_type: int = betterproto.int32_field(1)
    # 漫画 ID
    comic_id: int = betterproto.int32_field(2)
    # 单话 ID
    ep_id: int = betterproto.int32_field(3)


@dataclass
class UploadImageResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UploadImageData" = betterproto.message_field(3)


@dataclass
class UploadImageData(betterproto.Message):
    url: str = betterproto.string_field(1)


@dataclass
class ResetTokenReq(betterproto.Message):
    # 用户MID
    mid: int = betterproto.int64_field(1)


@dataclass
class ResetTokenResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ResetTokenData" = betterproto.message_field(3)


@dataclass
class ResetTokenData(betterproto.Message):
    # 接口令牌(请妥善保管，遗失的话请重新生成)
    token: str = betterproto.string_field(1)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class EpOnlineReq(betterproto.Message):
    # 单话ID
    epid: int = betterproto.int32_field(1)
    # 上线状态 0-上线 2-定时上线
    status: int = betterproto.int32_field(2)
    # 同步修改漫画连载状态 0-不修改连载状态(对应页面上的不勾选或者取消勾选) 1-修改为连载中 2-修改为已完结
    finish_status: int = betterproto.int32_field(3)
    # 上线时间(北京时间) 格式: 2020-04-11 16:11:36
    pub_time: str = betterproto.string_field(4)


@dataclass
class AddUserReq(betterproto.Message):
    # 用户MID
    mid: int = betterproto.int64_field(1)
    # 备注
    remark: str = betterproto.string_field(2)
    # 访问模式 0 普通, 1 支持api访问
    access_mode: int = betterproto.int32_field(3)


@dataclass
class EditUserReq(betterproto.Message):
    # 用户MID
    mid: int = betterproto.int64_field(1)
    # 角色ID 1-普通用户 2-管理员
    role_id: int = betterproto.int32_field(2)
    # 备注
    remark: str = betterproto.string_field(3)
    # 漫画ID列表
    cids: List[int] = betterproto.int32_field(4)
    # 电子邮箱
    email: str = betterproto.string_field(5)
    # 访问模式 0 普通, 1 支持api访问
    access_mode: int = betterproto.int32_field(6)


@dataclass
class EditEmailReq(betterproto.Message):
    email: str = betterproto.string_field(1)


@dataclass
class DelUserReq(betterproto.Message):
    # 用户ID
    mid: int = betterproto.int64_field(1)


@dataclass
class UserListReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 条目数
    page_size: int = betterproto.int32_field(2)
    # ID
    id: int = betterproto.int64_field(3)
    # 标注
    remark: str = betterproto.string_field(4)


@dataclass
class UserListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserListData" = betterproto.message_field(3)


@dataclass
class UserListData(betterproto.Message):
    # 总页数
    max_page: int = betterproto.int32_field(1)
    list: List["UserList"] = betterproto.message_field(2)


@dataclass
class UserList(betterproto.Message):
    # 用户ID
    mid: int = betterproto.int64_field(1)
    # 备注
    remark: str = betterproto.string_field(2)
    # 角色ID
    role_id: int = betterproto.int32_field(3)
    # 访问模式 0 普通, 1 支持api访问
    access_mode: int = betterproto.int32_field(4)
    # 电子邮箱
    email: str = betterproto.string_field(5)


@dataclass
class UserInfoReq(betterproto.Message):
    # 用户ID
    mid: int = betterproto.int64_field(1)


@dataclass
class UserInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserInfoData" = betterproto.message_field(3)


@dataclass
class UserInfoData(betterproto.Message):
    # 用户ID
    mid: int = betterproto.int64_field(1)
    # 角色ID
    role_id: int = betterproto.int32_field(2)
    # 备注
    remark: str = betterproto.string_field(3)
    # 漫画列表
    comic_list: List["ComicName"] = betterproto.message_field(4)
    # 电子邮箱
    email: str = betterproto.string_field(5)
    # 访问模式 0 普通, 1 支持api访问
    access_mode: int = betterproto.int32_field(6)


@dataclass
class ComicName(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画名
    name: str = betterproto.string_field(2)


@dataclass
class ComicListReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 条目数
    page_size: int = betterproto.int32_field(2)
    # 漫画ID
    cid: int = betterproto.int32_field(3)
    # 漫画名
    title: str = betterproto.string_field(4)


@dataclass
class ComicListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicListData" = betterproto.message_field(3)


@dataclass
class ComicListData(betterproto.Message):
    # 总页数
    max_page: int = betterproto.int32_field(1)
    list: List["ComicList"] = betterproto.message_field(2)


@dataclass
class ComicList(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 漫画名
    title: str = betterproto.string_field(2)
    # 单话总数
    cnt: int = betterproto.int32_field(3)
    # 建议付费模式
    pay_mode: int = betterproto.int32_field(4)
    # -1:下线 0:正常 1:删除 2:定时发布
    comic_status: int = betterproto.int32_field(5)
    # -1下架 0正常
    wiki_status: int = betterproto.int32_field(6)
    # 百科ID 小于等于0 代表未关联存在且有效的百科
    wiki_id: int = betterproto.int32_field(7)


@dataclass
class EpisodeListReq(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 页码
    page_num: int = betterproto.int32_field(2)
    # 条目数
    page_size: int = betterproto.int32_field(3)


@dataclass
class EpisodeListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EpisodeListData" = betterproto.message_field(3)


@dataclass
class EpisodeListData(betterproto.Message):
    # 总页数
    max_page: int = betterproto.int32_field(1)
    list: List["EpisodeList"] = betterproto.message_field(2)


@dataclass
class EpisodeList(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 话ID
    ep_id: int = betterproto.int32_field(2)
    # 序号
    ord: float = betterproto.float_field(3)
    # 标题
    title: str = betterproto.string_field(4)
    # 状态：0正常 1下线 2待上架（定时上线）
    status: int = betterproto.int32_field(5)
    # 修改时间 RFC3339 2006-01-02T15:04:05+07:00
    mtime: str = betterproto.string_field(6)
    # 短标题（话数）
    short_title: str = betterproto.string_field(7)
    # 付费模式 0免费 1付费 2按卷付费
    pay_mode: int = betterproto.int32_field(8)
    # 审核状态
    verify: int = betterproto.int32_field(9)
    # 审核驳回原因
    verify_reason: str = betterproto.string_field(10)
    show_type: int = betterproto.int32_field(11)
    chapter_short_title: str = betterproto.string_field(12)


@dataclass
class EpisodeDetailReq(betterproto.Message):
    # 话ID
    ep_id: int = betterproto.int32_field(1)


@dataclass
class EpisodeDetailResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EpisodeDetail" = betterproto.message_field(3)


@dataclass
class EpisodeDetail(betterproto.Message):
    # 单话id(epid)
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 漫画ID
    comic_id: int = betterproto.int32_field(3)
    # 序号
    ord: float = betterproto.float_field(4)
    # 上线状态 0正常 1下线 2待上架（定时上线）
    status: int = betterproto.int32_field(5)
    # 付费模式 0免费 1付费
    pay_mode: int = betterproto.int32_field(6)
    # 单话推广封面
    cover: str = betterproto.string_field(7)
    # 索引文件
    index: str = betterproto.string_field(8)
    # 短标题（话数）
    short_title: str = betterproto.string_field(9)
    # 单话大小
    size: int = betterproto.int32_field(10)
    # 发布时间 RFC3339 2006-01-02T15:04:05+07:00
    pub_time: str = betterproto.string_field(11)
    # 卷 id
    chapter_id: int = betterproto.int32_field(12)
    # 同步修改漫画连载状态标示 1-修改漫画为连载中 2-修改为已完结
    finish_status: int = betterproto.int32_field(13)
    # 单话类型 0-正文、1-活动、2-番外、3-公告、4-预告、100-其他
    type: int = betterproto.int32_field(14)


@dataclass
class AddEpisodeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "AddEpisodeData" = betterproto.message_field(3)


@dataclass
class AddEpisodeData(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class AddEpisodeReq(betterproto.Message):
    # 标题
    title: str = betterproto.string_field(1)
    # 漫画ID
    comic_id: int = betterproto.int32_field(2)
    # 序号(用于排序)
    ord: float = betterproto.float_field(3)
    # 付费模式 0免费 1付费
    pay_mode: int = betterproto.int32_field(4)
    # 单话推广封面
    cover: str = betterproto.string_field(5)
    # 创建人
    mid: int = betterproto.int64_field(6)
    # 短标题（话数）
    short_title: str = betterproto.string_field(7)
    # 卷 id
    chapter_id: int = betterproto.int32_field(8)
    # 单话类型 0-正文、1-活动、2-番外、3-公告、4-预告、100-其他
    type: int = betterproto.int32_field(9)


@dataclass
class EditEpisodeReq(betterproto.Message):
    # 单话id(epid)
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 漫画ID
    comic_id: int = betterproto.int32_field(3)
    # 序号
    ord: float = betterproto.float_field(4)
    # 付费模式 0免费 1付费
    pay_mode: int = betterproto.int32_field(5)
    # 单话推广封面
    cover: str = betterproto.string_field(6)
    # 索引文件
    index: str = betterproto.string_field(7)
    # 修改人
    mid: int = betterproto.int64_field(8)
    # 短标题（话数）
    short_title: str = betterproto.string_field(9)
    # 单话大小
    size: int = betterproto.int32_field(10)
    # 卷 id
    chapter_id: int = betterproto.int32_field(11)
    # 单话类型 0-正文、1-活动、2-番外、3-公告、4-预告、100-其他
    type: int = betterproto.int32_field(12)


@dataclass
class ListChaptersReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)


@dataclass
class ListChaptersResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListChapters" = betterproto.message_field(3)


@dataclass
class ListChapters(betterproto.Message):
    chapters: List["Chapter"] = betterproto.message_field(1)


@dataclass
class Chapter(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 长标题
    title: str = betterproto.string_field(2)
    # 短标题
    short_title: str = betterproto.string_field(3)
    # 漫画 id
    comic_id: int = betterproto.int32_field(4)
    # 序号
    ord: float = betterproto.float_field(5)
    # 0-未开卷 1-连载中 2-已完结
    is_finished: int = betterproto.int32_field(6)
    # 0-下线 1-上线 2-定时上线
    status: int = betterproto.int32_field(7)
    # 0-免费 1-付费
    pay_mode: int = betterproto.int32_field(8)
    # 金币
    gold: int = betterproto.int32_field(9)
    # 实付金币
    real_gold: int = betterproto.int32_field(10)
    # 封面
    cover: str = betterproto.string_field(11)
    # 预计话数
    expected_eps: int = betterproto.int32_field(12)
    # 列表接口使用，添加和修改卷不需要 上线时间(2019-10-01 00:00:00)
    online_time: str = betterproto.string_field(13)
    # 0-非预售 1-预售
    is_presale: int = betterproto.int32_field(14)
    # 预售文案
    presale_text: str = betterproto.string_field(15)
    # 预售截止时间 (2006-01-02 15:04:05)
    presale_time: str = betterproto.string_field(16)


@dataclass
class IndexUploadRequest(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    epid: int = betterproto.int32_field(2)
    # [{"url":"http://i0.hdslb.com/bfs/comic/24970/232810/data.index", "cx":100,
    # "cy":200}]
    json_data: str = betterproto.string_field(3)


@dataclass
class IndexUploadResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "IndexUpload" = betterproto.message_field(3)


@dataclass
class IndexUpload(betterproto.Message):
    pics: List[str] = betterproto.string_field(1)


@dataclass
class BfsTokenReq(betterproto.Message):
    # ["http://1.jpg", "http://2.jpg"]
    urls: str = betterproto.string_field(1)
    # method
    method: str = betterproto.string_field(2)


@dataclass
class BfsTokenResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["Token"] = betterproto.message_field(3)


@dataclass
class Token(betterproto.Message):
    url: str = betterproto.string_field(1)
    token: str = betterproto.string_field(2)


@dataclass
class GetComicRequest(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)


@dataclass
class GetComicResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Comic" = betterproto.message_field(3)


@dataclass
class Comic(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 关联漫画百科ID
    info_id: int = betterproto.int32_field(3)
    # 关联UP
    mid: int = betterproto.int64_field(4)
    # 漫画类型 0:条漫 1:页漫
    comic_type: int = betterproto.int32_field(5)
    # 默认翻页方式, 1:竖屏滚动，2:竖屏翻页 4:日漫，8:横屏
    page_default: int = betterproto.int32_field(6)
    # 允许翻页方式,位运算, 1:竖屏滚动，2：竖屏翻页，4：日漫，8:横屏
    page_allow: int = betterproto.int32_field(7)
    # 上线状态, -1:下线 0:正常 2:定时发布
    status: int = betterproto.int32_field(8)
    # 上线时间 RFC3339 2006-01-02T15:04:05+07:00
    release_time: str = betterproto.string_field(9)
    # 默认推广图 16:9
    default_cover: str = betterproto.string_field(10)
    # 连载类型, 连载类型, 0:单篇 1:连载
    mode: int = betterproto.int32_field(11)
    # 连载状态, 1:完结 0:连载中 -1:未开刊
    is_finish: int = betterproto.int32_field(12)
    # 总集数
    length: int = betterproto.int32_field(13)
    # 关联番剧seasonid 目前仅支持一个
    animation_seasonid: int = betterproto.int32_field(14)
    # 建议付费模式 0:免费 1:付费
    pay_mode: int = betterproto.int32_field(15)
    # 漫币价格
    gold: int = betterproto.int64_field(16)
    # 优惠漫币价格
    real_gold: int = betterproto.int64_field(17)
    # 银豆价
    silver: int = betterproto.int64_field(18)
    # 允许使用阅读券
    coupons: bool = betterproto.bool_field(19)
    # 禁止评论
    no_comment: bool = betterproto.bool_field(20)
    # 禁止搜索
    no_search: bool = betterproto.bool_field(21)
    # 禁止上线推送
    no_push: bool = betterproto.bool_field(22)
    # 版权性质 1-独家 2-首发 3-合作
    copyright: int = betterproto.int32_field(23)
    # 允许观看平台 位操作 1-ios 2-android 4-ipad 8-web
    watch_platform: int = betterproto.int32_field(24)
    # 地区限制组
    limit_group: int = betterproto.int32_field(25)
    # 允许下载 1-允许 0-禁止
    download: int = betterproto.int32_field(26)
    # 创建人
    cuser: str = betterproto.string_field(27)
    # 漫画展示形式 0-单话展示 1-按卷展示
    show_type: int = betterproto.int32_field(28)
    # 连载状态 0-正常 1-休刊
    serial_status: int = betterproto.int32_field(29)
    # 临时休刊时间,time.RFC3339,带时区时间
    temporary_finish_time: str = betterproto.string_field(30)


class ManageStub(betterproto.ServiceStub):
    """Manage 服务"""

    @allure.step("""上传图片(api)""")
    def upload_image(self, request: UploadImageReq) -> UploadImageResp:
        """上传图片(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[upload_image]" + " api" + "=>" + """上传图片(api)"""
        )
        response = UploadImageResp()
        self._do_twirp_rpc("/manage.v1.Manage/UploadImage", request, response)
        logging.getLogger(__name__).info("call " + "[upload_image]" + " api success!")
        return response

    @allure.step("""添加用户""")
    def add_user(self, request: AddUserReq) -> DefaultResponse:
        """添加用户"""
        logging.getLogger(__name__).info(
            "start call " + "[add_user]" + " api" + "=>" + """添加用户"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/AddUser", request, response)
        logging.getLogger(__name__).info("call " + "[add_user]" + " api success!")
        return response

    @allure.step("""修改用户权限""")
    def edit_user(self, request: EditUserReq) -> DefaultResponse:
        """修改用户权限"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_user]" + " api" + "=>" + """修改用户权限"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/EditUser", request, response)
        logging.getLogger(__name__).info("call " + "[edit_user]" + " api success!")
        return response

    @allure.step("""修改用户邮箱""")
    def edit_email(self, request: EditEmailReq) -> DefaultResponse:
        """修改用户邮箱"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_email]" + " api" + "=>" + """修改用户邮箱"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/EditEmail", request, response)
        logging.getLogger(__name__).info("call " + "[edit_email]" + " api success!")
        return response

    @allure.step("""删除用户""")
    def del_user(self, request: DelUserReq) -> DefaultResponse:
        """删除用户"""
        logging.getLogger(__name__).info(
            "start call " + "[del_user]" + " api" + "=>" + """删除用户"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/DelUser", request, response)
        logging.getLogger(__name__).info("call " + "[del_user]" + " api success!")
        return response

    @allure.step("""用户列表""")
    def user_list(self, request: UserListReq) -> UserListResp:
        """用户列表"""
        logging.getLogger(__name__).info(
            "start call " + "[user_list]" + " api" + "=>" + """用户列表"""
        )
        response = UserListResp()
        self._do_twirp_rpc("/manage.v1.Manage/UserList", request, response)
        logging.getLogger(__name__).info("call " + "[user_list]" + " api success!")
        return response

    @allure.step("""用户信息""")
    def user_info(self, request: UserInfoReq) -> UserInfoResp:
        """用户信息"""
        logging.getLogger(__name__).info(
            "start call " + "[user_info]" + " api" + "=>" + """用户信息"""
        )
        response = UserInfoResp()
        self._do_twirp_rpc("/manage.v1.Manage/UserInfo", request, response)
        logging.getLogger(__name__).info("call " + "[user_info]" + " api success!")
        return response

    @allure.step("""重设用户令牌""")
    def reset_token(self, request: ResetTokenReq) -> ResetTokenResp:
        """重设用户令牌"""
        logging.getLogger(__name__).info(
            "start call " + "[reset_token]" + " api" + "=>" + """重设用户令牌"""
        )
        response = ResetTokenResp()
        self._do_twirp_rpc("/manage.v1.Manage/ResetToken", request, response)
        logging.getLogger(__name__).info("call " + "[reset_token]" + " api success!")
        return response

    @allure.step("""漫画列表(当前用户权限)(api)""")
    def comic_list(self, request: ComicListReq) -> ComicListResp:
        """漫画列表(当前用户权限)(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[comic_list]" + " api" + "=>" + """漫画列表(当前用户权限)(api)"""
        )
        response = ComicListResp()
        self._do_twirp_rpc("/manage.v1.Manage/ComicList", request, response)
        logging.getLogger(__name__).info("call " + "[comic_list]" + " api success!")
        return response

    @allure.step("""编辑漫画""")
    def edit_comic(self, request: EditComicReq) -> DefaultResponse:
        """编辑漫画"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_comic]" + " api" + "=>" + """编辑漫画"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/EditComic", request, response)
        logging.getLogger(__name__).info("call " + "[edit_comic]" + " api success!")
        return response

    @allure.step("""话列表(api)""")
    def episode_list(self, request: EpisodeListReq) -> EpisodeListResp:
        """话列表(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[episode_list]" + " api" + "=>" + """话列表(api)"""
        )
        response = EpisodeListResp()
        self._do_twirp_rpc("/manage.v1.Manage/EpisodeList", request, response)
        logging.getLogger(__name__).info("call " + "[episode_list]" + " api success!")
        return response

    @allure.step("""话详情(api)""")
    def episode_detail(self, request: EpisodeDetailReq) -> EpisodeDetailResp:
        """话详情(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[episode_detail]" + " api" + "=>" + """话详情(api)"""
        )
        response = EpisodeDetailResp()
        self._do_twirp_rpc("/manage.v1.Manage/EpisodeDetail", request, response)
        logging.getLogger(__name__).info("call " + "[episode_detail]" + " api success!")
        return response

    @allure.step("""新增话(api)""")
    def add_episode(self, request: AddEpisodeReq) -> AddEpisodeResp:
        """新增话(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[add_episode]" + " api" + "=>" + """新增话(api)"""
        )
        response = AddEpisodeResp()
        self._do_twirp_rpc("/manage.v1.Manage/AddEpisode", request, response)
        logging.getLogger(__name__).info("call " + "[add_episode]" + " api success!")
        return response

    @allure.step("""编辑话""")
    def edit_episode(self, request: EditEpisodeReq) -> DefaultResponse:
        """编辑话"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_episode]" + " api" + "=>" + """编辑话"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/EditEpisode", request, response)
        logging.getLogger(__name__).info("call " + "[edit_episode]" + " api success!")
        return response

    @allure.step("""获取漫画 id 下的卷(api)""")
    def list_chapters(self, request: ListChaptersReq) -> ListChaptersResp:
        """获取漫画 id 下的卷(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[list_chapters]" + " api" + "=>" + """获取漫画 id 下的卷(api)"""
        )
        response = ListChaptersResp()
        self._do_twirp_rpc("/manage.v1.Manage/ListChapters", request, response)
        logging.getLogger(__name__).info("call " + "[list_chapters]" + " api success!")
        return response

    @allure.step("""生成INDEX(api)""")
    def index_upload(self, request: IndexUploadRequest) -> IndexUploadResp:
        """生成INDEX(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[index_upload]" + " api" + "=>" + """生成INDEX(api)"""
        )
        response = IndexUploadResp()
        self._do_twirp_rpc("/manage.v1.Manage/IndexUpload", request, response)
        logging.getLogger(__name__).info("call " + "[index_upload]" + " api success!")
        return response

    @allure.step("""BfsToken""")
    def bfs_token(self, request: BfsTokenReq) -> BfsTokenResp:
        """BfsToken"""
        logging.getLogger(__name__).info(
            "start call " + "[bfs_token]" + " api" + "=>" + """BfsToken"""
        )
        response = BfsTokenResp()
        self._do_twirp_rpc("/manage.v1.Manage/BfsToken", request, response)
        logging.getLogger(__name__).info("call " + "[bfs_token]" + " api success!")
        return response

    @allure.step("""漫画详情(api)""")
    def get_comic(self, request: GetComicRequest) -> GetComicResponse:
        """漫画详情(api)"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic]" + " api" + "=>" + """漫画详情(api)"""
        )
        response = GetComicResponse()
        self._do_twirp_rpc("/manage.v1.Manage/GetComic", request, response)
        logging.getLogger(__name__).info("call " + "[get_comic]" + " api success!")
        return response

    @allure.step("""用户信息""")
    def my_info(self, request: EmptyRequest) -> UserInfoResp:
        """用户信息"""
        logging.getLogger(__name__).info(
            "start call " + "[my_info]" + " api" + "=>" + """用户信息"""
        )
        response = UserInfoResp()
        self._do_twirp_rpc("/manage.v1.Manage/MyInfo", request, response)
        logging.getLogger(__name__).info("call " + "[my_info]" + " api success!")
        return response

    @allure.step("""单话上下线""")
    def ep_online(self, request: EpOnlineReq) -> DefaultResponse:
        """单话上下线"""
        logging.getLogger(__name__).info(
            "start call " + "[ep_online]" + " api" + "=>" + """单话上下线"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/EpOnline", request, response)
        logging.getLogger(__name__).info("call " + "[ep_online]" + " api success!")
        return response

    @allure.step("""获取推荐所有标签""")
    def get_all_tag_list(self, request: EmptyRequest) -> AllTagListResp:
        """获取推荐所有标签"""
        logging.getLogger(__name__).info(
            "start call " + "[get_all_tag_list]" + " api" + "=>" + """获取推荐所有标签"""
        )
        response = AllTagListResp()
        self._do_twirp_rpc("/manage.v1.Manage/GetAllTagList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_all_tag_list]" + " api success!"
        )
        return response

    @allure.step("""获取漫画标签列表""")
    def get_comic_tag_list(self, request: ComicTagListReq) -> ComicTagListResp:
        """获取漫画标签列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_tag_list]" + " api" + "=>" + """获取漫画标签列表"""
        )
        response = ComicTagListResp()
        self._do_twirp_rpc("/manage.v1.Manage/GetComicTagList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_tag_list]" + " api success!"
        )
        return response

    @allure.step("""编辑漫画标签""")
    def edit_comic_tags(self, request: EditComicTagsReq) -> DefaultResponse:
        """编辑漫画标签"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_comic_tags]" + " api" + "=>" + """编辑漫画标签"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/manage.v1.Manage/EditComicTags", request, response)
        logging.getLogger(__name__).info(
            "call " + "[edit_comic_tags]" + " api success!"
        )
        return response
