# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: manage/v0/risk.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class AddSkyOceanStockResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RiskEmptyData" = betterproto.message_field(3)


@dataclass
class RiskEmptyData(betterproto.Message):
    pass


@dataclass
class AddSkyOceanStockReq(betterproto.Message):
    # 1-天空 2-海洋
    type: int = betterproto.int32_field(1)
    comic_ids: List[int] = betterproto.int32_field(2)


@dataclass
class ListSkyOceanStockReq(betterproto.Message):
    # 1-天空 2-海洋
    type: int = betterproto.int32_field(1)


@dataclass
class ListSkyOceanStockResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListSkyOceanStock" = betterproto.message_field(3)


@dataclass
class ListSkyOceanStock(betterproto.Message):
    comics: List["ListSkyOcean"] = betterproto.message_field(1)


@dataclass
class ListSkyOcean(betterproto.Message):
    id: int = betterproto.int64_field(1)
    comic_id: int = betterproto.int32_field(2)
    title: str = betterproto.string_field(3)
    cuser: str = betterproto.string_field(4)
    ctime: str = betterproto.string_field(5)


@dataclass
class DelSkyOceanStockReq(betterproto.Message):
    # 库存主键 id
    id: int = betterproto.int64_field(1)
    comic_id: int = betterproto.int32_field(2)


class RiskStub(betterproto.ServiceStub):
    """Risk 后台风控配置服务"""

    @allure.step("""添加天空与海洋风险控制库存""")
    def add_sky_ocean_stock(
        self, request: AddSkyOceanStockReq
    ) -> AddSkyOceanStockResponse:
        """添加天空与海洋风险控制库存"""
        logging.getLogger(__name__).info(
            "start call "
            + "[add_sky_ocean_stock]"
            + " api"
            + "=>"
            + """添加天空与海洋风险控制库存"""
        )
        response = AddSkyOceanStockResponse()
        self._do_twirp_rpc("/manage.v0.Risk/AddSkyOceanStock", request, response)
        logging.getLogger(__name__).info(
            "call " + "[add_sky_ocean_stock]" + " api success!"
        )
        return response

    @allure.step("""查询天空与海洋风险控制库存""")
    def list_sky_ocean_stock(
        self, request: ListSkyOceanStockReq
    ) -> ListSkyOceanStockResp:
        """查询天空与海洋风险控制库存"""
        logging.getLogger(__name__).info(
            "start call "
            + "[list_sky_ocean_stock]"
            + " api"
            + "=>"
            + """查询天空与海洋风险控制库存"""
        )
        response = ListSkyOceanStockResp()
        self._do_twirp_rpc("/manage.v0.Risk/ListSkyOceanStock", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_sky_ocean_stock]" + " api success!"
        )
        return response

    @allure.step("""删除库存""")
    def del_sky_ocean_stock(
        self, request: DelSkyOceanStockReq
    ) -> AddSkyOceanStockResponse:
        """删除库存"""
        logging.getLogger(__name__).info(
            "start call " + "[del_sky_ocean_stock]" + " api" + "=>" + """删除库存"""
        )
        response = AddSkyOceanStockResponse()
        self._do_twirp_rpc("/manage.v0.Risk/DelSkyOceanStock", request, response)
        logging.getLogger(__name__).info(
            "call " + "[del_sky_ocean_stock]" + " api success!"
        )
        return response
