# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: manage/v0/activity.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyActivityRequest(betterproto.Message):
    pass


@dataclass
class DefaultActivityResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyActivityData" = betterproto.message_field(3)


@dataclass
class EmptyActivityData(betterproto.Message):
    pass


@dataclass
class ListActivitysReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 分页条目数
    page_size: int = betterproto.int32_field(2)
    # 活动名
    act_name: str = betterproto.string_field(3)
    # 活动类型
    act_type: str = betterproto.string_field(4)


@dataclass
class ListActivitysResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListActivitysData" = betterproto.message_field(3)


@dataclass
class ListActivitysData(betterproto.Message):
    # 列表
    list: List["ActivityInfo"] = betterproto.message_field(1)
    # 总数
    total: int = betterproto.int32_field(2)


@dataclass
class ActivityInfo(betterproto.Message):
    # 活动 ID
    id: int = betterproto.int32_field(1)
    # 活动名 @max_len:50
    act_name: str = betterproto.string_field(2)
    # spmid
    spmid: str = betterproto.string_field(3)
    # 活动类型
    act_type: str = betterproto.string_field(4)
    # 需求地址
    demand_url: str = betterproto.string_field(5)
    # 活动地址
    act_url: str = betterproto.string_field(6)
    # 活动开始时间
    act_start_time: str = betterproto.string_field(7)
    # 活动结束时间
    act_end_time: str = betterproto.string_field(8)
    # 额外信息
    ext: str = betterproto.string_field(9)


@dataclass
class DelActivityReq(betterproto.Message):
    # 活动 ID
    id: int = betterproto.int32_field(1)


class ActivityStub(betterproto.ServiceStub):
    """FIXME 服务必须写注释"""

    @allure.step("""获取活动列表""")
    def list_activitys(self, request: ListActivitysReq) -> ListActivitysResp:
        """获取活动列表"""
        logging.getLogger(__name__).info(
            "start call " + "[list_activitys]" + " api" + "=>" + """获取活动列表"""
        )
        response = ListActivitysResp()
        self._do_twirp_rpc("/manage.v0.Activity/ListActivitys", request, response)
        logging.getLogger(__name__).info("call " + "[list_activitys]" + " api success!")
        return response

    @allure.step("""新增/编辑 活动""")
    def edit_activity(self, request: ActivityInfo) -> DefaultActivityResponse:
        """新增/编辑 活动"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_activity]" + " api" + "=>" + """新增/编辑 活动"""
        )
        response = DefaultActivityResponse()
        self._do_twirp_rpc("/manage.v0.Activity/EditActivity", request, response)
        logging.getLogger(__name__).info("call " + "[edit_activity]" + " api success!")
        return response

    @allure.step("""删除 活动""")
    def del_activity(self, request: DelActivityReq) -> DefaultActivityResponse:
        """删除 活动"""
        logging.getLogger(__name__).info(
            "start call " + "[del_activity]" + " api" + "=>" + """删除 活动"""
        )
        response = DefaultActivityResponse()
        self._do_twirp_rpc("/manage.v0.Activity/DelActivity", request, response)
        logging.getLogger(__name__).info("call " + "[del_activity]" + " api success!")
        return response
