# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: coupon/v0/coupon.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class SendCouponReq(betterproto.Message):
    # 收券用户ID
    uid: int = betterproto.int64_field(1)
    # 发放数量
    amount: int = betterproto.int32_field(2)


@dataclass
class SendOrderCouponReq(betterproto.Message):
    # 订单号，最长 32 字节
    order_id: str = betterproto.string_field(1)
    # 收券用户ID
    uid: int = betterproto.int64_field(2)
    # 发放数量
    amount: int = betterproto.int32_field(3)
    # 区分该次发放道具类型 0: 漫读券 1: 限免卡
    biz_type: int = betterproto.int32_field(4)


@dataclass
class SendLPLCouponReq(betterproto.Message):
    # 订单号，最长 32 字节
    order_id: str = betterproto.string_field(1)
    # 收券用户ID
    uid: int = betterproto.int64_field(2)
    # 发放数量
    amount: int = betterproto.int32_field(3)
    # 发放类型：0 续费，1 首次购买
    type: int = betterproto.int32_field(4)


@dataclass
class SendUpCouponResp(betterproto.Message):
    # 调用方只需根据 http 状态码判断是否成功 成功反回 200 参数不符合要求反回 400 状态码
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class SetListRequest(betterproto.Message):
    # 单页数量
    page_size: int = betterproto.int32_field(1)
    # 分页页数
    page_num: int = betterproto.int32_field(2)
    # 1.漫读券, 2.限免卡, 3.优惠卡
    tab_type: int = betterproto.int32_field(3)
    # 按标题搜索
    title: str = betterproto.string_field(4)
    # 按关联漫画搜索
    comic_id: int = betterproto.int32_field(5)


@dataclass
class DefaultListRequest(betterproto.Message):
    # 单页数量
    page_size: int = betterproto.int32_field(1)
    # 分页页数
    page_num: int = betterproto.int32_field(2)


@dataclass
class ListCouponSetResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CouponSetData" = betterproto.message_field(3)


@dataclass
class CouponSetData(betterproto.Message):
    # 阅读券列表
    list: List["CouponSet"] = betterproto.message_field(1)
    # 阅读券页总数
    total: int = betterproto.int32_field(2)
    # 阅读券总数
    total_count: int = betterproto.int32_field(3)


@dataclass
class CouponSet(betterproto.Message):
    # 阅读券种类id
    id: int = betterproto.int32_field(1)
    # 阅读券标题
    reason_title: str = betterproto.string_field(2)
    # 阅读券类型 1.全场券 2.专属券 3.限免卡 4.打折卡 5.全场限免卡 6.全场打折卡 7.全场福利券
    type: int = betterproto.int32_field(3)
    # 时长
    expiration_day: int = betterproto.int32_field(4)
    # 创建人
    cuser: str = betterproto.string_field(5)
    # 创建时间
    ctime: str = betterproto.string_field(6)
    # 阅读券说明
    reason_description: str = betterproto.string_field(7)
    # 阅读券图标地址
    icon_url: str = betterproto.string_field(8)
    # 专属券/限定卡限定漫画内容
    limits: List["CouponLimit"] = betterproto.message_field(9)
    # 优惠卡折扣 90 九折
    discount: int = betterproto.int32_field(10)
    # 优惠卡最大折扣漫币数额
    discount_limit: int = betterproto.int32_field(11)
    # 主站临期私信推送
    need_remind_main: bool = betterproto.bool_field(12)


@dataclass
class CouponLimit(betterproto.Message):
    # 限定维度类型(暂时只有漫画维度) 1.漫画
    type: int = betterproto.int32_field(1)
    # id内容取决于type 当 type 为 1 时，id 为 comic_id
    id: int = betterproto.int32_field(2)
    # title内容取决于type 当 type 为 1 时，title 为 漫画标题
    title: str = betterproto.string_field(3)


@dataclass
class CouponAddReq(betterproto.Message):
    # 阅读券说明
    reason_description: str = betterproto.string_field(1)
    # 阅读券标题
    reason_title: str = betterproto.string_field(2)
    # 阅读券类型 1.全场券 2.专属券 3.限免卡 4.打折卡 5.全场限免卡 6.全场打折卡 7.全场福利券
    type: int = betterproto.int32_field(3)
    # 有效时长
    expiration_day: int = betterproto.int32_field(4)
    # 阅读券图标地址
    icon_url: str = betterproto.string_field(5)
    # 专属券/限定卡限定漫画 ID
    comic_id: int = betterproto.int32_field(7)
    # 打折卡折扣力度: 90 代表 9 折
    discount: int = betterproto.int32_field(8)
    # 打折卡限定漫画 IDS
    comic_ids: List[int] = betterproto.int32_field(9)
    # 打折卡最大折扣漫币数额
    discount_limit: int = betterproto.int32_field(10)
    # 主站临期私信推送
    need_remind_main: bool = betterproto.bool_field(11)


@dataclass
class UpdateIconReq(betterproto.Message):
    # 阅读券种类id
    id: int = betterproto.int32_field(1)
    # 阅读券图标地址
    icon_url: str = betterproto.string_field(2)


@dataclass
class ListCouponSendPlanResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CouponSendPlanData" = betterproto.message_field(3)


@dataclass
class CouponSendPlan(betterproto.Message):
    # 发放id
    id: int = betterproto.int32_field(1)
    # 发放说明
    reason_description: str = betterproto.string_field(2)
    # 阅读券种类id
    reason_id: int = betterproto.int32_field(3)
    # 发放状态 0: 未发放, 1: 发放中, 2: 发放成功
    status: int = betterproto.int32_field(4)
    # 创建人
    cuser: str = betterproto.string_field(5)
    # 创建时间
    ctime: str = betterproto.string_field(6)
    # 发放的用户 为""时为当时所有用户
    uids: str = betterproto.string_field(7)
    # 发放的劵种
    coupon_set: "CouponSet" = betterproto.message_field(8)
    # 人均发放数量
    amount: int = betterproto.int32_field(9)
    # 人群包ID
    user_group_ids: List[int] = betterproto.int32_field(10)


@dataclass
class CouponSendPlanData(betterproto.Message):
    # 阅读券发送计划列表
    list: List["CouponSendPlan"] = betterproto.message_field(1)
    # 阅读券发送计划页总数
    total: int = betterproto.int32_field(2)
    # 阅读券发送计划总数
    total_count: int = betterproto.int32_field(3)


@dataclass
class CouponSendPlanAddReq(betterproto.Message):
    # 阅读券种类 id
    reason_id: int = betterproto.int32_field(1)
    # 发放说明
    reason_description: str = betterproto.string_field(2)
    # 发放用户类型 1:所有漫画用户 2:指定用户 3:人群包
    type: int = betterproto.int32_field(3)
    # 发放用户组 uids
    uids: List[int] = betterproto.int64_field(4)
    # 人均发放数量
    amount: int = betterproto.int32_field(5)
    # uid 文件上传到 bfs 对应的 url
    file: str = betterproto.string_field(7)
    # 人群包ID
    user_group_ids: List[int] = betterproto.int32_field(8)


class CouponStub(betterproto.ServiceStub):
    """coupon 漫读券服务"""

    @allure.step("""新增漫读券""")
    def add_coupon(self, request: CouponAddReq) -> DefaultResponse:
        """新增漫读券"""
        logging.getLogger(__name__).info(
            "start call " + "[add_coupon]" + " api" + "=>" + """新增漫读券"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/AddCoupon", request, response)
        logging.getLogger(__name__).info("call " + "[add_coupon]" + " api success!")
        return response

    @allure.step("""修改漫读券""")
    def update_icon(self, request: UpdateIconReq) -> DefaultResponse:
        """修改漫读券"""
        logging.getLogger(__name__).info(
            "start call " + "[update_icon]" + " api" + "=>" + """修改漫读券"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/UpdateIcon", request, response)
        logging.getLogger(__name__).info("call " + "[update_icon]" + " api success!")
        return response

    @allure.step("""获取漫读券列表""")
    def get_coupon_list(self, request: SetListRequest) -> ListCouponSetResponse:
        """获取漫读券列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_coupon_list]" + " api" + "=>" + """获取漫读券列表"""
        )
        response = ListCouponSetResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/GetCouponList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_coupon_list]" + " api success!"
        )
        return response

    @allure.step("""获取漫读券发送计划列表""")
    def get_coupon_send_plan_list(
        self, request: DefaultListRequest
    ) -> ListCouponSendPlanResponse:
        """获取漫读券发送计划列表"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_coupon_send_plan_list]"
            + " api"
            + "=>"
            + """获取漫读券发送计划列表"""
        )
        response = ListCouponSendPlanResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/GetCouponSendPlanList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_coupon_send_plan_list]" + " api success!"
        )
        return response

    @allure.step("""新增漫读券发送计划""")
    def add_coupon_send_plan(self, request: CouponSendPlanAddReq) -> DefaultResponse:
        """新增漫读券发送计划"""
        logging.getLogger(__name__).info(
            "start call " + "[add_coupon_send_plan]" + " api" + "=>" + """新增漫读券发送计划"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/AddCouponSendPlan", request, response)
        logging.getLogger(__name__).info(
            "call " + "[add_coupon_send_plan]" + " api success!"
        )
        return response

    @allure.step(
        """
        发送联通免流漫读券 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
    )
    def send_uniform_coupon(self, request: SendCouponReq) -> DefaultResponse:
        """
        发送联通免流漫读券 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        logging.getLogger(__name__).info(
            "start call "
            + "[send_uniform_coupon]"
            + " api"
            + "=>"
            + """
        发送联通免流漫读券 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/SendUniformCoupon", request, response)
        logging.getLogger(__name__).info(
            "call " + "[send_uniform_coupon]" + " api success!"
        )
        return response

    @allure.step(
        """
        主站UP主兑换并给粉丝发放漫读券 有效期从发放开始算起 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
    )
    def send_up_coupon(self, request: SendOrderCouponReq) -> SendUpCouponResp:
        """
        主站UP主兑换并给粉丝发放漫读券 有效期从发放开始算起 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        logging.getLogger(__name__).info(
            "start call "
            + "[send_up_coupon]"
            + " api"
            + "=>"
            + """
        主站UP主兑换并给粉丝发放漫读券 有效期从发放开始算起 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        )
        response = SendUpCouponResp()
        self._do_twirp_rpc("/coupon.v0.Coupon/SendUpCoupon", request, response)
        logging.getLogger(__name__).info("call " + "[send_up_coupon]" + " api success!")
        return response

    @allure.step(
        """
        发放 2020 拜年祭预约礼限免卡 有效期从发放开始算起 接口有效期2020年1月17日-2月24日 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
    )
    def send_new_year_coupon(self, request: SendCouponReq) -> DefaultResponse:
        """
        发放 2020 拜年祭预约礼限免卡 有效期从发放开始算起 接口有效期2020年1月17日-2月24日 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        logging.getLogger(__name__).info(
            "start call "
            + "[send_new_year_coupon]"
            + " api"
            + "=>"
            + """
        发放 2020 拜年祭预约礼限免卡 有效期从发放开始算起 接口有效期2020年1月17日-2月24日 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/SendNewYearCoupon", request, response)
        logging.getLogger(__name__).info(
            "call " + "[send_new_year_coupon]" + " api success!"
        )
        return response

    @allure.step(
        """
        直播 LPL 会员赠券 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
    )
    def send_l_p_l_coupon(self, request: SendLPLCouponReq) -> DefaultResponse:
        """
        直播 LPL 会员赠券 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        logging.getLogger(__name__).info(
            "start call "
            + "[send_l_p_l_coupon]"
            + " api"
            + "=>"
            + """
        直播 LPL 会员赠券 需要签名，请参考
        https://info.bilibili.co/pages/viewpage.action?pageId=77684563
        """
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/coupon.v0.Coupon/SendLPLCoupon", request, response)
        logging.getLogger(__name__).info(
            "call " + "[send_l_p_l_coupon]" + " api success!"
        )
        return response
