# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: comic/v1/comic.proto
# plugin: python-betterproto
import logging
from typing import Dict, List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class DanmakuInfo(betterproto.Message):
    dmid: int = betterproto.int64_field(1)


@dataclass
class SendDanmakuResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DanmakuInfo" = betterproto.message_field(3)


@dataclass
class SendDanmakuReq(betterproto.Message):
    """
    参考主站接口 https://info.bilibili.co/pages/viewpage.action?pageId=48988377
    """

    type: int = betterproto.int32_field(1)
    oid: int = betterproto.int64_field(2)
    msg: str = betterproto.string_field(3)
    aid: int = betterproto.int32_field(4)
    progress: int = betterproto.int32_field(5)
    color: int = betterproto.int32_field(6)
    fontsize: int = betterproto.int32_field(7)
    pool: int = betterproto.int32_field(8)
    mode: int = betterproto.int32_field(9)
    rnd: str = betterproto.string_field(10)
    plat: int = betterproto.int32_field(11)
    teenagers_mode: str = betterproto.string_field(12)
    build: str = betterproto.string_field(13)


@dataclass
class GetRookieFreeComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RookieFreeComics" = betterproto.message_field(3)


@dataclass
class RookieFreeComics(betterproto.Message):
    # 今日限免
    today: List["FreeComic"] = betterproto.message_field(1)
    rookie_expire_time: str = betterproto.string_field(2)


@dataclass
class FreeComic(betterproto.Message):
    title: str = betterproto.string_field(1)
    # 排行榜
    rank: int = betterproto.int32_field(2)
    # 榜单类型  1 国漫 2 日漫 3 韩漫
    rank_type: int = betterproto.int32_field(3)
    # 风格
    style: List[str] = betterproto.string_field(4)
    # 评分
    score: float = betterproto.double_field(5)
    # 漫画 ID
    comic_id: int = betterproto.int32_field(6)
    # 封面
    cover: str = betterproto.string_field(7)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(8)
    # 算法 ext 字段
    ext: str = betterproto.string_field(9)


@dataclass
class InterestTag(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)
    # 未选中的封面
    img: str = betterproto.string_field(3)
    # 选中之后的封面
    select_img: str = betterproto.string_field(4)


@dataclass
class RankInfoData(betterproto.Message):
    list: List["FansComic"] = betterproto.message_field(1)
    # 下次更新时间(2006-01-02 15:04:05)(仅主榜单为当前周榜单时该字段为有效数据)
    next_time: str = betterproto.string_field(2)
    # 当前时间(2006-01-02 15:04:05)(仅主榜单为当前周榜单时该字段为有效数据)
    current_time: str = betterproto.string_field(3)
    # 历史数据回顾文案
    text: str = betterproto.string_field(4)
    # 历史数据
    last: List["FansComic"] = betterproto.message_field(5)
    # 截止文案
    end_text: str = betterproto.string_field(6)


@dataclass
class GetRankInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RankInfoData" = betterproto.message_field(3)


@dataclass
class GetRankInfoReq(betterproto.Message):
    # 榜单id 由ListRank接口下发
    id: int = betterproto.int32_field(1)
    # 应援榜，周偏移值, 获取前n周的数据, 例: 获取当前周的排行，该值传0，获取上周的排行，该值传1 月票榜，月偏移值，获取前n个月的数据，例:
    # 获取当前月的排行，该值传0，获取上月的排行，该值传1
    offset: int = betterproto.int32_field(2)


@dataclass
class RankDetail(betterproto.Message):
    # 榜单 id
    id: int = betterproto.int32_field(1)
    # 榜单类型 每日更新一次 type=0 实时更新    type=1
    type: int = betterproto.int32_field(2)
    # 榜单描述
    description: str = betterproto.string_field(3)
    # 榜单名
    name: str = betterproto.string_field(4)


@dataclass
class ListRankData(betterproto.Message):
    list: List["RankDetail"] = betterproto.message_field(1)


@dataclass
class ListRankResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListRankData" = betterproto.message_field(3)


@dataclass
class GetClassPageAnimeReq(betterproto.Message):
    page_num: int = betterproto.int32_field(1)
    page_size: int = betterproto.int32_field(2)


@dataclass
class GetClassPageAnimeItem(betterproto.Message):
    # 漫画 id
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 是否已追漫  0-未追漫 1-已追
    fav: int = betterproto.int32_field(3)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(6)
    # 是否完结 1:是 0:否 -1:未开刊
    is_finish: int = betterproto.int32_field(7)
    # 作者
    authors: List[str] = betterproto.string_field(8)
    # 风格
    styles: List[str] = betterproto.string_field(9)
    # 新人是否直接进入阅读器
    jump_value: str = betterproto.string_field(10)


@dataclass
class GetClassPageAnimeData(betterproto.Message):
    list: List["GetClassPageAnimeItem"] = betterproto.message_field(1)
    # 总数
    total: int = betterproto.int32_field(2)


@dataclass
class GetClassPageAnimeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetClassPageAnimeData" = betterproto.message_field(3)


@dataclass
class GetClassPageGiftItem(betterproto.Message):
    # coupon_id 券 id
    coupon_id: int = betterproto.int32_field(1)
    # 福利类型 0-新人券 1-关注官方  2-充值有礼
    type: int = betterproto.int32_field(2)
    # 状态 0-未领取 1-已领取
    status: int = betterproto.int32_field(3)


@dataclass
class GetClassPageGiftData(betterproto.Message):
    list: List["GetClassPageGiftItem"] = betterproto.message_field(1)


@dataclass
class GetClassPageGiftResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetClassPageGiftData" = betterproto.message_field(3)


@dataclass
class ABFlagInfo(betterproto.Message):
    # key: 实验名  value: 实验分组
    values: Dict[str, str] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )


@dataclass
class GetABFlagResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ABFlagInfo" = betterproto.message_field(3)


@dataclass
class GetABFlagReq(betterproto.Message):
    # 实验号(请参考 TAPD 试验号)
    names: List[str] = betterproto.string_field(1)


@dataclass
class ListCommonBannerInfo(betterproto.Message):
    list: List["CommonBannerInfo"] = betterproto.message_field(1)


@dataclass
class ListCommonBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCommonBannerInfo" = betterproto.message_field(3)


@dataclass
class ShareComicAlbumInfo(betterproto.Message):
    # 用户头像
    image_url: str = betterproto.string_field(1)
    # 用户昵称
    nick_name: str = betterproto.string_field(2)
    # 特典标题
    title: str = betterproto.string_field(3)
    # 特典封面
    cover_url: str = betterproto.string_field(4)
    # 漫画标题
    comic_title: str = betterproto.string_field(5)
    # 漫画 id
    comic_id: int = betterproto.int32_field(6)


@dataclass
class ShareComicAlbumResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ShareComicAlbumInfo" = betterproto.message_field(3)


@dataclass
class ShareComicAlbumReq(betterproto.Message):
    # uid
    uid: int = betterproto.int64_field(1)
    # 特典 id
    album_id: int = betterproto.int32_field(2)


@dataclass
class Watermark(betterproto.Message):
    # 水印
    url: str = betterproto.string_field(1)
    # 位置 0-没有指定 1-居左 2-居中 3-居右
    location: int = betterproto.int32_field(2)
    # 宽
    width: float = betterproto.double_field(3)
    # 高
    high: float = betterproto.double_field(4)
    # 字体
    font: str = betterproto.string_field(5)
    # 坐标 x
    x: float = betterproto.double_field(6)
    # 坐标 y
    y: float = betterproto.double_field(7)
    # 字体大小
    size: float = betterproto.double_field(8)
    # 水印类型 1-图片(用户头像) 2-文字(排名)
    type: int = betterproto.int32_field(9)
    # 颜色
    color: str = betterproto.string_field(10)


@dataclass
class ComicAlbumContent(betterproto.Message):
    # 特典 id
    id: int = betterproto.int32_field(1)
    # 特典标题
    title: str = betterproto.string_field(2)
    # 特典封面
    cover: str = betterproto.string_field(3)
    # 特典图片/动图链接
    pic: List[str] = betterproto.string_field(4)
    # 水印
    watermark: str = betterproto.string_field(5)
    # 排名
    rank: int = betterproto.int32_field(6)
    # 特典详情
    detail: str = betterproto.string_field(7)
    # 限量
    limits: int = betterproto.int32_field(8)
    # 图片类型 0-静态图片 1-gif
    pic_type: int = betterproto.int32_field(9)
    # 水印文字
    text: str = betterproto.string_field(10)
    # 水印宽
    width: int = betterproto.int32_field(11)
    # 水印高
    high: int = betterproto.int32_field(12)
    # 字体
    front: str = betterproto.string_field(13)
    # 图片数量
    pic_num: int = betterproto.int32_field(14)
    # 生效时间 格式 "2006-01-02 15:04:05"
    online_time: str = betterproto.string_field(15)
    # 截止时间 格式 "2006-01-02 15:04:05"
    offline_time: str = betterproto.string_field(16)
    # 金额数目
    num: int = betterproto.int32_field(17)
    # 解锁方式
    type: int = betterproto.int32_field(18)
    # 水印
    config: List["Watermark"] = betterproto.message_field(19)
    # 是否禁止下载/截屏/录屏 false - 不禁止 true - 禁止
    no_local: bool = betterproto.bool_field(20)
    video: "AlbumVideo" = betterproto.message_field(21)


@dataclass
class AccessComicAlbumResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicAlbumContent" = betterproto.message_field(3)


@dataclass
class AccessComicAlbumReq(betterproto.Message):
    # 特典 id
    id: int = betterproto.int32_field(1)


@dataclass
class UnlockComicAlbumReq(betterproto.Message):
    # 特典 id
    id: int = betterproto.int32_field(1)


@dataclass
class ComicAlbumItem(betterproto.Message):
    # 是否未解锁 true: 未解锁  false: 已解锁
    is_lock: bool = betterproto.bool_field(1)
    # 已消费的金额
    cost: int = betterproto.int32_field(2)
    # 已应援的金额
    reward: int = betterproto.int32_field(3)
    # 特典信息
    item: "ComicAlbumContent" = betterproto.message_field(4)
    # 已解锁的章节/卷数目
    item_id: List[int] = betterproto.int32_field(5)


@dataclass
class ComicAlbumInfo(betterproto.Message):
    list: List["ComicAlbumItem"] = betterproto.message_field(1)


@dataclass
class ComicAlbumPlusContent(betterproto.Message):
    # 特典 id
    id: int = betterproto.int32_field(1)
    # 特典标题
    title: str = betterproto.string_field(2)
    # 特典封面
    cover: str = betterproto.string_field(3)
    # 特典图片/动图链接
    pic: List[str] = betterproto.string_field(4)
    # 排名
    rank: int = betterproto.int32_field(5)
    # 特典详情
    detail: str = betterproto.string_field(6)
    # 限量
    limits: int = betterproto.int32_field(7)
    # 图片类型 0-静态图片 1-gif 2-单话 3-视频
    pic_type: int = betterproto.int32_field(8)
    # 图片数量
    pic_num: int = betterproto.int32_field(9)
    # 生效时间 格式 "2006-01-02 15:04:05"
    online_time: str = betterproto.string_field(10)
    # 截止时间 格式 "2006-01-02 15:04:05"
    offline_time: str = betterproto.string_field(11)
    # 金额数目
    num: int = betterproto.int32_field(12)
    # 解锁方式 0-购买 1-应援 2-混合 3-活动 4-解锁指定章节 5-解锁指定卷
    type: int = betterproto.int32_field(13)
    # 图标
    icon: str = betterproto.string_field(14)
    # 活动 url
    activity_url: str = betterproto.string_field(15)
    # 活动名称
    activity_name: str = betterproto.string_field(16)
    # 水印列表
    watermark: List["Watermark"] = betterproto.message_field(17)
    # 需要解锁的章节 ID 列表或者卷 ID 列表
    item_ids: List[int] = betterproto.int32_field(18)
    # 是否禁止下载/截屏/录屏 false - 不禁止 true - 禁止
    no_local: bool = betterproto.bool_field(19)
    # 视频特典信息
    video: "AlbumVideo" = betterproto.message_field(20)
    # 需要解锁等章节信息或者卷信息
    item_infos: List["LockItemInfo"] = betterproto.message_field(21)


@dataclass
class AlbumVideo(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 视频播放链接
    url: str = betterproto.string_field(2)
    # 视频封面
    cover: str = betterproto.string_field(3)
    # 视频时长，多少秒
    duration: int = betterproto.int64_field(4)


@dataclass
class LockItemInfo(betterproto.Message):
    id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)


@dataclass
class ComicAlbumPlusItem(betterproto.Message):
    # 是否未解锁 true: 未解锁  false: 已解锁
    is_lock: bool = betterproto.bool_field(1)
    # 已消费的金额
    cost: int = betterproto.int32_field(2)
    # 已应援的金额
    reward: int = betterproto.int32_field(3)
    # 特典信息
    item: "ComicAlbumPlusContent" = betterproto.message_field(4)
    # 已解锁的章节 ID 列表或者卷 ID 列表
    unlocked_item_ids: List[int] = betterproto.int32_field(5)


@dataclass
class ComicAlbumPlusInfo(betterproto.Message):
    list: List["ComicAlbumPlusItem"] = betterproto.message_field(1)
    # 特典入口
    icon_url: str = betterproto.string_field(2)
    comic_title: str = betterproto.string_field(3)


@dataclass
class GetComicAlbumPlusResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicAlbumPlusInfo" = betterproto.message_field(3)


@dataclass
class GetComicAlbumResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicAlbumInfo" = betterproto.message_field(3)


@dataclass
class GetComicAlbumReq(betterproto.Message):
    # 漫画 id @gt:0
    comic_id: int = betterproto.int32_field(1)


@dataclass
class SearchDisplayItem(betterproto.Message):
    # 关键字
    keywords: List[str] = betterproto.string_field(1)
    # 动画
    url: str = betterproto.string_field(2)
    # 开始时间  格式 2006-01-02 15:04:05
    online_time: str = betterproto.string_field(3)
    # 结束时间  格式 2006-01-02 15:04:05
    offline_time: str = betterproto.string_field(4)
    # md5
    md5: str = betterproto.string_field(5)


@dataclass
class SearchDisplayInfo(betterproto.Message):
    list: List["SearchDisplayItem"] = betterproto.message_field(1)


@dataclass
class SearchDisplayResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "SearchDisplayInfo" = betterproto.message_field(3)


@dataclass
class JumpCardInfo(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)
    # 一句话简介
    intro: str = betterproto.string_field(4)
    # 推荐维度
    recommendation: str = betterproto.string_field(5)
    # 是否已经追漫 0-未追漫 1-已追
    fav: bool = betterproto.bool_field(6)
    # 作者信息
    authors: List[str] = betterproto.string_field(7)
    # 风格信息
    styles: List[str] = betterproto.string_field(8)
    # 最新话ID
    last_epid: int = betterproto.int32_field(9)
    # 连载状态 1:完结 0:连载中 -1:未开刊
    is_finish: int = betterproto.int32_field(10)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(11)


@dataclass
class HomeSecondaryJumpInfo(betterproto.Message):
    # 新人欢迎卡标题
    title: str = betterproto.string_field(1)
    # 副标题
    sub_title: str = betterproto.string_field(2)
    # 新人欢迎卡
    new_card: List["JumpCardInfo"] = betterproto.message_field(3)
    # 番推漫总数
    total: int = betterproto.int32_field(4)


@dataclass
class HomeSecondaryJumpResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "HomeSecondaryJumpInfo" = betterproto.message_field(3)


@dataclass
class HomeSecondaryJumpReq(betterproto.Message):
    # 0-新人卡 5-番推漫
    type: int = betterproto.int32_field(1)
    # 卡片 ID
    id: int = betterproto.int32_field(2)
    # 每页个数
    page_size: int = betterproto.int32_field(3)
    # 页数
    page_num: int = betterproto.int32_field(4)


@dataclass
class ImageIndexErrorReq(betterproto.Message):
    # 上报的信息 客户端 ip, cdn ip, cache, req-id... "{\"client_ip\":\"\",
    # \"cdn_ip\":\"\", \"error\":\"decode index error/download image error\",
    # \"header\":\"...\"}"
    info: str = betterproto.string_field(1)


@dataclass
class ImmersiveRecommendReq(betterproto.Message):
    # 正在阅读的漫画 id
    comic_id: int = betterproto.int32_field(1)
    # 每页个数
    page_size: int = betterproto.int32_field(2)
    # 页数
    page_num: int = betterproto.int32_field(3)


@dataclass
class ImmersiveRecommendInfo(betterproto.Message):
    # 漫画 id
    comic_id: int = betterproto.int32_field(1)
    # 推荐语
    recommendation: str = betterproto.string_field(2)


@dataclass
class ImmersiveRecommendResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ImmersiveRecommendInfo"] = betterproto.message_field(3)


@dataclass
class ChannelStrategy(betterproto.Message):
    # 配置信息 json 字符串
    config: str = betterproto.string_field(1)


@dataclass
class GetChannelStrategyResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ChannelStrategy" = betterproto.message_field(3)


@dataclass
class GetChannelStrategyReq(betterproto.Message):
    # 来源
    from_: str = betterproto.string_field(1)


@dataclass
class CommonBannerInfo(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 内容
    content: str = betterproto.string_field(3)
    # 跳转 URL 1-漫画详情：bilicomic://detail/10， 2-单话：bilicomic://reader/10/11
    # 3-活动页地址：http://www.baidu.com
    jump_url: str = betterproto.string_field(4)
    # 跳转类型   0-无跳转 1-漫画详情 2-漫画单话 3-活动专题页地址
    jump_type: int = betterproto.int32_field(5)
    # 背景颜色
    background: str = betterproto.string_field(6)
    # 图片 url
    image_url: str = betterproto.string_field(7)
    # 漫画 id
    comic_id: int = betterproto.int32_field(8)
    # 自定义图标
    icon: str = betterproto.string_field(9)
    # 类型
    type: int = betterproto.int32_field(10)
    # 专栏信息
    column: "Column" = betterproto.message_field(11)
    # 0-全局 1-限定，绑定部分漫画或者单话
    limit_scope: int = betterproto.int32_field(12)
    # 按钮文字
    btn_txt: str = betterproto.string_field(13)


@dataclass
class GetCommonBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CommonBannerInfo" = betterproto.message_field(3)


@dataclass
class GetCommonBannerReq(betterproto.Message):
    # banner 类型 1-评论区 banner 2-搜索页 banner 3-充值页 banner 4-裂变 banner 5-漫画详情页
    # 6-月票榜公告 7-应援banner 8-漫读卡入口文案 9-充值页漫读卡推广 10-控制面板漫读卡推广Banner
    # 11-卡券包漫读卡推广banner 12-应援月票入口资源位,暂时是无跳转模式，所以 jump_type=0 13-单话评论区公告 14-月票投递动画
    # 15-首页顶部banner 16-畅读卡运营 banner
    type: int = betterproto.int32_field(1)
    # 漫画 id
    comic_id: int = betterproto.int32_field(2)
    # 单话 id
    episode_id: int = betterproto.int32_field(3)


@dataclass
class ImageIDData(betterproto.Message):
    # 图片 id
    oid: int = betterproto.int64_field(1)


@dataclass
class GetImageIDResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ImageIDData" = betterproto.message_field(3)


@dataclass
class GetImageIDReq(betterproto.Message):
    # 漫画 id
    comic_id: int = betterproto.int32_field(1)
    # 单话 id
    epid: int = betterproto.int32_field(2)
    # 图片 url 中的 md5
    md5: str = betterproto.string_field(3)


@dataclass
class GetChannelRecommendsReq(betterproto.Message):
    # 渠道包名
    package: str = betterproto.string_field(1)


@dataclass
class GetChannelRecommendsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ChannelRecommends" = betterproto.message_field(3)


@dataclass
class ChannelRecommends(betterproto.Message):
    # 直接返回 7 个漫画，第一个为推荐漫画 数组为空，不展示推荐页
    comics: List["Recommends"] = betterproto.message_field(1)
    # 2.11 后用的新推荐漫画, 若是没有配置则返回null
    comic: "ChannelRecommend" = betterproto.message_field(2)


@dataclass
class ChannelRecommend(betterproto.Message):
    # 封面
    cover: str = betterproto.string_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 标签
    styles: List["StyleInfo"] = betterproto.message_field(3)
    # 推荐语
    intro: str = betterproto.string_field(4)
    # 漫画ID
    comic_id: int = betterproto.int32_field(5)


@dataclass
class Recommends(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)
    # 简介
    introduction: str = betterproto.string_field(3)
    # 风格
    style: List[str] = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 横版封面
    horizon_cover: str = betterproto.string_field(6)
    # 追漫状态
    has_favorited: bool = betterproto.bool_field(7)


@dataclass
class GetClassPageAllTabsReq(betterproto.Message):
    # 从哪个平台导流来的用户 0-兼容老版本 1-网易
    type: int = betterproto.int32_field(1)
    # 判断新人 tab 实验 0-不是 1-是
    new_fall_into_trap: int = betterproto.int32_field(2)


@dataclass
class HomeFansReq(betterproto.Message):
    # 应援榜，周偏移值, 获取前n周的数据, 例: 获取当前周的排行，该值传0，获取上周的排行，该值传1
    last_week_offset: int = betterproto.int32_field(1)
    # 0-应援榜 1-月票月榜
    type: int = betterproto.int32_field(2)
    # 月票榜，月偏移值，获取前n个月的数据，例: 获取当前月的排行，该值传0，获取上月的排行，该值传1
    last_month_offset: int = betterproto.int32_field(3)


@dataclass
class OperateBannerInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    img: str = betterproto.string_field(3)
    # 跳转内容
    jump_url: str = betterproto.string_field(4)
    # 礼包领取方式 1 仅领取, 2 领取+追漫, 3 领取+追漫+跳转
    gift_type: int = betterproto.int32_field(5)
    # 礼包相关漫画ID
    gift_comic_id: int = betterproto.int32_field(6)
    # 礼包跳转url
    gift_url: str = betterproto.string_field(7)
    # 已经获取礼包
    has_taken_gift: bool = betterproto.bool_field(8)
    # 跳转类型 0 直接跳转 1 领取礼包
    jump_type: int = betterproto.int32_field(9)
    # img 类型 0: 静态 1: 动态 svga
    img_type: int = betterproto.int32_field(10)
    # 动态图片的 md5 值
    md5: str = betterproto.string_field(11)
    # 动态图播放模式 0 播放一次 1 循环播放
    play_mode: int = betterproto.int32_field(12)


@dataclass
class DpHistoryResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DailyPushHistory" = betterproto.message_field(3)


@dataclass
class DailyPushHistory(betterproto.Message):
    # 最近观看EPID 服务端存储
    read_epid: int = betterproto.int32_field(1)
    # 如果服务端没有数据使用
    epid: int = betterproto.int32_field(2)


@dataclass
class DpHistoryReq(betterproto.Message):
    # 漫画id
    comic_id: int = betterproto.int32_field(1)


@dataclass
class GetDailyPushReq(betterproto.Message):
    # 查询日期, 格式：2006-01-02
    date: str = betterproto.string_field(1)
    page_num: int = betterproto.int32_field(2)
    page_size: int = betterproto.int32_field(3)


@dataclass
class GetDailyPushResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DailyPushRecommend" = betterproto.message_field(3)


@dataclass
class DailyPushRecommend(betterproto.Message):
    # 总数
    total: int = betterproto.int32_field(1)
    list: List["DPRecommendDetail"] = betterproto.message_field(2)


@dataclass
class DPRecommendDetail(betterproto.Message):
    # 漫画 id,可以用来拼接跳转至漫画详情页的 URL
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 单话 id
    ep_id: int = betterproto.int32_field(3)
    # 单话标题
    ep_title: str = betterproto.string_field(4)
    # 最新话短标题 如果是字符串类型的数字，对应更新至xx话 如果是字符串，如 "预告"，则对应更新至预告
    short_title: str = betterproto.string_field(5)
    # 单话章节
    chapter: str = betterproto.string_field(6)
    # 漫画封面 URL
    url: str = betterproto.string_field(7)
    # 风格标签，长度可能不足 2，根据需要自行判断
    styles: List["StyleInfo"] = betterproto.message_field(8)
    # 评论总数
    comment_total: int = betterproto.int32_field(9)
    # 漫画竖版封面
    vertical_cover: str = betterproto.string_field(10)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(11)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(12)


@dataclass
class GetComicRelationsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetComicRelations" = betterproto.message_field(3)


@dataclass
class GetComicRelations(betterproto.Message):
    relations: List["ComicRelations"] = betterproto.message_field(1)


@dataclass
class ComicRelations(betterproto.Message):
    # 强相关漫画id
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 漫画作者
    author: List[str] = betterproto.string_field(3)
    # 漫画是否完结 0 连载中 1 完结 -1 未开刊
    is_finished: int = betterproto.int32_field(4)
    # 漫画横版封面
    horizontal_cover: str = betterproto.string_field(5)
    # 上线状态, -1:下线 0:正常
    status: int = betterproto.int32_field(6)
    # 最新话序号（更新至x话）
    last_ord: float = betterproto.float_field(7)
    # 总话数（全x话）
    total: int = betterproto.int32_field(8)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(9)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(10)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(11)


@dataclass
class GetRewardInfoReq(betterproto.Message):
    # 打赏的漫画 ID
    comic_id: int = betterproto.int32_field(1)
    # 0-获取打赏的漫画详情 1-获取月票投喂的漫画详情
    type: int = betterproto.int32_field(2)


@dataclass
class GetRewardInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RewardInfo" = betterproto.message_field(3)


@dataclass
class RewardInfo(betterproto.Message):
    # 应援榜总粉丝值 月票榜总月票数
    fans: int = betterproto.int64_field(1)
    # 应援榜打赏的用户总数量 月票榜投月票的用户总数量
    fans_cnt: int = betterproto.int32_field(2)
    # 应援周榜当前排名, 0 表示名次不够 或者 该漫画被加入黑名单 月票月榜当前排名，0 表示名次不够 或者 该漫画被加入黑名单
    rank: int = betterproto.int32_field(3)
    # 应援周粉丝值 月票榜当月总月票数
    week_fans: int = betterproto.int64_field(4)
    # 打赏的用户周总数量 月票榜当月投喂总用户数
    week_fans_cnt: int = betterproto.int32_field(6)
    # 应援榜距离上榜还有多少粉丝值, 当该值为0时, 表示已上榜 或 该漫画在黑名单 月票榜距离上榜还有多少月票数, 当该值为0时, 表示已上榜 或
    # 该漫画在黑名单
    on_rank_fans: int = betterproto.int64_field(7)
    # 应援榜距离榜上排名上升还有多少粉丝值, 当该值为0时, 表示未上榜 或 该漫画在黑名单 月票榜距离榜上排名上升还有多少月票数, 当该值为0时,
    # 表示未上榜 或 该漫画在黑名单
    rank_rise_fans: int = betterproto.int64_field(8)


@dataclass
class GetEntranceForRankReq(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 0-应援榜入口数据 1-月票榜入口数据 2-应援和月票都取
    type: int = betterproto.int32_field(2)


@dataclass
class GetEntranceForRankResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetEntranceForRank" = betterproto.message_field(3)


@dataclass
class GetEntranceForRank(betterproto.Message):
    entrance: "EntranceInfo" = betterproto.message_field(1)


@dataclass
class EntranceInfo(betterproto.Message):
    # 漫画粉丝值
    fans: int = betterproto.int64_field(1)
    # 漫画月票数
    month_tickets: int = betterproto.int64_field(2)
    # 落地页对应的前三名用户
    users: List["RewardUser"] = betterproto.message_field(3)
    # 活动标签
    activity_content: str = betterproto.string_field(4)
    # 用户剩余月票数
    remain_month_tickets: int = betterproto.int64_field(5)
    banner: "Banner" = betterproto.message_field(6)
    # 当月票和应援都展示的时候，月票对应的前三名用户
    ticket_users: List["RewardUser"] = betterproto.message_field(7)
    # 月票或者应援总人数
    fans_cnt: int = betterproto.int32_field(8)


@dataclass
class Banner(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 勋章内容
    content: str = betterproto.string_field(2)
    # 勋章文字背景颜色
    background: str = betterproto.string_field(3)
    # 勋章图片
    icon: str = betterproto.string_field(4)
    # 勋章背景图片
    image_url: str = betterproto.string_field(5)
    # 勋章背景颜色
    image_background: str = betterproto.string_field(6)


@dataclass
class GetRewardRankReq(betterproto.Message):
    # 打赏的漫画ID
    comic_id: int = betterproto.int32_field(1)
    # rank 排行榜类型 1.月榜，2.周榜，3.总榜
    rank_type: int = betterproto.int32_field(2)
    # 0-应援榜 1-月票榜,月票榜只有月榜和总榜
    type: int = betterproto.int32_field(3)


@dataclass
class GetRewardRankResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RankInfo" = betterproto.message_field(3)


@dataclass
class RankInfo(betterproto.Message):
    # 下次更新时间(2006-01-02 15:04:05), 当排行榜类型为总榜时无效
    next_time: str = betterproto.string_field(1)
    # 当前时间(2006-01-02 15:04:05), 当排行榜类型为总榜时无效
    current_time: str = betterproto.string_field(2)
    # 粉丝值(当应援排行榜类型是周时，该字段生效) 月票数(当月票排行榜类型是月时，该字段生效)
    fans: int = betterproto.int64_field(3)
    # 应援榜用户总数量(当排行榜类型是周时，该字段生效) 月票榜用户总数量(当排行榜类型是月时，该字段生效)
    fans_cnt: int = betterproto.int32_field(4)
    users: List["RewardUser"] = betterproto.message_field(5)
    # 应援榜我的粉丝值 月票榜我投的月票数
    my_fans: int = betterproto.int64_field(6)
    # 剩余余票
    remain_tickets: int = betterproto.int32_field(9)


@dataclass
class RewardComicData(betterproto.Message):
    text: str = betterproto.string_field(1)


@dataclass
class RewardComicResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RewardComicData" = betterproto.message_field(3)


@dataclass
class RewardComicReq(betterproto.Message):
    # 打赏的漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 打赏的漫币金额 打赏的月票数
    gold: int = betterproto.int32_field(2)
    # 0-漫画打赏 1-漫画月票
    type: int = betterproto.int32_field(3)


@dataclass
class GetEpisodeReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class GetRewardItemsReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)


@dataclass
class RewardItemsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RewardItemsInfo" = betterproto.message_field(3)


@dataclass
class RewardItemsInfo(betterproto.Message):
    # 剩余漫币
    remain_gold: int = betterproto.int32_field(1)
    # 打赏的项目
    items: List["RewardItem"] = betterproto.message_field(2)
    # 漫画标题
    comic_title: str = betterproto.string_field(3)


@dataclass
class RewardItem(betterproto.Message):
    # 打赏的漫币
    gold: int = betterproto.int32_field(1)
    # 打赏项目名称
    name: str = betterproto.string_field(2)
    # 打赏项目图标
    url: str = betterproto.string_field(3)


@dataclass
class GetEpisodeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Episode" = betterproto.message_field(3)


@dataclass
class Episode(betterproto.Message):
    # 单话标题
    title: str = betterproto.string_field(1)
    # 漫画 id
    comic_id: int = betterproto.int32_field(2)
    # 短标题（序号)
    short_title: str = betterproto.string_field(3)
    # 漫画标题
    comic_title: str = betterproto.string_field(4)


@dataclass
class RentEpReq(betterproto.Message):
    # 租借的单话ID
    ep_id: int = betterproto.int32_field(1)
    # 需要消耗的道具id
    item_id: int = betterproto.int32_field(2)


@dataclass
class RentEpResp(betterproto.Message):
    # 租借ep的结果: 0.成功(原则上客户端在调用接口前校验参数, 则不会出现租借失败的情况)
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class BuyEpReq(betterproto.Message):
    # 单话自动购买所需参数 - ep_id(单话ID), buy_method(传1) 单话漫读券购买所需参数 - ep_id(单话ID),
    # buy_method(传2), coupon_id(本次交易欲使用的漫读券ID, 可从GetEpisodeBuyInfo获取),
    # auto_pay_gold_status(自动购买开关) 单话漫币购买所需参数 - ep_id(单话ID), buy_method(传3),
    # pay_amount(本次交易应付金额, 可从GetEpisodeBuyInfo获取), auto_pay_gold_status(自动购买开关),
    # coupon_id(该参数可选, 使用打折卡时传递此参数，可从GetEpisodeBuyInfo获取) - ep_id(单话ID),
    # buy_method(传5), pay_amount(本次交易应付金额, 可从GetEpisodeBuyInfo获取),
    # auto_pay_gold_status(自动购买开关)) 漫币整本购买参数 - comic_id(该本漫画ID), buy_method(传3),
    # pay_amount(本次交易应付金额, 可从GetEpisodeBuyInfo获取), coupon_id(该参数可选,
    # 使用打折卡时传递此参数，可从GetEpisodeBuyInfo获取) 漫币批量购买参数 - comic_id(该本漫画ID),
    # buy_method(传3), pay_amount(本次交易应付金额, 可从GetEpisodeBuyInfo获取),
    # coupon_id(该参数可选, 使用打折卡时传递此参数，可从GetEpisodeBuyInfo获取), with_ord_scope(true),
    # start_ord(大于等于某一话之后的章节ord, 默认值0),limit(批量购买的档位，默认值为0, 即购买某章节后所有的漫画,
    # 档位可从GetEpisodeBuyInfo获取) 漫币指定章节购买参数 - comic_id(该本漫画ID), buy_method(传3),
    # pay_amount(本次交易应付金额, 客户端自行累加), ep_ids(指定章节ID数组字符串) 购买的ep (二选一参数，购买单话时传)
    ep_id: int = betterproto.int32_field(1)
    # 购买包括该id漫画的剩余ep(二选一参数，购买多话时传) 等免解锁需要传此参数
    comic_id: int = betterproto.int32_field(2)
    # 购买的方式: 1 自动购买，2 用券购买 3 用漫币购买 4 等免解锁 5 畅读券
    buy_method: int = betterproto.int32_field(3)
    # 需指定coupon_id(用漫读购买时必传该参数, 用漫币购买使用打折卡打折时就传，不打折就不传<PS：是打折卡的ID, 不是漫读券的ID>)
    coupon_id: int = betterproto.int32_field(4)
    # 自动购买状态 1、开；2、关
    auto_pay_gold_status: int = betterproto.int32_field(5)
    # 兑换券自动购买状态(用劵购买时传该参数), 1、开；2、关 此字段2.0版本后无效
    auto_pay_coupons_status: int = betterproto.int32_field(6)
    # 预期要花的漫币数量(用漫币购买时传)
    pay_amount: int = betterproto.int32_field(7)
    # 批量购买可选参数: 当with_ord_scope为true时, start_ord等参数有效
    with_ord_scope: bool = betterproto.bool_field(8)
    # 批量购买可选参数: 购买此话(ord)(包括此话)以后的所有话
    start_ord: float = betterproto.float_field(9)
    # ep_ids 为int32的数组转化的字符串;例: [1,2,3,4]
    ep_ids: str = betterproto.string_field(10)
    # 批量购买可选参数: 购买此话(ord)(包括此话)以后的 limit 话, 即限定数量购买, limit 参数仅限服务端指定的数值
    limit: int = betterproto.int32_field(11)


@dataclass
class BuyEpResp(betterproto.Message):
    # 购买ep的结果: 0.成功 1.券使用次数不够 2.漫币不够 3.未设定自动购买 4.预期支付金额与实际支付金额不符 5.不允许使用漫读券购买
    # 6.该话不属于限定券的范围 7.未绑定手机的账号 8.点击太快,请稍后重试
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BuyResult" = betterproto.message_field(3)


@dataclass
class BuyResult(betterproto.Message):
    # 自动使用的漫币/漫券
    auto_use_item: str = betterproto.string_field(1)


@dataclass
class BuyChapterReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    chapter_id: int = betterproto.int32_field(2)
    # 此次预计消耗漫币
    real_gold: int = betterproto.int32_field(3)
    # 打折卡 id 没有或者不使用传 0
    discount_id: int = betterproto.int32_field(4)
    # 批量购买卷信息,缓存购买用此字段 如: "1,2,3,4"
    chapter_ids: List[int] = betterproto.int32_field(5)
    # 单话 id > 0 代表选择单话购买场景
    ep_id: int = betterproto.int32_field(6)
    # 0-漫币购买 1-通用(畅读)券购买(劵购买不支持批量购买)
    buy_method: int = betterproto.int32_field(7)
    # 当buy_method为1时: 必传，要花费的通用劵定价
    pay_amount: int = betterproto.int32_field(8)


@dataclass
class BuyChapterResp(betterproto.Message):
    # 购买结果: 0.成功 2.漫币不够 4.预期支付金额与实际支付金额不符 5.不允许使用漫读券购买
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BuyResult" = betterproto.message_field(3)


@dataclass
class EpBuyInfoReq(betterproto.Message):
    # 该购买信息的ep, 与comic_id二选一, 一起传的话以ep_id为优先
    ep_id: int = betterproto.int32_field(1)
    # 该购买信息的comic, 与ep_id二选一, 一起传的话以ep_id为优先
    comic_id: int = betterproto.int32_field(2)


@dataclass
class EpBuyInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EpBuyInfo" = betterproto.message_field(3)


@dataclass
class EpBuyInfo(betterproto.Message):
    # 剩余兑换券数
    remain_coupon: int = betterproto.int32_field(1)
    # 剩余漫币
    remain_gold: int = betterproto.int32_field(2)
    # 单ep 实付漫币
    pay_gold: int = betterproto.int32_field(4)
    # 推荐使用的过期券Id: 目前推荐的是最近过期的
    recommend_coupon_id: int = betterproto.int32_field(5)
    # 剩余购买的话数
    remain_lock_ep_num: int = betterproto.int32_field(6)
    # 自动购买状态, 1、开；2、关
    auto_pay_gold_status: int = betterproto.int32_field(8)
    # 兑换券自动购买状态, 1、开；2、关 此字段2.0版本无效
    auto_pay_coupons_status: int = betterproto.int32_field(9)
    # 剩余购买的话数总价
    remain_lock_ep_gold: int = betterproto.int32_field(10)
    # 漫画 id
    comic_id: int = betterproto.int32_field(11)
    # 用户是可以阅读本话。付费但未购买返回 true，否则返回 false
    is_locked: bool = betterproto.bool_field(12)
    # 是否允许使用阅读券购买
    allow_coupon: bool = betterproto.bool_field(13)
    # TODO 删除这两个字段 剩余(此话以后,包括此话)购买的话数总价(v1.10后字段开始不作额外维护, 参考 batch_buy)
    after_lock_ep_gold: int = betterproto.int32_field(14)
    # 剩余(此话以后,包括此话)购买的话数数量(v1.10后字段开始不作额外维护, 参考 batch_buy)
    after_lock_ep_num: int = betterproto.int32_field(15)
    # 预览相关信息 预览当前话第一张图片的路径
    first_image_path: str = betterproto.string_field(16)
    # 预览当前话第一张图片的链接
    first_image_url: str = betterproto.string_field(17)
    # 预览当前话第一张图片的token
    first_image_token: str = betterproto.string_field(18)
    # 预览当前话最后一张图片的路径
    last_image_path: str = betterproto.string_field(19)
    # 预览当前话最后一张图片的链接
    last_image_url: str = betterproto.string_field(20)
    # 预览当前话最后一张图片的token
    last_image_token: str = betterproto.string_field(21)
    # 整本漫画折扣类型: 0.没折扣 1.限时优惠 2.限时免费
    discount_type: int = betterproto.int32_field(22)
    # 整本漫画折扣, 大于0, 小于100，95代表9.5折
    discount: int = betterproto.int32_field(23)
    # 整本漫画原价
    original_gold: int = betterproto.int32_field(24)
    # 首充赠送比例 50 表示 50%
    first_bonus_percent: int = betterproto.int32_field(25)
    # 是否有首充奖励
    has_first_bonus: bool = betterproto.bool_field(26)
    # 单话漫画折扣类型: 0.没折扣 1.限时优惠
    ep_discount_type: int = betterproto.int32_field(27)
    # 单话漫画折扣, 大于0, 小于100，95代表9.5折
    ep_discount: int = betterproto.int32_field(28)
    # 单话漫画原价
    ep_original_gold: int = betterproto.int32_field(29)
    batch_buy: List["BatchBuyInfo"] = betterproto.message_field(30)
    # 推荐使用的道具ID
    recommend_item_id: int = betterproto.int32_field(31)
    # 是否允许使用道具
    allow_item: bool = betterproto.bool_field(32)
    # 当前可用的道具数量(若单话不允许使用道具, 则数量为0)
    remain_item: int = betterproto.int32_field(33)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(34)
    # 下次等免可用时间 "2006-01-02 15:04:05"
    wait_free_at: str = betterproto.string_field(36)
    # 新人下载礼包是否有效
    has_newbie_gift: bool = betterproto.bool_field(37)
    # 推荐使用的打折卡ID
    recommend_discount_id: int = betterproto.int32_field(38)
    # 推荐使用的打折卡力度, 大于0, 小于100，95代表9.5折
    recommend_discount: int = betterproto.int32_field(39)
    # 当前可用的打折卡数量
    remain_discount_card: int = betterproto.int32_field(40)
    # 单话打折卡打折后价格
    discount_ep_gold: int = betterproto.int32_field(41)
    # 整本剩余打折卡打折后价格
    discount_remain_gold: int = betterproto.int32_field(42)
    # 剩余畅读卡
    remain_silver: int = betterproto.int32_field(44)
    # 单话畅读卡原价
    ep_silver: int = betterproto.int32_field(45)
    # 充值入口文案
    pay_entry_txt: str = betterproto.string_field(46)
    # 畅读卡开通状态 0 从未开通 1 已开通 2 已过期
    user_card_state: int = betterproto.int32_field(47)


@dataclass
class BatchBuyInfo(betterproto.Message):
    # 该档位批次购买数量, 当 batch_limit 等于0时, 表示没有限制即(此后所有),
    # 购买该档位时在"此后所有"的参数基础上额外传递该limit字段
    batch_limit: int = betterproto.int32_field(1)
    # 该档位可购买数量, 通常会等于 batch_limit, 若小于 batch_limit 的话，表示剩余可购买数量不足该档位，无法购买
    amount: int = betterproto.int32_field(2)
    # 原价格
    original_gold: int = betterproto.int32_field(3)
    # 需支付价格
    pay_gold: int = betterproto.int32_field(4)
    # 漫画折扣类型: 0.没折扣 1.限时优惠
    discount_type: int = betterproto.int32_field(5)
    # 该档位折扣, 大于0, 小于100，95代表9.5折
    discount: int = betterproto.int32_field(6)
    # 该档位打折卡打折后需支付价格
    discount_batch_gold: int = betterproto.int32_field(7)
    # 当前档位是否可用 如果待购买话数少于该档位数量，则不能使用该档位 最早是在客户端做判断，跳过无法使用的档位 现在服务端也冗余一下此逻辑，方便调用方使用
    usable: bool = betterproto.bool_field(8)


@dataclass
class GetChapterBuyInfoReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    chapter_id: int = betterproto.int32_field(2)
    ep_id: int = betterproto.int32_field(3)


@dataclass
class GetChapterBuyInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ChapterBuyInfoResp" = betterproto.message_field(3)


@dataclass
class ChapterBuyInfoResp(betterproto.Message):
    # 该卷是否被锁定 true 被锁定
    is_locked: bool = betterproto.bool_field(1)
    # 卷原价格
    gold: int = betterproto.int32_field(2)
    # 卷优惠价格或者补差价价格
    real_gold: int = betterproto.int32_field(3)
    # 用户剩余漫币
    remain_gold: int = betterproto.int32_field(4)
    chapter: "ChapterInfo" = betterproto.message_field(5)
    # 推荐使用的打折卡 ID
    recommend_discount_id: int = betterproto.int32_field(6)
    # 推荐使用的打折卡力度, 大于0, 小于100，95代表9.5折
    recommend_discount: int = betterproto.int32_field(7)
    # 当前可用的打折卡数量
    remain_discount_card: int = betterproto.int32_field(8)
    # 是否有首充奖励
    has_first_bonus: bool = betterproto.bool_field(9)
    image_info: "PreRead" = betterproto.message_field(10)
    # 该漫画是否支持单话购买 true 支持
    support_episode: bool = betterproto.bool_field(11)
    # 如果用户选择单话购买,是否强制切换为购买整卷 true 强制切换
    to_chapter: bool = betterproto.bool_field(12)
    # 按卷付费场景单话购买的信息
    episode: "EpisodeBuyInfo" = betterproto.message_field(13)
    # 当前支持打折卡的状态 0. 可使用打折卡 1. 跟活动互斥 2. 漫画本身禁止使用打折卡
    discount_status: int = betterproto.int32_field(14)
    # 是否补差价 true 补差价
    make_up_the_difference: bool = betterproto.bool_field(15)
    # 卷通用卷总定价
    ch_silver: int = betterproto.int32_field(16)
    # 购买此卷需要的通用劵数量(卷总价或差价), 该字段为0时代表不支持该卷漫画不支持通用劵支付(整卷，补差价，单话都不支持)
    silver: int = betterproto.int32_field(17)
    # 用户剩余畅读券
    remain_silver: int = betterproto.int32_field(18)
    # 充值入口文案
    pay_entry_txt: str = betterproto.string_field(19)
    # 畅读卡开通状态 0 从未开通 1 已开通 2 已过期
    user_card_state: int = betterproto.int32_field(20)


@dataclass
class EpisodeBuyInfo(betterproto.Message):
    # 该单话是否被锁定 true 被锁定
    is_locked: bool = betterproto.bool_field(1)
    # 单话价格
    gold: int = betterproto.int32_field(2)
    # 单话标题
    title: str = betterproto.string_field(3)
    # 单话短标题
    short_title: str = betterproto.string_field(4)
    # 购买此卷剩余所需的价格 (卷价格-已买单话价格)
    total_gold: int = betterproto.int32_field(5)
    # 单话通用劵数量
    silver: int = betterproto.int32_field(6)


@dataclass
class PreRead(betterproto.Message):
    # 预览相关信息 预览当前话第一张图片的路径
    first_image_path: str = betterproto.string_field(1)
    # 预览当前话第一张图片的链接
    first_image_url: str = betterproto.string_field(2)
    # 预览当前话第一张图片的token
    first_image_token: str = betterproto.string_field(3)
    # 预览当前话最后一张图片的路径
    last_image_path: str = betterproto.string_field(4)
    # 预览当前话最后一张图片的链接
    last_image_url: str = betterproto.string_field(5)
    # 预览当前话最后一张图片的token
    last_image_token: str = betterproto.string_field(6)


@dataclass
class ImageTokenReq(betterproto.Message):
    # ["http://1.jpg", "http://2.jpg"]
    urls: str = betterproto.string_field(1)
    # method
    method: str = betterproto.string_field(2)


@dataclass
class ImageTokenResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["Token"] = betterproto.message_field(3)


@dataclass
class Token(betterproto.Message):
    url: str = betterproto.string_field(1)
    token: str = betterproto.string_field(2)


@dataclass
class AllLabelResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "LabelGrid" = betterproto.message_field(3)


@dataclass
class LabelGrid(betterproto.Message):
    # 风格
    styles: List["Label"] = betterproto.message_field(1)
    # 地区
    areas: List["Label"] = betterproto.message_field(2)
    # 连载
    status: List["Label"] = betterproto.message_field(3)
    # 排序
    orders: List["Label"] = betterproto.message_field(4)
    # 价格
    prices: List["Label"] = betterproto.message_field(5)


@dataclass
class Label(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)


@dataclass
class TabLabel(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)
    # tab 类型 0-首页发现页 1-热门页 2-专题页 3-分类页发现页 4-首页新人 tab 6-首页推荐 7-首页排行
    tab_type: int = betterproto.int32_field(3)
    # 专题页链接
    url: str = betterproto.string_field(4)
    # 专题页背景颜色 #00ff00
    background: str = betterproto.string_field(5)
    # tab 小红点
    show_notice: bool = betterproto.bool_field(6)


@dataclass
class GetTabsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Tabs" = betterproto.message_field(3)


@dataclass
class Tabs(betterproto.Message):
    # 类型
    type: List["TabLabel"] = betterproto.message_field(1)
    # 数组 index, tabs 中落地 tab 的位置
    specify_tab: int = betterproto.int32_field(2)
    # 首页改版
    home_type: List["TabLabel"] = betterproto.message_field(3)
    # 新人tab abTest 结果
    tab_ab_test: bool = betterproto.bool_field(4)


@dataclass
class ComicDetailReq(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)


@dataclass
class ComicDetailResp(betterproto.Message):
    # 404 表示漫画不存在，前端同学需要跳转回主页
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicDetail" = betterproto.message_field(3)


@dataclass
class ComicDetail(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画名
    title: str = betterproto.string_field(2)
    # 漫画类型 0:条漫 1:页漫
    comic_type: int = betterproto.int32_field(3)
    # 默认翻页方式, 1:竖屏滚动 2:竖屏翻页 4:日漫 8:横屏
    page_default: int = betterproto.int32_field(4)
    # 允许翻页方式,位运算 1:竖屏滚动 2:竖屏翻页 4:日漫，8:横屏
    page_allow: int = betterproto.int32_field(5)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(6)
    # 方版封面
    square_cover: str = betterproto.string_field(7)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(8)
    # 作者名
    author_name: List[str] = betterproto.string_field(9)
    # 风格标签
    styles: List[str] = betterproto.string_field(10)
    # 最新话序号（更新至x话）
    last_ord: float = betterproto.float_field(11)
    # 是否完结 1:是 0:否 -1:未开刊
    is_finish: int = betterproto.int32_field(12)
    # 上线状态, -1:下线 0:正常
    status: int = betterproto.int32_field(13)
    # 追番标记 1:已追 0:未追番
    fav: int = betterproto.int32_field(14)
    # 最近观看序号 （看到第x话）
    read_order: float = betterproto.float_field(15)
    # 简介
    evaluate: str = betterproto.string_field(16)
    # 总话数（全x话）
    total: int = betterproto.int32_field(17)
    # 话列表
    ep_list: List["EpInfo"] = betterproto.message_field(18)
    # 预计开刊时间，只有在漫画连载状态是未开刊时使用
    release_time: str = betterproto.string_field(19)
    # 区域受限返回 1，否则返回 0
    is_limit: int = betterproto.int32_field(20)
    # 最近观看EPID
    read_epid: int = betterproto.int32_field(21)
    # 最近观看时间, 没有返回空字符串
    last_read_time: str = betterproto.string_field(22)
    # 是否允许下载 1:允许 0:禁止
    is_download: int = betterproto.int32_field(23)
    # 最近观看短标题
    read_short_title: str = betterproto.string_field(24)
    # 风格标签
    styles2: List["StyleInfo"] = betterproto.message_field(25)
    # 更新频率
    renewal_time: str = betterproto.string_field(26)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(27)
    # 整本漫画折扣类型： 0、无折扣 1、折扣 2、限免 3、指定章节限免 4、畅读卡整本限免 5、畅读卡指定章节限免 6、卷限免 7、畅读卡卷限免
    discount_type: int = betterproto.int32_field(28)
    # 具体折扣 discount = 95 表示 9.5 折
    discount: int = betterproto.int32_field(29)
    # 折扣结束时间 2006-01-02 15:04:05
    discount_end: str = betterproto.string_field(30)
    # 是否禁止打赏(为true时则禁止打赏)
    no_reward: bool = betterproto.bool_field(31)
    # 批量漫画折扣类型： 0、无折扣 1、折扣
    batch_discount_type: int = betterproto.int32_field(32)
    # 单话折扣类型： 0、无折扣 1、折扣
    ep_discount_type: int = betterproto.int32_field(33)
    # 该漫画是否有追漫送券活动 v2.13 后客户端不要用该字段 见 fav_comic_info
    has_fav_activity: bool = betterproto.bool_field(34)
    # 追漫送券数量 v2.13 后客户端不要用该字段 见 fav_comic_info
    fav_free_amount: int = betterproto.int32_field(35)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(36)
    # 等免解锁等待时间
    wait_hour: int = betterproto.int32_field(37)
    # 下次等免可用时间 "2006-01-02 15:04:05"
    wait_free_at: str = betterproto.string_field(38)
    # 是否允许发弹幕 0-允许 1-不允许
    no_danmaku: int = betterproto.int32_field(39)
    # 自动购买状态 0-未开启，1-开启
    auto_pay_status: int = betterproto.int32_field(40)
    # 禁止月票
    no_month_ticket: bool = betterproto.bool_field(41)
    # 是否启用沉浸式阅读接口
    immersive: bool = betterproto.bool_field(42)
    # 是否禁止优惠卡  0-允许使用 1-禁止使用
    no_discount: bool = betterproto.bool_field(43)
    # 目前管理后台单话展示一定单话付费 0-单话展示 1-按卷展示
    show_type: int = betterproto.int32_field(44)
    # 0-免费 1-单话付费 2-按卷付费
    pay_mode: int = betterproto.int32_field(45)
    # 漫画下所有的卷信息
    chapters: List["ChapterInfo"] = betterproto.message_field(46)
    # 经典台词
    classic_lines: str = betterproto.string_field(47)
    # 付费抢先看的数量，0 表示 不是付费抢先看
    pay_for_new: int = betterproto.int32_field(48)
    # 追漫活动信息
    fav_comic_info: "FavComicInfo" = betterproto.message_field(49)
    # 连载状态 0-正常 1-休刊
    serial_status: int = betterproto.int32_field(50)
    # 系列信息
    series_info: "SeriesInfo" = betterproto.message_field(51)
    # 特典总数量
    album_count: int = betterproto.int32_field(52)
    # 百科 id
    wiki_id: int = betterproto.int32_field(53)
    # 禁止使用漫读券/限免卡/福利券的最新话数量
    disable_coupon_amount: int = betterproto.int32_field(54)
    # 0-非日漫 1-日漫
    japan_comic: bool = betterproto.bool_field(55)
    # 互动数
    interact_value: int = betterproto.int64_field(56)
    # 临时休刊时间(无休刊时间为字符串空)
    temporary_finish_time: str = betterproto.string_field(57)
    # 视频封面
    video: "Video" = betterproto.message_field(58)
    # 一句话简介
    introduction: str = betterproto.string_field(59)
    # 评论区状态 0-关闭 1-打开
    comment_status: int = betterproto.int32_field(60)


@dataclass
class Video(betterproto.Message):
    # 视频
    aid: int = betterproto.int64_field(1)
    cid: int = betterproto.int64_field(2)
    # 视频封面，可有可无
    cover: str = betterproto.string_field(3)


@dataclass
class GetWikiDetailReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class GetWikiDetailResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetWikiDetail" = betterproto.message_field(3)


@dataclass
class GetWikiDetail(betterproto.Message):
    wiki: "WikiDetail" = betterproto.message_field(1)


@dataclass
class WikiDetail(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 标题，中文名
    title: str = betterproto.string_field(2)
    # 漫画原名
    origin_title: str = betterproto.string_field(3)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(4)
    # 发行方
    producer: str = betterproto.string_field(5)
    # 地区
    area: str = betterproto.string_field(6)
    # 开播时间，后台是按照字符串存储的
    publish_time: str = betterproto.string_field(7)
    # 更新频率
    frequency: str = betterproto.string_field(8)
    # 预约追漫状态 0-非 1-已预约 2-未开通预约追漫
    pre_favorite: int = betterproto.int32_field(9)
    # 风格信息
    style: List["StyleInfo"] = betterproto.message_field(10)
    # 简介
    evaluate: str = betterproto.string_field(11)
    # 作者
    author: "AuthorDetail" = betterproto.message_field(12)
    # 作者相关作品
    relations: List["ComicShort"] = betterproto.message_field(13)
    # 更多推荐漫画
    recommends: List["ComicShort"] = betterproto.message_field(14)
    # 相关专栏
    columns: List["Column"] = betterproto.message_field(15)


@dataclass
class AuthorDetail(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 作者原名
    name: str = betterproto.string_field(2)
    # 血型
    blood: str = betterproto.string_field(3)
    # 出生地
    birthplace: str = betterproto.string_field(4)
    # 星座
    constellation: str = betterproto.string_field(5)
    # 爱好
    hobby: str = betterproto.string_field(6)
    # 简介
    evaluate: str = betterproto.string_field(7)
    # 成就
    achievement: str = betterproto.string_field(8)
    # 作者照片
    photo: str = betterproto.string_field(9)


@dataclass
class ComicShort(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)
    image_url: str = betterproto.string_field(3)
    style: List["StyleInfo"] = betterproto.message_field(4)


@dataclass
class Column(betterproto.Message):
    # 专栏 id
    id: int = betterproto.int64_field(1)
    image_url: str = betterproto.string_field(2)
    # 专栏标题
    title: str = betterproto.string_field(3)
    # 作者头像信息
    author_face: str = betterproto.string_field(4)


@dataclass
class SeriesInfo(betterproto.Message):
    id: int = betterproto.int32_field(1)
    comics: List["SeriesComic"] = betterproto.message_field(2)


@dataclass
class SeriesComic(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)


@dataclass
class FavComicInfo(betterproto.Message):
    # 该漫画是否有追漫送券活动
    has_fav_activity: bool = betterproto.bool_field(1)
    # 追漫送券数量
    fav_free_amount: int = betterproto.int32_field(2)
    # 1 漫读券 2 限免卡 3 优惠卡
    fav_coupon_type: int = betterproto.int32_field(3)


@dataclass
class ChapterInfo(betterproto.Message):
    # 卷 id
    id: int = betterproto.int32_field(1)
    # 卷标题
    title: str = betterproto.string_field(2)
    # 卷短标题
    short_title: str = betterproto.string_field(3)
    # 0-免费 1-付费
    pay_mode: int = betterproto.int32_field(4)
    # 0-下线 1-上线 2-定时上线
    status: int = betterproto.int32_field(5)
    # 0-未开卷 1-连载 2-完结
    is_finished: int = betterproto.int32_field(6)
    cover: str = betterproto.string_field(7)
    # 价格
    gold: int = betterproto.int32_field(8)
    # 优惠价格
    real_gold: int = betterproto.int32_field(9)
    # 序号
    ord: float = betterproto.float_field(10)
    # 预计话数
    expected_eps: int = betterproto.int32_field(11)
    # 预售文案
    msg: str = betterproto.string_field(12)
    # 预售截止时间(2006-01-02 15:04:05)
    deadline: str = betterproto.string_field(13)
    # 0-非预售 1-预售
    is_pre: int = betterproto.int32_field(14)
    # 是否已经解锁
    is_locked: bool = betterproto.bool_field(15)
    # 该卷真实下多少话
    ep_count: int = betterproto.int32_field(16)
    # 1 购买解锁 2 整本卷限免 3 普通卷限免 4 畅读卡卷限免 5 畅读卡整本卷限免
    unlock_type: int = betterproto.int32_field(17)


@dataclass
class EpInfo(betterproto.Message):
    # 话ID epid
    id: int = betterproto.int32_field(1)
    # 序号
    ord: float = betterproto.float_field(2)
    # 已读标记 1:已读 0:未读
    read: int = betterproto.int32_field(3)
    # 付费模式 0.免费, 1.付费
    pay_mode: int = betterproto.int32_field(4)
    # 这是个神奇的字段 漫画为付费章节而且用户没有购买(以用户章节权限表为准)时返回 true 特别地，用户没有购买的付费章节参与限免活动时，该字段为
    # true
    is_locked: bool = betterproto.bool_field(5)
    # 需支付漫币价格
    pay_gold: int = betterproto.int32_field(6)
    # 单话大小
    size: int = betterproto.int32_field(7)
    # 短标题
    short_title: str = betterproto.string_field(8)
    # 当前章节是否有限免
    is_in_free: bool = betterproto.bool_field(9)
    # 标题，即长标题
    title: str = betterproto.string_field(10)
    # 单话封面
    cover: str = betterproto.string_field(11)
    # 发布时间
    pub_time: str = betterproto.string_field(12)
    # 单话评论数
    comments: int = betterproto.int32_field(13)
    # 解锁过期时间 2006-01-02 15:04:05
    unlock_expire_at: str = betterproto.string_field(14)
    # 单话解锁类型： - 1、漫币/漫读券 - 2、等免 - 3、限免卡 - 4、新人限免 - 5、畅读卡限免
    unlock_type: int = betterproto.int32_field(15)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(16)
    # 番剧进度条信息
    progress: str = betterproto.string_field(17)
    # 赞总数
    like_count: int = betterproto.int32_field(18)
    # 卷 id
    chapter_id: int = betterproto.int32_field(19)
    # 单话类型 0-正文、1-活动、2-番外、3-公告、4-预告、100-其他
    type: int = betterproto.int32_field(20)


@dataclass
class GetFusionPageSettingsReq(betterproto.Message):
    # 单话ID
    ep_id: int = betterproto.int32_field(1)


@dataclass
class GetFusionPageSettingsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetFusionPageSettingsData" = betterproto.message_field(3)


@dataclass
class GetFusionPageSettingsData(betterproto.Message):
    settings: List["FusionPageSettings"] = betterproto.message_field(1)


@dataclass
class FusionPageSettings(betterproto.Message):
    # 合页右边页码
    right_page: int = betterproto.int32_field(1)
    # 合页左边页码
    left_page: int = betterproto.int32_field(2)


@dataclass
class Image(betterproto.Message):
    # 路径
    path: str = betterproto.string_field(1)
    # 宽度
    x: int = betterproto.int32_field(2)
    # 高度
    y: int = betterproto.int32_field(3)


@dataclass
class ImageIndexData(betterproto.Message):
    # index 文件路径，读取逻辑跟 Index 的 data 字段相同
    path: str = betterproto.string_field(1)
    # 此字段目前只用于灰度测试。 - 如果 index 非 null，客户端可直接使用本字段内容。 - 如果 index 为 null，客户端需从 bfs
    # 下载 index.data 文件并解码。
    images: List["Image"] = betterproto.message_field(2)
    # index 文件最近更新时间，格式 "2006-01-02 15:04:05" 可能会有 "0001-01-01 00:00:00" 的情况！！
    last_modified: str = betterproto.string_field(3)
    # host 域名通过服务端返回，以服务端返回的为准
    host: str = betterproto.string_field(4)


@dataclass
class ImageIndexResp(betterproto.Message):
    # 1.需要购买 2.用户被冻结 3.用户被封禁
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ImageIndexData" = betterproto.message_field(3)


@dataclass
class IndexReq(betterproto.Message):
    ep_id: int = betterproto.int32_field(1)
    from_: str = betterproto.string_field(2)


@dataclass
class IndexResp(betterproto.Message):
    # 1.需要购买
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # "/bfs/comic/24967/232628/data.index?token=aaaaa"
    data: str = betterproto.string_field(3)


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class GetRookieComicsReq(betterproto.Message):
    page_size: int = betterproto.int32_field(1)
    page_num: int = betterproto.int32_field(2)


@dataclass
class GetRookieComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetRookieComics" = betterproto.message_field(3)


@dataclass
class GetRookieComics(betterproto.Message):
    comics: List["RookieComics"] = betterproto.message_field(1)
    # 是否是 web 端新人
    is_rookie: bool = betterproto.bool_field(2)


@dataclass
class RookieComics(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 漫画封面
    cover: str = betterproto.string_field(3)
    # 推荐理由
    recommendation: str = betterproto.string_field(4)
    # 风格
    styles: List["StyleInfo"] = betterproto.message_field(5)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(6)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(7)
    # true 已追漫
    has_fav: bool = betterproto.bool_field(8)
    # 是否直接进阅读器
    jump_value: str = betterproto.string_field(9)
    # 算法推荐 ext 字段
    ext: str = betterproto.string_field(10)


@dataclass
class GetSameThemeComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetSameThemeComics" = betterproto.message_field(3)


@dataclass
class GetSameThemeComics(betterproto.Message):
    # 模块 id
    id: int = betterproto.int32_field(1)
    # 模块名称，即合集名称
    title: str = betterproto.string_field(2)
    # 合集封面
    cover: str = betterproto.string_field(3)
    comics: List["SameThemeComics"] = betterproto.message_field(4)


@dataclass
class SameThemeComics(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)
    # 最近更新至
    last_short_title: str = betterproto.string_field(4)
    # 作者
    authors: List[str] = betterproto.string_field(5)
    # 风格
    styles: List[str] = betterproto.string_field(6)
    # 追漫 0-未追漫 1-已追漫
    fav: int = betterproto.int32_field(7)
    # 简介
    introduction: str = betterproto.string_field(8)
    # 漫画竖版封面
    vertical_cover: str = betterproto.string_field(9)


@dataclass
class ClassPageReq(betterproto.Message):
    # 风格标签ID (全部填-1)
    style_id: int = betterproto.int32_field(1)
    # 地区ID (全部填-1)
    area_id: int = betterproto.int32_field(2)
    # 1;完结 0;连载 (全部填-1, 连载包含未开刊)
    is_finish: int = betterproto.int32_field(3)
    # 排序 0:人气 1:更新 2:订阅 -1 默认排序
    order: int = betterproto.int32_field(4)
    # 页码
    page_num: int = betterproto.int32_field(5)
    # 条目数
    page_size: int = betterproto.int32_field(6)
    # 付费方式： - 1 免费漫画 - 2 付费漫画 - 3 等费漫画
    is_free: int = betterproto.int32_field(7)
    # 查询关键词
    key_word: str = betterproto.string_field(8)


@dataclass
class GetClassPageLayoutReq(betterproto.Message):
    # tab 类型 id
    tab_id: int = betterproto.int32_field(1)


@dataclass
class GetClassPageReq(betterproto.Message):
    # GetClassPageLayout 接口中的 id 字段
    id: int = betterproto.int32_field(1)


@dataclass
class GetClassPageFavoriteRewardResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FavoriteRewards" = betterproto.message_field(3)


@dataclass
class FavoriteRewards(betterproto.Message):
    comics: List["FavoriteReward"] = betterproto.message_field(1)


@dataclass
class FavoriteReward(betterproto.Message):
    # 封面
    cover: str = betterproto.string_field(1)
    # 作品名
    title: str = betterproto.string_field(2)
    comic_id: int = betterproto.int32_field(3)
    # 推荐语
    recommend: str = betterproto.string_field(4)
    # 追漫状态 0-未追漫 1-已追漫
    status: int = betterproto.int32_field(5)
    # 追漫送券数量
    amount: int = betterproto.int32_field(6)
    # 是否已经领取过 0-未领取 1-已领取
    has_received: bool = betterproto.bool_field(7)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(8)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(9)


@dataclass
class GetClassPageComicsRankResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetClassPageComicsRank" = betterproto.message_field(3)


@dataclass
class GetClassPageComicsRank(betterproto.Message):
    rank: List["ClassPageComicsRank"] = betterproto.message_field(1)


@dataclass
class ClassPageComicsRank(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    comic_title: str = betterproto.string_field(2)
    cover: str = betterproto.string_field(3)
    last_short_title: str = betterproto.string_field(4)
    recommendation: str = betterproto.string_field(5)
    styles: List["StyleInfo"] = betterproto.message_field(6)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(7)
    # 总话数
    total: int = betterproto.int32_field(8)


@dataclass
class GetClassPageHighEnergyEpResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetClassPageHighEnergyEp" = betterproto.message_field(3)


@dataclass
class GetClassPageHighEnergyEp(betterproto.Message):
    eps: List["ClassPageHighEnergyEp"] = betterproto.message_field(1)


@dataclass
class ClassPageHighEnergyEp(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    comic_title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)
    # 单话评论数
    ep_comment: int = betterproto.int32_field(4)
    # 单话短标题
    ep_short_title: str = betterproto.string_field(5)
    # 单话长标题
    ep_title: str = betterproto.string_field(6)
    # 单话 id
    ep_id: int = betterproto.int32_field(7)
    # 推荐语
    recommendation: str = betterproto.string_field(8)


@dataclass
class GetClassPageThreeComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ClassPageThreeComics" = betterproto.message_field(3)


@dataclass
class ClassPageThreeComics(betterproto.Message):
    comics: List["ThreeComics"] = betterproto.message_field(1)


@dataclass
class ThreeComics(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    comic_title: str = betterproto.string_field(2)
    recommendation: str = betterproto.string_field(3)
    vertical_cover: str = betterproto.string_field(4)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(5)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(6)
    # 新人实验，是否直接进阅读器
    jump_value: str = betterproto.string_field(7)


@dataclass
class GetNewComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "NewComics" = betterproto.message_field(3)


@dataclass
class NewComics(betterproto.Message):
    comics: List["NewComic"] = betterproto.message_field(1)


@dataclass
class NewComic(betterproto.Message):
    # 作品封面
    cover: str = betterproto.string_field(1)
    # 作品名
    title: str = betterproto.string_field(2)
    comic_id: int = betterproto.int32_field(3)
    # 如果 online_time 为空,客户端展示敬请期待
    online_time: str = betterproto.string_field(4)
    # 新作预约状态 0-未预约 1-已预约
    status: int = betterproto.int32_field(5)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(6)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(7)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(8)
    # 预计开刊时间 格式 2006.01.02
    release_date: str = betterproto.string_field(9)


@dataclass
class GetClassPageHomeBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ClassPageHomeBanner" = betterproto.message_field(3)


@dataclass
class GetClassPageRecommendBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ClassPageRecommendBanner" = betterproto.message_field(3)


@dataclass
class ClassPageRecommendBanner(betterproto.Message):
    # 推广大卡
    banner: "RecommendBanner" = betterproto.message_field(1)
    # 专栏模块
    banners: List["RecommendBanner"] = betterproto.message_field(2)


@dataclass
class ClassPageHomeBanner(betterproto.Message):
    banner: List["HomeBanner"] = betterproto.message_field(1)


@dataclass
class GetClassPageFourComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FourComics" = betterproto.message_field(3)


@dataclass
class GetClassPageLayoutResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Layout" = betterproto.message_field(3)


@dataclass
class Layout(betterproto.Message):
    # 列表，根据列表中的信息去获取具体对应的类型
    layout: List["LayoutData"] = betterproto.message_field(1)
    # 是否可以看见新手任务
    new_user_task: bool = betterproto.bool_field(2)


@dataclass
class LayoutData(betterproto.Message):
    # 0-分类页顶部 banner 1-推广 banner 2-横版 4 图 3-竖版 6 图 4-追漫有礼 5-新作预约 6-专栏模块 7-热门排行
    # 8-高能单话 9-新人三图 10-更多推荐 11-登录条 12-福利 13-番推漫 15-新人限免 16-新手签到 17-新手限时任务
    # 18-自动竖版六图
    type: int = betterproto.int32_field(1)
    # 模块 id
    id: int = betterproto.int32_field(2)
    # 模块名
    name: str = betterproto.string_field(3)
    # 该模块配色
    color: str = betterproto.string_field(4)


@dataclass
class HomeBanner(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    image_url: str = betterproto.string_field(3)
    # 跳转 url
    jump_url: str = betterproto.string_field(4)
    # 背景颜色
    background: str = betterproto.string_field(5)


@dataclass
class RecommendBanner(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    image_url: str = betterproto.string_field(3)
    # 跳转 url
    jump_url: str = betterproto.string_field(4)
    # 背景颜色
    background: str = betterproto.string_field(5)


@dataclass
class FourComics(betterproto.Message):
    # 为空或者固定长度 4
    stable_four_comics: List["FourClassPageData"] = betterproto.message_field(1)


@dataclass
class SixComics(betterproto.Message):
    # 0-不需要换一换 1-需要换一换
    need_switch: int = betterproto.int32_field(1)
    roll_six_comics: List["SixClassPageData"] = betterproto.message_field(2)
    # 查看全部漫画时，返回配置的总个数
    total: int = betterproto.int32_field(3)


@dataclass
class FourClassPageData(betterproto.Message):
    # 漫画 ID
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(6)
    # 上线状态 -1:下线 0:正常
    status: int = betterproto.int32_field(7)
    # 最新话序号（更新至x话）
    last_ord: float = betterproto.float_field(8)
    # 总话数（全x话）
    total: int = betterproto.int32_field(9)
    # 发布时间
    release_time: str = betterproto.string_field(10)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(11)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(12)
    # 推荐语 漫画百科一句话简介
    recommendation: str = betterproto.string_field(13)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(14)


@dataclass
class SixClassPageData(betterproto.Message):
    # 漫画 ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(6)
    # 上线状态 -1:下线 0:正常
    status: int = betterproto.int32_field(7)
    # 最新话序号（更新至x话）
    last_ord: float = betterproto.float_field(8)
    # 总话数（全x话）
    total: int = betterproto.int32_field(9)
    # 发布时间
    release_time: str = betterproto.string_field(10)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(11)
    # 折扣类型 1:有任意折扣 2:限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(12)
    # 推荐语 漫画百科一句话简介
    recommendation: str = betterproto.string_field(13)
    # 上次阅读话 id
    last_read_ep_id: int = betterproto.int32_field(14)
    # 上次阅读话短标题
    latest_ep_short_title: str = betterproto.string_field(15)
    # 风格
    style: List[str] = betterproto.string_field(16)
    # 作者名
    author_name: List[str] = betterproto.string_field(17)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(18)


@dataclass
class GetAutoSixComicsReq(betterproto.Message):
    # GetClassPageLayout 接口中的 id 字段 @gt:0
    id: int = betterproto.int32_field(1)
    # @gt:0
    page_num: int = betterproto.int32_field(2)
    # @gt:0
    page_size: int = betterproto.int32_field(3)
    # 是否全部查看 0-换一换接口 1-查看全部接口
    is_all: int = betterproto.int32_field(4)
    # true-是第一次登录
    is_first: bool = betterproto.bool_field(5)


@dataclass
class GetAutoSixComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "SixComics" = betterproto.message_field(3)


@dataclass
class GetClassPageSixComicsReq(betterproto.Message):
    # GetClassPageLayout 接口中的 id 字段 使用show_page字段的时候 id 可以不传
    id: int = betterproto.int32_field(1)
    # @gt:0
    page_num: int = betterproto.int32_field(2)
    # @gt:0
    page_size: int = betterproto.int32_field(3)
    # 是否全部查看 0-换一换接口 1-查看全部接口
    is_all: int = betterproto.int32_field(4)
    # 特殊场景展示的场景
    show_case: int = betterproto.int32_field(5)


@dataclass
class GetClassPageSixComicsResp(betterproto.Message):
    # v2 版本新增分类 tab 类型
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "SixComics" = betterproto.message_field(3)


@dataclass
class ClassPageResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ClassPageData"] = betterproto.message_field(3)


@dataclass
class ClassPageData(betterproto.Message):
    # 漫画ID
    season_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(6)
    # 上线状态, -1:下线 0:正常
    status: int = betterproto.int32_field(7)
    # 最新话序号（更新至x话）
    last_ord: float = betterproto.float_field(8)
    # 总话数（全x话）
    total: int = betterproto.int32_field(9)
    # 发布时间
    release_time: str = betterproto.string_field(10)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(11)
    # 折扣类型： - 1、有任意折扣 - 2、限免 - 3、指定章节限免
    discount_type: int = betterproto.int32_field(12)
    # 是否支持限免
    allow_wait_free: bool = betterproto.bool_field(13)


@dataclass
class RecommendReq(betterproto.Message):
    # 推荐池ID&数量  e.g.[{"pool_id":12345, "num":3}]
    json_data: str = betterproto.string_field(1)
    # 排除漫画ID
    ban_i_d: int = betterproto.int32_field(2)
    # 页码(仅部分pool_id支持换一换)
    page_num: int = betterproto.int32_field(3)


@dataclass
class RecommendJson(betterproto.Message):
    pool_id: int = betterproto.int32_field(1)
    num: int = betterproto.int32_field(2)


@dataclass
class RecommendResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["Recommend"] = betterproto.message_field(3)


@dataclass
class Recommend(betterproto.Message):
    # 漫画 ID
    season_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(6)
    # 上线状态, -1:下线 0:正常
    status: int = betterproto.int32_field(7)
    # 最新话序号
    last_ord: float = betterproto.float_field(8)
    # 总话数（全x话）
    total: int = betterproto.int32_field(9)
    # 发布时间
    release_time: str = betterproto.string_field(10)
    # 最新话短标题 如果是字符串类型的数字，对应更新至xx话 如果是字符串，如 "预告"，则对应更新至预告
    last_short_title: str = betterproto.string_field(11)
    # 算法透传字段
    ext: str = betterproto.string_field(12)
    # 推荐理由(算法透传)
    recommend_reason: str = betterproto.string_field(13)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(14)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(15)
    # 风格标签
    styles: List[str] = betterproto.string_field(16)


@dataclass
class SearchResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "SearchData" = betterproto.message_field(3)


@dataclass
class JumpLabelInfo(betterproto.Message):
    # 风格 tab 页 id
    style_id: int = betterproto.int32_field(1)
    # 地区 tab 页 id
    area_id: int = betterproto.int32_field(2)
    # 是否完结等
    status: int = betterproto.int32_field(3)
    # 付费信息
    price: int = betterproto.int32_field(4)
    # 排序信息
    order: int = betterproto.int32_field(5)


@dataclass
class SearchData(betterproto.Message):
    list: List["SearchInfo"] = betterproto.message_field(1)
    # 分页总页数
    total_page: int = betterproto.int32_field(2)
    # 搜索结果总数量
    total_num: int = betterproto.int32_field(3)
    # 如果没有/较少搜索结果的情况下，添加推荐信息
    recommends: List["SearchRecommends"] = betterproto.message_field(4)
    # 同义词
    similar: str = betterproto.string_field(5)
    # 跳转分类页详情
    jump: "JumpLabelInfo" = betterproto.message_field(6)
    # 搜索 id
    se_id: str = betterproto.string_field(7)


@dataclass
class SearchRecommends(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 最新话标题
    last_short_title: str = betterproto.string_field(6)
    # 简介
    recommendation: str = betterproto.string_field(7)
    # 连载状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(8)
    # 漫画在线单话总数
    total: int = betterproto.int32_field(9)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(10)
    # 作者名
    author_name: List[str] = betterproto.string_field(11)
    # 风格标签
    styles: List[str] = betterproto.string_field(12)
    # 百科别名
    alia_title: List[str] = betterproto.string_field(13)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(14)


@dataclass
class SearchInfo(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 百科中文名
    org_title: str = betterproto.string_field(3)
    # 百科别名
    alia_title: List[str] = betterproto.string_field(4)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(5)
    # 方版封面
    square_cover: str = betterproto.string_field(6)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(7)
    # 作者名
    author_name: List[str] = betterproto.string_field(8)
    # 风格标签
    styles: List[str] = betterproto.string_field(9)
    # 是否完结 1:是 0:否 -1:未开刊
    is_finish: int = betterproto.int32_field(10)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(11)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(12)
    # 0-漫画信息 1-百科信息，当是百科信息时，界面上展示的内容取 wiki 对象
    type: int = betterproto.int32_field(13)
    # 百科信息
    wiki: "Wiki" = betterproto.message_field(14)


@dataclass
class Wiki(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 标题，中文名
    title: str = betterproto.string_field(2)
    # 百科原名
    origin_title: str = betterproto.string_field(3)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(4)
    # 发行方
    producer: str = betterproto.string_field(5)
    # 作者名
    author_name: List[str] = betterproto.string_field(6)
    # 开播时间，后台是按照字符串存储的
    publish_time: str = betterproto.string_field(7)
    # 更新频率
    frequency: str = betterproto.string_field(8)


@dataclass
class SearchSugReq(betterproto.Message):
    term: str = betterproto.string_field(1)
    num: int = betterproto.int32_field(2)


@dataclass
class SearchSugResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List[str] = betterproto.string_field(3)


@dataclass
class HomePageReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 平台 phone/h5
    platform: str = betterproto.string_field(2)


@dataclass
class HomePageResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["CardInfo"] = betterproto.message_field(3)


@dataclass
class CardInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 卡片类型 1-漫画大卡 2-推广卡
    type: int = betterproto.int32_field(3)
    # 子标题
    sub_title: str = betterproto.string_field(4)
    # 图片
    img: str = betterproto.string_field(5)
    # 跳转类型 1-漫画详情 2-漫画单话
    jump_type: int = betterproto.int32_field(6)
    # 跳转内容
    jump_value: str = betterproto.string_field(7)
    # 漫画ID
    comic_id: int = betterproto.int32_field(8)
    # 风格
    styles: List["StyleInfo"] = betterproto.message_field(9)
    # 角标
    icon: int = betterproto.int32_field(10)
    # 总评论数
    comment_total: int = betterproto.int32_field(11)
    # 百科竖版封面,给 pc 展示使用
    vertical_cover: str = betterproto.string_field(12)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(13)
    # 当类型是聚合卡时，详细信息看此处
    combine: "CombineCard" = betterproto.message_field(14)


@dataclass
class StyleInfo(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)


@dataclass
class BannerReq(betterproto.Message):
    # 平台 phone/h5/pc
    platform: str = betterproto.string_field(1)


@dataclass
class BannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["BannerInfo"] = betterproto.message_field(3)


@dataclass
class BannerInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    img: str = betterproto.string_field(3)
    # 跳转类型 1-漫画详情 2-漫画单话 3-活动专题页地址
    jump_type: int = betterproto.int32_field(4)
    # 跳转内容
    jump_value: str = betterproto.string_field(5)
    # 新图片
    img2: str = betterproto.string_field(6)
    # 背景
    bg: str = betterproto.string_field(7)


@dataclass
class CommentBannerReq(betterproto.Message):
    # 漫画 id
    comic_id: int = betterproto.int32_field(1)


@dataclass
class CommentBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EntBanner" = betterproto.message_field(3)


@dataclass
class CommentBanner(betterproto.Message):
    # 全局 banner
    global_: "CommentBannerInfo" = betterproto.message_field(1)
    # 限定漫画 banner
    local: "CommentBannerInfo" = betterproto.message_field(2)


@dataclass
class CommentBannerInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 文案
    content: str = betterproto.string_field(3)
    # 跳转内容 1-漫画详情：bilicomic://detail/10 2-单话：bilicomic://reader/10/11
    # 3-活动页地址：http://www.baidu.com
    jump_url: str = betterproto.string_field(4)
    # 背景颜色
    background: str = betterproto.string_field(5)


@dataclass
class SearchBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "SearchBanner" = betterproto.message_field(3)


@dataclass
class SearchBanner(betterproto.Message):
    banners: List["SearchBannerInfo"] = betterproto.message_field(1)


@dataclass
class SearchBannerInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片 url
    image_url: str = betterproto.string_field(3)
    # 跳转内容 1-漫画详情：bilicomic://detail/10 2-单话：bilicomic://reader/10/11
    # 3-活动页地址：http://www.baidu.com
    jump_url: str = betterproto.string_field(4)
    # 背景颜色
    background: str = betterproto.string_field(5)


@dataclass
class RewardBannerReq(betterproto.Message):
    # 预留根据漫画id查询指定banner的能力，目前为全局banner
    comic_id: int = betterproto.int32_field(1)


@dataclass
class MoreRecommendReq(betterproto.Message):
    # 当前漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 请求类型 0-漫画详情页更多推荐 1-畅读卡主页推荐
    type: int = betterproto.int32_field(2)
    # 如果客户端不传，服务端会默认为20
    page_size: int = betterproto.int32_field(3)


@dataclass
class MoreRecommendResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "MoreRecommendData" = betterproto.message_field(3)


@dataclass
class MoreRecommendData(betterproto.Message):
    # 同系列漫画
    series_comics: List["MoreRecommendComic"] = betterproto.message_field(1)
    # 同作者漫画
    author_comics: List["MoreRecommendComic"] = betterproto.message_field(2)
    # 更多推荐漫画
    recommend_comics: List["MoreRecommendComic"] = betterproto.message_field(3)
    # 该系列标题
    series_title: str = betterproto.string_field(4)
    # 关联漫画作者
    author: "Author" = betterproto.message_field(5)


@dataclass
class MoreRecommendComic(betterproto.Message):
    # 漫画 ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(6)
    # 上线状态, -1:下线 0:正常
    status: int = betterproto.int32_field(7)
    # 最新话序号
    last_ord: float = betterproto.float_field(8)
    # 总话数（全x话）
    total: int = betterproto.int32_field(9)
    # 发布时间
    release_time: str = betterproto.string_field(10)
    # 最新话短标题 如果是字符串类型的数字，对应更新至xx话 如果是字符串，如 "预告"，则对应更新至预告
    last_short_title: str = betterproto.string_field(11)
    # 算法透传字段
    ext: str = betterproto.string_field(12)
    # 推荐理由(算法透传)
    recommend_reason: str = betterproto.string_field(13)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(14)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(15)
    # 是否追漫(仅同系列,同作者漫画有效)
    is_fav: bool = betterproto.bool_field(16)
    # 标签
    styles: List["StyleInfo"] = betterproto.message_field(17)
    # 作者
    authors: List["Author"] = betterproto.message_field(18)
    # 上次阅读话 id
    last_read_ep_id: int = betterproto.int32_field(19)


@dataclass
class RewardBannerResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 数组，只有一个值，默认取第一个 如果存在限定单部漫画，数组第一个值为限定对应的 banner 不存在限定的，第一个值为全局的打赏 banner
    data: List["RewardBannerInfo"] = betterproto.message_field(3)


@dataclass
class RewardBannerInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    image_url: str = betterproto.string_field(3)
    # 预留字段，跳转类型 1-活动专题页地址
    jump_type: int = betterproto.int32_field(4)
    # 跳转内容
    jump_url: str = betterproto.string_field(5)
    # 背景颜色
    background: str = betterproto.string_field(6)
    # 预留字段，banner类型，1为全局，2为限定
    banner_type: int = betterproto.int32_field(7)
    # 预留字段，banner类型为2时，此处漫画id生效
    comic_id: int = betterproto.int32_field(8)


@dataclass
class FlashReq(betterproto.Message):
    pass


@dataclass
class ListFlashData(betterproto.Message):
    list: List["FlashInfo"] = betterproto.message_field(1)


@dataclass
class ListFlashResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListFlashData" = betterproto.message_field(3)


@dataclass
class FlashResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FlashInfo" = betterproto.message_field(3)


@dataclass
class FlashInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    img: str = betterproto.string_field(3)
    # 跳转类型 1-漫画详情 2-漫画单话 3-活动专题页地址
    jump_type: int = betterproto.int32_field(4)
    # 跳转内容
    jump_value: str = betterproto.string_field(5)
    # 下线时间 格式： 2006-01-02 15:04:05
    offline_time: str = betterproto.string_field(6)
    # 闪屏类型 0-图片 1-视频
    meta_type: int = betterproto.int32_field(7)
    # 视频链接
    video: str = betterproto.string_field(8)
    # 上线时间 格式： 2006-01-02 15:04:05
    online_time: str = betterproto.string_field(9)


@dataclass
class Bubble(betterproto.Message):
    # 主键ID
    id: int = betterproto.int32_field(1)
    # 气泡图标
    img_url: str = betterproto.string_field(2)
    # 跳转类型 1、跳转型，2、弹窗型
    jump_type: int = betterproto.int32_field(3)
    # 跳转URL
    jump_url: str = betterproto.string_field(4)
    # 开始时间 "2006-01-02 15:04:05"
    start_time: str = betterproto.string_field(5)
    # 结束时间 0001-01-01 00:00:00 代表永久上线 (PS: 原则上服务端会返回当前在时间范围内的气泡,
    # 但是客户端获取气泡并展示一段时间后, 是否还在时间范围内可根据返回的时间范围判断)
    end_time: str = betterproto.string_field(6)
    # 弹窗图片URL
    pop_url: str = betterproto.string_field(7)
    # 落地类型 1、跳转型，2、充值型，3、领取型, 4 充值领取礼包(不限充值领取次数) 5 充值领取礼包（仅一次）
    pop_type: int = betterproto.int32_field(8)
    # 充值档位(漫币)，客户端需判断该档位是否存在
    pay_config: int = betterproto.int32_field(9)
    # 关闭后多少时间内不重新展示(秒)
    cd: int = betterproto.int32_field(10)
    # 礼包领取方式 1 仅领取, 2 领取+追漫, 3 领取+追漫+跳转
    gift_type: int = betterproto.int32_field(11)
    # 礼包跳转url
    gift_url: str = betterproto.string_field(12)
    # 已经获取礼包
    has_taken_gift: bool = betterproto.bool_field(13)
    # 追漫ID
    gift_comic_id: int = betterproto.int32_field(14)


@dataclass
class GetBubbleReq(betterproto.Message):
    # 气泡场景 0 首页, 1 详情页, 2 应援 3 月票, 4 支付页(破冰)
    show_page: int = betterproto.int32_field(1)
    # 首页不传
    comic_id: int = betterproto.int32_field(2)


@dataclass
class GetBubbleResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Bubble" = betterproto.message_field(3)


@dataclass
class GetBubblesResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetBubblesData" = betterproto.message_field(3)


@dataclass
class GetBubblesData(betterproto.Message):
    bubbles: List["Bubble"] = betterproto.message_field(1)


@dataclass
class AppInitReq(betterproto.Message):
    # 未登录状态是否需要判断命中新人实验 0-不需要 1-需要
    new_fall_into_trap: int = betterproto.int32_field(1)


@dataclass
class AppInitResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "AppInitData" = betterproto.message_field(3)


@dataclass
class CheckNetworkResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CheckNetworkData" = betterproto.message_field(3)


@dataclass
class CheckNetworkData(betterproto.Message):
    # 用户IP
    ip: str = betterproto.string_field(1)
    # 通用路径
    common_img_path: str = betterproto.string_field(2)
    # 通用链接
    common_img_url: str = betterproto.string_field(3)
    # 通用图片链接token
    common_img_token: str = betterproto.string_field(4)


@dataclass
class ActivityTabInfo(betterproto.Message):
    # 活动标题
    name: str = betterproto.string_field(1)
    # 图片 URL
    img: str = betterproto.string_field(2)
    # 活动的链接
    url: str = betterproto.string_field(3)


@dataclass
class DanmakuConf(betterproto.Message):
    # 弹幕显示配置
    num: int = betterproto.int32_field(1)
    # 默认持续时间单位: 毫秒
    default_duration: int = betterproto.int32_field(2)
    # 默认间隔时间单位: 毫秒
    default_interval: int = betterproto.int32_field(3)
    # 弹幕数较多时，持续时间单位: 毫秒
    escalate_duration: int = betterproto.int32_field(4)
    # 弹幕数较多时，间隔时间单位: 毫秒
    escalate_interval: int = betterproto.int32_field(5)


@dataclass
class AppInitData(betterproto.Message):
    # 安卓新版本信息
    patch: "AndroidPatchInfo" = betterproto.message_field(1)
    # 闪屏信息
    flash: "FlashInfo" = betterproto.message_field(2)
    # iOS 是否开启 B 币兑换功能
    ios_bpay_enabled: bool = betterproto.bool_field(3)
    # 当前环境(DEV/UAT/PRE/PRO)
    env: str = betterproto.string_field(4)
    # iOS 提审 build
    auditing_build: str = betterproto.string_field(5)
    # 离线下载图片压缩质量系数 可配置范围(1~100)
    offline_image_quality: int = betterproto.int32_field(6)
    # 签到开关 0-不开启签到功能 1-开启签到功能
    clockin_switch: int = betterproto.int32_field(7)
    # IOS新版本
    ios_patch: "IosPatchInfo" = betterproto.message_field(8)
    # 联通免流页面地址
    unicom_free_url: str = betterproto.string_field(9)
    # 阅读器任务时长列表
    read_time_list: List[int] = betterproto.int32_field(10)
    # 单本漫画书签上限
    max_bookmark: int = betterproto.int32_field(11)
    # 运营 banner 信息
    operate: "OperateBannerInfo" = betterproto.message_field(12)
    # 暑期活动 url 空串表示没有开启活动
    summer_activity_url: str = betterproto.string_field(13)
    # 是否开启日漫跨页合并浏览功能 false: 关闭 true: 开启
    enable_manga_combine: bool = betterproto.bool_field(14)
    # 是否打开隐私弹窗
    enable_privacy_alert: bool = betterproto.bool_field(15)
    # 是否禁止分享功能
    disable_share_dynamic: bool = betterproto.bool_field(16)
    # fluter 灰度开关，取值 0~1000
    use_flutter: int = betterproto.int32_field(17)
    # 帮助中心链接
    help_center: str = betterproto.string_field(18)
    # 个人中心活动 banner 位
    user_center_operate: "OperateBannerInfo" = betterproto.message_field(19)
    # 活动 tab 信息
    activity_tab: "ActivityTabInfo" = betterproto.message_field(20)
    # 首页排行是否展示月票排行榜 true 展示月票排行榜 false 不展示月票排行榜
    enable_monthly_ticket: bool = betterproto.bool_field(21)
    # 首页排行是否展示往期月票排行榜 false 不展示
    enable_last_month: bool = betterproto.bool_field(22)
    # 详情页展示应援榜和月票榜 tab 位 false 定位到应援榜 true 定位到月票榜
    jump_to_monthly_ticket: bool = betterproto.bool_field(23)
    # ios 新阅读器灰度使用开关，true 时使用新阅读器
    new_reader: bool = betterproto.bool_field(24)
    # fawkes安卓ff, 0代表没有获取到值, 下同
    android_ff: int = betterproto.int32_field(26)
    # fawkes安卓config
    android_config: int = betterproto.int32_field(27)
    # fawkesIOSff
    ios_ff: int = betterproto.int32_field(28)
    # fawkesIOSconfig
    ios_config: int = betterproto.int32_field(29)
    # 编辑用户昵称所需积分
    edit_name_point: int = betterproto.int32_field(30)
    # 弹幕显示配置
    danmaku: "DanmakuConf" = betterproto.message_field(31)
    # 禁上自动关注漫画官方帐号
    no_auto_follow: bool = betterproto.bool_field(32)
    # 首页运营气泡, null为没有气泡
    bubble: "Bubble" = betterproto.message_field(33)
    # 错误上报采样值千分位 1 表示 1/1000，1000 表示总是上报，0 表示不上报
    report_sample: int = betterproto.int32_field(34)
    # 隐私条款/用户协议更新内容 App 安装后首次开启展示本地写死版本 之后根据 version 展示服务端配置版本 如果服务端没有更新，此字段为
    # null
    privacy_change: "PrivacyChange" = betterproto.message_field(35)
    # 免流h5地址
    free_flow_url: str = betterproto.string_field(36)
    # 各场景下推荐理由样式，场景 => 样式 {"1":{"back-color":"#112233","text-color":"#112233"}}
    # 没有配置会返回*空字符串*
    recommend_styles: str = betterproto.string_field(37)
    # 详情页是否展示点评模块 true 不展示
    forbidden_review: bool = betterproto.bool_field(38)
    # 短信登录开关
    sms_login_enable: bool = betterproto.bool_field(39)
    # 是否用户中心展示青少年模式入口
    show_user_center: bool = betterproto.bool_field(40)
    # 青少年模式弹窗频率(x天一次)
    teenager_frequency: int = betterproto.int32_field(41)
    # 青少年模式开启前文本
    teenager_before_open: str = betterproto.string_field(42)
    # 青少年模式开启后文本
    teenager_after_open: str = betterproto.string_field(43)
    # 青少年模式查找密码文案
    teenager_find_sign: str = betterproto.string_field(44)
    # 漫读卡推广banner(充值中心)
    card_banner_in_pay: "CardBanner" = betterproto.message_field(45)
    # 漫读卡推广banner(控制面板)
    card_banner_in_ctrl: "CardBanner" = betterproto.message_field(46)
    # 漫读卡推广banner(卡券包)
    card_banner_in_coupon: "CardBanner" = betterproto.message_field(47)
    # 首页/发现页颜色置灰
    gray_mode: bool = betterproto.bool_field(48)
    # 是否启用畅读卡入口
    enable_user_card: bool = betterproto.bool_field(49)
    # 冻结时长(秒)
    freeze_time: int = betterproto.int32_field(50)
    # 是否命中阅读器翻页方式 abtest
    scroll_mode_ab: bool = betterproto.bool_field(51)
    # 裂变相关
    fission: "Fission" = betterproto.message_field(52)
    # 充值活动开始时间 2006-01-02 15:04:05
    act_start_time: str = betterproto.string_field(53)
    # 充值活动结束时间 2006-01-02 15:04:05
    act_end_time: str = betterproto.string_field(54)
    # 充值活动入口文案
    act_entry_txt: str = betterproto.string_field(55)
    # 商城入口
    shop_entry: bool = betterproto.bool_field(56)
    # 商城入口文案
    shop_entry_txt: str = betterproto.string_field(57)
    # 游戏入口
    game_entry: bool = betterproto.bool_field(58)
    # 游戏入口文案
    game_entry_txt: str = betterproto.string_field(59)
    # 游戏入口简介
    game_entry_desc: str = betterproto.string_field(60)
    # 游戏入口 url
    game_entry_url: str = betterproto.string_field(61)


@dataclass
class Fission(betterproto.Message):
    # 是否启用
    enable_entry: bool = betterproto.bool_field(1)
    # 左标题
    title: str = betterproto.string_field(2)
    # 右标题
    subtitle: str = betterproto.string_field(3)
    # 活动跳转的 url
    url: str = betterproto.string_field(4)


@dataclass
class CardBanner(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 图片url
    img_url: str = betterproto.string_field(2)


@dataclass
class PrivacyChange(betterproto.Message):
    # 变更版本号，递增，App 展示以后需要要本地记录 服务端配置的版本号要高于 App 本地的版本号
    version: int = betterproto.int32_field(1)
    # 变更内容，纯文本，App 需要支持展示空格和换行
    content: str = betterproto.string_field(2)


@dataclass
class AndroidPatchInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 版本号
    version: int = betterproto.int32_field(2)
    # 版本名
    name: str = betterproto.string_field(3)
    # 版本文件大小
    size: int = betterproto.int64_field(4)
    # 版本描述
    desc: str = betterproto.string_field(5)
    # 安装包地址
    download_url: str = betterproto.string_field(6)
    # 强制更新 1-强制 0-非强制
    force: int = betterproto.int32_field(8)


@dataclass
class IosPatchInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 版本号
    version: int = betterproto.int32_field(2)
    # 版本名
    name: str = betterproto.string_field(3)
    # 版本文件大小
    size: int = betterproto.int64_field(4)
    # 版本描述
    desc: str = betterproto.string_field(5)
    # 安装包地址
    download_url: str = betterproto.string_field(6)
    # 强制更新 1-强制 0-非强制
    force: int = betterproto.int32_field(8)


@dataclass
class TopicReq(betterproto.Message):
    # 平台 phone/h5
    platform: str = betterproto.string_field(1)
    # 页码
    page_num: int = betterproto.int32_field(2)


@dataclass
class TopicResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["TopicInfo"] = betterproto.message_field(3)


@dataclass
class TopicInfo(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    img: str = betterproto.string_field(3)
    # 跳转类型 1-漫画详情 2-漫画单话 3-活动专题页地址
    jump_type: int = betterproto.int32_field(4)
    # 跳转内容
    jump_value: str = betterproto.string_field(5)
    # 新图片
    img2: str = betterproto.string_field(6)
    # 背景
    bg: str = betterproto.string_field(7)
    # 标签文案
    tag_text: str = betterproto.string_field(8)
    # 标签文案颜色
    tag_text_color: str = betterproto.string_field(9)
    # 标签颜色
    tag_color: str = betterproto.string_field(10)


@dataclass
class DownloadUrlResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DownloadUrlData" = betterproto.message_field(3)


@dataclass
class DownloadUrlData(betterproto.Message):
    url: str = betterproto.string_field(1)


@dataclass
class ScheduleListReq(betterproto.Message):
    # 日期
    date: str = betterproto.string_field(1)


@dataclass
class ScheduleListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ScheduleListData" = betterproto.message_field(3)


@dataclass
class ScheduleListData(betterproto.Message):
    # 已更新列表
    updated_list: List["ScheduleList"] = betterproto.message_field(1)
    # 未更新列表
    not_update_list: List["ScheduleList"] = betterproto.message_field(2)


@dataclass
class ScheduleList(betterproto.Message):
    # 漫画ID
    cid: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 图片
    pic: str = betterproto.string_field(3)
    # 更新状态 0-正常 1-停更
    status: int = betterproto.int32_field(4)
    # 停更通知
    reason: str = betterproto.string_field(5)
    # 是否追漫
    is_fav: int = betterproto.int32_field(6)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(7)
    # 最新话ID
    last_epid: int = betterproto.int32_field(8)
    # 是否更新
    is_update: int = betterproto.int32_field(9)
    # 连载状态 1:完结 0:连载中 -1:未开刊
    is_finish: int = betterproto.int32_field(10)


@dataclass
class GetRecommendComicsReq(betterproto.Message):
    # 调用方不需要传递本字段，不传或者传0（推荐不传）时需要额外传 pange_num 此时接口返回算法推荐的漫画列表 以下取值已经废弃： 浏览器刷新时获取
    # A 池内容,传值 1 点击换一换传值 2
    type: int = betterproto.int32_field(1)
    # 一次返回漫画数量
    page_size: int = betterproto.int32_field(2)
    # 主站页面点换一换的时候需要将 page_num +1并传回服务端
    page_num: int = betterproto.int32_field(3)


@dataclass
class GetRecommendComicsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "RecommendSlice" = betterproto.message_field(3)


@dataclass
class RecommendSlice(betterproto.Message):
    comics: List["RecommendComic"] = betterproto.message_field(1)


@dataclass
class RecommendComic(betterproto.Message):
    # 漫画 id，可以用来拼接访问漫画详情的接口
    comic_id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(3)
    # 风格，即 tag 根据需求自取
    styles: List[str] = betterproto.string_field(4)
    # 推荐算法透传字段，打点的时候需要上报
    ext: str = betterproto.string_field(5)


@dataclass
class ToSecondaryPageReq(betterproto.Message):
    # 0-单话聚合卡历史期刊 id 传对应的 father_id 1-单话聚合卡 2-书聚合卡
    type: int = betterproto.int32_field(1)
    # 后台配置的聚合卡 id
    id: int = betterproto.int32_field(2)


@dataclass
class ToSecondaryPageResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ToSecondaryPage" = betterproto.message_field(3)


@dataclass
class ToSecondaryPage(betterproto.Message):
    # 单话聚合卡
    cards: List["CombineCards"] = betterproto.message_field(1)


@dataclass
class CombineCards(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 合集名称
    father_title: str = betterproto.string_field(2)
    # 合集 id
    father_id: int = betterproto.int32_field(3)
    num: int = betterproto.int32_field(4)
    # 更新时间(2006-01-02 15:04:05)
    update_time: str = betterproto.string_field(5)
    cover: str = betterproto.string_field(6)
    color: str = betterproto.string_field(7)
    ep_info: List["ComicEpisode"] = betterproto.message_field(8)
    books: List["BookInfo"] = betterproto.message_field(9)
    # 副标题
    sub_title: str = betterproto.string_field(10)
    # 模版样式 0-滑动样式 1-列表样式
    template_type: int = betterproto.int32_field(11)


@dataclass
class BookInfo(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    comic_title: str = betterproto.string_field(2)
    # 封面
    cover: str = betterproto.string_field(3)
    # 排名
    rank: int = betterproto.int32_field(4)
    # 榜单类型 0-国漫 1-日漫 2-应援 3-月票 4-飙升 5-免费
    rank_type: int = betterproto.int32_field(5)
    # 评论总数
    comments: int = betterproto.int32_field(6)
    # 简介
    evaluate: str = betterproto.string_field(7)
    # 作者名
    author_name: List[str] = betterproto.string_field(11)
    # 风格标签
    styles: List[str] = betterproto.string_field(12)
    # 是否已追漫
    fav: int = betterproto.int32_field(13)
    # 阅读历史
    last_read_ep_id: int = betterproto.int32_field(14)
    # 自定义简介
    introduction: str = betterproto.string_field(15)
    # 排行榜名称，直接服务端吐出排行榜名称
    rank_name: str = betterproto.string_field(16)


@dataclass
class ComicEpisode(betterproto.Message):
    comic_id: int = betterproto.int32_field(1)
    comic_title: str = betterproto.string_field(2)
    ep_id: int = betterproto.int32_field(3)
    ep_title: str = betterproto.string_field(4)
    # 评论数
    comment: int = betterproto.int32_field(5)
    # 序号 第几话
    short_title: str = betterproto.string_field(6)
    # 单话封面
    ep_cover: str = betterproto.string_field(7)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(8)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(9)


@dataclass
class HomeStockReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # seed: page_num大于1时，需要传入第一页返回的seed
    seed: int = betterproto.int64_field(2)
    # 人工推荐去重 1-去重 2-不去重
    omit_cards: int = betterproto.int32_field(3)
    # 是否下拉刷新 1-下拉刷新，0-上拉加载
    drag: int = betterproto.int32_field(4)
    # 渠道包名
    channel: str = betterproto.string_field(5)
    # 新人 tab 实验 0-不是 1-是
    new_fall_into_trap: int = betterproto.int32_field(6)


@dataclass
class HomeNegativeFeedBackReq(betterproto.Message):
    # 标签 id
    label_id: str = betterproto.string_field(1)
    # 漫画 id 或者大卡的 id
    item_id: int = betterproto.int32_field(2)
    # 0-漫画 1-漫画大卡
    type: int = betterproto.int32_field(3)
    # homeRecommend 接口中的推荐算法透传字段 ext
    ext: str = betterproto.string_field(4)
    # 由于 ios 2.5.0 配错字段,所以做个兼容
    comic_id: int = betterproto.int32_field(5)


@dataclass
class GetInterestingStylesResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetInterestingStyles" = betterproto.message_field(3)


@dataclass
class GetInterestingStyles(betterproto.Message):
    styles: List["InterestTag"] = betterproto.message_field(1)


@dataclass
class ReportUserInterestingReq(betterproto.Message):
    # 传逗号分割的字符串即可 '1,2,3' 服务端框架会自动解析为数组
    style_ids: List[int] = betterproto.int32_field(1)


@dataclass
class HomeRecommendResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "HomeRecommendData" = betterproto.message_field(3)


@dataclass
class HomeRecommendData(betterproto.Message):
    seed: int = betterproto.int64_field(1)
    ab_test: bool = betterproto.bool_field(2)
    list: List["RecommendInfo"] = betterproto.message_field(3)
    ab_read_history: bool = betterproto.bool_field(4)
    # 首页新人 tab abTest 命中新人 tab 不展示新人卡
    tab_ab_test: bool = betterproto.bool_field(5)


@dataclass
class CommentInfo(betterproto.Message):
    # 评论 id
    id: int = betterproto.int64_field(1)
    # 评论内容
    content: str = betterproto.string_field(2)


@dataclass
class RecommendInfo(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 子标题（最新话short_title）
    sub_title: str = betterproto.string_field(3)
    # 图片
    img: str = betterproto.string_field(4)
    # 跳转内容
    jump_value: str = betterproto.string_field(5)
    # 风格
    styles: List["StyleInfo"] = betterproto.message_field(6)
    # 评论总数
    comment_total: int = betterproto.int32_field(7)
    # 百科竖版封面，给 pc 展示使用
    vertical_cover: str = betterproto.string_field(8)
    # 推荐算法透传字段
    ext: str = betterproto.string_field(9)
    # 推荐卡片类型，1.原HomePage接口的运营内容，2.原HomeStock接口的库存内容
    recommend_type: int = betterproto.int32_field(10)
    # card id 或者 专栏卡 id
    id: int = betterproto.int32_field(11)
    # 卡片类型 1-漫画大卡 2-推广卡 3-聚合卡 4-专栏卡 5-番推漫 7-书聚合卡
    type: int = betterproto.int32_field(12)
    # 跳转类型 1-漫画详情 2-漫画单话
    jump_type: int = betterproto.int32_field(13)
    # 角标
    icon: int = betterproto.int32_field(14)
    # 百科简介
    introduction: str = betterproto.string_field(15)
    # 推荐算法标签
    labels: List["LabelInfo"] = betterproto.message_field(16)
    # 推荐算法 tag "xx万人在追"
    description: str = betterproto.string_field(17)
    # 是否支持等免
    allow_wait_free: bool = betterproto.bool_field(18)
    # 当类型是专栏时，详细信息看此处
    column: "ColumnCard" = betterproto.message_field(19)
    # 当类型是聚合卡时，详细信息看此处
    combine: "CombineCard" = betterproto.message_field(20)
    # 番推漫
    anime: "AnimeCardInfo" = betterproto.message_field(21)
    # 热评
    comments: List["CommentInfo"] = betterproto.message_field(22)
    # 当一个漫画存在多个专栏时，聚合专栏
    columns: List["ColumnCard"] = betterproto.message_field(23)
    # 折扣类型 1、有任意折扣 2、限免 3、指定章节限免
    discount_type: int = betterproto.int32_field(24)
    # 最新话标题
    last_ep_title: str = betterproto.string_field(25)
    # 首页请求页数
    page_num: int = betterproto.int32_field(26)
    # 漫画点评分数
    review_score: float = betterproto.double_field(27)
    # pv信息
    pv_info: "PvInfo" = betterproto.message_field(28)


@dataclass
class PvInfo(betterproto.Message):
    aid: int = betterproto.int64_field(1)
    cid: int = betterproto.int64_field(2)
    # 精彩片段偏移量秒数
    pv_start_at: int = betterproto.int32_field(3)


@dataclass
class CombineCard(betterproto.Message):
    # 期刊 id
    id: int = betterproto.int32_field(1)
    cover: str = betterproto.string_field(2)
    title: str = betterproto.string_field(3)
    # 颜色
    color: str = betterproto.string_field(4)
    # 期数
    num: int = betterproto.int32_field(5)
    # 更新时间 2006-01-02
    update_time: str = betterproto.string_field(6)
    # 合集 id（周刊）
    father_id: int = betterproto.int32_field(7)


@dataclass
class ColumnCard(betterproto.Message):
    # 后台配置的专栏 id
    id: int = betterproto.int32_field(1)
    title: str = betterproto.string_field(2)
    comic_id: int = betterproto.int32_field(3)
    comic_title: str = betterproto.string_field(4)
    author: List[str] = betterproto.string_field(5)
    comic_cover: str = betterproto.string_field(6)
    cover: str = betterproto.string_field(7)
    weight: float = betterproto.float_field(8)
    # 专栏 mc 号
    column_id: int = betterproto.int64_field(9)


@dataclass
class AnimeCardInfo(betterproto.Message):
    # 卡片 ID
    id: int = betterproto.int32_field(1)
    # 推荐语
    title: str = betterproto.string_field(2)
    # 总数
    total: int = betterproto.int32_field(3)
    comic: List["JumpCardInfo"] = betterproto.message_field(4)


@dataclass
class LabelInfo(betterproto.Message):
    id: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)


@dataclass
class HomeStockResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "HomeStockData" = betterproto.message_field(3)


@dataclass
class HomeStockData(betterproto.Message):
    seed: int = betterproto.int64_field(1)
    list: List["StockInfo"] = betterproto.message_field(2)


@dataclass
class StockInfo(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 子标题（最新话short_title）
    sub_title: str = betterproto.string_field(3)
    # 图片
    img: str = betterproto.string_field(4)
    # 跳转内容
    jump_value: str = betterproto.string_field(5)
    # 风格
    styles: List["StyleInfo"] = betterproto.message_field(6)
    # 评论总数
    comment_total: int = betterproto.int32_field(7)
    # 百科竖版封面，给 pc 展示使用
    vertical_cover: str = betterproto.string_field(8)
    # 推荐算法透传字段
    ext: str = betterproto.string_field(9)


@dataclass
class HomeFansResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "FansInfo" = betterproto.message_field(3)


@dataclass
class FansInfo(betterproto.Message):
    # 下次更新时间(2006-01-02 15:04:05)(仅主榜单为当前周榜单时该字段为有效数据)
    next_time: str = betterproto.string_field(1)
    # 当前时间(2006-01-02 15:04:05)(仅主榜单为当前周榜单时该字段为有效数据)
    current_time: str = betterproto.string_field(2)
    # 应援榜该周的漫画排行(主榜单) 月票榜该月的漫画排行榜(主榜单)
    comics: List["FansComic"] = betterproto.message_field(3)
    # 上周的漫画排行(副榜单)
    last_week_comics: List["FansComic"] = betterproto.message_field(4)
    # 月票榜往期榜单，按时间顺序倒排，当前 10 月，则数组第一个值为上个月9月
    last_month_rank: List["FansComic"] = betterproto.message_field(5)


@dataclass
class FansComic(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 作者
    author: List[str] = betterproto.string_field(3)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(4)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(5)
    # 最新话序号
    last_ord: float = betterproto.float_field(6)
    # 最新话短标题 如果是字符串类型的数字，对应更新至xx话 如果是字符串，如 "预告"，则对应更新至预告
    last_short_title: str = betterproto.string_field(7)
    # 风格标签
    styles: List["StyleInfo"] = betterproto.message_field(8)
    # 总话数（全x话）
    total: int = betterproto.int32_field(9)
    # 粉丝值 月票数
    fans: int = betterproto.int64_field(10)
    # 打赏上榜的用户 月票上榜的用户
    reward_users: List["RewardUser"] = betterproto.message_field(11)
    # 上周排名
    last_rank: int = betterproto.int32_field(12)
    # 最近更新单话 id
    last_ep: int = betterproto.int32_field(13)
    # 人气值/月票文案
    text: str = betterproto.string_field(14)


@dataclass
class RewardUser(betterproto.Message):
    # 粉丝值 月票数
    fans: int = betterproto.int64_field(1)
    # 头像
    avatar: str = betterproto.string_field(2)
    # 昵称
    name: str = betterproto.string_field(3)
    # 用户UID
    uid: int = betterproto.int64_field(4)


@dataclass
class HomeHotReq(betterproto.Message):
    # 榜单类型，0、人气榜；1、免费榜 2、飙升榜 3、日漫榜 4、国漫榜 5、新作榜 6、韩漫榜 7、新版国漫榜 8、宝藏榜
    type: int = betterproto.int32_field(1)


@dataclass
class HomeHotResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["HotInfo"] = betterproto.message_field(3)


@dataclass
class HotInfo(betterproto.Message):
    # 漫画 ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 作者
    author: List[str] = betterproto.string_field(3)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(4)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(5)
    # 最新话序号
    last_ord: float = betterproto.float_field(6)
    # 最新话短标题 如果是字符串类型的数字，对应更新至xx话 如果是字符串，如 "预告"，则对应更新至预告
    last_short_title: str = betterproto.string_field(7)
    # 风格标签，长度可能不足 2，业务根据需求自己判断
    styles: List["StyleInfo"] = betterproto.message_field(8)
    # 总话数（全 x 话）
    total: int = betterproto.int32_field(9)
    # 昨天排名 0 表示没有昨天的排名数据，客户端不要展示升降标志
    last_rank: int = betterproto.int32_field(10)
    # 最近更新单话 id
    last_ep: int = betterproto.int32_field(11)


@dataclass
class HomeNewReq(betterproto.Message):
    page_num: int = betterproto.int32_field(1)


@dataclass
class HomeNewResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["NewInfo"] = betterproto.message_field(3)


@dataclass
class NewInfo(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(3)
    # 风格标签
    styles: List["StyleInfo"] = betterproto.message_field(4)


@dataclass
class NewOrderReq(betterproto.Message):
    pass


@dataclass
class NewOrderResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["NewOrderInfo"] = betterproto.message_field(3)


@dataclass
class NewOrderInfo(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(3)
    # 上线日期 online_type=1时使用
    online_time: str = betterproto.string_field(4)
    # 是否预约
    is_order: int = betterproto.int32_field(5)
    # 上线时间 0-待定 1-日期
    online_type: int = betterproto.int32_field(6)


@dataclass
class AnimeRecommendResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 推漫列表
    data: List["AnimeRecommend"] = betterproto.message_field(3)


@dataclass
class AnimeRecommend(betterproto.Message):
    # 漫画ID
    comic_id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(3)
    # 是否是番推荐
    is_anime_recommend: bool = betterproto.bool_field(4)


@dataclass
class DownloadReq(betterproto.Message):
    # 来源 0-漫画首页 1-天马弹窗
    ref: int = betterproto.int32_field(1)
    # 渠道标识
    alias: str = betterproto.string_field(2)


@dataclass
class GetConfReq(betterproto.Message):
    # 配置名
    key: str = betterproto.string_field(1)


@dataclass
class GetConfResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    value: str = betterproto.string_field(3)


@dataclass
class LikeEpisodeReq(betterproto.Message):
    # 章节 ID
    ep_id: int = betterproto.int32_field(1)
    # 操作 1 点赞 2 取消点赞 3 踩 4 取消踩
    action: int = betterproto.int32_field(2)
    # 0-章节点赞 1-点评点赞
    type: int = betterproto.int32_field(3)
    # 点评 id
    review_id: int = betterproto.int64_field(4)


@dataclass
class EpisodeLikeStateReq(betterproto.Message):
    # 章节 ID
    ep_id: int = betterproto.int32_field(1)


@dataclass
class EpisodeLikeStateResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EpisodeLikeState" = betterproto.message_field(3)


@dataclass
class EpisodeLikeState(betterproto.Message):
    # 点赞总数
    likes: int = betterproto.int32_field(1)
    # 是否点赞
    is_like: bool = betterproto.bool_field(2)


@dataclass
class GetDiscountListReq(betterproto.Message):
    # 漫画 ID
    comic_id: int = betterproto.int32_field(1)


@dataclass
class GetDiscountListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DiscountListInfo" = betterproto.message_field(3)


@dataclass
class DiscountListInfo(betterproto.Message):
    discount_cards: List["DiscountInfo"] = betterproto.message_field(3)


@dataclass
class DiscountInfo(betterproto.Message):
    # id
    id: int = betterproto.int32_field(1)
    # 折扣
    discount: int = betterproto.int32_field(2)
    # 折扣上限
    discount_limit: int = betterproto.int32_field(3)
    # 活动描述
    reason_desc: str = betterproto.string_field(4)
    # 过期时间 形如 "2006-01-02"
    expire_time: str = betterproto.string_field(5)
    # 全场打折卡：6 、限定打折卡：4
    type: int = betterproto.int32_field(6)
    # 可用数量
    amount: int = betterproto.int32_field(7)


@dataclass
class CalDiscountPriceReq(betterproto.Message):
    # 原值
    original_values: List[int] = betterproto.int32_field(1)
    # 打折卡 id
    id: int = betterproto.int32_field(2)


@dataclass
class CalDiscountPriceResp(betterproto.Message):
    # 1: 无效打折卡 ID
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # key: 原价, value: 折扣价
    data: Dict[int, int] = betterproto.map_field(
        3, betterproto.TYPE_INT32, betterproto.TYPE_INT32
    )


@dataclass
class GetComicReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class GetComicResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicInfo" = betterproto.message_field(3)


@dataclass
class ComicInfo(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画名
    title: str = betterproto.string_field(2)
    # 漫画类型 0:条漫 1:页漫
    comic_type: int = betterproto.int32_field(3)
    # 默认翻页方式, 1:竖屏滚动 2:竖屏翻页 4:日漫 8:横屏
    page_default: int = betterproto.int32_field(4)
    # 允许翻页方式 1:竖屏滚动 2:竖屏翻页 4:日漫，8:横屏
    page_allow: List[int] = betterproto.int32_field(5)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(6)
    # 方版封面
    square_cover: str = betterproto.string_field(7)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(8)
    # 作者名
    authors: List["Author"] = betterproto.message_field(9)
    # 最新话序号（更新至x话）
    last_ord: float = betterproto.float_field(10)
    # 是否完结 1:是 0:否 -1:未开刊
    is_finish: int = betterproto.int32_field(11)
    # 上线状态, -1:下线 0:正常
    status: int = betterproto.int32_field(12)
    # 简介
    evaluate: str = betterproto.string_field(13)
    # 总话数（全x话）
    total: int = betterproto.int32_field(14)
    # 发布时间
    release_time: str = betterproto.string_field(15)
    # 是否允许下载 1:允许 0:禁止
    is_download: int = betterproto.int32_field(16)
    # 最近观看短标题
    read_short_title: str = betterproto.string_field(17)
    # 风格标签
    styles: List["StyleInfo"] = betterproto.message_field(18)
    # 更新频率
    renewal_time: str = betterproto.string_field(19)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(20)
    # 是否禁止优惠卡  0-允许使用 1-禁止使用
    no_discount: bool = betterproto.bool_field(21)
    # 目前管理后台单话展示一定单话付费 0-单话展示 1-按卷展示
    show_type: int = betterproto.int32_field(22)
    # 经典台词
    classic_lines: str = betterproto.string_field(23)
    # 版权方
    producer: str = betterproto.string_field(24)


@dataclass
class Author(betterproto.Message):
    """如果只是返回作者名,不要再调用此 model 了,id 和 name 用不上"""

    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)
    # 中文名
    cname: str = betterproto.string_field(3)


@dataclass
class GetTokenReq(betterproto.Message):
    # 模版ID 弹窗口令为后台配置主键ID h5下载为 -1
    temp_id: int = betterproto.int32_field(1)
    # 跳转地址
    jump_value: str = betterproto.string_field(2)
    # 在裂变活动中需要声明创建人的 uid，因为有可能没有登录态
    uid: int = betterproto.int64_field(3)


@dataclass
class GetTokenResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetTokenData" = betterproto.message_field(3)


@dataclass
class GetTokenData(betterproto.Message):
    # 口令内容
    token: str = betterproto.string_field(1)
    # content 文案, req 中传了模版 ID 会返回，其他情况客户端默认
    content: str = betterproto.string_field(2)


@dataclass
class ParseTokenReq(betterproto.Message):
    # 口令内容
    token: str = betterproto.string_field(1)


@dataclass
class ParseTokenResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ParseTokenData" = betterproto.message_field(3)


@dataclass
class ParseTokenData(betterproto.Message):
    # 操作类型 0 - 直接跳转 1 - 弹窗跳转 2 - 弹窗领取礼包
    type: int = betterproto.int32_field(1)
    # 跳转地址
    jump_value: str = betterproto.string_field(2)
    # 弹窗图片
    image_url: str = betterproto.string_field(3)
    # 模版ID
    temp_id: int = betterproto.int32_field(4)
    # h5buvid
    h5_buvid: str = betterproto.string_field(5)
    # 关联用户的 UID 注意一般情况下是不需要该字段的，但是有些活动比如裂变需要知道口令创建人的 uid
    uid: int = betterproto.int64_field(6)


@dataclass
class GetWidgetsComicResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetWidgetsComicData" = betterproto.message_field(3)


@dataclass
class GetWidgetsComicData(betterproto.Message):
    # 漫画列表
    comics: List["GetWidgetsComic"] = betterproto.message_field(1)
    # 是否新用户
    is_new: bool = betterproto.bool_field(2)


@dataclass
class GetWidgetsComic(betterproto.Message):
    # 漫画id
    id: int = betterproto.int32_field(1)
    # 漫画名
    title: str = betterproto.string_field(2)
    # 横版封面
    horizontal_cover: str = betterproto.string_field(3)
    # 方版封面
    square_cover: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 漫画第一个分类标签
    style: str = betterproto.string_field(6)
    # 漫画简介
    desc: str = betterproto.string_field(7)
    # 最新章节标题
    ep_latest_short_title: str = betterproto.string_field(8)
    # 上次阅读话标题
    ep_read_short_title: str = betterproto.string_field(9)
    # 点评总分
    score: float = betterproto.double_field(10)
    # 上次阅读话 id
    ep_read_id: int = betterproto.int32_field(11)


@dataclass
class GetWidgetsCalendarResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "GetWidgetsCalendarData" = betterproto.message_field(3)


@dataclass
class GetWidgetsCalendarData(betterproto.Message):
    # 漫画 id
    comic_id: int = betterproto.int32_field(1)
    # 单话 id
    episode_id: int = betterproto.int32_field(2)
    # 漫画名
    comic_title: str = betterproto.string_field(3)
    # 推荐语
    suggestion: str = betterproto.string_field(4)
    # 推荐图
    pic: str = betterproto.string_field(5)
    # 点评分
    score: float = betterproto.double_field(6)


class ComicStub(betterproto.ServiceStub):
    """漫画核心服务"""

    @allure.step("""分类页标签""")
    def all_label(self, request: EmptyRequest) -> AllLabelResp:
        """分类页标签"""
        logging.getLogger(__name__).info(
            "start call " + "[all_label]" + " api" + "=>" + """分类页标签"""
        )
        response = AllLabelResp()
        self._do_twirp_rpc("/comic.v1.Comic/AllLabel", request, response)
        logging.getLogger(__name__).info("call " + "[all_label]" + " api success!")
        return response

    @allure.step("""分类页列表""")
    def class_page(self, request: ClassPageReq) -> ClassPageResp:
        """分类页列表"""
        logging.getLogger(__name__).info(
            "start call " + "[class_page]" + " api" + "=>" + """分类页列表"""
        )
        response = ClassPageResp()
        self._do_twirp_rpc("/comic.v1.Comic/ClassPage", request, response)
        logging.getLogger(__name__).info("call " + "[class_page]" + " api success!")
        return response

    @allure.step("""v2 获取运营分类页标签""")
    def get_class_page_all_tabs(self, request: GetClassPageAllTabsReq) -> GetTabsResp:
        """v2 获取运营分类页标签"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_all_tabs]"
            + " api"
            + "=>"
            + """v2 获取运营分类页标签"""
        )
        response = GetTabsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageAllTabs", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_all_tabs]" + " api success!"
        )
        return response

    @allure.step("""v2 获取运营分类页布局""")
    def get_class_page_layout(
        self, request: GetClassPageLayoutReq
    ) -> GetClassPageLayoutResp:
        """v2 获取运营分类页布局"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_layout]"
            + " api"
            + "=>"
            + """v2 获取运营分类页布局"""
        )
        response = GetClassPageLayoutResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageLayout", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_layout]" + " api success!"
        )
        return response

    @allure.step("""v2 展示分类页横版四图""")
    def get_class_page_four_comics(
        self, request: GetClassPageReq
    ) -> GetClassPageFourComicsResp:
        """v2 展示分类页横版四图"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_four_comics]"
            + " api"
            + "=>"
            + """v2 展示分类页横版四图"""
        )
        response = GetClassPageFourComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageFourComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_four_comics]" + " api success!"
        )
        return response

    @allure.step("""v2 展示分类页竖版六图""")
    def get_class_page_six_comics(
        self, request: GetClassPageSixComicsReq
    ) -> GetClassPageSixComicsResp:
        """v2 展示分类页竖版六图"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_six_comics]"
            + " api"
            + "=>"
            + """v2 展示分类页竖版六图"""
        )
        response = GetClassPageSixComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageSixComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_six_comics]" + " api success!"
        )
        return response

    @allure.step("""v2 展示分类页自动竖版六图""")
    def get_auto_six_comics(self, request: GetAutoSixComicsReq) -> GetAutoSixComicsResp:
        """v2 展示分类页自动竖版六图"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_auto_six_comics]"
            + " api"
            + "=>"
            + """v2 展示分类页自动竖版六图"""
        )
        response = GetAutoSixComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetAutoSixComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_auto_six_comics]" + " api success!"
        )
        return response

    @allure.step("""v2 展示分类页顶部 banner""")
    def get_class_page_home_banner(
        self, request: GetClassPageReq
    ) -> GetClassPageHomeBannerResp:
        """v2 展示分类页顶部 banner"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_home_banner]"
            + " api"
            + "=>"
            + """v2 展示分类页顶部 banner"""
        )
        response = GetClassPageHomeBannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageHomeBanner", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_home_banner]" + " api success!"
        )
        return response

    @allure.step("""v2 推广大卡/专栏模块""")
    def get_class_page_recommend_banner(
        self, request: GetClassPageReq
    ) -> GetClassPageRecommendBannerResp:
        """v2 推广大卡/专栏模块"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_recommend_banner]"
            + " api"
            + "=>"
            + """v2 推广大卡/专栏模块"""
        )
        response = GetClassPageRecommendBannerResp()
        self._do_twirp_rpc(
            "/comic.v1.Comic/GetClassPageRecommendBanner", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_recommend_banner]" + " api success!"
        )
        return response

    @allure.step("""获取单话合页设定""")
    def get_fusion_page_settings(
        self, request: GetFusionPageSettingsReq
    ) -> GetFusionPageSettingsResp:
        """获取单话合页设定"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_fusion_page_settings]"
            + " api"
            + "=>"
            + """获取单话合页设定"""
        )
        response = GetFusionPageSettingsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetFusionPageSettings", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_fusion_page_settings]" + " api success!"
        )
        return response

    @allure.step("""追漫有礼模块""")
    def get_class_page_favorite_reward(
        self, request: GetClassPageReq
    ) -> GetClassPageFavoriteRewardResp:
        """追漫有礼模块"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_favorite_reward]"
            + " api"
            + "=>"
            + """追漫有礼模块"""
        )
        response = GetClassPageFavoriteRewardResp()
        self._do_twirp_rpc(
            "/comic.v1.Comic/GetClassPageFavoriteReward", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_favorite_reward]" + " api success!"
        )
        return response

    @allure.step("""新作预约模块""")
    def get_new_comics(self, request: GetClassPageReq) -> GetNewComicsResp:
        """新作预约模块"""
        logging.getLogger(__name__).info(
            "start call " + "[get_new_comics]" + " api" + "=>" + """新作预约模块"""
        )
        response = GetNewComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetNewComics", request, response)
        logging.getLogger(__name__).info("call " + "[get_new_comics]" + " api success!")
        return response

    @allure.step("""发现页热门排行榜""")
    def get_class_page_comics_rank(
        self, request: GetClassPageReq
    ) -> GetClassPageComicsRankResp:
        """发现页热门排行榜"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_comics_rank]"
            + " api"
            + "=>"
            + """发现页热门排行榜"""
        )
        response = GetClassPageComicsRankResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageComicsRank", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_comics_rank]" + " api success!"
        )
        return response

    @allure.step("""发现页高能单话""")
    def get_class_page_high_energy_ep(
        self, request: GetClassPageReq
    ) -> GetClassPageHighEnergyEpResp:
        """发现页高能单话"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_high_energy_ep]"
            + " api"
            + "=>"
            + """发现页高能单话"""
        )
        response = GetClassPageHighEnergyEpResp()
        self._do_twirp_rpc(
            "/comic.v1.Comic/GetClassPageHighEnergyEp", request, response
        )
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_high_energy_ep]" + " api success!"
        )
        return response

    @allure.step("""首页新人竖版三图""")
    def get_class_page_three_comics(
        self, request: GetClassPageReq
    ) -> GetClassPageThreeComicsResp:
        """首页新人竖版三图"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_class_page_three_comics]"
            + " api"
            + "=>"
            + """首页新人竖版三图"""
        )
        response = GetClassPageThreeComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageThreeComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_three_comics]" + " api success!"
        )
        return response

    @allure.step("""首页新人更多推荐""")
    def get_rookie_comics(self, request: GetRookieComicsReq) -> GetRookieComicsResp:
        """首页新人更多推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[get_rookie_comics]" + " api" + "=>" + """首页新人更多推荐"""
        )
        response = GetRookieComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRookieComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_rookie_comics]" + " api success!"
        )
        return response

    @allure.step("""发现页结构主题合集模块""")
    def get_same_theme_comics(self, request: GetClassPageReq) -> GetSameThemeComicsResp:
        """发现页结构主题合集模块"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_same_theme_comics]"
            + " api"
            + "=>"
            + """发现页结构主题合集模块"""
        )
        response = GetSameThemeComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetSameThemeComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_same_theme_comics]" + " api success!"
        )
        return response

    @allure.step("""获取气泡""")
    def get_bubble(self, request: GetBubbleReq) -> GetBubbleResp:
        """获取气泡"""
        logging.getLogger(__name__).info(
            "start call " + "[get_bubble]" + " api" + "=>" + """获取气泡"""
        )
        response = GetBubbleResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetBubble", request, response)
        logging.getLogger(__name__).info("call " + "[get_bubble]" + " api success!")
        return response

    @allure.step("""获取气泡列表""")
    def get_bubbles(self, request: GetBubbleReq) -> GetBubblesResp:
        """获取气泡列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_bubbles]" + " api" + "=>" + """获取气泡列表"""
        )
        response = GetBubblesResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetBubbles", request, response)
        logging.getLogger(__name__).info("call " + "[get_bubbles]" + " api success!")
        return response

    @allure.step("""漫画详情""")
    def comic_detail(self, request: ComicDetailReq) -> ComicDetailResp:
        """漫画详情"""
        logging.getLogger(__name__).info(
            "start call " + "[comic_detail]" + " api" + "=>" + """漫画详情"""
        )
        response = ComicDetailResp()
        self._do_twirp_rpc("/comic.v1.Comic/ComicDetail", request, response)
        logging.getLogger(__name__).info("call " + "[comic_detail]" + " api success!")
        return response

    @allure.step("""百科详情""")
    def get_wiki_detail(self, request: GetWikiDetailReq) -> GetWikiDetailResp:
        """百科详情"""
        logging.getLogger(__name__).info(
            "start call " + "[get_wiki_detail]" + " api" + "=>" + """百科详情"""
        )
        response = GetWikiDetailResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetWikiDetail", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_wiki_detail]" + " api success!"
        )
        return response

    @allure.step("""推荐""")
    def recommend(self, request: RecommendReq) -> RecommendResp:
        """推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[recommend]" + " api" + "=>" + """推荐"""
        )
        response = RecommendResp()
        self._do_twirp_rpc("/comic.v1.Comic/Recommend", request, response)
        logging.getLogger(__name__).info("call " + "[recommend]" + " api success!")
        return response

    @allure.step("""更多推荐""")
    def more_recommend(self, request: MoreRecommendReq) -> MoreRecommendResp:
        """更多推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[more_recommend]" + " api" + "=>" + """更多推荐"""
        )
        response = MoreRecommendResp()
        self._do_twirp_rpc("/comic.v1.Comic/MoreRecommend", request, response)
        logging.getLogger(__name__).info("call " + "[more_recommend]" + " api success!")
        return response

    @allure.step("""Index""")
    def index(self, request: IndexReq) -> IndexResp:
        """Index"""
        logging.getLogger(__name__).info(
            "start call " + "[index]" + " api" + "=>" + """Index"""
        )
        response = IndexResp()
        self._do_twirp_rpc("/comic.v1.Comic/Index", request, response)
        logging.getLogger(__name__).info("call " + "[index]" + " api success!")
        return response

    @allure.step("""获取图片信息列表""")
    def get_image_index(self, request: IndexReq) -> ImageIndexResp:
        """获取图片信息列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_image_index]" + " api" + "=>" + """获取图片信息列表"""
        )
        response = ImageIndexResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetImageIndex", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_image_index]" + " api success!"
        )
        return response

    @allure.step("""BfsToken""")
    def image_token(self, request: ImageTokenReq) -> ImageTokenResp:
        """BfsToken"""
        logging.getLogger(__name__).info(
            "start call " + "[image_token]" + " api" + "=>" + """BfsToken"""
        )
        response = ImageTokenResp()
        self._do_twirp_rpc("/comic.v1.Comic/ImageToken", request, response)
        logging.getLogger(__name__).info("call " + "[image_token]" + " api success!")
        return response

    @allure.step("""搜索""")
    def search(self, request: ClassPageReq) -> SearchResp:
        """搜索"""
        logging.getLogger(__name__).info(
            "start call " + "[search]" + " api" + "=>" + """搜索"""
        )
        response = SearchResp()
        self._do_twirp_rpc("/comic.v1.Comic/Search", request, response)
        logging.getLogger(__name__).info("call " + "[search]" + " api success!")
        return response

    @allure.step("""搜索联想词""")
    def search_sug(self, request: SearchSugReq) -> SearchSugResp:
        """搜索联想词"""
        logging.getLogger(__name__).info(
            "start call " + "[search_sug]" + " api" + "=>" + """搜索联想词"""
        )
        response = SearchSugResp()
        self._do_twirp_rpc("/comic.v1.Comic/SearchSug", request, response)
        logging.getLogger(__name__).info("call " + "[search_sug]" + " api success!")
        return response

    @allure.step("""返回购买信息""")
    def get_episode_buy_info(self, request: EpBuyInfoReq) -> EpBuyInfoResp:
        """返回购买信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_episode_buy_info]" + " api" + "=>" + """返回购买信息"""
        )
        response = EpBuyInfoResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetEpisodeBuyInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_episode_buy_info]" + " api success!"
        )
        return response

    @allure.step("""返回卷购买信息""")
    def get_chapter_buy_info(
        self, request: GetChapterBuyInfoReq
    ) -> GetChapterBuyInfoResp:
        """返回卷购买信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_chapter_buy_info]" + " api" + "=>" + """返回卷购买信息"""
        )
        response = GetChapterBuyInfoResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetChapterBuyInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_chapter_buy_info]" + " api success!"
        )
        return response

    @allure.step("""返回打赏项目""")
    def get_reward_items(self, request: GetRewardItemsReq) -> RewardItemsResp:
        """返回打赏项目"""
        logging.getLogger(__name__).info(
            "start call " + "[get_reward_items]" + " api" + "=>" + """返回打赏项目"""
        )
        response = RewardItemsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRewardItems", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_reward_items]" + " api success!"
        )
        return response

    @allure.step("""获取漫画打赏详情""")
    def get_reward_info(self, request: GetRewardInfoReq) -> GetRewardInfoResp:
        """获取漫画打赏详情"""
        logging.getLogger(__name__).info(
            "start call " + "[get_reward_info]" + " api" + "=>" + """获取漫画打赏详情"""
        )
        response = GetRewardInfoResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRewardInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_reward_info]" + " api success!"
        )
        return response

    @allure.step("""获取漫画用户打赏排行""")
    def get_reward_rank(self, request: GetRewardRankReq) -> GetRewardRankResp:
        """获取漫画用户打赏排行"""
        logging.getLogger(__name__).info(
            "start call " + "[get_reward_rank]" + " api" + "=>" + """获取漫画用户打赏排行"""
        )
        response = GetRewardRankResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRewardRank", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_reward_rank]" + " api success!"
        )
        return response

    @allure.step("""获取详情页应援月票榜入口展示数据""")
    def get_entrance_for_rank(
        self, request: GetEntranceForRankReq
    ) -> GetEntranceForRankResp:
        """获取详情页应援月票榜入口展示数据"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_entrance_for_rank]"
            + " api"
            + "=>"
            + """获取详情页应援月票榜入口展示数据"""
        )
        response = GetEntranceForRankResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetEntranceForRank", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_entrance_for_rank]" + " api success!"
        )
        return response

    @allure.step("""打赏漫画 code: 1.该漫画禁止被打赏, 2.漫币余额不足, 3.月票余额不足 4.漫画不存在或者未上线 5.该漫画禁止月票""")
    def reward_comic(self, request: RewardComicReq) -> RewardComicResp:
        """打赏漫画 code: 1.该漫画禁止被打赏, 2.漫币余额不足, 3.月票余额不足 4.漫画不存在或者未上线 5.该漫画禁止月票"""
        logging.getLogger(__name__).info(
            "start call "
            + "[reward_comic]"
            + " api"
            + "=>"
            + """打赏漫画 code: 1.该漫画禁止被打赏, 2.漫币余额不足, 3.月票余额不足 4.漫画不存在或者未上线 5.该漫画禁止月票"""
        )
        response = RewardComicResp()
        self._do_twirp_rpc("/comic.v1.Comic/RewardComic", request, response)
        logging.getLogger(__name__).info("call " + "[reward_comic]" + " api success!")
        return response

    @allure.step("""购买Episode""")
    def buy_episode(self, request: BuyEpReq) -> BuyEpResp:
        """购买Episode"""
        logging.getLogger(__name__).info(
            "start call " + "[buy_episode]" + " api" + "=>" + """购买Episode"""
        )
        response = BuyEpResp()
        self._do_twirp_rpc("/comic.v1.Comic/BuyEpisode", request, response)
        logging.getLogger(__name__).info("call " + "[buy_episode]" + " api success!")
        return response

    @allure.step("""购买 chapter""")
    def buy_chapter(self, request: BuyChapterReq) -> BuyChapterResp:
        """购买 chapter"""
        logging.getLogger(__name__).info(
            "start call " + "[buy_chapter]" + " api" + "=>" + """购买 chapter"""
        )
        response = BuyChapterResp()
        self._do_twirp_rpc("/comic.v1.Comic/BuyChapter", request, response)
        logging.getLogger(__name__).info("call " + "[buy_chapter]" + " api success!")
        return response

    @allure.step("""租借单话""")
    def rent_episode(self, request: RentEpReq) -> RentEpResp:
        """租借单话"""
        logging.getLogger(__name__).info(
            "start call " + "[rent_episode]" + " api" + "=>" + """租借单话"""
        )
        response = RentEpResp()
        self._do_twirp_rpc("/comic.v1.Comic/RentEpisode", request, response)
        logging.getLogger(__name__).info("call " + "[rent_episode]" + " api success!")
        return response

    @allure.step("""首页-人工""")
    def home_page(self, request: HomePageReq) -> HomePageResp:
        """首页-人工"""
        logging.getLogger(__name__).info(
            "start call " + "[home_page]" + " api" + "=>" + """首页-人工"""
        )
        response = HomePageResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomePage", request, response)
        logging.getLogger(__name__).info("call " + "[home_page]" + " api success!")
        return response

    @allure.step("""Banner""")
    def banner(self, request: BannerReq) -> BannerResp:
        """Banner"""
        logging.getLogger(__name__).info(
            "start call " + "[banner]" + " api" + "=>" + """Banner"""
        )
        response = BannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/Banner", request, response)
        logging.getLogger(__name__).info("call " + "[banner]" + " api success!")
        return response

    @allure.step("""RewardBanner 打赏banner""")
    def reward_banner(self, request: RewardBannerReq) -> RewardBannerResp:
        """RewardBanner 打赏banner"""
        logging.getLogger(__name__).info(
            "start call "
            + "[reward_banner]"
            + " api"
            + "=>"
            + """RewardBanner 打赏banner"""
        )
        response = RewardBannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/RewardBanner", request, response)
        logging.getLogger(__name__).info("call " + "[reward_banner]" + " api success!")
        return response

    @allure.step("""评论区 banner""")
    def comment_banner(self, request: CommentBannerReq) -> CommentBannerResp:
        """评论区 banner"""
        logging.getLogger(__name__).info(
            "start call " + "[comment_banner]" + " api" + "=>" + """评论区 banner"""
        )
        response = CommentBannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/CommentBanner", request, response)
        logging.getLogger(__name__).info("call " + "[comment_banner]" + " api success!")
        return response

    @allure.step("""搜索页 banner""")
    def search_banner(self, request: EmptyRequest) -> SearchBannerResp:
        """搜索页 banner"""
        logging.getLogger(__name__).info(
            "start call " + "[search_banner]" + " api" + "=>" + """搜索页 banner"""
        )
        response = SearchBannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/SearchBanner", request, response)
        logging.getLogger(__name__).info("call " + "[search_banner]" + " api success!")
        return response

    @allure.step("""闪屏""")
    def flash(self, request: FlashReq) -> FlashResp:
        """闪屏"""
        logging.getLogger(__name__).info(
            "start call " + "[flash]" + " api" + "=>" + """闪屏"""
        )
        response = FlashResp()
        self._do_twirp_rpc("/comic.v1.Comic/Flash", request, response)
        logging.getLogger(__name__).info("call " + "[flash]" + " api success!")
        return response

    @allure.step("""视频及多轮闪屏""")
    def list_flash(self, request: EmptyRequest) -> ListFlashResp:
        """视频及多轮闪屏"""
        logging.getLogger(__name__).info(
            "start call " + "[list_flash]" + " api" + "=>" + """视频及多轮闪屏"""
        )
        response = ListFlashResp()
        self._do_twirp_rpc("/comic.v1.Comic/ListFlash", request, response)
        logging.getLogger(__name__).info("call " + "[list_flash]" + " api success!")
        return response

    @allure.step("""APP初始化""")
    def app_init(self, request: AppInitReq) -> AppInitResp:
        """APP初始化"""
        logging.getLogger(__name__).info(
            "start call " + "[app_init]" + " api" + "=>" + """APP初始化"""
        )
        response = AppInitResp()
        self._do_twirp_rpc("/comic.v1.Comic/AppInit", request, response)
        logging.getLogger(__name__).info("call " + "[app_init]" + " api success!")
        return response

    @allure.step("""返回网络状况检测的相关信息""")
    def check_network(self, request: EmptyRequest) -> CheckNetworkResp:
        """返回网络状况检测的相关信息"""
        logging.getLogger(__name__).info(
            "start call " + "[check_network]" + " api" + "=>" + """返回网络状况检测的相关信息"""
        )
        response = CheckNetworkResp()
        self._do_twirp_rpc("/comic.v1.Comic/CheckNetwork", request, response)
        logging.getLogger(__name__).info("call " + "[check_network]" + " api success!")
        return response

    @allure.step("""话题""")
    def topic(self, request: TopicReq) -> TopicResp:
        """话题"""
        logging.getLogger(__name__).info(
            "start call " + "[topic]" + " api" + "=>" + """话题"""
        )
        response = TopicResp()
        self._do_twirp_rpc("/comic.v1.Comic/Topic", request, response)
        logging.getLogger(__name__).info("call " + "[topic]" + " api success!")
        return response

    @allure.step("""安卓下载地址""")
    def download_url(self, request: DownloadReq) -> DownloadUrlResp:
        """安卓下载地址"""
        logging.getLogger(__name__).info(
            "start call " + "[download_url]" + " api" + "=>" + """安卓下载地址"""
        )
        response = DownloadUrlResp()
        self._do_twirp_rpc("/comic.v1.Comic/DownloadUrl", request, response)
        logging.getLogger(__name__).info("call " + "[download_url]" + " api success!")
        return response

    @allure.step("""更新列表""")
    def schedule_list(self, request: ScheduleListReq) -> ScheduleListResp:
        """更新列表"""
        logging.getLogger(__name__).info(
            "start call " + "[schedule_list]" + " api" + "=>" + """更新列表"""
        )
        response = ScheduleListResp()
        self._do_twirp_rpc("/comic.v1.Comic/ScheduleList", request, response)
        logging.getLogger(__name__).info("call " + "[schedule_list]" + " api success!")
        return response

    @allure.step("""给主站使用，获取人气推荐，分为 A,B 池""")
    def get_recommend_comics(
        self, request: GetRecommendComicsReq
    ) -> GetRecommendComicsResp:
        """给主站使用，获取人气推荐，分为 A,B 池"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_recommend_comics]"
            + " api"
            + "=>"
            + """给主站使用，获取人气推荐，分为 A,B 池"""
        )
        response = GetRecommendComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRecommendComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_recommend_comics]" + " api success!"
        )
        return response

    @allure.step("""首页安卓渠道推荐""")
    def get_channel_recommends(
        self, request: GetChannelRecommendsReq
    ) -> GetChannelRecommendsResp:
        """首页安卓渠道推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[get_channel_recommends]" + " api" + "=>" + """首页安卓渠道推荐"""
        )
        response = GetChannelRecommendsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetChannelRecommends", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_channel_recommends]" + " api success!"
        )
        return response

    @allure.step("""首页-库存""")
    def home_stock(self, request: HomeStockReq) -> HomeStockResp:
        """首页-库存"""
        logging.getLogger(__name__).info(
            "start call " + "[home_stock]" + " api" + "=>" + """首页-库存"""
        )
        response = HomeStockResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomeStock", request, response)
        logging.getLogger(__name__).info("call " + "[home_stock]" + " api success!")
        return response

    @allure.step("""首页-算法推荐""")
    def home_recommend(self, request: HomeStockReq) -> HomeRecommendResp:
        """首页-算法推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[home_recommend]" + " api" + "=>" + """首页-算法推荐"""
        )
        response = HomeRecommendResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomeRecommend", request, response)
        logging.getLogger(__name__).info("call " + "[home_recommend]" + " api success!")
        return response

    @allure.step("""首页-聚合卡二级页面""")
    def to_secondary_page(self, request: ToSecondaryPageReq) -> ToSecondaryPageResp:
        """首页-聚合卡二级页面"""
        logging.getLogger(__name__).info(
            "start call " + "[to_secondary_page]" + " api" + "=>" + """首页-聚合卡二级页面"""
        )
        response = ToSecondaryPageResp()
        self._do_twirp_rpc("/comic.v1.Comic/ToSecondaryPage", request, response)
        logging.getLogger(__name__).info(
            "call " + "[to_secondary_page]" + " api success!"
        )
        return response

    @allure.step("""首页-负反馈""")
    def home_negative_feed_back(
        self, request: HomeNegativeFeedBackReq
    ) -> DefaultResponse:
        """首页-负反馈"""
        logging.getLogger(__name__).info(
            "start call " + "[home_negative_feed_back]" + " api" + "=>" + """首页-负反馈"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/comic.v1.Comic/HomeNegativeFeedBack", request, response)
        logging.getLogger(__name__).info(
            "call " + "[home_negative_feed_back]" + " api success!"
        )
        return response

    @allure.step("""首页-无点击行为上报 获取风格""")
    def get_interesting_styles(self, request: EmptyRequest) -> GetInterestingStylesResp:
        """首页-无点击行为上报 获取风格"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_interesting_styles]"
            + " api"
            + "=>"
            + """首页-无点击行为上报 获取风格"""
        )
        response = GetInterestingStylesResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetInterestingStyles", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_interesting_styles]" + " api success!"
        )
        return response

    @allure.step("""首页用户兴趣选择上报""")
    def report_user_interesting(
        self, request: ReportUserInterestingReq
    ) -> DefaultResponse:
        """首页用户兴趣选择上报"""
        logging.getLogger(__name__).info(
            "start call "
            + "[report_user_interesting]"
            + " api"
            + "=>"
            + """首页用户兴趣选择上报"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/comic.v1.Comic/ReportUserInteresting", request, response)
        logging.getLogger(__name__).info(
            "call " + "[report_user_interesting]" + " api success!"
        )
        return response

    @allure.step("""首页-热度""")
    def home_hot(self, request: HomeHotReq) -> HomeHotResp:
        """首页-热度"""
        logging.getLogger(__name__).info(
            "start call " + "[home_hot]" + " api" + "=>" + """首页-热度"""
        )
        response = HomeHotResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomeHot", request, response)
        logging.getLogger(__name__).info("call " + "[home_hot]" + " api success!")
        return response

    @allure.step("""首页-漫画粉丝值周榜排行,月票月榜""")
    def home_fans(self, request: HomeFansReq) -> HomeFansResp:
        """首页-漫画粉丝值周榜排行,月票月榜"""
        logging.getLogger(__name__).info(
            "start call " + "[home_fans]" + " api" + "=>" + """首页-漫画粉丝值周榜排行,月票月榜"""
        )
        response = HomeFansResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomeFans", request, response)
        logging.getLogger(__name__).info("call " + "[home_fans]" + " api success!")
        return response

    @allure.step("""首页-新作""")
    def home_new(self, request: HomeNewReq) -> HomeNewResp:
        """首页-新作"""
        logging.getLogger(__name__).info(
            "start call " + "[home_new]" + " api" + "=>" + """首页-新作"""
        )
        response = HomeNewResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomeNew", request, response)
        logging.getLogger(__name__).info("call " + "[home_new]" + " api success!")
        return response

    @allure.step("""新作预约""")
    def new_order(self, request: NewOrderReq) -> NewOrderResp:
        """新作预约"""
        logging.getLogger(__name__).info(
            "start call " + "[new_order]" + " api" + "=>" + """新作预约"""
        )
        response = NewOrderResp()
        self._do_twirp_rpc("/comic.v1.Comic/NewOrder", request, response)
        logging.getLogger(__name__).info("call " + "[new_order]" + " api success!")
        return response

    @allure.step("""番推漫列表""")
    def anime_recommend_list(self, request: EmptyRequest) -> AnimeRecommendResp:
        """番推漫列表"""
        logging.getLogger(__name__).info(
            "start call " + "[anime_recommend_list]" + " api" + "=>" + """番推漫列表"""
        )
        response = AnimeRecommendResp()
        self._do_twirp_rpc("/comic.v1.Comic/AnimeRecommendList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[anime_recommend_list]" + " api success!"
        )
        return response

    @allure.step("""查询单话信息""")
    def get_episode(self, request: GetEpisodeReq) -> GetEpisodeResp:
        """查询单话信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_episode]" + " api" + "=>" + """查询单话信息"""
        )
        response = GetEpisodeResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetEpisode", request, response)
        logging.getLogger(__name__).info("call " + "[get_episode]" + " api success!")
        return response

    @allure.step("""获取日更推荐""")
    def get_daily_push(self, request: GetDailyPushReq) -> GetDailyPushResp:
        """获取日更推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[get_daily_push]" + " api" + "=>" + """获取日更推荐"""
        )
        response = GetDailyPushResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetDailyPush", request, response)
        logging.getLogger(__name__).info("call " + "[get_daily_push]" + " api success!")
        return response

    @allure.step("""获取日更推荐阅读历史""")
    def daily_push_history(self, request: DpHistoryReq) -> DpHistoryResp:
        """获取日更推荐阅读历史"""
        logging.getLogger(__name__).info(
            "start call " + "[daily_push_history]" + " api" + "=>" + """获取日更推荐阅读历史"""
        )
        response = DpHistoryResp()
        self._do_twirp_rpc("/comic.v1.Comic/DailyPushHistory", request, response)
        logging.getLogger(__name__).info(
            "call " + "[daily_push_history]" + " api success!"
        )
        return response

    @allure.step("""查询漫画强相关漫画列表""")
    def get_comic_relations(self, request: ComicDetailReq) -> GetComicRelationsResp:
        """查询漫画强相关漫画列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_relations]" + " api" + "=>" + """查询漫画强相关漫画列表"""
        )
        response = GetComicRelationsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetComicRelations", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_relations]" + " api success!"
        )
        return response

    @allure.step("""查看配置取值，内部调试方法 仅线下环境可用""")
    def get_conf(self, request: GetConfReq) -> GetConfResp:
        """查看配置取值，内部调试方法 仅线下环境可用"""
        logging.getLogger(__name__).info(
            "start call " + "[get_conf]" + " api" + "=>" + """查看配置取值，内部调试方法 仅线下环境可用"""
        )
        response = GetConfResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetConf", request, response)
        logging.getLogger(__name__).info("call " + "[get_conf]" + " api success!")
        return response

    @allure.step("""获取单话图片的 id""")
    def get_image_i_d(self, request: GetImageIDReq) -> GetImageIDResp:
        """获取单话图片的 id"""
        logging.getLogger(__name__).info(
            "start call " + "[get_image_i_d]" + " api" + "=>" + """获取单话图片的 id"""
        )
        response = GetImageIDResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetImageID", request, response)
        logging.getLogger(__name__).info("call " + "[get_image_i_d]" + " api success!")
        return response

    @allure.step(
        """
        获取 banner 信息 1-评论区小黄条 5-漫画详情页 banner，v2.14 之前的版本 6-月票榜 banner 7-应援
        banner 13-单话末尾专栏 14-月票动画
        """
    )
    def get_common_banner(self, request: GetCommonBannerReq) -> GetCommonBannerResp:
        """
        获取 banner 信息 1-评论区小黄条 5-漫画详情页 banner，v2.14 之前的版本 6-月票榜 banner 7-应援
        banner 13-单话末尾专栏 14-月票动画
        """
        logging.getLogger(__name__).info(
            "start call "
            + "[get_common_banner]"
            + " api"
            + "=>"
            + """
        获取 banner 信息 1-评论区小黄条 5-漫画详情页 banner，v2.14 之前的版本 6-月票榜 banner 7-应援
        banner 13-单话末尾专栏 14-月票动画
        """
        )
        response = GetCommonBannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetCommonBanner", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_common_banner]" + " api success!"
        )
        return response

    @allure.step("""批量获取 banner 信息 5-漫画详情页 banner，v2.14 之后的版本""")
    def list_common_banner(self, request: GetCommonBannerReq) -> ListCommonBannerResp:
        """批量获取 banner 信息 5-漫画详情页 banner，v2.14 之后的版本"""
        logging.getLogger(__name__).info(
            "start call "
            + "[list_common_banner]"
            + " api"
            + "=>"
            + """批量获取 banner 信息 5-漫画详情页 banner，v2.14 之后的版本"""
        )
        response = ListCommonBannerResp()
        self._do_twirp_rpc("/comic.v1.Comic/ListCommonBanner", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_common_banner]" + " api success!"
        )
        return response

    @allure.step("""获取渠道合作策略""")
    def get_channel_strategy(
        self, request: GetChannelStrategyReq
    ) -> GetChannelStrategyResp:
        """获取渠道合作策略"""
        logging.getLogger(__name__).info(
            "start call " + "[get_channel_strategy]" + " api" + "=>" + """获取渠道合作策略"""
        )
        response = GetChannelStrategyResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetChannelStrategy", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_channel_strategy]" + " api success!"
        )
        return response

    @allure.step("""沉浸式阅读推荐""")
    def immersive_recommend(
        self, request: ImmersiveRecommendReq
    ) -> ImmersiveRecommendResp:
        """沉浸式阅读推荐"""
        logging.getLogger(__name__).info(
            "start call " + "[immersive_recommend]" + " api" + "=>" + """沉浸式阅读推荐"""
        )
        response = ImmersiveRecommendResp()
        self._do_twirp_rpc("/comic.v1.Comic/ImmersiveRecommend", request, response)
        logging.getLogger(__name__).info(
            "call " + "[immersive_recommend]" + " api success!"
        )
        return response

    @allure.step("""章节点赞 0 表示成功 1 表示操作失败""")
    def like_episode(self, request: LikeEpisodeReq) -> DefaultResponse:
        """章节点赞 0 表示成功 1 表示操作失败"""
        logging.getLogger(__name__).info(
            "start call "
            + "[like_episode]"
            + " api"
            + "=>"
            + """章节点赞 0 表示成功 1 表示操作失败"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/comic.v1.Comic/LikeEpisode", request, response)
        logging.getLogger(__name__).info("call " + "[like_episode]" + " api success!")
        return response

    @allure.step("""查询章节点赞状态""")
    def get_episode_like_state(
        self, request: EpisodeLikeStateReq
    ) -> EpisodeLikeStateResp:
        """查询章节点赞状态"""
        logging.getLogger(__name__).info(
            "start call " + "[get_episode_like_state]" + " api" + "=>" + """查询章节点赞状态"""
        )
        response = EpisodeLikeStateResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetEpisodeLikeState", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_episode_like_state]" + " api success!"
        )
        return response

    @allure.step("""首页二级跳转""")
    def home_secondary_jump(
        self, request: HomeSecondaryJumpReq
    ) -> HomeSecondaryJumpResp:
        """首页二级跳转"""
        logging.getLogger(__name__).info(
            "start call " + "[home_secondary_jump]" + " api" + "=>" + """首页二级跳转"""
        )
        response = HomeSecondaryJumpResp()
        self._do_twirp_rpc("/comic.v1.Comic/HomeSecondaryJump", request, response)
        logging.getLogger(__name__).info(
            "call " + "[home_secondary_jump]" + " api success!"
        )
        return response

    @allure.step("""上报 image/index 错误""")
    def image_index_error(self, request: ImageIndexErrorReq) -> DefaultResponse:
        """上报 image/index 错误"""
        logging.getLogger(__name__).info(
            "start call "
            + "[image_index_error]"
            + " api"
            + "=>"
            + """上报 image/index 错误"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/comic.v1.Comic/ImageIndexError", request, response)
        logging.getLogger(__name__).info(
            "call " + "[image_index_error]" + " api success!"
        )
        return response

    @allure.step("""获取特典信息 2.12以后开始废弃 参见: GetComicAlbumPlus""")
    def get_comic_album(self, request: GetComicAlbumReq) -> GetComicAlbumResp:
        """获取特典信息 2.12以后开始废弃 参见: GetComicAlbumPlus"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_comic_album]"
            + " api"
            + "=>"
            + """获取特典信息 2.12以后开始废弃 参见: GetComicAlbumPlus"""
        )
        response = GetComicAlbumResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetComicAlbum", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_album]" + " api success!"
        )
        return response

    @allure.step("""解锁特典""")
    def unlock_comic_album(self, request: UnlockComicAlbumReq) -> DefaultResponse:
        """解锁特典"""
        logging.getLogger(__name__).info(
            "start call " + "[unlock_comic_album]" + " api" + "=>" + """解锁特典"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/comic.v1.Comic/UnlockComicAlbum", request, response)
        logging.getLogger(__name__).info(
            "call " + "[unlock_comic_album]" + " api success!"
        )
        return response

    @allure.step("""获取特典内容""")
    def access_comic_album(self, request: AccessComicAlbumReq) -> AccessComicAlbumResp:
        """获取特典内容"""
        logging.getLogger(__name__).info(
            "start call " + "[access_comic_album]" + " api" + "=>" + """获取特典内容"""
        )
        response = AccessComicAlbumResp()
        self._do_twirp_rpc("/comic.v1.Comic/AccessComicAlbum", request, response)
        logging.getLogger(__name__).info(
            "call " + "[access_comic_album]" + " api success!"
        )
        return response

    @allure.step("""用户分享特典""")
    def share_comic_album(self, request: ShareComicAlbumReq) -> ShareComicAlbumResp:
        """用户分享特典"""
        logging.getLogger(__name__).info(
            "start call " + "[share_comic_album]" + " api" + "=>" + """用户分享特典"""
        )
        response = ShareComicAlbumResp()
        self._do_twirp_rpc("/comic.v1.Comic/ShareComicAlbum", request, response)
        logging.getLogger(__name__).info(
            "call " + "[share_comic_album]" + " api success!"
        )
        return response

    @allure.step("""搜索动画""")
    def search_display(self, request: EmptyRequest) -> SearchDisplayResp:
        """搜索动画"""
        logging.getLogger(__name__).info(
            "start call " + "[search_display]" + " api" + "=>" + """搜索动画"""
        )
        response = SearchDisplayResp()
        self._do_twirp_rpc("/comic.v1.Comic/SearchDisplay", request, response)
        logging.getLogger(__name__).info("call " + "[search_display]" + " api success!")
        return response

    @allure.step("""获取特典信息""")
    def get_comic_album_plus(self, request: GetComicAlbumReq) -> GetComicAlbumPlusResp:
        """获取特典信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_album_plus]" + " api" + "=>" + """获取特典信息"""
        )
        response = GetComicAlbumPlusResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetComicAlbumPlus", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_album_plus]" + " api success!"
        )
        return response

    @allure.step("""获取 AB test 结果""")
    def get_a_b_flags(self, request: GetABFlagReq) -> GetABFlagResp:
        """获取 AB test 结果"""
        logging.getLogger(__name__).info(
            "start call " + "[get_a_b_flags]" + " api" + "=>" + """获取 AB test 结果"""
        )
        response = GetABFlagResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetABFlags", request, response)
        logging.getLogger(__name__).info("call " + "[get_a_b_flags]" + " api success!")
        return response

    @allure.step("""获取对应漫画可用的打折卡列表""")
    def get_discount_list(self, request: GetDiscountListReq) -> GetDiscountListResp:
        """获取对应漫画可用的打折卡列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_discount_list]" + " api" + "=>" + """获取对应漫画可用的打折卡列表"""
        )
        response = GetDiscountListResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetDiscountList", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_discount_list]" + " api success!"
        )
        return response

    @allure.step("""计算打折卡折后价格""")
    def cal_discount_price(self, request: CalDiscountPriceReq) -> CalDiscountPriceResp:
        """计算打折卡折后价格"""
        logging.getLogger(__name__).info(
            "start call " + "[cal_discount_price]" + " api" + "=>" + """计算打折卡折后价格"""
        )
        response = CalDiscountPriceResp()
        self._do_twirp_rpc("/comic.v1.Comic/CalDiscountPrice", request, response)
        logging.getLogger(__name__).info(
            "call " + "[cal_discount_price]" + " api success!"
        )
        return response

    @allure.step("""获取漫画基础信息""")
    def get_comic(self, request: GetComicReq) -> GetComicResp:
        """获取漫画基础信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic]" + " api" + "=>" + """获取漫画基础信息"""
        )
        response = GetComicResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetComic", request, response)
        logging.getLogger(__name__).info("call " + "[get_comic]" + " api success!")
        return response

    @allure.step("""新人 tab 礼包""")
    def get_class_page_gift(self, request: EmptyRequest) -> GetClassPageGiftResp:
        """新人 tab 礼包"""
        logging.getLogger(__name__).info(
            "start call " + "[get_class_page_gift]" + " api" + "=>" + """新人 tab 礼包"""
        )
        response = GetClassPageGiftResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageGift", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_gift]" + " api success!"
        )
        return response

    @allure.step("""新人 tab 番推漫""")
    def get_class_page_anime(
        self, request: GetClassPageAnimeReq
    ) -> GetClassPageAnimeResp:
        """新人 tab 番推漫"""
        logging.getLogger(__name__).info(
            "start call " + "[get_class_page_anime]" + " api" + "=>" + """新人 tab 番推漫"""
        )
        response = GetClassPageAnimeResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetClassPageAnime", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_class_page_anime]" + " api success!"
        )
        return response

    @allure.step("""换取口令""")
    def get_token(self, request: GetTokenReq) -> GetTokenResp:
        """换取口令"""
        logging.getLogger(__name__).info(
            "start call " + "[get_token]" + " api" + "=>" + """换取口令"""
        )
        response = GetTokenResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetToken", request, response)
        logging.getLogger(__name__).info("call " + "[get_token]" + " api success!")
        return response

    @allure.step("""口令解析""")
    def parse_token(self, request: ParseTokenReq) -> ParseTokenResp:
        """口令解析"""
        logging.getLogger(__name__).info(
            "start call " + "[parse_token]" + " api" + "=>" + """口令解析"""
        )
        response = ParseTokenResp()
        self._do_twirp_rpc("/comic.v1.Comic/ParseToken", request, response)
        logging.getLogger(__name__).info("call " + "[parse_token]" + " api success!")
        return response

    @allure.step("""获取榜单列表""")
    def list_rank(self, request: EmptyRequest) -> ListRankResp:
        """获取榜单列表"""
        logging.getLogger(__name__).info(
            "start call " + "[list_rank]" + " api" + "=>" + """获取榜单列表"""
        )
        response = ListRankResp()
        self._do_twirp_rpc("/comic.v1.Comic/ListRank", request, response)
        logging.getLogger(__name__).info("call " + "[list_rank]" + " api success!")
        return response

    @allure.step("""获取榜单信息""")
    def get_rank_info(self, request: GetRankInfoReq) -> GetRankInfoResp:
        """获取榜单信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_rank_info]" + " api" + "=>" + """获取榜单信息"""
        )
        response = GetRankInfoResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRankInfo", request, response)
        logging.getLogger(__name__).info("call " + "[get_rank_info]" + " api success!")
        return response

    @allure.step("""获取新人限免漫画""")
    def get_rookie_free_comics(self, request: EmptyRequest) -> GetRookieFreeComicsResp:
        """获取新人限免漫画"""
        logging.getLogger(__name__).info(
            "start call " + "[get_rookie_free_comics]" + " api" + "=>" + """获取新人限免漫画"""
        )
        response = GetRookieFreeComicsResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetRookieFreeComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_rookie_free_comics]" + " api success!"
        )
        return response

    @allure.step("""获取 ios 小部件 内容""")
    def get_widgets_comic(self, request: EmptyRequest) -> GetWidgetsComicResp:
        """获取 ios 小部件 内容"""
        logging.getLogger(__name__).info(
            "start call " + "[get_widgets_comic]" + " api" + "=>" + """获取 ios 小部件 内容"""
        )
        response = GetWidgetsComicResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetWidgetsComic", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_widgets_comic]" + " api success!"
        )
        return response

    @allure.step("""获取 ios 小部件 日历/高能单话""")
    def get_widgets_calendar(self, request: EmptyRequest) -> GetWidgetsCalendarResp:
        """获取 ios 小部件 日历/高能单话"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_widgets_calendar]"
            + " api"
            + "=>"
            + """获取 ios 小部件 日历/高能单话"""
        )
        response = GetWidgetsCalendarResp()
        self._do_twirp_rpc("/comic.v1.Comic/GetWidgetsCalendar", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_widgets_calendar]" + " api success!"
        )
        return response

    @allure.step("""发弹幕 @auth""")
    def send_danmaku(self, request: SendDanmakuReq) -> SendDanmakuResp:
        """发弹幕 @auth"""
        logging.getLogger(__name__).info(
            "start call " + "[send_danmaku]" + " api" + "=>" + """发弹幕 @auth"""
        )
        response = SendDanmakuResp()
        self._do_twirp_rpc("/comic.v1.Comic/SendDanmaku", request, response)
        logging.getLogger(__name__).info("call " + "[send_danmaku]" + " api success!")
        return response
