# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: card/v1/card.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class GetMonthGiftReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class CardDefaultResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: str = betterproto.string_field(3)


@dataclass
class ListMonthGiftResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListMonthGiftData" = betterproto.message_field(3)


@dataclass
class ListMonthGiftData(betterproto.Message):
    gifts: List["MonthGift"] = betterproto.message_field(1)


@dataclass
class MonthGift(betterproto.Message):
    name: str = betterproto.string_field(1)
    icon: str = betterproto.string_field(2)
    # 是否当前可用
    is_valid: bool = betterproto.bool_field(3)
    # 1 卡券 2 挂件 3 积分
    type: int = betterproto.int32_field(4)
    # 数量
    amount: int = betterproto.int32_field(5)
    # 是否领取
    is_got: bool = betterproto.bool_field(6)
    # 卡券类型 通用券类型 TypeCommon int32 = 1 (漫画)专属券类型 TypeComic int32 = 2 (漫画)限免卡类型
    # TypeRentComic int32 = 3 (漫画)优惠卡类型 TypeDiscountCard int32 = 4 (漫画)全场限免卡
    # TypeGlobalRentComic int32 = 5 (漫画)全场优惠卡 TypeGlobalDiscountCard int32 = 6
    # 全场福利券 TypeWelfareCoupon = 7
    coupon_type: int = betterproto.int32_field(7)
    # 卡券过期时间
    coupon_end_date: str = betterproto.string_field(8)
    title: str = betterproto.string_field(9)
    # 描述
    desc: str = betterproto.string_field(10)
    # 按钮文字
    btn_txt: str = betterproto.string_field(11)
    jump_url: str = betterproto.string_field(12)
    # 领取类型 1 领取型 2 跳转型
    receive_type: int = betterproto.int32_field(13)
    id: int = betterproto.int64_field(14)


@dataclass
class ListCardSetsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardSetsData" = betterproto.message_field(3)


@dataclass
class ListCardSetsData(betterproto.Message):
    # 档位组ID
    group_id: int = betterproto.int32_field(1)
    list: List["CardSet"] = betterproto.message_field(2)
    # true 展示新页面
    show_new_page: bool = betterproto.bool_field(3)


@dataclass
class ChildCardSet(betterproto.Message):
    # ID(该关联档位的ID, 但客户端基本用不着)
    id: int = betterproto.int32_field(1)
    # 实际价格
    gold: int = betterproto.int32_field(2)
    # 档位类型: 10-7日卡 (客户端走白名单机制，不识别的card_type请不要展示)
    card_type: int = betterproto.int32_field(3)
    # 档位名称 (客户端走白名单机制，不识别的card_type请不要展示)
    card_name: str = betterproto.string_field(4)
    # 总发放数量
    total_amount: int = betterproto.int32_field(5)
    # 角标文案
    icon_txt: str = betterproto.string_field(6)
    # 宣传文案
    ad_txt: str = betterproto.string_field(7)


@dataclass
class CardSet(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)
    # 实际价格
    gold: int = betterproto.int32_field(2)
    # 原价格
    origin_gold: int = betterproto.int32_field(3)
    # 档位类型: 1-月卡  2-季卡  3-年卡  4-连续月卡 5-连续季卡 6-连续年卡 (客户端走白名单机制，不识别的type请不要展示)
    card_type: int = betterproto.int32_field(4)
    # 角标文案
    icon_txt: str = betterproto.string_field(5)
    # 宣传文案
    ad_txt: str = betterproto.string_field(6)
    # 增发数量
    extra_amount: int = betterproto.int32_field(7)
    # 总发放数量
    total_amount: int = betterproto.int32_field(8)
    # 首购优惠价格(分) 为0代表没有优惠
    discount_first_gold: int = betterproto.int32_field(9)
    # 优惠开始时间2006-01-02 15:04:05
    discount_start_time: str = betterproto.string_field(10)
    # 优惠结束时间2006-01-02 15:04:05
    discount_end_time: str = betterproto.string_field(11)
    # 是否首次购买(3.7变为是否有首购奖励)
    is_first: bool = betterproto.bool_field(12)
    # 每月发放数量
    month_amount: int = betterproto.int32_field(13)
    # iOS 内购标识
    product_id: str = betterproto.string_field(14)
    # 首次付费档位, null代表没有
    first_card_set: "ChildCardSet" = betterproto.message_field(15)


@dataclass
class CardOrdersResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CardOrderRespData" = betterproto.message_field(3)


@dataclass
class CardOrderRespData(betterproto.Message):
    orders: List["CardOrder"] = betterproto.message_field(1)


@dataclass
class CardOrder(betterproto.Message):
    # 类型
    card_type: int = betterproto.int32_field(1)
    # 金额
    pay_amount: int = betterproto.int32_field(2)
    # 支付方式
    pay_method: str = betterproto.string_field(3)
    # 2016.01.02 15:04
    pay_time: str = betterproto.string_field(4)
    # 2016.01.02-2016.01.02
    expire_time: str = betterproto.string_field(5)
    title: str = betterproto.string_field(6)
    # 1 支付成功 3 退款
    pay_status: int = betterproto.int32_field(7)


@dataclass
class ListCardPlanReq(betterproto.Message):
    # 0 未发放 2 已发放
    type: int = betterproto.int32_field(1)
    # 从 1 开始
    page_num: int = betterproto.int32_field(2)
    page_size: int = betterproto.int32_field(3)


@dataclass
class ListCardPlanResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardData" = betterproto.message_field(3)


@dataclass
class ListCardData(betterproto.Message):
    plans: List["CardPlan"] = betterproto.message_field(1)


@dataclass
class CardPlan(betterproto.Message):
    # title
    title: str = betterproto.string_field(1)
    subtitle: str = betterproto.string_field(2)
    # 2016.01.02
    ctime: str = betterproto.string_field(3)
    # 2016.01.02
    expire_time: str = betterproto.string_field(4)
    # 发放数量
    amount: int = betterproto.int32_field(5)
    # 发放时间
    send_time: str = betterproto.string_field(6)
    # 额外赠送数量
    extra_amount: int = betterproto.int32_field(7)
    # 通用券文案说明
    description: str = betterproto.string_field(8)


@dataclass
class UserCardInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserCardData" = betterproto.message_field(3)


@dataclass
class UserCardData(betterproto.Message):
    # 头像
    face: str = betterproto.string_field(1)
    # 用户名
    name: str = betterproto.string_field(2)
    # 有效期 2006/01/02
    expire_time: str = betterproto.string_field(3)
    # 节省漫币
    save_coin: int = betterproto.int32_field(4)
    # 漫读卡种类名称
    card_title: str = betterproto.string_field(5)
    # 已发放
    sent: int = betterproto.int32_field(6)
    # 待发放
    unsend: int = betterproto.int32_field(7)
    # 是否即将过期
    is_expire_soon: bool = betterproto.bool_field(8)
    # 当前用户使用的漫读卡种类
    type: int = betterproto.int32_field(9)
    # 开通状态 0 从未开通 1 已开通 2 已过期
    state: int = betterproto.int32_field(10)
    # 推荐语
    recommendation: str = betterproto.string_field(11)
    # 六图卡片id
    six_module_id: int = betterproto.int32_field(12)
    # 六图 title
    six_module_name: str = betterproto.string_field(13)
    # 下次续费时间 2006.01.02
    next_pay_time: str = betterproto.string_field(14)
    # 1 alipay 2 wechat 3 iap 4 花呗 5 QQ
    pay_channel: int = betterproto.int32_field(15)
    # 签约状态 0 未签约 1 已签约
    sign_state: int = betterproto.int32_field(16)
    # 封面 ID
    cover_id: int = betterproto.int32_field(17)
    # 剩余 silver 数量
    remain_amount: int = betterproto.int32_field(18)
    # silver 过期时间
    silver_expire_time: str = betterproto.string_field(19)
    # 当前订阅卡的信息
    sub_card_info: "CardInfo" = betterproto.message_field(20)
    # 是否有新卡面提醒
    new_cover: bool = betterproto.bool_field(21)
    # 是否是体验卡
    is_trial: bool = betterproto.bool_field(22)
    # 资源投放 banner
    resource_banner: "CardResourceBanner" = betterproto.message_field(23)


@dataclass
class CardResourceBanner(betterproto.Message):
    img: str = betterproto.string_field(1)
    url: str = betterproto.string_field(2)


@dataclass
class CardInfo(betterproto.Message):
    # 当前订阅卡的支付金额
    pay_amount: int = betterproto.int32_field(20)
    # 当前订阅卡的原价
    orginal_amount: int = betterproto.int32_field(21)
    # 卡类型 1 "月度畅读卡", 2 "季度畅读卡", 3 "年度畅读卡", 4 "畅读卡连续包月", 5 "畅读卡连续包季", 6 "畅读卡连续包年",
    # 7 "月度畅读卡", 8 "季度畅读卡", 9 "年度畅读卡", 10 "7日畅读卡", 11 "7日畅读卡",
    type: int = betterproto.int32_field(22)


@dataclass
class CardCoverResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CardCoverData" = betterproto.message_field(3)


@dataclass
class CardCoverData(betterproto.Message):
    card_covers: List["CardCover"] = betterproto.message_field(1)


@dataclass
class CardCover(betterproto.Message):
    # 封面 ID
    id: int = betterproto.int32_field(1)
    # uri 资源
    uri: str = betterproto.string_field(2)
    # 标题
    title: str = betterproto.string_field(3)
    # 封面
    cover: str = betterproto.string_field(4)
    # 版本
    version: int = betterproto.int32_field(5)
    # 背景渐变色
    gradient_color_top: str = betterproto.string_field(6)
    gradient_color_bottom: str = betterproto.string_field(7)


class CardStub(betterproto.ServiceStub):
    """Card 服务"""

    @allure.step("""列出漫读卡档位""")
    def list_card_sets(self, request: EmptyData) -> ListCardSetsResp:
        """列出漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_sets]" + " api" + "=>" + """列出漫读卡档位"""
        )
        response = ListCardSetsResp()
        self._do_twirp_rpc("/card.v1.Card/ListCardSets", request, response)
        logging.getLogger(__name__).info("call " + "[list_card_sets]" + " api success!")
        return response

    @allure.step("""查询漫读卡的购买记录""")
    def get_card_orders(self, request: EmptyData) -> CardOrdersResp:
        """查询漫读卡的购买记录"""
        logging.getLogger(__name__).info(
            "start call " + "[get_card_orders]" + " api" + "=>" + """查询漫读卡的购买记录"""
        )
        response = CardOrdersResp()
        self._do_twirp_rpc("/card.v1.Card/GetCardOrders", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_card_orders]" + " api success!"
        )
        return response

    @allure.step("""获取用户的发放计划/记录""")
    def list_card_plan(self, request: ListCardPlanReq) -> ListCardPlanResp:
        """获取用户的发放计划/记录"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_plan]" + " api" + "=>" + """获取用户的发放计划/记录"""
        )
        response = ListCardPlanResp()
        self._do_twirp_rpc("/card.v1.Card/ListCardPlan", request, response)
        logging.getLogger(__name__).info("call " + "[list_card_plan]" + " api success!")
        return response

    @allure.step("""用户的漫读卡信息""")
    def get_user_card_info(self, request: EmptyData) -> UserCardInfoResp:
        """用户的漫读卡信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_user_card_info]" + " api" + "=>" + """用户的漫读卡信息"""
        )
        response = UserCardInfoResp()
        self._do_twirp_rpc("/card.v1.Card/GetUserCardInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_user_card_info]" + " api success!"
        )
        return response

    @allure.step("""卡面列表""")
    def get_card_covers(self, request: EmptyData) -> CardCoverResp:
        """卡面列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_card_covers]" + " api" + "=>" + """卡面列表"""
        )
        response = CardCoverResp()
        self._do_twirp_rpc("/card.v1.Card/GetCardCovers", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_card_covers]" + " api success!"
        )
        return response

    @allure.step("""卡面列表""")
    def get_card_covers_v2(self, request: EmptyData) -> CardCoverResp:
        """卡面列表"""
        logging.getLogger(__name__).info(
            "start call " + "[get_card_covers_v2]" + " api" + "=>" + """卡面列表"""
        )
        response = CardCoverResp()
        self._do_twirp_rpc("/card.v1.Card/GetCardCoversV2", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_card_covers_v2]" + " api success!"
        )
        return response

    @allure.step("""领取畅读卡每月限定礼""")
    def get_month_gift(self, request: GetMonthGiftReq) -> CardDefaultResp:
        """领取畅读卡每月限定礼"""
        logging.getLogger(__name__).info(
            "start call " + "[get_month_gift]" + " api" + "=>" + """领取畅读卡每月限定礼"""
        )
        response = CardDefaultResp()
        self._do_twirp_rpc("/card.v1.Card/GetMonthGift", request, response)
        logging.getLogger(__name__).info("call " + "[get_month_gift]" + " api success!")
        return response

    @allure.step("""限定礼""")
    def list_month_gift(self, request: EmptyData) -> ListMonthGiftResp:
        """限定礼"""
        logging.getLogger(__name__).info(
            "start call " + "[list_month_gift]" + " api" + "=>" + """限定礼"""
        )
        response = ListMonthGiftResp()
        self._do_twirp_rpc("/card.v1.Card/ListMonthGift", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_month_gift]" + " api success!"
        )
        return response
