# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: card/v0/card.proto
# plugin: python-betterproto
import logging
from typing import Dict, List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class DefaultResponseWithIDResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DataWithID" = betterproto.message_field(3)


@dataclass
class DataWithID(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class DefaultPaginateReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 每页数量
    page_size: int = betterproto.int32_field(2)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class ListCardSetsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardSetsData" = betterproto.message_field(3)


@dataclass
class ListCardSetsData(betterproto.Message):
    total_count: int = betterproto.int32_field(1)
    list: List["CardSet"] = betterproto.message_field(2)


@dataclass
class ListCardSetGroupsReq(betterproto.Message):
    # 页码 @gt:0
    page_num: int = betterproto.int32_field(1)
    # 每页数量 @gt:0
    page_size: int = betterproto.int32_field(2)
    # 平台 0-双端 1-ios 2-安卓 @in:[0,1,2]
    platform: int = betterproto.int32_field(3)


@dataclass
class ListCardSetGroupsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardSetGroupsData" = betterproto.message_field(3)


@dataclass
class ListCardSetGroupsData(betterproto.Message):
    total_count: int = betterproto.int32_field(1)
    list: List["CardSetGroup"] = betterproto.message_field(2)


@dataclass
class CardSetGroup(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 档位ID
    card_set_ids: List[int] = betterproto.int32_field(3)
    # 推送类型 1.全局 2.人群包
    push_type: int = betterproto.int32_field(4)
    # 人群包ID
    user_group_ids: List[int] = betterproto.int32_field(5)
    # 权重
    weight: int = betterproto.int32_field(6)
    # 开始时间 2006-01-02 15:04:05
    start_time: str = betterproto.string_field(7)
    # 结束时间 2006-01-02 15:04:05(保持上线:1970-01-01 08:01:00)
    end_time: str = betterproto.string_field(8)
    # 操作人(创建/编辑时不传)
    cuser: str = betterproto.string_field(9)
    # 创建时间(创建/编辑时不传)
    ctime: str = betterproto.string_field(10)
    # 修改时间(创建/编辑时不传)
    mtime: str = betterproto.string_field(11)
    # 上下线状态 1-上线 2-下线 3-待上线(创建/编辑时不传)
    status: int = betterproto.int32_field(12)
    # 平台 0-双端 1-ios 2-安卓 @in:[0,1,2]
    platform: int = betterproto.int32_field(13)


@dataclass
class CardSet(betterproto.Message):
    # ID(创建时不传)
    id: int = betterproto.int32_field(1)
    # 名称
    title: str = betterproto.string_field(2)
    # 实际价格(分)
    gold: int = betterproto.int32_field(3)
    # 虚拟、原价格(分)
    origin_gold: int = betterproto.int32_field(4)
    # 档位类型:  1-月卡  2-季卡  3-年卡  4-连续月卡  5-连续季卡 6-连续年卡 7-赠送月卡  8-赠送季卡 9-赠送连续年卡
    # 10-7日卡 11-赠送7日卡
    card_type: int = betterproto.int32_field(5)
    # 角标文案
    icon_txt: str = betterproto.string_field(6)
    # 宣传文案
    ad_txt: str = betterproto.string_field(7)
    # 增发数量
    extra_amount: int = betterproto.int32_field(8)
    # 操作人(创建/编辑时不传)
    cuser: str = betterproto.string_field(9)
    # 创建时间(创建/编辑时不传)
    ctime: str = betterproto.string_field(10)
    # 修改时间(创建/编辑时不传)
    mtime: str = betterproto.string_field(11)
    # 首购优惠价格(分), 没有则传0
    discount_first_gold: int = betterproto.int32_field(12)
    # 优惠开始时间2006-01-02 15:04:05, 没有则不传或者传空字符串
    discount_start_time: str = betterproto.string_field(13)
    # 优惠结束时间2006-01-02 15:04:05, 没有或者保持上线则不传或者传空字符串
    discount_end_time: str = betterproto.string_field(14)
    # ios商品ID
    product_id: str = betterproto.string_field(15)
    # 微信模版 id
    plan_id: str = betterproto.string_field(16)
    # 首购角标文案
    first_icon_txt: str = betterproto.string_field(17)
    # 首购宣传文案
    first_ad_txt: str = betterproto.string_field(18)
    # 复购赠送额外数量
    second_extra_amount: int = betterproto.int32_field(19)
    # 复购赠送开始时间 (因为原来的接口中时间都是不带时区信息的，这次新加也不带把)
    second_start_time: str = betterproto.string_field(20)
    # 复购赠送结束时间(保持上线传 9999-12-31 23:59:59)
    second_end_time: str = betterproto.string_field(21)
    # 是否开启首周3元周卡
    has_first_week_card: bool = betterproto.bool_field(22)


@dataclass
class DefaultDeleteReq(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)


@dataclass
class UserCardInfoReq(betterproto.Message):
    uids: List[int] = betterproto.int64_field(1)


@dataclass
class UserCardInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserCardData" = betterproto.message_field(3)


@dataclass
class UserCardData(betterproto.Message):
    # 漫读卡等级 key uid value 0 未开通 1 已开通
    card_levels: Dict[int, int] = betterproto.map_field(
        2, betterproto.TYPE_INT64, betterproto.TYPE_INT32
    )


@dataclass
class AddCardCoverReq(betterproto.Message):
    # 新增不传 id，编辑带 id
    id: int = betterproto.int32_field(1)
    # 卡面名称
    title: str = betterproto.string_field(2)
    # 卡面封面
    cover: str = betterproto.string_field(3)
    resource: str = betterproto.string_field(4)
    # 卡片获取方式 0-开卡即得 1-定向发放
    type: int = betterproto.int32_field(5)
    # time.RFC3339 格式，带时区信息
    start_time: str = betterproto.string_field(6)
    # time.RFC3339 格式，带时区信息,保持上线(1970-01-01T08:01:00Z)
    end_time: str = betterproto.string_field(7)
    # 操作人，仅列表展示时使用
    cuser: str = betterproto.string_field(8)
    # time.RFC3339 格式，带时区信息，仅列表展示时使用
    mtime: str = betterproto.string_field(9)
    # 资源版本 0 默认 1 包含 mp4
    uri_type: int = betterproto.int32_field(10)
    # 封面渐变色
    gradient_color_top: str = betterproto.string_field(11)
    gradient_color_bottom: str = betterproto.string_field(12)
    # 版本 1 起始版本 2 资源数据结构发生变更
    version: int = betterproto.int32_field(13)


@dataclass
class DelCardCoverReq(betterproto.Message):
    id: int = betterproto.int32_field(1)


@dataclass
class ListCardCoversReq(betterproto.Message):
    page_num: int = betterproto.int32_field(1)
    page_size: int = betterproto.int32_field(2)
    # 版本 1 起始版本 2 资源数据结构发生变更
    version: int = betterproto.int32_field(3)


@dataclass
class ListCardCoversResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardCovers" = betterproto.message_field(3)


@dataclass
class ListCardCovers(betterproto.Message):
    # 总卡面数量
    total: int = betterproto.int32_field(1)
    cards: List["AddCardCoverReq"] = betterproto.message_field(2)


@dataclass
class AddSendPlanReq(betterproto.Message):
    # 新增的时候不传值或者传0
    id: int = betterproto.int32_field(1)
    # 发放说明
    description: str = betterproto.string_field(2)
    # 档位 id / 卡面 id，档位中的主键 id
    product_id: int = betterproto.int32_field(3)
    # 指定少数人 uid 发送
    uids: List[int] = betterproto.int64_field(4)
    # csv 文件
    csv: str = betterproto.string_field(5)
    # 操作人 仅列表查询时使用
    cuser: str = betterproto.string_field(6)
    # 创建时间，时间格式 time.RFC3339, 带时区信息
    ctime: str = betterproto.string_field(7)
    # 2-卡面发方 3-畅读卡发放 5-发放通用券
    type: int = betterproto.int32_field(8)
    # 发放状态，仅列表展示时使用 0-未开始发放 1-发放中 2-发放成功 3-发放失败
    status: int = betterproto.int32_field(9)
    # 当发放产品是畅读卡时，这里显示的是畅读卡类型 7-免费月卡 8-免费季卡 9-免费年卡
    product_type: int = betterproto.int32_field(10)
    # 发放数量
    amount: int = betterproto.int32_field(11)
    # 发放内容,当类型是 5 时，该内容会展示到客户端上
    content: str = betterproto.string_field(12)


@dataclass
class ListSendPlansReq(betterproto.Message):
    # 2-卡面发放 3-畅读卡发放
    type: int = betterproto.int32_field(1)
    page_num: int = betterproto.int32_field(2)
    page_size: int = betterproto.int32_field(3)


@dataclass
class ListSendPlansResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListSendPlans" = betterproto.message_field(3)


@dataclass
class ListSendPlans(betterproto.Message):
    # 总的发放数量
    total: int = betterproto.int32_field(1)
    plan: List["AddSendPlanReq"] = betterproto.message_field(2)


class CardStub(betterproto.ServiceStub):
    """Card 服务"""

    @allure.step("""添加漫读卡档位""")
    def add_card_set(self, request: CardSet) -> DefaultResponse:
        """添加漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[add_card_set]" + " api" + "=>" + """添加漫读卡档位"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/AddCardSet", request, response)
        logging.getLogger(__name__).info("call " + "[add_card_set]" + " api success!")
        return response

    @allure.step("""列出漫读卡档位""")
    def list_card_sets(self, request: DefaultPaginateReq) -> ListCardSetsResp:
        """列出漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_sets]" + " api" + "=>" + """列出漫读卡档位"""
        )
        response = ListCardSetsResp()
        self._do_twirp_rpc("/card.v0.Card/ListCardSets", request, response)
        logging.getLogger(__name__).info("call " + "[list_card_sets]" + " api success!")
        return response

    @allure.step("""编辑漫读卡档位""")
    def edit_card_set(self, request: CardSet) -> DefaultResponse:
        """编辑漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_card_set]" + " api" + "=>" + """编辑漫读卡档位"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/EditCardSet", request, response)
        logging.getLogger(__name__).info("call " + "[edit_card_set]" + " api success!")
        return response

    @allure.step("""添加漫读卡档位组""")
    def add_card_set_group(self, request: CardSetGroup) -> DefaultResponse:
        """添加漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[add_card_set_group]" + " api" + "=>" + """添加漫读卡档位组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/AddCardSetGroup", request, response)
        logging.getLogger(__name__).info(
            "call " + "[add_card_set_group]" + " api success!"
        )
        return response

    @allure.step("""列出漫读卡档位组""")
    def list_card_set_groups(
        self, request: ListCardSetGroupsReq
    ) -> ListCardSetGroupsResp:
        """列出漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_set_groups]" + " api" + "=>" + """列出漫读卡档位组"""
        )
        response = ListCardSetGroupsResp()
        self._do_twirp_rpc("/card.v0.Card/ListCardSetGroups", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_card_set_groups]" + " api success!"
        )
        return response

    @allure.step("""编辑漫读卡档位组""")
    def edit_card_set_group(self, request: CardSetGroup) -> DefaultResponse:
        """编辑漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_card_set_group]" + " api" + "=>" + """编辑漫读卡档位组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/EditCardSetGroup", request, response)
        logging.getLogger(__name__).info(
            "call " + "[edit_card_set_group]" + " api success!"
        )
        return response

    @allure.step("""删除漫读卡档位组""")
    def delete_card_set_group(self, request: DefaultDeleteReq) -> DefaultResponse:
        """删除漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[delete_card_set_group]" + " api" + "=>" + """删除漫读卡档位组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/DeleteCardSetGroup", request, response)
        logging.getLogger(__name__).info(
            "call " + "[delete_card_set_group]" + " api success!"
        )
        return response

    @allure.step("""查询用户开通畅读卡信息""")
    def get_user_card_info(self, request: UserCardInfoReq) -> UserCardInfoResp:
        """查询用户开通畅读卡信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_user_card_info]" + " api" + "=>" + """查询用户开通畅读卡信息"""
        )
        response = UserCardInfoResp()
        self._do_twirp_rpc("/card.v0.Card/GetUserCardInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_user_card_info]" + " api success!"
        )
        return response

    @allure.step("""添加卡面""")
    def add_card_cover(self, request: AddCardCoverReq) -> DefaultResponseWithIDResp:
        """添加卡面"""
        logging.getLogger(__name__).info(
            "start call " + "[add_card_cover]" + " api" + "=>" + """添加卡面"""
        )
        response = DefaultResponseWithIDResp()
        self._do_twirp_rpc("/card.v0.Card/AddCardCover", request, response)
        logging.getLogger(__name__).info("call " + "[add_card_cover]" + " api success!")
        return response

    @allure.step("""编辑卡面""")
    def edit_card_cover(self, request: AddCardCoverReq) -> DefaultResponse:
        """编辑卡面"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_card_cover]" + " api" + "=>" + """编辑卡面"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/EditCardCover", request, response)
        logging.getLogger(__name__).info(
            "call " + "[edit_card_cover]" + " api success!"
        )
        return response

    @allure.step("""删除卡面""")
    def del_card_cover(self, request: DelCardCoverReq) -> DefaultResponse:
        """删除卡面"""
        logging.getLogger(__name__).info(
            "start call " + "[del_card_cover]" + " api" + "=>" + """删除卡面"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/DelCardCover", request, response)
        logging.getLogger(__name__).info("call " + "[del_card_cover]" + " api success!")
        return response

    @allure.step("""卡面列表""")
    def list_card_covers(self, request: ListCardCoversReq) -> ListCardCoversResp:
        """卡面列表"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_covers]" + " api" + "=>" + """卡面列表"""
        )
        response = ListCardCoversResp()
        self._do_twirp_rpc("/card.v0.Card/ListCardCovers", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_card_covers]" + " api success!"
        )
        return response

    @allure.step("""卡面发放/畅读卡发放""")
    def add_send_plan(self, request: AddSendPlanReq) -> DefaultResponseWithIDResp:
        """卡面发放/畅读卡发放"""
        logging.getLogger(__name__).info(
            "start call " + "[add_send_plan]" + " api" + "=>" + """卡面发放/畅读卡发放"""
        )
        response = DefaultResponseWithIDResp()
        self._do_twirp_rpc("/card.v0.Card/AddSendPlan", request, response)
        logging.getLogger(__name__).info("call " + "[add_send_plan]" + " api success!")
        return response

    @allure.step("""卡面/畅读卡发放计划查询""")
    def list_send_plans(self, request: ListSendPlansReq) -> ListSendPlansResp:
        """卡面/畅读卡发放计划查询"""
        logging.getLogger(__name__).info(
            "start call " + "[list_send_plans]" + " api" + "=>" + """卡面/畅读卡发放计划查询"""
        )
        response = ListSendPlansResp()
        self._do_twirp_rpc("/card.v0.Card/ListSendPlans", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_send_plans]" + " api success!"
        )
        return response
